/* ClockEffect.c generated by valac 0.56.18, the Vala compiler
 * generated from ClockEffect.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*               2013 Jens Bav
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "pantheon-photos-transitions.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "io.elementary.photos.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define CLOCK_EFFECT_DESIRED_FPS 25
#define CLOCK_EFFECT_MIN_FPS 15
#define CLOCK_EFFECT_TOP_RADIANT (0.5 * G_PI)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_CLOCK_EFFECT_DESCRIPTOR (clock_effect_descriptor_get_type ())
#define CLOCK_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLOCK_EFFECT_DESCRIPTOR, ClockEffectDescriptor))
#define CLOCK_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLOCK_EFFECT_DESCRIPTOR, ClockEffectDescriptorClass))
#define IS_CLOCK_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLOCK_EFFECT_DESCRIPTOR))
#define IS_CLOCK_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLOCK_EFFECT_DESCRIPTOR))
#define CLOCK_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLOCK_EFFECT_DESCRIPTOR, ClockEffectDescriptorClass))

typedef struct _ClockEffectDescriptor ClockEffectDescriptor;
typedef struct _ClockEffectDescriptorClass ClockEffectDescriptorClass;
typedef struct _ClockEffectDescriptorPrivate ClockEffectDescriptorPrivate;
enum  {
	CLOCK_EFFECT_DESCRIPTOR_0_PROPERTY,
	CLOCK_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* clock_effect_descriptor_properties[CLOCK_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_CLOCK_EFFECT (clock_effect_get_type ())
#define CLOCK_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLOCK_EFFECT, ClockEffect))
#define CLOCK_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLOCK_EFFECT, ClockEffectClass))
#define IS_CLOCK_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLOCK_EFFECT))
#define IS_CLOCK_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLOCK_EFFECT))
#define CLOCK_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLOCK_EFFECT, ClockEffectClass))

typedef struct _ClockEffect ClockEffect;
typedef struct _ClockEffectClass ClockEffectClass;
typedef struct _ClockEffectPrivate ClockEffectPrivate;
enum  {
	CLOCK_EFFECT_0_PROPERTY,
	CLOCK_EFFECT_NUM_PROPERTIES
};
static GParamSpec* clock_effect_properties[CLOCK_EFFECT_NUM_PROPERTIES];

struct _ClockEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	ClockEffectDescriptorPrivate * priv;
};

struct _ClockEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _ClockEffect {
	GObject parent_instance;
	ClockEffectPrivate * priv;
};

struct _ClockEffectClass {
	GObjectClass parent_class;
};

static gpointer clock_effect_descriptor_parent_class = NULL;
static gpointer clock_effect_parent_class = NULL;
static SpitTransitionsEffectIface * clock_effect_spit_transitions_effect_parent_iface = NULL;

VALA_EXTERN GType clock_effect_descriptor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ClockEffectDescriptor* clock_effect_descriptor_new (GFile* resource_directory);
VALA_EXTERN ClockEffectDescriptor* clock_effect_descriptor_construct (GType object_type,
                                                          GFile* resource_directory);
static const gchar* clock_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* clock_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* clock_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                            SpitHostInterface* host);
VALA_EXTERN ClockEffect* clock_effect_new (void);
VALA_EXTERN ClockEffect* clock_effect_construct (GType object_type);
VALA_EXTERN GType clock_effect_get_type (void) G_GNUC_CONST ;
static GType clock_effect_descriptor_get_type_once (void);
static void clock_effect_real_get_fps (SpitTransitionsEffect* base,
                                gint* desired_fps,
                                gint* min_fps);
static void clock_effect_real_start (SpitTransitionsEffect* base,
                              SpitTransitionsVisuals* visuals,
                              SpitTransitionsMotion* motion);
static gboolean clock_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void clock_effect_real_paint (SpitTransitionsEffect* base,
                              SpitTransitionsVisuals* visuals,
                              SpitTransitionsMotion* motion,
                              cairo_t* ctx,
                              gint width,
                              gint height,
                              gint frame_number);
static void clock_effect_real_advance (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion,
                                gint frame_number);
static void clock_effect_real_cancel (SpitTransitionsEffect* base);
static GType clock_effect_get_type_once (void);

ClockEffectDescriptor*
clock_effect_descriptor_construct (GType object_type,
                                   GFile* resource_directory)
{
	ClockEffectDescriptor * self = NULL;
	g_return_val_if_fail (resource_directory != NULL, NULL);
	self = (ClockEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, resource_directory);
	return self;
}

ClockEffectDescriptor*
clock_effect_descriptor_new (GFile* resource_directory)
{
	return clock_effect_descriptor_construct (TYPE_CLOCK_EFFECT_DESCRIPTOR, resource_directory);
}

static const gchar*
clock_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	ClockEffectDescriptor * self;
	const gchar* result;
	self = (ClockEffectDescriptor*) base;
	result = "io.elementary.photos.transitions.clock";
	return result;
}

static const gchar*
clock_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	ClockEffectDescriptor * self;
	const gchar* result;
	self = (ClockEffectDescriptor*) base;
	result = _ ("Clock");
	return result;
}

static SpitTransitionsEffect*
clock_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                     SpitHostInterface* host)
{
	ClockEffectDescriptor * self;
	ClockEffect* _tmp0_;
	SpitTransitionsEffect* result;
	self = (ClockEffectDescriptor*) base;
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = clock_effect_new ();
	result = (SpitTransitionsEffect*) _tmp0_;
	return result;
}

static void
clock_effect_descriptor_class_init (ClockEffectDescriptorClass * klass,
                                    gpointer klass_data)
{
	clock_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor*)) clock_effect_descriptor_real_get_id;
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor*)) clock_effect_descriptor_real_get_pluggable_name;
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor*, SpitHostInterface*)) clock_effect_descriptor_real_create;
}

static void
clock_effect_descriptor_instance_init (ClockEffectDescriptor * self,
                                       gpointer klass)
{
}

static GType
clock_effect_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClockEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clock_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClockEffectDescriptor), 0, (GInstanceInitFunc) clock_effect_descriptor_instance_init, NULL };
	GType clock_effect_descriptor_type_id;
	clock_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "ClockEffectDescriptor", &g_define_type_info, 0);
	return clock_effect_descriptor_type_id;
}

GType
clock_effect_descriptor_get_type (void)
{
	static volatile gsize clock_effect_descriptor_type_id__once = 0;
	if (g_once_init_enter (&clock_effect_descriptor_type_id__once)) {
		GType clock_effect_descriptor_type_id;
		clock_effect_descriptor_type_id = clock_effect_descriptor_get_type_once ();
		g_once_init_leave (&clock_effect_descriptor_type_id__once, clock_effect_descriptor_type_id);
	}
	return clock_effect_descriptor_type_id__once;
}

ClockEffect*
clock_effect_construct (GType object_type)
{
	ClockEffect * self = NULL;
	self = (ClockEffect*) g_object_new (object_type, NULL);
	return self;
}

ClockEffect*
clock_effect_new (void)
{
	return clock_effect_construct (TYPE_CLOCK_EFFECT);
}

static void
clock_effect_real_get_fps (SpitTransitionsEffect* base,
                           gint* desired_fps,
                           gint* min_fps)
{
	ClockEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
	self = (ClockEffect*) base;
	_vala_desired_fps = CLOCK_EFFECT_DESIRED_FPS;
	_vala_min_fps = CLOCK_EFFECT_MIN_FPS;
	if (desired_fps) {
		*desired_fps = _vala_desired_fps;
	}
	if (min_fps) {
		*min_fps = _vala_min_fps;
	}
}

static void
clock_effect_real_start (SpitTransitionsEffect* base,
                         SpitTransitionsVisuals* visuals,
                         SpitTransitionsMotion* motion)
{
	ClockEffect * self;
	self = (ClockEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
}

static gboolean
clock_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	ClockEffect * self;
	gboolean result;
	self = (ClockEffect*) base;
	result = TRUE;
	return result;
}

static void
clock_effect_real_paint (SpitTransitionsEffect* base,
                         SpitTransitionsVisuals* visuals,
                         SpitTransitionsMotion* motion,
                         cairo_t* ctx,
                         gint width,
                         gint height,
                         gint frame_number)
{
	ClockEffect * self;
	gdouble alpha = 0.0;
	gdouble start_angle = 0.0;
	gdouble stop_angle = 0.0;
	SpitTransitionsDirection _tmp0_;
	SpitTransitionsDirection _tmp1_;
	gint radius = 0;
	GdkRectangle _tmp2_ = {0};
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp14_;
	GdkPixbuf* _tmp15_;
	self = (ClockEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
	g_return_if_fail (ctx != NULL);
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
	start_angle = -CLOCK_EFFECT_TOP_RADIANT;
	stop_angle = -CLOCK_EFFECT_TOP_RADIANT;
	_tmp0_ = spit_transitions_motion_get_direction (motion);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == SPIT_TRANSITIONS_DIRECTION_FORWARD) {
		stop_angle = ((alpha * G_PI) * 2) - CLOCK_EFFECT_TOP_RADIANT;
	} else {
		start_angle = ((2 * (1 - alpha)) * G_PI) - CLOCK_EFFECT_TOP_RADIANT;
	}
	spit_transitions_visuals_get_to_pos (visuals, &_tmp2_);
	_tmp3_ = _tmp2_;
	spit_transitions_visuals_get_to_pos (visuals, &_tmp4_);
	_tmp5_ = _tmp4_;
	radius = (gint) fmax ((gdouble) _tmp3_.width, (gdouble) _tmp5_.height);
	_tmp6_ = spit_transitions_visuals_get_from_pixbuf (visuals);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkRectangle _tmp10_ = {0};
		GdkRectangle _tmp11_;
		GdkRectangle _tmp12_ = {0};
		GdkRectangle _tmp13_;
		_tmp8_ = spit_transitions_visuals_get_from_pixbuf (visuals);
		_tmp9_ = _tmp8_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp10_);
		_tmp11_ = _tmp10_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp12_);
		_tmp13_ = _tmp12_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp9_, (gdouble) _tmp11_.x, (gdouble) _tmp13_.y);
		cairo_paint_with_alpha (ctx, 1 - alpha);
	}
	_tmp14_ = spit_transitions_visuals_get_to_pixbuf (visuals);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		GdkPixbuf* _tmp16_;
		GdkPixbuf* _tmp17_;
		GdkRectangle _tmp18_ = {0};
		GdkRectangle _tmp19_;
		GdkRectangle _tmp20_ = {0};
		GdkRectangle _tmp21_;
		gint x = 0;
		GdkRectangle _tmp22_ = {0};
		GdkRectangle _tmp23_;
		GdkRectangle _tmp24_ = {0};
		GdkRectangle _tmp25_;
		gint y = 0;
		GdkRectangle _tmp26_ = {0};
		GdkRectangle _tmp27_;
		GdkRectangle _tmp28_ = {0};
		GdkRectangle _tmp29_;
		_tmp16_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp17_ = _tmp16_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp18_);
		_tmp19_ = _tmp18_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp20_);
		_tmp21_ = _tmp20_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp17_, (gdouble) _tmp19_.x, (gdouble) _tmp21_.y);
		spit_transitions_visuals_get_to_pos (visuals, &_tmp22_);
		_tmp23_ = _tmp22_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp24_);
		_tmp25_ = _tmp24_;
		x = _tmp23_.x + (((gint) _tmp25_.width) / 2);
		spit_transitions_visuals_get_to_pos (visuals, &_tmp26_);
		_tmp27_ = _tmp26_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp28_);
		_tmp29_ = _tmp28_;
		y = _tmp27_.y + (((gint) _tmp29_.height) / 2);
		cairo_move_to (ctx, (gdouble) x, (gdouble) y);
		cairo_arc (ctx, (gdouble) x, (gdouble) y, (gdouble) radius, start_angle, stop_angle);
		cairo_fill_preserve (ctx);
	}
}

static void
clock_effect_real_advance (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion,
                           gint frame_number)
{
	ClockEffect * self;
	self = (ClockEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
}

static void
clock_effect_real_cancel (SpitTransitionsEffect* base)
{
	ClockEffect * self;
	self = (ClockEffect*) base;
}

static void
clock_effect_class_init (ClockEffectClass * klass,
                         gpointer klass_data)
{
	clock_effect_parent_class = g_type_class_peek_parent (klass);
}

static void
clock_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface,
                                                     gpointer iface_data)
{
	clock_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_fps = (void (*) (SpitTransitionsEffect*, gint*, gint*)) clock_effect_real_get_fps;
	iface->start = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) clock_effect_real_start;
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect*)) clock_effect_real_needs_clear_background;
	iface->paint = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) clock_effect_real_paint;
	iface->advance = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) clock_effect_real_advance;
	iface->cancel = (void (*) (SpitTransitionsEffect*)) clock_effect_real_cancel;
}

static void
clock_effect_instance_init (ClockEffect * self,
                            gpointer klass)
{
}

static GType
clock_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClockEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clock_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClockEffect), 0, (GInstanceInitFunc) clock_effect_instance_init, NULL };
	static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) clock_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType clock_effect_type_id;
	clock_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "ClockEffect", &g_define_type_info, 0);
	g_type_add_interface_static (clock_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
	return clock_effect_type_id;
}

GType
clock_effect_get_type (void)
{
	static volatile gsize clock_effect_type_id__once = 0;
	if (g_once_init_enter (&clock_effect_type_id__once)) {
		GType clock_effect_type_id;
		clock_effect_type_id = clock_effect_get_type_once ();
		g_once_init_leave (&clock_effect_type_id__once, clock_effect_type_id);
	}
	return clock_effect_type_id__once;
}

