/* WordWrapper.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WordWrapper.vala, do not modify */

/*
* Copyright (c) 2017 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Natan Streppel <streppels at gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_WORD_WRAPPER (word_wrapper_get_type ())
#define WORD_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORD_WRAPPER, WordWrapper))
#define WORD_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORD_WRAPPER, WordWrapperClass))
#define IS_WORD_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORD_WRAPPER))
#define IS_WORD_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORD_WRAPPER))
#define WORD_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORD_WRAPPER, WordWrapperClass))

typedef struct _WordWrapper WordWrapper;
typedef struct _WordWrapperClass WordWrapperClass;
typedef struct _WordWrapperPrivate WordWrapperPrivate;
enum  {
	WORD_WRAPPER_0_PROPERTY,
	WORD_WRAPPER_NUM_PROPERTIES
};
static GParamSpec* word_wrapper_properties[WORD_WRAPPER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _WordWrapper {
	GObject parent_instance;
	WordWrapperPrivate * priv;
};

struct _WordWrapperClass {
	GObjectClass parent_class;
};

static gpointer word_wrapper_parent_class = NULL;
static GRegex* word_wrapper_starting_whitespaces_regex;
static GRegex* word_wrapper_starting_whitespaces_regex = NULL;
static GRegex* word_wrapper_ending_whitespaces_regex;
static GRegex* word_wrapper_ending_whitespaces_regex = NULL;

VALA_EXTERN GType word_wrapper_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WordWrapper, g_object_unref)
VALA_EXTERN gchar* word_wrapper_identify_word (GtkTextIter* start,
                                   GtkTextIter* end,
                                   const gchar* first_half,
                                   const gchar* second_half);
static void word_wrapper_detect_edges (GtkTextIter* start,
                                GtkTextIter* end,
                                const gchar* first_half,
                                const gchar* second_half);
VALA_EXTERN gchar* word_wrapper_wrap_string (const gchar* original_text,
                                 const gchar* first_half,
                                 const gchar* second_half);
static void word_wrapper_save_surrouding_spaces (const gchar* text,
                                          gchar** leading_spaces,
                                          gchar** trailing_spaces);
static gboolean word_wrapper_already_wrapped (const gchar* text,
                                       const gchar* first_half,
                                       const gchar* second_half);
static gchar* word_wrapper_get_return_string (const gchar* text,
                                       const gchar* leading_spaces,
                                       const gchar* trailing_spaces);
static gboolean word_wrapper_no_edges (GtkTextIter* iter);
static void word_wrapper_detects_wrapping (GtkTextIter* start,
                                    GtkTextIter* end,
                                    const gchar* first_half,
                                    const gchar* second_half);
static gboolean word_wrapper_opens_wrapping (GtkTextIter* iter,
                                      const gchar* first_half,
                                      const gchar* second_half);
static void word_wrapper_forwards_iter_until_whitespace (GtkTextIter* iter,
                                                  gint n);
static gboolean word_wrapper_closes_wrapping (GtkTextIter* iter,
                                       const gchar* first_half,
                                       const gchar* second_half);
static void word_wrapper_forwards_iter_to_whitespace (GtkTextIter* iter,
                                               gint n);
static gboolean word_wrapper_iter_is_followed_by (GtkTextIter* iter,
                                           const gchar* text);
static gboolean word_wrapper_word_ends_with (GtkTextIter* iter,
                                      const gchar* tag);
static gboolean word_wrapper_iter_starts_after (GtkTextIter* iter,
                                         const gchar* text);
static gboolean word_wrapper_word_starts_with (GtkTextIter* iter,
                                        const gchar* tag);
static gboolean __lambda11_ (gunichar c);
static gboolean ___lambda11__gtk_text_char_predicate (gunichar ch,
                                               gpointer self);
static gboolean __lambda12_ (gunichar c);
static gboolean ___lambda12__gtk_text_char_predicate (gunichar ch,
                                               gpointer self);
VALA_EXTERN WordWrapper* word_wrapper_new (void);
VALA_EXTERN WordWrapper* word_wrapper_construct (GType object_type);
static void word_wrapper_finalize (GObject * obj);
static GType word_wrapper_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
     * Moves start and end iterators to the beggining and end of an word, respectively, additionaly
     * with its wrappers, if present.
     * Retuns the found string.
     */
gchar*
word_wrapper_identify_word (GtkTextIter* start,
                            GtkTextIter* end,
                            const gchar* first_half,
                            const gchar* second_half)
{
	GtkTextIter _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 42 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (start != NULL, NULL);
#line 42 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (end != NULL, NULL);
#line 42 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (first_half != NULL, NULL);
#line 42 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (second_half != NULL, NULL);
#line 43 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	word_wrapper_detect_edges (start, end, first_half, second_half);
#line 44 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = *end;
#line 44 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp1_ = gtk_text_iter_get_text (start, &_tmp0_);
#line 44 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = _tmp1_;
#line 44 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 174 "WordWrapper.c"
}

/**
     * Wraps this instance's text with first and second halves.
     * Unwraps this instance's text element if already wrapped with first and second halves.
     */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 199 "WordWrapper.c"
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1195 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1195 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1197 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1197 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 223 "WordWrapper.c"
		gchar* _tmp2_;
#line 1198 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1198 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1198 "glib-2.0.vapi"
		return result;
#line 231 "WordWrapper.c"
	} else {
#line 1200 "glib-2.0.vapi"
		result = -1;
#line 1200 "glib-2.0.vapi"
		return result;
#line 237 "WordWrapper.c"
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 261 "WordWrapper.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 270 "WordWrapper.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 289 "WordWrapper.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 293 "WordWrapper.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 299 "WordWrapper.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 309 "WordWrapper.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 317 "WordWrapper.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 321 "WordWrapper.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 327 "WordWrapper.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 337 "WordWrapper.c"
}

gchar*
word_wrapper_wrap_string (const gchar* original_text,
                          const gchar* first_half,
                          const gchar* second_half)
{
	gchar* leading_spaces = NULL;
	gchar* _tmp0_;
	gchar* trailing_spaces = NULL;
	gchar* _tmp1_;
	gchar* text = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* result;
#line 51 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (original_text != NULL, NULL);
#line 51 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (first_half != NULL, NULL);
#line 51 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (second_half != NULL, NULL);
#line 52 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = g_strdup ("");
#line 52 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	leading_spaces = _tmp0_;
#line 53 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp1_ = g_strdup ("");
#line 53 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	trailing_spaces = _tmp1_;
#line 55 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	word_wrapper_save_surrouding_spaces (original_text, &leading_spaces, &trailing_spaces);
#line 57 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp2_ = string_strip (original_text);
#line 57 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	text = _tmp2_;
#line 58 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp3_ = text;
#line 58 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (word_wrapper_already_wrapped (_tmp3_, first_half, second_half)) {
#line 377 "WordWrapper.c"
		gint head = 0;
		gint tail = 0;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
#line 60 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		head = g_utf8_strlen (first_half, (gssize) -1);
#line 61 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp4_ = text;
#line 61 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp5_ = text;
#line 61 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp6_ = strlen (_tmp5_);
#line 61 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp7_ = _tmp6_;
#line 61 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp8_ = strlen (second_half);
#line 61 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp9_ = _tmp8_;
#line 61 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		tail = string_last_index_of (_tmp4_, second_half, _tmp7_ - _tmp9_);
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp10_ = text;
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp11_ = string_substring (_tmp10_, (glong) head, (glong) (tail - head));
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp12_ = _tmp11_;
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp13_ = leading_spaces;
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp14_ = trailing_spaces;
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp15_ = word_wrapper_get_return_string (_tmp12_, _tmp13_, _tmp14_);
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp16_ = _tmp15_;
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_free0 (_tmp12_);
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		result = _tmp16_;
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_free0 (text);
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_free0 (trailing_spaces);
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_free0 (leading_spaces);
#line 62 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		return result;
#line 435 "WordWrapper.c"
	} else {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp17_ = text;
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp18_ = g_strconcat (first_half, _tmp17_, NULL);
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp19_ = _tmp18_;
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp20_ = g_strconcat (_tmp19_, second_half, NULL);
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp21_ = _tmp20_;
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp22_ = leading_spaces;
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp23_ = trailing_spaces;
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp24_ = word_wrapper_get_return_string (_tmp21_, _tmp22_, _tmp23_);
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp25_ = _tmp24_;
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_free0 (_tmp21_);
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_free0 (_tmp19_);
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		result = _tmp25_;
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_free0 (text);
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_free0 (trailing_spaces);
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_free0 (leading_spaces);
#line 65 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		return result;
#line 478 "WordWrapper.c"
	}
}

/**
     * Returns the given stripped string with its leading and trailing whitespaces back on
     */
static gchar*
word_wrapper_get_return_string (const gchar* text,
                                const gchar* leading_spaces,
                                const gchar* trailing_spaces)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
#line 72 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 72 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (leading_spaces != NULL, NULL);
#line 72 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (trailing_spaces != NULL, NULL);
#line 73 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = g_strconcat (leading_spaces, text, NULL);
#line 73 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp1_ = _tmp0_;
#line 73 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp2_ = g_strconcat (_tmp1_, trailing_spaces, NULL);
#line 73 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp3_ = _tmp2_;
#line 73 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_g_free0 (_tmp1_);
#line 73 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = _tmp3_;
#line 73 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 515 "WordWrapper.c"
}

/**
     * Counts the number of whitespace characters to the left and right of a given text
     */
static void
word_wrapper_save_surrouding_spaces (const gchar* text,
                                     gchar** leading_spaces,
                                     gchar** trailing_spaces)
{
	GMatchInfo* match_info = NULL;
	GRegex* _tmp0_;
	GMatchInfo* _tmp1_ = NULL;
	GMatchInfo* _tmp2_;
	GRegex* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	GMatchInfo* _tmp7_;
#line 79 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (text != NULL);
#line 79 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (*leading_spaces != NULL);
#line 79 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (*trailing_spaces != NULL);
#line 82 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = word_wrapper_starting_whitespaces_regex;
#line 82 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_regex_match (_tmp0_, text, 0, &_tmp1_);
#line 82 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_g_match_info_unref0 (match_info);
#line 82 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	match_info = _tmp1_;
#line 83 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp2_ = match_info;
#line 83 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (g_match_info_matches (_tmp2_)) {
#line 551 "WordWrapper.c"
		GMatchInfo* _tmp3_;
		gchar* _tmp4_;
#line 84 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp3_ = match_info;
#line 84 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp4_ = g_match_info_fetch (_tmp3_, 0);
#line 84 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_free0 (*leading_spaces);
#line 84 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		*leading_spaces = _tmp4_;
#line 562 "WordWrapper.c"
	}
#line 88 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp5_ = word_wrapper_ending_whitespaces_regex;
#line 88 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_regex_match (_tmp5_, text, 0, &_tmp6_);
#line 88 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_g_match_info_unref0 (match_info);
#line 88 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	match_info = _tmp6_;
#line 89 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp7_ = match_info;
#line 89 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (g_match_info_matches (_tmp7_)) {
#line 576 "WordWrapper.c"
		GMatchInfo* _tmp8_;
		gchar* _tmp9_;
#line 90 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp8_ = match_info;
#line 90 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp9_ = g_match_info_fetch (_tmp8_, 0);
#line 90 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_free0 (*trailing_spaces);
#line 90 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		*trailing_spaces = _tmp9_;
#line 587 "WordWrapper.c"
	}
#line 79 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_g_match_info_unref0 (match_info);
#line 591 "WordWrapper.c"
}

/**
     * Adjusts iterators to surround a word or its wrappers if present
     */
static void
word_wrapper_detect_edges (GtkTextIter* start,
                           GtkTextIter* end,
                           const gchar* first_half,
                           const gchar* second_half)
{
	GtkTextIter _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 97 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (start != NULL);
#line 97 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (end != NULL);
#line 97 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (first_half != NULL);
#line 97 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (second_half != NULL);
#line 98 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = *end;
#line 98 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (word_wrapper_no_edges (&_tmp0_)) {
#line 99 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		return;
#line 620 "WordWrapper.c"
	}
#line 101 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (g_unichar_isalnum (gtk_text_iter_get_char (start))) {
#line 101 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp2_ = TRUE;
#line 626 "WordWrapper.c"
	} else {
#line 101 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp2_ = g_unichar_isspace (gtk_text_iter_get_char (end));
#line 630 "WordWrapper.c"
	}
#line 101 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (_tmp2_) {
#line 101 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp1_ = TRUE;
#line 636 "WordWrapper.c"
	} else {
#line 101 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp1_ = gtk_text_iter_ends_line (end);
#line 640 "WordWrapper.c"
	}
#line 101 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (_tmp1_) {
#line 103 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		if (!gtk_text_iter_starts_word (start)) {
#line 104 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
			gtk_text_iter_backward_word_start (start);
#line 648 "WordWrapper.c"
		}
#line 106 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		if (!gtk_text_iter_ends_word (end)) {
#line 107 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
			gtk_text_iter_forward_word_end (end);
#line 654 "WordWrapper.c"
		}
	}
#line 110 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	word_wrapper_detects_wrapping (start, end, first_half, second_half);
#line 659 "WordWrapper.c"
}

/**
     * Detects if iterators' pointed text is surrounded by first and second halves
     */
static void
word_wrapper_detects_wrapping (GtkTextIter* start,
                               GtkTextIter* end,
                               const gchar* first_half,
                               const gchar* second_half)
{
	GtkTextIter _tmp0_;
#line 116 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (start != NULL);
#line 116 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (end != NULL);
#line 116 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (first_half != NULL);
#line 116 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (second_half != NULL);
#line 117 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = *start;
#line 117 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (word_wrapper_opens_wrapping (&_tmp0_, first_half, second_half)) {
#line 684 "WordWrapper.c"
		gint _tmp1_;
		gint _tmp2_;
		GtkTextIter _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 118 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp1_ = strlen (first_half);
#line 118 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp2_ = _tmp1_;
#line 118 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		word_wrapper_forwards_iter_until_whitespace (start, _tmp2_);
#line 119 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp3_ = *start;
#line 119 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		*end = _tmp3_;
#line 120 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		gtk_text_iter_forward_visible_word_end (end);
#line 121 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp4_ = strlen (second_half);
#line 121 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp5_ = _tmp4_;
#line 121 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		gtk_text_iter_forward_chars (end, _tmp5_);
#line 708 "WordWrapper.c"
	} else {
		GtkTextIter _tmp6_;
#line 122 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp6_ = *end;
#line 122 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		if (word_wrapper_closes_wrapping (&_tmp6_, first_half, second_half)) {
#line 715 "WordWrapper.c"
			gint _tmp7_;
			gint _tmp8_;
			GtkTextIter _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
#line 123 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
			_tmp7_ = strlen (second_half);
#line 123 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
			_tmp8_ = _tmp7_;
#line 123 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
			word_wrapper_forwards_iter_to_whitespace (end, _tmp8_);
#line 124 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
			_tmp9_ = *end;
#line 124 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
			*start = _tmp9_;
#line 125 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
			gtk_text_iter_backward_visible_word_start (start);
#line 126 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
			_tmp10_ = strlen (first_half);
#line 126 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
			_tmp11_ = _tmp10_;
#line 126 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
			gtk_text_iter_backward_chars (start, _tmp11_);
#line 739 "WordWrapper.c"
		}
	}
}

/**
     * Detects if current word pointed by iter is an opening tag that wraps a word
     */
static gboolean
word_wrapper_opens_wrapping (GtkTextIter* iter,
                             const gchar* first_half,
                             const gchar* second_half)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkTextIter _tmp3_;
	gboolean result;
#line 133 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 133 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (first_half != NULL, FALSE);
#line 133 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (second_half != NULL, FALSE);
#line 134 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = strlen (first_half);
#line 134 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp1_ = _tmp0_;
#line 134 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	word_wrapper_forwards_iter_until_whitespace (iter, _tmp1_);
#line 135 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp3_ = *iter;
#line 135 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (word_wrapper_iter_is_followed_by (&_tmp3_, first_half)) {
#line 773 "WordWrapper.c"
		GtkTextIter _tmp4_;
#line 135 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp4_ = *iter;
#line 135 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp2_ = word_wrapper_word_ends_with (&_tmp4_, second_half);
#line 779 "WordWrapper.c"
	} else {
#line 135 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp2_ = FALSE;
#line 783 "WordWrapper.c"
	}
#line 135 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = _tmp2_;
#line 135 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 789 "WordWrapper.c"
}

/**
     * Detects if current word pointed by iter is a closing tag that wraps a word
     */
static gboolean
word_wrapper_closes_wrapping (GtkTextIter* iter,
                              const gchar* first_half,
                              const gchar* second_half)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkTextIter _tmp3_;
	gboolean result;
#line 142 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 142 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (first_half != NULL, FALSE);
#line 142 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (second_half != NULL, FALSE);
#line 143 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = strlen (second_half);
#line 143 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp1_ = _tmp0_;
#line 143 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	word_wrapper_forwards_iter_to_whitespace (iter, _tmp1_);
#line 144 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp3_ = *iter;
#line 144 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (word_wrapper_iter_starts_after (&_tmp3_, second_half)) {
#line 821 "WordWrapper.c"
		GtkTextIter _tmp4_;
#line 144 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp4_ = *iter;
#line 144 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp2_ = word_wrapper_word_starts_with (&_tmp4_, first_half);
#line 827 "WordWrapper.c"
	} else {
#line 144 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp2_ = FALSE;
#line 831 "WordWrapper.c"
	}
#line 144 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = _tmp2_;
#line 144 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 837 "WordWrapper.c"
}

/**
     * Backwards an iterator up to n times searching for a whitespace
     */
static gboolean
__lambda11_ (gunichar c)
{
	gboolean result;
#line 154 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = g_unichar_isspace (c);
#line 154 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 851 "WordWrapper.c"
}

static gboolean
___lambda11__gtk_text_char_predicate (gunichar ch,
                                      gpointer self)
{
	gboolean result;
	result = __lambda11_ (ch);
#line 153 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 862 "WordWrapper.c"
}

static void
word_wrapper_forwards_iter_until_whitespace (GtkTextIter* iter,
                                             gint n)
{
	GtkTextIter search_limit = {0};
	GtkTextIter _tmp0_;
	GtkTextIter _tmp1_;
#line 150 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (iter != NULL);
#line 151 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = *iter;
#line 151 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	search_limit = _tmp0_;
#line 152 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	gtk_text_iter_backward_chars (&search_limit, n + 1);
#line 153 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp1_ = search_limit;
#line 153 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	gtk_text_iter_backward_find_char (iter, ___lambda11__gtk_text_char_predicate, NULL, &_tmp1_);
#line 156 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (g_unichar_isspace (gtk_text_iter_get_char (iter))) {
#line 157 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		gtk_text_iter_forward_char (iter);
#line 888 "WordWrapper.c"
	}
}

/**
     * Forwards an iterator up to n times searching for a whitespace
     */
static gboolean
__lambda12_ (gunichar c)
{
	gboolean result;
#line 168 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = g_unichar_isspace (c);
#line 168 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 903 "WordWrapper.c"
}

static gboolean
___lambda12__gtk_text_char_predicate (gunichar ch,
                                      gpointer self)
{
	gboolean result;
	result = __lambda12_ (ch);
#line 167 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 914 "WordWrapper.c"
}

static void
word_wrapper_forwards_iter_to_whitespace (GtkTextIter* iter,
                                          gint n)
{
	GtkTextIter search_limit = {0};
	GtkTextIter _tmp0_;
	GtkTextIter _tmp1_;
#line 164 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_if_fail (iter != NULL);
#line 165 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = *iter;
#line 165 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	search_limit = _tmp0_;
#line 166 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	gtk_text_iter_forward_chars (&search_limit, n + 1);
#line 167 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp1_ = search_limit;
#line 167 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	gtk_text_iter_forward_find_char (iter, ___lambda12__gtk_text_char_predicate, NULL, &_tmp1_);
#line 936 "WordWrapper.c"
}

/**
     * Detects if the word pointed by the iterator is prefixed with tag
     */
static gboolean
word_wrapper_word_ends_with (GtkTextIter* iter,
                             const gchar* tag)
{
	GtkTextIter _tmp0_;
	gboolean result;
#line 175 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 175 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 176 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	gtk_text_iter_forward_visible_word_end (iter);
#line 177 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = *iter;
#line 177 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = word_wrapper_iter_is_followed_by (&_tmp0_, tag);
#line 177 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 960 "WordWrapper.c"
}

/**
     * Detects if the word pointed by the iterator is prefixed with tag
     */
static gboolean
word_wrapper_word_starts_with (GtkTextIter* iter,
                               const gchar* tag)
{
	GtkTextIter _tmp0_;
	gboolean result;
#line 183 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 183 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 184 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	gtk_text_iter_backward_visible_word_start (iter);
#line 185 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = *iter;
#line 185 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = word_wrapper_iter_starts_after (&_tmp0_, tag);
#line 185 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 984 "WordWrapper.c"
}

/**
     * Checks if a text iterator starts after parameter text
     */
static gboolean
word_wrapper_iter_starts_after (GtkTextIter* iter,
                                const gchar* text)
{
	GtkTextIter peek_surroundings = {0};
	GtkTextIter _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkTextIter _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
#line 191 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 191 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 192 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = *iter;
#line 192 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	peek_surroundings = _tmp0_;
#line 193 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp1_ = strlen (text);
#line 193 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp2_ = _tmp1_;
#line 193 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	gtk_text_iter_backward_chars (&peek_surroundings, _tmp2_);
#line 194 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp3_ = *iter;
#line 194 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp4_ = gtk_text_iter_get_text (&peek_surroundings, &_tmp3_);
#line 194 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp5_ = _tmp4_;
#line 194 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp6_ = g_strcmp0 (_tmp5_, text) == 0;
#line 194 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_g_free0 (_tmp5_);
#line 194 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = _tmp6_;
#line 194 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 1031 "WordWrapper.c"
}

/**
     * Checks if a text iterator is followed by parameter text
     */
static gboolean
word_wrapper_iter_is_followed_by (GtkTextIter* iter,
                                  const gchar* text)
{
	GtkTextIter peek_surroundings = {0};
	GtkTextIter _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkTextIter _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
#line 200 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 200 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 201 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = *iter;
#line 201 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	peek_surroundings = _tmp0_;
#line 202 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp1_ = strlen (text);
#line 202 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp2_ = _tmp1_;
#line 202 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	gtk_text_iter_forward_chars (&peek_surroundings, _tmp2_);
#line 203 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp3_ = *iter;
#line 203 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp4_ = gtk_text_iter_get_text (&peek_surroundings, &_tmp3_);
#line 203 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp5_ = _tmp4_;
#line 203 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp6_ = g_strcmp0 (_tmp5_, text) == 0;
#line 203 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_g_free0 (_tmp5_);
#line 203 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = _tmp6_;
#line 203 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 1078 "WordWrapper.c"
}

/**
     * Detects if iter is in between two whitespaces
     */
static gboolean
word_wrapper_no_edges (GtkTextIter* iter)
{
	gboolean previous_value = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
#line 210 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 211 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	previous_value = g_unichar_isspace (gtk_text_iter_get_char (iter));
#line 212 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	gtk_text_iter_backward_char (iter);
#line 213 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (g_unichar_isspace (gtk_text_iter_get_char (iter))) {
#line 213 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp1_ = previous_value;
#line 1101 "WordWrapper.c"
	} else {
#line 213 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp1_ = FALSE;
#line 1105 "WordWrapper.c"
	}
#line 213 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (_tmp1_) {
#line 213 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp0_ = TRUE;
#line 1111 "WordWrapper.c"
	} else {
#line 213 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp0_ = FALSE;
#line 1115 "WordWrapper.c"
	}
#line 213 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = _tmp0_;
#line 213 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 1121 "WordWrapper.c"
}

static gboolean
word_wrapper_already_wrapped (const gchar* text,
                              const gchar* first_half,
                              const gchar* second_half)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 216 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 216 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (first_half != NULL, FALSE);
#line 216 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	g_return_val_if_fail (second_half != NULL, FALSE);
#line 217 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (g_str_has_prefix (text, first_half)) {
#line 217 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp0_ = g_str_has_suffix (text, second_half);
#line 1141 "WordWrapper.c"
	} else {
#line 217 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_tmp0_ = FALSE;
#line 1145 "WordWrapper.c"
	}
#line 217 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	result = _tmp0_;
#line 217 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return result;
#line 1151 "WordWrapper.c"
}

WordWrapper*
word_wrapper_construct (GType object_type)
{
	WordWrapper * self = NULL;
#line 27 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	self = (WordWrapper*) g_object_new (object_type, NULL);
#line 27 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return self;
#line 1162 "WordWrapper.c"
}

WordWrapper*
word_wrapper_new (void)
{
#line 27 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	return word_wrapper_construct (TYPE_WORD_WRAPPER);
#line 1170 "WordWrapper.c"
}

static void
word_wrapper_class_init (WordWrapperClass * klass,
                         gpointer klass_data)
{
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_;
	GRegex* _tmp2_;
	GRegex* _tmp3_ = NULL;
	GRegex* _tmp4_;
	GRegex* _tmp5_;
	GError* _inner_error0_ = NULL;
#line 27 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	word_wrapper_parent_class = g_type_class_peek_parent (klass);
#line 27 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	G_OBJECT_CLASS (klass)->finalize = word_wrapper_finalize;
#line 33 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp1_ = g_regex_new ("^(\\s)+", G_REGEX_EXTENDED, 0, &_inner_error0_);
#line 33 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = _tmp1_;
#line 33 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 33 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 33 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		g_clear_error (&_inner_error0_);
#line 1198 "WordWrapper.c"
	}
#line 33 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp2_ = _tmp0_;
#line 33 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp0_ = NULL;
#line 33 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_g_regex_unref0 (word_wrapper_starting_whitespaces_regex);
#line 33 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	word_wrapper_starting_whitespaces_regex = _tmp2_;
#line 34 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp4_ = g_regex_new ("(\\s)+$", G_REGEX_EXTENDED, 0, &_inner_error0_);
#line 34 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp3_ = _tmp4_;
#line 34 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 34 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		_g_regex_unref0 (_tmp0_);
#line 34 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 34 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
		g_clear_error (&_inner_error0_);
#line 1220 "WordWrapper.c"
	}
#line 34 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp5_ = _tmp3_;
#line 34 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_tmp3_ = NULL;
#line 34 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_g_regex_unref0 (word_wrapper_ending_whitespaces_regex);
#line 34 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	word_wrapper_ending_whitespaces_regex = _tmp5_;
#line 31 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_g_regex_unref0 (_tmp3_);
#line 31 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	_g_regex_unref0 (_tmp0_);
#line 1234 "WordWrapper.c"
}

static void
word_wrapper_instance_init (WordWrapper * self,
                            gpointer klass)
{
}

static void
word_wrapper_finalize (GObject * obj)
{
	WordWrapper * self;
#line 27 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WORD_WRAPPER, WordWrapper);
#line 27 "../Notes-up-2.0.6/src/Services/WordWrapper.vala"
	G_OBJECT_CLASS (word_wrapper_parent_class)->finalize (obj);
#line 1251 "WordWrapper.c"
}

/**
 * This class handles the wrapping logic for a given text within the bounds of 
 * two informed strings, which act as "string wrappers" for the text 
 */
static GType
word_wrapper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WordWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) word_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WordWrapper), 0, (GInstanceInitFunc) word_wrapper_instance_init, NULL };
	GType word_wrapper_type_id;
	word_wrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "WordWrapper", &g_define_type_info, 0);
	return word_wrapper_type_id;
}

GType
word_wrapper_get_type (void)
{
	static volatile gsize word_wrapper_type_id__once = 0;
	if (g_once_init_enter (&word_wrapper_type_id__once)) {
		GType word_wrapper_type_id;
		word_wrapper_type_id = word_wrapper_get_type_once ();
		g_once_init_leave (&word_wrapper_type_id__once, word_wrapper_type_id);
	}
	return word_wrapper_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

