/* AnimatorAction.c generated by valac 0.56.18, the Vala compiler
 * generated from AnimatorAction.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	ANIMATION_TYPE_UNKNOWN = 0,
	ANIMATION_TYPE_NODES,
	ANIMATION_TYPE_NODE,
	ANIMATION_TYPE_FADE,
	ANIMATION_TYPE_PAN,
	ANIMATION_TYPE_SCALE,
	ANIMATION_TYPE_PANSCALE
} AnimationType;

#define TYPE_ANIMATION_TYPE (animation_type_get_type ())

#define TYPE_ANIMATOR_ACTION (animator_action_get_type ())
#define ANIMATOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_ACTION, AnimatorAction))
#define ANIMATOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_ACTION, AnimatorActionClass))
#define IS_ANIMATOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_ACTION))
#define IS_ANIMATOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_ACTION))
#define ANIMATOR_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_ACTION, AnimatorActionClass))

typedef struct _AnimatorAction AnimatorAction;
typedef struct _AnimatorActionClass AnimatorActionClass;
typedef struct _AnimatorActionPrivate AnimatorActionPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
enum  {
	ANIMATOR_ACTION_0_PROPERTY,
	ANIMATOR_ACTION_INDEX_PROPERTY,
	ANIMATOR_ACTION_FRAMES_PROPERTY,
	ANIMATOR_ACTION_NUM_PROPERTIES
};
static GParamSpec* animator_action_properties[ANIMATOR_ACTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _AnimatorAction {
	GObject parent_instance;
	AnimatorActionPrivate * priv;
	gchar* _name;
	gboolean _save;
	gint _id;
};

struct _AnimatorActionClass {
	GObjectClass parent_class;
	AnimationType (*type) (AnimatorAction* self);
	void (*capture) (AnimatorAction* self, DrawArea* da);
	void (*adjust) (AnimatorAction* self, DrawArea* da);
	void (*on_completion) (AnimatorAction* self, DrawArea* da);
};

struct _AnimatorActionPrivate {
	gint _index;
	gdouble _frames;
};

static gint AnimatorAction_private_offset;
static gpointer animator_action_parent_class = NULL;
VALA_EXTERN gint animator_action__next_id;
gint animator_action__next_id = 0;

VALA_EXTERN GType animation_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType animator_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorAction, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN AnimationType animator_action_type (AnimatorAction* self);
VALA_EXTERN void animator_action_capture (AnimatorAction* self,
                              DrawArea* da);
VALA_EXTERN void animator_action_adjust (AnimatorAction* self,
                             DrawArea* da);
VALA_EXTERN void animator_action_on_completion (AnimatorAction* self,
                                    DrawArea* da);
VALA_EXTERN AnimatorAction* animator_action_new (const gchar* name,
                                     gboolean save);
VALA_EXTERN AnimatorAction* animator_action_construct (GType object_type,
                                           const gchar* name,
                                           gboolean save);
VALA_EXTERN gchar* animator_action_name (AnimatorAction* self);
VALA_EXTERN gboolean animator_action_save (AnimatorAction* self);
VALA_EXTERN gboolean animator_action_done (AnimatorAction* self);
VALA_EXTERN gint animator_action_get_index (AnimatorAction* self);
VALA_EXTERN gdouble animator_action_get_frames (AnimatorAction* self);
static AnimationType animator_action_real_type (AnimatorAction* self);
static void animator_action_real_capture (AnimatorAction* self,
                                   DrawArea* da);
static void animator_action_real_adjust (AnimatorAction* self,
                                  DrawArea* da);
static void animator_action_real_on_completion (AnimatorAction* self,
                                         DrawArea* da);
VALA_EXTERN void animator_action_flush (AnimatorAction* self,
                            DrawArea* da);
static void animator_action_set_frames (AnimatorAction* self,
                                 gdouble value);
VALA_EXTERN void animator_action_set_index (AnimatorAction* self,
                                gint value);
static void animator_action_finalize (GObject * obj);
static GType animator_action_get_type_once (void);
static void _vala_animator_action_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_animator_action_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
animation_type_get_type_once (void)
{
	static const GEnumValue values[] = {{ANIMATION_TYPE_UNKNOWN, "ANIMATION_TYPE_UNKNOWN", "unknown"}, {ANIMATION_TYPE_NODES, "ANIMATION_TYPE_NODES", "nodes"}, {ANIMATION_TYPE_NODE, "ANIMATION_TYPE_NODE", "node"}, {ANIMATION_TYPE_FADE, "ANIMATION_TYPE_FADE", "fade"}, {ANIMATION_TYPE_PAN, "ANIMATION_TYPE_PAN", "pan"}, {ANIMATION_TYPE_SCALE, "ANIMATION_TYPE_SCALE", "scale"}, {ANIMATION_TYPE_PANSCALE, "ANIMATION_TYPE_PANSCALE", "panscale"}, {0, NULL, NULL}};
	GType animation_type_type_id;
	animation_type_type_id = g_enum_register_static ("AnimationType", values);
	return animation_type_type_id;
}

GType
animation_type_get_type (void)
{
	static volatile gsize animation_type_type_id__once = 0;
	if (g_once_init_enter (&animation_type_type_id__once)) {
		GType animation_type_type_id;
		animation_type_type_id = animation_type_get_type_once ();
		g_once_init_leave (&animation_type_type_id__once, animation_type_type_id);
	}
	return animation_type_type_id__once;
}

static inline gpointer
animator_action_get_instance_private (AnimatorAction* self)
{
	return G_STRUCT_MEMBER_P (self, AnimatorAction_private_offset);
}

AnimatorAction*
animator_action_construct (GType object_type,
                           const gchar* name,
                           gboolean save)
{
	AnimatorAction * self = NULL;
	gchar* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (AnimatorAction*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->_name);
	self->_name = _tmp0_;
	self->_save = save;
	_tmp1_ = animator_action__next_id;
	animator_action__next_id = _tmp1_ + 1;
	self->_id = _tmp1_;
	return self;
}

AnimatorAction*
animator_action_new (const gchar* name,
                     gboolean save)
{
	return animator_action_construct (TYPE_ANIMATOR_ACTION, name, save);
}

gchar*
animator_action_name (AnimatorAction* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_name;
	_tmp1_ = g_strconcat (_tmp0_, "-", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%i", self->_id);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

gboolean
animator_action_save (AnimatorAction* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->_save;
	return result;
}

gboolean
animator_action_done (AnimatorAction* self)
{
	gint _tmp0_;
	gdouble _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_index;
	_tmp1_ = self->priv->_frames;
	result = ((gdouble) _tmp0_) > _tmp1_;
	return result;
}

static AnimationType
animator_action_real_type (AnimatorAction* self)
{
	AnimationType result;
	result = ANIMATION_TYPE_UNKNOWN;
	return result;
}

AnimationType
animator_action_type (AnimatorAction* self)
{
	AnimatorActionClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = ANIMATOR_ACTION_GET_CLASS (self);
	if (_klass_->type) {
		return _klass_->type (self);
	}
	return 0;
}

static void
animator_action_real_capture (AnimatorAction* self,
                              DrawArea* da)
{
	g_return_if_fail (da != NULL);
}

void
animator_action_capture (AnimatorAction* self,
                         DrawArea* da)
{
	AnimatorActionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ANIMATOR_ACTION_GET_CLASS (self);
	if (_klass_->capture) {
		_klass_->capture (self, da);
	}
}

static void
animator_action_real_adjust (AnimatorAction* self,
                             DrawArea* da)
{
	g_return_if_fail (da != NULL);
}

void
animator_action_adjust (AnimatorAction* self,
                        DrawArea* da)
{
	AnimatorActionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ANIMATOR_ACTION_GET_CLASS (self);
	if (_klass_->adjust) {
		_klass_->adjust (self, da);
	}
}

static void
animator_action_real_on_completion (AnimatorAction* self,
                                    DrawArea* da)
{
	g_return_if_fail (da != NULL);
}

void
animator_action_on_completion (AnimatorAction* self,
                               DrawArea* da)
{
	AnimatorActionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ANIMATOR_ACTION_GET_CLASS (self);
	if (_klass_->on_completion) {
		_klass_->on_completion (self, da);
	}
}

void
animator_action_flush (AnimatorAction* self,
                       DrawArea* da)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = self->priv->_index;
	animator_action_set_frames (self, (gdouble) _tmp0_);
	animator_action_adjust (self, da);
}

gint
animator_action_get_index (AnimatorAction* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_index;
	return result;
}

void
animator_action_set_index (AnimatorAction* self,
                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = animator_action_get_index (self);
	if (old_value != value) {
		self->priv->_index = value;
		g_object_notify_by_pspec ((GObject *) self, animator_action_properties[ANIMATOR_ACTION_INDEX_PROPERTY]);
	}
}

gdouble
animator_action_get_frames (AnimatorAction* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_frames;
	return result;
}

static void
animator_action_set_frames (AnimatorAction* self,
                            gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = animator_action_get_frames (self);
	if (old_value != value) {
		self->priv->_frames = value;
		g_object_notify_by_pspec ((GObject *) self, animator_action_properties[ANIMATOR_ACTION_FRAMES_PROPERTY]);
	}
}

static void
animator_action_class_init (AnimatorActionClass * klass,
                            gpointer klass_data)
{
	animator_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AnimatorAction_private_offset);
	((AnimatorActionClass *) klass)->type = (AnimationType (*) (AnimatorAction*)) animator_action_real_type;
	((AnimatorActionClass *) klass)->capture = (void (*) (AnimatorAction*, DrawArea*)) animator_action_real_capture;
	((AnimatorActionClass *) klass)->adjust = (void (*) (AnimatorAction*, DrawArea*)) animator_action_real_adjust;
	((AnimatorActionClass *) klass)->on_completion = (void (*) (AnimatorAction*, DrawArea*)) animator_action_real_on_completion;
	G_OBJECT_CLASS (klass)->get_property = _vala_animator_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_animator_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = animator_action_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATOR_ACTION_INDEX_PROPERTY, animator_action_properties[ANIMATOR_ACTION_INDEX_PROPERTY] = g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATOR_ACTION_FRAMES_PROPERTY, animator_action_properties[ANIMATOR_ACTION_FRAMES_PROPERTY] = g_param_spec_double ("frames", "frames", "frames", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 10, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
animator_action_instance_init (AnimatorAction * self,
                               gpointer klass)
{
	self->priv = animator_action_get_instance_private (self);
	self->priv->_index = 0;
	self->priv->_frames = (gdouble) 10;
}

static void
animator_action_finalize (GObject * obj)
{
	AnimatorAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ANIMATOR_ACTION, AnimatorAction);
	_g_free0 (self->_name);
	G_OBJECT_CLASS (animator_action_parent_class)->finalize (obj);
}

static GType
animator_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AnimatorActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) animator_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnimatorAction), 0, (GInstanceInitFunc) animator_action_instance_init, NULL };
	GType animator_action_type_id;
	animator_action_type_id = g_type_register_static (G_TYPE_OBJECT, "AnimatorAction", &g_define_type_info, 0);
	AnimatorAction_private_offset = g_type_add_instance_private (animator_action_type_id, sizeof (AnimatorActionPrivate));
	return animator_action_type_id;
}

GType
animator_action_get_type (void)
{
	static volatile gsize animator_action_type_id__once = 0;
	if (g_once_init_enter (&animator_action_type_id__once)) {
		GType animator_action_type_id;
		animator_action_type_id = animator_action_get_type_once ();
		g_once_init_leave (&animator_action_type_id__once, animator_action_type_id);
	}
	return animator_action_type_id__once;
}

static void
_vala_animator_action_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	AnimatorAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATOR_ACTION, AnimatorAction);
	switch (property_id) {
		case ANIMATOR_ACTION_INDEX_PROPERTY:
		g_value_set_int (value, animator_action_get_index (self));
		break;
		case ANIMATOR_ACTION_FRAMES_PROPERTY:
		g_value_set_double (value, animator_action_get_frames (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_animator_action_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	AnimatorAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATOR_ACTION, AnimatorAction);
	switch (property_id) {
		case ANIMATOR_ACTION_INDEX_PROPERTY:
		animator_action_set_index (self, g_value_get_int (value));
		break;
		case ANIMATOR_ACTION_FRAMES_PROPERTY:
		animator_action_set_frames (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

