/* UndoTextBuffer.c generated by valac 0.56.18, the Vala compiler
 * generated from UndoTextBuffer.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;
typedef struct _UndoBufferPrivate UndoBufferPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;

#define TYPE_UNDO_TEXT_BUFFER (undo_text_buffer_get_type ())
#define UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer))
#define UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))
#define IS_UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_BUFFER))
#define IS_UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_BUFFER))
#define UNDO_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))

typedef struct _UndoTextBuffer UndoTextBuffer;
typedef struct _UndoTextBufferClass UndoTextBufferClass;
typedef struct _UndoTextBufferPrivate UndoTextBufferPrivate;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;
enum  {
	UNDO_TEXT_BUFFER_0_PROPERTY,
	UNDO_TEXT_BUFFER_CT_PROPERTY,
	UNDO_TEXT_BUFFER_ORIG_PROPERTY,
	UNDO_TEXT_BUFFER_MERGEABLE_PROPERTY,
	UNDO_TEXT_BUFFER_DO_UNDO_PROPERTY,
	UNDO_TEXT_BUFFER_NUM_PROPERTIES
};
static GParamSpec* undo_text_buffer_properties[UNDO_TEXT_BUFFER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_UNDO_TEXT_ITEM (undo_text_item_get_type ())
#define UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItem))
#define UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))
#define IS_UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_ITEM))
#define IS_UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_ITEM))
#define UNDO_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))

typedef struct _UndoTextItem UndoTextItem;
typedef struct _UndoTextItemClass UndoTextItemClass;

#define TYPE_UNDO_TEXT_INSERT (undo_text_insert_get_type ())
#define UNDO_TEXT_INSERT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_INSERT, UndoTextInsert))
#define UNDO_TEXT_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_INSERT, UndoTextInsertClass))
#define IS_UNDO_TEXT_INSERT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_INSERT))
#define IS_UNDO_TEXT_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_INSERT))
#define UNDO_TEXT_INSERT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_INSERT, UndoTextInsertClass))

typedef struct _UndoTextInsert UndoTextInsert;
typedef struct _UndoTextInsertClass UndoTextInsertClass;

#define TYPE_INSERT_TEXT (insert_text_get_type ())
typedef struct _InsertText InsertText;

#define TYPE_UNDO_TEXT_MULTI_INSERT (undo_text_multi_insert_get_type ())
#define UNDO_TEXT_MULTI_INSERT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_MULTI_INSERT, UndoTextMultiInsert))
#define UNDO_TEXT_MULTI_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_MULTI_INSERT, UndoTextMultiInsertClass))
#define IS_UNDO_TEXT_MULTI_INSERT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_MULTI_INSERT))
#define IS_UNDO_TEXT_MULTI_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_MULTI_INSERT))
#define UNDO_TEXT_MULTI_INSERT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_MULTI_INSERT, UndoTextMultiInsertClass))

typedef struct _UndoTextMultiInsert UndoTextMultiInsert;
typedef struct _UndoTextMultiInsertClass UndoTextMultiInsertClass;

#define TYPE_UNDO_TAG_INFO (undo_tag_info_get_type ())
#define UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfo))
#define UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))
#define IS_UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TAG_INFO))
#define IS_UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TAG_INFO))
#define UNDO_TAG_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))

typedef struct _UndoTagInfo UndoTagInfo;
typedef struct _UndoTagInfoClass UndoTagInfoClass;

#define TYPE_UNDO_TEXT_DELETE (undo_text_delete_get_type ())
#define UNDO_TEXT_DELETE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_DELETE, UndoTextDelete))
#define UNDO_TEXT_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_DELETE, UndoTextDeleteClass))
#define IS_UNDO_TEXT_DELETE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_DELETE))
#define IS_UNDO_TEXT_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_DELETE))
#define UNDO_TEXT_DELETE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_DELETE, UndoTextDeleteClass))

typedef struct _UndoTextDelete UndoTextDelete;
typedef struct _UndoTextDeleteClass UndoTextDeleteClass;

#define TYPE_UNDO_TEXT_REPLACE (undo_text_replace_get_type ())
#define UNDO_TEXT_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_REPLACE, UndoTextReplace))
#define UNDO_TEXT_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_REPLACE, UndoTextReplaceClass))
#define IS_UNDO_TEXT_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_REPLACE))
#define IS_UNDO_TEXT_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_REPLACE))
#define UNDO_TEXT_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_REPLACE, UndoTextReplaceClass))

typedef struct _UndoTextReplace UndoTextReplace;
typedef struct _UndoTextReplaceClass UndoTextReplaceClass;
typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())

#define TYPE_UNDO_TEXT_TAG_ADD (undo_text_tag_add_get_type ())
#define UNDO_TEXT_TAG_ADD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_TAG_ADD, UndoTextTagAdd))
#define UNDO_TEXT_TAG_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_TAG_ADD, UndoTextTagAddClass))
#define IS_UNDO_TEXT_TAG_ADD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_TAG_ADD))
#define IS_UNDO_TEXT_TAG_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_TAG_ADD))
#define UNDO_TEXT_TAG_ADD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_TAG_ADD, UndoTextTagAddClass))

typedef struct _UndoTextTagAdd UndoTextTagAdd;
typedef struct _UndoTextTagAddClass UndoTextTagAddClass;

#define TYPE_UNDO_TEXT_TAG_REMOVE (undo_text_tag_remove_get_type ())
#define UNDO_TEXT_TAG_REMOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_TAG_REMOVE, UndoTextTagRemove))
#define UNDO_TEXT_TAG_REMOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_TAG_REMOVE, UndoTextTagRemoveClass))
#define IS_UNDO_TEXT_TAG_REMOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_TAG_REMOVE))
#define IS_UNDO_TEXT_TAG_REMOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_TAG_REMOVE))
#define UNDO_TEXT_TAG_REMOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_TAG_REMOVE, UndoTextTagRemoveClass))

typedef struct _UndoTextTagRemove UndoTextTagRemove;
typedef struct _UndoTextTagRemoveClass UndoTextTagRemoveClass;

#define TYPE_UNDO_TEXT_CLEAR_TAGS (undo_text_clear_tags_get_type ())
#define UNDO_TEXT_CLEAR_TAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_CLEAR_TAGS, UndoTextClearTags))
#define UNDO_TEXT_CLEAR_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_CLEAR_TAGS, UndoTextClearTagsClass))
#define IS_UNDO_TEXT_CLEAR_TAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_CLEAR_TAGS))
#define IS_UNDO_TEXT_CLEAR_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_CLEAR_TAGS))
#define UNDO_TEXT_CLEAR_TAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_CLEAR_TAGS, UndoTextClearTagsClass))

typedef struct _UndoTextClearTags UndoTextClearTags;
typedef struct _UndoTextClearTagsClass UndoTextClearTagsClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UndoBuffer {
	GObject parent_instance;
	UndoBufferPrivate * priv;
	DrawArea* _da;
	GArray* _undo_buffer;
	GArray* _redo_buffer;
};

struct _UndoBufferClass {
	GObjectClass parent_class;
	void (*undo) (UndoBuffer* self);
	void (*redo) (UndoBuffer* self);
};

struct _UndoTextBuffer {
	UndoBuffer parent_instance;
	UndoTextBufferPrivate * priv;
};

struct _UndoTextBufferClass {
	UndoBufferClass parent_class;
};

struct _UndoTextBufferPrivate {
	CanvasText* _ct;
	CanvasText* _orig;
	gboolean _mergeable;
	gboolean _do_undo;
};

struct _InsertText {
	gint start;
	gchar* text;
};

static gint UndoTextBuffer_private_offset;
static gpointer undo_text_buffer_parent_class = NULL;

VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN GType undo_text_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextBuffer, g_object_unref)
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN void undo_buffer_undo (UndoBuffer* self);
VALA_EXTERN void undo_buffer_redo (UndoBuffer* self);
VALA_EXTERN UndoTextBuffer* undo_text_buffer_new (DrawArea* da);
VALA_EXTERN UndoTextBuffer* undo_text_buffer_construct (GType object_type,
                                            DrawArea* da);
VALA_EXTERN UndoBuffer* undo_buffer_new (DrawArea* da);
VALA_EXTERN UndoBuffer* undo_buffer_construct (GType object_type,
                                   DrawArea* da);
VALA_EXTERN CanvasText* canvas_text_new (DrawArea* da);
VALA_EXTERN CanvasText* canvas_text_construct (GType object_type,
                                   DrawArea* da);
static void undo_text_buffer_set_orig (UndoTextBuffer* self,
                                CanvasText* value);
VALA_EXTERN GType undo_text_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextItem, g_object_unref)
static gboolean undo_text_buffer_merge_with_last (UndoTextBuffer* self,
                                           UndoTextItem* item);
VALA_EXTERN gboolean undo_text_buffer_get_mergeable (UndoTextBuffer* self);
VALA_EXTERN gboolean undo_text_item_merge (UndoTextItem* self,
                               CanvasText* ct,
                               UndoTextItem* item);
VALA_EXTERN CanvasText* undo_text_buffer_get_ct (UndoTextBuffer* self);
VALA_EXTERN void undo_text_buffer_set_mergeable (UndoTextBuffer* self,
                                     gboolean value);
static gint undo_text_buffer_get_ct_cursor (UndoTextBuffer* self);
VALA_EXTERN void canvas_text_get_cursor_info (CanvasText* self,
                                  gint* cursor,
                                  gint* start,
                                  gint* end);
VALA_EXTERN void undo_text_buffer_add_insert (UndoTextBuffer* self,
                                  gint start,
                                  const gchar* text,
                                  gint start_cursor);
VALA_EXTERN GType undo_text_insert_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextInsert, g_object_unref)
VALA_EXTERN UndoTextInsert* undo_text_insert_new (const gchar* text,
                                      gint start,
                                      gint start_cursor,
                                      gint end_cursor);
VALA_EXTERN UndoTextInsert* undo_text_insert_construct (GType object_type,
                                            const gchar* text,
                                            gint start,
                                            gint start_cursor,
                                            gint end_cursor);
VALA_EXTERN void undo_buffer_add_item (UndoBuffer* self,
                           UndoItem* item);
VALA_EXTERN GType insert_text_get_type (void) G_GNUC_CONST ;
VALA_EXTERN InsertText* insert_text_dup (const InsertText* self);
VALA_EXTERN void insert_text_free (InsertText* self);
VALA_EXTERN void insert_text_copy (const InsertText* self,
                       InsertText* dest);
VALA_EXTERN void insert_text_destroy (InsertText* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (InsertText, insert_text_destroy)
VALA_EXTERN void undo_text_buffer_add_inserts (UndoTextBuffer* self,
                                   GArray* its,
                                   gint start_cursor);
VALA_EXTERN GType undo_text_multi_insert_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextMultiInsert, g_object_unref)
VALA_EXTERN UndoTextMultiInsert* undo_text_multi_insert_new (GArray* inserts,
                                                 gint start_cursor,
                                                 gint end_cursor);
VALA_EXTERN UndoTextMultiInsert* undo_text_multi_insert_construct (GType object_type,
                                                       GArray* inserts,
                                                       gint start_cursor,
                                                       gint end_cursor);
VALA_EXTERN gpointer undo_tag_info_ref (gpointer instance);
VALA_EXTERN void undo_tag_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo_tag_info (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_undo_tag_info (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_undo_tag_info (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_undo_tag_info (const GValue* value);
VALA_EXTERN GType undo_tag_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTagInfo, undo_tag_info_unref)
VALA_EXTERN void undo_text_buffer_add_delete (UndoTextBuffer* self,
                                  gint start,
                                  const gchar* orig_text,
                                  GArray* tags,
                                  gint start_cursor);
VALA_EXTERN GType undo_text_delete_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextDelete, g_object_unref)
VALA_EXTERN UndoTextDelete* undo_text_delete_new (const gchar* text,
                                      gint start,
                                      GArray* tags,
                                      gint start_cursor,
                                      gint end_cursor);
VALA_EXTERN UndoTextDelete* undo_text_delete_construct (GType object_type,
                                            const gchar* text,
                                            gint start,
                                            GArray* tags,
                                            gint start_cursor,
                                            gint end_cursor);
VALA_EXTERN void undo_text_buffer_add_replace (UndoTextBuffer* self,
                                   gint start,
                                   const gchar* orig_text,
                                   const gchar* text,
                                   GArray* tags,
                                   gint start_cursor);
VALA_EXTERN GType undo_text_replace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextReplace, g_object_unref)
VALA_EXTERN UndoTextReplace* undo_text_replace_new (const gchar* orig_text,
                                        const gchar* new_text,
                                        gint start,
                                        GArray* tags,
                                        gint start_cursor,
                                        gint end_cursor);
VALA_EXTERN UndoTextReplace* undo_text_replace_construct (GType object_type,
                                              const gchar* orig_text,
                                              const gchar* new_text,
                                              gint start,
                                              GArray* tags,
                                              gint start_cursor,
                                              gint end_cursor);
VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void undo_text_buffer_add_tag_add (UndoTextBuffer* self,
                                   gint start,
                                   gint end,
                                   FormatTag tag,
                                   const gchar* extra,
                                   gboolean parsed,
                                   gint cursor);
VALA_EXTERN GType undo_text_tag_add_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextTagAdd, g_object_unref)
VALA_EXTERN UndoTextTagAdd* undo_text_tag_add_new (gint start,
                                       gint end,
                                       FormatTag tag,
                                       const gchar* extra,
                                       gboolean parsed,
                                       gint cursor);
VALA_EXTERN UndoTextTagAdd* undo_text_tag_add_construct (GType object_type,
                                             gint start,
                                             gint end,
                                             FormatTag tag,
                                             const gchar* extra,
                                             gboolean parsed,
                                             gint cursor);
VALA_EXTERN void undo_text_buffer_add_tag_remove (UndoTextBuffer* self,
                                      gint start,
                                      gint end,
                                      FormatTag tag,
                                      const gchar* extra,
                                      gboolean parsed,
                                      gint cursor);
VALA_EXTERN GType undo_text_tag_remove_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextTagRemove, g_object_unref)
VALA_EXTERN UndoTextTagRemove* undo_text_tag_remove_new (gint start,
                                             gint end,
                                             FormatTag tag,
                                             const gchar* extra,
                                             gboolean parsed,
                                             gint cursor);
VALA_EXTERN UndoTextTagRemove* undo_text_tag_remove_construct (GType object_type,
                                                   gint start,
                                                   gint end,
                                                   FormatTag tag,
                                                   const gchar* extra,
                                                   gboolean parsed,
                                                   gint cursor);
VALA_EXTERN void undo_text_buffer_add_tag_clear (UndoTextBuffer* self,
                                     gint start,
                                     gint end,
                                     GArray* tags,
                                     gint cursor);
VALA_EXTERN GType undo_text_clear_tags_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextClearTags, g_object_unref)
VALA_EXTERN UndoTextClearTags* undo_text_clear_tags_new (gint start,
                                             gint end,
                                             GArray* tags,
                                             gint cursor);
VALA_EXTERN UndoTextClearTags* undo_text_clear_tags_construct (GType object_type,
                                                   gint start,
                                                   gint end,
                                                   GArray* tags,
                                                   gint cursor);
static void undo_text_buffer_real_undo (UndoBuffer* base);
VALA_EXTERN gboolean undo_buffer_undoable (UndoBuffer* self);
VALA_EXTERN void undo_text_item_undo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
static void undo_text_buffer_real_redo (UndoBuffer* base);
VALA_EXTERN gboolean undo_buffer_redoable (UndoBuffer* self);
VALA_EXTERN void undo_text_item_redo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
VALA_EXTERN void undo_text_buffer_set_ct (UndoTextBuffer* self,
                              CanvasText* value);
VALA_EXTERN CanvasText* undo_text_buffer_get_orig (UndoTextBuffer* self);
VALA_EXTERN gboolean undo_text_buffer_get_do_undo (UndoTextBuffer* self);
VALA_EXTERN void undo_text_buffer_set_do_undo (UndoTextBuffer* self,
                                   gboolean value);
static void undo_text_buffer_finalize (GObject * obj);
static GType undo_text_buffer_get_type_once (void);
static void _vala_undo_text_buffer_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_undo_text_buffer_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
undo_text_buffer_get_instance_private (UndoTextBuffer* self)
{
	return G_STRUCT_MEMBER_P (self, UndoTextBuffer_private_offset);
}

UndoTextBuffer*
undo_text_buffer_construct (GType object_type,
                            DrawArea* da)
{
	UndoTextBuffer * self = NULL;
	CanvasText* _tmp0_;
	CanvasText* _tmp1_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (UndoTextBuffer*) undo_buffer_construct (object_type, da);
	_tmp0_ = canvas_text_new (da);
	_tmp1_ = _tmp0_;
	undo_text_buffer_set_orig (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}

UndoTextBuffer*
undo_text_buffer_new (DrawArea* da)
{
	return undo_text_buffer_construct (TYPE_UNDO_TEXT_BUFFER, da);
}

static gboolean
undo_text_buffer_merge_with_last (UndoTextBuffer* self,
                                  UndoTextItem* item)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GArray* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp2_ = ((UndoBuffer*) self)->_undo_buffer;
	if (_tmp2_->len > ((guint) 0)) {
		GArray* _tmp3_;
		_tmp3_ = ((UndoBuffer*) self)->_redo_buffer;
		_tmp1_ = _tmp3_->len == ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->_mergeable;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GArray* _tmp5_;
		GArray* _tmp6_;
		UndoItem* _tmp7_;
		CanvasText* _tmp8_;
		_tmp5_ = ((UndoBuffer*) self)->_undo_buffer;
		_tmp6_ = ((UndoBuffer*) self)->_undo_buffer;
		_tmp7_ = g_array_index (_tmp5_, UndoItem*, _tmp6_->len - 1);
		_tmp8_ = self->priv->_ct;
		result = undo_text_item_merge (IS_UNDO_TEXT_ITEM (_tmp7_) ? ((UndoTextItem*) _tmp7_) : NULL, _tmp8_, item);
		return result;
	}
	undo_text_buffer_set_mergeable (self, TRUE);
	result = FALSE;
	return result;
}

static gint
undo_text_buffer_get_ct_cursor (UndoTextBuffer* self)
{
	gint cursor = 0;
	gint start = 0;
	gint end = 0;
	CanvasText* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_ct;
	canvas_text_get_cursor_info (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	cursor = _tmp1_;
	start = _tmp2_;
	end = _tmp3_;
	result = cursor;
	return result;
}

void
undo_text_buffer_add_insert (UndoTextBuffer* self,
                             gint start,
                             const gchar* text,
                             gint start_cursor)
{
	UndoTextInsert* item = NULL;
	UndoTextInsert* _tmp0_;
	UndoTextInsert* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = undo_text_insert_new (text, start, start_cursor, undo_text_buffer_get_ct_cursor (self));
	item = _tmp0_;
	_tmp1_ = item;
	if (!undo_text_buffer_merge_with_last (self, (UndoTextItem*) _tmp1_)) {
		UndoTextInsert* _tmp2_;
		_tmp2_ = item;
		undo_buffer_add_item ((UndoBuffer*) self, (UndoItem*) _tmp2_);
	}
	_g_object_unref0 (item);
}

void
undo_text_buffer_add_inserts (UndoTextBuffer* self,
                              GArray* its,
                              gint start_cursor)
{
	UndoTextMultiInsert* item = NULL;
	UndoTextMultiInsert* _tmp0_;
	UndoTextMultiInsert* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (its != NULL);
	_tmp0_ = undo_text_multi_insert_new (its, start_cursor, undo_text_buffer_get_ct_cursor (self));
	item = _tmp0_;
	_tmp1_ = item;
	if (!undo_text_buffer_merge_with_last (self, (UndoTextItem*) _tmp1_)) {
		UndoTextMultiInsert* _tmp2_;
		_tmp2_ = item;
		undo_buffer_add_item ((UndoBuffer*) self, (UndoItem*) _tmp2_);
	}
	_g_object_unref0 (item);
}

void
undo_text_buffer_add_delete (UndoTextBuffer* self,
                             gint start,
                             const gchar* orig_text,
                             GArray* tags,
                             gint start_cursor)
{
	UndoTextDelete* item = NULL;
	UndoTextDelete* _tmp0_;
	UndoTextDelete* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (orig_text != NULL);
	_tmp0_ = undo_text_delete_new (orig_text, start, tags, start_cursor, undo_text_buffer_get_ct_cursor (self));
	item = _tmp0_;
	_tmp1_ = item;
	if (!undo_text_buffer_merge_with_last (self, (UndoTextItem*) _tmp1_)) {
		UndoTextDelete* _tmp2_;
		_tmp2_ = item;
		undo_buffer_add_item ((UndoBuffer*) self, (UndoItem*) _tmp2_);
	}
	_g_object_unref0 (item);
}

void
undo_text_buffer_add_replace (UndoTextBuffer* self,
                              gint start,
                              const gchar* orig_text,
                              const gchar* text,
                              GArray* tags,
                              gint start_cursor)
{
	UndoTextReplace* item = NULL;
	UndoTextReplace* _tmp0_;
	UndoTextReplace* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (orig_text != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = undo_text_replace_new (orig_text, text, start, tags, start_cursor, undo_text_buffer_get_ct_cursor (self));
	item = _tmp0_;
	_tmp1_ = item;
	if (!undo_text_buffer_merge_with_last (self, (UndoTextItem*) _tmp1_)) {
		UndoTextReplace* _tmp2_;
		_tmp2_ = item;
		undo_buffer_add_item ((UndoBuffer*) self, (UndoItem*) _tmp2_);
	}
	_g_object_unref0 (item);
}

void
undo_text_buffer_add_tag_add (UndoTextBuffer* self,
                              gint start,
                              gint end,
                              FormatTag tag,
                              const gchar* extra,
                              gboolean parsed,
                              gint cursor)
{
	UndoTextTagAdd* item = NULL;
	UndoTextTagAdd* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = undo_text_tag_add_new (start, end, tag, extra, parsed, cursor);
	item = _tmp0_;
	undo_buffer_add_item ((UndoBuffer*) self, (UndoItem*) item);
	_g_object_unref0 (item);
}

void
undo_text_buffer_add_tag_remove (UndoTextBuffer* self,
                                 gint start,
                                 gint end,
                                 FormatTag tag,
                                 const gchar* extra,
                                 gboolean parsed,
                                 gint cursor)
{
	UndoTextTagRemove* item = NULL;
	UndoTextTagRemove* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = undo_text_tag_remove_new (start, end, tag, extra, parsed, cursor);
	item = _tmp0_;
	undo_buffer_add_item ((UndoBuffer*) self, (UndoItem*) item);
	_g_object_unref0 (item);
}

void
undo_text_buffer_add_tag_clear (UndoTextBuffer* self,
                                gint start,
                                gint end,
                                GArray* tags,
                                gint cursor)
{
	UndoTextClearTags* item = NULL;
	UndoTextClearTags* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tags != NULL);
	_tmp0_ = undo_text_clear_tags_new (start, end, tags, cursor);
	item = _tmp0_;
	undo_buffer_add_item ((UndoBuffer*) self, (UndoItem*) item);
	_g_object_unref0 (item);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

static void
undo_text_buffer_real_undo (UndoBuffer* base)
{
	UndoTextBuffer * self;
	self = (UndoTextBuffer*) base;
	if (undo_buffer_undoable ((UndoBuffer*) self)) {
		UndoItem* item = NULL;
		GArray* _tmp0_;
		GArray* _tmp1_;
		UndoItem* _tmp2_;
		UndoItem* _tmp3_;
		UndoItem* _tmp4_;
		DrawArea* _tmp5_;
		CanvasText* _tmp6_;
		GArray* _tmp7_;
		GArray* _tmp8_;
		UndoItem* _tmp9_;
		UndoItem* _tmp10_;
		GArray* _tmp11_;
		UndoItem* _tmp12_;
		UndoItem* _tmp13_;
		_tmp0_ = ((UndoBuffer*) self)->_undo_buffer;
		_tmp1_ = ((UndoBuffer*) self)->_undo_buffer;
		_tmp2_ = g_array_index (_tmp0_, UndoItem*, _tmp1_->len - 1);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		item = _tmp3_;
		_tmp4_ = item;
		_tmp5_ = ((UndoBuffer*) self)->_da;
		_tmp6_ = self->priv->_ct;
		undo_text_item_undo_text (IS_UNDO_TEXT_ITEM (_tmp4_) ? ((UndoTextItem*) _tmp4_) : NULL, _tmp5_, _tmp6_);
		_tmp7_ = ((UndoBuffer*) self)->_undo_buffer;
		_tmp8_ = ((UndoBuffer*) self)->_undo_buffer;
		_tmp9_ = vala_g_array_remove_index (_tmp7_, _tmp8_->len - 1);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		_tmp11_ = ((UndoBuffer*) self)->_redo_buffer;
		_tmp12_ = item;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		g_array_append_val (_tmp11_, _tmp13_);
		undo_text_buffer_set_mergeable (self, FALSE);
		g_signal_emit_by_name ((UndoBuffer*) self, "buffer-changed", (UndoBuffer*) self);
		_g_object_unref0 (item);
	}
}

static void
undo_text_buffer_real_redo (UndoBuffer* base)
{
	UndoTextBuffer * self;
	self = (UndoTextBuffer*) base;
	if (undo_buffer_redoable ((UndoBuffer*) self)) {
		UndoItem* item = NULL;
		GArray* _tmp0_;
		GArray* _tmp1_;
		UndoItem* _tmp2_;
		UndoItem* _tmp3_;
		UndoItem* _tmp4_;
		DrawArea* _tmp5_;
		CanvasText* _tmp6_;
		GArray* _tmp7_;
		GArray* _tmp8_;
		UndoItem* _tmp9_;
		UndoItem* _tmp10_;
		GArray* _tmp11_;
		UndoItem* _tmp12_;
		UndoItem* _tmp13_;
		_tmp0_ = ((UndoBuffer*) self)->_redo_buffer;
		_tmp1_ = ((UndoBuffer*) self)->_redo_buffer;
		_tmp2_ = g_array_index (_tmp0_, UndoItem*, _tmp1_->len - 1);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		item = _tmp3_;
		_tmp4_ = item;
		_tmp5_ = ((UndoBuffer*) self)->_da;
		_tmp6_ = self->priv->_ct;
		undo_text_item_redo_text (IS_UNDO_TEXT_ITEM (_tmp4_) ? ((UndoTextItem*) _tmp4_) : NULL, _tmp5_, _tmp6_);
		_tmp7_ = ((UndoBuffer*) self)->_redo_buffer;
		_tmp8_ = ((UndoBuffer*) self)->_redo_buffer;
		_tmp9_ = vala_g_array_remove_index (_tmp7_, _tmp8_->len - 1);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		_tmp11_ = ((UndoBuffer*) self)->_undo_buffer;
		_tmp12_ = item;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		g_array_append_val (_tmp11_, _tmp13_);
		undo_text_buffer_set_mergeable (self, FALSE);
		g_signal_emit_by_name ((UndoBuffer*) self, "buffer-changed", (UndoBuffer*) self);
		_g_object_unref0 (item);
	}
}

CanvasText*
undo_text_buffer_get_ct (UndoTextBuffer* self)
{
	CanvasText* result;
	CanvasText* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ct;
	result = _tmp0_;
	return result;
}

void
undo_text_buffer_set_ct (UndoTextBuffer* self,
                         CanvasText* value)
{
	CanvasText* old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_buffer_get_ct (self);
	if (old_value != value) {
		CanvasText* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_ct);
		self->priv->_ct = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, undo_text_buffer_properties[UNDO_TEXT_BUFFER_CT_PROPERTY]);
	}
}

CanvasText*
undo_text_buffer_get_orig (UndoTextBuffer* self)
{
	CanvasText* result;
	CanvasText* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_orig;
	result = _tmp0_;
	return result;
}

static void
undo_text_buffer_set_orig (UndoTextBuffer* self,
                           CanvasText* value)
{
	CanvasText* old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_buffer_get_orig (self);
	if (old_value != value) {
		CanvasText* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_orig);
		self->priv->_orig = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, undo_text_buffer_properties[UNDO_TEXT_BUFFER_ORIG_PROPERTY]);
	}
}

gboolean
undo_text_buffer_get_mergeable (UndoTextBuffer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mergeable;
	return result;
}

void
undo_text_buffer_set_mergeable (UndoTextBuffer* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_buffer_get_mergeable (self);
	if (old_value != value) {
		self->priv->_mergeable = value;
		g_object_notify_by_pspec ((GObject *) self, undo_text_buffer_properties[UNDO_TEXT_BUFFER_MERGEABLE_PROPERTY]);
	}
}

gboolean
undo_text_buffer_get_do_undo (UndoTextBuffer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_do_undo;
	return result;
}

void
undo_text_buffer_set_do_undo (UndoTextBuffer* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_buffer_get_do_undo (self);
	if (old_value != value) {
		self->priv->_do_undo = value;
		g_object_notify_by_pspec ((GObject *) self, undo_text_buffer_properties[UNDO_TEXT_BUFFER_DO_UNDO_PROPERTY]);
	}
}

static void
undo_text_buffer_class_init (UndoTextBufferClass * klass,
                             gpointer klass_data)
{
	undo_text_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UndoTextBuffer_private_offset);
	((UndoBufferClass *) klass)->undo = (void (*) (UndoBuffer*)) undo_text_buffer_real_undo;
	((UndoBufferClass *) klass)->redo = (void (*) (UndoBuffer*)) undo_text_buffer_real_redo;
	G_OBJECT_CLASS (klass)->get_property = _vala_undo_text_buffer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_undo_text_buffer_set_property;
	G_OBJECT_CLASS (klass)->finalize = undo_text_buffer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_BUFFER_CT_PROPERTY, undo_text_buffer_properties[UNDO_TEXT_BUFFER_CT_PROPERTY] = g_param_spec_object ("ct", "ct", "ct", TYPE_CANVAS_TEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_BUFFER_ORIG_PROPERTY, undo_text_buffer_properties[UNDO_TEXT_BUFFER_ORIG_PROPERTY] = g_param_spec_object ("orig", "orig", "orig", TYPE_CANVAS_TEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_BUFFER_MERGEABLE_PROPERTY, undo_text_buffer_properties[UNDO_TEXT_BUFFER_MERGEABLE_PROPERTY] = g_param_spec_boolean ("mergeable", "mergeable", "mergeable", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_BUFFER_DO_UNDO_PROPERTY, undo_text_buffer_properties[UNDO_TEXT_BUFFER_DO_UNDO_PROPERTY] = g_param_spec_boolean ("do-undo", "do-undo", "do-undo", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
undo_text_buffer_instance_init (UndoTextBuffer * self,
                                gpointer klass)
{
	self->priv = undo_text_buffer_get_instance_private (self);
	self->priv->_ct = NULL;
	self->priv->_mergeable = TRUE;
	self->priv->_do_undo = TRUE;
}

static void
undo_text_buffer_finalize (GObject * obj)
{
	UndoTextBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer);
	_g_object_unref0 (self->priv->_ct);
	_g_object_unref0 (self->priv->_orig);
	G_OBJECT_CLASS (undo_text_buffer_parent_class)->finalize (obj);
}

static GType
undo_text_buffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UndoTextBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) undo_text_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UndoTextBuffer), 0, (GInstanceInitFunc) undo_text_buffer_instance_init, NULL };
	GType undo_text_buffer_type_id;
	undo_text_buffer_type_id = g_type_register_static (TYPE_UNDO_BUFFER, "UndoTextBuffer", &g_define_type_info, 0);
	UndoTextBuffer_private_offset = g_type_add_instance_private (undo_text_buffer_type_id, sizeof (UndoTextBufferPrivate));
	return undo_text_buffer_type_id;
}

GType
undo_text_buffer_get_type (void)
{
	static volatile gsize undo_text_buffer_type_id__once = 0;
	if (g_once_init_enter (&undo_text_buffer_type_id__once)) {
		GType undo_text_buffer_type_id;
		undo_text_buffer_type_id = undo_text_buffer_get_type_once ();
		g_once_init_leave (&undo_text_buffer_type_id__once, undo_text_buffer_type_id);
	}
	return undo_text_buffer_type_id__once;
}

static void
_vala_undo_text_buffer_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	UndoTextBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer);
	switch (property_id) {
		case UNDO_TEXT_BUFFER_CT_PROPERTY:
		g_value_set_object (value, undo_text_buffer_get_ct (self));
		break;
		case UNDO_TEXT_BUFFER_ORIG_PROPERTY:
		g_value_set_object (value, undo_text_buffer_get_orig (self));
		break;
		case UNDO_TEXT_BUFFER_MERGEABLE_PROPERTY:
		g_value_set_boolean (value, undo_text_buffer_get_mergeable (self));
		break;
		case UNDO_TEXT_BUFFER_DO_UNDO_PROPERTY:
		g_value_set_boolean (value, undo_text_buffer_get_do_undo (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_undo_text_buffer_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	UndoTextBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer);
	switch (property_id) {
		case UNDO_TEXT_BUFFER_CT_PROPERTY:
		undo_text_buffer_set_ct (self, g_value_get_object (value));
		break;
		case UNDO_TEXT_BUFFER_ORIG_PROPERTY:
		undo_text_buffer_set_orig (self, g_value_get_object (value));
		break;
		case UNDO_TEXT_BUFFER_MERGEABLE_PROPERTY:
		undo_text_buffer_set_mergeable (self, g_value_get_boolean (value));
		break;
		case UNDO_TEXT_BUFFER_DO_UNDO_PROPERTY:
		undo_text_buffer_set_do_undo (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

