/* game-view.c generated by valac 0.56.18, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2018 Robert Roth
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_GAME_VIEW, GameViewIface))

typedef struct _GameView GameView;
typedef struct _GameViewIface GameViewIface;

#define TYPE_BOARD_VIEW (board_view_get_type ())
#define BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_VIEW, BoardView))
#define IS_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_VIEW))
#define BOARD_VIEW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BOARD_VIEW, BoardViewIface))

typedef struct _BoardView BoardView;
typedef struct _BoardViewIface BoardViewIface;

#define TYPE_PUZZLE_GENERATOR (puzzle_generator_get_type ())
#define PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGenerator))
#define PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))
#define IS_PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_GENERATOR))
#define IS_PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_GENERATOR))
#define PUZZLE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))

typedef struct _PuzzleGenerator PuzzleGenerator;
typedef struct _PuzzleGeneratorClass PuzzleGeneratorClass;
typedef enum  {
	GAME_VIEW_REPLACE_STYLE_REFRESH,
	GAME_VIEW_REPLACE_STYLE_RESTART,
	GAME_VIEW_REPLACE_STYLE_SLIDE_FORWARD,
	GAME_VIEW_REPLACE_STYLE_SLIDE_BACKWARD,
	GAME_VIEW_REPLACE_STYLE_SLIDE_NEXT
} GameViewReplaceStyle;

#define GAME_VIEW_TYPE_REPLACE_STYLE (game_view_replace_style_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GAME_VIEW_LEVEL_CHANGED_SIGNAL,
	GAME_VIEW_MOVES_CHANGED_SIGNAL,
	GAME_VIEW_NUM_SIGNALS
};
static guint game_view_signals[GAME_VIEW_NUM_SIGNALS] = {0};

struct _BoardViewIface {
	GTypeInterface parent_iface;
	PuzzleGenerator* (*get_puzzle_generator) (BoardView* self);
	void (*clear_level) (BoardView* self);
	void (*toggle_light) (BoardView* self, gint x, gint y, gboolean user_initiated);
	gboolean (*is_light_active) (BoardView* self, gint x, gint y);
	GObject* (*get_light_at) (BoardView* self, gint x, gint y);
};

struct _GameViewIface {
	GTypeInterface parent_iface;
	void (*replace_board) (GameView* self, BoardView* board_biew, BoardView* new_board_view, GameViewReplaceStyle style, gboolean fast);
	gboolean (*hide_cursor) (GameView* self);
	gboolean (*activate_cursor) (GameView* self);
	gboolean (*move_cursor) (GameView* self, gint x, gint y);
	void (*reset_game) (GameView* self);
	BoardView* (*get_board_view) (GameView* self);
	gboolean (*is_transitioning) (GameView* self);
	gint (*next_level) (GameView* self, gint direction);
	BoardView* (*create_board_view) (GameView* self, gint level);
};

VALA_EXTERN GType puzzle_generator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PuzzleGenerator, g_object_unref)
VALA_EXTERN GType board_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoardView, g_object_unref)
VALA_EXTERN GType game_view_replace_style_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
VALA_EXTERN void game_view_replace_board (GameView* self,
                              BoardView* board_biew,
                              BoardView* new_board_view,
                              GameViewReplaceStyle style,
                              gboolean fast);
VALA_EXTERN gboolean game_view_hide_cursor (GameView* self);
VALA_EXTERN gboolean game_view_activate_cursor (GameView* self);
VALA_EXTERN gboolean game_view_move_cursor (GameView* self,
                                gint x,
                                gint y);
VALA_EXTERN void game_view_reset_game (GameView* self);
VALA_EXTERN BoardView* game_view_get_board_view (GameView* self);
VALA_EXTERN gboolean game_view_is_transitioning (GameView* self);
VALA_EXTERN gint game_view_next_level (GameView* self,
                           gint direction);
VALA_EXTERN BoardView* game_view_create_board_view (GameView* self,
                                        gint level);
VALA_EXTERN void game_view_swap_board (GameView* self,
                           gint direction);
VALA_EXTERN void game_view_game_won_cb (GameView* self);
static GType game_view_get_type_once (void);

static GType
game_view_replace_style_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_VIEW_REPLACE_STYLE_REFRESH, "GAME_VIEW_REPLACE_STYLE_REFRESH", "refresh"}, {GAME_VIEW_REPLACE_STYLE_RESTART, "GAME_VIEW_REPLACE_STYLE_RESTART", "restart"}, {GAME_VIEW_REPLACE_STYLE_SLIDE_FORWARD, "GAME_VIEW_REPLACE_STYLE_SLIDE_FORWARD", "slide-forward"}, {GAME_VIEW_REPLACE_STYLE_SLIDE_BACKWARD, "GAME_VIEW_REPLACE_STYLE_SLIDE_BACKWARD", "slide-backward"}, {GAME_VIEW_REPLACE_STYLE_SLIDE_NEXT, "GAME_VIEW_REPLACE_STYLE_SLIDE_NEXT", "slide-next"}, {0, NULL, NULL}};
	GType game_view_replace_style_type_id;
	game_view_replace_style_type_id = g_enum_register_static ("GameViewReplaceStyle", values);
	return game_view_replace_style_type_id;
}

GType
game_view_replace_style_get_type (void)
{
	static volatile gsize game_view_replace_style_type_id__once = 0;
	if (g_once_init_enter (&game_view_replace_style_type_id__once)) {
		GType game_view_replace_style_type_id;
		game_view_replace_style_type_id = game_view_replace_style_get_type_once ();
		g_once_init_leave (&game_view_replace_style_type_id__once, game_view_replace_style_type_id);
	}
	return game_view_replace_style_type_id__once;
}

void
game_view_replace_board (GameView* self,
                         BoardView* board_biew,
                         BoardView* new_board_view,
                         GameViewReplaceStyle style,
                         gboolean fast)
{
	GameViewIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GAME_VIEW_GET_INTERFACE (self);
	if (_iface_->replace_board) {
		_iface_->replace_board (self, board_biew, new_board_view, style, fast);
	}
}

gboolean
game_view_hide_cursor (GameView* self)
{
	GameViewIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GAME_VIEW_GET_INTERFACE (self);
	if (_iface_->hide_cursor) {
		return _iface_->hide_cursor (self);
	}
	return FALSE;
}

gboolean
game_view_activate_cursor (GameView* self)
{
	GameViewIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GAME_VIEW_GET_INTERFACE (self);
	if (_iface_->activate_cursor) {
		return _iface_->activate_cursor (self);
	}
	return FALSE;
}

gboolean
game_view_move_cursor (GameView* self,
                       gint x,
                       gint y)
{
	GameViewIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GAME_VIEW_GET_INTERFACE (self);
	if (_iface_->move_cursor) {
		return _iface_->move_cursor (self, x, y);
	}
	return FALSE;
}

void
game_view_reset_game (GameView* self)
{
	GameViewIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GAME_VIEW_GET_INTERFACE (self);
	if (_iface_->reset_game) {
		_iface_->reset_game (self);
	}
}

BoardView*
game_view_get_board_view (GameView* self)
{
	GameViewIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GAME_VIEW_GET_INTERFACE (self);
	if (_iface_->get_board_view) {
		return _iface_->get_board_view (self);
	}
	return NULL;
}

gboolean
game_view_is_transitioning (GameView* self)
{
	GameViewIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GAME_VIEW_GET_INTERFACE (self);
	if (_iface_->is_transitioning) {
		return _iface_->is_transitioning (self);
	}
	return FALSE;
}

gint
game_view_next_level (GameView* self,
                      gint direction)
{
	GameViewIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GAME_VIEW_GET_INTERFACE (self);
	if (_iface_->next_level) {
		return _iface_->next_level (self, direction);
	}
	return -1;
}

BoardView*
game_view_create_board_view (GameView* self,
                             gint level)
{
	GameViewIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GAME_VIEW_GET_INTERFACE (self);
	if (_iface_->create_board_view) {
		return _iface_->create_board_view (self, level);
	}
	return NULL;
}

void
game_view_swap_board (GameView* self,
                      gint direction)
{
	GameViewReplaceStyle style = 0;
	BoardView* _tmp0_;
	BoardView* _tmp1_;
	BoardView* _tmp2_;
	BoardView* _tmp3_;
	if (game_view_is_transitioning (self)) {
		return;
	}
	if (direction == 1) {
		style = GAME_VIEW_REPLACE_STYLE_SLIDE_FORWARD;
	} else {
		if (direction == 0) {
			style = GAME_VIEW_REPLACE_STYLE_REFRESH;
		} else {
			if (direction == -1) {
				style = GAME_VIEW_REPLACE_STYLE_SLIDE_BACKWARD;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp0_ = game_view_get_board_view (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_view_create_board_view (self, game_view_next_level (self, direction));
	_tmp3_ = _tmp2_;
	game_view_replace_board (self, _tmp1_, _tmp3_, style, TRUE);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}

void
game_view_game_won_cb (GameView* self)
{
	BoardView* _tmp0_;
	BoardView* _tmp1_;
	BoardView* _tmp2_;
	BoardView* _tmp3_;
	if (game_view_is_transitioning (self)) {
		return;
	}
	_tmp0_ = game_view_get_board_view (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_view_create_board_view (self, game_view_next_level (self, 1));
	_tmp3_ = _tmp2_;
	game_view_replace_board (self, _tmp1_, _tmp3_, GAME_VIEW_REPLACE_STYLE_SLIDE_NEXT, TRUE);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}

static void
game_view_default_init (GameViewIface * iface,
                        gpointer iface_data)
{
	game_view_signals[GAME_VIEW_LEVEL_CHANGED_SIGNAL] = g_signal_new ("level-changed", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	game_view_signals[GAME_VIEW_MOVES_CHANGED_SIGNAL] = g_signal_new ("moves-changed", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}

static GType
game_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameViewIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType game_view_type_id;
	game_view_type_id = g_type_register_static (G_TYPE_INTERFACE, "GameView", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (game_view_type_id, G_TYPE_OBJECT);
	return game_view_type_id;
}

GType
game_view_get_type (void)
{
	static volatile gsize game_view_type_id__once = 0;
	if (g_once_init_enter (&game_view_type_id__once)) {
		GType game_view_type_id;
		game_view_type_id = game_view_get_type_once ();
		g_once_init_leave (&game_view_type_id__once, game_view_type_id);
	}
	return game_view_type_id__once;
}

