
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kdatepickerpopup_wrapper.h"

// Wrappers providing overrides
#include "krecentfilesmenu_wrapper.h"
#include "kxyselector_wrapper.h"

// Argument includes
#include <QMap>
#include <QString>
#include <kdatepicker.h>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatetime.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KDatePickerPopup_Type = nullptr;
static PyTypeObject *Sbk_KDatePickerPopup_TypeF(void)
{
    return _Sbk_KDatePickerPopup_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KDatePickerPopupWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KDatePickerPopupWrapper::KDatePickerPopupWrapper(::QFlags<KDatePickerPopup::Mode> modes, ::QDate date, ::QWidget * parent) : KDatePickerPopup(modes, date, parent)
{
}

void KDatePickerPopupWrapper::actionEvent(::QActionEvent * arg__1)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::actionEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

void KDatePickerPopupWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::changeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

void KDatePickerPopupWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

void KDatePickerPopupWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

void KDatePickerPopupWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDatePickerPopup", funcName, gil, pyOverride, signal);
}

void KDatePickerPopupWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

void KDatePickerPopupWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

int KDatePickerPopupWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KDatePickerPopup", funcName, gil, pyOverride);
}

void KDatePickerPopupWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDatePickerPopup", funcName, gil, pyOverride, signal);
}

void KDatePickerPopupWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

void KDatePickerPopupWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

void KDatePickerPopupWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

void KDatePickerPopupWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

void KDatePickerPopupWrapper::enterEvent(::QEnterEvent * arg__1)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::enterEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

bool KDatePickerPopupWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::event(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_event("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

bool KDatePickerPopupWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KDatePickerPopup", funcName, gil, pyOverride, watched, event);
}

void KDatePickerPopupWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

bool KDatePickerPopupWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KDatePickerPopup", funcName, gil, pyOverride, next);
}

void KDatePickerPopupWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

bool KDatePickerPopupWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KDatePickerPopup", funcName, gil, pyOverride);
}

int KDatePickerPopupWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

void KDatePickerPopupWrapper::hideEvent(::QHideEvent * arg__1)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::hideEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

void KDatePickerPopupWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KDatePickerPopup", funcName, gil, pyOverride, painter);
}

void KDatePickerPopupWrapper::initStyleOption(::QStyleOptionMenuItem * option, const ::QAction * action) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::initStyleOption(option, action);
    }
    KRecentFilesMenuWrapper::sbk_o_initStyleOption("KDatePickerPopup", funcName, gil, pyOverride, option, action);
}

void KDatePickerPopupWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

::QVariant KDatePickerPopupWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

void KDatePickerPopupWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

void KDatePickerPopupWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

void KDatePickerPopupWrapper::leaveEvent(::QEvent * arg__1)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::leaveEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

int KDatePickerPopupWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

::QSize KDatePickerPopupWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KDatePickerPopup", funcName, gil, pyOverride);
}

void KDatePickerPopupWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

void KDatePickerPopupWrapper::mouseMoveEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mouseMoveEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

void KDatePickerPopupWrapper::mousePressEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mousePressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

void KDatePickerPopupWrapper::mouseReleaseEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mouseReleaseEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

void KDatePickerPopupWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

bool KDatePickerPopupWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KDatePickerPopup", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KDatePickerPopupWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KDatePickerPopup", funcName, gil, pyOverride);
}

void KDatePickerPopupWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KDatePickerPopupWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KDatePickerPopup", funcName, gil, pyOverride, offset);
}

void KDatePickerPopupWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

void KDatePickerPopupWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KDatePickerPopup", funcName, gil, pyOverride, visible);
}

::QPainter * KDatePickerPopupWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KDatePickerPopup", funcName, gil, pyOverride);
}

void KDatePickerPopupWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

::QSize KDatePickerPopupWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KDatePickerPopup", funcName, gil, pyOverride);
}

void KDatePickerPopupWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KDatePickerPopup", funcName, gil, pyOverride, event);
}

void KDatePickerPopupWrapper::timerEvent(::QTimerEvent * arg__1)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::timerEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

void KDatePickerPopupWrapper::wheelEvent(::QWheelEvent * arg__1)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePickerPopup_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::wheelEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KDatePickerPopup", funcName, gil, pyOverride, arg__1);
}

const QMetaObject *KDatePickerPopupWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KDatePickerPopup::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KDatePickerPopupWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KDatePickerPopup::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KDatePickerPopupWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KDatePickerPopupWrapper *>(this));
    }
    return KDatePickerPopup::qt_metacast(_clname);
}

KDatePickerPopupWrapper::~KDatePickerPopupWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KDatePickerPopup_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KDatePickerPopup_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KDatePickerPopup >()))
        return -1;

    KDatePickerPopupWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOO:KDatePickerPopup", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KDatePickerPopup::KDatePickerPopup(QFlags<KDatePickerPopup::Mode>=,QDate=,QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KDatePickerPopup(QFlags<KDatePickerPopup::Mode>,QDate,QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KDatePickerPopup_Mode_IDX])))->flagsConverter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KDatePickerPopup(QFlags<KDatePickerPopup::Mode>,QDate,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // KDatePickerPopup(QFlags<KDatePickerPopup::Mode>,QDate,QWidget*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2])))) {
                overloadId = 0; // KDatePickerPopup(QFlags<KDatePickerPopup::Mode>,QDate,QWidget*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"modes", 0}, {"date", 1}, {"parent", 2}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KDatePickerPopup_Mode_IDX])))->flagsConverter, (pyArgs[0]))))
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]);
            }
        }
        ::QFlags<KDatePickerPopup::Mode> cppArg0(KDatePickerPopup::Mode::DatePicker);
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QDate cppArg1 = QDate::currentDate();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return -1;
        ::QWidget *cppArg2 = nullptr;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KDatePickerPopup(QFlags<KDatePickerPopup::Mode>,QDate,QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KDatePickerPopupWrapper(cppArg0, cppArg1, cppArg2);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KDatePickerPopupWrapper(cppArg0, cppArg1, cppArg2);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KDatePickerPopup >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KDatePickerPopupFunc_dateMap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePickerPopup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // dateMap()const
        QMap<QDate,QString> cppResult = const_cast<const ::KDatePickerPopup *>(cppSelf)->dateMap();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QDate_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDatePickerPopupFunc_datePicker(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePickerPopup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // datePicker()const
        KDatePicker * cppResult = const_cast<const ::KDatePickerPopup *>(cppSelf)->datePicker();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDatePickerPopupFunc_modes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePickerPopup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // modes()const
        QFlags<KDatePickerPopup::Mode> cppResult = const_cast<const ::KDatePickerPopup *>(cppSelf)->modes();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KDatePickerPopup_Mode_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDatePickerPopupFunc_setDate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePickerPopup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDatePickerPopup::setDate(QDate)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArg)))) {
        overloadId = 0; // setDate(QDate)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDate cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDate(QDate)
            cppSelf->setDate(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerPopupFunc_setDateMap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePickerPopup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDatePickerPopup::setDateMap(QMap<QDate,QString>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QDate_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDateMap(QMap<QDate,QString>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDateMap", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]);

    // Call function/method
    {
        ::QMap<QDate,QString> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDateMap(QMap<QDate,QString>)
            cppSelf->setDateMap(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerPopupFunc_setDateRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePickerPopup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setDateRange", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDatePickerPopup::setDateRange(QDate,QDate)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setDateRange(QDate,QDate)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setDateRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QDate cppArg1_local;
        ::QDate *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setDateRange(QDate,QDate)
            cppSelf->setDateRange(*cppArg0, *cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerPopupFunc_setModes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePickerPopup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDatePickerPopup::setModes(QFlags<KDatePickerPopup::Mode>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KDatePickerPopup_Mode_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setModes(QFlags<KDatePickerPopup::Mode>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setModes", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]);

    // Call function/method
    {
        ::QFlags<KDatePickerPopup::Mode> cppArg0 = QFlags<KDatePickerPopup::Mode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setModes(QFlags<KDatePickerPopup::Mode>)
            cppSelf->setModes(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KDatePickerPopup_PropertyStrings[] = {
    "modes::",
    nullptr // Sentinel
};

static const char *Sbk_KDatePickerPopup_EnumFlagInfo[] = {
    "Mode:IntFlag:Modes",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KDatePickerPopup_methods[] = {
    {"dateMap", reinterpret_cast<PyCFunction>(Sbk_KDatePickerPopupFunc_dateMap), METH_NOARGS, nullptr},
    {"datePicker", reinterpret_cast<PyCFunction>(Sbk_KDatePickerPopupFunc_datePicker), METH_NOARGS, nullptr},
    {"modes", reinterpret_cast<PyCFunction>(Sbk_KDatePickerPopupFunc_modes), METH_NOARGS, nullptr},
    {"setDate", reinterpret_cast<PyCFunction>(Sbk_KDatePickerPopupFunc_setDate), METH_O, nullptr},
    {"setDateMap", reinterpret_cast<PyCFunction>(Sbk_KDatePickerPopupFunc_setDateMap), METH_O, nullptr},
    {"setDateRange", reinterpret_cast<PyCFunction>(Sbk_KDatePickerPopupFunc_setDateRange), METH_VARARGS, nullptr},
    {"setModes", reinterpret_cast<PyCFunction>(Sbk_KDatePickerPopupFunc_setModes), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KDatePickerPopup_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KDatePickerPopup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KDatePickerPopupWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KDatePickerPopup_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KDatePickerPopup_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KDatePickerPopupSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KDatePickerPopup *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]))
        return static_cast< ::QMenu *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KDatePickerPopup_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KDatePickerPopup_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KDatePickerPopup_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KDatePickerPopup_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KDatePickerPopup_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KDatePickerPopup_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KDatePickerPopup_spec = {
    "1:KWidgetsAddons.KDatePickerPopup",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KDatePickerPopup_slots
};

} //extern "C"

static void *Sbk_KDatePickerPopup_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KDatePickerPopup *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KDatePickerPopup *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KDatePickerPopup *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KDatePickerPopup_Mode(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KDatePickerPopup::Mode>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KDatePickerPopup::Mode *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KDatePickerPopup_Mode_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_Mode_IDX])))
        return Enum_PythonToCpp_KDatePickerPopup_Mode;
    return {};
}

static PyObject *KDatePickerPopup_Mode_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KDatePickerPopup::Mode>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KDatePickerPopup::Mode *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KDatePickerPopup_Mode(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KDatePickerPopup::Mode>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KDatePickerPopup::Mode> *>(cppOut) = value;

}

static PyObject *KDatePickerPopup_Mode_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KDatePickerPopup::Mode> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_Mode_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KDatePickerPopup_PythonToCpp_KDatePickerPopup_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KDatePickerPopup_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KDatePickerPopup_PythonToCpp_KDatePickerPopup_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KDatePickerPopup_TypeF()))
        return KDatePickerPopup_PythonToCpp_KDatePickerPopup_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KDatePickerPopup_PTR_CppToPython_KDatePickerPopup(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KDatePickerPopup *>(const_cast<void *>(cppIn)), Sbk_KDatePickerPopup_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KDatePickerPopup_SignatureStrings[] = {
    "KWidgetsAddons.KDatePickerPopup(self,modes:KWidgetsAddons.KDatePickerPopup.Mode=KDatePickerPopup.Mode.DatePicker,date:PySide6.QtCore.QDate=QDate.currentDate(),parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,modes:KWidgetsAddons.KDatePickerPopup.Mode=None)",
    "KWidgetsAddons.KDatePickerPopup.dateMap(self)->QMap[PySide6.QtCore.QDate, QString]",
    "KWidgetsAddons.KDatePickerPopup.datePicker(self)->KWidgetsAddons.KDatePicker",
    "KWidgetsAddons.KDatePickerPopup.modes(self)->KWidgetsAddons.KDatePickerPopup.Mode",
    "KWidgetsAddons.KDatePickerPopup.setDate(self,date:PySide6.QtCore.QDate)",
    "KWidgetsAddons.KDatePickerPopup.setDateMap(self,dateMap:QMap[PySide6.QtCore.QDate, QString])",
    "KWidgetsAddons.KDatePickerPopup.setDateRange(self,minDate:PySide6.QtCore.QDate,maxDate:PySide6.QtCore.QDate)",
    "KWidgetsAddons.KDatePickerPopup.setModes(self,modes:KWidgetsAddons.KDatePickerPopup.Mode)",
    nullptr}; // Sentinel
#else
static constexpr size_t KDatePickerPopup_SignatureByteSize = 239;
static constexpr uint8_t KDatePickerPopup_SignatureBytes[239] = {
    0x78, 0xda, 0xa5, 0x52, 0x3d, 0x0f, 0x82, 0x30, 0x14, 0xdc, 0xfd, 0x15, 0x8e, 0xd6, 0xd4, 0x8e,
    0x0e, 0x24, 0x98, 0x18, 0xd9, 0x08, 0x4a, 0x75, 0x70, 0x30, 0x0e, 0x8d, 0x7d, 0x92, 0x46, 0x68,
    0x49, 0x5b, 0xa2, 0xfc, 0x7b, 0x29, 0xe0, 0xc7, 0x20, 0x82, 0x71, 0x69, 0xee, 0xbd, 0x5e, 0x2f,
    0xf7, 0xae, 0x2f, 0xdc, 0x0b, 0x9e, 0x80, 0x35, 0x4b, 0xce, 0x95, 0x34, 0x24, 0x0c, 0x98, 0x85,
    0x58, 0x9c, 0x2e, 0xa0, 0x63, 0x95, 0x17, 0xf9, 0xc4, 0x40, 0x7a, 0xc6, 0x99, 0xe2, 0x60, 0xbc,
    0xf0, 0x3b, 0x95, 0x44, 0x15, 0xcb, 0xff, 0xd8, 0x25, 0xaf, 0x26, 0xe6, 0x15, 0xf4, 0xe2, 0x72,
    0x27, 0x38, 0xcc, 0x09, 0xb5, 0x2b, 0xa5, 0x81, 0x50, 0x77, 0xef, 0xd7, 0x27, 0x39, 0x15, 0x5a,
    0x83, 0xb4, 0x0e, 0x4f, 0x10, 0xce, 0x99, 0x2b, 0xde, 0xf8, 0xad, 0x07, 0x42, 0x1b, 0xe0, 0xcb,
    0x22, 0x4d, 0x73, 0xab, 0xf1, 0xd4, 0x0b, 0xa1, 0xbc, 0x2a, 0xcd, 0x37, 0x32, 0x2d, 0xfd, 0xb5,
    0x92, 0xf0, 0x8b, 0x6b, 0xc7, 0x47, 0xa3, 0x3e, 0xaa, 0xb3, 0x1e, 0xb1, 0x26, 0x13, 0x34, 0x5b,
    0xd0, 0x0a, 0x1f, 0x3e, 0x4d, 0x82, 0xc7, 0x74, 0x67, 0xb5, 0x90, 0xc9, 0x71, 0x90, 0x64, 0x53,
    0x3f, 0x54, 0xbb, 0x5f, 0xf4, 0x8a, 0xd5, 0x03, 0xf7, 0xeb, 0xbc, 0xe6, 0xee, 0x55, 0x34, 0xd0,
    0x7c, 0x44, 0xbd, 0x05, 0x9d, 0x3f, 0x87, 0x86, 0xea, 0x3c, 0xc2, 0xc3, 0x6d, 0x92, 0xde, 0x80,
    0x08, 0x07, 0x8b, 0x6f, 0x99, 0x4c, 0x5a, 0xa7, 0x99, 0x90, 0x41, 0x97, 0x59, 0x9c, 0xb1, 0x5b,
    0xf0, 0xd7, 0x24, 0xd1, 0x33, 0xe6, 0x1f, 0x56, 0x0c, 0x8d, 0xee, 0x0c, 0x47, 0x3e, 0x3f
};
#endif

PyTypeObject *init_KDatePickerPopup(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX].type;

    Shiboken::AutoDecRef Sbk_KDatePickerPopup_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]))));

    _Sbk_KDatePickerPopup_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KDatePickerPopup",
        "KDatePickerPopup*",
        &Sbk_KDatePickerPopup_spec,
        &Shiboken::callCppDestructor< KDatePickerPopup >,
        Sbk_KDatePickerPopup_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KDatePickerPopup_TypeF(); // references _Sbk_KDatePickerPopup_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KDatePickerPopup_SignatureStrings);
#else
    InitSignatureBytes(pyType, KDatePickerPopup_SignatureBytes, KDatePickerPopup_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KDatePickerPopup_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KDatePickerPopup_PythonToCpp_KDatePickerPopup_PTR,
        is_KDatePickerPopup_PythonToCpp_KDatePickerPopup_PTR_Convertible,
        KDatePickerPopup_PTR_CppToPython_KDatePickerPopup);

    Shiboken::Conversions::registerConverterName(converter, "KDatePickerPopup");
    Shiboken::Conversions::registerConverterName(converter, "KDatePickerPopup*");
    Shiboken::Conversions::registerConverterName(converter, "KDatePickerPopup&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KDatePickerPopup).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KDatePickerPopupWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KDatePickerPopup_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KDatePickerPopup_TypeF(), &Sbk_KDatePickerPopupSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KDatePickerPopup_TypeF(), &Sbk_KDatePickerPopup_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KDatePickerPopup_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Mode'.
    const char *Mode_Initializer[] = {
        "NoDate",
        "DatePicker",
        "Words",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Mode_InitializerValues[] = {
        uint8_t(KDatePickerPopup::Mode::NoDate),     //  0x01  1
        uint8_t(KDatePickerPopup::Mode::DatePicker), //  0x02  2
        uint8_t(KDatePickerPopup::Mode::Words)       //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KDatePickerPopup_TypeF(),
        "1:KWidgetsAddons.KDatePickerPopup.Mode",
        Mode_Initializer, Mode_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_Mode_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KDatePickerPopup_Mode_IDX].type =
        EType;
    // Register converter for enum 'KDatePickerPopup::Mode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KDatePickerPopup_Mode_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KDatePickerPopup_Mode,
            is_Enum_PythonToCpp_KDatePickerPopup_Mode_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KDatePickerPopup::Mode");
        Shiboken::Conversions::registerConverterAlias(converter, "Mode");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KDatePickerPopup_Mode_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KDatePickerPopup_Mode,
            is_Enum_PythonToCpp_KDatePickerPopup_Mode_Convertible);
        // Register converter for flag 'QFlags<KDatePickerPopup::Mode>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KDatePickerPopup::Mode>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KDatePickerPopup::Modes");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Mode' enum/flags.

    PySide::Signal::registerSignals(pyType, &::KDatePickerPopup::staticMetaObject);
    qRegisterMetaType< ::KDatePickerPopup::Mode >("KDatePickerPopup::Mode");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KDatePickerPopup::staticMetaObject, sizeof(KDatePickerPopupWrapper));

    return pyType;
}
