/* game.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_GAME_0_PROPERTY,
	GAMES_GAME_NAME_PROPERTY,
	GAMES_GAME_UID_PROPERTY,
	GAMES_GAME_URI_PROPERTY,
	GAMES_GAME_PLATFORM_PROPERTY,
	GAMES_GAME_MEDIA_SET_PROPERTY,
	GAMES_GAME_IS_FAVORITE_PROPERTY,
	GAMES_GAME_LAST_PLAYED_PROPERTY,
	GAMES_GAME_NUM_PROPERTIES
};
static GParamSpec* games_game_properties[GAMES_GAME_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	GAMES_GAME_REPLACED_SIGNAL,
	GAMES_GAME_NUM_SIGNALS
};
static guint games_game_signals[GAMES_GAME_NUM_SIGNALS] = {0};

struct _GamesGamePrivate {
	gchar* _name;
	GamesUid* _uid;
	GamesUri* _uri;
	GamesPlatform* _platform;
	GamesMediaSet* _media_set;
	gboolean _is_favorite;
	GDateTime* _last_played;
	GamesTitle* game_title;
	GamesIcon* game_icon;
	GamesCover* game_cover;
};

static gint GamesGame_private_offset;
static gpointer games_game_parent_class = NULL;

static void games_game_set_uid (GamesGame* self,
                         GamesUid* value);
static void games_game_set_uri (GamesGame* self,
                         GamesUri* value);
static void games_game_set_platform (GamesGame* self,
                              GamesPlatform* value);
static void games_game_finalize (GObject * obj);
static GType games_game_get_type_once (void);
static void _vala_games_game_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_games_game_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);

static inline gpointer
games_game_get_instance_private (GamesGame* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGame_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesGame*
games_game_construct (GType object_type,
                      GamesUid* uid,
                      GamesUri* uri,
                      GamesTitle* title,
                      GamesPlatform* platform)
{
	GamesGame * self = NULL;
	GamesTitle* _tmp0_;
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (platform != NULL, NULL);
	self = (GamesGame*) g_object_new (object_type, NULL);
	games_game_set_uid (self, uid);
	games_game_set_uri (self, uri);
	_tmp0_ = _g_object_ref0 (title);
	_g_object_unref0 (self->priv->game_title);
	self->priv->game_title = _tmp0_;
	games_game_set_platform (self, platform);
	return self;
}

GamesGame*
games_game_new (GamesUid* uid,
                GamesUri* uri,
                GamesTitle* title,
                GamesPlatform* platform)
{
	return games_game_construct (GAMES_TYPE_GAME, uid, uri, title, platform);
}

GamesIcon*
games_game_get_icon (GamesGame* self)
{
	GamesIcon* _tmp0_;
	GamesIcon* _tmp2_;
	GamesIcon* _tmp3_;
	GamesIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->game_icon;
	if (_tmp0_ == NULL) {
		GamesDummyIcon* _tmp1_;
		_tmp1_ = games_dummy_icon_new ();
		_g_object_unref0 (self->priv->game_icon);
		self->priv->game_icon = (GamesIcon*) _tmp1_;
	}
	_tmp2_ = self->priv->game_icon;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
games_game_set_icon (GamesGame* self,
                     GamesIcon* icon)
{
	GamesIcon* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon != NULL);
	_tmp0_ = _g_object_ref0 (icon);
	_g_object_unref0 (self->priv->game_icon);
	self->priv->game_icon = _tmp0_;
}

GamesCover*
games_game_get_cover (GamesGame* self)
{
	GamesCover* _tmp0_;
	GamesCover* _tmp2_;
	GamesCover* _tmp3_;
	GamesCover* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->game_cover;
	if (_tmp0_ == NULL) {
		GamesDummyCover* _tmp1_;
		_tmp1_ = games_dummy_cover_new ();
		_g_object_unref0 (self->priv->game_cover);
		self->priv->game_cover = (GamesCover*) _tmp1_;
	}
	_tmp2_ = self->priv->game_cover;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
games_game_set_cover (GamesGame* self,
                      GamesCover* cover)
{
	GamesCover* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cover != NULL);
	_tmp0_ = _g_object_ref0 (cover);
	_g_object_unref0 (self->priv->game_cover);
	self->priv->game_cover = _tmp0_;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
games_game_matches_search_terms (GamesGame* self,
                                 gchar** search_terms,
                                 gint search_terms_length1)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (search_terms_length1 != 0) {
		{
			gchar** term_collection = NULL;
			gint term_collection_length1 = 0;
			gint _term_collection_size_ = 0;
			gint term_it = 0;
			term_collection = search_terms;
			term_collection_length1 = search_terms_length1;
			for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
				gchar* _tmp0_;
				gchar* term = NULL;
				_tmp0_ = g_strdup (term_collection[term_it]);
				term = _tmp0_;
				{
					const gchar* _tmp1_;
					const gchar* _tmp2_;
					gchar* _tmp3_;
					gchar* _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gboolean _tmp8_;
					_tmp1_ = games_game_get_name (self);
					_tmp2_ = _tmp1_;
					_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) -1);
					_tmp4_ = _tmp3_;
					_tmp5_ = term;
					_tmp6_ = g_utf8_casefold (_tmp5_, (gssize) -1);
					_tmp7_ = _tmp6_;
					_tmp8_ = !string_contains (_tmp4_, _tmp7_);
					_g_free0 (_tmp7_);
					_g_free0 (_tmp4_);
					if (_tmp8_) {
						result = FALSE;
						_g_free0 (term);
						return result;
					}
					_g_free0 (term);
				}
			}
		}
	}
	result = TRUE;
	return result;
}

void
games_game_update_last_played (GamesGame* self)
{
	GTimeZone* _tmp0_;
	GTimeZone* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_time_zone_new_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_new_now (_tmp1_);
	_tmp3_ = _tmp2_;
	games_game_set_last_played (self, _tmp3_);
	_g_date_time_unref0 (_tmp3_);
	_g_time_zone_unref0 (_tmp1_);
}

guint
games_game_hash (GamesGame* key)
{
	GamesUid* _tmp0_;
	guint result;
	g_return_val_if_fail (key != NULL, 0U);
	_tmp0_ = key->priv->_uid;
	result = games_uid_hash (_tmp0_);
	return result;
}

gboolean
games_game_equal (GamesGame* a,
                  GamesGame* b)
{
	GEqualFunc _tmp0_;
	GamesUid* _tmp1_;
	GamesUid* _tmp2_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = g_direct_equal;
	if (_tmp0_ (a, b)) {
		result = TRUE;
		return result;
	}
	_tmp1_ = a->priv->_uid;
	_tmp2_ = b->priv->_uid;
	result = games_uid_equal (_tmp1_, _tmp2_);
	return result;
}

gint
games_game_compare (GamesGame* a,
                    GamesGame* b)
{
	gint ret = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GamesPlatform* _tmp4_;
	GamesPlatform* _tmp5_;
	GamesUid* _tmp6_;
	GamesUid* _tmp7_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = games_game_get_name (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_game_get_name (b);
	_tmp3_ = _tmp2_;
	ret = g_utf8_collate (_tmp1_, _tmp3_);
	if (ret != 0) {
		result = ret;
		return result;
	}
	_tmp4_ = a->priv->_platform;
	_tmp5_ = b->priv->_platform;
	ret = games_platform_compare (_tmp4_, _tmp5_);
	if (ret != 0) {
		result = ret;
		return result;
	}
	_tmp6_ = a->priv->_uid;
	_tmp7_ = b->priv->_uid;
	result = games_uid_compare (_tmp6_, _tmp7_);
	return result;
}

gint
games_game_compare_by_date_time (GamesGame* a,
                                 GamesGame* b)
{
	gboolean _tmp0_ = FALSE;
	GDateTime* _tmp1_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp1_ = a->priv->_last_played;
	if (_tmp1_ == NULL) {
		GDateTime* _tmp2_;
		_tmp2_ = b->priv->_last_played;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp3_ = a->priv->_last_played;
	if (_tmp3_ == NULL) {
		result = 1;
		return result;
	}
	_tmp4_ = b->priv->_last_played;
	if (_tmp4_ == NULL) {
		result = -1;
		return result;
	}
	_tmp5_ = b->priv->_last_played;
	_tmp6_ = a->priv->_last_played;
	result = g_date_time_compare (_tmp5_, _tmp6_);
	return result;
}

const gchar*
games_game_get_name (GamesGame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	const gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_name;
		result = _tmp1_;
		return result;
	}
	{
		gchar* _tmp2_ = NULL;
		GamesTitle* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->game_title;
		_tmp4_ = games_title_get_title (_tmp3_, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp5_;
		_g_free0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("game.vala:16: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp8_ = self->priv->_name;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp9_;
	}
	_tmp10_ = self->priv->_name;
	result = _tmp10_;
	return result;
}

GamesUid*
games_game_get_uid (GamesGame* self)
{
	GamesUid* result;
	GamesUid* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uid;
	result = _tmp0_;
	return result;
}

static void
games_game_set_uid (GamesGame* self,
                    GamesUid* value)
{
	GamesUid* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_game_get_uid (self);
	if (old_value != value) {
		GamesUid* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_uid);
		self->priv->_uid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_game_properties[GAMES_GAME_UID_PROPERTY]);
	}
}

GamesUri*
games_game_get_uri (GamesGame* self)
{
	GamesUri* result;
	GamesUri* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static gpointer
_games_uri_ref0 (gpointer self)
{
	return self ? games_uri_ref (self) : NULL;
}

static void
games_game_set_uri (GamesGame* self,
                    GamesUri* value)
{
	GamesUri* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_game_get_uri (self);
	if (old_value != value) {
		GamesUri* _tmp0_;
		_tmp0_ = _games_uri_ref0 (value);
		_games_uri_unref0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_game_properties[GAMES_GAME_URI_PROPERTY]);
	}
}

GamesPlatform*
games_game_get_platform (GamesGame* self)
{
	GamesPlatform* result;
	GamesPlatform* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_platform;
	result = _tmp0_;
	return result;
}

static void
games_game_set_platform (GamesGame* self,
                         GamesPlatform* value)
{
	GamesPlatform* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_game_get_platform (self);
	if (old_value != value) {
		GamesPlatform* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_platform);
		self->priv->_platform = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_game_properties[GAMES_GAME_PLATFORM_PROPERTY]);
	}
}

GamesMediaSet*
games_game_get_media_set (GamesGame* self)
{
	GamesMediaSet* result;
	GamesMediaSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_media_set;
	result = _tmp0_;
	return result;
}

void
games_game_set_media_set (GamesGame* self,
                          GamesMediaSet* value)
{
	GamesMediaSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_game_get_media_set (self);
	if (old_value != value) {
		GamesMediaSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_media_set);
		self->priv->_media_set = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_game_properties[GAMES_GAME_MEDIA_SET_PROPERTY]);
	}
}

gboolean
games_game_get_is_favorite (GamesGame* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_favorite;
	return result;
}

void
games_game_set_is_favorite (GamesGame* self,
                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = games_game_get_is_favorite (self);
	if (old_value != value) {
		self->priv->_is_favorite = value;
		g_object_notify_by_pspec ((GObject *) self, games_game_properties[GAMES_GAME_IS_FAVORITE_PROPERTY]);
	}
}

GDateTime*
games_game_get_last_played (GamesGame* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_last_played;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
games_game_set_last_played (GamesGame* self,
                            GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_game_get_last_played (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_last_played);
		self->priv->_last_played = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_game_properties[GAMES_GAME_LAST_PLAYED_PROPERTY]);
	}
}

static void
games_game_class_init (GamesGameClass * klass,
                       gpointer klass_data)
{
	games_game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGame_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_NAME_PROPERTY, games_game_properties[GAMES_GAME_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_UID_PROPERTY, games_game_properties[GAMES_GAME_UID_PROPERTY] = g_param_spec_object ("uid", "uid", "uid", GAMES_TYPE_UID, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_URI_PROPERTY, games_game_properties[GAMES_GAME_URI_PROPERTY] = games_param_spec_uri ("uri", "uri", "uri", GAMES_TYPE_URI, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_PLATFORM_PROPERTY, games_game_properties[GAMES_GAME_PLATFORM_PROPERTY] = g_param_spec_object ("platform", "platform", "platform", GAMES_TYPE_PLATFORM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_MEDIA_SET_PROPERTY, games_game_properties[GAMES_GAME_MEDIA_SET_PROPERTY] = g_param_spec_object ("media-set", "media-set", "media-set", GAMES_TYPE_MEDIA_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_IS_FAVORITE_PROPERTY, games_game_properties[GAMES_GAME_IS_FAVORITE_PROPERTY] = g_param_spec_boolean ("is-favorite", "is-favorite", "is-favorite", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_LAST_PLAYED_PROPERTY, games_game_properties[GAMES_GAME_LAST_PLAYED_PROPERTY] = g_param_spec_boxed ("last-played", "last-played", "last-played", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	games_game_signals[GAMES_GAME_REPLACED_SIGNAL] = g_signal_new ("replaced", GAMES_TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GAMES_TYPE_GAME);
}

static void
games_game_instance_init (GamesGame * self,
                          gpointer klass)
{
	self->priv = games_game_get_instance_private (self);
}

static void
games_game_finalize (GObject * obj)
{
	GamesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAME, GamesGame);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_uid);
	_games_uri_unref0 (self->priv->_uri);
	_g_object_unref0 (self->priv->_platform);
	_g_object_unref0 (self->priv->_media_set);
	_g_date_time_unref0 (self->priv->_last_played);
	_g_object_unref0 (self->priv->game_title);
	_g_object_unref0 (self->priv->game_icon);
	_g_object_unref0 (self->priv->game_cover);
	G_OBJECT_CLASS (games_game_parent_class)->finalize (obj);
}

static GType
games_game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGame), 0, (GInstanceInitFunc) games_game_instance_init, NULL };
	GType games_game_type_id;
	games_game_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesGame", &g_define_type_info, 0);
	GamesGame_private_offset = g_type_add_instance_private (games_game_type_id, sizeof (GamesGamePrivate));
	return games_game_type_id;
}

GType
games_game_get_type (void)
{
	static volatile gsize games_game_type_id__once = 0;
	if (g_once_init_enter (&games_game_type_id__once)) {
		GType games_game_type_id;
		games_game_type_id = games_game_get_type_once ();
		g_once_init_leave (&games_game_type_id__once, games_game_type_id);
	}
	return games_game_type_id__once;
}

static void
_vala_games_game_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	GamesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAME, GamesGame);
	switch (property_id) {
		case GAMES_GAME_NAME_PROPERTY:
		g_value_set_string (value, games_game_get_name (self));
		break;
		case GAMES_GAME_UID_PROPERTY:
		g_value_set_object (value, games_game_get_uid (self));
		break;
		case GAMES_GAME_URI_PROPERTY:
		games_value_set_uri (value, games_game_get_uri (self));
		break;
		case GAMES_GAME_PLATFORM_PROPERTY:
		g_value_set_object (value, games_game_get_platform (self));
		break;
		case GAMES_GAME_MEDIA_SET_PROPERTY:
		g_value_set_object (value, games_game_get_media_set (self));
		break;
		case GAMES_GAME_IS_FAVORITE_PROPERTY:
		g_value_set_boolean (value, games_game_get_is_favorite (self));
		break;
		case GAMES_GAME_LAST_PLAYED_PROPERTY:
		g_value_set_boxed (value, games_game_get_last_played (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_game_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	GamesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAME, GamesGame);
	switch (property_id) {
		case GAMES_GAME_UID_PROPERTY:
		games_game_set_uid (self, g_value_get_object (value));
		break;
		case GAMES_GAME_URI_PROPERTY:
		games_game_set_uri (self, games_value_get_uri (value));
		break;
		case GAMES_GAME_PLATFORM_PROPERTY:
		games_game_set_platform (self, g_value_get_object (value));
		break;
		case GAMES_GAME_MEDIA_SET_PROPERTY:
		games_game_set_media_set (self, g_value_get_object (value));
		break;
		case GAMES_GAME_IS_FAVORITE_PROPERTY:
		games_game_set_is_favorite (self, g_value_get_boolean (value));
		break;
		case GAMES_GAME_LAST_PLAYED_PROPERTY:
		games_game_set_last_played (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

