// Generated from libavcodec/vulkan/ffv1_reset.comp
const char *ff_source_ffv1_reset_comp =
"/*\n"
" * FFv1 codec\n"
" *\n"
" * Copyright (c) 2024 Lynne <dev@lynne.ee>\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"void main(void)\n"
"{\n"
"    const uint slice_idx = gl_WorkGroupID.y*gl_NumWorkGroups.x + gl_WorkGroupID.x;\n"
"\n"
"    if (key_frame == 0 &&\n"
"        slice_ctx[slice_idx].slice_reset_contexts == false)\n"
"        return;\n"
"\n"
"    const uint8_t qidx = slice_ctx[slice_idx].quant_table_idx[gl_WorkGroupID.z];\n"
"    uint contexts = context_count[qidx];\n"
"    uint64_t slice_state_off = uint64_t(slice_state) +\n"
"                               slice_idx*plane_state_size*codec_planes;\n"
"\n"
"#ifdef GOLOMB\n"
"    uint64_t start = slice_state_off +\n"
"                     (gl_WorkGroupID.z*(plane_state_size/VLC_STATE_SIZE) + gl_LocalInvocationID.x)*VLC_STATE_SIZE;\n"
"    for (uint x = gl_LocalInvocationID.x; x < contexts; x += gl_WorkGroupSize.x) {\n"
"        VlcState sb = VlcState(start);\n"
"        sb.drift     =  int16_t(0);\n"
"        sb.error_sum = uint16_t(4);\n"
"        sb.bias      =   int8_t(0);\n"
"        sb.count     =  uint8_t(1);\n"
"        start += gl_WorkGroupSize.x*VLC_STATE_SIZE;\n"
"    }\n"
"#else\n"
"    uint64_t start = slice_state_off +\n"
"                     gl_WorkGroupID.z*plane_state_size +\n"
"                     (gl_LocalInvocationID.x << 2 /* dwords */); /* Bytes */\n"
"    uint count_total = contexts*(CONTEXT_SIZE /* bytes */ >> 2 /* dwords */);\n"
"    for (uint x = gl_LocalInvocationID.x; x < count_total; x += gl_WorkGroupSize.x) {\n"
"        u32buf(start).v = 0x80808080;\n"
"        start += gl_WorkGroupSize.x*(CONTEXT_SIZE >> 3 /* 1/8th of context */);\n"
"    }\n"
"#endif\n"
"}\n"
;
