/* BackendRemote.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackendRemote.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Canonical Ltd
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <errno.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DEJA_DUP_BACKEND_REMOTE_0_PROPERTY,
	DEJA_DUP_BACKEND_REMOTE_NUM_PROPERTIES
};
static GParamSpec* deja_dup_backend_remote_properties[DEJA_DUP_BACKEND_REMOTE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupBackendRemoteIsReadyData DejaDupBackendRemoteIsReadyData;
typedef struct _Block2Data Block2Data;

#define DEJA_DUP_TYPE_BACKEND_ERROR (deja_dup_backend_error_get_type ())
typedef struct _DejaDupBackendRemoteMountData DejaDupBackendRemoteMountData;

struct _DejaDupBackendRemoteIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRemote* self;
	gchar* reason;
	gchar* message;
	gboolean result;
	GFile* root;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GFile* _tmp3_;
	GMountOperation* _tmp4_;
	GMountOperation* _tmp5_;
	GFile* _tmp6_;
	GFileInfo* _tmp7_;
	GFileInfo* _tmp8_;
	GError* e;
	GFile* _tmp9_;
	GError* _tmp10_;
	gchar* _tmp11_;
	GError* _vala1_e;
	GFile* _tmp12_;
	GError* _tmp13_;
	gchar* _tmp14_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	DejaDupBackendRemote* self;
	gpointer _async_data_;
};

typedef enum  {
	DEJA_DUP_BACKEND_ERROR_MOUNT_OP_NEEDED
} DejaDupBackendError;
#define DEJA_DUP_BACKEND_ERROR deja_dup_backend_error_quark ()

struct _DejaDupBackendRemoteMountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRemote* self;
	gboolean result;
	Block2Data* _data2_;
	DejaDupNetwork* _tmp0_;
	DejaDupNetwork* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gulong sigid;
	DejaDupNetwork* _tmp5_;
	DejaDupNetwork* _tmp6_;
	gulong _tmp7_;
	gulong _tmp8_;
	DejaDupNetwork* _tmp9_;
	DejaDupNetwork* _tmp10_;
	GFile* root;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GError* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	GError* _tmp18_;
	GFile* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _tmp28_;
	GError* _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gboolean _tmp33_;
	gchar* orig_uri;
	GSettings* _tmp34_;
	GSettings* _tmp35_;
	gchar* _tmp36_;
	gchar* scheme;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gboolean _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GError* _tmp46_;
	GError* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GError* _tmp51_;
	GError* _tmp52_;
	gboolean _tmp53_;
	GFile* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gboolean _tmp57_;
	GFile* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar** _tmp61_;
	gchar** _tmp62_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	GError* _tmp64_;
	GFile* _tmp65_;
	GMountOperation* _tmp66_;
	GMountOperation* _tmp67_;
	GFile* _tmp68_;
	GError* _tmp69_;
	GError* _tmp70_;
	GFile* _tmp71_;
	GError* _inner_error0_;
};

static gpointer deja_dup_backend_remote_parent_class = NULL;

VALA_EXTERN GFile* deja_dup_backend_file_get_file_from_settings (DejaDupBackendFile* self);
static gchar* deja_dup_backend_remote_real_get_folder (DejaDupBackendRemote* self);
static GFile* deja_dup_backend_remote_real_get_root_from_settings (DejaDupBackendFile* base);
static GFile* deja_dup_backend_remote_real_get_file_from_settings (DejaDupBackendFile* base);
static gboolean deja_dup_backend_remote_real_is_native (DejaDupBackend* base);
static gchar* deja_dup_backend_remote_get_unready_message (DejaDupBackendRemote* self,
                                                    GFile* root,
                                                    GError* e);
static void deja_dup_backend_remote_real_is_ready_data_free (gpointer _data);
static void deja_dup_backend_remote_real_is_ready (DejaDupBackend* base,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean deja_dup_backend_remote_real_is_ready_co (DejaDupBackendRemoteIsReadyData* _data_);
static void deja_dup_backend_remote_is_ready_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static GIcon* deja_dup_backend_remote_real_get_icon (DejaDupBackend* base);
static void deja_dup_backend_remote_real_mount_data_free (gpointer _data);
static void deja_dup_backend_remote_real_mount (DejaDupBackendFile* base,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean deja_dup_backend_remote_real_mount_co (DejaDupBackendRemoteMountData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda9_ (Block2Data* _data2_);
static void ____lambda9__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void deja_dup_backend_remote_mount_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
VALA_EXTERN GQuark deja_dup_backend_error_quark (void);
VALA_EXTERN GType deja_dup_backend_error_get_type (void) G_GNUC_CONST ;
static GType deja_dup_backend_remote_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DejaDupBackendRemote*
deja_dup_backend_remote_construct (GType object_type,
                                   GSettings* settings)
{
	DejaDupBackendRemote * self = NULL;
	GSettings* _tmp0_ = NULL;
	if (settings != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = _g_object_ref0 (settings);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		DejaDupFilteredSettings* _tmp2_;
		_tmp2_ = deja_dup_get_settings (DEJA_DUP_REMOTE_ROOT);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (GSettings*) _tmp2_;
	}
	self = (DejaDupBackendRemote*) g_object_new (object_type, "kind", DEJA_DUP_BACKEND_KIND_GVFS, "settings", _tmp0_, NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}

DejaDupBackendRemote*
deja_dup_backend_remote_new (GSettings* settings)
{
	return deja_dup_backend_remote_construct (DEJA_DUP_TYPE_BACKEND_REMOTE, settings);
}

static gchar*
deja_dup_backend_remote_real_get_folder (DejaDupBackendRemote* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = deja_dup_backend_get_settings ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_get_folder_key (_tmp1_, DEJA_DUP_REMOTE_FOLDER_KEY, TRUE);
	result = _tmp2_;
	return result;
}

gchar*
deja_dup_backend_remote_get_folder (DejaDupBackendRemote* self)
{
	DejaDupBackendRemoteClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = DEJA_DUP_BACKEND_REMOTE_GET_CLASS (self);
	if (_klass_->get_folder) {
		return _klass_->get_folder (self);
	}
	return NULL;
}

static GFile*
deja_dup_backend_remote_real_get_root_from_settings (DejaDupBackendFile* base)
{
	DejaDupBackendRemote * self;
	gchar* uri = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	self = (DejaDupBackendRemote*) base;
	_tmp0_ = deja_dup_backend_get_settings ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_get_string (_tmp1_, DEJA_DUP_REMOTE_URI_KEY);
	uri = _tmp2_;
	_tmp3_ = g_file_parse_name (uri);
	result = _tmp3_;
	_g_free0 (uri);
	return result;
}

static GFile*
deja_dup_backend_remote_real_get_file_from_settings (DejaDupBackendFile* base)
{
	DejaDupBackendRemote * self;
	GFile* root = NULL;
	GFile* _tmp0_;
	gchar* folder = NULL;
	gchar* _tmp1_;
	GFile* _tmp15_;
	const gchar* _tmp16_;
	GFile* _tmp17_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	self = (DejaDupBackendRemote*) base;
	_tmp0_ = deja_dup_backend_file_get_root_from_settings ((DejaDupBackendFile*) self);
	root = _tmp0_;
	_tmp1_ = deja_dup_backend_remote_get_folder (self);
	folder = _tmp1_;
	{
		GMount* mount = NULL;
		GFile* _tmp2_;
		GMount* _tmp3_;
		GFile* mount_root = NULL;
		GMount* _tmp4_;
		GFile* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp2_ = root;
		_tmp3_ = g_file_find_enclosing_mount (_tmp2_, NULL, &_inner_error0_);
		mount = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_MOUNTED)) {
				goto __catch0_g_io_error_not_mounted;
			}
			goto __catch0_g_error;
		}
		_tmp4_ = mount;
		_tmp5_ = g_mount_get_root (_tmp4_);
		mount_root = _tmp5_;
		_tmp7_ = root;
		_tmp8_ = mount_root;
		if (g_file_equal (_tmp7_, _tmp8_)) {
			_tmp6_ = TRUE;
		} else {
			GFile* _tmp9_;
			GFile* _tmp10_;
			_tmp9_ = root;
			_tmp10_ = mount_root;
			_tmp6_ = !g_file_has_prefix (_tmp9_, _tmp10_);
		}
		if (_tmp6_) {
			GMount* _tmp11_;
			GFile* _tmp12_;
			_tmp11_ = mount;
			_tmp12_ = g_mount_get_default_location (_tmp11_);
			_g_object_unref0 (root);
			root = _tmp12_;
		}
		_g_object_unref0 (mount_root);
		_g_object_unref0 (mount);
	}
	goto __finally0;
	__catch0_g_io_error_not_mounted:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("BackendRemote.vala:71: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (folder);
		_g_object_unref0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp15_ = root;
	_tmp16_ = folder;
	_tmp17_ = g_file_resolve_relative_path (_tmp15_, _tmp16_);
	result = _tmp17_;
	_g_free0 (folder);
	_g_object_unref0 (root);
	return result;
}

static gboolean
deja_dup_backend_remote_real_is_native (DejaDupBackend* base)
{
	DejaDupBackendRemote * self;
	gboolean result;
	self = (DejaDupBackendRemote*) base;
	result = FALSE;
	return result;
}

static gchar*
deja_dup_backend_remote_get_unready_message (DejaDupBackendRemote* self,
                                             GFile* root,
                                             GError* e)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (root != NULL, NULL);
	g_return_val_if_fail (e != NULL, NULL);
	_tmp0_ = g_file_get_uri_scheme (root);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "smb") == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean egain_error = FALSE;
		gboolean invalid_arg_error = FALSE;
		gboolean _tmp4_ = FALSE;
		if (errno == EAGAIN) {
			_tmp3_ = g_error_matches (e, g_io_error_quark (), 0);
		} else {
			_tmp3_ = FALSE;
		}
		egain_error = _tmp3_;
		invalid_arg_error = g_error_matches (e, g_io_error_quark (), G_IO_ERROR_INVALID_ARGUMENT);
		if (egain_error) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = invalid_arg_error;
		}
		if (_tmp4_) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("The network server is not available"));
			result = _tmp5_;
			return result;
		}
	}
	_tmp6_ = e->message;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	return result;
}

static void
deja_dup_backend_remote_real_is_ready_data_free (gpointer _data)
{
	DejaDupBackendRemoteIsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRemoteIsReadyData, _data_);
}

static void
deja_dup_backend_remote_real_is_ready (DejaDupBackend* base,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	DejaDupBackendRemote * self;
	DejaDupBackendRemoteIsReadyData* _data_;
	DejaDupBackendRemote* _tmp0_;
	self = (DejaDupBackendRemote*) base;
	_data_ = g_slice_new0 (DejaDupBackendRemoteIsReadyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_remote_real_is_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_remote_real_is_ready_co (_data_);
}

static gboolean
deja_dup_backend_remote_is_ready_finish (DejaDupBackend* base,
                                         GAsyncResult* _res_,
                                         gchar** reason,
                                         gchar** message)
{
	gboolean result;
	DejaDupBackendRemoteIsReadyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (reason) {
		*reason = _data_->reason;
	} else {
		_g_free0 (_data_->reason);
	}
	_data_->reason = NULL;
	if (message) {
		*message = _data_->message;
	} else {
		_g_free0 (_data_->message);
	}
	_data_->message = NULL;
	result = _data_->result;
	return result;
}

static void
deja_dup_backend_remote_is_ready_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	DejaDupBackendRemoteIsReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_remote_real_is_ready_co (_data_);
}

static gboolean
deja_dup_backend_remote_real_is_ready_co (DejaDupBackendRemoteIsReadyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_file_get_root_from_settings ((DejaDupBackendFile*) _data_->self);
	_data_->root = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup ("remote-mounted");
	_g_free0 (_data_->reason);
	_data_->reason = _data_->_tmp1_;
	_g_free0 (_data_->message);
	_data_->message = NULL;
	{
		_data_->_tmp3_ = _data_->root;
		_data_->_tmp4_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) _data_->self);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_state_ = 1;
		g_file_mount_enclosing_volume (_data_->_tmp3_, G_MOUNT_MOUNT_NONE, _data_->_tmp5_, NULL, deja_dup_backend_remote_is_ready_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = g_file_mount_enclosing_volume_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_ALREADY_MOUNTED)) {
				goto __catch0_g_io_error_already_mounted;
			}
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_FAILED_HANDLED)) {
				goto __catch0_g_io_error_failed_handled;
			}
			goto __catch0_g_error;
		}
		_data_->result = _data_->_tmp2_;
		_g_object_unref0 (_data_->root);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_io_error_already_mounted:
	{
		g_clear_error (&_data_->_inner_error0_);
		{
			_data_->_tmp6_ = _data_->root;
			_data_->_state_ = 2;
			g_file_query_info_async (_data_->_tmp6_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, G_PRIORITY_LOW, NULL, deja_dup_backend_remote_is_ready_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp7_ = g_file_query_info_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp8_ = _data_->_tmp7_;
			_g_object_unref0 (_data_->_tmp8_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->result = TRUE;
			_g_object_unref0 (_data_->root);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp9_ = _data_->root;
			_data_->_tmp10_ = _data_->e;
			_data_->_tmp11_ = deja_dup_backend_remote_get_unready_message (_data_->self, _data_->_tmp9_, _data_->_tmp10_);
			_g_free0 (_data_->message);
			_data_->message = _data_->_tmp11_;
			_data_->result = FALSE;
			_g_error_free0 (_data_->e);
			_g_object_unref0 (_data_->root);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally1:
		_g_object_unref0 (_data_->root);
		_g_free0 (_data_->reason);
		_g_free0 (_data_->message);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_io_error_failed_handled:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = TRUE;
		_g_object_unref0 (_data_->root);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->root;
		_data_->_tmp13_ = _data_->_vala1_e;
		_data_->_tmp14_ = deja_dup_backend_remote_get_unready_message (_data_->self, _data_->_tmp12_, _data_->_tmp13_);
		_g_free0 (_data_->message);
		_data_->message = _data_->_tmp14_;
		_data_->result = FALSE;
		_g_error_free0 (_data_->_vala1_e);
		_g_object_unref0 (_data_->root);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_g_object_unref0 (_data_->root);
	_g_free0 (_data_->reason);
	_g_free0 (_data_->message);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GIcon*
deja_dup_backend_remote_real_get_icon (DejaDupBackend* base)
{
	DejaDupBackendRemote * self;
	GError* _inner_error0_ = NULL;
	GIcon* result;
	self = (DejaDupBackendRemote*) base;
	{
		GIcon* _tmp0_ = NULL;
		GIcon* _tmp1_;
		GIcon* _tmp2_;
		_tmp1_ = g_icon_new_for_string ("network-server", &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("BackendRemote.vala:145: %s", _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
deja_dup_backend_remote_check_fuse (DejaDupBackendRemote* self,
                                    GFile* root,
                                    GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	_tmp0_ = g_file_get_path (root);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "%s", _ ("You must first install FUSE support for GVfs, " "likely provided by the gvfs-fuse package. " "Then log out, log back in, and try again."));
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
deja_dup_backend_remote_real_mount_data_free (gpointer _data)
{
	DejaDupBackendRemoteMountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRemoteMountData, _data_);
}

static void
deja_dup_backend_remote_real_mount (DejaDupBackendFile* base,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	DejaDupBackendRemote * self;
	DejaDupBackendRemoteMountData* _data_;
	DejaDupBackendRemote* _tmp0_;
	self = (DejaDupBackendRemote*) base;
	_data_ = g_slice_new0 (DejaDupBackendRemoteMountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_remote_real_mount_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_remote_real_mount_co (_data_);
}

static gboolean
deja_dup_backend_remote_mount_finish (DejaDupBackendFile* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	gboolean result;
	DejaDupBackendRemoteMountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		DejaDupBackendRemote* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
___lambda9_ (Block2Data* _data2_)
{
	DejaDupBackendRemote* self;
	DejaDupNetwork* _tmp0_;
	DejaDupNetwork* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	self = _data2_->self;
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_network_get_connected (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		deja_dup_backend_remote_real_mount_co (_data2_->_async_data_);
	}
}

static void
____lambda9__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	___lambda9_ (self);
}

static void
deja_dup_backend_remote_mount_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	DejaDupBackendRemoteMountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_remote_real_mount_co (_data_);
}

static gboolean
deja_dup_backend_remote_real_mount_co (DejaDupBackendRemoteMountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = deja_dup_network_get ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = deja_dup_network_get_connected (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = !_data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp1_);
	if (_data_->_tmp4_) {
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "pause-op", _ ("Storage location not available"), _ ("Waiting for a network connection…"));
		_data_->_tmp5_ = deja_dup_network_get ();
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = g_signal_connect_data ((GObject*) _data_->_tmp6_, "notify::connected", (GCallback) ____lambda9__g_object_notify, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
		_data_->_tmp8_ = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp6_);
		_data_->sigid = _data_->_tmp8_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp9_ = deja_dup_network_get ();
		_data_->_tmp10_ = _data_->_tmp9_;
		g_signal_handler_disconnect ((GObject*) _data_->_tmp10_, _data_->sigid);
		_g_object_unref0 (_data_->_tmp10_);
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "pause-op", NULL, NULL);
	}
	_data_->_tmp11_ = deja_dup_backend_file_get_root_from_settings ((DejaDupBackendFile*) _data_->self);
	_data_->root = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->root;
	if (_data_->_tmp12_ == NULL) {
		_data_->_tmp13_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "%s", _ ("Could not mount storage location."));
		_data_->_inner_error0_ = _data_->_tmp13_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->root);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->root;
	_data_->_tmp15_ = g_file_get_uri (_data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = g_strcmp0 (_data_->_tmp16_, "") == 0;
	_g_free0 (_data_->_tmp16_);
	if (_data_->_tmp17_) {
		_data_->_tmp18_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "%s", _ ("The server’s network location needs to be specified in the storage loc" \
"ation preferences."));
		_data_->_inner_error0_ = _data_->_tmp18_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->root);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->root;
	_data_->_tmp20_ = g_file_get_uri_scheme (_data_->_tmp19_);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = _data_->_tmp21_ == NULL;
	_g_free0 (_data_->_tmp21_);
	if (_data_->_tmp22_) {
		_data_->_tmp23_ = _data_->root;
		_data_->_tmp24_ = g_file_get_uri (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = g_strdup_printf (_ ("The server’s network location ‘%s’ does not look like a network locati" \
"on."), _data_->_tmp25_);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp28_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "%s", _data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		_g_free0 (_data_->_tmp27_);
		_g_free0 (_data_->_tmp25_);
		_data_->_inner_error0_ = _data_->_tmp29_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->root);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp30_ = _data_->root;
	_data_->_tmp31_ = g_file_get_uri_scheme (_data_->_tmp30_);
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = g_strcmp0 (_data_->_tmp32_, "file") == 0;
	_g_free0 (_data_->_tmp32_);
	if (_data_->_tmp33_) {
		_data_->_tmp34_ = deja_dup_backend_get_settings ((DejaDupBackend*) _data_->self);
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->_tmp36_ = g_settings_get_string (_data_->_tmp35_, DEJA_DUP_REMOTE_URI_KEY);
		_data_->orig_uri = _data_->_tmp36_;
		_data_->_tmp37_ = _data_->orig_uri;
		_data_->_tmp38_ = g_uri_peek_scheme (_data_->_tmp37_);
		_data_->_tmp39_ = g_strdup (_data_->_tmp38_);
		_data_->scheme = _data_->_tmp39_;
		_data_->_tmp41_ = _data_->scheme;
		if (_data_->_tmp41_ == NULL) {
			_data_->_tmp40_ = TRUE;
		} else {
			_data_->_tmp42_ = _data_->scheme;
			_data_->_tmp40_ = g_strcmp0 (_data_->_tmp42_, "file") == 0;
		}
		if (_data_->_tmp40_) {
			_data_->_tmp43_ = _data_->orig_uri;
			_data_->_tmp44_ = g_strdup_printf (_ ("‘%s’ does not appear to be a network location."), _data_->_tmp43_);
			_data_->_tmp45_ = _data_->_tmp44_;
			_data_->_tmp46_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "%s", _data_->_tmp45_);
			_data_->_tmp47_ = _data_->_tmp46_;
			_g_free0 (_data_->_tmp45_);
			_data_->_inner_error0_ = _data_->_tmp47_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->scheme);
			_g_free0 (_data_->orig_uri);
			_g_object_unref0 (_data_->root);
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp48_ = _data_->scheme;
		_data_->_tmp49_ = g_strdup_printf (_ ("You must first install a gvfs backend that can connect to ‘%s’ network" \
" locations."), _data_->_tmp48_);
		_data_->_tmp50_ = _data_->_tmp49_;
		_data_->_tmp51_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "%s", _data_->_tmp50_);
		_data_->_tmp52_ = _data_->_tmp51_;
		_g_free0 (_data_->_tmp50_);
		_data_->_inner_error0_ = _data_->_tmp52_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->scheme);
		_g_free0 (_data_->orig_uri);
		_g_object_unref0 (_data_->root);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp54_ = _data_->root;
	_data_->_tmp55_ = g_file_get_uri_scheme (_data_->_tmp54_);
	_data_->_tmp56_ = _data_->_tmp55_;
	_data_->_tmp57_ = g_strcmp0 (_data_->_tmp56_, "smb") == 0;
	_g_free0 (_data_->_tmp56_);
	if (_data_->_tmp57_) {
		_data_->_tmp58_ = _data_->root;
		_data_->_tmp59_ = g_file_get_uri (_data_->_tmp58_);
		_data_->_tmp60_ = _data_->_tmp59_;
		_data_->_tmp62_ = _data_->_tmp61_ = g_strsplit (_data_->_tmp60_, "/", 0);
		_data_->_tmp63_ = _data_->_tmp62_;
		_data_->_tmp63__length1 = _vala_array_length (_data_->_tmp61_);
		_data_->_tmp53_ = _vala_array_length (_data_->_tmp61_) < 5;
		_data_->_tmp63_ = (_vala_array_free (_data_->_tmp63_, _data_->_tmp63__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->_tmp60_);
	} else {
		_data_->_tmp53_ = FALSE;
	}
	if (_data_->_tmp53_) {
		_data_->_tmp64_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "%s", _ ("Samba network locations must include both a hostname and a share name."));
		_data_->_inner_error0_ = _data_->_tmp64_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->root);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp65_ = _data_->root;
		_data_->_tmp66_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) _data_->self);
		_data_->_tmp67_ = _data_->_tmp66_;
		_data_->_state_ = 2;
		g_file_mount_enclosing_volume (_data_->_tmp65_, G_MOUNT_MOUNT_NONE, _data_->_tmp67_, NULL, deja_dup_backend_remote_mount_ready, _data_);
		return FALSE;
		_state_2:
		g_file_mount_enclosing_volume_finish (_data_->_tmp65_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_ALREADY_MOUNTED)) {
				goto __catch0_g_io_error_already_mounted;
			}
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_FAILED_HANDLED)) {
				goto __catch0_g_io_error_failed_handled;
			}
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED)) {
				goto __catch0_g_io_error_permission_denied;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_g_io_error_already_mounted:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp68_ = _data_->root;
		deja_dup_backend_remote_check_fuse (_data_->self, _data_->_tmp68_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_data_->result = FALSE;
		_g_object_unref0 (_data_->root);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_io_error_failed_handled:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp69_ = g_error_new_literal (DEJA_DUP_BACKEND_ERROR, DEJA_DUP_BACKEND_ERROR_MOUNT_OP_NEEDED, "");
		_data_->_inner_error0_ = _data_->_tmp69_;
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_io_error_permission_denied:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp70_ = g_error_new_literal (DEJA_DUP_BACKEND_ERROR, DEJA_DUP_BACKEND_ERROR_MOUNT_OP_NEEDED, "");
		_data_->_inner_error0_ = _data_->_tmp70_;
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->root);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp71_ = _data_->root;
	deja_dup_backend_remote_check_fuse (_data_->self, _data_->_tmp71_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->root);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = FALSE;
	_g_object_unref0 (_data_->root);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_remote_class_init (DejaDupBackendRemoteClass * klass,
                                    gpointer klass_data)
{
	deja_dup_backend_remote_parent_class = g_type_class_peek_parent (klass);
	((DejaDupBackendRemoteClass *) klass)->get_folder = (gchar* (*) (DejaDupBackendRemote*)) deja_dup_backend_remote_real_get_folder;
	((DejaDupBackendFileClass *) klass)->get_root_from_settings = (GFile* (*) (DejaDupBackendFile*)) deja_dup_backend_remote_real_get_root_from_settings;
	((DejaDupBackendFileClass *) klass)->get_file_from_settings = (GFile* (*) (DejaDupBackendFile*)) deja_dup_backend_remote_real_get_file_from_settings;
	((DejaDupBackendClass *) klass)->is_native = (gboolean (*) (DejaDupBackend*)) deja_dup_backend_remote_real_is_native;
	((DejaDupBackendClass *) klass)->is_ready = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_remote_real_is_ready;
	((DejaDupBackendClass *) klass)->is_ready_finish = (gboolean (*) (DejaDupBackend*, GAsyncResult*, gchar**, gchar**)) deja_dup_backend_remote_is_ready_finish;
	((DejaDupBackendClass *) klass)->get_icon = (GIcon* (*) (DejaDupBackend*)) deja_dup_backend_remote_real_get_icon;
	((DejaDupBackendFileClass *) klass)->mount = (void (*) (DejaDupBackendFile*, GAsyncReadyCallback, gpointer)) deja_dup_backend_remote_real_mount;
	((DejaDupBackendFileClass *) klass)->mount_finish = (gboolean (*) (DejaDupBackendFile*, GAsyncResult*, GError**)) deja_dup_backend_remote_mount_finish;
}

static void
deja_dup_backend_remote_instance_init (DejaDupBackendRemote * self,
                                       gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
deja_dup_backend_remote_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendRemoteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_remote_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendRemote), 0, (GInstanceInitFunc) deja_dup_backend_remote_instance_init, NULL };
	GType deja_dup_backend_remote_type_id;
	deja_dup_backend_remote_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND_FILE, "DejaDupBackendRemote", &g_define_type_info, 0);
	return deja_dup_backend_remote_type_id;
}

GType
deja_dup_backend_remote_get_type (void)
{
	static gsize deja_dup_backend_remote_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_backend_remote_type_id__once)) {
		GType deja_dup_backend_remote_type_id;
		deja_dup_backend_remote_type_id = deja_dup_backend_remote_get_type_once ();
		g_once_init_leave (&deja_dup_backend_remote_type_id__once, deja_dup_backend_remote_type_id);
	}
	return deja_dup_backend_remote_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

