/* config.c generated by valac 0.56.17, the Vala compiler
 * generated from config.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
enum  {
	CONFIG_CONFIG_0_PROPERTY,
	CONFIG_CONFIG_NUM_PROPERTIES
};
static GParamSpec* config_config_properties[CONFIG_CONFIG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	CONFIG_CONFIG_UPDATE_SIGNAL,
	CONFIG_CONFIG_NUM_SIGNALS
};
static guint config_config_signals[CONFIG_CONFIG_NUM_SIGNALS] = {0};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

static gpointer config_config_parent_class = NULL;

VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN gchar* utils_get_config_file_path (const gchar* config_name);
VALA_EXTERN ConfigConfig* config_config_new (void);
VALA_EXTERN ConfigConfig* config_config_construct (GType object_type);
gchar* font_match (const gchar* family);
VALA_EXTERN void config_config_init_config (ConfigConfig* self);
VALA_EXTERN void config_config_load_config (ConfigConfig* self);
VALA_EXTERN void config_config_save (ConfigConfig* self);
VALA_EXTERN void config_config_check_string (ConfigConfig* self,
                                 const gchar* group,
                                 const gchar* key,
                                 const gchar* value);
VALA_EXTERN void config_config_check_font (ConfigConfig* self,
                               const gchar* group,
                               const gchar* key,
                               const gchar* value);
gchar** list_mono_or_dot_fonts (gint* num,
                                gint* result_length1);
VALA_EXTERN void config_config_check_integer (ConfigConfig* self,
                                  const gchar* group,
                                  const gchar* key,
                                  gint value);
VALA_EXTERN void config_config_check_double (ConfigConfig* self,
                                 const gchar* group,
                                 const gchar* key,
                                 gdouble value);
VALA_EXTERN void config_config_check_boolean (ConfigConfig* self,
                                  const gchar* group,
                                  const gchar* key,
                                  gboolean value);
VALA_EXTERN void config_config_check_config (ConfigConfig* self);
VALA_EXTERN void config_config_load_temp_theme (ConfigConfig* self,
                                    const gchar* theme_name);
VALA_EXTERN void config_config_update_theme (ConfigConfig* self,
                                 const gchar* theme_name);
VALA_EXTERN void config_config_set_theme (ConfigConfig* self,
                              const gchar* theme_name);
VALA_EXTERN gchar* utils_get_theme_path (const gchar* theme_name);
VALA_EXTERN gboolean utils_is_light_color (const gchar* color_string);
VALA_EXTERN void utils_touch_dir (const gchar* dir);
VALA_EXTERN gchar* utils_get_config_dir (void);
VALA_EXTERN gint config_config_get_terminal_monitor (ConfigConfig* self);
VALA_EXTERN gint utils_get_active_monitor (GdkScreen* screen);
VALA_EXTERN gint utils_get_pointer_monitor (GdkScreen* screen);
static void config_config_finalize (GObject * obj);
static GType config_config_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

ConfigConfig*
config_config_construct (GType object_type)
{
	ConfigConfig * self = NULL;
	gchar* _tmp0_;
	GKeyFile* _tmp1_;
	GeeArrayList* _tmp2_;
	gchar** backspace_key_erase_list = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint backspace_key_erase_list_length1;
	gint _backspace_key_erase_list_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GeeArrayList* _tmp13_;
	gchar** del_key_erase_list = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gint del_key_erase_list_length1;
	gint _del_key_erase_list_size_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GeeHashMap* _tmp24_;
	GeeHashMap* _tmp25_;
	GeeHashMap* _tmp26_;
	GeeHashMap* _tmp27_;
	GeeHashMap* _tmp28_;
	GeeHashMap* _tmp29_;
	GeeArrayList* _tmp30_;
	gchar** encoding_list = NULL;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar** _tmp99_;
	gint encoding_list_length1;
	gint _encoding_list_size_;
	gchar** _tmp100_;
	gint _tmp100__length1;
	GFile* file = NULL;
	const gchar* _tmp104_;
	GFile* _tmp105_;
	GFile* _tmp106_;
	self = (ConfigConfig*) g_object_new (object_type, NULL);
	_tmp0_ = font_match ("mono");
	_g_free0 (self->default_mono_font);
	self->default_mono_font = _tmp0_;
	_tmp1_ = g_key_file_new ();
	_g_key_file_unref0 (self->config_file);
	self->config_file = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->backspace_key_erase_names);
	self->backspace_key_erase_names = _tmp2_;
	_tmp3_ = g_strdup ("ascii-del");
	_tmp4_ = g_strdup ("auto");
	_tmp5_ = g_strdup ("control-h");
	_tmp6_ = g_strdup ("escape-sequence");
	_tmp7_ = g_strdup ("tty");
	_tmp8_ = g_new0 (gchar*, 5 + 1);
	_tmp8_[0] = _tmp3_;
	_tmp8_[1] = _tmp4_;
	_tmp8_[2] = _tmp5_;
	_tmp8_[3] = _tmp6_;
	_tmp8_[4] = _tmp7_;
	backspace_key_erase_list = _tmp8_;
	backspace_key_erase_list_length1 = 5;
	_backspace_key_erase_list_size_ = backspace_key_erase_list_length1;
	_tmp9_ = backspace_key_erase_list;
	_tmp9__length1 = backspace_key_erase_list_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp9_;
		name_collection_length1 = _tmp9__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp10_;
			gchar* name = NULL;
			_tmp10_ = g_strdup (name_collection[name_it]);
			name = _tmp10_;
			{
				GeeArrayList* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = self->backspace_key_erase_names;
				_tmp12_ = name;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
				_g_free0 (name);
			}
		}
	}
	_tmp13_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->del_key_erase_names);
	self->del_key_erase_names = _tmp13_;
	_tmp14_ = g_strdup ("escape-sequence");
	_tmp15_ = g_strdup ("ascii-del");
	_tmp16_ = g_strdup ("auto");
	_tmp17_ = g_strdup ("control-h");
	_tmp18_ = g_strdup ("tty");
	_tmp19_ = g_new0 (gchar*, 5 + 1);
	_tmp19_[0] = _tmp14_;
	_tmp19_[1] = _tmp15_;
	_tmp19_[2] = _tmp16_;
	_tmp19_[3] = _tmp17_;
	_tmp19_[4] = _tmp18_;
	del_key_erase_list = _tmp19_;
	del_key_erase_list_length1 = 5;
	_del_key_erase_list_size_ = del_key_erase_list_length1;
	_tmp20_ = del_key_erase_list;
	_tmp20__length1 = del_key_erase_list_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp20_;
		name_collection_length1 = _tmp20__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp21_;
			gchar* name = NULL;
			_tmp21_ = g_strdup (name_collection[name_it]);
			name = _tmp21_;
			{
				GeeArrayList* _tmp22_;
				const gchar* _tmp23_;
				_tmp22_ = self->del_key_erase_names;
				_tmp23_ = name;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
				_g_free0 (name);
			}
		}
	}
	_tmp24_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->erase_map);
	self->erase_map = _tmp24_;
	_tmp25_ = self->erase_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, "ascii-del", "ascii-del");
	_tmp26_ = self->erase_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, "auto", "auto");
	_tmp27_ = self->erase_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "control-h", "control-h");
	_tmp28_ = self->erase_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, "escape-sequence", "escape-sequence");
	_tmp29_ = self->erase_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, "tty", "tty");
	_tmp30_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->encoding_names);
	self->encoding_names = _tmp30_;
	_tmp31_ = g_strdup ("UTF-8");
	_tmp32_ = g_strdup ("UTF-16");
	_tmp33_ = g_strdup ("GB18030");
	_tmp34_ = g_strdup ("GB2312");
	_tmp35_ = g_strdup ("GBK");
	_tmp36_ = g_strdup ("BIG5");
	_tmp37_ = g_strdup ("BIG5-HKSCS");
	_tmp38_ = g_strdup ("ISO-8859-1");
	_tmp39_ = g_strdup ("ISO-8859-2");
	_tmp40_ = g_strdup ("ISO-8859-3");
	_tmp41_ = g_strdup ("ISO-8859-4");
	_tmp42_ = g_strdup ("ISO-8859-5");
	_tmp43_ = g_strdup ("ISO-8859-6");
	_tmp44_ = g_strdup ("ISO-8859-7");
	_tmp45_ = g_strdup ("ISO-8859-8");
	_tmp46_ = g_strdup ("ISO-8859-8-I");
	_tmp47_ = g_strdup ("ISO-8859-9");
	_tmp48_ = g_strdup ("ISO-8859-10");
	_tmp49_ = g_strdup ("ISO-8859-13");
	_tmp50_ = g_strdup ("ISO-8859-14");
	_tmp51_ = g_strdup ("ISO-8859-15");
	_tmp52_ = g_strdup ("ISO-8859-16");
	_tmp53_ = g_strdup ("ARMSCII-8");
	_tmp54_ = g_strdup ("CP866");
	_tmp55_ = g_strdup ("EUC-JP");
	_tmp56_ = g_strdup ("EUC-KR");
	_tmp57_ = g_strdup ("EUC-TW");
	_tmp58_ = g_strdup ("GEORGIAN-PS");
	_tmp59_ = g_strdup ("IBM850");
	_tmp60_ = g_strdup ("IBM852");
	_tmp61_ = g_strdup ("IBM855");
	_tmp62_ = g_strdup ("IBM857");
	_tmp63_ = g_strdup ("IBM862");
	_tmp64_ = g_strdup ("IBM864");
	_tmp65_ = g_strdup ("ISO-2022-JP");
	_tmp66_ = g_strdup ("ISO-2022-KR");
	_tmp67_ = g_strdup ("ISO-IR-111");
	_tmp68_ = g_strdup ("KOI8-R");
	_tmp69_ = g_strdup ("KOI8-U");
	_tmp70_ = g_strdup ("MAC_ARABIC");
	_tmp71_ = g_strdup ("MAC_CE");
	_tmp72_ = g_strdup ("MAC_CROATIAN");
	_tmp73_ = g_strdup ("MAC-CYRILLIC");
	_tmp74_ = g_strdup ("MAC_DEVANAGARI");
	_tmp75_ = g_strdup ("MAC_FARSI");
	_tmp76_ = g_strdup ("MAC_GREEK");
	_tmp77_ = g_strdup ("MAC_GUJARATI");
	_tmp78_ = g_strdup ("MAC_GURMUKHI");
	_tmp79_ = g_strdup ("MAC_HEBREW");
	_tmp80_ = g_strdup ("MAC_ICELANDIC");
	_tmp81_ = g_strdup ("MAC_ROMAN");
	_tmp82_ = g_strdup ("MAC_ROMANIAN");
	_tmp83_ = g_strdup ("MAC_TURKISH");
	_tmp84_ = g_strdup ("MAC_UKRAINIAN");
	_tmp85_ = g_strdup ("SHIFT_JIS");
	_tmp86_ = g_strdup ("TCVN");
	_tmp87_ = g_strdup ("TIS-620");
	_tmp88_ = g_strdup ("UHC");
	_tmp89_ = g_strdup ("VISCII");
	_tmp90_ = g_strdup ("WINDOWS-1250");
	_tmp91_ = g_strdup ("WINDOWS-1251");
	_tmp92_ = g_strdup ("WINDOWS-1252");
	_tmp93_ = g_strdup ("WINDOWS-1253");
	_tmp94_ = g_strdup ("WINDOWS-1254");
	_tmp95_ = g_strdup ("WINDOWS-1255");
	_tmp96_ = g_strdup ("WINDOWS-1256");
	_tmp97_ = g_strdup ("WINDOWS-1257");
	_tmp98_ = g_strdup ("WINDOWS-1258");
	_tmp99_ = g_new0 (gchar*, 68 + 1);
	_tmp99_[0] = _tmp31_;
	_tmp99_[1] = _tmp32_;
	_tmp99_[2] = _tmp33_;
	_tmp99_[3] = _tmp34_;
	_tmp99_[4] = _tmp35_;
	_tmp99_[5] = _tmp36_;
	_tmp99_[6] = _tmp37_;
	_tmp99_[7] = _tmp38_;
	_tmp99_[8] = _tmp39_;
	_tmp99_[9] = _tmp40_;
	_tmp99_[10] = _tmp41_;
	_tmp99_[11] = _tmp42_;
	_tmp99_[12] = _tmp43_;
	_tmp99_[13] = _tmp44_;
	_tmp99_[14] = _tmp45_;
	_tmp99_[15] = _tmp46_;
	_tmp99_[16] = _tmp47_;
	_tmp99_[17] = _tmp48_;
	_tmp99_[18] = _tmp49_;
	_tmp99_[19] = _tmp50_;
	_tmp99_[20] = _tmp51_;
	_tmp99_[21] = _tmp52_;
	_tmp99_[22] = _tmp53_;
	_tmp99_[23] = _tmp54_;
	_tmp99_[24] = _tmp55_;
	_tmp99_[25] = _tmp56_;
	_tmp99_[26] = _tmp57_;
	_tmp99_[27] = _tmp58_;
	_tmp99_[28] = _tmp59_;
	_tmp99_[29] = _tmp60_;
	_tmp99_[30] = _tmp61_;
	_tmp99_[31] = _tmp62_;
	_tmp99_[32] = _tmp63_;
	_tmp99_[33] = _tmp64_;
	_tmp99_[34] = _tmp65_;
	_tmp99_[35] = _tmp66_;
	_tmp99_[36] = _tmp67_;
	_tmp99_[37] = _tmp68_;
	_tmp99_[38] = _tmp69_;
	_tmp99_[39] = _tmp70_;
	_tmp99_[40] = _tmp71_;
	_tmp99_[41] = _tmp72_;
	_tmp99_[42] = _tmp73_;
	_tmp99_[43] = _tmp74_;
	_tmp99_[44] = _tmp75_;
	_tmp99_[45] = _tmp76_;
	_tmp99_[46] = _tmp77_;
	_tmp99_[47] = _tmp78_;
	_tmp99_[48] = _tmp79_;
	_tmp99_[49] = _tmp80_;
	_tmp99_[50] = _tmp81_;
	_tmp99_[51] = _tmp82_;
	_tmp99_[52] = _tmp83_;
	_tmp99_[53] = _tmp84_;
	_tmp99_[54] = _tmp85_;
	_tmp99_[55] = _tmp86_;
	_tmp99_[56] = _tmp87_;
	_tmp99_[57] = _tmp88_;
	_tmp99_[58] = _tmp89_;
	_tmp99_[59] = _tmp90_;
	_tmp99_[60] = _tmp91_;
	_tmp99_[61] = _tmp92_;
	_tmp99_[62] = _tmp93_;
	_tmp99_[63] = _tmp94_;
	_tmp99_[64] = _tmp95_;
	_tmp99_[65] = _tmp96_;
	_tmp99_[66] = _tmp97_;
	_tmp99_[67] = _tmp98_;
	encoding_list = _tmp99_;
	encoding_list_length1 = 68;
	_encoding_list_size_ = encoding_list_length1;
	_tmp100_ = encoding_list;
	_tmp100__length1 = encoding_list_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp100_;
		name_collection_length1 = _tmp100__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp101_;
			gchar* name = NULL;
			_tmp101_ = g_strdup (name_collection[name_it]);
			name = _tmp101_;
			{
				GeeArrayList* _tmp102_;
				const gchar* _tmp103_;
				_tmp102_ = self->encoding_names;
				_tmp103_ = name;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp102_, _tmp103_);
				_g_free0 (name);
			}
		}
	}
	_tmp104_ = self->config_file_path;
	_tmp105_ = g_file_new_for_path (_tmp104_);
	file = _tmp105_;
	_tmp106_ = file;
	if (!g_file_query_exists (_tmp106_, NULL)) {
		config_config_init_config (self);
	} else {
		config_config_load_config (self);
	}
	_g_object_unref0 (file);
	encoding_list = (_vala_array_free (encoding_list, encoding_list_length1, (GDestroyNotify) g_free), NULL);
	del_key_erase_list = (_vala_array_free (del_key_erase_list, del_key_erase_list_length1, (GDestroyNotify) g_free), NULL);
	backspace_key_erase_list = (_vala_array_free (backspace_key_erase_list, backspace_key_erase_list_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ConfigConfig*
config_config_new (void)
{
	return config_config_construct (CONFIG_TYPE_CONFIG);
}

void
config_config_init_config (ConfigConfig* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GKeyFile* _tmp0_;
		GKeyFile* _tmp1_;
		GKeyFile* _tmp2_;
		const gchar* _tmp3_;
		GKeyFile* _tmp4_;
		GKeyFile* _tmp5_;
		GKeyFile* _tmp6_;
		GKeyFile* _tmp7_;
		GKeyFile* _tmp8_;
		GKeyFile* _tmp9_;
		GKeyFile* _tmp10_;
		GKeyFile* _tmp11_;
		GKeyFile* _tmp12_;
		GKeyFile* _tmp13_;
		GKeyFile* _tmp14_;
		GKeyFile* _tmp15_;
		GKeyFile* _tmp16_;
		GKeyFile* _tmp17_;
		GKeyFile* _tmp18_;
		GKeyFile* _tmp19_;
		GKeyFile* _tmp20_;
		GKeyFile* _tmp21_;
		GKeyFile* _tmp22_;
		GKeyFile* _tmp23_;
		GKeyFile* _tmp24_;
		GKeyFile* _tmp25_;
		GKeyFile* _tmp26_;
		GKeyFile* _tmp27_;
		GKeyFile* _tmp28_;
		GKeyFile* _tmp29_;
		GKeyFile* _tmp30_;
		GKeyFile* _tmp31_;
		GKeyFile* _tmp32_;
		GKeyFile* _tmp33_;
		GKeyFile* _tmp34_;
		GKeyFile* _tmp35_;
		GKeyFile* _tmp36_;
		GKeyFile* _tmp37_;
		GKeyFile* _tmp38_;
		GKeyFile* _tmp39_;
		GKeyFile* _tmp40_;
		GKeyFile* _tmp41_;
		GKeyFile* _tmp42_;
		GKeyFile* _tmp43_;
		GKeyFile* _tmp44_;
		GKeyFile* _tmp45_;
		GKeyFile* _tmp46_;
		GKeyFile* _tmp47_;
		GKeyFile* _tmp48_;
		GKeyFile* _tmp49_;
		GKeyFile* _tmp50_;
		GKeyFile* _tmp51_;
		GKeyFile* _tmp52_;
		GKeyFile* _tmp53_;
		GKeyFile* _tmp54_;
		GKeyFile* _tmp55_;
		GKeyFile* _tmp56_;
		GKeyFile* _tmp57_;
		GKeyFile* _tmp58_;
		GKeyFile* _tmp59_;
		GKeyFile* _tmp60_;
		GKeyFile* _tmp61_;
		GKeyFile* _tmp62_;
		GKeyFile* _tmp63_;
		GKeyFile* _tmp64_;
		GKeyFile* _tmp65_;
		GKeyFile* _tmp66_;
		GKeyFile* _tmp67_;
		GKeyFile* _tmp68_;
		GKeyFile* _tmp69_;
		GKeyFile* _tmp70_;
		GKeyFile* _tmp71_;
		GKeyFile* _tmp72_;
		GKeyFile* _tmp73_;
		GKeyFile* _tmp74_;
		GKeyFile* _tmp75_;
		GKeyFile* _tmp76_;
		GKeyFile* _tmp77_;
		GKeyFile* _tmp78_;
		GKeyFile* _tmp79_;
		GKeyFile* _tmp80_;
		GKeyFile* _tmp81_;
		GKeyFile* _tmp82_;
		GKeyFile* _tmp83_;
		GKeyFile* _tmp84_;
		GKeyFile* _tmp85_;
		GKeyFile* _tmp86_;
		GKeyFile* _tmp87_;
		GKeyFile* _tmp88_;
		GKeyFile* _tmp89_;
		GKeyFile* _tmp90_;
		GKeyFile* _tmp91_;
		GKeyFile* _tmp92_;
		GKeyFile* _tmp93_;
		GKeyFile* _tmp94_;
		GKeyFile* _tmp95_;
		GKeyFile* _tmp96_;
		GKeyFile* _tmp97_;
		GKeyFile* _tmp98_;
		_tmp0_ = self->config_file;
		g_key_file_set_string (_tmp0_, "general", "theme", "deepin");
		_tmp1_ = self->config_file;
		g_key_file_set_double (_tmp1_, "general", "opacity", self->default_opacity);
		_tmp2_ = self->config_file;
		_tmp3_ = self->default_mono_font;
		g_key_file_set_string (_tmp2_, "general", "font", _tmp3_);
		_tmp4_ = self->config_file;
		g_key_file_set_integer (_tmp4_, "general", "font_size", self->default_size);
		_tmp5_ = self->config_file;
		g_key_file_set_string (_tmp5_, "shortcut", "copy", "Ctrl + Shift + c");
		_tmp6_ = self->config_file;
		g_key_file_set_string (_tmp6_, "shortcut", "paste", "Ctrl + Shift + v");
		_tmp7_ = self->config_file;
		g_key_file_set_string (_tmp7_, "shortcut", "open", "Ctrl + Shift + x");
		_tmp8_ = self->config_file;
		g_key_file_set_string (_tmp8_, "shortcut", "search", "Ctrl + Shift + f");
		_tmp9_ = self->config_file;
		g_key_file_set_string (_tmp9_, "shortcut", "zoom_in", "Ctrl + =");
		_tmp10_ = self->config_file;
		g_key_file_set_string (_tmp10_, "shortcut", "zoom_out", "Ctrl + -");
		_tmp11_ = self->config_file;
		g_key_file_set_string (_tmp11_, "shortcut", "default_size", "Ctrl + 0");
		_tmp12_ = self->config_file;
		g_key_file_set_string (_tmp12_, "shortcut", "select_all", "Ctrl + Shift + a");
		_tmp13_ = self->config_file;
		g_key_file_set_string (_tmp13_, "shortcut", "jump_to_next_command", "Shift + Down");
		_tmp14_ = self->config_file;
		g_key_file_set_string (_tmp14_, "shortcut", "jump_to_previous_command", "Shift + Up");
		_tmp15_ = self->config_file;
		g_key_file_set_string (_tmp15_, "shortcut", "new_workspace", "Ctrl + Shift + t");
		_tmp16_ = self->config_file;
		g_key_file_set_string (_tmp16_, "shortcut", "close_workspace", "Ctrl + Shift + w");
		_tmp17_ = self->config_file;
		g_key_file_set_string (_tmp17_, "shortcut", "next_workspace", "Ctrl + Tab");
		_tmp18_ = self->config_file;
		g_key_file_set_string (_tmp18_, "shortcut", "previous_workspace", "Ctrl + Shift + Tab");
		_tmp19_ = self->config_file;
		g_key_file_set_string (_tmp19_, "shortcut", "vertical_split", "Ctrl + Shift + j");
		_tmp20_ = self->config_file;
		g_key_file_set_string (_tmp20_, "shortcut", "horizontal_split", "Ctrl + Shift + h");
		_tmp21_ = self->config_file;
		g_key_file_set_string (_tmp21_, "shortcut", "select_upper_window", "Alt + k");
		_tmp22_ = self->config_file;
		g_key_file_set_string (_tmp22_, "shortcut", "select_lower_window", "Alt + j");
		_tmp23_ = self->config_file;
		g_key_file_set_string (_tmp23_, "shortcut", "select_left_window", "Alt + h");
		_tmp24_ = self->config_file;
		g_key_file_set_string (_tmp24_, "shortcut", "select_right_window", "Alt + l");
		_tmp25_ = self->config_file;
		g_key_file_set_string (_tmp25_, "shortcut", "close_window", "Ctrl + Alt + q");
		_tmp26_ = self->config_file;
		g_key_file_set_string (_tmp26_, "shortcut", "close_other_windows", "Ctrl + Shift + q");
		_tmp27_ = self->config_file;
		g_key_file_set_string (_tmp27_, "shortcut", "rename_title", "F2");
		_tmp28_ = self->config_file;
		g_key_file_set_string (_tmp28_, "shortcut", "switch_fullscreen", "F11");
		_tmp29_ = self->config_file;
		g_key_file_set_string (_tmp29_, "shortcut", "display_shortcuts", "Ctrl + Shift + ?");
		_tmp30_ = self->config_file;
		g_key_file_set_string (_tmp30_, "shortcut", "custom_commands", "Ctrl + [");
		_tmp31_ = self->config_file;
		g_key_file_set_string (_tmp31_, "shortcut", "remote_management", "Ctrl + /");
		_tmp32_ = self->config_file;
		g_key_file_set_string (_tmp32_, "shortcut", "select_workspace", "Alt");
		_tmp33_ = self->config_file;
		g_key_file_set_string (_tmp33_, "shortcut", "new_theme_terminal", "Ctrl + Alt");
		_tmp34_ = self->config_file;
		g_key_file_set_string (_tmp34_, "advanced", "cursor_shape", "block");
		_tmp35_ = self->config_file;
		g_key_file_set_boolean (_tmp35_, "advanced", "cursor_blink_mode", TRUE);
		_tmp36_ = self->config_file;
		g_key_file_set_boolean (_tmp36_, "advanced", "cursor_auto_hide", FALSE);
		_tmp37_ = self->config_file;
		g_key_file_set_boolean (_tmp37_, "advanced", "scroll_on_key", TRUE);
		_tmp38_ = self->config_file;
		g_key_file_set_boolean (_tmp38_, "advanced", "scroll_on_output", FALSE);
		_tmp39_ = self->config_file;
		g_key_file_set_integer (_tmp39_, "advanced", "scroll_line", -1);
		_tmp40_ = self->config_file;
		g_key_file_set_string (_tmp40_, "advanced", "use_on_starting", "window");
		_tmp41_ = self->config_file;
		g_key_file_set_boolean (_tmp41_, "advanced", "blur_background", FALSE);
		_tmp42_ = self->config_file;
		g_key_file_set_integer (_tmp42_, "advanced", "window_width", 0);
		_tmp43_ = self->config_file;
		g_key_file_set_integer (_tmp43_, "advanced", "window_height", 0);
		_tmp44_ = self->config_file;
		g_key_file_set_double (_tmp44_, "advanced", "quake_window_height", (gdouble) 0);
		_tmp45_ = self->config_file;
		g_key_file_set_boolean (_tmp45_, "advanced", "quake_window_fullscreen", FALSE);
		_tmp46_ = self->config_file;
		g_key_file_set_string (_tmp46_, "advanced", "remote_commands", "zssh");
		_tmp47_ = self->config_file;
		g_key_file_set_boolean (_tmp47_, "advanced", "hide_quakewindow_after_lost_focus", FALSE);
		_tmp48_ = self->config_file;
		g_key_file_set_boolean (_tmp48_, "advanced", "show_quakewindow_tab", TRUE);
		_tmp49_ = self->config_file;
		g_key_file_set_boolean (_tmp49_, "advanced", "follow_active_window", TRUE);
		_tmp50_ = self->config_file;
		g_key_file_set_boolean (_tmp50_, "advanced", "hide_quakewindow_when_active", TRUE);
		_tmp51_ = self->config_file;
		g_key_file_set_boolean (_tmp51_, "advanced", "print_notify_after_script_finish", TRUE);
		_tmp52_ = self->config_file;
		g_key_file_set_boolean (_tmp52_, "advanced", "run_as_login_shell", FALSE);
		_tmp53_ = self->config_file;
		g_key_file_set_boolean (_tmp53_, "advanced", "show_highlight_frame", FALSE);
		_tmp54_ = self->config_file;
		g_key_file_set_boolean (_tmp54_, "advanced", "copy_on_select", FALSE);
		_tmp55_ = self->config_file;
		g_key_file_set_boolean (_tmp55_, "advanced", "tabbar_at_the_bottom", FALSE);
		_tmp56_ = self->config_file;
		g_key_file_set_boolean (_tmp56_, "advanced", "audible_bell", FALSE);
		_tmp57_ = self->config_file;
		g_key_file_set_boolean (_tmp57_, "advanced", "always_hide_resize_grip", FALSE);
		_tmp58_ = self->config_file;
		g_key_file_set_boolean (_tmp58_, "advanced", "allow_hyperlink", FALSE);
		_tmp59_ = self->config_file;
		g_key_file_set_boolean (_tmp59_, "advanced", "prefer_deepin_menu", TRUE);
		_tmp60_ = self->config_file;
		g_key_file_set_string (_tmp60_, "theme", "color_1", "#073642");
		_tmp61_ = self->config_file;
		g_key_file_set_comment (_tmp61_, "theme", "color_1", "host", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp62_ = self->config_file;
		g_key_file_set_string (_tmp62_, "theme", "color_2", "#bdb76b");
		_tmp63_ = self->config_file;
		g_key_file_set_comment (_tmp63_, "theme", "color_2", "string", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp64_ = self->config_file;
		g_key_file_set_string (_tmp64_, "theme", "color_3", "#859900");
		_tmp65_ = self->config_file;
		g_key_file_set_comment (_tmp65_, "theme", "color_3", "command", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp66_ = self->config_file;
		g_key_file_set_string (_tmp66_, "theme", "color_4", "#b58900");
		_tmp67_ = self->config_file;
		g_key_file_set_comment (_tmp67_, "theme", "color_4", "command", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp68_ = self->config_file;
		g_key_file_set_string (_tmp68_, "theme", "color_5", "#ffd700");
		_tmp69_ = self->config_file;
		g_key_file_set_comment (_tmp69_, "theme", "color_5", "path", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp70_ = self->config_file;
		g_key_file_set_string (_tmp70_, "theme", "color_6", "#d33682");
		_tmp71_ = self->config_file;
		g_key_file_set_comment (_tmp71_, "theme", "color_6", "variable", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp72_ = self->config_file;
		g_key_file_set_string (_tmp72_, "theme", "color_7", "#2aa198");
		_tmp73_ = self->config_file;
		g_key_file_set_comment (_tmp73_, "theme", "color_7", "prompt", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp74_ = self->config_file;
		g_key_file_set_string (_tmp74_, "theme", "color_8", "#eee8d5");
		_tmp75_ = self->config_file;
		g_key_file_set_string (_tmp75_, "theme", "color_9", "#002b36");
		_tmp76_ = self->config_file;
		g_key_file_set_string (_tmp76_, "theme", "color_10", "#8b0000");
		_tmp77_ = self->config_file;
		g_key_file_set_comment (_tmp77_, "theme", "color_10", "error", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp78_ = self->config_file;
		g_key_file_set_string (_tmp78_, "theme", "color_11", "#00ff00");
		_tmp79_ = self->config_file;
		g_key_file_set_comment (_tmp79_, "theme", "color_11", "execute", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp80_ = self->config_file;
		g_key_file_set_string (_tmp80_, "theme", "color_12", "#657b83");
		_tmp81_ = self->config_file;
		g_key_file_set_string (_tmp81_, "theme", "color_13", "#1e90ff");
		_tmp82_ = self->config_file;
		g_key_file_set_comment (_tmp82_, "theme", "color_13", "folder", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp83_ = self->config_file;
		g_key_file_set_string (_tmp83_, "theme", "color_14", "#6c71c4");
		_tmp84_ = self->config_file;
		g_key_file_set_string (_tmp84_, "theme", "color_15", "#93a1a1");
		_tmp85_ = self->config_file;
		g_key_file_set_string (_tmp85_, "theme", "color_16", "#fdf6e3");
		_tmp86_ = self->config_file;
		g_key_file_set_string (_tmp86_, "theme", "background", "#000000");
		_tmp87_ = self->config_file;
		g_key_file_set_string (_tmp87_, "theme", "foreground", "#00cd00");
		_tmp88_ = self->config_file;
		g_key_file_set_string (_tmp88_, "theme", "tab", "#2CA7F8");
		_tmp89_ = self->config_file;
		g_key_file_set_string (_tmp89_, "theme", "style", "dark");
		_tmp90_ = self->config_file;
		g_key_file_set_string (_tmp90_, "theme_terminal", "theme1", "solarized dark");
		_tmp91_ = self->config_file;
		g_key_file_set_string (_tmp91_, "theme_terminal", "theme2", "bim");
		_tmp92_ = self->config_file;
		g_key_file_set_string (_tmp92_, "theme_terminal", "theme3", "hemisu light");
		_tmp93_ = self->config_file;
		g_key_file_set_string (_tmp93_, "theme_terminal", "theme4", "gruvbox light");
		_tmp94_ = self->config_file;
		g_key_file_set_string (_tmp94_, "theme_terminal", "theme5", "elementary");
		_tmp95_ = self->config_file;
		g_key_file_set_string (_tmp95_, "theme_terminal", "theme6", "azu");
		_tmp96_ = self->config_file;
		g_key_file_set_string (_tmp96_, "theme_terminal", "theme7", "aco");
		_tmp97_ = self->config_file;
		g_key_file_set_string (_tmp97_, "theme_terminal", "theme8", "miu");
		_tmp98_ = self->config_file;
		g_key_file_set_string (_tmp98_, "theme_terminal", "theme9", "material");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp99_;
		const gchar* _tmp100_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp99_ = e;
		_tmp100_ = _tmp99_->message;
		g_print ("Config init_config: %s\n", _tmp100_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	config_config_save (self);
}

void
config_config_check_string (ConfigConfig* self,
                            const gchar* group,
                            const gchar* key,
                            const gchar* value)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->config_file;
		if (!g_key_file_has_group (_tmp1_, group)) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			GKeyFile* _tmp3_;
			_tmp3_ = self->config_file;
			_tmp2_ = g_key_file_has_key (_tmp3_, group, key, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp0_ = !_tmp2_;
		}
		if (_tmp0_) {
			GKeyFile* _tmp4_;
			_tmp4_ = self->config_file;
			g_key_file_set_string (_tmp4_, group, key, value);
		} else {
			GKeyFile* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = self->config_file;
			_tmp6_ = g_key_file_get_string (_tmp5_, group, key, &_inner_error0_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp7_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GKeyFile* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_print ("check_string: %s\n", _tmp9_);
		_tmp10_ = self->config_file;
		g_key_file_set_string (_tmp10_, group, key, value);
		g_print ("Reset [%s] %s with %s\n", group, key, value);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
config_config_check_font (ConfigConfig* self,
                          const gchar* group,
                          const gchar* key,
                          const gchar* value)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->config_file;
		if (!g_key_file_has_group (_tmp1_, group)) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			GKeyFile* _tmp3_;
			_tmp3_ = self->config_file;
			_tmp2_ = g_key_file_has_key (_tmp3_, group, key, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp0_ = !_tmp2_;
		}
		if (_tmp0_) {
			GKeyFile* _tmp4_;
			_tmp4_ = self->config_file;
			g_key_file_set_string (_tmp4_, group, key, value);
		} else {
			gchar* font = NULL;
			GKeyFile* _tmp5_;
			gchar* _tmp6_;
			gboolean mono_font_exist = FALSE;
			gint num = 0;
			gchar** mono_or_dot_fonts = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gchar** _tmp9_;
			gint mono_or_dot_fonts_length1;
			gint _mono_or_dot_fonts_size_;
			_tmp5_ = self->config_file;
			_tmp6_ = g_key_file_get_string (_tmp5_, group, key, &_inner_error0_);
			font = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			mono_font_exist = FALSE;
			_tmp9_ = list_mono_or_dot_fonts (&_tmp7_, &_tmp8_);
			num = _tmp7_;
			mono_or_dot_fonts = (gchar**) _tmp9_;
			mono_or_dot_fonts_length1 = (_tmp8_ * sizeof (gchar*)) / sizeof (gchar*);
			_mono_or_dot_fonts_size_ = mono_or_dot_fonts_length1;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp10_ = FALSE;
					_tmp10_ = TRUE;
					while (TRUE) {
						const gchar* _tmp12_;
						gchar** _tmp13_;
						gint _tmp13__length1;
						const gchar* _tmp14_;
						if (!_tmp10_) {
							gint _tmp11_;
							_tmp11_ = i;
							i = _tmp11_ + 1;
						}
						_tmp10_ = FALSE;
						if (!(i < num)) {
							break;
						}
						_tmp12_ = font;
						_tmp13_ = mono_or_dot_fonts;
						_tmp13__length1 = mono_or_dot_fonts_length1;
						_tmp14_ = _tmp13_[i];
						if (g_strcmp0 (_tmp12_, _tmp14_) == 0) {
							mono_font_exist = TRUE;
							break;
						}
					}
				}
			}
			if (!mono_font_exist) {
				GKeyFile* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = self->config_file;
				g_key_file_set_string (_tmp15_, group, key, value);
				_tmp16_ = font;
				g_print ("Font '%s' is not exist in system, use '%s' instead.\n", _tmp16_, value);
			}
			mono_or_dot_fonts = (_vala_array_free (mono_or_dot_fonts, mono_or_dot_fonts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (font);
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		GKeyFile* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_print ("check_font: %s\n", _tmp18_);
		_tmp19_ = self->config_file;
		g_key_file_set_string (_tmp19_, group, key, value);
		g_print ("Reset [%s] %s with %s\n", group, key, value);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
config_config_check_integer (ConfigConfig* self,
                             const gchar* group,
                             const gchar* key,
                             gint value)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->config_file;
		if (!g_key_file_has_group (_tmp1_, group)) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			GKeyFile* _tmp3_;
			_tmp3_ = self->config_file;
			_tmp2_ = g_key_file_has_key (_tmp3_, group, key, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp0_ = !_tmp2_;
		}
		if (_tmp0_) {
			GKeyFile* _tmp4_;
			g_print ("** start!\n");
			_tmp4_ = self->config_file;
			g_key_file_set_integer (_tmp4_, group, key, value);
		} else {
			GKeyFile* _tmp5_;
			_tmp5_ = self->config_file;
			g_key_file_get_integer (_tmp5_, group, key, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GKeyFile* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_print ("check_integer: %s\n", _tmp7_);
		_tmp8_ = self->config_file;
		g_key_file_set_integer (_tmp8_, group, key, value);
		g_print ("Reset [%s] %s with %i\n", group, key, value);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
config_config_check_double (ConfigConfig* self,
                            const gchar* group,
                            const gchar* key,
                            gdouble value)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->config_file;
		if (!g_key_file_has_group (_tmp1_, group)) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			GKeyFile* _tmp3_;
			_tmp3_ = self->config_file;
			_tmp2_ = g_key_file_has_key (_tmp3_, group, key, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp0_ = !_tmp2_;
		}
		if (_tmp0_) {
			GKeyFile* _tmp4_;
			_tmp4_ = self->config_file;
			g_key_file_set_double (_tmp4_, group, key, value);
		} else {
			GKeyFile* _tmp5_;
			_tmp5_ = self->config_file;
			g_key_file_get_double (_tmp5_, group, key, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GKeyFile* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_print ("check_double: %s\n", _tmp7_);
		_tmp8_ = self->config_file;
		g_key_file_set_double (_tmp8_, group, key, value);
		g_print ("Reset [%s] %s with %f\n", group, key, value);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

void
config_config_check_boolean (ConfigConfig* self,
                             const gchar* group,
                             const gchar* key,
                             gboolean value)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->config_file;
		if (!g_key_file_has_group (_tmp1_, group)) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			GKeyFile* _tmp3_;
			_tmp3_ = self->config_file;
			_tmp2_ = g_key_file_has_key (_tmp3_, group, key, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp0_ = !_tmp2_;
		}
		if (_tmp0_) {
			GKeyFile* _tmp4_;
			_tmp4_ = self->config_file;
			g_key_file_set_boolean (_tmp4_, group, key, value);
		} else {
			GKeyFile* _tmp5_;
			_tmp5_ = self->config_file;
			g_key_file_get_boolean (_tmp5_, group, key, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GKeyFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_print ("check_boolean: %s\n", _tmp7_);
		_tmp8_ = self->config_file;
		g_key_file_set_boolean (_tmp8_, group, key, value);
		_tmp9_ = bool_to_string (value);
		_tmp10_ = _tmp9_;
		g_print ("Reset [%s] %s with %s\n", group, key, _tmp10_);
		_g_free0 (_tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
config_config_check_config (ConfigConfig* self)
{
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->config_file;
		_tmp1_ = self->config_file_path;
		g_key_file_load_from_file (_tmp0_, _tmp1_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = self->config_file_path;
		if (!g_file_test (_tmp2_, G_FILE_TEST_EXISTS)) {
			GError* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_print ("Config check_config: %s\n", _tmp4_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	config_config_check_string (self, "general", "theme", "deepin");
	config_config_check_double (self, "general", "opacity", self->default_opacity);
	_tmp5_ = self->default_mono_font;
	config_config_check_font (self, "general", "font", _tmp5_);
	config_config_check_integer (self, "general", "font_size", self->default_size);
	config_config_check_string (self, "shortcut", "copy", "Ctrl + Shift + c");
	config_config_check_string (self, "shortcut", "paste", "Ctrl + Shift + v");
	config_config_check_string (self, "shortcut", "open", "Ctrl + Shift + x");
	config_config_check_string (self, "shortcut", "search", "Ctrl + Shift + f");
	config_config_check_string (self, "shortcut", "zoom_in", "Ctrl + =");
	config_config_check_string (self, "shortcut", "zoom_out", "Ctrl + -");
	config_config_check_string (self, "shortcut", "default_size", "Ctrl + 0");
	config_config_check_string (self, "shortcut", "jump_to_next_command", "Shift + Down");
	config_config_check_string (self, "shortcut", "jump_to_previous_command", "Shift + Up");
	config_config_check_string (self, "shortcut", "select_all", "Ctrl + Shift + a");
	config_config_check_string (self, "shortcut", "new_workspace", "Ctrl + Shift + t");
	config_config_check_string (self, "shortcut", "close_workspace", "Ctrl + Shift + w");
	config_config_check_string (self, "shortcut", "next_workspace", "Ctrl + Tab");
	config_config_check_string (self, "shortcut", "previous_workspace", "Ctrl + Shift + Tab");
	config_config_check_string (self, "shortcut", "resize_workspace_up", "Ctrl + Alt + Up");
	config_config_check_string (self, "shortcut", "resize_workspace_down", "Ctrl + Alt + Down");
	config_config_check_string (self, "shortcut", "resize_workspace_left", "Ctrl + Alt + Left");
	config_config_check_string (self, "shortcut", "resize_workspace_right", "Ctrl + Alt + Right");
	config_config_check_string (self, "shortcut", "vertical_split", "Ctrl + Shift + j");
	config_config_check_string (self, "shortcut", "horizontal_split", "Ctrl + Shift + h");
	config_config_check_string (self, "shortcut", "select_upper_window", "Alt + k");
	config_config_check_string (self, "shortcut", "select_lower_window", "Alt + j");
	config_config_check_string (self, "shortcut", "select_left_window", "Alt + h");
	config_config_check_string (self, "shortcut", "select_right_window", "Alt + l");
	config_config_check_string (self, "shortcut", "close_window", "Ctrl + Alt + q");
	config_config_check_string (self, "shortcut", "close_other_windows", "Ctrl + Shift + q");
	config_config_check_string (self, "shortcut", "rename_title", "F2");
	config_config_check_string (self, "shortcut", "switch_fullscreen", "F11");
	config_config_check_string (self, "shortcut", "display_shortcuts", "Ctrl + Shift + ?");
	config_config_check_string (self, "shortcut", "custom_commands", "Ctrl + [");
	config_config_check_string (self, "shortcut", "remote_management", "Ctrl + /");
	config_config_check_string (self, "shortcut", "select_workspace", "Alt");
	config_config_check_string (self, "shortcut", "new_theme_terminal", "Ctrl + Alt");
	config_config_check_string (self, "advanced", "cursor_shape", "block");
	config_config_check_boolean (self, "advanced", "cursor_blink_mode", TRUE);
	config_config_check_boolean (self, "advanced", "cursor_auto_hide", FALSE);
	config_config_check_boolean (self, "advanced", "bold_is_bright", FALSE);
	config_config_check_boolean (self, "advanced", "audible_bell", FALSE);
	config_config_check_boolean (self, "advanced", "always_hide_resize_grip", FALSE);
	config_config_check_boolean (self, "advanced", "allow_hyperlink", FALSE);
	config_config_check_boolean (self, "advanced", "prefer_deepin_menu", TRUE);
	config_config_check_boolean (self, "advanced", "scroll_on_key", TRUE);
	config_config_check_boolean (self, "advanced", "scroll_on_output", FALSE);
	config_config_check_integer (self, "advanced", "scroll_line", -1);
	config_config_check_string (self, "advanced", "use_on_starting", "window");
	config_config_check_boolean (self, "advanced", "blur_background", FALSE);
	config_config_check_integer (self, "advanced", "window_width", 0);
	config_config_check_integer (self, "advanced", "window_height", 0);
	config_config_check_double (self, "advanced", "quake_window_height", (gdouble) 0);
	config_config_check_boolean (self, "advanced", "quake_window_fullscreen", FALSE);
	config_config_check_string (self, "advanced", "remote_commands", "ssh;zssh;tmux;screen");
	config_config_check_boolean (self, "advanced", "hide_quakewindow_after_lost_focus", FALSE);
	config_config_check_boolean (self, "advanced", "show_quakewindow_tab", TRUE);
	config_config_check_boolean (self, "advanced", "follow_active_window", TRUE);
	config_config_check_boolean (self, "advanced", "hide_quakewindow_when_active", TRUE);
	config_config_check_boolean (self, "advanced", "print_notify_after_script_finish", TRUE);
	config_config_check_boolean (self, "advanced", "run_as_login_shell", FALSE);
	config_config_check_boolean (self, "advanced", "show_highlight_frame", FALSE);
	config_config_check_boolean (self, "advanced", "copy_on_select", FALSE);
	config_config_check_boolean (self, "advanced", "tabbar_at_the_bottom", FALSE);
	config_config_check_string (self, "theme", "color_1", "#073642");
	config_config_check_string (self, "theme", "color_2", "#bdb76b");
	config_config_check_string (self, "theme", "color_3", "#859900");
	config_config_check_string (self, "theme", "color_4", "#b58900");
	config_config_check_string (self, "theme", "color_5", "#ffd700");
	config_config_check_string (self, "theme", "color_6", "#d33682");
	config_config_check_string (self, "theme", "color_7", "#2aa198");
	config_config_check_string (self, "theme", "color_8", "#eee8d5");
	config_config_check_string (self, "theme", "color_9", "#002b36");
	config_config_check_string (self, "theme", "color_10", "#8b0000");
	config_config_check_string (self, "theme", "color_11", "#00ff00");
	config_config_check_string (self, "theme", "color_12", "#657b83");
	config_config_check_string (self, "theme", "color_13", "#1e90ff");
	config_config_check_string (self, "theme", "color_14", "#6c71c4");
	config_config_check_string (self, "theme", "color_15", "#93a1a1");
	config_config_check_string (self, "theme", "color_16", "#fdf6e3");
	config_config_check_string (self, "theme", "background", "#000000");
	config_config_check_string (self, "theme", "foreground", "#00cd00");
	config_config_check_string (self, "theme", "tab", "#2CA7F8");
	config_config_check_string (self, "theme", "style", "dark");
	config_config_check_string (self, "theme_terminal", "theme1", "solarized dark");
	config_config_check_string (self, "theme_terminal", "theme2", "bim");
	config_config_check_string (self, "theme_terminal", "theme3", "hemisu light");
	config_config_check_string (self, "theme_terminal", "theme4", "gruvbox light");
	config_config_check_string (self, "theme_terminal", "theme5", "elementary");
	config_config_check_string (self, "theme_terminal", "theme6", "azu");
	config_config_check_string (self, "theme_terminal", "theme7", "aco");
	config_config_check_string (self, "theme_terminal", "theme8", "miu");
	config_config_check_string (self, "theme_terminal", "theme9", "material");
	config_config_save (self);
}

void
config_config_load_config (ConfigConfig* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		config_config_check_config (self);
		_tmp0_ = self->config_file;
		_tmp1_ = self->config_file_path;
		g_key_file_load_from_file (_tmp0_, _tmp1_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = self->config_file_path;
		if (!g_file_test (_tmp2_, G_FILE_TEST_EXISTS)) {
			GError* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_print ("Config load_config: %s\n", _tmp4_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
config_config_load_temp_theme (ConfigConfig* self,
                               const gchar* theme_name)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme_name != NULL);
	config_config_update_theme (self, theme_name);
	_tmp0_ = g_strdup (theme_name);
	_g_free0 (self->temp_theme);
	self->temp_theme = _tmp0_;
}

void
config_config_set_theme (ConfigConfig* self,
                         const gchar* theme_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme_name != NULL);
	_g_free0 (self->temp_theme);
	self->temp_theme = NULL;
	config_config_update_theme (self, theme_name);
	config_config_save (self);
	g_signal_emit (self, config_config_signals[CONFIG_CONFIG_UPDATE_SIGNAL], 0);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
config_config_update_theme (ConfigConfig* self,
                            const gchar* theme_name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme_name != NULL);
	{
		GKeyFile* theme_file = NULL;
		GKeyFile* _tmp0_;
		GKeyFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar** _tmp4_ = NULL;
		GKeyFile* _tmp5_;
		gsize _tmp6_ = 0;
		gchar** _tmp7_;
		gint _tmp4__length1;
		gint __tmp4__size_;
		gchar* _tmp17_ = NULL;
		GKeyFile* _tmp18_;
		gchar* _tmp19_;
		gchar* background = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		GKeyFile* _tmp24_;
		_tmp0_ = g_key_file_new ();
		theme_file = _tmp0_;
		_tmp1_ = theme_file;
		_tmp2_ = utils_get_theme_path (theme_name);
		_tmp3_ = _tmp2_;
		g_key_file_load_from_file (_tmp1_, _tmp3_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (theme_file);
			goto __catch0_g_error;
		}
		_tmp5_ = theme_file;
		_tmp7_ = g_key_file_get_keys (_tmp5_, "theme", &_tmp6_, &_inner_error0_);
		_tmp4_ = _tmp7_;
		_tmp4__length1 = _tmp6_;
		__tmp4__size_ = _tmp4__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (theme_file);
			goto __catch0_g_error;
		}
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp4_;
			key_collection_length1 = _tmp4__length1;
			for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
				gchar* _tmp8_;
				gchar* key = NULL;
				_tmp8_ = g_strdup (key_collection[key_it]);
				key = _tmp8_;
				{
					gchar* _tmp9_ = NULL;
					GKeyFile* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					GKeyFile* _tmp13_;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp10_ = theme_file;
					_tmp11_ = key;
					_tmp12_ = g_key_file_get_string (_tmp10_, "theme", _tmp11_, &_inner_error0_);
					_tmp9_ = _tmp12_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (key);
						_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (theme_file);
						goto __catch0_g_error;
					}
					_tmp13_ = self->config_file;
					_tmp14_ = key;
					_tmp15_ = string_strip (_tmp9_);
					_tmp16_ = _tmp15_;
					g_key_file_set_string (_tmp13_, "theme", _tmp14_, _tmp16_);
					_g_free0 (_tmp16_);
					_g_free0 (_tmp9_);
					_g_free0 (key);
				}
			}
		}
		_tmp18_ = theme_file;
		_tmp19_ = g_key_file_get_string (_tmp18_, "theme", "background", &_inner_error0_);
		_tmp17_ = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
			_g_key_file_unref0 (theme_file);
			goto __catch0_g_error;
		}
		_tmp20_ = string_strip (_tmp17_);
		background = _tmp20_;
		_tmp21_ = background;
		if (utils_is_light_color (_tmp21_)) {
			GKeyFile* _tmp22_;
			_tmp22_ = self->config_file;
			g_key_file_set_string (_tmp22_, "theme", "style", "light");
		} else {
			GKeyFile* _tmp23_;
			_tmp23_ = self->config_file;
			g_key_file_set_string (_tmp23_, "theme", "style", "dark");
		}
		_tmp24_ = self->config_file;
		g_key_file_set_string (_tmp24_, "general", "theme", theme_name);
		_g_free0 (background);
		_g_free0 (_tmp17_);
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
		_g_key_file_unref0 (theme_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_print ("Config update_theme: %s\n", _tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
config_config_save (ConfigConfig* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		GKeyFile* _tmp13_;
		const gchar* _tmp14_;
		_tmp0_ = utils_get_config_dir ();
		_tmp1_ = _tmp0_;
		utils_touch_dir (_tmp1_);
		_g_free0 (_tmp1_);
		_tmp2_ = self->temp_theme;
		if (_tmp2_ != NULL) {
			{
				GKeyFile* theme_file = NULL;
				GKeyFile* _tmp3_;
				GKeyFile* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				GKeyFile* _tmp7_;
				gchar* _tmp8_;
				gchar* theme_name = NULL;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				_tmp3_ = g_key_file_new ();
				theme_file = _tmp3_;
				_tmp4_ = theme_file;
				_tmp5_ = self->config_file_path;
				g_key_file_load_from_file (_tmp4_, _tmp5_, G_KEY_FILE_NONE, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_key_file_unref0 (theme_file);
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					goto __finally1;
				}
				_tmp7_ = theme_file;
				_tmp8_ = g_key_file_get_string (_tmp7_, "general", "theme", &_inner_error0_);
				_tmp6_ = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_key_file_unref0 (theme_file);
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp9_ = string_strip (_tmp6_);
				theme_name = _tmp9_;
				_tmp10_ = theme_name;
				config_config_update_theme (self, _tmp10_);
				_g_free0 (theme_name);
				_g_free0 (_tmp6_);
				_g_key_file_unref0 (theme_file);
			}
			goto __finally1;
			__catch1_g_key_file_error:
			{
				GError* e = NULL;
				GError* _tmp11_;
				const gchar* _tmp12_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp11_ = e;
				_tmp12_ = _tmp11_->message;
				g_print ("save: %s\n", _tmp12_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp13_ = self->config_file;
		_tmp14_ = self->config_file_path;
		g_key_file_save_to_file (_tmp13_, _tmp14_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = self->config_file_path;
		if (!g_file_test (_tmp15_, G_FILE_TEST_EXISTS)) {
			GError* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_print ("save: %s\n", _tmp17_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gint
config_config_get_terminal_monitor (ConfigConfig* self)
{
	gboolean follow_active_window = FALSE;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp5_;
	GdkScreen* _tmp6_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	follow_active_window = TRUE;
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->config_file;
		_tmp0_ = g_key_file_get_boolean (_tmp1_, "advanced", "follow_active_window", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		follow_active_window = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_print ("Config get_terminal_monitor: %s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp4_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	_tmp5_ = gdk_screen_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	screen = _tmp6_;
	if (follow_active_window) {
		GdkScreen* _tmp7_;
		_tmp7_ = screen;
		result = utils_get_active_monitor (_tmp7_);
		_g_object_unref0 (screen);
		return result;
	} else {
		GdkScreen* _tmp8_;
		_tmp8_ = screen;
		result = utils_get_pointer_monitor (_tmp8_);
		_g_object_unref0 (screen);
		return result;
	}
}

static void
config_config_class_init (ConfigConfigClass * klass,
                          gpointer klass_data)
{
	config_config_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = config_config_finalize;
	config_config_signals[CONFIG_CONFIG_UPDATE_SIGNAL] = g_signal_new ("update", CONFIG_TYPE_CONFIG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
config_config_instance_init (ConfigConfig * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->default_opacity = 0.9;
	self->default_size = 11;
	_tmp0_ = g_strdup ("");
	self->default_mono_font = _tmp0_;
	_tmp1_ = utils_get_config_file_path ("config.conf");
	self->config_file_path = _tmp1_;
	self->temp_theme = NULL;
}

static void
config_config_finalize (GObject * obj)
{
	ConfigConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONFIG_TYPE_CONFIG, ConfigConfig);
	_g_object_unref0 (self->backspace_key_erase_names);
	_g_object_unref0 (self->del_key_erase_names);
	_g_object_unref0 (self->encoding_names);
	_g_object_unref0 (self->erase_map);
	_g_free0 (self->default_mono_font);
	_g_key_file_unref0 (self->config_file);
	_g_free0 (self->config_file_path);
	_g_free0 (self->temp_theme);
	G_OBJECT_CLASS (config_config_parent_class)->finalize (obj);
}

static GType
config_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConfigConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigConfig), 0, (GInstanceInitFunc) config_config_instance_init, NULL };
	GType config_config_type_id;
	config_config_type_id = g_type_register_static (G_TYPE_OBJECT, "ConfigConfig", &g_define_type_info, 0);
	return config_config_type_id;
}

GType
config_config_get_type (void)
{
	static volatile gsize config_config_type_id__once = 0;
	if (g_once_init_enter (&config_config_type_id__once)) {
		GType config_config_type_id;
		config_config_type_id = config_config_get_type_once ();
		g_once_init_leave (&config_config_type_id__once, config_config_type_id);
	}
	return config_config_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

