/* short-pathbar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from short-pathbar.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gio/gio.h>

#define MODEL_UTILS_folder_context_id_string "1"
#define MODEL_UTILS_folder_context_id ((guint16) 1)
#define MODEL_UTILS_undefined_context_id ((guint16) 0)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PATHBAR (pathbar_get_type ())
#define PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATHBAR, Pathbar))
#define IS_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATHBAR))
#define PATHBAR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PATHBAR, PathbarIface))

typedef struct _Pathbar Pathbar;
typedef struct _PathbarIface PathbarIface;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_SHORT_PATHBAR (short_pathbar_get_type ())
#define SHORT_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHORT_PATHBAR, ShortPathbar))
#define SHORT_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHORT_PATHBAR, ShortPathbarClass))
#define IS_SHORT_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHORT_PATHBAR))
#define IS_SHORT_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHORT_PATHBAR))
#define SHORT_PATHBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHORT_PATHBAR, ShortPathbarClass))

typedef struct _ShortPathbar ShortPathbar;
typedef struct _ShortPathbarClass ShortPathbarClass;
typedef struct _ShortPathbarPrivate ShortPathbarPrivate;
enum  {
	SHORT_PATHBAR_0_PROPERTY,
	SHORT_PATHBAR_NUM_PROPERTIES
};
static GParamSpec* short_pathbar_properties[SHORT_PATHBAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _PathbarIface {
	GTypeInterface parent_iface;
	gboolean (*has_popover) (Pathbar* self);
	void (*close_menu) (Pathbar* self);
	void (*toggle_menu) (Pathbar* self);
	void (*set_path) (Pathbar* self, ViewType type, const gchar* path);
	void (*update_ghosts) (Pathbar* self, const gchar* non_ghost_path, gboolean is_search);
	void (*get_complete_path) (Pathbar* self, gchar** _complete_path);
	void (*get_fallback_path_and_complete_path) (Pathbar* self, gchar** _fallback_path, gchar** _complete_path);
	gchar* (*get_selected_child) (Pathbar* self, const gchar* current_path);
};

struct _ShortPathbar {
	GtkGrid parent_instance;
	ShortPathbarPrivate * priv;
};

struct _ShortPathbarClass {
	GtkGridClass parent_class;
};

struct _ShortPathbarPrivate {
	gchar* non_ghost_path;
	gchar* complete_path;
	GtkMenuButton* menu_button;
	GtkLabel* view_label;
	gint event_x;
};

static gint ShortPathbar_private_offset;
static gpointer short_pathbar_parent_class = NULL;
static PathbarIface * short_pathbar_pathbar_parent_iface = NULL;

VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pathbar_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType short_pathbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ShortPathbar, g_object_unref)
static void short_pathbar_real_get_complete_path (Pathbar* base,
                                           gchar** _complete_path);
static void short_pathbar_real_get_fallback_path_and_complete_path (Pathbar* base,
                                                             gchar** _fallback_path,
                                                             gchar** _complete_path);
VALA_EXTERN gboolean model_utils_is_folder_path (const gchar* path);
VALA_EXTERN ShortPathbar* short_pathbar_new (const gchar* complete_path_or_empty,
                                 ViewType type,
                                 const gchar* path);
VALA_EXTERN ShortPathbar* short_pathbar_construct (GType object_type,
                                       const gchar* complete_path_or_empty,
                                       ViewType type,
                                       const gchar* path);
VALA_EXTERN void pathbar_set_path (Pathbar* self,
                       ViewType type,
                       const gchar* path);
static gboolean short_pathbar_on_button_press_event (ShortPathbar* self,
                                              GtkWidget* widget,
                                              GdkEventButton* event);
static gboolean _short_pathbar_on_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                             GdkEventButton* event,
                                                                             gpointer self);
static void short_pathbar_on_button_clicked (ShortPathbar* self,
                                      GtkButton* button);
static void _short_pathbar_on_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static gboolean short_pathbar_real_has_popover (Pathbar* base);
static void short_pathbar_real_close_menu (Pathbar* base);
static void short_pathbar_real_toggle_menu (Pathbar* base);
static void short_pathbar_real_set_path (Pathbar* base,
                                  ViewType type,
                                  const gchar* path);
VALA_EXTERN gchar* model_utils_get_name (const gchar* path);
static void short_pathbar_update_menu (ShortPathbar* self);
static void short_pathbar_real_update_ghosts (Pathbar* base,
                                       const gchar* _non_ghost_path,
                                       gboolean is_search);
static void _short_pathbar_update_menu (const gchar* complete_path,
                                 const gchar* non_ghost_path,
                                 GMenu** menu);
static gchar** _vala_array_dup14 (gchar** self,
                           gssize length);
VALA_EXTERN void pathbar_populate_pathbar_menu (gboolean is_folder,
                                    GMenu** menu);
VALA_EXTERN void pathbar_get_complete_path (Pathbar* self,
                                gchar** _complete_path);
VALA_EXTERN void pathbar_get_fallback_path_and_complete_path (Pathbar* self,
                                                  gchar** _fallback_path,
                                                  gchar** _complete_path);
VALA_EXTERN gboolean pathbar_has_popover (Pathbar* self);
VALA_EXTERN void pathbar_close_menu (Pathbar* self);
VALA_EXTERN void pathbar_toggle_menu (Pathbar* self);
VALA_EXTERN void pathbar_update_ghosts (Pathbar* self,
                            const gchar* non_ghost_path,
                            gboolean is_search);
static void short_pathbar_finalize (GObject * obj);
static GType short_pathbar_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
short_pathbar_get_instance_private (ShortPathbar* self)
{
	return G_STRUCT_MEMBER_P (self, ShortPathbar_private_offset);
}

static void
short_pathbar_real_get_complete_path (Pathbar* base,
                                      gchar** _complete_path)
{
	ShortPathbar * self;
	gchar* _vala__complete_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ShortPathbar*) base;
	_tmp0_ = self->priv->complete_path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_vala__complete_path);
	_vala__complete_path = _tmp1_;
	if (_complete_path) {
		*_complete_path = _vala__complete_path;
	} else {
		_g_free0 (_vala__complete_path);
	}
}

static void
short_pathbar_real_get_fallback_path_and_complete_path (Pathbar* base,
                                                        gchar** _fallback_path,
                                                        gchar** _complete_path)
{
	ShortPathbar * self;
	gchar* _vala__fallback_path = NULL;
	gchar* _vala__complete_path = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	self = (ShortPathbar*) base;
	_tmp2_ = self->priv->non_ghost_path;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->non_ghost_path;
		_tmp1_ = model_utils_is_folder_path (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->complete_path;
		_tmp5_ = self->priv->non_ghost_path;
		_tmp0_ = g_str_has_prefix (_tmp4_, _tmp5_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = self->priv->non_ghost_path;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (_vala__fallback_path);
		_vala__fallback_path = _tmp7_;
	} else {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->complete_path;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (_vala__fallback_path);
		_vala__fallback_path = _tmp9_;
	}
	_tmp10_ = self->priv->complete_path;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (_vala__complete_path);
	_vala__complete_path = _tmp11_;
	if (_fallback_path) {
		*_fallback_path = _vala__fallback_path;
	} else {
		_g_free0 (_vala__fallback_path);
	}
	if (_complete_path) {
		*_complete_path = _vala__complete_path;
	} else {
		_g_free0 (_vala__complete_path);
	}
}

ShortPathbar*
short_pathbar_construct (GType object_type,
                         const gchar* complete_path_or_empty,
                         ViewType type,
                         const gchar* path)
{
	ShortPathbar * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (complete_path_or_empty != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	self = (ShortPathbar*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (complete_path_or_empty);
	_g_free0 (self->priv->complete_path);
	self->priv->complete_path = _tmp0_;
	_tmp1_ = g_strdup (complete_path_or_empty);
	_g_free0 (self->priv->non_ghost_path);
	self->priv->non_ghost_path = _tmp1_;
	pathbar_set_path ((Pathbar*) self, type, path);
	return self;
}

ShortPathbar*
short_pathbar_new (const gchar* complete_path_or_empty,
                   ViewType type,
                   const gchar* path)
{
	return short_pathbar_construct (TYPE_SHORT_PATHBAR, complete_path_or_empty, type, path);
}

static gboolean
short_pathbar_on_button_press_event (ShortPathbar* self,
                                     GtkWidget* widget,
                                     GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->event_x = (gint) event->x;
	result = FALSE;
	return result;
}

static gboolean
_short_pathbar_on_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                    GdkEventButton* event,
                                                                    gpointer self)
{
	gboolean result;
	result = short_pathbar_on_button_press_event ((ShortPathbar*) self, _sender, event);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
short_pathbar_on_button_clicked (ShortPathbar* self,
                                 GtkButton* button)
{
	GtkMenuButton* menu_button = NULL;
	GtkMenuButton* _tmp0_;
	GtkPopover* popover = NULL;
	GtkPopover* _tmp1_;
	GtkPopover* _tmp2_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp3_ = {0};
	GdkRectangle rect = {0};
	GtkAllocation _tmp4_;
	GdkRectangle _tmp5_ = {0};
	GdkRectangle _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (button, gtk_menu_button_get_type (), GtkMenuButton));
	menu_button = _tmp0_;
	_tmp1_ = gtk_menu_button_get_popover (menu_button);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	popover = _tmp2_;
	if (popover == NULL) {
		g_assert_not_reached ();
	}
	gtk_widget_get_allocated_size ((GtkWidget*) menu_button, &_tmp3_, NULL);
	allocation = _tmp3_;
	_tmp4_ = allocation;
	_tmp5_.x = self->priv->event_x;
	_tmp5_.y = _tmp4_.height;
	_tmp5_.width = 0;
	_tmp5_.height = 0;
	rect = _tmp5_;
	_tmp6_ = rect;
	gtk_popover_set_pointing_to (G_TYPE_CHECK_INSTANCE_CAST (popover, gtk_popover_get_type (), GtkPopover), &_tmp6_);
	_g_object_unref0 (popover);
	_g_object_unref0 (menu_button);
}

static void
_short_pathbar_on_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	short_pathbar_on_button_clicked ((ShortPathbar*) self, _sender);
}

static gboolean
short_pathbar_real_has_popover (Pathbar* base)
{
	ShortPathbar * self;
	GtkMenuButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (ShortPathbar*) base;
	_tmp0_ = self->priv->menu_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
short_pathbar_real_close_menu (Pathbar* base)
{
	ShortPathbar * self;
	GtkMenuButton* _tmp0_;
	self = (ShortPathbar*) base;
	_tmp0_ = self->priv->menu_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, FALSE);
}

static void
short_pathbar_real_toggle_menu (Pathbar* base)
{
	ShortPathbar * self;
	GtkMenuButton* _tmp0_;
	GtkMenuButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (ShortPathbar*) base;
	_tmp0_ = self->priv->menu_button;
	_tmp1_ = self->priv->menu_button;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, !_tmp3_);
}

static void
short_pathbar_real_set_path (Pathbar* base,
                             ViewType type,
                             const gchar* path)
{
	ShortPathbar * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GtkLabel* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self = (ShortPathbar*) base;
	g_return_if_fail (path != NULL);
	if (type == VIEW_TYPE_SEARCH) {
		return;
	}
	_tmp2_ = self->priv->complete_path;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = !g_str_has_suffix (path, "/");
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->complete_path;
		_tmp0_ = !g_str_has_prefix (_tmp3_, path);
	}
	if (_tmp0_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup (path);
		_g_free0 (self->priv->complete_path);
		self->priv->complete_path = _tmp4_;
		_tmp5_ = g_strdup (path);
		_g_free0 (self->priv->non_ghost_path);
		self->priv->non_ghost_path = _tmp5_;
	}
	_tmp6_ = self->priv->view_label;
	_tmp7_ = model_utils_get_name (path);
	_tmp8_ = _tmp7_;
	gtk_label_set_text (_tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
	short_pathbar_update_menu (self);
}

static void
short_pathbar_real_update_ghosts (Pathbar* base,
                                  const gchar* _non_ghost_path,
                                  gboolean is_search)
{
	ShortPathbar * self;
	gchar* _tmp0_;
	self = (ShortPathbar*) base;
	g_return_if_fail (_non_ghost_path != NULL);
	_tmp0_ = g_strdup (_non_ghost_path);
	_g_free0 (self->priv->non_ghost_path);
	self->priv->non_ghost_path = _tmp0_;
	short_pathbar_update_menu (self);
}

static void
short_pathbar_update_menu (ShortPathbar* self)
{
	GMenu* menu = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GMenu* _tmp2_ = NULL;
	GtkMenuButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->complete_path;
	_tmp1_ = self->priv->non_ghost_path;
	_short_pathbar_update_menu (_tmp0_, _tmp1_, &_tmp2_);
	_g_object_unref0 (menu);
	menu = _tmp2_;
	_tmp3_ = self->priv->menu_button;
	gtk_menu_button_set_menu_model (_tmp3_, (GMenuModel*) menu);
	_g_object_unref0 (menu);
}

static gchar**
_vala_array_dup14 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_short_pathbar_update_menu (const gchar* complete_path,
                            const gchar* non_ghost_path,
                            GMenu** menu)
{
	GMenu* _vala_menu = NULL;
	GMenu* _tmp0_;
	GMenu* section = NULL;
	GMenu* _tmp1_;
	gchar** split = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint split_length1;
	gint _split_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* last = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* tmp_path = NULL;
	gchar* _tmp12_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp42_;
	GMenu* _tmp70_;
	const gchar* _tmp71_;
	GMenu* _tmp72_;
	g_return_if_fail (complete_path != NULL);
	g_return_if_fail (non_ghost_path != NULL);
	_tmp0_ = g_menu_new ();
	_g_object_unref0 (_vala_menu);
	_vala_menu = _tmp0_;
	_tmp1_ = g_menu_new ();
	section = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (complete_path, "/", 0);
	split = _tmp3_;
	split_length1 = _vala_array_length (_tmp2_);
	_split_size_ = split_length1;
	_tmp4_ = split;
	_tmp4__length1 = split_length1;
	if (_tmp4__length1 < 2) {
		g_assert_not_reached ();
	}
	_tmp5_ = split;
	_tmp5__length1 = split_length1;
	_tmp6_ = split;
	_tmp6__length1 = split_length1;
	_tmp7_ = _tmp5_[_tmp6__length1 - 1];
	_tmp8_ = g_strdup (_tmp7_);
	last = _tmp8_;
	_tmp9_ = split;
	_tmp9__length1 = split_length1;
	_tmp10_ = split;
	_tmp10__length1 = split_length1;
	_tmp11_ = (_tmp9_ != NULL) ? _vala_array_dup14 (_tmp9_ + 1, (_tmp10__length1 - 1) - 1) : _tmp9_;
	_tmp11__length1 = (_tmp10__length1 - 1) - 1;
	split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
	split = _tmp11_;
	split_length1 = _tmp11__length1;
	_split_size_ = split_length1;
	_tmp12_ = g_strdup ("/");
	tmp_path = _tmp12_;
	if (g_strcmp0 (complete_path, "/") != 0) {
		GMenu* _tmp13_;
		_tmp13_ = _vala_menu;
		g_menu_append (_tmp13_, "/", "browser.open-path(('/',uint16 " MODEL_UTILS_folder_context_id_string "))");
	}
	_tmp14_ = split;
	_tmp14__length1 = split_length1;
	{
		gchar** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp14_;
		item_collection_length1 = _tmp14__length1;
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			gchar* _tmp15_;
			gchar* item = NULL;
			_tmp15_ = g_strdup (item_collection[item_it]);
			item = _tmp15_;
			{
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				GVariant* variant = NULL;
				const gchar* _tmp21_;
				GVariant* _tmp22_;
				const gchar* _tmp23_;
				_tmp16_ = tmp_path;
				_tmp17_ = item;
				_tmp18_ = g_strconcat (_tmp17_, "/", NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
				_g_free0 (tmp_path);
				tmp_path = _tmp20_;
				_g_free0 (_tmp19_);
				_tmp21_ = tmp_path;
				_tmp22_ = g_variant_new ("(sq)", _tmp21_, MODEL_UTILS_folder_context_id, NULL);
				g_variant_ref_sink (_tmp22_);
				variant = _tmp22_;
				_tmp23_ = tmp_path;
				if (g_str_has_prefix (non_ghost_path, _tmp23_)) {
					GMenu* _tmp24_;
					const gchar* _tmp25_;
					GVariant* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp24_ = _vala_menu;
					_tmp25_ = item;
					_tmp26_ = variant;
					_tmp27_ = g_variant_print (_tmp26_, TRUE);
					_tmp28_ = _tmp27_;
					_tmp29_ = g_strconcat ("browser.open-path(", _tmp28_, NULL);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_strconcat (_tmp30_, ")", NULL);
					_tmp32_ = _tmp31_;
					g_menu_append (_tmp24_, _tmp25_, _tmp32_);
					_g_free0 (_tmp32_);
					_g_free0 (_tmp30_);
					_g_free0 (_tmp28_);
				} else {
					GMenu* _tmp33_;
					const gchar* _tmp34_;
					GVariant* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					_tmp33_ = _vala_menu;
					_tmp34_ = item;
					_tmp35_ = variant;
					_tmp36_ = g_variant_print (_tmp35_, TRUE);
					_tmp37_ = _tmp36_;
					_tmp38_ = g_strconcat ("browser.disabled-state-sq(", _tmp37_, NULL);
					_tmp39_ = _tmp38_;
					_tmp40_ = g_strconcat (_tmp39_, ")", NULL);
					_tmp41_ = _tmp40_;
					g_menu_append (_tmp33_, _tmp34_, _tmp41_);
					_g_free0 (_tmp41_);
					_g_free0 (_tmp39_);
					_g_free0 (_tmp37_);
				}
				_g_variant_unref0 (variant);
				_g_free0 (item);
			}
		}
	}
	_tmp42_ = last;
	if (g_strcmp0 (_tmp42_, "") != 0) {
		gboolean is_folder = FALSE;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		guint16 _tmp48_ = 0U;
		guint16 context_id = 0U;
		GVariant* variant = NULL;
		const gchar* _tmp49_;
		GVariant* _tmp50_;
		const gchar* _tmp51_;
		is_folder = model_utils_is_folder_path (complete_path);
		_tmp43_ = tmp_path;
		_tmp44_ = last;
		_tmp45_ = g_strconcat (_tmp43_, _tmp44_, NULL);
		_g_free0 (tmp_path);
		tmp_path = _tmp45_;
		if (is_folder) {
			const gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp46_ = tmp_path;
			_tmp47_ = g_strconcat (_tmp46_, "/", NULL);
			_g_free0 (tmp_path);
			tmp_path = _tmp47_;
		}
		if (is_folder) {
			_tmp48_ = MODEL_UTILS_folder_context_id;
		} else {
			_tmp48_ = MODEL_UTILS_undefined_context_id;
		}
		context_id = _tmp48_;
		_tmp49_ = tmp_path;
		_tmp50_ = g_variant_new ("(sq)", _tmp49_, context_id, NULL);
		g_variant_ref_sink (_tmp50_);
		variant = _tmp50_;
		_tmp51_ = tmp_path;
		if (g_str_has_prefix (non_ghost_path, _tmp51_)) {
			GMenu* _tmp52_;
			const gchar* _tmp53_;
			GVariant* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			_tmp52_ = _vala_menu;
			_tmp53_ = last;
			_tmp54_ = variant;
			_tmp55_ = g_variant_print (_tmp54_, TRUE);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strconcat ("browser.open-path(", _tmp56_, NULL);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strconcat (_tmp58_, ")", NULL);
			_tmp60_ = _tmp59_;
			g_menu_append (_tmp52_, _tmp53_, _tmp60_);
			_g_free0 (_tmp60_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
		} else {
			GMenu* _tmp61_;
			const gchar* _tmp62_;
			GVariant* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			_tmp61_ = _vala_menu;
			_tmp62_ = last;
			_tmp63_ = variant;
			_tmp64_ = g_variant_print (_tmp63_, TRUE);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strconcat ("browser.disabled-state-sq(", _tmp65_, NULL);
			_tmp67_ = _tmp66_;
			_tmp68_ = g_strconcat (_tmp67_, ")", NULL);
			_tmp69_ = _tmp68_;
			g_menu_append (_tmp61_, _tmp62_, _tmp69_);
			_g_free0 (_tmp69_);
			_g_free0 (_tmp67_);
			_g_free0 (_tmp65_);
		}
		_g_variant_unref0 (variant);
	}
	g_menu_freeze (section);
	_tmp70_ = _vala_menu;
	g_menu_append_section (_tmp70_, NULL, (GMenuModel*) section);
	_tmp71_ = last;
	pathbar_populate_pathbar_menu (g_strcmp0 (_tmp71_, "") == 0, &_vala_menu);
	_tmp72_ = _vala_menu;
	g_menu_freeze (_tmp72_);
	_g_free0 (tmp_path);
	_g_free0 (last);
	split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (section);
	if (menu) {
		*menu = _vala_menu;
	} else {
		_g_object_unref0 (_vala_menu);
	}
}

static void
short_pathbar_class_init (ShortPathbarClass * klass,
                          gpointer klass_data)
{
	short_pathbar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ShortPathbar_private_offset);
	G_OBJECT_CLASS (klass)->finalize = short_pathbar_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/short-pathbar.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, ShortPathbar_private_offset + G_STRUCT_OFFSET (ShortPathbarPrivate, menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "view_label", FALSE, ShortPathbar_private_offset + G_STRUCT_OFFSET (ShortPathbarPrivate, view_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_button_press_event", G_CALLBACK(_short_pathbar_on_button_press_event_gtk_widget_button_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_button_clicked", G_CALLBACK(_short_pathbar_on_button_clicked_gtk_button_clicked));
}

static void
short_pathbar_pathbar_interface_init (PathbarIface * iface,
                                      gpointer iface_data)
{
	short_pathbar_pathbar_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_complete_path = (void (*) (Pathbar*, gchar**)) short_pathbar_real_get_complete_path;
	iface->get_fallback_path_and_complete_path = (void (*) (Pathbar*, gchar**, gchar**)) short_pathbar_real_get_fallback_path_and_complete_path;
	iface->has_popover = (gboolean (*) (Pathbar*)) short_pathbar_real_has_popover;
	iface->close_menu = (void (*) (Pathbar*)) short_pathbar_real_close_menu;
	iface->toggle_menu = (void (*) (Pathbar*)) short_pathbar_real_toggle_menu;
	iface->set_path = (void (*) (Pathbar*, ViewType, const gchar*)) short_pathbar_real_set_path;
	iface->update_ghosts = (void (*) (Pathbar*, const gchar*, gboolean)) short_pathbar_real_update_ghosts;
}

static void
short_pathbar_instance_init (ShortPathbar * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = short_pathbar_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->non_ghost_path = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->complete_path = _tmp1_;
	self->priv->event_x = 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
short_pathbar_finalize (GObject * obj)
{
	ShortPathbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHORT_PATHBAR, ShortPathbar);
	_g_free0 (self->priv->non_ghost_path);
	_g_free0 (self->priv->complete_path);
	G_OBJECT_CLASS (short_pathbar_parent_class)->finalize (obj);
}

static GType
short_pathbar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ShortPathbarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) short_pathbar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShortPathbar), 0, (GInstanceInitFunc) short_pathbar_instance_init, NULL };
	static const GInterfaceInfo pathbar_info = { (GInterfaceInitFunc) short_pathbar_pathbar_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType short_pathbar_type_id;
	short_pathbar_type_id = g_type_register_static (gtk_grid_get_type (), "ShortPathbar", &g_define_type_info, 0);
	g_type_add_interface_static (short_pathbar_type_id, TYPE_PATHBAR, &pathbar_info);
	ShortPathbar_private_offset = g_type_add_instance_private (short_pathbar_type_id, sizeof (ShortPathbarPrivate));
	return short_pathbar_type_id;
}

GType
short_pathbar_get_type (void)
{
	static volatile gsize short_pathbar_type_id__once = 0;
	if (g_once_init_enter (&short_pathbar_type_id__once)) {
		GType short_pathbar_type_id;
		short_pathbar_type_id = short_pathbar_get_type_once ();
		g_once_init_leave (&short_pathbar_type_id__once, short_pathbar_type_id);
	}
	return short_pathbar_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

