/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__UF_H
#define CVC4__OPTIONS__UF_H

#include "options/options.h"




#define CVC4_OPTIONS__UF__FOR_OPTION_HOLDER \
  ufSymmetryBreaker__option_t::type ufSymmetryBreaker;\
  bool ufSymmetryBreaker__setByUser__; \
  ufHo__option_t::type ufHo;\
  bool ufHo__setByUser__; \
  ufHoExt__option_t::type ufHoExt;\
  bool ufHoExt__setByUser__; \
  ufssAbortCardinality__option_t::type ufssAbortCardinality;\
  bool ufssAbortCardinality__setByUser__; \
  ufssFairness__option_t::type ufssFairness;\
  bool ufssFairness__setByUser__; \
  ufssFairnessMonotone__option_t::type ufssFairnessMonotone;\
  bool ufssFairnessMonotone__setByUser__; \
  ufssTotality__option_t::type ufssTotality;\
  bool ufssTotality__setByUser__; \
  ufssTotalityLimited__option_t::type ufssTotalityLimited;\
  bool ufssTotalityLimited__setByUser__; \
  ufssTotalitySymBreak__option_t::type ufssTotalitySymBreak;\
  bool ufssTotalitySymBreak__setByUser__; \
  ufssMode__option_t::type ufssMode;\
  bool ufssMode__setByUser__;


namespace CVC4 {

namespace options {


enum class UfssMode
{
  FULL,
  NO_MINIMAL,
  NONE
};
std::ostream&
operator<<(std::ostream& os, UfssMode mode) CVC4_PUBLIC;
UfssMode
stringToUfssMode(const std::string& option, const std::string& optarg);

extern struct CVC4_PUBLIC ufSymmetryBreaker__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} ufSymmetryBreaker CVC4_PUBLIC;
extern struct CVC4_PUBLIC ufHo__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} ufHo CVC4_PUBLIC;
extern struct CVC4_PUBLIC ufHoExt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} ufHoExt CVC4_PUBLIC;
extern struct CVC4_PUBLIC ufssAbortCardinality__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} ufssAbortCardinality CVC4_PUBLIC;
extern struct CVC4_PUBLIC ufssFairness__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} ufssFairness CVC4_PUBLIC;
extern struct CVC4_PUBLIC ufssFairnessMonotone__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} ufssFairnessMonotone CVC4_PUBLIC;
extern struct CVC4_PUBLIC ufssTotality__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} ufssTotality CVC4_PUBLIC;
extern struct CVC4_PUBLIC ufssTotalityLimited__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} ufssTotalityLimited CVC4_PUBLIC;
extern struct CVC4_PUBLIC ufssTotalitySymBreak__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} ufssTotalitySymBreak CVC4_PUBLIC;
extern struct CVC4_PUBLIC ufssMode__option_t
{
  typedef UfssMode type;
  type operator()() const;
  bool wasSetByUser() const;
} ufssMode CVC4_PUBLIC;

}  // namespace options

template <> void Options::set(
    options::ufSymmetryBreaker__option_t,
    const options::ufSymmetryBreaker__option_t::type& x);
template <> const options::ufSymmetryBreaker__option_t::type& Options::operator[](
    options::ufSymmetryBreaker__option_t) const;
template <> bool Options::wasSetByUser(options::ufSymmetryBreaker__option_t) const;
template <> void Options::assignBool(
    options::ufSymmetryBreaker__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::ufHo__option_t,
    const options::ufHo__option_t::type& x);
template <> const options::ufHo__option_t::type& Options::operator[](
    options::ufHo__option_t) const;
template <> bool Options::wasSetByUser(options::ufHo__option_t) const;
template <> void Options::assignBool(
    options::ufHo__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::ufHoExt__option_t,
    const options::ufHoExt__option_t::type& x);
template <> const options::ufHoExt__option_t::type& Options::operator[](
    options::ufHoExt__option_t) const;
template <> bool Options::wasSetByUser(options::ufHoExt__option_t) const;
template <> void Options::assignBool(
    options::ufHoExt__option_t,
    std::string option,
    bool value);
template <> const options::ufssAbortCardinality__option_t::type& Options::operator[](
    options::ufssAbortCardinality__option_t) const;
template <> bool Options::wasSetByUser(options::ufssAbortCardinality__option_t) const;
template <> void Options::assign(
    options::ufssAbortCardinality__option_t,
    std::string option,
    std::string value);
template <> const options::ufssFairness__option_t::type& Options::operator[](
    options::ufssFairness__option_t) const;
template <> bool Options::wasSetByUser(options::ufssFairness__option_t) const;
template <> void Options::assignBool(
    options::ufssFairness__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::ufssFairnessMonotone__option_t,
    const options::ufssFairnessMonotone__option_t::type& x);
template <> const options::ufssFairnessMonotone__option_t::type& Options::operator[](
    options::ufssFairnessMonotone__option_t) const;
template <> bool Options::wasSetByUser(options::ufssFairnessMonotone__option_t) const;
template <> void Options::assignBool(
    options::ufssFairnessMonotone__option_t,
    std::string option,
    bool value);
template <> const options::ufssTotality__option_t::type& Options::operator[](
    options::ufssTotality__option_t) const;
template <> bool Options::wasSetByUser(options::ufssTotality__option_t) const;
template <> void Options::assignBool(
    options::ufssTotality__option_t,
    std::string option,
    bool value);
template <> const options::ufssTotalityLimited__option_t::type& Options::operator[](
    options::ufssTotalityLimited__option_t) const;
template <> bool Options::wasSetByUser(options::ufssTotalityLimited__option_t) const;
template <> void Options::assign(
    options::ufssTotalityLimited__option_t,
    std::string option,
    std::string value);
template <> const options::ufssTotalitySymBreak__option_t::type& Options::operator[](
    options::ufssTotalitySymBreak__option_t) const;
template <> bool Options::wasSetByUser(options::ufssTotalitySymBreak__option_t) const;
template <> void Options::assignBool(
    options::ufssTotalitySymBreak__option_t,
    std::string option,
    bool value);
template <> const options::ufssMode__option_t::type& Options::operator[](
    options::ufssMode__option_t) const;
template <> bool Options::wasSetByUser(options::ufssMode__option_t) const;
template <> void Options::assign(
    options::ufssMode__option_t,
    std::string option,
    std::string value);


namespace options {

inline ufSymmetryBreaker__option_t::type ufSymmetryBreaker__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ufSymmetryBreaker__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void ufSymmetryBreaker__option_t::set(const ufSymmetryBreaker__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline ufHo__option_t::type ufHo__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ufHo__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void ufHo__option_t::set(const ufHo__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline ufHoExt__option_t::type ufHoExt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ufHoExt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void ufHoExt__option_t::set(const ufHoExt__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline ufssAbortCardinality__option_t::type ufssAbortCardinality__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ufssAbortCardinality__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline ufssFairness__option_t::type ufssFairness__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ufssFairness__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline ufssFairnessMonotone__option_t::type ufssFairnessMonotone__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ufssFairnessMonotone__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void ufssFairnessMonotone__option_t::set(const ufssFairnessMonotone__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline ufssTotality__option_t::type ufssTotality__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ufssTotality__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline ufssTotalityLimited__option_t::type ufssTotalityLimited__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ufssTotalityLimited__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline ufssTotalitySymBreak__option_t::type ufssTotalitySymBreak__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ufssTotalitySymBreak__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline ufssMode__option_t::type ufssMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ufssMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__UF_H */
