/* OtfFeatureTable.c generated by valac 0.56.17, the Vala compiler
 * generated from OtfFeatureTable.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <cairo-gobject.h>

#define BIRD_FONT_OTF_FEATURE_TABLE_NONE 0
#define BIRD_FONT_OTF_FEATURE_TABLE_OTF_FEATURE 1
#define BIRD_FONT_OTF_FEATURE_TABLE_SOURCE_GLYPH 2
#define BIRD_FONT_OTF_FEATURE_TABLE_REPLACEMENT_GLYPH 3
#define BIRD_FONT_OTF_FEATURE_TABLE_ALTERNATE_ENTRY 4
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_OTF_FEATURE_TABLE_0_PROPERTY,
	BIRD_FONT_OTF_FEATURE_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_otf_feature_table_properties[BIRD_FONT_OTF_FEATURE_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _Block38Data Block38Data;

struct _BirdFontOtfFeatureTablePrivate {
	GeeArrayList* rows;
	BirdFontGlyphCollection* glyph_collection;
	BirdFontGlyphCollection* replacement_glyph;
	gchar* alternate_name;
	BirdFontTextListener* listener;
	GeeArrayList* undo_items;
	gboolean ignore_input;
};

struct _Block38Data {
	int _ref_count_;
	BirdFontOtfFeatureTable* self;
	BirdFontGlyphCollection* gc;
	gchar* tag;
};

static gint BirdFontOtfFeatureTable_private_offset;
static gpointer bird_font_otf_feature_table_parent_class = NULL;

static void bird_font_otf_feature_table_real_selected_canvas (BirdFontFontDisplay* base);
static gboolean __lambda115_ (BirdFontOtfFeatureTable* self);
static gboolean ___lambda115__gsource_func (gpointer self);
static GeeArrayList* bird_font_otf_feature_table_real_get_rows (BirdFontTable* base);
static void bird_font_otf_feature_table_real_selected_row (BirdFontTable* base,
                                                    BirdFontRow* row,
                                                    gint column,
                                                    gboolean delete_button);
static void ___lambda116_ (BirdFontOtfFeatureTable* self,
                    BirdFontGlyphCollection* gc);
static void ____lambda116__bird_font_glyph_selection_selected_glyph (BirdFontGlyphSelection* _sender,
                                                              BirdFontGlyphCollection* gc,
                                                              gpointer self);
static void ____lambda222_ (BirdFontOtfFeatureTable* self,
                     BirdFontGlyphCollection* gc);
static void _____lambda222__bird_font_glyph_selection_selected_glyph (BirdFontGlyphSelection* _sender,
                                                               BirdFontGlyphCollection* gc,
                                                               gpointer self);
static void bird_font_otf_feature_table_real_update_rows (BirdFontTable* base);
static void bird_font_otf_feature_table_add_alternate_items (BirdFontOtfFeatureTable* self,
                                                      const gchar* tag);
static void bird_font_otf_feature_table_add_alternate_rows (BirdFontOtfFeatureTable* self,
                                                     BirdFontAlternate* alt);
static gchar* bird_font_otf_feature_table_real_get_label (BirdFontFontDisplay* base);
static gchar* bird_font_otf_feature_table_real_get_name (BirdFontFontDisplay* base);
static void bird_font_otf_feature_table_real_draw (BirdFontFontDisplay* base,
                                            BirdFontWidgetAllocation* allocation,
                                            cairo_t* cr);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static void __lambda223_ (BirdFontOtfFeatureTable* self,
                   const gchar* text);
static void ___lambda223__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda224_ (Block38Data* _data38_);
static void ___lambda224__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static void bird_font_otf_feature_table_real_undo (BirdFontFontDisplay* base);
static void bird_font_otf_feature_table_finalize (GObject * obj);
static GType bird_font_otf_feature_table_get_type_once (void);

static inline gpointer
bird_font_otf_feature_table_get_instance_private (BirdFontOtfFeatureTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontOtfFeatureTable_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontOtfFeatureTable*
bird_font_otf_feature_table_construct (GType object_type,
                                       BirdFontGlyphCollection* gc)
{
	BirdFontOtfFeatureTable * self = NULL;
	BirdFontGlyphCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	self = (BirdFontOtfFeatureTable*) bird_font_table_construct (object_type);
	_tmp0_ = _g_object_ref0 (gc);
	_g_object_unref0 (self->priv->glyph_collection);
	self->priv->glyph_collection = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_ALTERNATE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->undo_items);
	self->priv->undo_items = _tmp1_;
	return self;
}

BirdFontOtfFeatureTable*
bird_font_otf_feature_table_new (BirdFontGlyphCollection* gc)
{
	return bird_font_otf_feature_table_construct (BIRD_FONT_TYPE_OTF_FEATURE_TABLE, gc);
}

static gboolean
__lambda115_ (BirdFontOtfFeatureTable* self)
{
	gboolean result;
	self->priv->ignore_input = FALSE;
	result = FALSE;
	return result;
}

static gboolean
___lambda115__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda115_ ((BirdFontOtfFeatureTable*) self);
	return result;
}

static void
bird_font_otf_feature_table_real_selected_canvas (BirdFontFontDisplay* base)
{
	BirdFontOtfFeatureTable * self;
	GSource* input_delay = NULL;
	GSource* _tmp0_;
	self = (BirdFontOtfFeatureTable*) base;
	self->priv->ignore_input = TRUE;
	_tmp0_ = g_timeout_source_new ((guint) 250);
	input_delay = _tmp0_;
	g_source_set_callback (input_delay, ___lambda115__gsource_func, g_object_ref (self), g_object_unref);
	g_source_attach (input_delay, NULL);
	BIRD_FONT_FONT_DISPLAY_CLASS (bird_font_otf_feature_table_parent_class)->selected_canvas ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TABLE, BirdFontTable));
	_g_source_unref0 (input_delay);
}

static GeeArrayList*
bird_font_otf_feature_table_real_get_rows (BirdFontTable* base)
{
	BirdFontOtfFeatureTable * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
	self = (BirdFontOtfFeatureTable*) base;
	_tmp0_ = self->priv->rows;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
___lambda116_ (BirdFontOtfFeatureTable* self,
               BirdFontGlyphCollection* gc)
{
	BirdFontGlyphCollection* _tmp0_;
	BirdFontTabBar* _tmp1_;
	BirdFontTabBar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (gc != NULL);
	_tmp0_ = _g_object_ref0 (gc);
	_g_object_unref0 (self->priv->glyph_collection);
	self->priv->glyph_collection = _tmp0_;
	_g_object_unref0 (self->priv->replacement_glyph);
	self->priv->replacement_glyph = NULL;
	bird_font_tool_yield ();
	_tmp1_ = bird_font_main_window_get_tab_bar ();
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) self);
	_tmp4_ = _tmp3_;
	bird_font_tab_bar_select_tab_name (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}

static void
____lambda116__bird_font_glyph_selection_selected_glyph (BirdFontGlyphSelection* _sender,
                                                         BirdFontGlyphCollection* gc,
                                                         gpointer self)
{
	___lambda116_ ((BirdFontOtfFeatureTable*) self, gc);
}

static void
____lambda222_ (BirdFontOtfFeatureTable* self,
                BirdFontGlyphCollection* gc)
{
	BirdFontGlyphCollection* _tmp0_;
	BirdFontTabBar* _tmp1_;
	BirdFontTabBar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (gc != NULL);
	_tmp0_ = _g_object_ref0 (gc);
	_g_object_unref0 (self->priv->replacement_glyph);
	self->priv->replacement_glyph = _tmp0_;
	bird_font_tool_yield ();
	_tmp1_ = bird_font_main_window_get_tab_bar ();
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) self);
	_tmp4_ = _tmp3_;
	bird_font_tab_bar_select_tab_name (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}

static void
_____lambda222__bird_font_glyph_selection_selected_glyph (BirdFontGlyphSelection* _sender,
                                                          BirdFontGlyphCollection* gc,
                                                          gpointer self)
{
	____lambda222_ ((BirdFontOtfFeatureTable*) self, gc);
}

static void
bird_font_otf_feature_table_real_selected_row (BirdFontTable* base,
                                               BirdFontRow* row,
                                               gint column,
                                               gboolean delete_button)
{
	BirdFontOtfFeatureTable * self;
	gint row_index = 0;
	GObject* o = NULL;
	BirdFontString* s = NULL;
	BirdFontAlternateItem* a = NULL;
	self = (BirdFontOtfFeatureTable*) base;
	g_return_if_fail (row != NULL);
	row_index = bird_font_row_get_index (row);
	if (self->priv->ignore_input) {
		_g_object_unref0 (a);
		_g_object_unref0 (s);
		_g_object_unref0 (o);
		return;
	}
	if (row_index == BIRD_FONT_OTF_FEATURE_TABLE_SOURCE_GLYPH) {
		BirdFontGlyphSelection* gs = NULL;
		BirdFontGlyphSelection* _tmp0_;
		BirdFontGlyphSelection* _tmp1_;
		BirdFontGlyphSelection* _tmp2_;
		_tmp0_ = bird_font_glyph_selection_new ();
		gs = _tmp0_;
		_tmp1_ = gs;
		g_signal_connect_object (_tmp1_, "selected-glyph", (GCallback) ____lambda116__bird_font_glyph_selection_selected_glyph, self, 0);
		_tmp2_ = gs;
		bird_font_glyph_canvas_set_display ((BirdFontFontDisplay*) _tmp2_);
		_g_object_unref0 (gs);
	} else {
		if (row_index == BIRD_FONT_OTF_FEATURE_TABLE_REPLACEMENT_GLYPH) {
			BirdFontGlyphSelection* gs = NULL;
			BirdFontGlyphSelection* _tmp3_;
			BirdFontGlyphSelection* _tmp4_;
			BirdFontGlyphSelection* _tmp5_;
			_tmp3_ = bird_font_glyph_selection_new ();
			gs = _tmp3_;
			_tmp4_ = gs;
			g_signal_connect_object (_tmp4_, "selected-glyph", (GCallback) _____lambda222__bird_font_glyph_selection_selected_glyph, self, 0);
			_tmp5_ = gs;
			bird_font_glyph_canvas_set_display ((BirdFontFontDisplay*) _tmp5_);
			_g_object_unref0 (gs);
		} else {
			if (row_index == BIRD_FONT_OTF_FEATURE_TABLE_OTF_FEATURE) {
				GObject* _tmp6_;
				GObject* _tmp7_;
				GObject* _tmp8_;
				BirdFontString* _tmp9_;
				BirdFontString* _tmp10_;
				const gchar* _tmp11_;
				g_return_if_fail (bird_font_row_has_row_data (row));
				_tmp6_ = bird_font_row_get_row_data (row);
				_g_object_unref0 (o);
				o = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, G_TYPE_OBJECT, GObject);
				_tmp7_ = o;
				g_return_if_fail (BIRD_FONT_IS_STRING (_tmp7_));
				_tmp8_ = o;
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, BIRD_FONT_TYPE_STRING, BirdFontString));
				_g_object_unref0 (s);
				s = _tmp9_;
				_tmp10_ = s;
				_tmp11_ = _tmp10_->c_str;
				bird_font_otf_feature_table_add_new_alternate (self, _tmp11_);
			} else {
				if (row_index == BIRD_FONT_OTF_FEATURE_TABLE_ALTERNATE_ENTRY) {
					if (delete_button) {
						GObject* _tmp12_;
						GObject* _tmp13_;
						GObject* _tmp14_;
						BirdFontAlternateItem* _tmp15_;
						BirdFontAlternateItem* _tmp16_;
						BirdFontFont* f = NULL;
						BirdFontFont* _tmp17_;
						BirdFontFont* _tmp18_;
						BirdFontAlternateSets* _tmp19_;
						GeeArrayList* _tmp20_;
						BirdFontAlternateItem* _tmp21_;
						g_return_if_fail (bird_font_row_has_row_data (row));
						_tmp12_ = bird_font_row_get_row_data (row);
						_g_object_unref0 (o);
						o = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, G_TYPE_OBJECT, GObject);
						_tmp13_ = o;
						g_return_if_fail (BIRD_FONT_IS_ALTERNATE_ITEM (_tmp13_));
						_tmp14_ = o;
						_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, BIRD_FONT_TYPE_ALTERNATE_ITEM, BirdFontAlternateItem));
						_g_object_unref0 (a);
						a = _tmp15_;
						_tmp16_ = a;
						bird_font_alternate_item_delete_item_from_list (_tmp16_);
						_tmp17_ = bird_font_bird_font_get_current_font ();
						f = _tmp17_;
						_tmp18_ = f;
						_tmp19_ = _tmp18_->alternates;
						bird_font_alternate_sets_remove_empty_sets (_tmp19_);
						_tmp20_ = self->priv->undo_items;
						_tmp21_ = a;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
						bird_font_table_update_rows ((BirdFontTable*) self);
						bird_font_glyph_canvas_redraw ();
						_g_object_unref0 (f);
					}
				}
			}
		}
	}
	_g_object_unref0 (a);
	_g_object_unref0 (s);
	_g_object_unref0 (o);
}

static void
bird_font_otf_feature_table_real_update_rows (BirdFontTable* base)
{
	BirdFontOtfFeatureTable * self;
	BirdFontRow* row = NULL;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	GeeArrayList* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	BirdFontRow* _tmp4_;
	GeeArrayList* _tmp5_;
	BirdFontRow* _tmp6_;
	gchar* glyph = NULL;
	gchar* _tmp7_;
	BirdFontGlyphCollection* _tmp8_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	BirdFontRow* _tmp19_;
	GeeArrayList* _tmp20_;
	BirdFontRow* _tmp21_;
	gchar* replacement = NULL;
	gchar* _tmp22_;
	BirdFontGlyphCollection* _tmp23_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	BirdFontRow* _tmp35_;
	GeeArrayList* _tmp36_;
	BirdFontRow* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	BirdFontRow* _tmp40_;
	GeeArrayList* _tmp41_;
	BirdFontRow* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	BirdFontRow* _tmp45_;
	BirdFontRow* _tmp46_;
	BirdFontString* _tmp47_;
	BirdFontString* _tmp48_;
	GeeArrayList* _tmp49_;
	BirdFontRow* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	BirdFontRow* _tmp53_;
	BirdFontRow* _tmp54_;
	BirdFontString* _tmp55_;
	BirdFontString* _tmp56_;
	GeeArrayList* _tmp57_;
	BirdFontRow* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	BirdFontRow* _tmp61_;
	BirdFontRow* _tmp62_;
	BirdFontString* _tmp63_;
	BirdFontString* _tmp64_;
	GeeArrayList* _tmp65_;
	BirdFontRow* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	BirdFontRow* _tmp69_;
	BirdFontRow* _tmp70_;
	BirdFontString* _tmp71_;
	BirdFontString* _tmp72_;
	GeeArrayList* _tmp73_;
	BirdFontRow* _tmp74_;
	GeeArrayList* tags = NULL;
	BirdFontFont* _tmp75_;
	BirdFontAlternateSets* _tmp76_;
	GeeArrayList* _tmp77_;
	self = (BirdFontOtfFeatureTable*) base;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (font);
	font = _tmp0_;
	_tmp1_ = self->priv->rows;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_tmp2_ = bird_font_t_ ("Glyph Substitutions");
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_row_new_headline (_tmp3_);
	_g_object_unref0 (row);
	row = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp5_ = self->priv->rows;
	_tmp6_ = row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
	_tmp7_ = g_strdup ("");
	glyph = _tmp7_;
	_tmp8_ = self->priv->glyph_collection;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_;
		_tmp9_ = bird_font_t_ ("New glyph");
		_g_free0 (glyph);
		glyph = _tmp9_;
	} else {
		BirdFontGlyphCollection* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->priv->glyph_collection;
		_tmp11_ = bird_font_glyph_collection_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		_g_free0 (glyph);
		glyph = _tmp11_;
	}
	_tmp12_ = bird_font_t_ ("Glyph");
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, ": ", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = glyph;
	_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = bird_font_row_new_columns_1 (_tmp18_, BIRD_FONT_OTF_FEATURE_TABLE_SOURCE_GLYPH, FALSE);
	_g_object_unref0 (row);
	row = _tmp19_;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp20_ = self->priv->rows;
	_tmp21_ = row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
	_tmp22_ = bird_font_t_ ("New glyph");
	replacement = _tmp22_;
	_tmp23_ = self->priv->replacement_glyph;
	if (_tmp23_ != NULL) {
		BirdFontGlyphCollection* gc = NULL;
		BirdFontGlyphCollection* _tmp24_;
		BirdFontGlyphCollection* _tmp25_;
		BirdFontGlyphCollection* _tmp26_;
		gchar* _tmp27_;
		_tmp24_ = self->priv->replacement_glyph;
		_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		gc = _tmp25_;
		_tmp26_ = gc;
		_tmp27_ = bird_font_glyph_collection_get_name (_tmp26_);
		_g_free0 (replacement);
		replacement = _tmp27_;
		_g_object_unref0 (gc);
	}
	_tmp28_ = bird_font_t_ ("Replacement");
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat (_tmp29_, ": ", NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = replacement;
	_tmp33_ = g_strconcat (_tmp31_, _tmp32_, NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = bird_font_row_new_columns_1 (_tmp34_, BIRD_FONT_OTF_FEATURE_TABLE_REPLACEMENT_GLYPH, FALSE);
	_g_object_unref0 (row);
	row = _tmp35_;
	_g_free0 (_tmp34_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_tmp36_ = self->priv->rows;
	_tmp37_ = row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, _tmp37_);
	_tmp38_ = bird_font_t_ ("Tag");
	_tmp39_ = _tmp38_;
	_tmp40_ = bird_font_row_new_headline (_tmp39_);
	_g_object_unref0 (row);
	row = _tmp40_;
	_g_free0 (_tmp39_);
	_tmp41_ = self->priv->rows;
	_tmp42_ = row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp42_);
	_tmp43_ = bird_font_otf_label_get_string ("salt");
	_tmp44_ = _tmp43_;
	_tmp45_ = bird_font_row_new_columns_1 (_tmp44_, BIRD_FONT_OTF_FEATURE_TABLE_OTF_FEATURE, FALSE);
	_g_object_unref0 (row);
	row = _tmp45_;
	_g_free0 (_tmp44_);
	_tmp46_ = row;
	_tmp47_ = bird_font_string_new ("salt");
	_tmp48_ = _tmp47_;
	bird_font_row_set_row_data (_tmp46_, (GObject*) _tmp48_);
	_g_object_unref0 (_tmp48_);
	_tmp49_ = self->priv->rows;
	_tmp50_ = row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp50_);
	_tmp51_ = bird_font_otf_label_get_string ("smcp");
	_tmp52_ = _tmp51_;
	_tmp53_ = bird_font_row_new_columns_1 (_tmp52_, BIRD_FONT_OTF_FEATURE_TABLE_OTF_FEATURE, FALSE);
	_g_object_unref0 (row);
	row = _tmp53_;
	_g_free0 (_tmp52_);
	_tmp54_ = row;
	_tmp55_ = bird_font_string_new ("smcp");
	_tmp56_ = _tmp55_;
	bird_font_row_set_row_data (_tmp54_, (GObject*) _tmp56_);
	_g_object_unref0 (_tmp56_);
	_tmp57_ = self->priv->rows;
	_tmp58_ = row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, _tmp58_);
	_tmp59_ = bird_font_otf_label_get_string ("c2sc");
	_tmp60_ = _tmp59_;
	_tmp61_ = bird_font_row_new_columns_1 (_tmp60_, BIRD_FONT_OTF_FEATURE_TABLE_OTF_FEATURE, FALSE);
	_g_object_unref0 (row);
	row = _tmp61_;
	_g_free0 (_tmp60_);
	_tmp62_ = row;
	_tmp63_ = bird_font_string_new ("c2sc");
	_tmp64_ = _tmp63_;
	bird_font_row_set_row_data (_tmp62_, (GObject*) _tmp64_);
	_g_object_unref0 (_tmp64_);
	_tmp65_ = self->priv->rows;
	_tmp66_ = row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp65_, _tmp66_);
	_tmp67_ = bird_font_otf_label_get_string ("swsh");
	_tmp68_ = _tmp67_;
	_tmp69_ = bird_font_row_new_columns_1 (_tmp68_, BIRD_FONT_OTF_FEATURE_TABLE_OTF_FEATURE, FALSE);
	_g_object_unref0 (row);
	row = _tmp69_;
	_g_free0 (_tmp68_);
	_tmp70_ = row;
	_tmp71_ = bird_font_string_new ("swsh");
	_tmp72_ = _tmp71_;
	bird_font_row_set_row_data (_tmp70_, (GObject*) _tmp72_);
	_g_object_unref0 (_tmp72_);
	_tmp73_ = self->priv->rows;
	_tmp74_ = row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp73_, _tmp74_);
	_tmp75_ = font;
	_tmp76_ = _tmp75_->alternates;
	_tmp77_ = bird_font_alternate_sets_get_all_tags (_tmp76_);
	tags = _tmp77_;
	{
		GeeArrayList* _tag_list = NULL;
		GeeArrayList* _tmp78_;
		gint _tag_size = 0;
		GeeArrayList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _tag_index = 0;
		_tmp78_ = tags;
		_tag_list = _tmp78_;
		_tmp79_ = _tag_list;
		_tmp80_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_tag_size = _tmp81_;
		_tag_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gchar* tag = NULL;
			GeeArrayList* _tmp84_;
			gpointer _tmp85_;
			const gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			BirdFontRow* _tmp89_;
			GeeArrayList* _tmp90_;
			BirdFontRow* _tmp91_;
			const gchar* _tmp92_;
			_tag_index = _tag_index + 1;
			_tmp82_ = _tag_index;
			_tmp83_ = _tag_size;
			if (!(_tmp82_ < _tmp83_)) {
				break;
			}
			_tmp84_ = _tag_list;
			_tmp85_ = gee_abstract_list_get ((GeeAbstractList*) _tmp84_, _tag_index);
			tag = (gchar*) _tmp85_;
			_tmp86_ = tag;
			_tmp87_ = bird_font_otf_label_get_string (_tmp86_);
			_tmp88_ = _tmp87_;
			_tmp89_ = bird_font_row_new_headline (_tmp88_);
			_g_object_unref0 (row);
			row = _tmp89_;
			_g_free0 (_tmp88_);
			_tmp90_ = self->priv->rows;
			_tmp91_ = row;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp90_, _tmp91_);
			_tmp92_ = tag;
			bird_font_otf_feature_table_add_alternate_items (self, _tmp92_);
			_g_free0 (tag);
		}
	}
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (tags);
	_g_free0 (replacement);
	_g_free0 (glyph);
	_g_object_unref0 (font);
	_g_object_unref0 (row);
}

static void
bird_font_otf_feature_table_add_alternate_items (BirdFontOtfFeatureTable* self,
                                                 const gchar* tag)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	{
		GeeArrayList* _alt_list = NULL;
		BirdFontFont* _tmp1_;
		BirdFontAlternateSets* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _alt_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _alt_index = 0;
		_tmp1_ = font;
		_tmp2_ = _tmp1_->alternates;
		_tmp3_ = bird_font_alternate_sets_get_alt (_tmp2_, tag);
		_alt_list = _tmp3_;
		_tmp4_ = _alt_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_alt_size = _tmp6_;
		_alt_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontAlternate* alt = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontAlternate* _tmp11_;
			_alt_index = _alt_index + 1;
			_tmp7_ = _alt_index;
			_tmp8_ = _alt_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _alt_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _alt_index);
			alt = (BirdFontAlternate*) _tmp10_;
			_tmp11_ = alt;
			bird_font_otf_feature_table_add_alternate_rows (self, _tmp11_);
			_g_object_unref0 (alt);
		}
		_g_object_unref0 (_alt_list);
	}
	_g_object_unref0 (font);
}

static void
bird_font_otf_feature_table_add_alternate_rows (BirdFontOtfFeatureTable* self,
                                                BirdFontAlternate* alt)
{
	BirdFontRow* row = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alt != NULL);
	{
		GeeArrayList* _a_list = NULL;
		GeeArrayList* _tmp0_;
		gint _a_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _a_index = 0;
		_tmp0_ = alt->alternates;
		_a_list = _tmp0_;
		_tmp1_ = _a_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_a_size = _tmp3_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gchar* a = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			BirdFontRow* _tmp10_;
			BirdFontRow* _tmp11_;
			const gchar* _tmp12_;
			BirdFontAlternateItem* _tmp13_;
			BirdFontAlternateItem* _tmp14_;
			GeeArrayList* _tmp15_;
			BirdFontRow* _tmp16_;
			_a_index = _a_index + 1;
			_tmp4_ = _a_index;
			_tmp5_ = _a_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _a_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _a_index);
			a = (gchar*) _tmp7_;
			_tmp8_ = alt->glyph_name;
			_tmp9_ = a;
			_tmp10_ = bird_font_row_new_columns_2 (_tmp8_, _tmp9_, BIRD_FONT_OTF_FEATURE_TABLE_ALTERNATE_ENTRY, TRUE);
			_g_object_unref0 (row);
			row = _tmp10_;
			_tmp11_ = row;
			_tmp12_ = a;
			_tmp13_ = bird_font_alternate_item_new (alt, _tmp12_);
			_tmp14_ = _tmp13_;
			bird_font_row_set_row_data (_tmp11_, (GObject*) _tmp14_);
			_g_object_unref0 (_tmp14_);
			_tmp15_ = self->priv->rows;
			_tmp16_ = row;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
			_g_free0 (a);
		}
	}
	_g_object_unref0 (row);
}

static gchar*
bird_font_otf_feature_table_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontOtfFeatureTable * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontOtfFeatureTable*) base;
	_tmp0_ = bird_font_t_ ("Glyph Substitutions");
	result = _tmp0_;
	return result;
}

static gchar*
bird_font_otf_feature_table_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontOtfFeatureTable * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontOtfFeatureTable*) base;
	_tmp0_ = g_strdup ("Glyph Substitutions");
	result = _tmp0_;
	return result;
}

static void
bird_font_otf_feature_table_real_draw (BirdFontFontDisplay* base,
                                       BirdFontWidgetAllocation* allocation,
                                       cairo_t* cr)
{
	BirdFontOtfFeatureTable * self;
	self = (BirdFontOtfFeatureTable*) base;
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	BIRD_FONT_FONT_DISPLAY_CLASS (bird_font_otf_feature_table_parent_class)->draw ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TABLE, BirdFontTable), allocation, cr);
}

static Block38Data*
block38_data_ref (Block38Data* _data38_)
{
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}

static void
block38_data_unref (void * _userdata_)
{
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		BirdFontOtfFeatureTable* self;
		self = _data38_->self;
		_g_object_unref0 (_data38_->gc);
		_g_free0 (_data38_->tag);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}

static void
__lambda223_ (BirdFontOtfFeatureTable* self,
              const gchar* text)
{
	gchar* _tmp0_;
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (self->priv->alternate_name);
	self->priv->alternate_name = _tmp0_;
}

static void
___lambda223__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda223_ ((BirdFontOtfFeatureTable*) self, text);
}

static void
__lambda224_ (Block38Data* _data38_)
{
	BirdFontOtfFeatureTable* self;
	BirdFontGlyphCollection* alt = NULL;
	BirdFontFont* font = NULL;
	BirdFontOverview* overview = NULL;
	BirdFontOverview* _tmp0_;
	BirdFontFont* _tmp1_;
	BirdFontFont* _tmp2_;
	BirdFontGlyphTable* _tmp3_;
	const gchar* _tmp4_;
	self = _data38_->self;
	_tmp0_ = bird_font_main_window_get_overview ();
	overview = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (font);
	font = _tmp1_;
	_tmp2_ = font;
	_tmp3_ = _tmp2_->glyph_name;
	_tmp4_ = self->priv->alternate_name;
	if (bird_font_glyph_table_has_key (_tmp3_, _tmp4_)) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		BirdFontMessageDialog* _tmp7_;
		BirdFontMessageDialog* _tmp8_;
		_tmp5_ = bird_font_t_ ("All glyphs must have unique names.");
		_tmp6_ = _tmp5_;
		_tmp7_ = bird_font_main_window_show_message (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp8_);
		_g_free0 (_tmp6_);
	} else {
		const gchar* _tmp9_;
		BirdFontGlyphCollection* _tmp10_;
		BirdFontGlyphCollection* _tmp11_;
		BirdFontFont* _tmp12_;
		BirdFontGlyphCollection* _tmp13_;
		BirdFontGlyphCollection* _tmp14_;
		BirdFontOverview* _tmp15_;
		BirdFontOverview* _tmp16_;
		BirdFontOverview* _tmp17_;
		BirdFontGlyphCollection* _tmp18_;
		_tmp9_ = self->priv->alternate_name;
		_tmp10_ = bird_font_glyph_collection_new_with_glyph ((gunichar) '\0', _tmp9_);
		_g_object_unref0 (alt);
		alt = _tmp10_;
		_tmp11_ = alt;
		bird_font_glyph_collection_set_unassigned (_tmp11_, TRUE);
		_tmp12_ = font;
		_tmp13_ = _data38_->gc;
		_tmp14_ = alt;
		bird_font_font_add_new_alternate (_tmp12_, _tmp13_, _tmp14_, _data38_->tag);
		bird_font_table_update_rows ((BirdFontTable*) self);
		bird_font_glyph_canvas_redraw ();
		_tmp15_ = bird_font_main_window_get_overview ();
		_tmp16_ = _tmp15_;
		bird_font_overview_update_item_list (_tmp16_);
		_g_object_unref0 (_tmp16_);
		_tmp17_ = overview;
		_tmp18_ = alt;
		g_signal_emit_by_name (_tmp17_, "open-glyph-signal", _tmp18_);
	}
	_g_object_unref0 (overview);
	_g_object_unref0 (font);
	_g_object_unref0 (alt);
}

static void
___lambda224__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda224_ (self);
}

void
bird_font_otf_feature_table_add_new_alternate (BirdFontOtfFeatureTable* self,
                                               const gchar* tag)
{
	Block38Data* _data38_;
	gchar* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontGlyphCollection* _tmp6_;
	BirdFontGlyphCollection* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	BirdFontTextListener* _tmp12_;
	BirdFontTextListener* _tmp13_;
	BirdFontTextListener* _tmp14_;
	BirdFontGlyphCollection* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	_data38_->self = g_object_ref (self);
	_tmp0_ = g_strdup (tag);
	_g_free0 (_data38_->tag);
	_data38_->tag = _tmp0_;
	_tmp1_ = self->priv->glyph_collection;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		BirdFontMessageDialog* _tmp4_;
		BirdFontMessageDialog* _tmp5_;
		_tmp2_ = bird_font_t_ ("Select a glyph to create an alternate for.");
		_tmp3_ = _tmp2_;
		_tmp4_ = bird_font_main_window_show_message (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp5_);
		_g_free0 (_tmp3_);
		block38_data_unref (_data38_);
		_data38_ = NULL;
		return;
	}
	_tmp6_ = self->priv->glyph_collection;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
	_g_object_unref0 (_data38_->gc);
	_data38_->gc = _tmp7_;
	_tmp8_ = bird_font_t_ ("Glyph name");
	_tmp9_ = _tmp8_;
	_tmp10_ = bird_font_t_ ("Add");
	_tmp11_ = _tmp10_;
	_tmp12_ = bird_font_text_listener_new (_tmp9_, "", _tmp11_);
	_g_object_unref0 (self->priv->listener);
	self->priv->listener = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp13_ = self->priv->listener;
	g_signal_connect_object (_tmp13_, "signal-text-input", (GCallback) ___lambda223__bird_font_text_listener_signal_text_input, self, 0);
	_tmp14_ = self->priv->listener;
	g_signal_connect_data (_tmp14_, "signal-submit", (GCallback) ___lambda224__bird_font_text_listener_signal_submit, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
	_tmp15_ = self->priv->replacement_glyph;
	if (_tmp15_ != NULL) {
		BirdFontGlyphCollection* replacement = NULL;
		BirdFontGlyphCollection* _tmp16_;
		BirdFontGlyphCollection* _tmp17_;
		BirdFontFont* f = NULL;
		BirdFontFont* _tmp18_;
		BirdFontFont* _tmp19_;
		BirdFontGlyphCollection* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		BirdFontGlyphCollection* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp16_ = self->priv->replacement_glyph;
		_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		replacement = _tmp17_;
		_tmp18_ = bird_font_bird_font_get_current_font ();
		f = _tmp18_;
		_tmp19_ = f;
		_tmp20_ = _data38_->gc;
		_tmp21_ = bird_font_glyph_collection_get_name (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = replacement;
		_tmp24_ = bird_font_glyph_collection_get_name (_tmp23_);
		_tmp25_ = _tmp24_;
		bird_font_font_add_alternate (_tmp19_, _tmp22_, _tmp25_, _data38_->tag);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp22_);
		bird_font_table_update_rows ((BirdFontTable*) self);
		bird_font_glyph_canvas_redraw ();
		_g_object_unref0 (f);
		_g_object_unref0 (replacement);
	} else {
		BirdFontTextListener* _tmp26_;
		_tmp26_ = self->priv->listener;
		bird_font_tab_content_show_text_input (_tmp26_);
	}
	block38_data_unref (_data38_);
	_data38_ = NULL;
}

static void
bird_font_otf_feature_table_real_undo (BirdFontFontDisplay* base)
{
	BirdFontOtfFeatureTable * self;
	BirdFontAlternateItem* item = NULL;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (BirdFontOtfFeatureTable*) base;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (font);
	font = _tmp0_;
	_tmp1_ = self->priv->undo_items;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gpointer _tmp8_;
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gpointer _tmp13_;
		BirdFontAlternateItem* _tmp14_;
		BirdFontFont* _tmp15_;
		BirdFontAlternateItem* _tmp16_;
		BirdFontAlternate* _tmp17_;
		const gchar* _tmp18_;
		BirdFontAlternateItem* _tmp19_;
		const gchar* _tmp20_;
		BirdFontAlternateItem* _tmp21_;
		BirdFontAlternate* _tmp22_;
		const gchar* _tmp23_;
		_tmp4_ = self->priv->undo_items;
		_tmp5_ = self->priv->undo_items;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, _tmp7_ - 1);
		_g_object_unref0 (item);
		item = (BirdFontAlternateItem*) _tmp8_;
		_tmp9_ = self->priv->undo_items;
		_tmp10_ = self->priv->undo_items;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp9_, _tmp12_ - 1);
		_tmp14_ = (BirdFontAlternateItem*) _tmp13_;
		_g_object_unref0 (_tmp14_);
		_tmp15_ = font;
		_tmp16_ = item;
		_tmp17_ = _tmp16_->alternate_list;
		_tmp18_ = _tmp17_->glyph_name;
		_tmp19_ = item;
		_tmp20_ = _tmp19_->alternate;
		_tmp21_ = item;
		_tmp22_ = _tmp21_->alternate_list;
		_tmp23_ = _tmp22_->tag;
		bird_font_font_add_alternate (_tmp15_, _tmp18_, _tmp20_, _tmp23_);
		bird_font_table_update_rows ((BirdFontTable*) self);
		bird_font_glyph_canvas_redraw ();
	}
	_g_object_unref0 (font);
	_g_object_unref0 (item);
}

static void
bird_font_otf_feature_table_class_init (BirdFontOtfFeatureTableClass * klass,
                                        gpointer klass_data)
{
	bird_font_otf_feature_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontOtfFeatureTable_private_offset);
	((BirdFontFontDisplayClass *) klass)->selected_canvas = (void (*) (BirdFontFontDisplay*)) bird_font_otf_feature_table_real_selected_canvas;
	((BirdFontTableClass *) klass)->get_rows = (GeeArrayList* (*) (BirdFontTable*)) bird_font_otf_feature_table_real_get_rows;
	((BirdFontTableClass *) klass)->selected_row = (void (*) (BirdFontTable*, BirdFontRow*, gint, gboolean)) bird_font_otf_feature_table_real_selected_row;
	((BirdFontTableClass *) klass)->update_rows = (void (*) (BirdFontTable*)) bird_font_otf_feature_table_real_update_rows;
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_otf_feature_table_real_get_label;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_otf_feature_table_real_get_name;
	((BirdFontFontDisplayClass *) klass)->draw = (void (*) (BirdFontFontDisplay*, BirdFontWidgetAllocation*, cairo_t*)) bird_font_otf_feature_table_real_draw;
	((BirdFontFontDisplayClass *) klass)->undo = (void (*) (BirdFontFontDisplay*)) bird_font_otf_feature_table_real_undo;
	G_OBJECT_CLASS (klass)->finalize = bird_font_otf_feature_table_finalize;
}

static void
bird_font_otf_feature_table_instance_init (BirdFontOtfFeatureTable * self,
                                           gpointer klass)
{
	GeeArrayList* _tmp0_;
	gchar* _tmp1_;
	self->priv = bird_font_otf_feature_table_get_instance_private (self);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->rows = _tmp0_;
	self->priv->glyph_collection = NULL;
	self->priv->replacement_glyph = NULL;
	_tmp1_ = g_strdup ("");
	self->priv->alternate_name = _tmp1_;
	self->priv->ignore_input = FALSE;
}

static void
bird_font_otf_feature_table_finalize (GObject * obj)
{
	BirdFontOtfFeatureTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_OTF_FEATURE_TABLE, BirdFontOtfFeatureTable);
	_g_object_unref0 (self->priv->rows);
	_g_object_unref0 (self->priv->glyph_collection);
	_g_object_unref0 (self->priv->replacement_glyph);
	_g_free0 (self->priv->alternate_name);
	_g_object_unref0 (self->priv->listener);
	_g_object_unref0 (self->priv->undo_items);
	G_OBJECT_CLASS (bird_font_otf_feature_table_parent_class)->finalize (obj);
}

/** A table for managing feature tags in Open Type tables. */
static GType
bird_font_otf_feature_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontOtfFeatureTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_otf_feature_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontOtfFeatureTable), 0, (GInstanceInitFunc) bird_font_otf_feature_table_instance_init, NULL };
	GType bird_font_otf_feature_table_type_id;
	bird_font_otf_feature_table_type_id = g_type_register_static (BIRD_FONT_TYPE_TABLE, "BirdFontOtfFeatureTable", &g_define_type_info, 0);
	BirdFontOtfFeatureTable_private_offset = g_type_add_instance_private (bird_font_otf_feature_table_type_id, sizeof (BirdFontOtfFeatureTablePrivate));
	return bird_font_otf_feature_table_type_id;
}

GType
bird_font_otf_feature_table_get_type (void)
{
	static volatile gsize bird_font_otf_feature_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_otf_feature_table_type_id__once)) {
		GType bird_font_otf_feature_table_type_id;
		bird_font_otf_feature_table_type_id = bird_font_otf_feature_table_get_type_once ();
		g_once_init_leave (&bird_font_otf_feature_table_type_id__once, bird_font_otf_feature_table_type_id);
	}
	return bird_font_otf_feature_table_type_id__once;
}

