/* CheckBox.c generated by valac 0.56.17, the Vala compiler
 * generated from CheckBox.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_CHECK_BOX_0_PROPERTY,
	BIRD_FONT_CHECK_BOX_NUM_PROPERTIES
};
static GParamSpec* bird_font_check_box_properties[BIRD_FONT_CHECK_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BIRD_FONT_CHECK_BOX_UPDATED_SIGNAL,
	BIRD_FONT_CHECK_BOX_NUM_SIGNALS
};
static guint bird_font_check_box_signals[BIRD_FONT_CHECK_BOX_NUM_SIGNALS] = {0};

struct _BirdFontCheckBoxPrivate {
	gboolean has_focus;
};

static gint BirdFontCheckBox_private_offset;
static gpointer bird_font_check_box_parent_class = NULL;

static gdouble bird_font_check_box_real_get_height (BirdFontWidget* base);
static gdouble bird_font_check_box_real_get_width (BirdFontWidget* base);
static void bird_font_check_box_real_draw (BirdFontWidget* base,
                                    cairo_t* cr);
static void bird_font_check_box_real_key_press (BirdFontWidget* base,
                                         guint keyval);
static void bird_font_check_box_real_focus (BirdFontWidget* base,
                                     gboolean focus);
static void bird_font_check_box_finalize (GObject * obj);
static GType bird_font_check_box_get_type_once (void);

static inline gpointer
bird_font_check_box_get_instance_private (BirdFontCheckBox* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontCheckBox_private_offset);
}

BirdFontCheckBox*
bird_font_check_box_construct (GType object_type,
                               const gchar* text,
                               gdouble font_size)
{
	BirdFontCheckBox * self = NULL;
	BirdFontText* _tmp0_;
	BirdFontText* _tmp1_;
	g_return_val_if_fail (text != NULL, NULL);
	self = (BirdFontCheckBox*) bird_font_widget_construct (object_type);
	if (font_size < ((gdouble) 0)) {
		font_size = self->h;
	}
	_tmp0_ = bird_font_text_new (text, font_size, (gdouble) 0);
	_g_object_unref0 (self->label);
	self->label = _tmp0_;
	_tmp1_ = self->label;
	bird_font_theme_text_color (_tmp1_, "Text Foreground");
	return self;
}

BirdFontCheckBox*
bird_font_check_box_new (const gchar* text,
                         gdouble font_size)
{
	return bird_font_check_box_construct (BIRD_FONT_TYPE_CHECK_BOX, text, font_size);
}

void
bird_font_check_box_set_checked (BirdFontCheckBox* self,
                                 gboolean c)
{
	g_return_if_fail (self != NULL);
	self->checked = c;
	g_signal_emit (self, bird_font_check_box_signals[BIRD_FONT_CHECK_BOX_UPDATED_SIGNAL], 0, c);
}

static gdouble
bird_font_check_box_real_get_height (BirdFontWidget* base)
{
	BirdFontCheckBox * self;
	BirdFontText* _tmp0_;
	gdouble result;
	self = (BirdFontCheckBox*) base;
	_tmp0_ = self->label;
	result = _tmp0_->font_size;
	return result;
}

static gdouble
bird_font_check_box_real_get_width (BirdFontWidget* base)
{
	BirdFontCheckBox * self;
	BirdFontText* _tmp0_;
	gdouble result;
	self = (BirdFontCheckBox*) base;
	_tmp0_ = self->label;
	result = (self->w + (2 * self->padding)) + bird_font_text_get_sidebearing_extent (_tmp0_);
	return result;
}

static void
bird_font_check_box_real_draw (BirdFontWidget* base,
                               cairo_t* cr)
{
	BirdFontCheckBox * self;
	gdouble d = 0.0;
	gdouble center_y = 0.0;
	BirdFontText* _tmp0_;
	BirdFontText* _tmp1_;
	BirdFontText* _tmp2_;
	self = (BirdFontCheckBox*) base;
	g_return_if_fail (cr != NULL);
	d = self->w * 0.25;
	center_y = ((bird_font_widget_get_height ((BirdFontWidget*) self) - (self->h + (2 * self->padding))) / 2.0) + self->padding;
	cairo_save (cr);
	bird_font_theme_color (cr, "Checkbox Background");
	bird_font_widget_draw_rounded_rectangle (cr, ((BirdFontWidget*) self)->widget_x, ((BirdFontWidget*) self)->widget_y + center_y, self->w, self->h - self->padding, self->padding);
	cairo_fill (cr);
	cairo_restore (cr);
	cairo_save (cr);
	cairo_set_line_width (cr, (gdouble) 1);
	if (self->priv->has_focus) {
		bird_font_theme_color (cr, "Highlighted 1");
	} else {
		bird_font_theme_color (cr, "Text Foreground");
	}
	bird_font_widget_draw_rounded_rectangle (cr, ((BirdFontWidget*) self)->widget_x, ((BirdFontWidget*) self)->widget_y + center_y, self->w, self->h - self->padding, self->padding);
	cairo_stroke (cr);
	cairo_restore (cr);
	if (self->checked) {
		cairo_save (cr);
		bird_font_theme_color (cr, "Text Foreground");
		cairo_set_line_width (cr, (gdouble) 1);
		cairo_move_to (cr, ((BirdFontWidget*) self)->widget_x + d, (((BirdFontWidget*) self)->widget_y + d) + center_y);
		cairo_line_to (cr, (((BirdFontWidget*) self)->widget_x + self->w) - d, ((((BirdFontWidget*) self)->widget_y + self->h) - d) + center_y);
		cairo_stroke (cr);
		cairo_move_to (cr, (((BirdFontWidget*) self)->widget_x + self->w) - d, (((BirdFontWidget*) self)->widget_y + d) + center_y);
		cairo_line_to (cr, ((BirdFontWidget*) self)->widget_x + d, ((((BirdFontWidget*) self)->widget_y + self->h) - d) + center_y);
		cairo_stroke (cr);
		cairo_restore (cr);
	}
	_tmp0_ = self->label;
	((BirdFontWidget*) _tmp0_)->widget_x = ((BirdFontWidget*) self)->widget_x + (1.5 * self->w);
	_tmp1_ = self->label;
	((BirdFontWidget*) _tmp1_)->widget_y = ((BirdFontWidget*) self)->widget_y;
	_tmp2_ = self->label;
	bird_font_widget_draw ((BirdFontWidget*) _tmp2_, cr);
}

static void
bird_font_check_box_real_key_press (BirdFontWidget* base,
                                    guint keyval)
{
	BirdFontCheckBox * self;
	gunichar c = 0U;
	self = (BirdFontCheckBox*) base;
	c = (gunichar) keyval;
	if (c == ((gunichar) ' ')) {
		self->checked = !self->checked;
	}
}

static void
bird_font_check_box_real_focus (BirdFontWidget* base,
                                gboolean focus)
{
	BirdFontCheckBox * self;
	self = (BirdFontCheckBox*) base;
	self->priv->has_focus = focus;
}

static void
bird_font_check_box_class_init (BirdFontCheckBoxClass * klass,
                                gpointer klass_data)
{
	bird_font_check_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontCheckBox_private_offset);
	((BirdFontWidgetClass *) klass)->get_height = (gdouble (*) (BirdFontWidget*)) bird_font_check_box_real_get_height;
	((BirdFontWidgetClass *) klass)->get_width = (gdouble (*) (BirdFontWidget*)) bird_font_check_box_real_get_width;
	((BirdFontWidgetClass *) klass)->draw = (void (*) (BirdFontWidget*, cairo_t*)) bird_font_check_box_real_draw;
	((BirdFontWidgetClass *) klass)->key_press = (void (*) (BirdFontWidget*, guint)) bird_font_check_box_real_key_press;
	((BirdFontWidgetClass *) klass)->focus = (void (*) (BirdFontWidget*, gboolean)) bird_font_check_box_real_focus;
	G_OBJECT_CLASS (klass)->finalize = bird_font_check_box_finalize;
	bird_font_check_box_signals[BIRD_FONT_CHECK_BOX_UPDATED_SIGNAL] = g_signal_new ("updated", BIRD_FONT_TYPE_CHECK_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
bird_font_check_box_instance_init (BirdFontCheckBox * self,
                                   gpointer klass)
{
	self->priv = bird_font_check_box_get_instance_private (self);
	self->checked = FALSE;
	self->padding = 3.333;
	self->w = (gdouble) 12;
	self->h = (gdouble) 12;
	self->priv->has_focus = FALSE;
}

static void
bird_font_check_box_finalize (GObject * obj)
{
	BirdFontCheckBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_CHECK_BOX, BirdFontCheckBox);
	_g_object_unref0 (self->label);
	G_OBJECT_CLASS (bird_font_check_box_parent_class)->finalize (obj);
}

static GType
bird_font_check_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontCheckBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_check_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontCheckBox), 0, (GInstanceInitFunc) bird_font_check_box_instance_init, NULL };
	GType bird_font_check_box_type_id;
	bird_font_check_box_type_id = g_type_register_static (BIRD_FONT_TYPE_WIDGET, "BirdFontCheckBox", &g_define_type_info, 0);
	BirdFontCheckBox_private_offset = g_type_add_instance_private (bird_font_check_box_type_id, sizeof (BirdFontCheckBoxPrivate));
	return bird_font_check_box_type_id;
}

GType
bird_font_check_box_get_type (void)
{
	static volatile gsize bird_font_check_box_type_id__once = 0;
	if (g_once_init_enter (&bird_font_check_box_type_id__once)) {
		GType bird_font_check_box_type_id;
		bird_font_check_box_type_id = bird_font_check_box_get_type_once ();
		g_once_init_leave (&bird_font_check_box_type_id__once, bird_font_check_box_type_id);
	}
	return bird_font_check_box_type_id__once;
}

