/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: RISCV.td                                                             *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  FeatureBitset ComputeAvailableFeatures(const FeatureBitset &FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands,
                       const SmallBitVector &OptionalOperandsMask,
                       ArrayRef<unsigned> DefaultsOffset);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                FeatureBitset &MissingFeatures,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0) {
    FeatureBitset MissingFeatures;
    return MatchInstructionImpl(Operands, Inst, ErrorInfo, MissingFeatures,
                                matchingInlineAsm, VariantID);
  }

  ParseStatus MatchOperandParserImpl(
    OperandVector &Operands,
    StringRef Mnemonic,
    bool ParseForAllFeatures = false);
  ParseStatus tryCustomParseOperand(
    OperandVector &Operands,
    unsigned MCK);

#endif // GET_ASSEMBLER_HEADER


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

  Match_InvalidBareSImm11Lsb0,
  Match_InvalidBareSImm12Lsb0,
  Match_InvalidBareSImm13Lsb0,
  Match_InvalidBareSImm21Lsb0,
  Match_InvalidBareSImm32,
  Match_InvalidBareSImm32Lsb0,
  Match_InvalidBareSImm9Lsb0,
  Match_InvalidBareSymbol,
  Match_InvalidBareSymbolQC_E_LI,
  Match_InvalidCLUIImm,
  Match_InvalidCSRSystemRegister,
  Match_InvalidCallSymbol,
  Match_InvalidImmFour,
  Match_InvalidImmThree,
  Match_InvalidImmXLenLI,
  Match_InvalidImmXLenLI_Restricted,
  Match_InvalidImmZero,
  Match_InvalidLoadFPImm,
  Match_InvalidPseudoJumpSymbol,
  Match_InvalidRTZArg,
  Match_InvalidRegClassGPRNoX0,
  Match_InvalidRegClassGPRNoX0X2,
  Match_InvalidRegClassGPRX1,
  Match_InvalidRegClassGPRX1X5,
  Match_InvalidRegClassGPRX31,
  Match_InvalidRegClassGPRX5,
  Match_InvalidRegClassSP,
  Match_InvalidRegList,
  Match_InvalidRegListS0,
  Match_InvalidRnumArg,
  Match_InvalidSImm10,
  Match_InvalidSImm10Lsb0000NonZero,
  Match_InvalidSImm10Unsigned,
  Match_InvalidSImm11,
  Match_InvalidSImm12,
  Match_InvalidSImm12Lsb00000,
  Match_InvalidSImm16,
  Match_InvalidSImm16NonZero,
  Match_InvalidSImm18,
  Match_InvalidSImm18Lsb0,
  Match_InvalidSImm19Lsb00,
  Match_InvalidSImm20LI,
  Match_InvalidSImm20Lsb000,
  Match_InvalidSImm26,
  Match_InvalidSImm5,
  Match_InvalidSImm5NonZero,
  Match_InvalidSImm5Plus1,
  Match_InvalidSImm6,
  Match_InvalidSImm6NonZero,
  Match_InvalidStackAdj,
  Match_InvalidTLSDESCCallSymbol,
  Match_InvalidTPRelAddSymbol,
  Match_InvalidUImm1,
  Match_InvalidUImm10,
  Match_InvalidUImm10Lsb00NonZero,
  Match_InvalidUImm11,
  Match_InvalidUImm14Lsb00,
  Match_InvalidUImm16,
  Match_InvalidUImm16NonZero,
  Match_InvalidUImm2,
  Match_InvalidUImm20,
  Match_InvalidUImm20AUIPC,
  Match_InvalidUImm20LUI,
  Match_InvalidUImm2Lsb0,
  Match_InvalidUImm3,
  Match_InvalidUImm32,
  Match_InvalidUImm4,
  Match_InvalidUImm48,
  Match_InvalidUImm5,
  Match_InvalidUImm5GE6Plus1,
  Match_InvalidUImm5GT3,
  Match_InvalidUImm5Lsb0,
  Match_InvalidUImm5NonZero,
  Match_InvalidUImm5Plus1,
  Match_InvalidUImm5Slist,
  Match_InvalidUImm6,
  Match_InvalidUImm64,
  Match_InvalidUImm6Lsb0,
  Match_InvalidUImm7,
  Match_InvalidUImm7Lsb00,
  Match_InvalidUImm7Lsb000,
  Match_InvalidUImm8,
  Match_InvalidUImm8GE32,
  Match_InvalidUImm8Lsb00,
  Match_InvalidUImm8Lsb000,
  Match_InvalidUImm9,
  Match_InvalidUImm9Lsb000,
  Match_InvalidUImmLog2XLen,
  Match_InvalidUImmLog2XLenNonZero,
  Match_InvalidVMaskCarryInRegister,
  Match_InvalidVMaskRegister,
  Match_InvalidVTypeI,
  Match_InvalidXSfmmVType,
  END_OPERAND_DIAGNOSTIC_TYPES
#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtZicbomBit = 49,
  Feature_HasStdExtZicbopBit = 50,
  Feature_HasStdExtZicbozBit = 51,
  Feature_HasStdExtZicsrBit = 55,
  Feature_HasStdExtZicondBit = 54,
  Feature_HasStdExtZifenceiBit = 56,
  Feature_HasStdExtZihintpauseBit = 58,
  Feature_HasStdExtZihintntlBit = 57,
  Feature_HasStdExtZimopBit = 60,
  Feature_HasStdExtZicfilpBit = 52,
  Feature_NoStdExtZicfilpBit = 155,
  Feature_HasStdExtZicfissBit = 53,
  Feature_HasStdExtZilsdBit = 59,
  Feature_HasStdExtZmmulBit = 68,
  Feature_HasStdExtMBit = 9,
  Feature_HasStdExtZaamoBit = 15,
  Feature_HasStdExtZalrscBit = 19,
  Feature_HasStdExtABit = 1,
  Feature_HasStdExtZtsoBit = 69,
  Feature_HasStdExtZabhaBit = 16,
  Feature_HasStdExtZacasBit = 17,
  Feature_HasStdExtZalasrBit = 18,
  Feature_HasStdExtZawrsBit = 20,
  Feature_HasStdExtFBit = 6,
  Feature_HasStdExtDBit = 5,
  Feature_HasStdExtQBit = 11,
  Feature_HasStdExtZfhminBit = 45,
  Feature_HasStdExtZfhBit = 43,
  Feature_HasStdExtZfbfminBit = 42,
  Feature_HasHalfFPLoadStoreMoveBit = 0,
  Feature_HasStdExtZfaBit = 41,
  Feature_HasStdExtZfinxBit = 46,
  Feature_HasStdExtFOrZfinxBit = 7,
  Feature_HasStdExtZdinxBit = 40,
  Feature_HasStdExtZhinxminBit = 48,
  Feature_HasStdExtZhinxBit = 47,
  Feature_HasStdExtZcaBit = 34,
  Feature_HasStdExtCBit = 2,
  Feature_HasStdExtZcbBit = 35,
  Feature_HasStdExtCOrZcdBit = 3,
  Feature_HasStdExtZclsdBit = 36,
  Feature_HasStdExtZcmpBit = 38,
  Feature_HasStdExtZcmtBit = 39,
  Feature_HasStdExtCOrZcfOrZceBit = 4,
  Feature_HasStdExtZcmopBit = 37,
  Feature_HasStdExtZbaBit = 21,
  Feature_HasStdExtZbbBit = 23,
  Feature_NoStdExtZbbBit = 153,
  Feature_HasStdExtZbcBit = 27,
  Feature_HasStdExtZbsBit = 33,
  Feature_HasStdExtZbkbBit = 29,
  Feature_NoStdExtZbkbBit = 154,
  Feature_HasStdExtZbkxBit = 32,
  Feature_HasStdExtZbbOrZbkbBit = 25,
  Feature_HasStdExtZbkcBit = 31,
  Feature_HasStdExtZbcOrZbkcBit = 28,
  Feature_HasStdExtZkndBit = 61,
  Feature_HasStdExtZkneBit = 63,
  Feature_HasStdExtZkndOrZkneBit = 62,
  Feature_HasStdExtZknhBit = 64,
  Feature_HasStdExtZksedBit = 66,
  Feature_HasStdExtZkshBit = 67,
  Feature_HasStdExtZkrBit = 65,
  Feature_HasStdExtZvfbfminBit = 73,
  Feature_HasStdExtZvfbfwmaBit = 74,
  Feature_HasStdExtZfhOrZvfhBit = 44,
  Feature_HasStdExtZvkbBit = 75,
  Feature_HasStdExtZvbbBit = 70,
  Feature_HasStdExtZvbcBit = 71,
  Feature_HasStdExtZvbcOrZvbc32eBit = 72,
  Feature_HasStdExtZvkgBit = 76,
  Feature_HasStdExtZvkgsBit = 77,
  Feature_HasStdExtZvknedBit = 78,
  Feature_HasStdExtZvknhaBit = 79,
  Feature_HasStdExtZvknhbBit = 81,
  Feature_HasStdExtZvknhaOrZvknhbBit = 80,
  Feature_HasStdExtZvksedBit = 82,
  Feature_HasStdExtZvkshBit = 83,
  Feature_HasStdExtZvqdotqBit = 84,
  Feature_HasVInstructionsBit = 85,
  Feature_HasVInstructionsI64Bit = 88,
  Feature_HasVInstructionsAnyFBit = 86,
  Feature_HasVInstructionsF16MinimalBit = 87,
  Feature_HasStdExtHBit = 8,
  Feature_HasStdExtSmrnmiBit = 13,
  Feature_HasStdExtSvinvalBit = 14,
  Feature_HasStdExtSmctrOrSsctrBit = 12,
  Feature_HasStdExtPBit = 10,
  Feature_HasStdExtZbaOrPBit = 22,
  Feature_HasStdExtZbbOrPBit = 24,
  Feature_HasStdExtZbkbOrPBit = 30,
  Feature_HasStdExtZbbOrZbkbOrPBit = 26,
  Feature_HasVendorXVentanaCondOpsBit = 130,
  Feature_HasVendorXTHeadBaBit = 119,
  Feature_HasVendorXTHeadBbBit = 120,
  Feature_HasVendorXTHeadBsBit = 121,
  Feature_HasVendorXTHeadCondMovBit = 123,
  Feature_HasVendorXTHeadCmoBit = 122,
  Feature_HasVendorXTHeadFMemIdxBit = 124,
  Feature_HasVendorXTHeadMacBit = 125,
  Feature_HasVendorXTHeadMemIdxBit = 126,
  Feature_HasVendorXTHeadMemPairBit = 127,
  Feature_HasVendorXTHeadSyncBit = 128,
  Feature_HasVendorXTHeadVdotBit = 129,
  Feature_HasVendorXSfvcpBit = 112,
  Feature_HasVendorXSfmmbaseBit = 111,
  Feature_HasVendorXSfmm32a8fBit = 108,
  Feature_HasVendorXSfmm32a8iBit = 109,
  Feature_HasVendorXSfmm32a16fOrXSfmm32a32fOrXSfmm64a64fBit = 110,
  Feature_HasVendorXSfvqmaccdodBit = 115,
  Feature_HasVendorXSfvqmaccqoqBit = 116,
  Feature_HasVendorXSfvfwmaccqqqBit = 114,
  Feature_HasVendorXSfvfnrclipxfqfBit = 113,
  Feature_HasVendorXSiFivecdiscarddloneBit = 117,
  Feature_HasVendorXSiFivecflushdloneBit = 118,
  Feature_HasVendorXSfceaseBit = 107,
  Feature_HasVendorXCVelwBit = 98,
  Feature_HasVendorXCVbitmanipBit = 97,
  Feature_HasVendorXCVmacBit = 99,
  Feature_HasVendorXCVmemBit = 100,
  Feature_HasVendorXCValuBit = 95,
  Feature_HasVendorXCVsimdBit = 101,
  Feature_HasVendorXCVbiBit = 96,
  Feature_HasVendorXMIPSCMovBit = 103,
  Feature_HasVendorXMIPSLSPBit = 104,
  Feature_HasVendorXMIPSCBOPBit = 102,
  Feature_HasVendorXwchcBit = 150,
  Feature_HasVendorXqccmpBit = 131,
  Feature_HasVendorXqciaBit = 132,
  Feature_HasVendorXqciacBit = 133,
  Feature_HasVendorXqcibiBit = 134,
  Feature_HasVendorXqcibmBit = 135,
  Feature_HasVendorXqcicliBit = 136,
  Feature_HasVendorXqcicmBit = 137,
  Feature_HasVendorXqcicsBit = 138,
  Feature_HasVendorXqcicsrBit = 139,
  Feature_HasVendorXqciintBit = 140,
  Feature_HasVendorXqciioBit = 141,
  Feature_HasVendorXqcilbBit = 142,
  Feature_HasVendorXqciliBit = 143,
  Feature_HasVendorXqciliaBit = 144,
  Feature_HasVendorXqciloBit = 145,
  Feature_HasVendorXqcilsmBit = 146,
  Feature_HasVendorXqcisimBit = 147,
  Feature_HasVendorXqcislsBit = 148,
  Feature_HasVendorXqcisyncBit = 149,
  Feature_HasVendorXRivosVisniBit = 105,
  Feature_HasVendorXRivosVizipBit = 106,
  Feature_HasVendorXAndesPerfBit = 90,
  Feature_HasVendorXAndesBFHCvtBit = 89,
  Feature_HasVendorXAndesVBFHCvtBit = 91,
  Feature_HasVendorXAndesVSIntLoadBit = 94,
  Feature_HasVendorXAndesVPackFPHBit = 93,
  Feature_HasVendorXAndesVDotBit = 92,
  Feature_IsRV64Bit = 152,
  Feature_IsRV32Bit = 151,
};

static MCRegister MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 1 string to match.
    if (Name[0] != '0')
      break;
    return RISCV::DUMMY_REG_PAIR_WITH_X0;	 // "0"
  case 2:	 // 184 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 40 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 4 strings to match.
        return RISCV::F0_D;	 // "f0"
      case '1':	 // 4 strings to match.
        return RISCV::F1_D;	 // "f1"
      case '2':	 // 4 strings to match.
        return RISCV::F2_D;	 // "f2"
      case '3':	 // 4 strings to match.
        return RISCV::F3_D;	 // "f3"
      case '4':	 // 4 strings to match.
        return RISCV::F4_D;	 // "f4"
      case '5':	 // 4 strings to match.
        return RISCV::F5_D;	 // "f5"
      case '6':	 // 4 strings to match.
        return RISCV::F6_D;	 // "f6"
      case '7':	 // 4 strings to match.
        return RISCV::F7_D;	 // "f7"
      case '8':	 // 4 strings to match.
        return RISCV::F8_D;	 // "f8"
      case '9':	 // 4 strings to match.
        return RISCV::F9_D;	 // "f9"
      }
      break;
    case 'v':	 // 109 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 15 strings to match.
        return RISCV::V0;	 // "v0"
      case '1':	 // 8 strings to match.
        return RISCV::V1;	 // "v1"
      case '2':	 // 12 strings to match.
        return RISCV::V2;	 // "v2"
      case '3':	 // 8 strings to match.
        return RISCV::V3;	 // "v3"
      case '4':	 // 14 strings to match.
        return RISCV::V4;	 // "v4"
      case '5':	 // 8 strings to match.
        return RISCV::V5;	 // "v5"
      case '6':	 // 12 strings to match.
        return RISCV::V6;	 // "v6"
      case '7':	 // 8 strings to match.
        return RISCV::V7;	 // "v7"
      case '8':	 // 15 strings to match.
        return RISCV::V8;	 // "v8"
      case '9':	 // 8 strings to match.
        return RISCV::V9;	 // "v9"
      case 'l':	 // 1 string to match.
        return RISCV::VL;	 // "vl"
      }
      break;
    case 'x':	 // 35 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 4 strings to match.
        return RISCV::X0;	 // "x0"
      case '1':	 // 3 strings to match.
        return RISCV::X1;	 // "x1"
      case '2':	 // 4 strings to match.
        return RISCV::X2;	 // "x2"
      case '3':	 // 3 strings to match.
        return RISCV::X3;	 // "x3"
      case '4':	 // 4 strings to match.
        return RISCV::X4;	 // "x4"
      case '5':	 // 3 strings to match.
        return RISCV::X5;	 // "x5"
      case '6':	 // 4 strings to match.
        return RISCV::X6;	 // "x6"
      case '7':	 // 3 strings to match.
        return RISCV::X7;	 // "x7"
      case '8':	 // 4 strings to match.
        return RISCV::X8;	 // "x8"
      case '9':	 // 3 strings to match.
        return RISCV::X9;	 // "x9"
      }
      break;
    }
    break;
  case 3:	 // 374 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 89 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 40 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::F10_D;	 // "f10"
        case '1':	 // 4 strings to match.
          return RISCV::F11_D;	 // "f11"
        case '2':	 // 4 strings to match.
          return RISCV::F12_D;	 // "f12"
        case '3':	 // 4 strings to match.
          return RISCV::F13_D;	 // "f13"
        case '4':	 // 4 strings to match.
          return RISCV::F14_D;	 // "f14"
        case '5':	 // 4 strings to match.
          return RISCV::F15_D;	 // "f15"
        case '6':	 // 4 strings to match.
          return RISCV::F16_D;	 // "f16"
        case '7':	 // 4 strings to match.
          return RISCV::F17_D;	 // "f17"
        case '8':	 // 4 strings to match.
          return RISCV::F18_D;	 // "f18"
        case '9':	 // 4 strings to match.
          return RISCV::F19_D;	 // "f19"
        }
        break;
      case '2':	 // 40 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::F20_D;	 // "f20"
        case '1':	 // 4 strings to match.
          return RISCV::F21_D;	 // "f21"
        case '2':	 // 4 strings to match.
          return RISCV::F22_D;	 // "f22"
        case '3':	 // 4 strings to match.
          return RISCV::F23_D;	 // "f23"
        case '4':	 // 4 strings to match.
          return RISCV::F24_D;	 // "f24"
        case '5':	 // 4 strings to match.
          return RISCV::F25_D;	 // "f25"
        case '6':	 // 4 strings to match.
          return RISCV::F26_D;	 // "f26"
        case '7':	 // 4 strings to match.
          return RISCV::F27_D;	 // "f27"
        case '8':	 // 4 strings to match.
          return RISCV::F28_D;	 // "f28"
        case '9':	 // 4 strings to match.
          return RISCV::F29_D;	 // "f29"
        }
        break;
      case '3':	 // 8 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::F30_D;	 // "f30"
        case '1':	 // 4 strings to match.
          return RISCV::F31_D;	 // "f31"
        }
        break;
      case 'r':	 // 1 string to match.
        if (Name[2] != 'm')
          break;
        return RISCV::FRM;	 // "frm"
      }
      break;
    case 'm':	 // 10 strings to match.
      if (Name[1] != 't')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return RISCV::T0;	 // "mt0"
      case '1':	 // 1 string to match.
        return RISCV::T1;	 // "mt1"
      case '2':	 // 1 string to match.
        return RISCV::T2;	 // "mt2"
      case '3':	 // 1 string to match.
        return RISCV::T3;	 // "mt3"
      case '4':	 // 1 string to match.
        return RISCV::T4;	 // "mt4"
      case '5':	 // 1 string to match.
        return RISCV::T5;	 // "mt5"
      case '6':	 // 1 string to match.
        return RISCV::T6;	 // "mt6"
      case '7':	 // 1 string to match.
        return RISCV::T7;	 // "mt7"
      case '8':	 // 1 string to match.
        return RISCV::T8;	 // "mt8"
      case '9':	 // 1 string to match.
        return RISCV::T9;	 // "mt9"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "sp", 2) != 0)
        break;
      return RISCV::SSP;	 // "ssp"
    case 'v':	 // 197 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 105 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 12 strings to match.
          return RISCV::V10;	 // "v10"
        case '1':	 // 8 strings to match.
          return RISCV::V11;	 // "v11"
        case '2':	 // 14 strings to match.
          return RISCV::V12;	 // "v12"
        case '3':	 // 8 strings to match.
          return RISCV::V13;	 // "v13"
        case '4':	 // 12 strings to match.
          return RISCV::V14;	 // "v14"
        case '5':	 // 8 strings to match.
          return RISCV::V15;	 // "v15"
        case '6':	 // 15 strings to match.
          return RISCV::V16;	 // "v16"
        case '7':	 // 8 strings to match.
          return RISCV::V17;	 // "v17"
        case '8':	 // 12 strings to match.
          return RISCV::V18;	 // "v18"
        case '9':	 // 8 strings to match.
          return RISCV::V19;	 // "v19"
        }
        break;
      case '2':	 // 88 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 14 strings to match.
          return RISCV::V20;	 // "v20"
        case '1':	 // 8 strings to match.
          return RISCV::V21;	 // "v21"
        case '2':	 // 12 strings to match.
          return RISCV::V22;	 // "v22"
        case '3':	 // 8 strings to match.
          return RISCV::V23;	 // "v23"
        case '4':	 // 15 strings to match.
          return RISCV::V24;	 // "v24"
        case '5':	 // 7 strings to match.
          return RISCV::V25;	 // "v25"
        case '6':	 // 9 strings to match.
          return RISCV::V26;	 // "v26"
        case '7':	 // 5 strings to match.
          return RISCV::V27;	 // "v27"
        case '8':	 // 7 strings to match.
          return RISCV::V28;	 // "v28"
        case '9':	 // 3 strings to match.
          return RISCV::V29;	 // "v29"
        }
        break;
      case '3':	 // 4 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return RISCV::V30;	 // "v30"
        case '1':	 // 1 string to match.
          return RISCV::V31;	 // "v31"
        }
        break;
      }
      break;
    case 'x':	 // 77 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 35 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::X10;	 // "x10"
        case '1':	 // 3 strings to match.
          return RISCV::X11;	 // "x11"
        case '2':	 // 4 strings to match.
          return RISCV::X12;	 // "x12"
        case '3':	 // 3 strings to match.
          return RISCV::X13;	 // "x13"
        case '4':	 // 4 strings to match.
          return RISCV::X14;	 // "x14"
        case '5':	 // 3 strings to match.
          return RISCV::X15;	 // "x15"
        case '6':	 // 4 strings to match.
          return RISCV::X16;	 // "x16"
        case '7':	 // 3 strings to match.
          return RISCV::X17;	 // "x17"
        case '8':	 // 4 strings to match.
          return RISCV::X18;	 // "x18"
        case '9':	 // 3 strings to match.
          return RISCV::X19;	 // "x19"
        }
        break;
      case '2':	 // 35 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::X20;	 // "x20"
        case '1':	 // 3 strings to match.
          return RISCV::X21;	 // "x21"
        case '2':	 // 4 strings to match.
          return RISCV::X22;	 // "x22"
        case '3':	 // 3 strings to match.
          return RISCV::X23;	 // "x23"
        case '4':	 // 4 strings to match.
          return RISCV::X24;	 // "x24"
        case '5':	 // 3 strings to match.
          return RISCV::X25;	 // "x25"
        case '6':	 // 4 strings to match.
          return RISCV::X26;	 // "x26"
        case '7':	 // 3 strings to match.
          return RISCV::X27;	 // "x27"
        case '8':	 // 4 strings to match.
          return RISCV::X28;	 // "x28"
        case '9':	 // 3 strings to match.
          return RISCV::X29;	 // "x29"
        }
        break;
      case '3':	 // 7 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::X30;	 // "x30"
        case '1':	 // 3 strings to match.
          return RISCV::X31;	 // "x31"
        }
        break;
      }
      break;
    }
    break;
  case 4:	 // 8 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "csr", 3) != 0)
        break;
      return RISCV::FCSR;	 // "fcsr"
    case 'm':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "t1", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return RISCV::T10;	 // "mt10"
      case '1':	 // 1 string to match.
        return RISCV::T11;	 // "mt11"
      case '2':	 // 1 string to match.
        return RISCV::T12;	 // "mt12"
      case '3':	 // 1 string to match.
        return RISCV::T13;	 // "mt13"
      case '4':	 // 1 string to match.
        return RISCV::T14;	 // "mt14"
      case '5':	 // 1 string to match.
        return RISCV::T15;	 // "mt15"
      }
      break;
    case 'v':	 // 1 string to match.
      if (memcmp(Name.data()+1, "xrm", 3) != 0)
        break;
      return RISCV::VXRM;	 // "vxrm"
    }
    break;
  case 5:	 // 3 strings to match.
    if (Name[0] != 'v')
      break;
    switch (Name[1]) {
    default: break;
    case 'l':	 // 1 string to match.
      if (memcmp(Name.data()+2, "enb", 3) != 0)
        break;
      return RISCV::VLENB;	 // "vlenb"
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+2, "ype", 3) != 0)
        break;
      return RISCV::VTYPE;	 // "vtype"
    case 'x':	 // 1 string to match.
      if (memcmp(Name.data()+2, "sat", 3) != 0)
        break;
      return RISCV::VXSAT;	 // "vxsat"
    }
    break;
  case 6:	 // 1 string to match.
    if (memcmp(Name.data()+0, "fflags", 6) != 0)
      break;
    return RISCV::FFLAGS;	 // "fflags"
  case 13:	 // 1 string to match.
    if (memcmp(Name.data()+0, "sf.vcix_state", 13) != 0)
      break;
    return RISCV::SF_VCIX_STATE;	 // "sf.vcix_state"
  }
  return RISCV::NoRegister;
}

static MCRegister MatchRegisterAltName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 105 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 28 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 4 strings to match.
        return RISCV::X10;	 // "a0"
      case '1':	 // 3 strings to match.
        return RISCV::X11;	 // "a1"
      case '2':	 // 4 strings to match.
        return RISCV::X12;	 // "a2"
      case '3':	 // 3 strings to match.
        return RISCV::X13;	 // "a3"
      case '4':	 // 4 strings to match.
        return RISCV::X14;	 // "a4"
      case '5':	 // 3 strings to match.
        return RISCV::X15;	 // "a5"
      case '6':	 // 4 strings to match.
        return RISCV::X16;	 // "a6"
      case '7':	 // 3 strings to match.
        return RISCV::X17;	 // "a7"
      }
      break;
    case 'f':	 // 4 strings to match.
      if (Name[1] != 'p')
        break;
      return RISCV::X8;	 // "fp"
    case 'g':	 // 3 strings to match.
      if (Name[1] != 'p')
        break;
      return RISCV::X3;	 // "gp"
    case 'r':	 // 3 strings to match.
      if (Name[1] != 'a')
        break;
      return RISCV::X1;	 // "ra"
    case 's':	 // 39 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 4 strings to match.
        return RISCV::X8;	 // "s0"
      case '1':	 // 3 strings to match.
        return RISCV::X9;	 // "s1"
      case '2':	 // 4 strings to match.
        return RISCV::X18;	 // "s2"
      case '3':	 // 3 strings to match.
        return RISCV::X19;	 // "s3"
      case '4':	 // 4 strings to match.
        return RISCV::X20;	 // "s4"
      case '5':	 // 3 strings to match.
        return RISCV::X21;	 // "s5"
      case '6':	 // 4 strings to match.
        return RISCV::X22;	 // "s6"
      case '7':	 // 3 strings to match.
        return RISCV::X23;	 // "s7"
      case '8':	 // 4 strings to match.
        return RISCV::X24;	 // "s8"
      case '9':	 // 3 strings to match.
        return RISCV::X25;	 // "s9"
      case 'p':	 // 4 strings to match.
        return RISCV::X2;	 // "sp"
      }
      break;
    case 't':	 // 28 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 3 strings to match.
        return RISCV::X5;	 // "t0"
      case '1':	 // 4 strings to match.
        return RISCV::X6;	 // "t1"
      case '2':	 // 3 strings to match.
        return RISCV::X7;	 // "t2"
      case '3':	 // 4 strings to match.
        return RISCV::X28;	 // "t3"
      case '4':	 // 3 strings to match.
        return RISCV::X29;	 // "t4"
      case '5':	 // 4 strings to match.
        return RISCV::X30;	 // "t5"
      case '6':	 // 3 strings to match.
        return RISCV::X31;	 // "t6"
      case 'p':	 // 4 strings to match.
        return RISCV::X4;	 // "tp"
      }
      break;
    }
    break;
  case 3:	 // 119 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 112 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 32 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::F10_D;	 // "fa0"
        case '1':	 // 4 strings to match.
          return RISCV::F11_D;	 // "fa1"
        case '2':	 // 4 strings to match.
          return RISCV::F12_D;	 // "fa2"
        case '3':	 // 4 strings to match.
          return RISCV::F13_D;	 // "fa3"
        case '4':	 // 4 strings to match.
          return RISCV::F14_D;	 // "fa4"
        case '5':	 // 4 strings to match.
          return RISCV::F15_D;	 // "fa5"
        case '6':	 // 4 strings to match.
          return RISCV::F16_D;	 // "fa6"
        case '7':	 // 4 strings to match.
          return RISCV::F17_D;	 // "fa7"
        }
        break;
      case 's':	 // 40 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::F8_D;	 // "fs0"
        case '1':	 // 4 strings to match.
          return RISCV::F9_D;	 // "fs1"
        case '2':	 // 4 strings to match.
          return RISCV::F18_D;	 // "fs2"
        case '3':	 // 4 strings to match.
          return RISCV::F19_D;	 // "fs3"
        case '4':	 // 4 strings to match.
          return RISCV::F20_D;	 // "fs4"
        case '5':	 // 4 strings to match.
          return RISCV::F21_D;	 // "fs5"
        case '6':	 // 4 strings to match.
          return RISCV::F22_D;	 // "fs6"
        case '7':	 // 4 strings to match.
          return RISCV::F23_D;	 // "fs7"
        case '8':	 // 4 strings to match.
          return RISCV::F24_D;	 // "fs8"
        case '9':	 // 4 strings to match.
          return RISCV::F25_D;	 // "fs9"
        }
        break;
      case 't':	 // 40 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::F0_D;	 // "ft0"
        case '1':	 // 4 strings to match.
          return RISCV::F1_D;	 // "ft1"
        case '2':	 // 4 strings to match.
          return RISCV::F2_D;	 // "ft2"
        case '3':	 // 4 strings to match.
          return RISCV::F3_D;	 // "ft3"
        case '4':	 // 4 strings to match.
          return RISCV::F4_D;	 // "ft4"
        case '5':	 // 4 strings to match.
          return RISCV::F5_D;	 // "ft5"
        case '6':	 // 4 strings to match.
          return RISCV::F6_D;	 // "ft6"
        case '7':	 // 4 strings to match.
          return RISCV::F7_D;	 // "ft7"
        case '8':	 // 4 strings to match.
          return RISCV::F28_D;	 // "ft8"
        case '9':	 // 4 strings to match.
          return RISCV::F29_D;	 // "ft9"
        }
        break;
      }
      break;
    case 's':	 // 7 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 4 strings to match.
        return RISCV::X26;	 // "s10"
      case '1':	 // 3 strings to match.
        return RISCV::X27;	 // "s11"
      }
      break;
    }
    break;
  case 4:	 // 20 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 16 strings to match.
      switch (Name[1]) {
      default: break;
      case 's':	 // 8 strings to match.
        if (Name[2] != '1')
          break;
        switch (Name[3]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::F26_D;	 // "fs10"
        case '1':	 // 4 strings to match.
          return RISCV::F27_D;	 // "fs11"
        }
        break;
      case 't':	 // 8 strings to match.
        if (Name[2] != '1')
          break;
        switch (Name[3]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::F30_D;	 // "ft10"
        case '1':	 // 4 strings to match.
          return RISCV::F31_D;	 // "ft11"
        }
        break;
      }
      break;
    case 'z':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "ero", 3) != 0)
        break;
      return RISCV::X0;	 // "zero"
    }
    break;
  }
  return RISCV::NoRegister;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_HasStdExtZicbomBit: return "'Zicbom' (Cache-Block Management Instructions)";
  case Feature_HasStdExtZicbopBit: return "'Zicbop' (Cache-Block Prefetch Instructions)";
  case Feature_HasStdExtZicbozBit: return "'Zicboz' (Cache-Block Zero Instructions)";
  case Feature_HasStdExtZicsrBit: return "'Zicsr' (CSRs)";
  case Feature_HasStdExtZicondBit: return "(Integer Conditional Operations)";
  case Feature_HasStdExtZifenceiBit: return "'Zifencei' (fence.i)";
  case Feature_HasStdExtZihintpauseBit: return "'Zihintpause' (Pause Hint)";
  case Feature_HasStdExtZihintntlBit: return "'Zihintntl' (Non-Temporal Locality Hints)";
  case Feature_HasStdExtZimopBit: return "'Zimop' (May-Be-Operations)";
  case Feature_HasStdExtZicfilpBit: return "'Zicfilp' (Landing pad)";
  case Feature_NoStdExtZicfilpBit: return "";
  case Feature_HasStdExtZicfissBit: return "'Zicfiss' (Shadow stack)";
  case Feature_HasStdExtZilsdBit: return "'Zilsd' (Load/Store pair instructions)";
  case Feature_HasStdExtZmmulBit: return "'Zmmul' (Integer Multiplication)";
  case Feature_HasStdExtMBit: return "'M' (Integer Multiplication and Division)";
  case Feature_HasStdExtZaamoBit: return "'Zaamo' (Atomic Memory Operations)";
  case Feature_HasStdExtZalrscBit: return "'Zalrsc' (Load-Reserved/Store-Conditional)";
  case Feature_HasStdExtABit: return "'A' (Atomic Instructions)";
  case Feature_HasStdExtZtsoBit: return "'Ztso' (Memory Model - Total Store Order)";
  case Feature_HasStdExtZabhaBit: return "'Zabha' (Byte and Halfword Atomic Memory Operations)";
  case Feature_HasStdExtZacasBit: return "'Zacas' (Atomic Compare-And-Swap Instructions)";
  case Feature_HasStdExtZalasrBit: return "'Zalasr' (Load-Acquire and Store-Release Instructions)";
  case Feature_HasStdExtZawrsBit: return "'Zawrs' (Wait on Reservation Set)";
  case Feature_HasStdExtFBit: return "'F' (Single-Precision Floating-Point)";
  case Feature_HasStdExtDBit: return "'D' (Double-Precision Floating-Point)";
  case Feature_HasStdExtQBit: return "'Q' (Quad-Precision Floating-Point)";
  case Feature_HasStdExtZfhminBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zfhmin' (Half-Precision Floating-Point Minimal)";
  case Feature_HasStdExtZfhBit: return "'Zfh' (Half-Precision Floating-Point)";
  case Feature_HasStdExtZfbfminBit: return "'Zfbfmin' (Scalar BF16 Converts)";
  case Feature_HasHalfFPLoadStoreMoveBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zfhmin' (Half-Precision Floating-Point Minimal) or 'Zfbfmin' (Scalar BF16 Converts)";
  case Feature_HasStdExtZfaBit: return "'Zfa' (Additional Floating-Point)";
  case Feature_HasStdExtZfinxBit: return "'Zfinx' (Float in Integer)";
  case Feature_HasStdExtFOrZfinxBit: return "'F' (Single-Precision Floating-Point) or 'Zfinx' (Float in Integer)";
  case Feature_HasStdExtZdinxBit: return "'Zdinx' (Double in Integer)";
  case Feature_HasStdExtZhinxminBit: return "'Zhinx' (Half Float in Integer) or 'Zhinxmin' (Half Float in Integer Minimal)";
  case Feature_HasStdExtZhinxBit: return "'Zhinx' (Half Float in Integer)";
  case Feature_HasStdExtZcaBit: return "'C' (Compressed Instructions) or 'Zca' (part of the C extension, excluding compressed floating point loads/stores)";
  case Feature_HasStdExtCBit: return "'C' (Compressed Instructions)";
  case Feature_HasStdExtZcbBit: return "'Zcb' (Compressed basic bit manipulation instructions)";
  case Feature_HasStdExtCOrZcdBit: return "'C' (Compressed Instructions) or 'Zcd' (Compressed Double-Precision Floating-Point Instructions)";
  case Feature_HasStdExtZclsdBit: return "'Zclsd' (Compressed Load/Store pair instructions)";
  case Feature_HasStdExtZcmpBit: return "'Zcmp' (sequenced instructions for code-size reduction)";
  case Feature_HasStdExtZcmtBit: return "'Zcmt' (table jump instructions for code-size reduction)";
  case Feature_HasStdExtCOrZcfOrZceBit: return "'C' (Compressed Instructions) or 'Zcf' (Compressed Single-Precision Floating-Point Instructions)";
  case Feature_HasStdExtZcmopBit: return "'Zcmop' (Compressed May-Be-Operations)";
  case Feature_HasStdExtZbaBit: return "'Zba' (Address Generation Instructions)";
  case Feature_HasStdExtZbbBit: return "'Zbb' (Basic Bit-Manipulation)";
  case Feature_NoStdExtZbbBit: return "";
  case Feature_HasStdExtZbcBit: return "'Zbc' (Carry-Less Multiplication)";
  case Feature_HasStdExtZbsBit: return "'Zbs' (Single-Bit Instructions)";
  case Feature_HasStdExtZbkbBit: return "'Zbkb' (Bitmanip instructions for Cryptography)";
  case Feature_NoStdExtZbkbBit: return "";
  case Feature_HasStdExtZbkxBit: return "'Zbkx' (Crossbar permutation instructions)";
  case Feature_HasStdExtZbbOrZbkbBit: return "'Zbb' (Basic Bit-Manipulation) or 'Zbkb' (Bitmanip instructions for Cryptography)";
  case Feature_HasStdExtZbkcBit: return "'Zbkc' (Carry-less multiply instructions for Cryptography)";
  case Feature_HasStdExtZbcOrZbkcBit: return "'Zbc' (Carry-Less Multiplication) or 'Zbkc' (Carry-less multiply instructions for Cryptography)";
  case Feature_HasStdExtZkndBit: return "'Zknd' (NIST Suite: AES Decryption)";
  case Feature_HasStdExtZkneBit: return "'Zkne' (NIST Suite: AES Encryption)";
  case Feature_HasStdExtZkndOrZkneBit: return "'Zknd' (NIST Suite: AES Decryption) or 'Zkne' (NIST Suite: AES Encryption)";
  case Feature_HasStdExtZknhBit: return "'Zknh' (NIST Suite: Hash Function Instructions)";
  case Feature_HasStdExtZksedBit: return "'Zksed' (ShangMi Suite: SM4 Block Cipher Instructions)";
  case Feature_HasStdExtZkshBit: return "'Zksh' (ShangMi Suite: SM3 Hash Function Instructions)";
  case Feature_HasStdExtZkrBit: return "'Zkr' (Entropy Source Extension)";
  case Feature_HasStdExtZvfbfminBit: return "'Zvfbfmin' (Vector BF16 Converts)";
  case Feature_HasStdExtZvfbfwmaBit: return "'Zvfbfwma' (Vector BF16 widening mul-add)";
  case Feature_HasStdExtZfhOrZvfhBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zvfh' (Vector Half-Precision Floating-Point)";
  case Feature_HasStdExtZvkbBit: return "'Zvkb' (Vector Bit-manipulation used in Cryptography)";
  case Feature_HasStdExtZvbbBit: return "'Zvbb' (Vector basic bit-manipulation instructions)";
  case Feature_HasStdExtZvbcBit: return "'Zvbc' (Vector Carryless Multiplication)";
  case Feature_HasStdExtZvbcOrZvbc32eBit: return "'Zvbc' or 'Zvbc32e' (Vector Carryless Multiplication)";
  case Feature_HasStdExtZvkgBit: return "'Zvkg' (Vector GCM instructions for Cryptography)";
  case Feature_HasStdExtZvkgsBit: return "'Zvkgs' (Vector-Scalar GCM instructions for Cryptography)";
  case Feature_HasStdExtZvknedBit: return "'Zvkned' (Vector AES Encryption & Decryption (Single Round))";
  case Feature_HasStdExtZvknhaBit: return "'Zvknha' (Vector SHA-2 (SHA-256 only))";
  case Feature_HasStdExtZvknhbBit: return "'Zvknhb' (Vector SHA-2 (SHA-256 and SHA-512))";
  case Feature_HasStdExtZvknhaOrZvknhbBit: return "'Zvknha' or 'Zvknhb' (Vector SHA-2)";
  case Feature_HasStdExtZvksedBit: return "'Zvksed' (SM4 Block Cipher Instructions)";
  case Feature_HasStdExtZvkshBit: return "'Zvksh' (SM3 Hash Function Instructions)";
  case Feature_HasStdExtZvqdotqBit: return "'Zvqdotq' (Vector quad widening 4D Dot Product)";
  case Feature_HasVInstructionsBit: return "'V' (Vector Extension for Application Processors), 'Zve32x' (Vector Extensions for Embedded Processors)";
  case Feature_HasVInstructionsI64Bit: return "'V' (Vector Extension for Application Processors) or 'Zve64x' (Vector Extensions for Embedded Processors)";
  case Feature_HasVInstructionsAnyFBit: return "'V' (Vector Extension for Application Processors), 'Zve32f' (Vector Extensions for Embedded Processors)";
  case Feature_HasVInstructionsF16MinimalBit: return "'Zvfhmin' (Vector Half-Precision Floating-Point Minimal) or 'Zvfh' (Vector Half-Precision Floating-Point)";
  case Feature_HasStdExtHBit: return "'H' (Hypervisor)";
  case Feature_HasStdExtSmrnmiBit: return "'Smrnmi' (Resumable Non-Maskable Interrupts)";
  case Feature_HasStdExtSvinvalBit: return "'Svinval' (Fine-Grained Address-Translation Cache Invalidation)";
  case Feature_HasStdExtSmctrOrSsctrBit: return "'Smctr' (Control Transfer Records Machine Level) or 'Ssctr' (Control Transfer Records Supervisor Level)";
  case Feature_HasStdExtPBit: return "'Base P' (Packed SIMD)";
  case Feature_HasStdExtZbaOrPBit: return "'Zba' (Address Generation Instructions) or 'Base P' (Packed-SIMD)";
  case Feature_HasStdExtZbbOrPBit: return "'Zbb' (Basic Bit-Manipulation) or 'Base P' (Packed-SIMD)";
  case Feature_HasStdExtZbkbOrPBit: return "'Zbkb' (Bitmanip instructions for Cryptography) or 'Base P' (Packed-SIMD)";
  case Feature_HasStdExtZbbOrZbkbOrPBit: return "'Zbb' (Basic Bit-Manipulation) or 'Zbkb' (Bitmanip instructions for Cryptography) or 'Base P' (Packed-SIMD)";
  case Feature_HasVendorXVentanaCondOpsBit: return "'XVentanaCondOps' (Ventana Conditional Ops)";
  case Feature_HasVendorXTHeadBaBit: return "'XTHeadBa' (T-Head address calculation instructions)";
  case Feature_HasVendorXTHeadBbBit: return "'XTHeadBb' (T-Head basic bit-manipulation instructions)";
  case Feature_HasVendorXTHeadBsBit: return "'XTHeadBs' (T-Head single-bit instructions)";
  case Feature_HasVendorXTHeadCondMovBit: return "'XTHeadCondMov' (T-Head conditional move instructions)";
  case Feature_HasVendorXTHeadCmoBit: return "'XTHeadCmo' (T-Head cache management instructions)";
  case Feature_HasVendorXTHeadFMemIdxBit: return "'XTHeadFMemIdx' (T-Head FP Indexed Memory Operations)";
  case Feature_HasVendorXTHeadMacBit: return "'XTHeadMac' (T-Head Multiply-Accumulate Instructions)";
  case Feature_HasVendorXTHeadMemIdxBit: return "'XTHeadMemIdx' (T-Head Indexed Memory Operations)";
  case Feature_HasVendorXTHeadMemPairBit: return "'XTHeadMemPair' (T-Head two-GPR Memory Operations)";
  case Feature_HasVendorXTHeadSyncBit: return "'XTHeadSync' (T-Head multicore synchronization instructions)";
  case Feature_HasVendorXTHeadVdotBit: return "'XTHeadVdot' (T-Head Vector Extensions for Dot)";
  case Feature_HasVendorXSfvcpBit: return "'XSfvcp' (SiFive Custom Vector Coprocessor Interface Instructions)";
  case Feature_HasVendorXSfmmbaseBit: return "'XSfmmbase' (All non arithmetic instructions for all TEWs and sf.vtzero)";
  case Feature_HasVendorXSfmm32a8fBit: return "'XSfmm32a8f' (TEW=32-bit accumulation, operands - float: fp8)";
  case Feature_HasVendorXSfmm32a8iBit: return "'XSfmm32a8i' (TEW=32-bit accumulation, operands - int: 8b)";
  case Feature_HasVendorXSfmm32a16fOrXSfmm32a32fOrXSfmm64a64fBit: return "'XSfmm32a16f' (TEW=32-bit accumulation, operands - float: 16b, widen=2 (IEEE, BF)), or 'XSfmm32a32f' (TEW=32-bit accumulation, operands - float: 32b), or 'XSfmm64a64f' (TEW=64-bit accumulation, operands - float: fp64)";
  case Feature_HasVendorXSfvqmaccdodBit: return "'XSfvqmaccdod' (SiFive Int8 Matrix Multiplication Instructions (2-by-8 and 8-by-2))";
  case Feature_HasVendorXSfvqmaccqoqBit: return "'XSfvqmaccqoq' (SiFive Int8 Matrix Multiplication Instructions (4-by-8 and 8-by-4))";
  case Feature_HasVendorXSfvfwmaccqqqBit: return "'XSfvfwmaccqqq' (SiFive Matrix Multiply Accumulate Instruction (4-by-4))";
  case Feature_HasVendorXSfvfnrclipxfqfBit: return "'XSfvfnrclipxfqf' (SiFive FP32-to-int8 Ranged Clip Instructions)";
  case Feature_HasVendorXSiFivecdiscarddloneBit: return "'XSiFivecdiscarddlone' (SiFive sf.cdiscard.d.l1 Instruction)";
  case Feature_HasVendorXSiFivecflushdloneBit: return "'XSiFivecflushdlone' (SiFive sf.cflush.d.l1 Instruction)";
  case Feature_HasVendorXSfceaseBit: return "'XSfcease' (SiFive sf.cease Instruction)";
  case Feature_HasVendorXCVelwBit: return "'XCVelw' (CORE-V Event Load Word)";
  case Feature_HasVendorXCVbitmanipBit: return "'XCVbitmanip' (CORE-V Bit Manipulation)";
  case Feature_HasVendorXCVmacBit: return "'XCVmac' (CORE-V Multiply-Accumulate)";
  case Feature_HasVendorXCVmemBit: return "'XCVmem' (CORE-V Post-incrementing Load & Store)";
  case Feature_HasVendorXCValuBit: return "'XCValu' (CORE-V ALU Operations)";
  case Feature_HasVendorXCVsimdBit: return "'XCVsimd' (CORE-V SIMD ALU)";
  case Feature_HasVendorXCVbiBit: return "'XCVbi' (CORE-V Immediate Branching)";
  case Feature_HasVendorXMIPSCMovBit: return "'Xmipscmov' ('mips.ccmov' instruction)";
  case Feature_HasVendorXMIPSLSPBit: return "'Xmipslsp' (load and store pair instructions)";
  case Feature_HasVendorXMIPSCBOPBit: return "'Xmipscbop' (MIPS hardware prefetch)";
  case Feature_HasVendorXwchcBit: return "'Xwchc' (WCH/QingKe additional compressed opcodes)";
  case Feature_HasVendorXqccmpBit: return "'Xqccmp' (Qualcomm 16-bit Push/Pop and Double Moves)";
  case Feature_HasVendorXqciaBit: return "'Xqcia' (Qualcomm uC Arithmetic Extension)";
  case Feature_HasVendorXqciacBit: return "'Xqciac' (Qualcomm uC Load-Store Address Calculation Extension)";
  case Feature_HasVendorXqcibiBit: return "'Xqcibi' (Qualcomm uC Branch Immediate Extension)";
  case Feature_HasVendorXqcibmBit: return "'Xqcibm' (Qualcomm uC Bit Manipulation Extension)";
  case Feature_HasVendorXqcicliBit: return "'Xqcicli' (Qualcomm uC Conditional Load Immediate Extension)";
  case Feature_HasVendorXqcicmBit: return "'Xqcicm' (Qualcomm uC Conditional Move Extension)";
  case Feature_HasVendorXqcicsBit: return "'Xqcics' (Qualcomm uC Conditional Select Extension)";
  case Feature_HasVendorXqcicsrBit: return "'Xqcicsr' (Qualcomm uC CSR Extension)";
  case Feature_HasVendorXqciintBit: return "'Xqciint' (Qualcomm uC Interrupts Extension)";
  case Feature_HasVendorXqciioBit: return "'Xqciio' (Qualcomm uC External Input Output Extension)";
  case Feature_HasVendorXqcilbBit: return "'Xqcilb' (Qualcomm uC Long Branch Extension)";
  case Feature_HasVendorXqciliBit: return "'Xqcili' (Qualcomm uC Load Large Immediate Extension)";
  case Feature_HasVendorXqciliaBit: return "'Xqcilia' (Qualcomm uC Large Immediate Arithmetic Extension)";
  case Feature_HasVendorXqciloBit: return "'Xqcilo' (Qualcomm uC Large Offset Load Store Extension)";
  case Feature_HasVendorXqcilsmBit: return "'Xqcilsm' (Qualcomm uC Load Store Multiple Extension)";
  case Feature_HasVendorXqcisimBit: return "'Xqcisim' (Qualcomm uC Simulation Hint Extension)";
  case Feature_HasVendorXqcislsBit: return "'Xqcisls' (Qualcomm uC Scaled Load Store Extension)";
  case Feature_HasVendorXqcisyncBit: return "'Xqcisync' (Qualcomm uC Sync Delay Extension)";
  case Feature_HasVendorXRivosVisniBit: return "'XRivosVisni' (Rivos Vector Integer Small New)";
  case Feature_HasVendorXRivosVizipBit: return "'XRivosVizip' (Rivos Vector Register Zips)";
  case Feature_HasVendorXAndesPerfBit: return "'XAndesPerf' (Andes Performance Extension)";
  case Feature_HasVendorXAndesBFHCvtBit: return "'XAndesBFHCvt' (Andes Scalar BFLOAT16 Conversion Extension)";
  case Feature_HasVendorXAndesVBFHCvtBit: return "'XAndesVBFHCvt' (Andes Vector BFLOAT16 Conversion Extension)";
  case Feature_HasVendorXAndesVSIntLoadBit: return "'XAndesVSIntLoad' (Andes Vector INT4 Load Extension)";
  case Feature_HasVendorXAndesVPackFPHBit: return "'XAndesVPackFPH' (Andes Vector Packed FP16 Extension)";
  case Feature_HasVendorXAndesVDotBit: return "'XAndesVDot' (Andes Vector Dot Product Extension)";
  case Feature_IsRV64Bit: return "RV64I Base Instruction Set";
  case Feature_IsRV32Bit: return "RV32I Base Instruction Set";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, const FeatureBitset &Features, unsigned VariantID) {
  switch (Mnemonic.size()) {
  default: break;
  case 4:	 // 3 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 2 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'r':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "sr", 2) != 0)
          break;
        if (Features.test(Feature_HasStdExtFOrZfinxBit))	 // "frsr"
          Mnemonic = "frcsr";
        return;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "sr", 2) != 0)
          break;
        if (Features.test(Feature_HasStdExtFOrZfinxBit))	 // "fssr"
          Mnemonic = "fscsr";
        return;
      }
      break;
    case 'm':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "ove", 3) != 0)
        break;
      Mnemonic = "mv";	 // "move"
      return;
    }
    break;
  case 5:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "scall", 5) != 0)
      break;
    Mnemonic = "ecall";	 // "scall"
    return;
  case 6:	 // 3 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 's':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "break", 5) != 0)
        break;
      Mnemonic = "ebreak";	 // "sbreak"
      return;
    case 'v':	 // 2 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "e1.v", 4) != 0)
          break;
        if (Features.test(Feature_HasVInstructionsBit))	 // "vle1.v"
          Mnemonic = "vlm.v";
        return;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "e1.v", 4) != 0)
          break;
        if (Features.test(Feature_HasVInstructionsBit))	 // "vse1.v"
          Mnemonic = "vsm.v";
        return;
      }
      break;
    }
    break;
  case 7:	 // 4 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "v.slet", 6) != 0)
        break;
      if (Features.test(Feature_HasVendorXCValuBit) && Features.test(Feature_IsRV32Bit))	 // "cv.slet"
        Mnemonic = "cv.sle";
      return;
    case 'f':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "mv.", 3) != 0)
        break;
      switch (Mnemonic[4]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, ".x", 2) != 0)
          break;
        if (Features.test(Feature_HasStdExtFBit))	 // "fmv.s.x"
          Mnemonic = "fmv.w.x";
        return;
      case 'x':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, ".s", 2) != 0)
          break;
        if (Features.test(Feature_HasStdExtFBit))	 // "fmv.x.s"
          Mnemonic = "fmv.x.w";
        return;
      }
      break;
    case 'v':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "popc.m", 6) != 0)
        break;
      if (Features.test(Feature_HasVInstructionsBit))	 // "vpopc.m"
        Mnemonic = "vcpop.m";
      return;
    }
    break;
  case 8:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "cv.sletu", 8) != 0)
      break;
    if (Features.test(Feature_HasVendorXCValuBit) && Features.test(Feature_IsRV32Bit))	 // "cv.sletu"
      Mnemonic = "cv.sleu";
    return;
  case 10:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "vmornot.mm", 10) != 0)
      break;
    if (Features.test(Feature_HasVInstructionsBit))	 // "vmornot.mm"
      Mnemonic = "vmorn.mm";
    return;
  case 11:	 // 2 strings to match.
    if (Mnemonic[0] != 'v')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+2, "redsum.vs", 9) != 0)
        break;
      if (Features.test(Feature_HasVInstructionsAnyFBit))	 // "vfredsum.vs"
        Mnemonic = "vfredusum.vs";
      return;
    case 'm':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+2, "andnot.mm", 9) != 0)
        break;
      if (Features.test(Feature_HasVInstructionsBit))	 // "vmandnot.mm"
        Mnemonic = "vmandn.mm";
      return;
    }
    break;
  case 12:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "vfwredsum.vs", 12) != 0)
      break;
    if (Features.test(Feature_HasVInstructionsAnyFBit))	 // "vfwredsum.vs"
      Mnemonic = "vfwredusum.vs";
    return;
  }
}

enum {
  Tie0_1_1,
  Tie0_2_2,
  Tie0_3_3,
  Tie1_3_3,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie0_2_2 */ { 0, 2, 2 },
  /* Tie0_3_3 */ { 0, 3, 3 },
  /* Tie1_3_3 */ { 1, 3, 3 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_95_addImmOperands,
  CVT_95_addRegOperands,
  CVT_imm_95_0,
  CVT_95_Reg,
  CVT_regX0,
  CVT_regX5,
  CVT_regX2,
  CVT_regX3,
  CVT_regX4,
  CVT_95_addRegListOperands,
  CVT_95_addStackAdjOperands,
  CVT_95_addCSRSystemRegisterOperands,
  CVT_95_addRegRegOperands,
  CVT_95_addFRMArgOperands_95_defaultFRMArgOp,
  CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp,
  CVT_95_addFRMArgOperands,
  CVT_imm_95_15,
  CVT_95_addFenceArgOperands,
  CVT_95_addFPImmOperands,
  CVT_imm_95_3,
  CVT_imm_95_1,
  CVT_imm_95_2,
  CVT_regX1,
  CVT_95_addRegOperands_95_defaultMaskRegOp,
  CVT_imm_95__MINUS_1,
  CVT_95_addSImm10UnsignedOperands,
  CVT_imm_95_3072,
  CVT_imm_95_3200,
  CVT_imm_95_3074,
  CVT_imm_95_3202,
  CVT_imm_95_3073,
  CVT_imm_95_3201,
  CVT_95_addVTypeIOperands,
  CVT_reg0,
  CVT_imm_95_255,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__BareSImm13Lsb01_4,
  Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__BareSImm9Lsb01_3,
  Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__BareSImm12Lsb01_2,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_4__imm_95_0,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3,
  Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_4__imm_95_0,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3,
  Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4,
  Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_4__imm_95_0,
  Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3,
  Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__BareSImm21Lsb01_2,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm11_2__BareSImm321_4,
  Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm51_2__AnyRegOperand1_3__SImm161_4__BareSImm13Lsb01_5,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__SImm261_5,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_5__imm_95_0,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_6__SImm261_4,
  Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__UImm51_3__BareSImm32Lsb01_4,
  Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_3__AnyRegOperand1_5__imm_95_0,
  Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_3__AnyRegOperand1_6__SImm261_4,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6,
  Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_4__imm_95_0,
  Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3,
  Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__SImm121_2,
  Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3,
  Convert__Reg1_0__Reg1_1__RnumArg1_2,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1,
  Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1,
  Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1,
  Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1,
  Convert__Reg1_0__UImm20AUIPC1_1,
  Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2,
  Convert__Reg1_0__Reg1_1__BareSImm13Lsb01_2,
  Convert__Reg1_0__regX0__BareSImm13Lsb01_1,
  Convert__Reg1_1__Reg1_0__BareSImm13Lsb01_2,
  Convert__regX0__Reg1_0__BareSImm13Lsb01_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1,
  Convert__Reg1_0__imm_95_0__ImmZero1_1,
  Convert__SImm6NonZero1_1,
  Convert__Reg1_0__Tie0_1_1__ImmZero1_1,
  Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1,
  Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1,
  Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2,
  Convert__Reg1_0__Tie0_1_1__SImm61_1,
  Convert__Reg1_0__BareSImm9Lsb01_1,
  Convert_NoOperands,
  Convert__Reg1_0__Reg1_2__imm_95_0,
  Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1,
  Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1,
  Convert__Reg1_0__Reg1_3__UImm7Lsb001_1,
  Convert__Reg1_0__Reg1_3__UImm8Lsb001_1,
  Convert__BareSImm12Lsb01_0,
  Convert__Reg1_0,
  Convert__Reg1_0__Reg1_3__UImm21_1,
  Convert__GPRPairCRV321_0__Reg1_2__imm_95_0,
  Convert__GPRPairCRV321_0__Reg1_3__UImm8Lsb0001_1,
  Convert__GPRPairNoX0RV321_0__Reg1_2__imm_95_0,
  Convert__GPRPairNoX0RV321_0__Reg1_3__UImm9Lsb0001_1,
  Convert__Reg1_0__Reg1_3__UImm2Lsb01_1,
  Convert__Reg1_0__SImm61_1,
  Convert__Reg1_0__CLUIImm1_1,
  Convert__SImm6NonZero1_0,
  Convert__Reg1_0__Tie0_1_1,
  Convert__regX0__Tie0_1_1__regX5,
  Convert__regX0__Tie0_1_1__regX2,
  Convert__regX0__Tie0_1_1__regX3,
  Convert__regX0__Tie0_1_1__regX4,
  Convert__GPRPairRV321_0__Reg1_2__imm_95_0,
  Convert__GPRPairRV321_0__Reg1_3__UImm9Lsb0001_1,
  Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1,
  Convert__CallSymbol1_0,
  Convert__Reg1_0__CallSymbol1_1,
  Convert__ZeroOffsetMemOpOperand1_0,
  Convert__UImm8GE321_0,
  Convert__UImm51_0,
  Convert__RegList1_0__StackAdj1_1,
  Convert__RegList1_0__NegStackAdj1_1,
  Convert__regX0__CSRSystemRegister1_0__Reg1_1,
  Convert__regX0__CSRSystemRegister1_0__UImm51_1,
  Convert__Reg1_0__CSRSystemRegister1_1__regX0,
  Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2,
  Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2,
  Convert__Reg1_0__Reg1_1__SImm61_2,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__UImm61_2,
  Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3,
  Convert__Reg1_0__SImm51_1__BareSImm13Lsb01_2,
  Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3,
  Convert__Reg1_0__Reg1_1__UImm51_2,
  Convert__Reg1_0__Reg1_3__SImm121_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2,
  Convert__Reg1_0__RegReg2_1,
  Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4,
  Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0,
  Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2,
  Convert__Reg1_0__Reg1_1__UImm31_2,
  Convert__Reg1_0__Reg1_1__UImm41_2,
  Convert__Reg1_0__Reg1_1__Reg1_1,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1,
  Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_1,
  Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3,
  Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3,
  Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3,
  Convert__Reg1_0__GPRF64AsFPR1_1,
  Convert__Reg1_0__GPRPairAsFPR1_1,
  Convert__Reg1_0__GPRAsFPR161_1,
  Convert__Reg1_0__GPRAsFPR321_1,
  Convert__Reg1_0__Reg1_1__FRMArg1_2,
  Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2,
  Convert__GPRF64AsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2,
  Convert__GPRPairAsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2,
  Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2,
  Convert__GPRF64AsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2,
  Convert__GPRPairAsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2,
  Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2,
  Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2,
  Convert__GPRAsFPR161_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR161_0__GPRPairAsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2,
  Convert__GPRAsFPR161_0__GPRAsFPR321_1__FRMArg1_2,
  Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2,
  Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2,
  Convert__GPRAsFPR321_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR321_0__GPRPairAsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR321_0__GPRAsFPR161_1__FRMArgLegacy1_2,
  Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2,
  Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2,
  Convert__Reg1_0__Reg1_1__RTZArg1_2,
  Convert__imm_95_15__imm_95_15,
  Convert__FenceArg1_0__FenceArg1_1,
  Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2,
  Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2,
  Convert__Reg1_0__GPRAsFPR161_1__GPRAsFPR161_2,
  Convert__Reg1_0__GPRAsFPR321_1__GPRAsFPR321_2,
  Convert__Reg1_0__Reg1_2__Reg1_1,
  Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1,
  Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1,
  Convert__Reg1_0__GPRAsFPR161_2__GPRAsFPR161_1,
  Convert__Reg1_0__GPRAsFPR321_2__GPRAsFPR321_1,
  Convert__Reg1_2__Reg1_0__BareSymbol1_1,
  Convert__Reg1_0__LoadFPImm1_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4,
  Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4,
  Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2,
  Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2,
  Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2,
  Convert__Reg1_0__imm_95_3__regX0,
  Convert__Reg1_0__imm_95_1__regX0,
  Convert__Reg1_0__imm_95_2__regX0,
  Convert__regX0__imm_95_3__Reg1_0,
  Convert__Reg1_0__imm_95_3__Reg1_1,
  Convert__regX0__imm_95_1__Reg1_0,
  Convert__Reg1_0__imm_95_1__Reg1_1,
  Convert__regX0__imm_95_1__UImm51_0,
  Convert__Reg1_0__imm_95_1__UImm51_1,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR161_0__GPRAsFPR161_1__FRMArg1_2,
  Convert__GPRAsFPR321_0__GPRAsFPR321_1__FRMArg1_2,
  Convert__regX0__imm_95_2__Reg1_0,
  Convert__Reg1_0__imm_95_2__Reg1_1,
  Convert__regX0__imm_95_2__UImm51_0,
  Convert__Reg1_0__imm_95_2__UImm51_1,
  Convert__regX0__regX0,
  Convert__Reg1_0__regX0,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1,
  Convert__regX0__BareSImm21Lsb01_0,
  Convert__regX1__BareSImm21Lsb01_0,
  Convert__Reg1_0__BareSImm21Lsb01_1,
  Convert__regX1__Reg1_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__imm_95_0,
  Convert__regX1__Reg1_0__SImm121_1,
  Convert__regX1__Reg1_1__imm_95_0,
  Convert__regX1__Reg1_2__SImm121_0,
  Convert__Reg1_0__Reg1_3__SImm121_1__TLSDESCCallSymbol1_5,
  Convert__regX0__Reg1_0__imm_95_0,
  Convert__regX0__Reg1_0__SImm121_1,
  Convert__regX0__Reg1_1__imm_95_0,
  Convert__regX0__Reg1_2__SImm121_0,
  Convert__Reg1_1__PseudoJumpSymbol1_0,
  Convert__Reg1_0__BareSymbol1_1,
  Convert__Reg1_0__ImmXLenLI_Restricted1_1,
  Convert__GPRPairRV321_0__BareSymbol1_1,
  Convert__GPRPairRV321_0__Reg1_3__SImm121_1,
  Convert__Reg1_0__regX0__SImm121_1,
  Convert__Reg1_0__ImmXLenLI1_1,
  Convert__regX0__UImm201_0,
  Convert__Reg1_0__UImm20LUI1_1,
  Convert__Reg1_0__Reg1_2__Reg1_1__Reg1_3,
  Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb0001_2,
  Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb001_2,
  Convert__Reg1_3__UImm91_1__UImm51_0,
  Convert__Reg1_0__SImm181_1,
  Convert__Reg1_0__UImmLog2XLen1_1__BareSImm11Lsb01_2,
  Convert__Reg1_0__UImm71_1__BareSImm11Lsb01_2,
  Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3,
  Convert__Reg1_0__SImm20Lsb0001_1,
  Convert__Reg1_0__SImm18Lsb01_1,
  Convert__Reg1_0__SImm19Lsb001_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__regX0__Reg1_1,
  Convert__regX0__regX0__imm_95_0,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1,
  Convert__regX0__regX0__regX5,
  Convert__regX0__regX0__regX2,
  Convert__regX0__regX0__regX3,
  Convert__regX0__regX0__regX4,
  Convert__imm_95_1__imm_95_0,
  Convert__Reg1_0__UImm81_1,
  Convert__Reg1_0__SImm101_1,
  Convert__Reg1_0__SImm10Unsigned1_1,
  Convert__Reg1_2__SImm12Lsb000001_0,
  Convert__Reg1_0__SImm5NonZero1_1__BareSImm13Lsb01_2,
  Convert__Reg1_0__UImm5NonZero1_1__BareSImm13Lsb01_2,
  Convert__UImm5NonZero1_0,
  Convert__Reg1_0__Tie0_1_1__UImm5GE6Plus11_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2,
  Convert__UImm5Slist1_0,
  Convert__UImm101_0,
  Convert__RegListS01_0__NegStackAdj1_1,
  Convert__Reg1_0__UImm51_1__Reg1_2,
  Convert__Reg1_0__Tie0_1_1__BareSImm321_1,
  Convert__Reg1_0__Reg1_1__SImm261_2,
  Convert__Reg1_0__SImm16NonZero1_1__BareSImm13Lsb01_2,
  Convert__Reg1_0__UImm16NonZero1_1__BareSImm13Lsb01_2,
  Convert__BareSImm32Lsb01_0,
  Convert__Reg1_0__Reg1_3__SImm261_1,
  Convert__Reg1_0__BareSImm321_1,
  Convert__Reg1_0__regX0__BareSymbolQC_E_LI1_1,
  Convert__Reg1_0__Reg1_1__UImm5Plus11_2__UImm51_3,
  Convert__Reg1_0__Tie0_1_1__SImm51_1__UImm5Plus11_2__UImm51_3,
  Convert__Reg1_0__Reg1_1__SImm111_2,
  Convert__Reg1_0__Reg1_3__UImm14Lsb001_1,
  Convert__Reg1_0__SImm20LI1_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__SImm51_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3,
  Convert__Reg1_0__Reg1_3__Reg1_1__imm_95_0,
  Convert__Reg1_0__Reg1_4__Reg1_1__UImm7Lsb001_2,
  Convert__Reg1_0__Reg1_3__UImm5NonZero1_1__imm_95_0,
  Convert__Reg1_0__Reg1_4__UImm5NonZero1_1__UImm7Lsb001_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm121_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__Reg1_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__Reg1_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__Reg1_3,
  Convert__UImm81_0,
  Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__Reg1_3,
  Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__SImm51_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm5GT31_3,
  Convert__Reg1_0__Reg1_1__UImm111_2,
  Convert__Reg1_0__Reg1_3__UImm51_1,
  Convert__Reg1_0__Reg1_3__UImm41_1,
  Convert__Reg1_0__Reg1_3__UImm6Lsb01_1,
  Convert__Reg1_0__Reg1_3__UImm5Lsb01_1,
  Convert__Reg1_0__imm_95_3072__regX0,
  Convert__Reg1_0__imm_95_3200__regX0,
  Convert__Reg1_0__imm_95_3074__regX0,
  Convert__Reg1_0__imm_95_3202__regX0,
  Convert__Reg1_0__imm_95_3073__regX0,
  Convert__Reg1_0__imm_95_3201__regX0,
  Convert__regX0__regX1__imm_95_0,
  Convert__ZeroOffsetMemOpOperand1_1__Reg1_0,
  Convert__Reg1_2__GPRPairRV321_0__BareSymbol1_1,
  Convert__Reg1_0__Reg1_1__imm_95_1,
  Convert__regX0,
  Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3,
  Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3,
  Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3,
  Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3,
  Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3,
  Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3,
  Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3,
  Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3,
  Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3,
  Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3,
  Convert__Reg1_0__Reg1_1__XSfmmVType1_2,
  Convert__Reg1_0__Reg1_1__regX0,
  Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5,
  Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__ImmFour1_6,
  Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__ImmThree1_6,
  Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskCarryInRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__Reg1_1__reg0,
  Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__RVVMaskRegOpOperand1_1,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm51_2,
  Convert__Reg1_0__Reg1_0__Reg1_0,
  Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__SImm51_1,
  Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__regX0__reg0,
  Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__UImm51_1__VTypeI101_2,
  Convert__Reg1_0__Reg1_1__VTypeI111_2,
  Convert__Reg1_0__Reg1_1__imm_95_255,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][15] = {
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__BareSImm13Lsb01_4
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__BareSImm9Lsb01_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__BareSImm12Lsb01_2
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_4__imm_95_0
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_4__imm_95_0
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_4__imm_95_0
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__BareSImm21Lsb01_2
  { CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm11_2__BareSImm321_4
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm51_2__AnyRegOperand1_3__SImm161_4__BareSImm13Lsb01_5
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__SImm261_5
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_5__imm_95_0
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 6, CVT_imm_95_0, 0, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_6__SImm261_4
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 7, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__UImm51_3__BareSImm32Lsb01_4
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_3__AnyRegOperand1_5__imm_95_0
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addRegOperands, 6, CVT_imm_95_0, 0, CVT_Done },
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_3__AnyRegOperand1_6__SImm261_4
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addRegOperands, 7, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_95_addRegOperands, 6, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_95_addRegOperands, 6, CVT_95_addRegOperands, 7, CVT_Done },
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_4__imm_95_0
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2
  { CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm121_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RnumArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__UImm20AUIPC1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__BareSImm13Lsb01_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__regX0__BareSImm13Lsb01_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_0__BareSImm13Lsb01_2
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__regX0__Reg1_0__BareSImm13Lsb01_1
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__imm_95_0__ImmZero1_1
  { CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__SImm6NonZero1_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm61_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__BareSImm9Lsb01_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert_NoOperands
  { CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm7Lsb001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm8Lsb001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__BareSImm12Lsb01_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm21_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GPRPairCRV321_0__Reg1_2__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__GPRPairCRV321_0__Reg1_3__UImm8Lsb0001_1
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GPRPairNoX0RV321_0__Reg1_2__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__GPRPairNoX0RV321_0__Reg1_3__UImm9Lsb0001_1
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm2Lsb01_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm61_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__CLUIImm1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__SImm6NonZero1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX5
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX5, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX2
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX2, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX3
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX3, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX4
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX4, 0, CVT_Done },
  // Convert__GPRPairRV321_0__Reg1_2__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__GPRPairRV321_0__Reg1_3__UImm9Lsb0001_1
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__CallSymbol1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__CallSymbol1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__ZeroOffsetMemOpOperand1_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__UImm8GE321_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__UImm51_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__RegList1_0__StackAdj1_1
  { CVT_95_addRegListOperands, 1, CVT_95_addStackAdjOperands, 2, CVT_Done },
  // Convert__RegList1_0__NegStackAdj1_1
  { CVT_95_addRegListOperands, 1, CVT_95_addStackAdjOperands, 2, CVT_Done },
  // Convert__regX0__CSRSystemRegister1_0__Reg1_1
  { CVT_regX0, 0, CVT_95_addCSRSystemRegisterOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__CSRSystemRegister1_0__UImm51_1
  { CVT_regX0, 0, CVT_95_addCSRSystemRegisterOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__regX0
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm61_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm61_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__SImm51_1__BareSImm13Lsb01_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_3__SImm121_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__RegReg2_1
  { CVT_95_Reg, 1, CVT_95_addRegRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie1_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie1_3_3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm31_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm41_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR161_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR321_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRPairAsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR321_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRPairAsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR161_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RTZArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands, 3, CVT_Done },
  // Convert__imm_95_15__imm_95_15
  { CVT_imm_95_15, 0, CVT_imm_95_15, 0, CVT_Done },
  // Convert__FenceArg1_0__FenceArg1_1
  { CVT_95_addFenceArgOperands, 1, CVT_95_addFenceArgOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR161_1__GPRAsFPR161_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR321_1__GPRAsFPR321_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR161_2__GPRAsFPR161_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR321_2__GPRAsFPR321_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__BareSymbol1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__LoadFPImm1_1
  { CVT_95_Reg, 1, CVT_95_addFPImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__imm_95_3__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_1__regX0
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_2__regX0
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_regX0, 0, CVT_Done },
  // Convert__regX0__imm_95_3__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_3, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_3__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_1__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_1, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_1__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_1__UImm51_0
  { CVT_regX0, 0, CVT_imm_95_1, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_1__UImm51_1
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR161_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR321_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__regX0__imm_95_2__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_2, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_2__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_2__UImm51_0
  { CVT_regX0, 0, CVT_imm_95_2, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_2__UImm51_1
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX0__regX0
  { CVT_regX0, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__regX0
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__regX0__BareSImm21Lsb01_0
  { CVT_regX0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regX1__BareSImm21Lsb01_0
  { CVT_regX1, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__BareSImm21Lsb01_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX1__Reg1_0__imm_95_0
  { CVT_regX1, 0, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX1__Reg1_0__SImm121_1
  { CVT_regX1, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX1__Reg1_1__imm_95_0
  { CVT_regX1, 0, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX1__Reg1_2__SImm121_0
  { CVT_regX1, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_3__SImm121_1__TLSDESCCallSymbol1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__regX0__Reg1_0__imm_95_0
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX0__Reg1_0__SImm121_1
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX0__Reg1_1__imm_95_0
  { CVT_regX0, 0, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX0__Reg1_2__SImm121_0
  { CVT_regX0, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__PseudoJumpSymbol1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__BareSymbol1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmXLenLI_Restricted1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GPRPairRV321_0__BareSymbol1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GPRPairRV321_0__Reg1_3__SImm121_1
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__regX0__SImm121_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmXLenLI1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX0__UImm201_0
  { CVT_regX0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__UImm20LUI1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_1__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb0001_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 5, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb001_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 5, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_3__UImm91_1__UImm51_0
  { CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__SImm181_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__UImmLog2XLen1_1__BareSImm11Lsb01_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__UImm71_1__BareSImm11Lsb01_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__SImm20Lsb0001_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm18Lsb01_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm19Lsb001_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__regX0__Reg1_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__regX0__imm_95_0
  { CVT_regX0, 0, CVT_regX0, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_Done },
  // Convert__regX0__regX0__regX5
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX5, 0, CVT_Done },
  // Convert__regX0__regX0__regX2
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX2, 0, CVT_Done },
  // Convert__regX0__regX0__regX3
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX3, 0, CVT_Done },
  // Convert__regX0__regX0__regX4
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX4, 0, CVT_Done },
  // Convert__imm_95_1__imm_95_0
  { CVT_imm_95_1, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__UImm81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm101_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm10Unsigned1_1
  { CVT_95_Reg, 1, CVT_95_addSImm10UnsignedOperands, 2, CVT_Done },
  // Convert__Reg1_2__SImm12Lsb000001_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__SImm5NonZero1_1__BareSImm13Lsb01_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__UImm5NonZero1_1__BareSImm13Lsb01_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__UImm5NonZero1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__UImm5GE6Plus11_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__UImm5Slist1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__UImm101_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__RegListS01_0__NegStackAdj1_1
  { CVT_95_addRegListOperands, 1, CVT_95_addStackAdjOperands, 2, CVT_Done },
  // Convert__Reg1_0__UImm51_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__BareSImm321_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm261_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__SImm16NonZero1_1__BareSImm13Lsb01_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__UImm16NonZero1_1__BareSImm13Lsb01_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__BareSImm32Lsb01_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_3__SImm261_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__BareSImm321_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__regX0__BareSymbolQC_E_LI1_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm5Plus11_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm51_1__UImm5Plus11_2__UImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm111_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm14Lsb001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm20LI1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__SImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_3__Reg1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_4__Reg1_1__UImm7Lsb001_2
  { CVT_95_Reg, 1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm5NonZero1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_4__UImm5NonZero1_1__UImm7Lsb001_2
  { CVT_95_Reg, 1, CVT_95_Reg, 5, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm121_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__Reg1_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__Reg1_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__SImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm5GT31_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm111_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm51_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm41_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm6Lsb01_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm5Lsb01_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__imm_95_3072__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3072, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3200__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3200, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3074__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3074, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3202__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3202, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3073__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3073, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3201__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3201, 0, CVT_regX0, 0, CVT_Done },
  // Convert__regX0__regX1__imm_95_0
  { CVT_regX0, 0, CVT_regX1, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__ZeroOffsetMemOpOperand1_1__Reg1_0
  { CVT_95_addRegOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__GPRPairRV321_0__BareSymbol1_1
  { CVT_95_Reg, 3, CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__regX0
  { CVT_regX0, 0, CVT_Done },
  // Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__XSfmmVType1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addVTypeIOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie1_3_3, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__ImmFour1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__ImmThree1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskCarryInRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__RVVMaskRegOpOperand1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands_95_defaultMaskRegOp, 2, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_0__Reg1_0
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__SImm51_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__UImm51_1__VTypeI101_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addVTypeIOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__VTypeI111_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addVTypeIOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_255
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_255, 0, CVT_Done },
};

void RISCVAsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands,
                const SmallBitVector &OptionalOperandsMask,
                ArrayRef<unsigned> DefaultsOffset) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p += 2) {
    unsigned OpIdx = *(p + 1) - DefaultsOffset[*(p + 1)];
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(*(p + 1) < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[*(p + 1)][0];
      if (TiedResOpnd != (uint8_t)-1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_95_addImmOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addRegOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_95_Reg:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_regX0:
      Inst.addOperand(MCOperand::createReg(RISCV::X0));
      break;
    case CVT_regX5:
      Inst.addOperand(MCOperand::createReg(RISCV::X5));
      break;
    case CVT_regX2:
      Inst.addOperand(MCOperand::createReg(RISCV::X2));
      break;
    case CVT_regX3:
      Inst.addOperand(MCOperand::createReg(RISCV::X3));
      break;
    case CVT_regX4:
      Inst.addOperand(MCOperand::createReg(RISCV::X4));
      break;
    case CVT_95_addRegListOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegListOperands(Inst, 1);
      break;
    case CVT_95_addStackAdjOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addStackAdjOperands(Inst, 1);
      break;
    case CVT_95_addCSRSystemRegisterOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addCSRSystemRegisterOperands(Inst, 1);
      break;
    case CVT_95_addRegRegOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegRegOperands(Inst, 2);
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultFRMArgOp()->addFRMArgOperands(Inst, 1);
      } else {
        static_cast<RISCVOperand &>(*Operands[OpIdx]).addFRMArgOperands(Inst, 1);
      }
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultFRMArgLegacyOp()->addFRMArgOperands(Inst, 1);
      } else {
        static_cast<RISCVOperand &>(*Operands[OpIdx]).addFRMArgOperands(Inst, 1);
      }
      break;
    case CVT_95_addFRMArgOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFRMArgOperands(Inst, 1);
      break;
    case CVT_imm_95_15:
      Inst.addOperand(MCOperand::createImm(15));
      break;
    case CVT_95_addFenceArgOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFenceArgOperands(Inst, 1);
      break;
    case CVT_95_addFPImmOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFPImmOperands(Inst, 1);
      break;
    case CVT_imm_95_3:
      Inst.addOperand(MCOperand::createImm(3));
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_imm_95_2:
      Inst.addOperand(MCOperand::createImm(2));
      break;
    case CVT_regX1:
      Inst.addOperand(MCOperand::createReg(RISCV::X1));
      break;
    case CVT_95_addRegOperands_95_defaultMaskRegOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultMaskRegOp()->addRegOperands(Inst, 1);
      } else {
        static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      }
      break;
    case CVT_imm_95__MINUS_1:
      Inst.addOperand(MCOperand::createImm(-1));
      break;
    case CVT_95_addSImm10UnsignedOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addSImm10UnsignedOperands(Inst, 1);
      break;
    case CVT_imm_95_3072:
      Inst.addOperand(MCOperand::createImm(3072));
      break;
    case CVT_imm_95_3200:
      Inst.addOperand(MCOperand::createImm(3200));
      break;
    case CVT_imm_95_3074:
      Inst.addOperand(MCOperand::createImm(3074));
      break;
    case CVT_imm_95_3202:
      Inst.addOperand(MCOperand::createImm(3202));
      break;
    case CVT_imm_95_3073:
      Inst.addOperand(MCOperand::createImm(3073));
      break;
    case CVT_imm_95_3201:
      Inst.addOperand(MCOperand::createImm(3201));
      break;
    case CVT_95_addVTypeIOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addVTypeIOperands(Inst, 1);
      break;
    case CVT_reg0:
      Inst.addOperand(MCOperand::createReg(0));
      break;
    case CVT_imm_95_255:
      Inst.addOperand(MCOperand::createImm(255));
      break;
    }
  }
}

void RISCVAsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_regX0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX5:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX4:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addRegListOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addStackAdjOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addCSRSystemRegisterOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRegRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFRMArgOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_15:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addFenceArgOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFPImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_regX1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addRegOperands_95_defaultMaskRegOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95__MINUS_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addSImm10UnsignedOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_3072:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3200:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3074:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3202:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3073:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3201:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addVTypeIOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_reg0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95_255:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK__40_, // '('
  MCK__41_, // ')'
  MCK_LAST_TOKEN = MCK__41_,
  MCK_Reg109, // derived register class
  MCK_Reg106, // derived register class
  MCK_Reg103, // derived register class
  MCK_Reg100, // derived register class
  MCK_Reg97, // derived register class
  MCK_Reg94, // derived register class
  MCK_Reg91, // derived register class
  MCK_Reg88, // derived register class
  MCK_Reg85, // derived register class
  MCK_Reg82, // derived register class
  MCK_Reg79, // derived register class
  MCK_Reg69, // derived register class
  MCK_Reg66, // derived register class
  MCK_Reg63, // derived register class
  MCK_Reg44, // derived register class
  MCK_Reg39, // derived register class
  MCK_Reg36, // derived register class
  MCK_Reg33, // derived register class
  MCK_Reg31, // derived register class
  MCK_GPRX0, // register class 'GPRX0,X0'
  MCK_GPRX1, // register class 'GPRX1'
  MCK_GPRX5, // register class 'GPRX5'
  MCK_GPRX7, // register class 'GPRX7'
  MCK_SP, // register class 'SP'
  MCK_VMV0, // register class 'VMV0'
  MCK_anonymous_9404, // register class 'anonymous_9404'
  MCK_Reg27, // derived register class
  MCK_GPRX1X5, // register class 'GPRX1X5'
  MCK_Reg49, // derived register class
  MCK_VCSR, // register class 'VCSR'
  MCK_VRM8NoV0, // register class 'VRM8NoV0'
  MCK_Reg48, // derived register class
  MCK_GPRPairC, // register class 'GPRPairC'
  MCK_TRM4, // register class 'TRM4'
  MCK_VRM8, // register class 'VRM8'
  MCK_Reg50, // derived register class
  MCK_Reg51, // derived register class
  MCK_Reg42, // derived register class
  MCK_Reg30, // derived register class
  MCK_VRN2M4NoV0, // register class 'VRN2M4NoV0'
  MCK_Reg43, // derived register class
  MCK_VRM4NoV0, // register class 'VRM4NoV0'
  MCK_VRN2M4, // register class 'VRN2M4'
  MCK_Reg59, // derived register class
  MCK_FPR16C, // register class 'FPR16C'
  MCK_FPR32C, // register class 'FPR32C'
  MCK_FPR64C, // register class 'FPR64C'
  MCK_GPRC, // register class 'GPRC'
  MCK_GPRF16C, // register class 'GPRF16C'
  MCK_GPRF32C, // register class 'GPRF32C'
  MCK_SR07, // register class 'SR07'
  MCK_TRM2, // register class 'TRM2'
  MCK_VRM4, // register class 'VRM4'
  MCK_Reg46, // derived register class
  MCK_Reg47, // derived register class
  MCK_Reg40, // derived register class
  MCK_Reg24, // derived register class
  MCK_VRN4M2NoV0, // register class 'VRN4M2NoV0'
  MCK_Reg41, // derived register class
  MCK_Reg37, // derived register class
  MCK_Reg20, // derived register class
  MCK_GPRTCNonX7, // register class 'GPRTCNonX7'
  MCK_VRN3M2NoV0, // register class 'VRN3M2NoV0'
  MCK_VRN4M2, // register class 'VRN4M2'
  MCK_Reg38, // derived register class
  MCK_Reg34, // derived register class
  MCK_GPRTC, // register class 'GPRTC'
  MCK_VRN2M2NoV0, // register class 'VRN2M2NoV0'
  MCK_VRN3M2, // register class 'VRN3M2'
  MCK_GPRPairNoX0, // register class 'GPRPairNoX0'
  MCK_VRM2NoV0, // register class 'VRM2NoV0'
  MCK_VRN2M2, // register class 'VRN2M2'
  MCK_GPRPair, // register class 'GPRPair'
  MCK_TR, // register class 'TR'
  MCK_VRM2, // register class 'VRM2'
  MCK_Reg22, // derived register class
  MCK_VRN8M1NoV0, // register class 'VRN8M1NoV0'
  MCK_Reg18, // derived register class
  MCK_GPRJALRNonX7, // register class 'GPRJALRNonX7'
  MCK_VRN7M1NoV0, // register class 'VRN7M1NoV0'
  MCK_VRN8M1, // register class 'VRN8M1'
  MCK_GPRJALR, // register class 'GPRJALR'
  MCK_VRN6M1NoV0, // register class 'VRN6M1NoV0'
  MCK_VRN7M1, // register class 'VRN7M1'
  MCK_VRN5M1NoV0, // register class 'VRN5M1NoV0'
  MCK_VRN6M1, // register class 'VRN6M1'
  MCK_VRN4M1NoV0, // register class 'VRN4M1NoV0'
  MCK_VRN5M1, // register class 'VRN5M1'
  MCK_Reg13, // derived register class
  MCK_VRN3M1NoV0, // register class 'VRN3M1NoV0'
  MCK_VRN4M1, // register class 'VRN4M1'
  MCK_Reg11, // derived register class
  MCK_GPRNoX0X2, // register class 'GPRNoX0X2'
  MCK_VRN2M1NoV0, // register class 'VRN2M1NoV0'
  MCK_VRN3M1, // register class 'VRN3M1'
  MCK_GPRF16NoX0, // register class 'GPRF16NoX0'
  MCK_GPRF32NoX0, // register class 'GPRF32NoX0'
  MCK_GPRNoX0, // register class 'GPRNoX0'
  MCK_GPRNoX31, // register class 'GPRNoX31'
  MCK_VRN2M1, // register class 'VRN2M1'
  MCK_VRNoV0, // register class 'VRNoV0'
  MCK_FPR128, // register class 'FPR128'
  MCK_FPR16, // register class 'FPR16'
  MCK_FPR32, // register class 'FPR32'
  MCK_FPR64, // register class 'FPR64'
  MCK_GPR, // register class 'GPR'
  MCK_GPRF16, // register class 'GPRF16'
  MCK_GPRF32, // register class 'GPRF32'
  MCK_VM, // register class 'VM,VR'
  MCK_GPRAll, // register class 'GPRAll'
  MCK_LAST_REGISTER = MCK_GPRAll,
  MCK_AnyRegCOperand, // user defined class 'AnyRegCOperand'
  MCK_AnyRegOperand, // user defined class 'AnyRegOperand'
  MCK_BareSymbol, // user defined class 'BareSymbol'
  MCK_BareSymbolQC_E_LI, // user defined class 'BareSymbolQC_E_LI'
  MCK_CLUIImm, // user defined class 'CLUIImmAsmOperand'
  MCK_CSRSystemRegister, // user defined class 'CSRSystemRegister'
  MCK_RegReg, // user defined class 'CVrrAsmOperand'
  MCK_CallSymbol, // user defined class 'CallSymbol'
  MCK_FRMArg, // user defined class 'FRMArg'
  MCK_FRMArgLegacy, // user defined class 'FRMArgLegacy'
  MCK_FenceArg, // user defined class 'FenceArg'
  MCK_GPRAsFPR16, // user defined class 'GPRAsFPR16'
  MCK_GPRAsFPR32, // user defined class 'GPRAsFPR32'
  MCK_GPRF64AsFPR, // user defined class 'GPRF64AsFPR'
  MCK_GPRPairAsFPR, // user defined class 'GPRPairAsFPR'
  MCK_GPRPairCRV32, // user defined class 'GPRPairCRV32Operand'
  MCK_GPRPairNoX0RV32, // user defined class 'GPRPairNoX0RV32Operand'
  MCK_GPRPairRV32, // user defined class 'GPRPairRV32Operand'
  MCK_GPRPairRV64, // user defined class 'GPRPairRV64Operand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_ImmFour, // user defined class 'ImmFourAsmOperand'
  MCK_ImmThree, // user defined class 'ImmThreeAsmOperand'
  MCK_ImmZero, // user defined class 'ImmZeroAsmOperand'
  MCK_InsnCDirectiveOpcode, // user defined class 'InsnCDirectiveOpcode'
  MCK_InsnDirectiveOpcode, // user defined class 'InsnDirectiveOpcode'
  MCK_LoadFPImm, // user defined class 'LoadFPImmOperand'
  MCK_NegStackAdj, // user defined class 'NegStackAdjAsmOperand'
  MCK_PseudoJumpSymbol, // user defined class 'PseudoJumpSymbol'
  MCK_RTZArg, // user defined class 'RTZArg'
  MCK_RegList, // user defined class 'RegListAsmOperand'
  MCK_RegListS0, // user defined class 'RegListS0AsmOperand'
  MCK_RnumArg, // user defined class 'RnumArg'
  MCK_SImm10Unsigned, // user defined class 'SImm10UnsignedAsmOperand'
  MCK_BareSImm21Lsb0, // user defined class 'Simm21Lsb0JALAsmOperand'
  MCK_StackAdj, // user defined class 'StackAdjAsmOperand'
  MCK_TLSDESCCallSymbol, // user defined class 'TLSDESCCallSymbol'
  MCK_TPRelAddSymbol, // user defined class 'TPRelAddSymbol'
  MCK_UImm5Plus1, // user defined class 'UImm5Plus1AsmOperand'
  MCK_UImmLog2XLen, // user defined class 'UImmLog2XLenAsmOperand'
  MCK_UImmLog2XLenNonZero, // user defined class 'UImmLog2XLenNonZeroAsmOperand'
  MCK_RVVMaskRegOpOperand, // user defined class 'VMaskAsmOperand'
  MCK_RVVMaskCarryInRegOpOperand, // user defined class 'VMaskCarryInAsmOperand'
  MCK_XSfmmVType, // user defined class 'XSfmmVTypeAsmOperand'
  MCK_ZeroOffsetMemOpOperand, // user defined class 'ZeroOffsetMemOpOperand'
  MCK_SImm12Lsb00000, // user defined class 'anonymous_10677'
  MCK_VTypeI10, // user defined class 'anonymous_11368'
  MCK_VTypeI11, // user defined class 'anonymous_11369'
  MCK_SImm5, // user defined class 'anonymous_11370'
  MCK_SImm5Plus1, // user defined class 'anonymous_11371'
  MCK_SImm10, // user defined class 'anonymous_51559'
  MCK_SImm6, // user defined class 'anonymous_51560'
  MCK_SImm6NonZero, // user defined class 'anonymous_51561'
  MCK_UImm7Lsb00, // user defined class 'anonymous_51562'
  MCK_UImm8Lsb00, // user defined class 'anonymous_51563'
  MCK_UImm8Lsb000, // user defined class 'anonymous_51564'
  MCK_BareSImm9Lsb0, // user defined class 'anonymous_51565'
  MCK_UImm9Lsb000, // user defined class 'anonymous_51566'
  MCK_UImm10Lsb00NonZero, // user defined class 'anonymous_51567'
  MCK_SImm10Lsb0000NonZero, // user defined class 'anonymous_51568'
  MCK_BareSImm12Lsb0, // user defined class 'anonymous_51569'
  MCK_UImm2Lsb0, // user defined class 'anonymous_51659'
  MCK_UImm8GE32, // user defined class 'anonymous_51660'
  MCK_UImm5Lsb0, // user defined class 'anonymous_53380'
  MCK_UImm6Lsb0, // user defined class 'anonymous_53381'
  MCK_UImm5NonZero, // user defined class 'anonymous_53398'
  MCK_UImm5GT3, // user defined class 'anonymous_53399'
  MCK_UImm5GE6Plus1, // user defined class 'anonymous_53400'
  MCK_UImm5Slist, // user defined class 'anonymous_53401'
  MCK_UImm10, // user defined class 'anonymous_53402'
  MCK_UImm11, // user defined class 'anonymous_53403'
  MCK_UImm14Lsb00, // user defined class 'anonymous_53404'
  MCK_UImm16NonZero, // user defined class 'anonymous_53405'
  MCK_SImm5NonZero, // user defined class 'anonymous_53406'
  MCK_SImm11, // user defined class 'anonymous_53407'
  MCK_SImm16, // user defined class 'anonymous_53408'
  MCK_SImm16NonZero, // user defined class 'anonymous_53409'
  MCK_SImm20LI, // user defined class 'anonymous_53410'
  MCK_SImm26, // user defined class 'anonymous_53411'
  MCK_BareSImm32, // user defined class 'anonymous_53412'
  MCK_BareSImm32Lsb0, // user defined class 'anonymous_53413'
  MCK_UImm7Lsb000, // user defined class 'anonymous_53617'
  MCK_UImm9, // user defined class 'anonymous_53618'
  MCK_BareSImm11Lsb0, // user defined class 'anonymous_53892'
  MCK_SImm18, // user defined class 'anonymous_53893'
  MCK_SImm18Lsb0, // user defined class 'anonymous_53894'
  MCK_SImm19Lsb00, // user defined class 'anonymous_53895'
  MCK_SImm20Lsb000, // user defined class 'anonymous_53896'
  MCK_UImm1, // user defined class 'anonymous_9795'
  MCK_UImm2, // user defined class 'anonymous_9796'
  MCK_UImm3, // user defined class 'anonymous_9797'
  MCK_UImm4, // user defined class 'anonymous_9798'
  MCK_UImm5, // user defined class 'anonymous_9799'
  MCK_UImm6, // user defined class 'anonymous_9800'
  MCK_UImm7, // user defined class 'anonymous_9801'
  MCK_UImm8, // user defined class 'anonymous_9802'
  MCK_UImm16, // user defined class 'anonymous_9803'
  MCK_UImm32, // user defined class 'anonymous_9804'
  MCK_UImm48, // user defined class 'anonymous_9805'
  MCK_UImm64, // user defined class 'anonymous_9806'
  MCK_SImm12, // user defined class 'anonymous_9807'
  MCK_BareSImm13Lsb0, // user defined class 'anonymous_9808'
  MCK_UImm20, // user defined class 'anonymous_9809'
  MCK_UImm20LUI, // user defined class 'anonymous_9810'
  MCK_UImm20AUIPC, // user defined class 'anonymous_9811'
  MCK_ImmXLenLI, // user defined class 'anonymous_9812'
  MCK_ImmXLenLI_Restricted, // user defined class 'anonymous_9813'
  NumMatchClassKinds
};

} // end anonymous namespace

static const char *getMatchKindDiag(RISCVAsmParser::RISCVMatchResultTy MatchResult) {
  switch (MatchResult) {
  case RISCVAsmParser::Match_InvalidRegClassGPRX1:
    return "register must be ra (x1)";
  case RISCVAsmParser::Match_InvalidRegClassGPRX5:
    return "register must be t0 (x5)";
  case RISCVAsmParser::Match_InvalidRegClassSP:
    return "register must be sp (x2)";
  case RISCVAsmParser::Match_InvalidRegClassGPRX1X5:
    return "register must be ra or t0 (x1 or x5)";
  case RISCVAsmParser::Match_InvalidRegClassGPRNoX0X2:
    return "register must be a GPR excluding zero (x0) and sp (x2)";
  case RISCVAsmParser::Match_InvalidRegClassGPRNoX0:
    return "register must be a GPR excluding zero (x0)";
  case RISCVAsmParser::Match_InvalidRegClassGPRX31:
    return "register must be a GPR excluding t6 (x31)";
  case RISCVAsmParser::Match_InvalidBareSymbol:
    return "operand must be a bare symbol name";
  case RISCVAsmParser::Match_InvalidCallSymbol:
    return "operand must be a bare symbol name";
  case RISCVAsmParser::Match_InvalidImmFour:
    return "operand must be constant 4";
  case RISCVAsmParser::Match_InvalidImmThree:
    return "operand must be constant 3";
  case RISCVAsmParser::Match_InvalidImmZero:
    return "immediate must be zero";
  case RISCVAsmParser::Match_InvalidLoadFPImm:
    return "operand must be a valid floating-point constant";
  case RISCVAsmParser::Match_InvalidPseudoJumpSymbol:
    return "operand must be a valid jump target";
  case RISCVAsmParser::Match_InvalidRTZArg:
    return "operand must be 'rtz' floating-point rounding mode";
  case RISCVAsmParser::Match_InvalidRegList:
    return "operand must be {ra [, s0[-sN]]} or {x1 [, x8[-x9][, x18[-xN]]]}";
  case RISCVAsmParser::Match_InvalidRegListS0:
    return "operand must be {ra, s0[-sN]} or {x1, x8[-x9][, x18[-xN]]}";
  case RISCVAsmParser::Match_InvalidTLSDESCCallSymbol:
    return "operand must be a symbol with %tlsdesc_call specifier";
  case RISCVAsmParser::Match_InvalidTPRelAddSymbol:
    return "operand must be a symbol with %tprel_add specifier";
  case RISCVAsmParser::Match_InvalidVMaskRegister:
    return "operand must be v0.t";
  case RISCVAsmParser::Match_InvalidVMaskCarryInRegister:
    return "operand must be v0";
  default:
    return nullptr;
  }
}

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  switch (RegisterClass) {
  case MCK_GPRX1:
    return RISCVAsmParser::Match_InvalidRegClassGPRX1;
  case MCK_GPRX5:
    return RISCVAsmParser::Match_InvalidRegClassGPRX5;
  case MCK_SP:
    return RISCVAsmParser::Match_InvalidRegClassSP;
  case MCK_GPRX1X5:
    return RISCVAsmParser::Match_InvalidRegClassGPRX1X5;
  case MCK_GPRNoX0X2:
    return RISCVAsmParser::Match_InvalidRegClassGPRNoX0X2;
  case MCK_GPRNoX0:
    return RISCVAsmParser::Match_InvalidRegClassGPRNoX0;
  case MCK_GPRNoX31:
    return RISCVAsmParser::Match_InvalidRegClassGPRX31;
  default:
    return MCTargetAsmParser::Match_InvalidOperand;
  }
}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case '(':	 // 1 string to match.
      return MCK__40_;	 // "("
    case ')':	 // 1 string to match.
      return MCK__41_;	 // ")"
    }
    break;
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  [[maybe_unused]] static constexpr struct {
    uint32_t Offset;
    uint16_t Start;
    uint16_t Length;
  } Table[] = {
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 84, 1},
    {1, 87, 1},
    {2, 89, 1},
    {3, 91, 1},
    {4, 67, 1},
    {5, 94, 1},
    {6, 72, 1},
    {7, 98, 1},
    {8, 46, 1},
    {9, 75, 1},
    {10, 103, 1},
    {11, 38, 1},
    {12, 56, 1},
    {13, 78, 1},
    {14, 35, 42},
    {56, 41, 36},
    {92, 63, 14},
    {106, 69, 8},
    {114, 76, 1},
    {115, 102, 12},
    {127, 31, 83},
    {210, 31, 83},
    {293, 64, 50},
    {343, 95, 19},
    {362, 112, 1},
    {363, 0, 0},
    {363, 51, 63},
    {426, 92, 22},
    {448, 36, 41},
    {489, 0, 0},
    {489, 38, 1},
    {490, 57, 20},
    {510, 57, 20},
    {530, 55, 23},
    {553, 0, 0},
    {553, 40, 37},
    {590, 44, 33},
    {623, 44, 33},
    {656, 51, 63},
    {719, 46, 1},
    {720, 62, 15},
    {735, 56, 1},
    {736, 0, 0},
    {736, 105, 1},
    {737, 106, 1},
    {738, 107, 1},
    {739, 108, 1},
    {740, 79, 35},
    {775, 99, 12},
    {787, 100, 12},
    {799, 79, 35},
    {834, 77, 1},
    {835, 0, 0},
    {835, 58, 19},
    {854, 62, 15},
    {869, 62, 15},
    {884, 64, 50},
    {934, 67, 1},
    {935, 68, 9},
    {944, 68, 9},
    {953, 70, 44},
    {997, 70, 44},
    {1041, 72, 1},
    {1042, 0, 0},
    {1042, 73, 4},
    {1046, 73, 4},
    {1050, 85, 29},
    {1079, 75, 1},
    {1080, 0, 0},
    {1080, 76, 1},
    {1081, 78, 1},
    {1082, 0, 0},
    {1082, 0, 0},
    {1082, 0, 0},
    {1082, 0, 0},
    {1082, 81, 33},
    {1115, 84, 1},
    {1116, 85, 29},
    {1145, 85, 29},
    {1174, 87, 1},
    {1175, 0, 0},
    {1175, 96, 18},
    {1193, 89, 1},
    {1194, 0, 0},
    {1194, 91, 1},
    {1195, 0, 0},
    {1195, 94, 1},
    {1196, 0, 0},
    {1196, 95, 19},
    {1215, 98, 1},
    {1216, 0, 0},
    {1216, 101, 13},
    {1229, 101, 13},
    {1242, 103, 1},
    {1243, 0, 0},
    {1243, 110, 1},
    {1244, 111, 1},
    {1245, 109, 5},
    {1250, 109, 5},
    {1255, 0, 0},
    {1255, 112, 1},
    {1256, 0, 0},
    {1256, 0, 0},
    {1256, 0, 0},
    {1256, 0, 0},
    {1256, 113, 1},
    {1257, 0, 0},
    {1257, 0, 0},
    {1257, 0, 0},
    {1257, 0, 0},
    {1257, 0, 0},
    {1257, 0, 0},
    {1257, 0, 0},
    {1257, 0, 0},
    {1257, 0, 0},
    {1257, 0, 0},
    {1257, 0, 0},
    {1257, 0, 0},
    {1257, 1, 1},
    {1258, 1, 1},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 0, 0},
    {1259, 1, 1},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
    {1260, 0, 0},
  };

  static constexpr uint8_t Data[] = {
    0xFF,
    0xFF,
    0x00,
    0x00,
    0x70,
    0x86,
    0x91,
    0x09,
    0x00,
    0x64,
    0x18,
    0x19,
    0x46,
    0x46,
    0x0E,
    0xC4,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x90,
    0x61,
    0x20,
    0x06,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x80,
    0x0C,
    0x03,
    0x31,
    0x08,
    0x40,
    0x04,
    0x32,
    0x0C,
    0xC4,
    0x60,
    0x20,
    0x4E,
    0x00,
    0x00,
    0x80,
    0x26,
    0x90,
    0x61,
    0x20,
    0x66,
    0x18,
    0x88,
    0x39,
    0x01,
    0xE0,
    0x0C,
    0x23,
    0x9F,
    0x61,
    0xE4,
    0x19,
    0x46,
    0x06,
    0x00,
    0x00,
    0x27,
    0x00,
    0x9C,
    0x61,
    0x64,
    0x00,
    0x10,
    0x41,
    0xC8,
    0x00,
    0x40,
    0x86,
    0x91,
    0x01,
    0x62,
    0x08,
    0xD0,
    0x04,
    0x32,
    0x0C,
    0xC4,
    0x41,
    0xC8,
    0xDF,
    0x04,
    0x32,
    0x0C,
    0xC4,
    0x00,
    0x0C,
    0xC0,
    0x26,
    0x90,
    0x61,
    0x20,
    0x9E,
    0x61,
    0x64,
    0x10,
    0x72,
    0x18,
    0x39,
    0x04,
    0x68,
    0x02,
    0x19,
    0x06,
    0xE2,
    0x90,
    0x23,
    0x03,
    0x10,
    0x81,
    0x0C,
    0x03,
    0x31,
    0x00,
    0x12,
    0x80,
    0x10,
    0x10,
    0x67,
    0x06,
    0x20,
    0x04,
    0xC4,
    0x4F,
    0x20,
    0xC3,
    0x40,
    0x1C,
    0xC8,
    0x30,
    0x10,
    0x03,
    0x10,
    0x02,
    0xE2,
    0x10,
    0x10,
    0x3F,
    0x0C,
    0xC4,
    0x03,
    0x31,
    0x20,
    0x3E,
    0xC6,
    0x0F,
  };

  auto &Entry = Table[A];
  unsigned Idx = B - Entry.Start;
  if (Idx >= Entry.Length)
    return false;
  Idx += Entry.Offset;
  return (Data[Idx / 8] >> (Idx % 8)) & 1;
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  RISCVOperand &Operand = (RISCVOperand &)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  case MCK_AnyRegCOperand: {
    DiagnosticPredicate DP(Operand.isAnyRegC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_AnyRegOperand: {
    DiagnosticPredicate DP(Operand.isAnyReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BareSymbol: {
    DiagnosticPredicate DP(Operand.isBareSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSymbol;
    break;
  }
  case MCK_BareSymbolQC_E_LI: {
    DiagnosticPredicate DP(Operand.isBareSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSymbolQC_E_LI;
    break;
  }
  case MCK_CLUIImm: {
    DiagnosticPredicate DP(Operand.isCLUIImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCLUIImm;
    break;
  }
  case MCK_CSRSystemRegister: {
    DiagnosticPredicate DP(Operand.isCSRSystemRegister());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCSRSystemRegister;
    break;
  }
  case MCK_RegReg: {
    DiagnosticPredicate DP(Operand.isRegReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_CallSymbol: {
    DiagnosticPredicate DP(Operand.isCallSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCallSymbol;
    break;
  }
  case MCK_FRMArg: {
    DiagnosticPredicate DP(Operand.isFRMArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_FRMArgLegacy: {
    DiagnosticPredicate DP(Operand.isFRMArgLegacy());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_FenceArg: {
    DiagnosticPredicate DP(Operand.isFenceArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRAsFPR16: {
    DiagnosticPredicate DP(Operand.isGPRAsFPR16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRAsFPR32: {
    DiagnosticPredicate DP(Operand.isGPRAsFPR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRF64AsFPR: {
    DiagnosticPredicate DP(Operand.isGPRAsFPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRPairAsFPR: {
    DiagnosticPredicate DP(Operand.isGPRPairAsFPR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRPairCRV32: {
    DiagnosticPredicate DP(Operand.isGPRPairC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRPairNoX0RV32: {
    DiagnosticPredicate DP(Operand.isGPRPairNoX0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRPairRV32: {
    DiagnosticPredicate DP(Operand.isGPRPair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRPairRV64: {
    DiagnosticPredicate DP(Operand.isGPRPair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ImmFour: {
    DiagnosticPredicate DP(Operand.isImmFour());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmFour;
    break;
  }
  case MCK_ImmThree: {
    DiagnosticPredicate DP(Operand.isImmThree());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmThree;
    break;
  }
  case MCK_ImmZero: {
    DiagnosticPredicate DP(Operand.isImmZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmZero;
    break;
  }
  case MCK_InsnCDirectiveOpcode: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_InsnDirectiveOpcode: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_LoadFPImm: {
    DiagnosticPredicate DP(Operand.isLoadFPImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidLoadFPImm;
    break;
  }
  case MCK_NegStackAdj: {
    DiagnosticPredicate DP(Operand.isStackAdj());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidStackAdj;
    break;
  }
  case MCK_PseudoJumpSymbol: {
    DiagnosticPredicate DP(Operand.isPseudoJumpSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidPseudoJumpSymbol;
    break;
  }
  case MCK_RTZArg: {
    DiagnosticPredicate DP(Operand.isRTZArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRTZArg;
    break;
  }
  case MCK_RegList: {
    DiagnosticPredicate DP(Operand.isRegList());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRegList;
    break;
  }
  case MCK_RegListS0: {
    DiagnosticPredicate DP(Operand.isRegListS0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRegListS0;
    break;
  }
  case MCK_RnumArg: {
    DiagnosticPredicate DP(Operand.isRnumArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRnumArg;
    break;
  }
  case MCK_SImm10Unsigned: {
    DiagnosticPredicate DP(Operand.isSImm10Unsigned());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm10Unsigned;
    break;
  }
  case MCK_BareSImm21Lsb0: {
    DiagnosticPredicate DP(Operand.isBareSimmNLsb0<21>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSImm21Lsb0;
    break;
  }
  case MCK_StackAdj: {
    DiagnosticPredicate DP(Operand.isStackAdj());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidStackAdj;
    break;
  }
  case MCK_TLSDESCCallSymbol: {
    DiagnosticPredicate DP(Operand.isTLSDESCCallSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidTLSDESCCallSymbol;
    break;
  }
  case MCK_TPRelAddSymbol: {
    DiagnosticPredicate DP(Operand.isTPRelAddSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidTPRelAddSymbol;
    break;
  }
  case MCK_UImm5Plus1: {
    DiagnosticPredicate DP(Operand.isUImm5Plus1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5Plus1;
    break;
  }
  case MCK_UImmLog2XLen: {
    DiagnosticPredicate DP(Operand.isUImmLog2XLen());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImmLog2XLen;
    break;
  }
  case MCK_UImmLog2XLenNonZero: {
    DiagnosticPredicate DP(Operand.isUImmLog2XLenNonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImmLog2XLenNonZero;
    break;
  }
  case MCK_RVVMaskRegOpOperand: {
    DiagnosticPredicate DP(Operand.isV0Reg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVMaskRegister;
    break;
  }
  case MCK_RVVMaskCarryInRegOpOperand: {
    DiagnosticPredicate DP(Operand.isV0Reg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVMaskCarryInRegister;
    break;
  }
  case MCK_XSfmmVType: {
    DiagnosticPredicate DP(Operand.isXSfmmVType());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidXSfmmVType;
    break;
  }
  case MCK_ZeroOffsetMemOpOperand: {
    DiagnosticPredicate DP(Operand.isGPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_SImm12Lsb00000: {
    DiagnosticPredicate DP(Operand.isSImm12Lsb00000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm12Lsb00000;
    break;
  }
  case MCK_VTypeI10: {
    DiagnosticPredicate DP(Operand.isVTypeI10());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVTypeI;
    break;
  }
  case MCK_VTypeI11: {
    DiagnosticPredicate DP(Operand.isVTypeI11());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVTypeI;
    break;
  }
  case MCK_SImm5: {
    DiagnosticPredicate DP(Operand.isSImm5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm5;
    break;
  }
  case MCK_SImm5Plus1: {
    DiagnosticPredicate DP(Operand.isSImm5Plus1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm5Plus1;
    break;
  }
  case MCK_SImm10: {
    DiagnosticPredicate DP(Operand.isSImm10());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm10;
    break;
  }
  case MCK_SImm6: {
    DiagnosticPredicate DP(Operand.isSImm6());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm6;
    break;
  }
  case MCK_SImm6NonZero: {
    DiagnosticPredicate DP(Operand.isSImm6NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm6NonZero;
    break;
  }
  case MCK_UImm7Lsb00: {
    DiagnosticPredicate DP(Operand.isUImm7Lsb00());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm7Lsb00;
    break;
  }
  case MCK_UImm8Lsb00: {
    DiagnosticPredicate DP(Operand.isUImm8Lsb00());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8Lsb00;
    break;
  }
  case MCK_UImm8Lsb000: {
    DiagnosticPredicate DP(Operand.isUImm8Lsb000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8Lsb000;
    break;
  }
  case MCK_BareSImm9Lsb0: {
    DiagnosticPredicate DP(Operand.isBareSimmNLsb0<9>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSImm9Lsb0;
    break;
  }
  case MCK_UImm9Lsb000: {
    DiagnosticPredicate DP(Operand.isUImm9Lsb000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm9Lsb000;
    break;
  }
  case MCK_UImm10Lsb00NonZero: {
    DiagnosticPredicate DP(Operand.isUImm10Lsb00NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm10Lsb00NonZero;
    break;
  }
  case MCK_SImm10Lsb0000NonZero: {
    DiagnosticPredicate DP(Operand.isSImm10Lsb0000NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm10Lsb0000NonZero;
    break;
  }
  case MCK_BareSImm12Lsb0: {
    DiagnosticPredicate DP(Operand.isBareSimmNLsb0<12>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSImm12Lsb0;
    break;
  }
  case MCK_UImm2Lsb0: {
    DiagnosticPredicate DP(Operand.isUImm2Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm2Lsb0;
    break;
  }
  case MCK_UImm8GE32: {
    DiagnosticPredicate DP(Operand.isUImm8GE32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8GE32;
    break;
  }
  case MCK_UImm5Lsb0: {
    DiagnosticPredicate DP(Operand.isUImm5Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5Lsb0;
    break;
  }
  case MCK_UImm6Lsb0: {
    DiagnosticPredicate DP(Operand.isUImm6Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm6Lsb0;
    break;
  }
  case MCK_UImm5NonZero: {
    DiagnosticPredicate DP(Operand.isUImm5NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5NonZero;
    break;
  }
  case MCK_UImm5GT3: {
    DiagnosticPredicate DP(Operand.isUImm5GT3());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5GT3;
    break;
  }
  case MCK_UImm5GE6Plus1: {
    DiagnosticPredicate DP(Operand.isUImm5GE6Plus1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5GE6Plus1;
    break;
  }
  case MCK_UImm5Slist: {
    DiagnosticPredicate DP(Operand.isUImm5Slist());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5Slist;
    break;
  }
  case MCK_UImm10: {
    DiagnosticPredicate DP(Operand.isUImm10());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm10;
    break;
  }
  case MCK_UImm11: {
    DiagnosticPredicate DP(Operand.isUImm11());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm11;
    break;
  }
  case MCK_UImm14Lsb00: {
    DiagnosticPredicate DP(Operand.isUImm14Lsb00());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm14Lsb00;
    break;
  }
  case MCK_UImm16NonZero: {
    DiagnosticPredicate DP(Operand.isUImm16NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm16NonZero;
    break;
  }
  case MCK_SImm5NonZero: {
    DiagnosticPredicate DP(Operand.isSImm5NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm5NonZero;
    break;
  }
  case MCK_SImm11: {
    DiagnosticPredicate DP(Operand.isSImm11());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm11;
    break;
  }
  case MCK_SImm16: {
    DiagnosticPredicate DP(Operand.isSImm16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm16;
    break;
  }
  case MCK_SImm16NonZero: {
    DiagnosticPredicate DP(Operand.isSImm16NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm16NonZero;
    break;
  }
  case MCK_SImm20LI: {
    DiagnosticPredicate DP(Operand.isSImm20LI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm20LI;
    break;
  }
  case MCK_SImm26: {
    DiagnosticPredicate DP(Operand.isSImm26());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm26;
    break;
  }
  case MCK_BareSImm32: {
    DiagnosticPredicate DP(Operand.isBareSimmN<32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSImm32;
    break;
  }
  case MCK_BareSImm32Lsb0: {
    DiagnosticPredicate DP(Operand.isBareSimmNLsb0<32>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSImm32Lsb0;
    break;
  }
  case MCK_UImm7Lsb000: {
    DiagnosticPredicate DP(Operand.isUImm7Lsb000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm7Lsb000;
    break;
  }
  case MCK_UImm9: {
    DiagnosticPredicate DP(Operand.isUImm9());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm9;
    break;
  }
  case MCK_BareSImm11Lsb0: {
    DiagnosticPredicate DP(Operand.isBareSimmNLsb0<11>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSImm11Lsb0;
    break;
  }
  case MCK_SImm18: {
    DiagnosticPredicate DP(Operand.isSImm18());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm18;
    break;
  }
  case MCK_SImm18Lsb0: {
    DiagnosticPredicate DP(Operand.isSImm18Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm18Lsb0;
    break;
  }
  case MCK_SImm19Lsb00: {
    DiagnosticPredicate DP(Operand.isSImm19Lsb00());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm19Lsb00;
    break;
  }
  case MCK_SImm20Lsb000: {
    DiagnosticPredicate DP(Operand.isSImm20Lsb000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm20Lsb000;
    break;
  }
  case MCK_UImm1: {
    DiagnosticPredicate DP(Operand.isUImm1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm1;
    break;
  }
  case MCK_UImm2: {
    DiagnosticPredicate DP(Operand.isUImm2());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm2;
    break;
  }
  case MCK_UImm3: {
    DiagnosticPredicate DP(Operand.isUImm3());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm3;
    break;
  }
  case MCK_UImm4: {
    DiagnosticPredicate DP(Operand.isUImm4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm4;
    break;
  }
  case MCK_UImm5: {
    DiagnosticPredicate DP(Operand.isUImm5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5;
    break;
  }
  case MCK_UImm6: {
    DiagnosticPredicate DP(Operand.isUImm6());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm6;
    break;
  }
  case MCK_UImm7: {
    DiagnosticPredicate DP(Operand.isUImm7());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm7;
    break;
  }
  case MCK_UImm8: {
    DiagnosticPredicate DP(Operand.isUImm8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8;
    break;
  }
  case MCK_UImm16: {
    DiagnosticPredicate DP(Operand.isUImm16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm16;
    break;
  }
  case MCK_UImm32: {
    DiagnosticPredicate DP(Operand.isUImm32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm32;
    break;
  }
  case MCK_UImm48: {
    DiagnosticPredicate DP(Operand.isUImm48());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm48;
    break;
  }
  case MCK_UImm64: {
    DiagnosticPredicate DP(Operand.isUImm64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm64;
    break;
  }
  case MCK_SImm12: {
    DiagnosticPredicate DP(Operand.isSImm12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm12;
    break;
  }
  case MCK_BareSImm13Lsb0: {
    DiagnosticPredicate DP(Operand.isBareSimmNLsb0<13>());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSImm13Lsb0;
    break;
  }
  case MCK_UImm20: {
    DiagnosticPredicate DP(Operand.isUImm20());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm20;
    break;
  }
  case MCK_UImm20LUI: {
    DiagnosticPredicate DP(Operand.isUImm20LUI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm20LUI;
    break;
  }
  case MCK_UImm20AUIPC: {
    DiagnosticPredicate DP(Operand.isUImm20AUIPC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm20AUIPC;
    break;
  }
  case MCK_ImmXLenLI: {
    DiagnosticPredicate DP(Operand.isImmXLenLI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmXLenLI;
    break;
  }
  case MCK_ImmXLenLI_Restricted: {
    DiagnosticPredicate DP(Operand.isImmXLenLI_Restricted());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmXLenLI_Restricted;
    break;
  }
  } // end switch (Kind)

  if (Operand.isReg()) {
    static constexpr uint16_t Table[RISCV::NUM_TARGET_REGS] = {
      InvalidMatchClass,
      InvalidMatchClass,
      InvalidMatchClass,
      InvalidMatchClass,
      MCK_anonymous_9404,
      InvalidMatchClass,
      MCK_VCSR,
      MCK_VCSR,
      MCK_VCSR,
      InvalidMatchClass,
      InvalidMatchClass,
      MCK_GPRAll,
      MCK_TRM4,
      MCK_TR,
      MCK_TRM2,
      MCK_TR,
      MCK_TRM4,
      MCK_TR,
      MCK_TRM2,
      MCK_TR,
      MCK_TRM4,
      MCK_TR,
      MCK_TRM2,
      MCK_TR,
      MCK_TRM4,
      MCK_TR,
      MCK_TRM2,
      MCK_TR,
      MCK_VMV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_GPRX0,
      MCK_GPRX1,
      MCK_SP,
      MCK_Reg13,
      MCK_Reg13,
      MCK_GPRX5,
      MCK_Reg24,
      MCK_GPRX7,
      MCK_Reg27,
      MCK_Reg27,
      MCK_Reg30,
      MCK_Reg30,
      MCK_Reg30,
      MCK_Reg30,
      MCK_Reg30,
      MCK_Reg30,
      MCK_Reg24,
      MCK_Reg24,
      MCK_SR07,
      MCK_SR07,
      MCK_SR07,
      MCK_SR07,
      MCK_SR07,
      MCK_SR07,
      MCK_Reg22,
      MCK_Reg22,
      MCK_Reg22,
      MCK_Reg22,
      MCK_Reg24,
      MCK_Reg24,
      MCK_Reg24,
      MCK_GPRTCNonX7,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_Reg59,
      MCK_Reg59,
      MCK_Reg59,
      MCK_Reg59,
      MCK_Reg59,
      MCK_Reg59,
      MCK_Reg59,
      MCK_Reg59,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_FPR128,
      MCK_GPRF16,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_Reg31,
      MCK_GPRF32,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_Reg63,
      MCK_Reg66,
      MCK_Reg69,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM8NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM8NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM8NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM2NoV0,
      MCK_Reg33,
      MCK_Reg36,
      MCK_Reg39,
      MCK_Reg44,
      MCK_Reg49,
      MCK_Reg49,
      MCK_Reg49,
      MCK_Reg50,
      MCK_Reg48,
      MCK_Reg48,
      MCK_Reg48,
      MCK_Reg46,
      MCK_Reg46,
      MCK_Reg50,
      MCK_Reg51,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_Reg79,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_Reg82,
      MCK_VRN2M4NoV0,
      MCK_VRN2M4NoV0,
      MCK_VRN2M4NoV0,
      MCK_VRN2M4NoV0,
      MCK_VRN2M4NoV0,
      MCK_VRN2M4NoV0,
      MCK_Reg85,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_Reg88,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_Reg91,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_Reg94,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_Reg97,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_Reg100,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_Reg103,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_Reg106,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_Reg109,
    };

    MCRegister Reg = Operand.getReg();
    MatchClassKind OpKind = Reg.isPhysical() ? (MatchClassKind)Table[Reg.id()] : InvalidMatchClass;
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK__40_: return "MCK__40_";
  case MCK__41_: return "MCK__41_";
  case MCK_Reg109: return "MCK_Reg109";
  case MCK_Reg106: return "MCK_Reg106";
  case MCK_Reg103: return "MCK_Reg103";
  case MCK_Reg100: return "MCK_Reg100";
  case MCK_Reg97: return "MCK_Reg97";
  case MCK_Reg94: return "MCK_Reg94";
  case MCK_Reg91: return "MCK_Reg91";
  case MCK_Reg88: return "MCK_Reg88";
  case MCK_Reg85: return "MCK_Reg85";
  case MCK_Reg82: return "MCK_Reg82";
  case MCK_Reg79: return "MCK_Reg79";
  case MCK_Reg69: return "MCK_Reg69";
  case MCK_Reg66: return "MCK_Reg66";
  case MCK_Reg63: return "MCK_Reg63";
  case MCK_Reg44: return "MCK_Reg44";
  case MCK_Reg39: return "MCK_Reg39";
  case MCK_Reg36: return "MCK_Reg36";
  case MCK_Reg33: return "MCK_Reg33";
  case MCK_Reg31: return "MCK_Reg31";
  case MCK_GPRX0: return "MCK_GPRX0";
  case MCK_GPRX1: return "MCK_GPRX1";
  case MCK_GPRX5: return "MCK_GPRX5";
  case MCK_GPRX7: return "MCK_GPRX7";
  case MCK_SP: return "MCK_SP";
  case MCK_VMV0: return "MCK_VMV0";
  case MCK_anonymous_9404: return "MCK_anonymous_9404";
  case MCK_Reg27: return "MCK_Reg27";
  case MCK_GPRX1X5: return "MCK_GPRX1X5";
  case MCK_Reg49: return "MCK_Reg49";
  case MCK_VCSR: return "MCK_VCSR";
  case MCK_VRM8NoV0: return "MCK_VRM8NoV0";
  case MCK_Reg48: return "MCK_Reg48";
  case MCK_GPRPairC: return "MCK_GPRPairC";
  case MCK_TRM4: return "MCK_TRM4";
  case MCK_VRM8: return "MCK_VRM8";
  case MCK_Reg50: return "MCK_Reg50";
  case MCK_Reg51: return "MCK_Reg51";
  case MCK_Reg42: return "MCK_Reg42";
  case MCK_Reg30: return "MCK_Reg30";
  case MCK_VRN2M4NoV0: return "MCK_VRN2M4NoV0";
  case MCK_Reg43: return "MCK_Reg43";
  case MCK_VRM4NoV0: return "MCK_VRM4NoV0";
  case MCK_VRN2M4: return "MCK_VRN2M4";
  case MCK_Reg59: return "MCK_Reg59";
  case MCK_FPR16C: return "MCK_FPR16C";
  case MCK_FPR32C: return "MCK_FPR32C";
  case MCK_FPR64C: return "MCK_FPR64C";
  case MCK_GPRC: return "MCK_GPRC";
  case MCK_GPRF16C: return "MCK_GPRF16C";
  case MCK_GPRF32C: return "MCK_GPRF32C";
  case MCK_SR07: return "MCK_SR07";
  case MCK_TRM2: return "MCK_TRM2";
  case MCK_VRM4: return "MCK_VRM4";
  case MCK_Reg46: return "MCK_Reg46";
  case MCK_Reg47: return "MCK_Reg47";
  case MCK_Reg40: return "MCK_Reg40";
  case MCK_Reg24: return "MCK_Reg24";
  case MCK_VRN4M2NoV0: return "MCK_VRN4M2NoV0";
  case MCK_Reg41: return "MCK_Reg41";
  case MCK_Reg37: return "MCK_Reg37";
  case MCK_Reg20: return "MCK_Reg20";
  case MCK_GPRTCNonX7: return "MCK_GPRTCNonX7";
  case MCK_VRN3M2NoV0: return "MCK_VRN3M2NoV0";
  case MCK_VRN4M2: return "MCK_VRN4M2";
  case MCK_Reg38: return "MCK_Reg38";
  case MCK_Reg34: return "MCK_Reg34";
  case MCK_GPRTC: return "MCK_GPRTC";
  case MCK_VRN2M2NoV0: return "MCK_VRN2M2NoV0";
  case MCK_VRN3M2: return "MCK_VRN3M2";
  case MCK_GPRPairNoX0: return "MCK_GPRPairNoX0";
  case MCK_VRM2NoV0: return "MCK_VRM2NoV0";
  case MCK_VRN2M2: return "MCK_VRN2M2";
  case MCK_GPRPair: return "MCK_GPRPair";
  case MCK_TR: return "MCK_TR";
  case MCK_VRM2: return "MCK_VRM2";
  case MCK_Reg22: return "MCK_Reg22";
  case MCK_VRN8M1NoV0: return "MCK_VRN8M1NoV0";
  case MCK_Reg18: return "MCK_Reg18";
  case MCK_GPRJALRNonX7: return "MCK_GPRJALRNonX7";
  case MCK_VRN7M1NoV0: return "MCK_VRN7M1NoV0";
  case MCK_VRN8M1: return "MCK_VRN8M1";
  case MCK_GPRJALR: return "MCK_GPRJALR";
  case MCK_VRN6M1NoV0: return "MCK_VRN6M1NoV0";
  case MCK_VRN7M1: return "MCK_VRN7M1";
  case MCK_VRN5M1NoV0: return "MCK_VRN5M1NoV0";
  case MCK_VRN6M1: return "MCK_VRN6M1";
  case MCK_VRN4M1NoV0: return "MCK_VRN4M1NoV0";
  case MCK_VRN5M1: return "MCK_VRN5M1";
  case MCK_Reg13: return "MCK_Reg13";
  case MCK_VRN3M1NoV0: return "MCK_VRN3M1NoV0";
  case MCK_VRN4M1: return "MCK_VRN4M1";
  case MCK_Reg11: return "MCK_Reg11";
  case MCK_GPRNoX0X2: return "MCK_GPRNoX0X2";
  case MCK_VRN2M1NoV0: return "MCK_VRN2M1NoV0";
  case MCK_VRN3M1: return "MCK_VRN3M1";
  case MCK_GPRF16NoX0: return "MCK_GPRF16NoX0";
  case MCK_GPRF32NoX0: return "MCK_GPRF32NoX0";
  case MCK_GPRNoX0: return "MCK_GPRNoX0";
  case MCK_GPRNoX31: return "MCK_GPRNoX31";
  case MCK_VRN2M1: return "MCK_VRN2M1";
  case MCK_VRNoV0: return "MCK_VRNoV0";
  case MCK_FPR128: return "MCK_FPR128";
  case MCK_FPR16: return "MCK_FPR16";
  case MCK_FPR32: return "MCK_FPR32";
  case MCK_FPR64: return "MCK_FPR64";
  case MCK_GPR: return "MCK_GPR";
  case MCK_GPRF16: return "MCK_GPRF16";
  case MCK_GPRF32: return "MCK_GPRF32";
  case MCK_VM: return "MCK_VM";
  case MCK_GPRAll: return "MCK_GPRAll";
  case MCK_AnyRegCOperand: return "MCK_AnyRegCOperand";
  case MCK_AnyRegOperand: return "MCK_AnyRegOperand";
  case MCK_BareSymbol: return "MCK_BareSymbol";
  case MCK_BareSymbolQC_E_LI: return "MCK_BareSymbolQC_E_LI";
  case MCK_CLUIImm: return "MCK_CLUIImm";
  case MCK_CSRSystemRegister: return "MCK_CSRSystemRegister";
  case MCK_RegReg: return "MCK_RegReg";
  case MCK_CallSymbol: return "MCK_CallSymbol";
  case MCK_FRMArg: return "MCK_FRMArg";
  case MCK_FRMArgLegacy: return "MCK_FRMArgLegacy";
  case MCK_FenceArg: return "MCK_FenceArg";
  case MCK_GPRAsFPR16: return "MCK_GPRAsFPR16";
  case MCK_GPRAsFPR32: return "MCK_GPRAsFPR32";
  case MCK_GPRF64AsFPR: return "MCK_GPRF64AsFPR";
  case MCK_GPRPairAsFPR: return "MCK_GPRPairAsFPR";
  case MCK_GPRPairCRV32: return "MCK_GPRPairCRV32";
  case MCK_GPRPairNoX0RV32: return "MCK_GPRPairNoX0RV32";
  case MCK_GPRPairRV32: return "MCK_GPRPairRV32";
  case MCK_GPRPairRV64: return "MCK_GPRPairRV64";
  case MCK_Imm: return "MCK_Imm";
  case MCK_ImmFour: return "MCK_ImmFour";
  case MCK_ImmThree: return "MCK_ImmThree";
  case MCK_ImmZero: return "MCK_ImmZero";
  case MCK_InsnCDirectiveOpcode: return "MCK_InsnCDirectiveOpcode";
  case MCK_InsnDirectiveOpcode: return "MCK_InsnDirectiveOpcode";
  case MCK_LoadFPImm: return "MCK_LoadFPImm";
  case MCK_NegStackAdj: return "MCK_NegStackAdj";
  case MCK_PseudoJumpSymbol: return "MCK_PseudoJumpSymbol";
  case MCK_RTZArg: return "MCK_RTZArg";
  case MCK_RegList: return "MCK_RegList";
  case MCK_RegListS0: return "MCK_RegListS0";
  case MCK_RnumArg: return "MCK_RnumArg";
  case MCK_SImm10Unsigned: return "MCK_SImm10Unsigned";
  case MCK_BareSImm21Lsb0: return "MCK_BareSImm21Lsb0";
  case MCK_StackAdj: return "MCK_StackAdj";
  case MCK_TLSDESCCallSymbol: return "MCK_TLSDESCCallSymbol";
  case MCK_TPRelAddSymbol: return "MCK_TPRelAddSymbol";
  case MCK_UImm5Plus1: return "MCK_UImm5Plus1";
  case MCK_UImmLog2XLen: return "MCK_UImmLog2XLen";
  case MCK_UImmLog2XLenNonZero: return "MCK_UImmLog2XLenNonZero";
  case MCK_RVVMaskRegOpOperand: return "MCK_RVVMaskRegOpOperand";
  case MCK_RVVMaskCarryInRegOpOperand: return "MCK_RVVMaskCarryInRegOpOperand";
  case MCK_XSfmmVType: return "MCK_XSfmmVType";
  case MCK_ZeroOffsetMemOpOperand: return "MCK_ZeroOffsetMemOpOperand";
  case MCK_SImm12Lsb00000: return "MCK_SImm12Lsb00000";
  case MCK_VTypeI10: return "MCK_VTypeI10";
  case MCK_VTypeI11: return "MCK_VTypeI11";
  case MCK_SImm5: return "MCK_SImm5";
  case MCK_SImm5Plus1: return "MCK_SImm5Plus1";
  case MCK_SImm10: return "MCK_SImm10";
  case MCK_SImm6: return "MCK_SImm6";
  case MCK_SImm6NonZero: return "MCK_SImm6NonZero";
  case MCK_UImm7Lsb00: return "MCK_UImm7Lsb00";
  case MCK_UImm8Lsb00: return "MCK_UImm8Lsb00";
  case MCK_UImm8Lsb000: return "MCK_UImm8Lsb000";
  case MCK_BareSImm9Lsb0: return "MCK_BareSImm9Lsb0";
  case MCK_UImm9Lsb000: return "MCK_UImm9Lsb000";
  case MCK_UImm10Lsb00NonZero: return "MCK_UImm10Lsb00NonZero";
  case MCK_SImm10Lsb0000NonZero: return "MCK_SImm10Lsb0000NonZero";
  case MCK_BareSImm12Lsb0: return "MCK_BareSImm12Lsb0";
  case MCK_UImm2Lsb0: return "MCK_UImm2Lsb0";
  case MCK_UImm8GE32: return "MCK_UImm8GE32";
  case MCK_UImm5Lsb0: return "MCK_UImm5Lsb0";
  case MCK_UImm6Lsb0: return "MCK_UImm6Lsb0";
  case MCK_UImm5NonZero: return "MCK_UImm5NonZero";
  case MCK_UImm5GT3: return "MCK_UImm5GT3";
  case MCK_UImm5GE6Plus1: return "MCK_UImm5GE6Plus1";
  case MCK_UImm5Slist: return "MCK_UImm5Slist";
  case MCK_UImm10: return "MCK_UImm10";
  case MCK_UImm11: return "MCK_UImm11";
  case MCK_UImm14Lsb00: return "MCK_UImm14Lsb00";
  case MCK_UImm16NonZero: return "MCK_UImm16NonZero";
  case MCK_SImm5NonZero: return "MCK_SImm5NonZero";
  case MCK_SImm11: return "MCK_SImm11";
  case MCK_SImm16: return "MCK_SImm16";
  case MCK_SImm16NonZero: return "MCK_SImm16NonZero";
  case MCK_SImm20LI: return "MCK_SImm20LI";
  case MCK_SImm26: return "MCK_SImm26";
  case MCK_BareSImm32: return "MCK_BareSImm32";
  case MCK_BareSImm32Lsb0: return "MCK_BareSImm32Lsb0";
  case MCK_UImm7Lsb000: return "MCK_UImm7Lsb000";
  case MCK_UImm9: return "MCK_UImm9";
  case MCK_BareSImm11Lsb0: return "MCK_BareSImm11Lsb0";
  case MCK_SImm18: return "MCK_SImm18";
  case MCK_SImm18Lsb0: return "MCK_SImm18Lsb0";
  case MCK_SImm19Lsb00: return "MCK_SImm19Lsb00";
  case MCK_SImm20Lsb000: return "MCK_SImm20Lsb000";
  case MCK_UImm1: return "MCK_UImm1";
  case MCK_UImm2: return "MCK_UImm2";
  case MCK_UImm3: return "MCK_UImm3";
  case MCK_UImm4: return "MCK_UImm4";
  case MCK_UImm5: return "MCK_UImm5";
  case MCK_UImm6: return "MCK_UImm6";
  case MCK_UImm7: return "MCK_UImm7";
  case MCK_UImm8: return "MCK_UImm8";
  case MCK_UImm16: return "MCK_UImm16";
  case MCK_UImm32: return "MCK_UImm32";
  case MCK_UImm48: return "MCK_UImm48";
  case MCK_UImm64: return "MCK_UImm64";
  case MCK_SImm12: return "MCK_SImm12";
  case MCK_BareSImm13Lsb0: return "MCK_BareSImm13Lsb0";
  case MCK_UImm20: return "MCK_UImm20";
  case MCK_UImm20LUI: return "MCK_UImm20LUI";
  case MCK_UImm20AUIPC: return "MCK_UImm20AUIPC";
  case MCK_ImmXLenLI: return "MCK_ImmXLenLI";
  case MCK_ImmXLenLI_Restricted: return "MCK_ImmXLenLI_Restricted";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
FeatureBitset RISCVAsmParser::
ComputeAvailableFeatures(const FeatureBitset &FB) const {
  FeatureBitset Features;
  if (FB[RISCV::FeatureStdExtZicbom])
    Features.set(Feature_HasStdExtZicbomBit);
  if (FB[RISCV::FeatureStdExtZicbop])
    Features.set(Feature_HasStdExtZicbopBit);
  if (FB[RISCV::FeatureStdExtZicboz])
    Features.set(Feature_HasStdExtZicbozBit);
  if (FB[RISCV::FeatureStdExtZicsr])
    Features.set(Feature_HasStdExtZicsrBit);
  if (FB[RISCV::FeatureStdExtZicond])
    Features.set(Feature_HasStdExtZicondBit);
  if (FB[RISCV::FeatureStdExtZifencei])
    Features.set(Feature_HasStdExtZifenceiBit);
  if (FB[RISCV::FeatureStdExtZihintpause])
    Features.set(Feature_HasStdExtZihintpauseBit);
  if (FB[RISCV::FeatureStdExtZihintntl])
    Features.set(Feature_HasStdExtZihintntlBit);
  if (FB[RISCV::FeatureStdExtZimop])
    Features.set(Feature_HasStdExtZimopBit);
  if (FB[RISCV::FeatureStdExtZicfilp])
    Features.set(Feature_HasStdExtZicfilpBit);
  if (!FB[RISCV::FeatureStdExtZicfilp])
    Features.set(Feature_NoStdExtZicfilpBit);
  if (FB[RISCV::FeatureStdExtZicfiss])
    Features.set(Feature_HasStdExtZicfissBit);
  if (FB[RISCV::FeatureStdExtZilsd])
    Features.set(Feature_HasStdExtZilsdBit);
  if (FB[RISCV::FeatureStdExtZmmul])
    Features.set(Feature_HasStdExtZmmulBit);
  if (FB[RISCV::FeatureStdExtM])
    Features.set(Feature_HasStdExtMBit);
  if (FB[RISCV::FeatureStdExtZaamo])
    Features.set(Feature_HasStdExtZaamoBit);
  if (FB[RISCV::FeatureStdExtZalrsc])
    Features.set(Feature_HasStdExtZalrscBit);
  if (FB[RISCV::FeatureStdExtA])
    Features.set(Feature_HasStdExtABit);
  if (FB[RISCV::FeatureStdExtZtso])
    Features.set(Feature_HasStdExtZtsoBit);
  if (FB[RISCV::FeatureStdExtZabha])
    Features.set(Feature_HasStdExtZabhaBit);
  if (FB[RISCV::FeatureStdExtZacas])
    Features.set(Feature_HasStdExtZacasBit);
  if (FB[RISCV::FeatureStdExtZalasr])
    Features.set(Feature_HasStdExtZalasrBit);
  if (FB[RISCV::FeatureStdExtZawrs])
    Features.set(Feature_HasStdExtZawrsBit);
  if (FB[RISCV::FeatureStdExtF])
    Features.set(Feature_HasStdExtFBit);
  if (FB[RISCV::FeatureStdExtD])
    Features.set(Feature_HasStdExtDBit);
  if (FB[RISCV::FeatureStdExtQ])
    Features.set(Feature_HasStdExtQBit);
  if (FB[RISCV::FeatureStdExtZfhmin])
    Features.set(Feature_HasStdExtZfhminBit);
  if (FB[RISCV::FeatureStdExtZfh])
    Features.set(Feature_HasStdExtZfhBit);
  if (FB[RISCV::FeatureStdExtZfbfmin])
    Features.set(Feature_HasStdExtZfbfminBit);
  if (FB[RISCV::FeatureStdExtZfh] || FB[RISCV::FeatureStdExtZfhmin] || FB[RISCV::FeatureStdExtZfbfmin])
    Features.set(Feature_HasHalfFPLoadStoreMoveBit);
  if (FB[RISCV::FeatureStdExtZfa])
    Features.set(Feature_HasStdExtZfaBit);
  if (FB[RISCV::FeatureStdExtZfinx])
    Features.set(Feature_HasStdExtZfinxBit);
  if (FB[RISCV::FeatureStdExtF] || FB[RISCV::FeatureStdExtZfinx])
    Features.set(Feature_HasStdExtFOrZfinxBit);
  if (FB[RISCV::FeatureStdExtZdinx])
    Features.set(Feature_HasStdExtZdinxBit);
  if (FB[RISCV::FeatureStdExtZhinxmin])
    Features.set(Feature_HasStdExtZhinxminBit);
  if (FB[RISCV::FeatureStdExtZhinx])
    Features.set(Feature_HasStdExtZhinxBit);
  if (FB[RISCV::FeatureStdExtZca])
    Features.set(Feature_HasStdExtZcaBit);
  if (FB[RISCV::FeatureStdExtC])
    Features.set(Feature_HasStdExtCBit);
  if (FB[RISCV::FeatureStdExtZcb])
    Features.set(Feature_HasStdExtZcbBit);
  if (FB[RISCV::FeatureStdExtC] || FB[RISCV::FeatureStdExtZcd])
    Features.set(Feature_HasStdExtCOrZcdBit);
  if (FB[RISCV::FeatureStdExtZclsd])
    Features.set(Feature_HasStdExtZclsdBit);
  if (FB[RISCV::FeatureStdExtZcmp])
    Features.set(Feature_HasStdExtZcmpBit);
  if (FB[RISCV::FeatureStdExtZcmt])
    Features.set(Feature_HasStdExtZcmtBit);
  if (FB[RISCV::FeatureStdExtC] || FB[RISCV::FeatureStdExtZcf] || FB[RISCV::FeatureStdExtZce])
    Features.set(Feature_HasStdExtCOrZcfOrZceBit);
  if (FB[RISCV::FeatureStdExtZcmop])
    Features.set(Feature_HasStdExtZcmopBit);
  if (FB[RISCV::FeatureStdExtZba])
    Features.set(Feature_HasStdExtZbaBit);
  if (FB[RISCV::FeatureStdExtZbb])
    Features.set(Feature_HasStdExtZbbBit);
  if (!FB[RISCV::FeatureStdExtZbb])
    Features.set(Feature_NoStdExtZbbBit);
  if (FB[RISCV::FeatureStdExtZbc])
    Features.set(Feature_HasStdExtZbcBit);
  if (FB[RISCV::FeatureStdExtZbs])
    Features.set(Feature_HasStdExtZbsBit);
  if (FB[RISCV::FeatureStdExtZbkb])
    Features.set(Feature_HasStdExtZbkbBit);
  if (!FB[RISCV::FeatureStdExtZbkb])
    Features.set(Feature_NoStdExtZbkbBit);
  if (FB[RISCV::FeatureStdExtZbkx])
    Features.set(Feature_HasStdExtZbkxBit);
  if (FB[RISCV::FeatureStdExtZbb] || FB[RISCV::FeatureStdExtZbkb])
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (FB[RISCV::FeatureStdExtZbkc])
    Features.set(Feature_HasStdExtZbkcBit);
  if (FB[RISCV::FeatureStdExtZbc] || FB[RISCV::FeatureStdExtZbkc])
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (FB[RISCV::FeatureStdExtZknd])
    Features.set(Feature_HasStdExtZkndBit);
  if (FB[RISCV::FeatureStdExtZkne])
    Features.set(Feature_HasStdExtZkneBit);
  if (FB[RISCV::FeatureStdExtZknd] || FB[RISCV::FeatureStdExtZkne])
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (FB[RISCV::FeatureStdExtZknh])
    Features.set(Feature_HasStdExtZknhBit);
  if (FB[RISCV::FeatureStdExtZksed])
    Features.set(Feature_HasStdExtZksedBit);
  if (FB[RISCV::FeatureStdExtZksh])
    Features.set(Feature_HasStdExtZkshBit);
  if (FB[RISCV::FeatureStdExtZkr])
    Features.set(Feature_HasStdExtZkrBit);
  if (FB[RISCV::FeatureStdExtZvfbfmin])
    Features.set(Feature_HasStdExtZvfbfminBit);
  if (FB[RISCV::FeatureStdExtZvfbfwma])
    Features.set(Feature_HasStdExtZvfbfwmaBit);
  if (FB[RISCV::FeatureStdExtZfh] || FB[RISCV::FeatureStdExtZvfh])
    Features.set(Feature_HasStdExtZfhOrZvfhBit);
  if (FB[RISCV::FeatureStdExtZvkb])
    Features.set(Feature_HasStdExtZvkbBit);
  if (FB[RISCV::FeatureStdExtZvbb])
    Features.set(Feature_HasStdExtZvbbBit);
  if (FB[RISCV::FeatureStdExtZvbc])
    Features.set(Feature_HasStdExtZvbcBit);
  if (FB[RISCV::FeatureStdExtZvbc] || FB[RISCV::FeatureStdExtZvbc32e])
    Features.set(Feature_HasStdExtZvbcOrZvbc32eBit);
  if (FB[RISCV::FeatureStdExtZvkg])
    Features.set(Feature_HasStdExtZvkgBit);
  if (FB[RISCV::FeatureStdExtZvkgs])
    Features.set(Feature_HasStdExtZvkgsBit);
  if (FB[RISCV::FeatureStdExtZvkned])
    Features.set(Feature_HasStdExtZvknedBit);
  if (FB[RISCV::FeatureStdExtZvknha])
    Features.set(Feature_HasStdExtZvknhaBit);
  if (FB[RISCV::FeatureStdExtZvknhb])
    Features.set(Feature_HasStdExtZvknhbBit);
  if (FB[RISCV::FeatureStdExtZvknha] || FB[RISCV::FeatureStdExtZvknhb])
    Features.set(Feature_HasStdExtZvknhaOrZvknhbBit);
  if (FB[RISCV::FeatureStdExtZvksed])
    Features.set(Feature_HasStdExtZvksedBit);
  if (FB[RISCV::FeatureStdExtZvksh])
    Features.set(Feature_HasStdExtZvkshBit);
  if (FB[RISCV::FeatureStdExtZvqdotq])
    Features.set(Feature_HasStdExtZvqdotqBit);
  if (FB[RISCV::FeatureStdExtZve32x])
    Features.set(Feature_HasVInstructionsBit);
  if (FB[RISCV::FeatureStdExtZve64x])
    Features.set(Feature_HasVInstructionsI64Bit);
  if (FB[RISCV::FeatureStdExtZve32f])
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (FB[RISCV::FeatureStdExtZvfhmin] || FB[RISCV::FeatureStdExtZvfh])
    Features.set(Feature_HasVInstructionsF16MinimalBit);
  if (FB[RISCV::FeatureStdExtH])
    Features.set(Feature_HasStdExtHBit);
  if (FB[RISCV::FeatureStdExtSmrnmi])
    Features.set(Feature_HasStdExtSmrnmiBit);
  if (FB[RISCV::FeatureStdExtSvinval])
    Features.set(Feature_HasStdExtSvinvalBit);
  if (FB[RISCV::FeatureStdExtSmctr] || FB[RISCV::FeatureStdExtSsctr])
    Features.set(Feature_HasStdExtSmctrOrSsctrBit);
  if (FB[RISCV::FeatureStdExtP])
    Features.set(Feature_HasStdExtPBit);
  if (FB[RISCV::FeatureStdExtZba] || FB[RISCV::FeatureStdExtP])
    Features.set(Feature_HasStdExtZbaOrPBit);
  if (FB[RISCV::FeatureStdExtZbb] || FB[RISCV::FeatureStdExtP])
    Features.set(Feature_HasStdExtZbbOrPBit);
  if (FB[RISCV::FeatureStdExtZbkb] || FB[RISCV::FeatureStdExtP])
    Features.set(Feature_HasStdExtZbkbOrPBit);
  if (FB[RISCV::FeatureStdExtZbb] || FB[RISCV::FeatureStdExtZbkb] || FB[RISCV::FeatureStdExtP])
    Features.set(Feature_HasStdExtZbbOrZbkbOrPBit);
  if (FB[RISCV::FeatureVendorXVentanaCondOps])
    Features.set(Feature_HasVendorXVentanaCondOpsBit);
  if (FB[RISCV::FeatureVendorXTHeadBa])
    Features.set(Feature_HasVendorXTHeadBaBit);
  if (FB[RISCV::FeatureVendorXTHeadBb])
    Features.set(Feature_HasVendorXTHeadBbBit);
  if (FB[RISCV::FeatureVendorXTHeadBs])
    Features.set(Feature_HasVendorXTHeadBsBit);
  if (FB[RISCV::FeatureVendorXTHeadCondMov])
    Features.set(Feature_HasVendorXTHeadCondMovBit);
  if (FB[RISCV::FeatureVendorXTHeadCmo])
    Features.set(Feature_HasVendorXTHeadCmoBit);
  if (FB[RISCV::FeatureVendorXTHeadFMemIdx])
    Features.set(Feature_HasVendorXTHeadFMemIdxBit);
  if (FB[RISCV::FeatureVendorXTHeadMac])
    Features.set(Feature_HasVendorXTHeadMacBit);
  if (FB[RISCV::FeatureVendorXTHeadMemIdx])
    Features.set(Feature_HasVendorXTHeadMemIdxBit);
  if (FB[RISCV::FeatureVendorXTHeadMemPair])
    Features.set(Feature_HasVendorXTHeadMemPairBit);
  if (FB[RISCV::FeatureVendorXTHeadSync])
    Features.set(Feature_HasVendorXTHeadSyncBit);
  if (FB[RISCV::FeatureVendorXTHeadVdot])
    Features.set(Feature_HasVendorXTHeadVdotBit);
  if (FB[RISCV::FeatureVendorXSfvcp])
    Features.set(Feature_HasVendorXSfvcpBit);
  if (FB[RISCV::FeatureVendorXSfmmbase])
    Features.set(Feature_HasVendorXSfmmbaseBit);
  if (FB[RISCV::FeatureVendorXSfmm32a8f])
    Features.set(Feature_HasVendorXSfmm32a8fBit);
  if (FB[RISCV::FeatureVendorXSfmm32a8i])
    Features.set(Feature_HasVendorXSfmm32a8iBit);
  if (FB[RISCV::FeatureVendorXSfmm32a16f] || FB[RISCV::FeatureVendorXSfmm32a32f] || FB[RISCV::FeatureVendorXSfmm64a64f])
    Features.set(Feature_HasVendorXSfmm32a16fOrXSfmm32a32fOrXSfmm64a64fBit);
  if (FB[RISCV::FeatureVendorXSfvqmaccdod])
    Features.set(Feature_HasVendorXSfvqmaccdodBit);
  if (FB[RISCV::FeatureVendorXSfvqmaccqoq])
    Features.set(Feature_HasVendorXSfvqmaccqoqBit);
  if (FB[RISCV::FeatureVendorXSfvfwmaccqqq])
    Features.set(Feature_HasVendorXSfvfwmaccqqqBit);
  if (FB[RISCV::FeatureVendorXSfvfnrclipxfqf])
    Features.set(Feature_HasVendorXSfvfnrclipxfqfBit);
  if (FB[RISCV::FeatureVendorXSiFivecdiscarddlone])
    Features.set(Feature_HasVendorXSiFivecdiscarddloneBit);
  if (FB[RISCV::FeatureVendorXSiFivecflushdlone])
    Features.set(Feature_HasVendorXSiFivecflushdloneBit);
  if (FB[RISCV::FeatureVendorXSfcease])
    Features.set(Feature_HasVendorXSfceaseBit);
  if (FB[RISCV::FeatureVendorXCVelw])
    Features.set(Feature_HasVendorXCVelwBit);
  if (FB[RISCV::FeatureVendorXCVbitmanip])
    Features.set(Feature_HasVendorXCVbitmanipBit);
  if (FB[RISCV::FeatureVendorXCVmac])
    Features.set(Feature_HasVendorXCVmacBit);
  if (FB[RISCV::FeatureVendorXCVmem])
    Features.set(Feature_HasVendorXCVmemBit);
  if (FB[RISCV::FeatureVendorXCValu])
    Features.set(Feature_HasVendorXCValuBit);
  if (FB[RISCV::FeatureVendorXCVsimd])
    Features.set(Feature_HasVendorXCVsimdBit);
  if (FB[RISCV::FeatureVendorXCVbi])
    Features.set(Feature_HasVendorXCVbiBit);
  if (FB[RISCV::FeatureVendorXMIPSCMov])
    Features.set(Feature_HasVendorXMIPSCMovBit);
  if (FB[RISCV::FeatureVendorXMIPSLSP])
    Features.set(Feature_HasVendorXMIPSLSPBit);
  if (FB[RISCV::FeatureVendorXMIPSCBOP])
    Features.set(Feature_HasVendorXMIPSCBOPBit);
  if (FB[RISCV::FeatureVendorXwchc])
    Features.set(Feature_HasVendorXwchcBit);
  if (FB[RISCV::FeatureVendorXqccmp])
    Features.set(Feature_HasVendorXqccmpBit);
  if (FB[RISCV::FeatureVendorXqcia])
    Features.set(Feature_HasVendorXqciaBit);
  if (FB[RISCV::FeatureVendorXqciac])
    Features.set(Feature_HasVendorXqciacBit);
  if (FB[RISCV::FeatureVendorXqcibi])
    Features.set(Feature_HasVendorXqcibiBit);
  if (FB[RISCV::FeatureVendorXqcibm])
    Features.set(Feature_HasVendorXqcibmBit);
  if (FB[RISCV::FeatureVendorXqcicli])
    Features.set(Feature_HasVendorXqcicliBit);
  if (FB[RISCV::FeatureVendorXqcicm])
    Features.set(Feature_HasVendorXqcicmBit);
  if (FB[RISCV::FeatureVendorXqcics])
    Features.set(Feature_HasVendorXqcicsBit);
  if (FB[RISCV::FeatureVendorXqcicsr])
    Features.set(Feature_HasVendorXqcicsrBit);
  if (FB[RISCV::FeatureVendorXqciint])
    Features.set(Feature_HasVendorXqciintBit);
  if (FB[RISCV::FeatureVendorXqciio])
    Features.set(Feature_HasVendorXqciioBit);
  if (FB[RISCV::FeatureVendorXqcilb])
    Features.set(Feature_HasVendorXqcilbBit);
  if (FB[RISCV::FeatureVendorXqcili])
    Features.set(Feature_HasVendorXqciliBit);
  if (FB[RISCV::FeatureVendorXqcilia])
    Features.set(Feature_HasVendorXqciliaBit);
  if (FB[RISCV::FeatureVendorXqcilo])
    Features.set(Feature_HasVendorXqciloBit);
  if (FB[RISCV::FeatureVendorXqcilsm])
    Features.set(Feature_HasVendorXqcilsmBit);
  if (FB[RISCV::FeatureVendorXqcisim])
    Features.set(Feature_HasVendorXqcisimBit);
  if (FB[RISCV::FeatureVendorXqcisls])
    Features.set(Feature_HasVendorXqcislsBit);
  if (FB[RISCV::FeatureVendorXqcisync])
    Features.set(Feature_HasVendorXqcisyncBit);
  if (FB[RISCV::FeatureVendorXRivosVisni])
    Features.set(Feature_HasVendorXRivosVisniBit);
  if (FB[RISCV::FeatureVendorXRivosVizip])
    Features.set(Feature_HasVendorXRivosVizipBit);
  if (FB[RISCV::FeatureVendorXAndesPerf])
    Features.set(Feature_HasVendorXAndesPerfBit);
  if (FB[RISCV::FeatureVendorXAndesBFHCvt])
    Features.set(Feature_HasVendorXAndesBFHCvtBit);
  if (FB[RISCV::FeatureVendorXAndesVBFHCvt])
    Features.set(Feature_HasVendorXAndesVBFHCvtBit);
  if (FB[RISCV::FeatureVendorXAndesVSIntLoad])
    Features.set(Feature_HasVendorXAndesVSIntLoadBit);
  if (FB[RISCV::FeatureVendorXAndesVPackFPH])
    Features.set(Feature_HasVendorXAndesVPackFPHBit);
  if (FB[RISCV::FeatureVendorXAndesVDot])
    Features.set(Feature_HasVendorXAndesVDotBit);
  if (FB[RISCV::Feature64Bit])
    Features.set(Feature_IsRV64Bit);
  if (!FB[RISCV::Feature64Bit])
    Features.set(Feature_IsRV32Bit);
  return Features;
}

static bool checkAsmTiedOperandConstraints(const RISCVAsmParser&AsmParser,
                               unsigned Kind, const OperandVector &Operands,
                               ArrayRef<unsigned> DefaultsOffset,
                               uint64_t &ErrorInfo) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    case CVT_Tied: {
      unsigned OpIdx = *(p + 1);
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned OpndNum1 = TiedAsmOperandTable[OpIdx][1];
      unsigned OpndNum2 = TiedAsmOperandTable[OpIdx][2];
      OpndNum1 = OpndNum1 - DefaultsOffset[OpndNum1];
      OpndNum2 = OpndNum2 - DefaultsOffset[OpndNum2];
      if (OpndNum1 != OpndNum2) {
        auto &SrcOp1 = Operands[OpndNum1];
        auto &SrcOp2 = Operands[OpndNum2];
        if (!AsmParser.areEqualRegs(*SrcOp1, *SrcOp2)) {
          ErrorInfo = OpndNum2;
          return false;
        }
      }
      break;
    }
    default:
      break;
    }
  }
  return true;
}

static const char MnemonicTable[] =
    "\007.insn_b\010.insn_ca\010.insn_cb\010.insn_ci\t.insn_ciw\010.insn_cj\010"
    ".insn_cl\010.insn_cr\010.insn_cs\t.insn_css\007.insn_i\007.insn_j\014.i"
    "nsn_qc.eai\013.insn_qc.eb\013.insn_qc.ei\013.insn_qc.ej\013.insn_qc.es\007"
    ".insn_r\010.insn_r4\007.insn_s\010.insn_sb\007.insn_u\010.insn_uj\003ab"
    "s\004absw\003add\006add.uw\004addi\005addiw\004addw\010aes32dsi\taes32d"
    "smi\010aes32esi\taes32esmi\007aes64ds\010aes64dsm\007aes64es\010aes64es"
    "m\007aes64im\taes64ks1i\010aes64ks2\010amoadd.b\013amoadd.b.aq\015amoad"
    "d.b.aqrl\013amoadd.b.rl\010amoadd.d\013amoadd.d.aq\015amoadd.d.aqrl\013"
    "amoadd.d.rl\010amoadd.h\013amoadd.h.aq\015amoadd.h.aqrl\013amoadd.h.rl\010"
    "amoadd.w\013amoadd.w.aq\015amoadd.w.aqrl\013amoadd.w.rl\010amoand.b\013"
    "amoand.b.aq\015amoand.b.aqrl\013amoand.b.rl\010amoand.d\013amoand.d.aq\015"
    "amoand.d.aqrl\013amoand.d.rl\010amoand.h\013amoand.h.aq\015amoand.h.aqr"
    "l\013amoand.h.rl\010amoand.w\013amoand.w.aq\015amoand.w.aqrl\013amoand."
    "w.rl\010amocas.b\013amocas.b.aq\015amocas.b.aqrl\013amocas.b.rl\010amoc"
    "as.d\013amocas.d.aq\015amocas.d.aqrl\013amocas.d.rl\010amocas.h\013amoc"
    "as.h.aq\015amocas.h.aqrl\013amocas.h.rl\010amocas.q\013amocas.q.aq\015a"
    "mocas.q.aqrl\013amocas.q.rl\010amocas.w\013amocas.w.aq\015amocas.w.aqrl"
    "\013amocas.w.rl\010amomax.b\013amomax.b.aq\015amomax.b.aqrl\013amomax.b"
    ".rl\010amomax.d\013amomax.d.aq\015amomax.d.aqrl\013amomax.d.rl\010amoma"
    "x.h\013amomax.h.aq\015amomax.h.aqrl\013amomax.h.rl\010amomax.w\013amoma"
    "x.w.aq\015amomax.w.aqrl\013amomax.w.rl\tamomaxu.b\014amomaxu.b.aq\016am"
    "omaxu.b.aqrl\014amomaxu.b.rl\tamomaxu.d\014amomaxu.d.aq\016amomaxu.d.aq"
    "rl\014amomaxu.d.rl\tamomaxu.h\014amomaxu.h.aq\016amomaxu.h.aqrl\014amom"
    "axu.h.rl\tamomaxu.w\014amomaxu.w.aq\016amomaxu.w.aqrl\014amomaxu.w.rl\010"
    "amomin.b\013amomin.b.aq\015amomin.b.aqrl\013amomin.b.rl\010amomin.d\013"
    "amomin.d.aq\015amomin.d.aqrl\013amomin.d.rl\010amomin.h\013amomin.h.aq\015"
    "amomin.h.aqrl\013amomin.h.rl\010amomin.w\013amomin.w.aq\015amomin.w.aqr"
    "l\013amomin.w.rl\tamominu.b\014amominu.b.aq\016amominu.b.aqrl\014amomin"
    "u.b.rl\tamominu.d\014amominu.d.aq\016amominu.d.aqrl\014amominu.d.rl\tam"
    "ominu.h\014amominu.h.aq\016amominu.h.aqrl\014amominu.h.rl\tamominu.w\014"
    "amominu.w.aq\016amominu.w.aqrl\014amominu.w.rl\007amoor.b\namoor.b.aq\014"
    "amoor.b.aqrl\namoor.b.rl\007amoor.d\namoor.d.aq\014amoor.d.aqrl\namoor."
    "d.rl\007amoor.h\namoor.h.aq\014amoor.h.aqrl\namoor.h.rl\007amoor.w\namo"
    "or.w.aq\014amoor.w.aqrl\namoor.w.rl\tamoswap.b\014amoswap.b.aq\016amosw"
    "ap.b.aqrl\014amoswap.b.rl\tamoswap.d\014amoswap.d.aq\016amoswap.d.aqrl\014"
    "amoswap.d.rl\tamoswap.h\014amoswap.h.aq\016amoswap.h.aqrl\014amoswap.h."
    "rl\tamoswap.w\014amoswap.w.aq\016amoswap.w.aqrl\014amoswap.w.rl\010amox"
    "or.b\013amoxor.b.aq\015amoxor.b.aqrl\013amoxor.b.rl\010amoxor.d\013amox"
    "or.d.aq\015amoxor.d.aqrl\013amoxor.d.rl\010amoxor.h\013amoxor.h.aq\015a"
    "moxor.h.aqrl\013amoxor.h.rl\010amoxor.w\013amoxor.w.aq\015amoxor.w.aqrl"
    "\013amoxor.w.rl\003and\004andi\004andn\005auipc\004bclr\005bclri\003beq"
    "\004beqz\004bext\005bexti\003bge\004bgeu\004bgez\003bgt\004bgtu\004bgtz"
    "\004binv\005binvi\003ble\004bleu\004blez\003blt\004bltu\004bltz\003bne\004"
    "bnez\005brev8\004bset\005bseti\005c.add\006c.addi\nc.addi16sp\nc.addi4s"
    "pn\007c.addiw\006c.addw\005c.and\006c.andi\006c.beqz\006c.bnez\010c.ebr"
    "eak\005c.fld\007c.fldsp\005c.flw\007c.flwsp\005c.fsd\007c.fsdsp\005c.fs"
    "w\007c.fswsp\003c.j\005c.jal\006c.jalr\004c.jr\005c.lbu\004c.ld\006c.ld"
    "sp\004c.lh\005c.lhu\004c.li\005c.lui\004c.lw\006c.lwsp\007c.mop.1\010c."
    "mop.11\010c.mop.13\010c.mop.15\007c.mop.3\007c.mop.5\007c.mop.7\007c.mo"
    "p.9\005c.mul\004c.mv\005c.nop\005c.not\tc.ntl.all\010c.ntl.p1\nc.ntl.pa"
    "ll\010c.ntl.s1\004c.or\004c.sb\004c.sd\006c.sdsp\010c.sext.b\010c.sext."
    "h\004c.sh\006c.slli\010c.slli64\006c.srai\010c.srai64\006c.srli\010c.sr"
    "li64\nc.sspopchk\010c.sspush\005c.sub\006c.subw\004c.sw\006c.swsp\007c."
    "unimp\005c.xor\010c.zext.b\010c.zext.h\010c.zext.w\004call\tcbo.clean\t"
    "cbo.flush\tcbo.inval\010cbo.zero\005clmul\006clmulh\006clmulr\003cls\004"
    "clsw\003clz\004clzw\007cm.jalt\005cm.jt\tcm.mva01s\tcm.mvsa01\006cm.pop"
    "\tcm.popret\ncm.popretz\007cm.push\004cpop\005cpopw\004csrc\005csrci\004"
    "csrr\005csrrc\006csrrci\005csrrs\006csrrsi\005csrrw\006csrrwi\004csrs\005"
    "csrsi\004csrw\005csrwi\003ctz\004ctzw\006cv.abs\010cv.abs.b\010cv.abs.h"
    "\010cv.add.b\013cv.add.div2\013cv.add.div4\013cv.add.div8\010cv.add.h\013"
    "cv.add.sc.b\013cv.add.sc.h\014cv.add.sci.b\014cv.add.sci.h\007cv.addn\010"
    "cv.addnr\010cv.addrn\tcv.addrnr\010cv.addun\tcv.addunr\tcv.addurn\ncv.a"
    "ddurnr\010cv.and.b\010cv.and.h\013cv.and.sc.b\013cv.and.sc.h\014cv.and."
    "sci.b\014cv.and.sci.h\010cv.avg.b\010cv.avg.h\013cv.avg.sc.b\013cv.avg."
    "sc.h\014cv.avg.sci.b\014cv.avg.sci.h\tcv.avgu.b\tcv.avgu.h\014cv.avgu.s"
    "c.b\014cv.avgu.sc.h\015cv.avgu.sci.b\015cv.avgu.sci.h\007cv.bclr\010cv."
    "bclrr\tcv.beqimm\tcv.bitrev\tcv.bneimm\007cv.bset\010cv.bsetr\006cv.clb"
    "\007cv.clip\010cv.clipr\010cv.clipu\tcv.clipur\ncv.cmpeq.b\ncv.cmpeq.h\015"
    "cv.cmpeq.sc.b\015cv.cmpeq.sc.h\016cv.cmpeq.sci.b\016cv.cmpeq.sci.h\ncv."
    "cmpge.b\ncv.cmpge.h\015cv.cmpge.sc.b\015cv.cmpge.sc.h\016cv.cmpge.sci.b"
    "\016cv.cmpge.sci.h\013cv.cmpgeu.b\013cv.cmpgeu.h\016cv.cmpgeu.sc.b\016c"
    "v.cmpgeu.sc.h\017cv.cmpgeu.sci.b\017cv.cmpgeu.sci.h\ncv.cmpgt.b\ncv.cmp"
    "gt.h\015cv.cmpgt.sc.b\015cv.cmpgt.sc.h\016cv.cmpgt.sci.b\016cv.cmpgt.sc"
    "i.h\013cv.cmpgtu.b\013cv.cmpgtu.h\016cv.cmpgtu.sc.b\016cv.cmpgtu.sc.h\017"
    "cv.cmpgtu.sci.b\017cv.cmpgtu.sci.h\ncv.cmple.b\ncv.cmple.h\015cv.cmple."
    "sc.b\015cv.cmple.sc.h\016cv.cmple.sci.b\016cv.cmple.sci.h\013cv.cmpleu."
    "b\013cv.cmpleu.h\016cv.cmpleu.sc.b\016cv.cmpleu.sc.h\017cv.cmpleu.sci.b"
    "\017cv.cmpleu.sci.h\ncv.cmplt.b\ncv.cmplt.h\015cv.cmplt.sc.b\015cv.cmpl"
    "t.sc.h\016cv.cmplt.sci.b\016cv.cmplt.sci.h\013cv.cmpltu.b\013cv.cmpltu."
    "h\016cv.cmpltu.sc.b\016cv.cmpltu.sc.h\017cv.cmpltu.sci.b\017cv.cmpltu.s"
    "ci.h\ncv.cmpne.b\ncv.cmpne.h\015cv.cmpne.sc.b\015cv.cmpne.sc.h\016cv.cm"
    "pne.sci.b\016cv.cmpne.sci.h\006cv.cnt\013cv.cplxconj\014cv.cplxmul.i\021"
    "cv.cplxmul.i.div2\021cv.cplxmul.i.div4\021cv.cplxmul.i.div8\014cv.cplxm"
    "ul.r\021cv.cplxmul.r.div2\021cv.cplxmul.r.div4\021cv.cplxmul.r.div8\ncv"
    ".dotsp.b\ncv.dotsp.h\015cv.dotsp.sc.b\015cv.dotsp.sc.h\016cv.dotsp.sci."
    "b\016cv.dotsp.sci.h\ncv.dotup.b\ncv.dotup.h\015cv.dotup.sc.b\015cv.dotu"
    "p.sc.h\016cv.dotup.sci.b\016cv.dotup.sci.h\013cv.dotusp.b\013cv.dotusp."
    "h\016cv.dotusp.sc.b\016cv.dotusp.sc.h\017cv.dotusp.sci.b\017cv.dotusp.s"
    "ci.h\006cv.elw\010cv.extbs\010cv.extbz\010cv.exths\010cv.exthz\ncv.extr"
    "act\014cv.extract.b\014cv.extract.h\013cv.extractr\013cv.extractu\015cv"
    ".extractu.b\015cv.extractu.h\014cv.extractur\006cv.ff1\006cv.fl1\tcv.in"
    "sert\013cv.insert.b\013cv.insert.h\ncv.insertr\005cv.lb\006cv.lbu\005cv"
    ".lh\006cv.lhu\005cv.lw\006cv.mac\ncv.machhsn\013cv.machhsrn\ncv.machhun"
    "\013cv.machhurn\010cv.macsn\tcv.macsrn\010cv.macun\tcv.macurn\006cv.max"
    "\010cv.max.b\010cv.max.h\013cv.max.sc.b\013cv.max.sc.h\014cv.max.sci.b\014"
    "cv.max.sci.h\007cv.maxu\tcv.maxu.b\tcv.maxu.h\014cv.maxu.sc.b\014cv.max"
    "u.sc.h\015cv.maxu.sci.b\015cv.maxu.sci.h\006cv.min\010cv.min.b\010cv.mi"
    "n.h\013cv.min.sc.b\013cv.min.sc.h\014cv.min.sci.b\014cv.min.sci.h\007cv"
    ".minu\tcv.minu.b\tcv.minu.h\014cv.minu.sc.b\014cv.minu.sc.h\015cv.minu."
    "sci.b\015cv.minu.sci.h\006cv.msu\tcv.mulhhs\ncv.mulhhsn\013cv.mulhhsrn\t"
    "cv.mulhhu\ncv.mulhhun\013cv.mulhhurn\007cv.muls\010cv.mulsn\tcv.mulsrn\007"
    "cv.mulu\010cv.mulun\tcv.mulurn\007cv.or.b\007cv.or.h\ncv.or.sc.b\ncv.or"
    ".sc.h\013cv.or.sci.b\013cv.or.sci.h\007cv.pack\tcv.pack.h\013cv.packhi."
    "b\013cv.packlo.b\006cv.ror\005cv.sb\013cv.sdotsp.b\013cv.sdotsp.h\016cv"
    ".sdotsp.sc.b\016cv.sdotsp.sc.h\017cv.sdotsp.sci.b\017cv.sdotsp.sci.h\013"
    "cv.sdotup.b\013cv.sdotup.h\016cv.sdotup.sc.b\016cv.sdotup.sc.h\017cv.sd"
    "otup.sci.b\017cv.sdotup.sci.h\014cv.sdotusp.b\014cv.sdotusp.h\017cv.sdo"
    "tusp.sc.b\017cv.sdotusp.sc.h\020cv.sdotusp.sci.b\020cv.sdotusp.sci.h\005"
    "cv.sh\014cv.shuffle.b\014cv.shuffle.h\020cv.shuffle.sci.h\015cv.shuffle"
    "2.b\015cv.shuffle2.h\022cv.shufflei0.sci.b\022cv.shufflei1.sci.b\022cv."
    "shufflei2.sci.b\022cv.shufflei3.sci.b\006cv.sle\007cv.sleu\010cv.sll.b\010"
    "cv.sll.h\013cv.sll.sc.b\013cv.sll.sc.h\014cv.sll.sci.b\014cv.sll.sci.h\010"
    "cv.sra.b\010cv.sra.h\013cv.sra.sc.b\013cv.sra.sc.h\014cv.sra.sci.b\014c"
    "v.sra.sci.h\010cv.srl.b\010cv.srl.h\013cv.srl.sc.b\013cv.srl.sc.h\014cv"
    ".srl.sci.b\014cv.srl.sci.h\010cv.sub.b\013cv.sub.div2\013cv.sub.div4\013"
    "cv.sub.div8\010cv.sub.h\013cv.sub.sc.b\013cv.sub.sc.h\014cv.sub.sci.b\014"
    "cv.sub.sci.h\007cv.subn\010cv.subnr\010cv.subrn\tcv.subrnr\013cv.subrot"
    "mj\020cv.subrotmj.div2\020cv.subrotmj.div4\020cv.subrotmj.div8\010cv.su"
    "bun\tcv.subunr\tcv.suburn\ncv.suburnr\005cv.sw\010cv.xor.b\010cv.xor.h\013"
    "cv.xor.sc.b\013cv.xor.sc.h\014cv.xor.sci.b\014cv.xor.sci.h\tczero.eqz\t"
    "czero.nez\003div\004divu\005divuw\004divw\004dret\006ebreak\005ecall\006"
    "fabs.d\006fabs.h\006fabs.q\006fabs.s\006fadd.d\006fadd.h\006fadd.q\006f"
    "add.s\010fclass.d\010fclass.h\010fclass.q\010fclass.s\013fcvt.bf16.s\010"
    "fcvt.d.h\010fcvt.d.l\tfcvt.d.lu\010fcvt.d.q\010fcvt.d.s\010fcvt.d.w\tfc"
    "vt.d.wu\010fcvt.h.d\010fcvt.h.l\tfcvt.h.lu\010fcvt.h.s\010fcvt.h.w\tfcv"
    "t.h.wu\010fcvt.l.d\010fcvt.l.h\010fcvt.l.q\010fcvt.l.s\tfcvt.lu.d\tfcvt"
    ".lu.h\tfcvt.lu.q\tfcvt.lu.s\010fcvt.q.d\010fcvt.q.l\tfcvt.q.lu\010fcvt."
    "q.s\010fcvt.q.w\tfcvt.q.wu\013fcvt.s.bf16\010fcvt.s.d\010fcvt.s.h\010fc"
    "vt.s.l\tfcvt.s.lu\010fcvt.s.q\010fcvt.s.w\tfcvt.s.wu\010fcvt.w.d\010fcv"
    "t.w.h\010fcvt.w.q\010fcvt.w.s\tfcvt.wu.d\tfcvt.wu.h\tfcvt.wu.q\tfcvt.wu"
    ".s\013fcvtmod.w.d\006fdiv.d\006fdiv.h\006fdiv.q\006fdiv.s\005fence\007f"
    "ence.i\tfence.tso\005feq.d\005feq.h\005feq.q\005feq.s\005fge.d\005fge.h"
    "\005fge.q\005fge.s\006fgeq.d\006fgeq.h\006fgeq.q\006fgeq.s\005fgt.d\005"
    "fgt.h\005fgt.q\005fgt.s\006fgtq.d\006fgtq.h\006fgtq.q\006fgtq.s\003fld\005"
    "fle.d\005fle.h\005fle.q\005fle.s\006fleq.d\006fleq.h\006fleq.q\006fleq."
    "s\003flh\005fli.d\005fli.h\005fli.q\005fli.s\003flq\005flt.d\005flt.h\005"
    "flt.q\005flt.s\006fltq.d\006fltq.h\006fltq.q\006fltq.s\003flw\007fmadd."
    "d\007fmadd.h\007fmadd.q\007fmadd.s\006fmax.d\006fmax.h\006fmax.q\006fma"
    "x.s\007fmaxm.d\007fmaxm.h\007fmaxm.q\007fmaxm.s\006fmin.d\006fmin.h\006"
    "fmin.q\006fmin.s\007fminm.d\007fminm.h\007fminm.q\007fminm.s\007fmsub.d"
    "\007fmsub.h\007fmsub.q\007fmsub.s\006fmul.d\006fmul.h\006fmul.q\006fmul"
    ".s\005fmv.d\007fmv.d.x\005fmv.h\007fmv.h.x\005fmv.q\005fmv.s\007fmv.w.x"
    "\007fmv.x.d\007fmv.x.h\007fmv.x.w\010fmvh.x.d\010fmvh.x.q\010fmvp.d.x\010"
    "fmvp.q.x\006fneg.d\006fneg.h\006fneg.q\006fneg.s\010fnmadd.d\010fnmadd."
    "h\010fnmadd.q\010fnmadd.s\010fnmsub.d\010fnmsub.h\010fnmsub.q\010fnmsub"
    ".s\005frcsr\007frflags\010fround.d\010fround.h\010fround.q\010fround.s\n"
    "froundnx.d\nfroundnx.h\nfroundnx.q\nfroundnx.s\004frrm\005fscsr\003fsd\007"
    "fsflags\010fsflagsi\007fsgnj.d\007fsgnj.h\007fsgnj.q\007fsgnj.s\010fsgn"
    "jn.d\010fsgnjn.h\010fsgnjn.q\010fsgnjn.s\010fsgnjx.d\010fsgnjx.h\010fsg"
    "njx.q\010fsgnjx.s\003fsh\003fsq\007fsqrt.d\007fsqrt.h\007fsqrt.q\007fsq"
    "rt.s\004fsrm\005fsrmi\006fsub.d\006fsub.h\006fsub.q\006fsub.s\003fsw\013"
    "hfence.gvma\013hfence.vvma\013hinval.gvma\013hinval.vvma\005hlv.b\006hl"
    "v.bu\005hlv.d\005hlv.h\006hlv.hu\005hlv.w\006hlv.wu\007hlvx.hu\007hlvx."
    "wu\005hsv.b\005hsv.d\005hsv.h\005hsv.w\001j\003jal\004jalr\002jr\004jum"
    "p\002la\tla.tls.gd\tla.tls.ie\nla.tlsdesc\002lb\005lb.aq\007lb.aqrl\003"
    "lbu\002ld\005ld.aq\007ld.aqrl\003lga\002lh\005lh.aq\007lh.aqrl\003lhu\002"
    "li\003lla\004lpad\004lr.d\007lr.d.aq\tlr.d.aqrl\007lr.d.rl\004lr.w\007l"
    "r.w.aq\tlr.w.aqrl\007lr.w.rl\003lui\002lw\005lw.aq\007lw.aqrl\003lwu\003"
    "max\004maxu\003min\004minu\nmips.ccmov\010mips.ldp\010mips.lwp\tmips.pr"
    "ef\010mips.sdp\010mips.swp\005mnret\007mop.r.0\007mop.r.1\010mop.r.10\010"
    "mop.r.11\010mop.r.12\010mop.r.13\010mop.r.14\010mop.r.15\010mop.r.16\010"
    "mop.r.17\010mop.r.18\010mop.r.19\007mop.r.2\010mop.r.20\010mop.r.21\010"
    "mop.r.22\010mop.r.23\010mop.r.24\010mop.r.25\010mop.r.26\010mop.r.27\010"
    "mop.r.28\010mop.r.29\007mop.r.3\010mop.r.30\010mop.r.31\007mop.r.4\007m"
    "op.r.5\007mop.r.6\007mop.r.7\007mop.r.8\007mop.r.9\010mop.rr.0\010mop.r"
    "r.1\010mop.rr.2\010mop.rr.3\010mop.rr.4\010mop.rr.5\010mop.rr.6\010mop."
    "rr.7\004mret\003mul\004mulh\006mulhsu\005mulhu\004mulw\002mv\nnds.addig"
    "p\007nds.bbc\007nds.bbs\010nds.beqc\010nds.bfos\010nds.bfoz\010nds.bnec"
    "\017nds.fcvt.bf16.s\017nds.fcvt.s.bf16\007nds.ffb\nnds.ffmism\013nds.ff"
    "zmism\nnds.flmism\010nds.lbgp\tnds.lbugp\010nds.ldgp\014nds.lea.b.ze\tn"
    "ds.lea.d\014nds.lea.d.ze\tnds.lea.h\014nds.lea.h.ze\tnds.lea.w\014nds.l"
    "ea.w.ze\010nds.lhgp\tnds.lhugp\010nds.lwgp\tnds.lwugp\010nds.sbgp\010nd"
    "s.sdgp\010nds.shgp\010nds.swgp\016nds.vd4dots.vv\017nds.vd4dotsu.vv\016"
    "nds.vd4dotu.vv\021nds.vfncvt.bf16.s\016nds.vfpmadb.vf\016nds.vfpmadt.vf"
    "\021nds.vfwcvt.s.bf16\nnds.vln8.v\013nds.vlnu8.v\003neg\004negw\003nop\003"
    "not\007ntl.all\006ntl.p1\010ntl.pall\006ntl.s1\002or\005orc.b\003ori\003"
    "orn\004pack\005packh\005packw\005pause\005pli.b\005pli.h\005pli.w\006pl"
    "ui.h\006plui.w\nprefetch.i\nprefetch.r\nprefetch.w\007psabs.b\007psabs."
    "h\tpsext.h.b\tpsext.w.b\tpsext.w.h\007pslli.b\007pslli.h\007pslli.w\010"
    "psslai.h\010psslai.w\tqc.addsat\nqc.addusat\007qc.beqi\007qc.bgei\010qc"
    ".bgeui\007qc.blti\010qc.bltui\007qc.bnei\tqc.brev32\nqc.c.bexti\nqc.c.b"
    "seti\013qc.c.clrint\nqc.c.delay\007qc.c.di\010qc.c.dir\007qc.c.ei\010qc"
    ".c.eir\tqc.c.extu\014qc.c.mienter\021qc.c.mienter.nest\017qc.c.mileaver"
    "et\nqc.c.mnret\tqc.c.mret\014qc.c.muliadd\nqc.c.mveqz\013qc.c.ptrace\013"
    "qc.c.setint\tqc.c.sync\nqc.c.syncr\013qc.c.syncwf\013qc.c.syncwl\006qc."
    "clo\nqc.clrinti\014qc.cm.mva01s\014qc.cm.mvsa01\tqc.cm.pop\014qc.cm.pop"
    "ret\015qc.cm.popretz\nqc.cm.push\014qc.cm.pushfp\014qc.compress2\014qc."
    "compress3\tqc.csrrwr\nqc.csrrwri\006qc.cto\nqc.e.addai\tqc.e.addi\nqc.e"
    ".andai\tqc.e.andi\tqc.e.beqi\tqc.e.bgei\nqc.e.bgeui\tqc.e.blti\nqc.e.bl"
    "tui\tqc.e.bnei\006qc.e.j\010qc.e.jal\007qc.e.lb\010qc.e.lbu\007qc.e.lh\010"
    "qc.e.lhu\007qc.e.li\007qc.e.lw\tqc.e.orai\010qc.e.ori\007qc.e.sb\007qc."
    "e.sh\007qc.e.sw\nqc.e.xorai\tqc.e.xori\nqc.expand2\nqc.expand3\006qc.ex"
    "t\007qc.extd\tqc.extdpr\nqc.extdprh\010qc.extdr\010qc.extdu\nqc.extdupr"
    "\013qc.extduprh\tqc.extdur\007qc.extu\007qc.insb\010qc.insbh\tqc.insbhr"
    "\010qc.insbi\tqc.insbpr\nqc.insbprh\010qc.insbr\tqc.insbri\006qc.inw\005"
    "qc.li\007qc.lieq\010qc.lieqi\007qc.lige\010qc.ligei\010qc.ligeu\tqc.lig"
    "eui\007qc.lilt\010qc.lilti\010qc.liltu\tqc.liltui\007qc.line\010qc.line"
    "i\006qc.lrb\007qc.lrbu\006qc.lrh\007qc.lrhu\006qc.lrw\006qc.lwm\007qc.l"
    "wmi\nqc.muliadd\007qc.mveq\010qc.mveqi\007qc.mvge\010qc.mvgei\010qc.mvg"
    "eu\tqc.mvgeui\007qc.mvlt\010qc.mvlti\010qc.mvltu\tqc.mvltui\007qc.mvne\010"
    "qc.mvnei\007qc.norm\tqc.normeu\010qc.normu\007qc.outw\014qc.pcoredump\010"
    "qc.pexit\010qc.ppreg\tqc.ppregs\010qc.pputc\tqc.pputci\010qc.pputs\013q"
    "c.psyscall\014qc.psyscalli\014qc.selecteqi\014qc.selectieq\015qc.select"
    "ieqi\015qc.selectiieq\015qc.selectiine\014qc.selectine\015qc.selectinei"
    "\014qc.selectnei\nqc.setinti\010qc.setwm\tqc.setwmi\tqc.shladd\tqc.shls"
    "at\nqc.shlusat\006qc.srb\006qc.srh\006qc.srw\tqc.subsat\nqc.subusat\006"
    "qc.swm\007qc.swmi\007qc.sync\010qc.syncr\tqc.syncwf\tqc.syncwl\007qc.wr"
    "ap\010qc.wrapi\010qk.c.lbu\nqk.c.lbusp\010qk.c.lhu\nqk.c.lhusp\007qk.c."
    "sb\tqk.c.sbsp\007qk.c.sh\tqk.c.shsp\007rdcycle\010rdcycleh\trdinstret\n"
    "rdinstreth\006rdtime\007rdtimeh\003rem\004remu\005remuw\004remw\003ret\003"
    "rev\005rev16\004rev8\017ri.vextract.x.v\016ri.vinsert.v.x\016ri.vunzip2"
    "a.vv\016ri.vunzip2b.vv\nri.vzero.v\014ri.vzip2a.vv\014ri.vzip2b.vv\016r"
    "i.vzipeven.vv\015ri.vzipodd.vv\003rol\004rolw\003ror\004rori\005roriw\004"
    "rorw\002sb\007sb.aqrl\005sb.rl\004sc.d\007sc.d.aq\tsc.d.aqrl\007sc.d.rl"
    "\004sc.w\007sc.w.aq\tsc.w.aqrl\007sc.w.rl\007sctrclr\002sd\007sd.aqrl\005"
    "sd.rl\004seqz\006sext.b\006sext.h\006sext.w\020sf.cdiscard.d.l1\010sf.c"
    "ease\016sf.cflush.d.l1\017sf.mm.e4m3.e4m3\017sf.mm.e4m3.e5m2\017sf.mm.e"
    "5m2.e4m3\017sf.mm.e5m2.e5m2\tsf.mm.f.f\tsf.mm.s.s\tsf.mm.s.u\tsf.mm.u.s"
    "\tsf.mm.u.u\010sf.vc.fv\tsf.vc.fvv\tsf.vc.fvw\007sf.vc.i\010sf.vc.iv\ts"
    "f.vc.ivv\tsf.vc.ivw\nsf.vc.v.fv\013sf.vc.v.fvv\013sf.vc.v.fvw\tsf.vc.v."
    "i\nsf.vc.v.iv\013sf.vc.v.ivv\013sf.vc.v.ivw\nsf.vc.v.vv\013sf.vc.v.vvv\013"
    "sf.vc.v.vvw\tsf.vc.v.x\nsf.vc.v.xv\013sf.vc.v.xvv\013sf.vc.v.xvw\010sf."
    "vc.vv\tsf.vc.vvv\tsf.vc.vvw\007sf.vc.x\010sf.vc.xv\tsf.vc.xvv\tsf.vc.xv"
    "w\022sf.vfnrclip.x.f.qf\023sf.vfnrclip.xu.f.qf\020sf.vfwmacc.4x4x4\tsf."
    "vlte16\tsf.vlte32\tsf.vlte64\010sf.vlte8\017sf.vqmacc.2x8x2\017sf.vqmac"
    "c.4x8x4\021sf.vqmaccsu.2x8x2\021sf.vqmaccsu.4x8x4\020sf.vqmaccu.2x8x2\020"
    "sf.vqmaccu.4x8x4\021sf.vqmaccus.2x8x2\021sf.vqmaccus.4x8x4\tsf.vsettk\t"
    "sf.vsettm\tsf.vsettn\nsf.vsettnt\tsf.vste16\tsf.vste32\tsf.vste64\010sf"
    ".vste8\014sf.vtdiscard\013sf.vtmv.t.v\013sf.vtmv.v.t\013sf.vtzero.t\017"
    "sfence.inval.ir\nsfence.vma\016sfence.w.inval\003sgt\004sgtu\004sgtz\002"
    "sh\007sh.aqrl\005sh.rl\006sh1add\tsh1add.uw\006sh2add\tsh2add.uw\006sh3"
    "add\tsh3add.uw\nsha256sig0\nsha256sig1\nsha256sum0\nsha256sum1\nsha512s"
    "ig0\013sha512sig0h\013sha512sig0l\nsha512sig1\013sha512sig1h\013sha512s"
    "ig1l\nsha512sum0\013sha512sum0r\nsha512sum1\013sha512sum1r\nsinval.vma\003"
    "sll\004slli\007slli.uw\005slliw\004sllw\003slt\004slti\005sltiu\004sltu"
    "\004sltz\005sm3p0\005sm3p1\005sm4ed\005sm4ks\004snez\003sra\004srai\005"
    "sraiw\004sraw\004sret\003srl\004srli\005srliw\004srlw\013ssamoswap.d\016"
    "ssamoswap.d.aq\020ssamoswap.d.aqrl\016ssamoswap.d.rl\013ssamoswap.w\016"
    "ssamoswap.w.aq\020ssamoswap.w.aqrl\016ssamoswap.w.rl\005sslai\010sspopc"
    "hk\006sspush\005ssrdp\003sub\004subw\002sw\007sw.aqrl\005sw.rl\004tail\010"
    "th.addsl\016th.dcache.call\017th.dcache.ciall\016th.dcache.cipa\016th.d"
    "cache.cisw\016th.dcache.civa\015th.dcache.cpa\017th.dcache.cpal1\015th."
    "dcache.csw\015th.dcache.cva\017th.dcache.cval1\016th.dcache.iall\015th."
    "dcache.ipa\015th.dcache.isw\015th.dcache.iva\006th.ext\007th.extu\006th"
    ".ff0\006th.ff1\007th.flrd\007th.flrw\010th.flurd\010th.flurw\007th.fsrd"
    "\007th.fsrw\010th.fsurd\010th.fsurw\016th.icache.iall\017th.icache.iall"
    "s\015th.icache.ipa\015th.icache.iva\017th.l2cache.call\020th.l2cache.ci"
    "all\017th.l2cache.iall\007th.lbia\007th.lbib\010th.lbuia\010th.lbuib\006"
    "th.ldd\007th.ldia\007th.ldib\007th.lhia\007th.lhib\010th.lhuia\010th.lh"
    "uib\006th.lrb\007th.lrbu\006th.lrd\006th.lrh\007th.lrhu\006th.lrw\007th"
    ".lrwu\007th.lurb\010th.lurbu\007th.lurd\007th.lurh\010th.lurhu\007th.lu"
    "rw\010th.lurwu\006th.lwd\007th.lwia\007th.lwib\007th.lwud\010th.lwuia\010"
    "th.lwuib\007th.mula\010th.mulah\010th.mulaw\007th.muls\010th.mulsh\010t"
    "h.mulsw\010th.mveqz\010th.mvnez\006th.rev\007th.revw\007th.sbia\007th.s"
    "bib\006th.sdd\007th.sdia\007th.sdib\016th.sfence.vmas\007th.shia\007th."
    "shib\006th.srb\006th.srd\006th.srh\007th.srri\010th.srriw\006th.srw\007"
    "th.surb\007th.surd\007th.surh\007th.surw\006th.swd\007th.swia\007th.swi"
    "b\007th.sync\tth.sync.i\nth.sync.is\tth.sync.s\006th.tst\tth.tstnbz\013"
    "th.vmaqa.vv\013th.vmaqa.vx\015th.vmaqasu.vv\015th.vmaqasu.vx\014th.vmaq"
    "au.vv\014th.vmaqau.vx\015th.vmaqaus.vx\005unimp\005unzip\010vaadd.vv\010"
    "vaadd.vx\tvaaddu.vv\tvaaddu.vx\010vadc.vim\010vadc.vvm\010vadc.vxm\007v"
    "add.vi\007vadd.vv\007vadd.vx\tvaesdf.vs\tvaesdf.vv\tvaesdm.vs\tvaesdm.v"
    "v\tvaesef.vs\tvaesef.vv\tvaesem.vs\tvaesem.vv\nvaeskf1.vi\nvaeskf2.vi\010"
    "vaesz.vs\007vand.vi\007vand.vv\007vand.vx\010vandn.vv\010vandn.vx\010va"
    "sub.vv\010vasub.vx\tvasubu.vv\tvasubu.vx\007vbrev.v\010vbrev8.v\tvclmul"
    ".vv\tvclmul.vx\nvclmulh.vv\nvclmulh.vx\006vclz.v\014vcompress.vm\007vcp"
    "op.m\007vcpop.v\006vctz.v\007vdiv.vv\007vdiv.vx\010vdivu.vv\010vdivu.vx"
    "\007vfabs.v\010vfadd.vf\010vfadd.vv\tvfclass.v\013vfcvt.f.x.v\014vfcvt."
    "f.xu.v\017vfcvt.rtz.x.f.v\020vfcvt.rtz.xu.f.v\013vfcvt.x.f.v\014vfcvt.x"
    "u.f.v\010vfdiv.vf\010vfdiv.vv\010vfirst.m\tvfmacc.vf\tvfmacc.vv\tvfmadd"
    ".vf\tvfmadd.vv\010vfmax.vf\010vfmax.vv\013vfmerge.vfm\010vfmin.vf\010vf"
    "min.vv\tvfmsac.vf\tvfmsac.vv\tvfmsub.vf\tvfmsub.vv\010vfmul.vf\010vfmul"
    ".vv\010vfmv.f.s\010vfmv.s.f\010vfmv.v.f\014vfncvt.f.f.w\014vfncvt.f.x.w"
    "\015vfncvt.f.xu.w\020vfncvt.rod.f.f.w\020vfncvt.rtz.x.f.w\021vfncvt.rtz"
    ".xu.f.w\014vfncvt.x.f.w\015vfncvt.xu.f.w\020vfncvtbf16.f.f.w\007vfneg.v"
    "\nvfnmacc.vf\nvfnmacc.vv\nvfnmadd.vf\nvfnmadd.vv\nvfnmsac.vf\nvfnmsac.v"
    "v\nvfnmsub.vf\nvfnmsub.vv\tvfrdiv.vf\010vfrec7.v\013vfredmax.vs\013vfre"
    "dmin.vs\014vfredosum.vs\014vfredusum.vs\nvfrsqrt7.v\tvfrsub.vf\tvfsgnj."
    "vf\tvfsgnj.vv\nvfsgnjn.vf\nvfsgnjn.vv\nvfsgnjx.vf\nvfsgnjx.vv\017vfslid"
    "e1down.vf\015vfslide1up.vf\010vfsqrt.v\010vfsub.vf\010vfsub.vv\tvfwadd."
    "vf\tvfwadd.vv\tvfwadd.wf\tvfwadd.wv\014vfwcvt.f.f.v\014vfwcvt.f.x.v\015"
    "vfwcvt.f.xu.v\020vfwcvt.rtz.x.f.v\021vfwcvt.rtz.xu.f.v\014vfwcvt.x.f.v\015"
    "vfwcvt.xu.f.v\020vfwcvtbf16.f.f.v\nvfwmacc.vf\nvfwmacc.vv\016vfwmaccbf1"
    "6.vf\016vfwmaccbf16.vv\nvfwmsac.vf\nvfwmsac.vv\tvfwmul.vf\tvfwmul.vv\013"
    "vfwnmacc.vf\013vfwnmacc.vv\013vfwnmsac.vf\013vfwnmsac.vv\015vfwredosum."
    "vs\015vfwredusum.vs\tvfwsub.vf\tvfwsub.vv\tvfwsub.wf\tvfwsub.wv\010vghs"
    "h.vs\010vghsh.vv\010vgmul.vs\010vgmul.vv\005vid.v\007viota.m\006vl1r.v\t"
    "vl1re16.v\tvl1re32.v\tvl1re64.v\010vl1re8.v\006vl2r.v\tvl2re16.v\tvl2re"
    "32.v\tvl2re64.v\010vl2re8.v\006vl4r.v\tvl4re16.v\tvl4re32.v\tvl4re64.v\010"
    "vl4re8.v\006vl8r.v\tvl8re16.v\tvl8re32.v\tvl8re64.v\010vl8re8.v\007vle1"
    "6.v\tvle16ff.v\007vle32.v\tvle32ff.v\007vle64.v\tvle64ff.v\006vle8.v\010"
    "vle8ff.v\005vlm.v\nvloxei16.v\nvloxei32.v\nvloxei64.v\tvloxei8.v\016vlo"
    "xseg2ei16.v\016vloxseg2ei32.v\016vloxseg2ei64.v\015vloxseg2ei8.v\016vlo"
    "xseg3ei16.v\016vloxseg3ei32.v\016vloxseg3ei64.v\015vloxseg3ei8.v\016vlo"
    "xseg4ei16.v\016vloxseg4ei32.v\016vloxseg4ei64.v\015vloxseg4ei8.v\016vlo"
    "xseg5ei16.v\016vloxseg5ei32.v\016vloxseg5ei64.v\015vloxseg5ei8.v\016vlo"
    "xseg6ei16.v\016vloxseg6ei32.v\016vloxseg6ei64.v\015vloxseg6ei8.v\016vlo"
    "xseg7ei16.v\016vloxseg7ei32.v\016vloxseg7ei64.v\015vloxseg7ei8.v\016vlo"
    "xseg8ei16.v\016vloxseg8ei32.v\016vloxseg8ei64.v\015vloxseg8ei8.v\010vls"
    "e16.v\010vlse32.v\010vlse64.v\007vlse8.v\013vlseg2e16.v\015vlseg2e16ff."
    "v\013vlseg2e32.v\015vlseg2e32ff.v\013vlseg2e64.v\015vlseg2e64ff.v\nvlse"
    "g2e8.v\014vlseg2e8ff.v\013vlseg3e16.v\015vlseg3e16ff.v\013vlseg3e32.v\015"
    "vlseg3e32ff.v\013vlseg3e64.v\015vlseg3e64ff.v\nvlseg3e8.v\014vlseg3e8ff"
    ".v\013vlseg4e16.v\015vlseg4e16ff.v\013vlseg4e32.v\015vlseg4e32ff.v\013v"
    "lseg4e64.v\015vlseg4e64ff.v\nvlseg4e8.v\014vlseg4e8ff.v\013vlseg5e16.v\015"
    "vlseg5e16ff.v\013vlseg5e32.v\015vlseg5e32ff.v\013vlseg5e64.v\015vlseg5e"
    "64ff.v\nvlseg5e8.v\014vlseg5e8ff.v\013vlseg6e16.v\015vlseg6e16ff.v\013v"
    "lseg6e32.v\015vlseg6e32ff.v\013vlseg6e64.v\015vlseg6e64ff.v\nvlseg6e8.v"
    "\014vlseg6e8ff.v\013vlseg7e16.v\015vlseg7e16ff.v\013vlseg7e32.v\015vlse"
    "g7e32ff.v\013vlseg7e64.v\015vlseg7e64ff.v\nvlseg7e8.v\014vlseg7e8ff.v\013"
    "vlseg8e16.v\015vlseg8e16ff.v\013vlseg8e32.v\015vlseg8e32ff.v\013vlseg8e"
    "64.v\015vlseg8e64ff.v\nvlseg8e8.v\014vlseg8e8ff.v\014vlsseg2e16.v\014vl"
    "sseg2e32.v\014vlsseg2e64.v\013vlsseg2e8.v\014vlsseg3e16.v\014vlsseg3e32"
    ".v\014vlsseg3e64.v\013vlsseg3e8.v\014vlsseg4e16.v\014vlsseg4e32.v\014vl"
    "sseg4e64.v\013vlsseg4e8.v\014vlsseg5e16.v\014vlsseg5e32.v\014vlsseg5e64"
    ".v\013vlsseg5e8.v\014vlsseg6e16.v\014vlsseg6e32.v\014vlsseg6e64.v\013vl"
    "sseg6e8.v\014vlsseg7e16.v\014vlsseg7e32.v\014vlsseg7e64.v\013vlsseg7e8."
    "v\014vlsseg8e16.v\014vlsseg8e32.v\014vlsseg8e64.v\013vlsseg8e8.v\nvluxe"
    "i16.v\nvluxei32.v\nvluxei64.v\tvluxei8.v\016vluxseg2ei16.v\016vluxseg2e"
    "i32.v\016vluxseg2ei64.v\015vluxseg2ei8.v\016vluxseg3ei16.v\016vluxseg3e"
    "i32.v\016vluxseg3ei64.v\015vluxseg3ei8.v\016vluxseg4ei16.v\016vluxseg4e"
    "i32.v\016vluxseg4ei64.v\015vluxseg4ei8.v\016vluxseg5ei16.v\016vluxseg5e"
    "i32.v\016vluxseg5ei64.v\015vluxseg5ei8.v\016vluxseg6ei16.v\016vluxseg6e"
    "i32.v\016vluxseg6ei64.v\015vluxseg6ei8.v\016vluxseg7ei16.v\016vluxseg7e"
    "i32.v\016vluxseg7ei64.v\015vluxseg7ei8.v\016vluxseg8ei16.v\016vluxseg8e"
    "i32.v\016vluxseg8ei64.v\015vluxseg8ei8.v\010vmacc.vv\010vmacc.vx\010vma"
    "dc.vi\tvmadc.vim\010vmadc.vv\tvmadc.vvm\010vmadc.vx\tvmadc.vxm\010vmadd"
    ".vv\010vmadd.vx\010vmand.mm\tvmandn.mm\007vmax.vv\007vmax.vx\010vmaxu.v"
    "v\010vmaxu.vx\007vmclr.m\nvmerge.vim\nvmerge.vvm\nvmerge.vxm\010vmfeq.v"
    "f\010vmfeq.vv\010vmfge.vf\010vmfge.vv\010vmfgt.vf\010vmfgt.vv\010vmfle."
    "vf\010vmfle.vv\010vmflt.vf\010vmflt.vv\010vmfne.vf\010vmfne.vv\007vmin."
    "vv\007vmin.vx\010vminu.vv\010vminu.vx\006vmmv.m\tvmnand.mm\010vmnor.mm\007"
    "vmnot.m\007vmor.mm\010vmorn.mm\010vmsbc.vv\tvmsbc.vvm\010vmsbc.vx\tvmsb"
    "c.vxm\007vmsbf.m\010vmseq.vi\010vmseq.vv\010vmseq.vx\007vmset.m\010vmsg"
    "e.vi\010vmsge.vv\010vmsge.vx\tvmsgeu.vi\tvmsgeu.vv\tvmsgeu.vx\010vmsgt."
    "vi\010vmsgt.vv\010vmsgt.vx\tvmsgtu.vi\tvmsgtu.vv\tvmsgtu.vx\007vmsif.m\010"
    "vmsle.vi\010vmsle.vv\010vmsle.vx\tvmsleu.vi\tvmsleu.vv\tvmsleu.vx\010vm"
    "slt.vi\010vmslt.vv\010vmslt.vx\tvmsltu.vi\tvmsltu.vv\tvmsltu.vx\010vmsn"
    "e.vi\010vmsne.vv\010vmsne.vx\007vmsof.m\007vmul.vv\007vmul.vx\010vmulh."
    "vv\010vmulh.vx\nvmulhsu.vv\nvmulhsu.vx\tvmulhu.vv\tvmulhu.vx\007vmv.s.x"
    "\007vmv.v.i\007vmv.v.v\007vmv.v.x\007vmv.x.s\007vmv1r.v\007vmv2r.v\007v"
    "mv4r.v\007vmv8r.v\tvmxnor.mm\010vmxor.mm\tvnclip.wi\tvnclip.wv\tvnclip."
    "wx\nvnclipu.wi\nvnclipu.wv\nvnclipu.wx\013vncvt.x.x.w\006vneg.v\tvnmsac"
    ".vv\tvnmsac.vx\tvnmsub.vv\tvnmsub.vx\006vnot.v\010vnsra.wi\010vnsra.wv\010"
    "vnsra.wx\010vnsrl.wi\010vnsrl.wv\010vnsrl.wx\006vor.vi\006vor.vv\006vor"
    ".vx\010vqdot.vv\010vqdot.vx\nvqdotsu.vv\nvqdotsu.vx\tvqdotu.vv\tvqdotu."
    "vx\nvqdotus.vx\nvredand.vs\nvredmax.vs\013vredmaxu.vs\nvredmin.vs\013vr"
    "edminu.vs\tvredor.vs\nvredsum.vs\nvredxor.vs\007vrem.vv\007vrem.vx\010v"
    "remu.vv\010vremu.vx\007vrev8.v\013vrgather.vi\013vrgather.vv\013vrgathe"
    "r.vx\017vrgatherei16.vv\007vrol.vv\007vrol.vx\007vror.vi\007vror.vv\007"
    "vror.vx\010vrsub.vi\010vrsub.vx\006vs1r.v\006vs2r.v\006vs4r.v\006vs8r.v"
    "\010vsadd.vi\010vsadd.vv\010vsadd.vx\tvsaddu.vi\tvsaddu.vv\tvsaddu.vx\010"
    "vsbc.vvm\010vsbc.vxm\007vse16.v\007vse32.v\007vse64.v\006vse8.v\010vset"
    "ivli\006vsetvl\007vsetvli\tvsext.vf2\tvsext.vf4\tvsext.vf8\nvsha2ch.vv\n"
    "vsha2cl.vv\nvsha2ms.vv\016vslide1down.vx\014vslide1up.vx\015vslidedown."
    "vi\015vslidedown.vx\013vslideup.vi\013vslideup.vx\007vsll.vi\007vsll.vv"
    "\007vsll.vx\005vsm.v\010vsm3c.vi\tvsm3me.vv\010vsm4k.vi\010vsm4r.vs\010"
    "vsm4r.vv\010vsmul.vv\010vsmul.vx\nvsoxei16.v\nvsoxei32.v\nvsoxei64.v\tv"
    "soxei8.v\016vsoxseg2ei16.v\016vsoxseg2ei32.v\016vsoxseg2ei64.v\015vsoxs"
    "eg2ei8.v\016vsoxseg3ei16.v\016vsoxseg3ei32.v\016vsoxseg3ei64.v\015vsoxs"
    "eg3ei8.v\016vsoxseg4ei16.v\016vsoxseg4ei32.v\016vsoxseg4ei64.v\015vsoxs"
    "eg4ei8.v\016vsoxseg5ei16.v\016vsoxseg5ei32.v\016vsoxseg5ei64.v\015vsoxs"
    "eg5ei8.v\016vsoxseg6ei16.v\016vsoxseg6ei32.v\016vsoxseg6ei64.v\015vsoxs"
    "eg6ei8.v\016vsoxseg7ei16.v\016vsoxseg7ei32.v\016vsoxseg7ei64.v\015vsoxs"
    "eg7ei8.v\016vsoxseg8ei16.v\016vsoxseg8ei32.v\016vsoxseg8ei64.v\015vsoxs"
    "eg8ei8.v\007vsra.vi\007vsra.vv\007vsra.vx\007vsrl.vi\007vsrl.vv\007vsrl"
    ".vx\010vsse16.v\010vsse32.v\010vsse64.v\007vsse8.v\013vsseg2e16.v\013vs"
    "seg2e32.v\013vsseg2e64.v\nvsseg2e8.v\013vsseg3e16.v\013vsseg3e32.v\013v"
    "sseg3e64.v\nvsseg3e8.v\013vsseg4e16.v\013vsseg4e32.v\013vsseg4e64.v\nvs"
    "seg4e8.v\013vsseg5e16.v\013vsseg5e32.v\013vsseg5e64.v\nvsseg5e8.v\013vs"
    "seg6e16.v\013vsseg6e32.v\013vsseg6e64.v\nvsseg6e8.v\013vsseg7e16.v\013v"
    "sseg7e32.v\013vsseg7e64.v\nvsseg7e8.v\013vsseg8e16.v\013vsseg8e32.v\013"
    "vsseg8e64.v\nvsseg8e8.v\010vssra.vi\010vssra.vv\010vssra.vx\010vssrl.vi"
    "\010vssrl.vv\010vssrl.vx\014vssseg2e16.v\014vssseg2e32.v\014vssseg2e64."
    "v\013vssseg2e8.v\014vssseg3e16.v\014vssseg3e32.v\014vssseg3e64.v\013vss"
    "seg3e8.v\014vssseg4e16.v\014vssseg4e32.v\014vssseg4e64.v\013vssseg4e8.v"
    "\014vssseg5e16.v\014vssseg5e32.v\014vssseg5e64.v\013vssseg5e8.v\014vsss"
    "eg6e16.v\014vssseg6e32.v\014vssseg6e64.v\013vssseg6e8.v\014vssseg7e16.v"
    "\014vssseg7e32.v\014vssseg7e64.v\013vssseg7e8.v\014vssseg8e16.v\014vsss"
    "eg8e32.v\014vssseg8e64.v\013vssseg8e8.v\010vssub.vv\010vssub.vx\tvssubu"
    ".vv\tvssubu.vx\007vsub.vv\007vsub.vx\nvsuxei16.v\nvsuxei32.v\nvsuxei64."
    "v\tvsuxei8.v\016vsuxseg2ei16.v\016vsuxseg2ei32.v\016vsuxseg2ei64.v\015v"
    "suxseg2ei8.v\016vsuxseg3ei16.v\016vsuxseg3ei32.v\016vsuxseg3ei64.v\015v"
    "suxseg3ei8.v\016vsuxseg4ei16.v\016vsuxseg4ei32.v\016vsuxseg4ei64.v\015v"
    "suxseg4ei8.v\016vsuxseg5ei16.v\016vsuxseg5ei32.v\016vsuxseg5ei64.v\015v"
    "suxseg5ei8.v\016vsuxseg6ei16.v\016vsuxseg6ei32.v\016vsuxseg6ei64.v\015v"
    "suxseg6ei8.v\016vsuxseg7ei16.v\016vsuxseg7ei32.v\016vsuxseg7ei64.v\015v"
    "suxseg7ei8.v\016vsuxseg8ei16.v\016vsuxseg8ei32.v\016vsuxseg8ei64.v\015v"
    "suxseg8ei8.v\010vt.maskc\tvt.maskcn\010vwadd.vv\010vwadd.vx\010vwadd.wv"
    "\010vwadd.wx\tvwaddu.vv\tvwaddu.vx\tvwaddu.wv\tvwaddu.wx\013vwcvt.x.x.v"
    "\014vwcvtu.x.x.v\tvwmacc.vv\tvwmacc.vx\013vwmaccsu.vv\013vwmaccsu.vx\nv"
    "wmaccu.vv\nvwmaccu.vx\013vwmaccus.vx\010vwmul.vv\010vwmul.vx\nvwmulsu.v"
    "v\nvwmulsu.vx\tvwmulu.vv\tvwmulu.vx\013vwredsum.vs\014vwredsumu.vs\010v"
    "wsll.vi\010vwsll.vv\010vwsll.vx\010vwsub.vv\010vwsub.vx\010vwsub.wv\010"
    "vwsub.wx\tvwsubu.vv\tvwsubu.vx\tvwsubu.wv\tvwsubu.wx\007vxor.vi\007vxor"
    ".vv\007vxor.vx\tvzext.vf2\tvzext.vf4\tvzext.vf8\003wfi\007wrs.nto\007wr"
    "s.sto\004xnor\003xor\004xori\006xperm4\006xperm8\006zext.b\006zext.h\006"
    "zext.w\003zip";

// Feature bitsets.
enum : uint8_t {
  AMFBS_None,
  AMFBS_HasHalfFPLoadStoreMove,
  AMFBS_HasStdExtD,
  AMFBS_HasStdExtF,
  AMFBS_HasStdExtFOrZfinx,
  AMFBS_HasStdExtH,
  AMFBS_HasStdExtM,
  AMFBS_HasStdExtP,
  AMFBS_HasStdExtQ,
  AMFBS_HasStdExtSmctrOrSsctr,
  AMFBS_HasStdExtSmrnmi,
  AMFBS_HasStdExtSvinval,
  AMFBS_HasStdExtZaamo,
  AMFBS_HasStdExtZabha,
  AMFBS_HasStdExtZacas,
  AMFBS_HasStdExtZalasr,
  AMFBS_HasStdExtZalrsc,
  AMFBS_HasStdExtZawrs,
  AMFBS_HasStdExtZba,
  AMFBS_HasStdExtZbaOrP,
  AMFBS_HasStdExtZbb,
  AMFBS_HasStdExtZbbOrP,
  AMFBS_HasStdExtZbbOrZbkb,
  AMFBS_HasStdExtZbc,
  AMFBS_HasStdExtZbcOrZbkc,
  AMFBS_HasStdExtZbkb,
  AMFBS_HasStdExtZbkbOrP,
  AMFBS_HasStdExtZbkx,
  AMFBS_HasStdExtZbs,
  AMFBS_HasStdExtZca,
  AMFBS_HasStdExtZcb,
  AMFBS_HasStdExtZcmop,
  AMFBS_HasStdExtZcmp,
  AMFBS_HasStdExtZcmt,
  AMFBS_HasStdExtZfa,
  AMFBS_HasStdExtZfbfmin,
  AMFBS_HasStdExtZfh,
  AMFBS_HasStdExtZfhmin,
  AMFBS_HasStdExtZfinx,
  AMFBS_HasStdExtZhinx,
  AMFBS_HasStdExtZhinxmin,
  AMFBS_HasStdExtZicbom,
  AMFBS_HasStdExtZicbop,
  AMFBS_HasStdExtZicboz,
  AMFBS_HasStdExtZicfilp,
  AMFBS_HasStdExtZicfiss,
  AMFBS_HasStdExtZicond,
  AMFBS_HasStdExtZihintntl,
  AMFBS_HasStdExtZihintpause,
  AMFBS_HasStdExtZimop,
  AMFBS_HasStdExtZknh,
  AMFBS_HasStdExtZksed,
  AMFBS_HasStdExtZksh,
  AMFBS_HasStdExtZmmul,
  AMFBS_HasStdExtZvbb,
  AMFBS_HasStdExtZvbcOrZvbc32e,
  AMFBS_HasStdExtZvfbfmin,
  AMFBS_HasStdExtZvfbfwma,
  AMFBS_HasStdExtZvkb,
  AMFBS_HasStdExtZvkg,
  AMFBS_HasStdExtZvkgs,
  AMFBS_HasStdExtZvkned,
  AMFBS_HasStdExtZvknhaOrZvknhb,
  AMFBS_HasStdExtZvksed,
  AMFBS_HasStdExtZvksh,
  AMFBS_HasStdExtZvqdotq,
  AMFBS_HasVInstructions,
  AMFBS_HasVInstructionsAnyF,
  AMFBS_HasVInstructionsI64,
  AMFBS_HasVendorXAndesBFHCvt,
  AMFBS_HasVendorXAndesPerf,
  AMFBS_HasVendorXAndesVBFHCvt,
  AMFBS_HasVendorXAndesVDot,
  AMFBS_HasVendorXAndesVPackFPH,
  AMFBS_HasVendorXAndesVSIntLoad,
  AMFBS_HasVendorXMIPSCBOP,
  AMFBS_HasVendorXMIPSCMov,
  AMFBS_HasVendorXMIPSLSP,
  AMFBS_HasVendorXRivosVisni,
  AMFBS_HasVendorXRivosVizip,
  AMFBS_HasVendorXSfcease,
  AMFBS_HasVendorXSfmm32a16fOrXSfmm32a32fOrXSfmm64a64f,
  AMFBS_HasVendorXSfmm32a8f,
  AMFBS_HasVendorXSfmm32a8i,
  AMFBS_HasVendorXSfmmbase,
  AMFBS_HasVendorXSfvcp,
  AMFBS_HasVendorXSfvfnrclipxfqf,
  AMFBS_HasVendorXSfvfwmaccqqq,
  AMFBS_HasVendorXSfvqmaccdod,
  AMFBS_HasVendorXSfvqmaccqoq,
  AMFBS_HasVendorXSiFivecdiscarddlone,
  AMFBS_HasVendorXSiFivecflushdlone,
  AMFBS_HasVendorXTHeadBa,
  AMFBS_HasVendorXTHeadBb,
  AMFBS_HasVendorXTHeadBs,
  AMFBS_HasVendorXTHeadCmo,
  AMFBS_HasVendorXTHeadCondMov,
  AMFBS_HasVendorXTHeadMac,
  AMFBS_HasVendorXTHeadMemIdx,
  AMFBS_HasVendorXTHeadMemPair,
  AMFBS_HasVendorXTHeadSync,
  AMFBS_HasVendorXTHeadVdot,
  AMFBS_HasVendorXVentanaCondOps,
  AMFBS_HasVendorXqccmp,
  AMFBS_HasVendorXwchc,
  AMFBS_IsRV32,
  AMFBS_IsRV64,
  AMFBS_HasStdExtC_HasStdExtZihintntl,
  AMFBS_HasStdExtCOrZcd_HasStdExtD,
  AMFBS_HasStdExtD_IsRV64,
  AMFBS_HasStdExtF_IsRV64,
  AMFBS_HasStdExtM_IsRV64,
  AMFBS_HasStdExtP_IsRV32,
  AMFBS_HasStdExtP_IsRV64,
  AMFBS_HasStdExtQ_IsRV64,
  AMFBS_HasStdExtZaamo_IsRV64,
  AMFBS_HasStdExtZabha_HasStdExtZacas,
  AMFBS_HasStdExtZacas_IsRV32,
  AMFBS_HasStdExtZacas_IsRV64,
  AMFBS_HasStdExtZalasr_IsRV64,
  AMFBS_HasStdExtZalrsc_IsRV64,
  AMFBS_HasStdExtZba_IsRV64,
  AMFBS_HasStdExtZbb_IsRV32,
  AMFBS_HasStdExtZbb_IsRV64,
  AMFBS_HasStdExtZbbOrP_IsRV64,
  AMFBS_HasStdExtZbbOrZbkb_IsRV64,
  AMFBS_HasStdExtZbbOrZbkbOrP_IsRV32,
  AMFBS_HasStdExtZbbOrZbkbOrP_IsRV64,
  AMFBS_HasStdExtZbkb_IsRV32,
  AMFBS_HasStdExtZbkb_IsRV64,
  AMFBS_HasStdExtZca_IsRV32,
  AMFBS_HasStdExtZca_IsRV64,
  AMFBS_HasStdExtZcb_HasStdExtZbb,
  AMFBS_HasStdExtZcb_HasStdExtZmmul,
  AMFBS_HasStdExtZclsd_IsRV32,
  AMFBS_HasStdExtZdinx_IsRV32,
  AMFBS_HasStdExtZdinx_IsRV64,
  AMFBS_HasStdExtZfa_HasStdExtD,
  AMFBS_HasStdExtZfa_HasStdExtQ,
  AMFBS_HasStdExtZfa_HasStdExtZfh,
  AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh,
  AMFBS_HasStdExtZfh_IsRV64,
  AMFBS_HasStdExtZfhmin_HasStdExtD,
  AMFBS_HasStdExtZfinx_IsRV64,
  AMFBS_HasStdExtZhinx_IsRV64,
  AMFBS_HasStdExtZicfiss_HasStdExtZcmop,
  AMFBS_HasStdExtZicfiss_IsRV64,
  AMFBS_HasStdExtZilsd_IsRV32,
  AMFBS_HasStdExtZknd_IsRV32,
  AMFBS_HasStdExtZknd_IsRV64,
  AMFBS_HasStdExtZkndOrZkne_IsRV64,
  AMFBS_HasStdExtZkne_IsRV32,
  AMFBS_HasStdExtZkne_IsRV64,
  AMFBS_HasStdExtZknh_IsRV32,
  AMFBS_HasStdExtZknh_IsRV64,
  AMFBS_HasStdExtZmmul_IsRV64,
  AMFBS_HasVInstructionsI64_IsRV64,
  AMFBS_HasVendorXAndesPerf_IsRV64,
  AMFBS_HasVendorXCValu_IsRV32,
  AMFBS_HasVendorXCVbi_IsRV32,
  AMFBS_HasVendorXCVbitmanip_IsRV32,
  AMFBS_HasVendorXCVelw_IsRV32,
  AMFBS_HasVendorXCVmac_IsRV32,
  AMFBS_HasVendorXCVmem_IsRV32,
  AMFBS_HasVendorXCVsimd_IsRV32,
  AMFBS_HasVendorXTHeadBb_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF,
  AMFBS_HasVendorXTHeadMac_IsRV64,
  AMFBS_HasVendorXTHeadMemIdx_IsRV64,
  AMFBS_HasVendorXTHeadMemPair_IsRV64,
  AMFBS_HasVendorXqcia_IsRV32,
  AMFBS_HasVendorXqciac_IsRV32,
  AMFBS_HasVendorXqcibi_IsRV32,
  AMFBS_HasVendorXqcibm_IsRV32,
  AMFBS_HasVendorXqcicli_IsRV32,
  AMFBS_HasVendorXqcicm_IsRV32,
  AMFBS_HasVendorXqcics_IsRV32,
  AMFBS_HasVendorXqcicsr_IsRV32,
  AMFBS_HasVendorXqciint_IsRV32,
  AMFBS_HasVendorXqciio_IsRV32,
  AMFBS_HasVendorXqcilb_IsRV32,
  AMFBS_HasVendorXqcili_IsRV32,
  AMFBS_HasVendorXqcilia_IsRV32,
  AMFBS_HasVendorXqcilo_IsRV32,
  AMFBS_HasVendorXqcilsm_IsRV32,
  AMFBS_HasVendorXqcisim_IsRV32,
  AMFBS_HasVendorXqcisls_IsRV32,
  AMFBS_HasVendorXqcisync_IsRV32,
  AMFBS_IsRV64_HasStdExtH,
  AMFBS_IsRV64_HasVInstructionsI64,
  AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32,
  AMFBS_HasStdExtZbkb_NoStdExtZbb_IsRV32,
  AMFBS_HasStdExtZbkb_NoStdExtZbb_IsRV64,
  AMFBS_HasStdExtZcb_HasStdExtZba_IsRV64,
  AMFBS_HasStdExtZdinx_IsRV64_IsRV64,
  AMFBS_HasStdExtZfa_HasStdExtD_IsRV32,
  AMFBS_HasStdExtZfa_HasStdExtQ_IsRV64,
  AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32,
  AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64,
};

static constexpr FeatureBitset FeatureBitsets[] = {
  {}, // AMFBS_None
  {Feature_HasHalfFPLoadStoreMoveBit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtFOrZfinxBit, },
  {Feature_HasStdExtHBit, },
  {Feature_HasStdExtMBit, },
  {Feature_HasStdExtPBit, },
  {Feature_HasStdExtQBit, },
  {Feature_HasStdExtSmctrOrSsctrBit, },
  {Feature_HasStdExtSmrnmiBit, },
  {Feature_HasStdExtSvinvalBit, },
  {Feature_HasStdExtZaamoBit, },
  {Feature_HasStdExtZabhaBit, },
  {Feature_HasStdExtZacasBit, },
  {Feature_HasStdExtZalasrBit, },
  {Feature_HasStdExtZalrscBit, },
  {Feature_HasStdExtZawrsBit, },
  {Feature_HasStdExtZbaBit, },
  {Feature_HasStdExtZbaOrPBit, },
  {Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZbbOrPBit, },
  {Feature_HasStdExtZbbOrZbkbBit, },
  {Feature_HasStdExtZbcBit, },
  {Feature_HasStdExtZbcOrZbkcBit, },
  {Feature_HasStdExtZbkbBit, },
  {Feature_HasStdExtZbkbOrPBit, },
  {Feature_HasStdExtZbkxBit, },
  {Feature_HasStdExtZbsBit, },
  {Feature_HasStdExtZcaBit, },
  {Feature_HasStdExtZcbBit, },
  {Feature_HasStdExtZcmopBit, },
  {Feature_HasStdExtZcmpBit, },
  {Feature_HasStdExtZcmtBit, },
  {Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtZfbfminBit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhminBit, },
  {Feature_HasStdExtZfinxBit, },
  {Feature_HasStdExtZhinxBit, },
  {Feature_HasStdExtZhinxminBit, },
  {Feature_HasStdExtZicbomBit, },
  {Feature_HasStdExtZicbopBit, },
  {Feature_HasStdExtZicbozBit, },
  {Feature_HasStdExtZicfilpBit, },
  {Feature_HasStdExtZicfissBit, },
  {Feature_HasStdExtZicondBit, },
  {Feature_HasStdExtZihintntlBit, },
  {Feature_HasStdExtZihintpauseBit, },
  {Feature_HasStdExtZimopBit, },
  {Feature_HasStdExtZknhBit, },
  {Feature_HasStdExtZksedBit, },
  {Feature_HasStdExtZkshBit, },
  {Feature_HasStdExtZmmulBit, },
  {Feature_HasStdExtZvbbBit, },
  {Feature_HasStdExtZvbcOrZvbc32eBit, },
  {Feature_HasStdExtZvfbfminBit, },
  {Feature_HasStdExtZvfbfwmaBit, },
  {Feature_HasStdExtZvkbBit, },
  {Feature_HasStdExtZvkgBit, },
  {Feature_HasStdExtZvkgsBit, },
  {Feature_HasStdExtZvknedBit, },
  {Feature_HasStdExtZvknhaOrZvknhbBit, },
  {Feature_HasStdExtZvksedBit, },
  {Feature_HasStdExtZvkshBit, },
  {Feature_HasStdExtZvqdotqBit, },
  {Feature_HasVInstructionsBit, },
  {Feature_HasVInstructionsAnyFBit, },
  {Feature_HasVInstructionsI64Bit, },
  {Feature_HasVendorXAndesBFHCvtBit, },
  {Feature_HasVendorXAndesPerfBit, },
  {Feature_HasVendorXAndesVBFHCvtBit, },
  {Feature_HasVendorXAndesVDotBit, },
  {Feature_HasVendorXAndesVPackFPHBit, },
  {Feature_HasVendorXAndesVSIntLoadBit, },
  {Feature_HasVendorXMIPSCBOPBit, },
  {Feature_HasVendorXMIPSCMovBit, },
  {Feature_HasVendorXMIPSLSPBit, },
  {Feature_HasVendorXRivosVisniBit, },
  {Feature_HasVendorXRivosVizipBit, },
  {Feature_HasVendorXSfceaseBit, },
  {Feature_HasVendorXSfmm32a16fOrXSfmm32a32fOrXSfmm64a64fBit, },
  {Feature_HasVendorXSfmm32a8fBit, },
  {Feature_HasVendorXSfmm32a8iBit, },
  {Feature_HasVendorXSfmmbaseBit, },
  {Feature_HasVendorXSfvcpBit, },
  {Feature_HasVendorXSfvfnrclipxfqfBit, },
  {Feature_HasVendorXSfvfwmaccqqqBit, },
  {Feature_HasVendorXSfvqmaccdodBit, },
  {Feature_HasVendorXSfvqmaccqoqBit, },
  {Feature_HasVendorXSiFivecdiscarddloneBit, },
  {Feature_HasVendorXSiFivecflushdloneBit, },
  {Feature_HasVendorXTHeadBaBit, },
  {Feature_HasVendorXTHeadBbBit, },
  {Feature_HasVendorXTHeadBsBit, },
  {Feature_HasVendorXTHeadCmoBit, },
  {Feature_HasVendorXTHeadCondMovBit, },
  {Feature_HasVendorXTHeadMacBit, },
  {Feature_HasVendorXTHeadMemIdxBit, },
  {Feature_HasVendorXTHeadMemPairBit, },
  {Feature_HasVendorXTHeadSyncBit, },
  {Feature_HasVendorXTHeadVdotBit, },
  {Feature_HasVendorXVentanaCondOpsBit, },
  {Feature_HasVendorXqccmpBit, },
  {Feature_HasVendorXwchcBit, },
  {Feature_IsRV32Bit, },
  {Feature_IsRV64Bit, },
  {Feature_HasStdExtCBit, Feature_HasStdExtZihintntlBit, },
  {Feature_HasStdExtCOrZcdBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtPBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtPBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtQBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZaamoBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZalasrBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZalrscBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrPBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrZbkbOrPBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbOrZbkbOrPBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZcaBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZcaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtZmmulBit, },
  {Feature_HasStdExtZclsdBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtQBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhOrZvfhBit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZicfissBit, Feature_HasStdExtZcmopBit, },
  {Feature_HasStdExtZicfissBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZilsdBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZmmulBit, Feature_IsRV64Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_IsRV64Bit, },
  {Feature_HasVendorXAndesPerfBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXCValuBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVbiBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVelwBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVmacBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVmemBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVsimdBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtDBit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtFBit, },
  {Feature_HasVendorXTHeadMacBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadMemIdxBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadMemPairBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXqciaBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqciacBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcibiBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcibmBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcicliBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcicmBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcicsBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcicsrBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqciintBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqciioBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcilbBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqciliBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqciliaBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqciloBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcilsmBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcisimBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcislsBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcisyncBit, Feature_IsRV32Bit, },
  {Feature_IsRV64Bit, Feature_HasStdExtHBit, },
  {Feature_IsRV64Bit, Feature_HasVInstructionsI64Bit, },
  {Feature_HasStdExtCOrZcfOrZceBit, Feature_HasStdExtFBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbkbBit, Feature_NoStdExtZbbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbkbBit, Feature_NoStdExtZbbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtDBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtQBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtFBit, Feature_IsRV64Bit, },
};

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint8_t RequiredFeaturesIdx;
    uint8_t Classes[8];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const MatchEntry MatchTable0[] = {
  { 0 /* .insn_b */, RISCV::InsnB, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__BareSImm13Lsb01_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_BareSImm13Lsb0 }, },
  { 8 /* .insn_ca */, RISCV::InsnCA, Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4, AMFBS_HasStdExtZca, { MCK_InsnCDirectiveOpcode, MCK_UImm6, MCK_UImm2, MCK_AnyRegCOperand, MCK_AnyRegCOperand }, },
  { 17 /* .insn_cb */, RISCV::InsnCB, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__BareSImm9Lsb01_3, AMFBS_HasStdExtZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_BareSImm9Lsb0 }, },
  { 26 /* .insn_ci */, RISCV::InsnCI, Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3, AMFBS_HasStdExtZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_SImm6 }, },
  { 35 /* .insn_ciw */, RISCV::InsnCIW, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3, AMFBS_HasStdExtZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm8 }, },
  { 45 /* .insn_cj */, RISCV::InsnCJ, Convert__InsnCDirectiveOpcode1_0__UImm31_1__BareSImm12Lsb01_2, AMFBS_HasStdExtZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_BareSImm12Lsb0 }, },
  { 54 /* .insn_cl */, RISCV::InsnCL, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_4__imm_95_0, AMFBS_HasStdExtZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 54 /* .insn_cl */, RISCV::InsnCL, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3, AMFBS_HasStdExtZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm5, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 63 /* .insn_cr */, RISCV::InsnCR, Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3, AMFBS_HasStdExtZca, { MCK_InsnCDirectiveOpcode, MCK_UImm4, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 72 /* .insn_cs */, RISCV::InsnCS, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_4__imm_95_0, AMFBS_HasStdExtZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 72 /* .insn_cs */, RISCV::InsnCS, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3, AMFBS_HasStdExtZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm5, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 81 /* .insn_css */, RISCV::InsnCSS, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3, AMFBS_HasStdExtZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_UImm6 }, },
  { 91 /* .insn_i */, RISCV::InsnI, Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_SImm12 }, },
  { 91 /* .insn_i */, RISCV::InsnI_Mem, Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_4__imm_95_0, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 91 /* .insn_i */, RISCV::InsnI_Mem, Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_SImm12, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 99 /* .insn_j */, RISCV::InsnJ, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__BareSImm21Lsb01_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_BareSImm21Lsb0 }, },
  { 107 /* .insn_qc.eai */, RISCV::InsnQC_EAI, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm11_2__BareSImm321_4, AMFBS_IsRV32, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm1, MCK_AnyRegOperand, MCK_BareSImm32 }, },
  { 120 /* .insn_qc.eb */, RISCV::InsnQC_EB, Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm51_2__AnyRegOperand1_3__SImm161_4__BareSImm13Lsb01_5, AMFBS_IsRV32, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm5, MCK_AnyRegOperand, MCK_SImm16, MCK_BareSImm13Lsb0 }, },
  { 132 /* .insn_qc.ei */, RISCV::InsnQC_EI, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__SImm261_5, AMFBS_IsRV32, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_SImm26 }, },
  { 132 /* .insn_qc.ei */, RISCV::InsnQC_EI_Mem, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_5__imm_95_0, AMFBS_IsRV32, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 132 /* .insn_qc.ei */, RISCV::InsnQC_EI_Mem, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_6__SImm261_4, AMFBS_IsRV32, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK_SImm26, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 144 /* .insn_qc.ej */, RISCV::InsnQC_EJ, Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__UImm51_3__BareSImm32Lsb01_4, AMFBS_IsRV32, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_UImm5, MCK_BareSImm32Lsb0 }, },
  { 156 /* .insn_qc.es */, RISCV::InsnQC_ES, Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_3__AnyRegOperand1_5__imm_95_0, AMFBS_IsRV32, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 156 /* .insn_qc.es */, RISCV::InsnQC_ES, Convert__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_3__AnyRegOperand1_6__SImm261_4, AMFBS_IsRV32, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK_SImm26, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 168 /* .insn_r */, RISCV::InsnR, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm7, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 168 /* .insn_r */, RISCV::InsnR4, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 176 /* .insn_r4 */, RISCV::InsnR4, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 185 /* .insn_s */, RISCV::InsnS, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_4__imm_95_0, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 185 /* .insn_s */, RISCV::InsnS, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_SImm12, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 193 /* .insn_sb */, RISCV::InsnB, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__BareSImm13Lsb01_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_BareSImm13Lsb0 }, },
  { 202 /* .insn_u */, RISCV::InsnU, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_UImm20LUI }, },
  { 210 /* .insn_uj */, RISCV::InsnJ, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__BareSImm21Lsb01_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_BareSImm21Lsb0 }, },
  { 219 /* abs */, RISCV::ABS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP, { MCK_GPR, MCK_GPR }, },
  { 223 /* absw */, RISCV::ABSW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 228 /* add */, RISCV::ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 228 /* add */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 228 /* add */, RISCV::PseudoAddTPRel, Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_TPRelAddSymbol }, },
  { 232 /* add.uw */, RISCV::ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 239 /* addi */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 244 /* addiw */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 250 /* addw */, RISCV::ADDW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 250 /* addw */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 255 /* aes32dsi */, RISCV::AES32DSI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZknd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 264 /* aes32dsmi */, RISCV::AES32DSMI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZknd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 274 /* aes32esi */, RISCV::AES32ESI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZkne_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 283 /* aes32esmi */, RISCV::AES32ESMI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZkne_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 293 /* aes64ds */, RISCV::AES64DS, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 301 /* aes64dsm */, RISCV::AES64DSM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 310 /* aes64es */, RISCV::AES64ES, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 318 /* aes64esm */, RISCV::AES64ESM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 327 /* aes64im */, RISCV::AES64IM, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 335 /* aes64ks1i */, RISCV::AES64KS1I, Convert__Reg1_0__Reg1_1__RnumArg1_2, AMFBS_HasStdExtZkndOrZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_RnumArg }, },
  { 345 /* aes64ks2 */, RISCV::AES64KS2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkndOrZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 354 /* amoadd.b */, RISCV::AMOADD_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 363 /* amoadd.b.aq */, RISCV::AMOADD_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 375 /* amoadd.b.aqrl */, RISCV::AMOADD_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 389 /* amoadd.b.rl */, RISCV::AMOADD_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 401 /* amoadd.d */, RISCV::AMOADD_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 410 /* amoadd.d.aq */, RISCV::AMOADD_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 422 /* amoadd.d.aqrl */, RISCV::AMOADD_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 436 /* amoadd.d.rl */, RISCV::AMOADD_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 448 /* amoadd.h */, RISCV::AMOADD_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 457 /* amoadd.h.aq */, RISCV::AMOADD_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 469 /* amoadd.h.aqrl */, RISCV::AMOADD_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 483 /* amoadd.h.rl */, RISCV::AMOADD_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 495 /* amoadd.w */, RISCV::AMOADD_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 504 /* amoadd.w.aq */, RISCV::AMOADD_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 516 /* amoadd.w.aqrl */, RISCV::AMOADD_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 530 /* amoadd.w.rl */, RISCV::AMOADD_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 542 /* amoand.b */, RISCV::AMOAND_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 551 /* amoand.b.aq */, RISCV::AMOAND_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 563 /* amoand.b.aqrl */, RISCV::AMOAND_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 577 /* amoand.b.rl */, RISCV::AMOAND_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 589 /* amoand.d */, RISCV::AMOAND_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 598 /* amoand.d.aq */, RISCV::AMOAND_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 610 /* amoand.d.aqrl */, RISCV::AMOAND_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 624 /* amoand.d.rl */, RISCV::AMOAND_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 636 /* amoand.h */, RISCV::AMOAND_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 645 /* amoand.h.aq */, RISCV::AMOAND_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 657 /* amoand.h.aqrl */, RISCV::AMOAND_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 671 /* amoand.h.rl */, RISCV::AMOAND_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 683 /* amoand.w */, RISCV::AMOAND_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 692 /* amoand.w.aq */, RISCV::AMOAND_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 704 /* amoand.w.aqrl */, RISCV::AMOAND_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 718 /* amoand.w.rl */, RISCV::AMOAND_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 730 /* amocas.b */, RISCV::AMOCAS_B, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 739 /* amocas.b.aq */, RISCV::AMOCAS_B_AQ, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 751 /* amocas.b.aqrl */, RISCV::AMOCAS_B_AQ_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 765 /* amocas.b.rl */, RISCV::AMOCAS_B_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 777 /* amocas.d */, RISCV::AMOCAS_D_RV64, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 777 /* amocas.d */, RISCV::AMOCAS_D_RV32, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 786 /* amocas.d.aq */, RISCV::AMOCAS_D_RV64_AQ, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 786 /* amocas.d.aq */, RISCV::AMOCAS_D_RV32_AQ, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 798 /* amocas.d.aqrl */, RISCV::AMOCAS_D_RV64_AQ_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 798 /* amocas.d.aqrl */, RISCV::AMOCAS_D_RV32_AQ_RL, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 812 /* amocas.d.rl */, RISCV::AMOCAS_D_RV64_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 812 /* amocas.d.rl */, RISCV::AMOCAS_D_RV32_RL, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 824 /* amocas.h */, RISCV::AMOCAS_H, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 833 /* amocas.h.aq */, RISCV::AMOCAS_H_AQ, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 845 /* amocas.h.aqrl */, RISCV::AMOCAS_H_AQ_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 859 /* amocas.h.rl */, RISCV::AMOCAS_H_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 871 /* amocas.q */, RISCV::AMOCAS_Q, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 880 /* amocas.q.aq */, RISCV::AMOCAS_Q_AQ, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 892 /* amocas.q.aqrl */, RISCV::AMOCAS_Q_AQ_RL, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 906 /* amocas.q.rl */, RISCV::AMOCAS_Q_RL, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 918 /* amocas.w */, RISCV::AMOCAS_W, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 927 /* amocas.w.aq */, RISCV::AMOCAS_W_AQ, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 939 /* amocas.w.aqrl */, RISCV::AMOCAS_W_AQ_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 953 /* amocas.w.rl */, RISCV::AMOCAS_W_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 965 /* amomax.b */, RISCV::AMOMAX_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 974 /* amomax.b.aq */, RISCV::AMOMAX_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 986 /* amomax.b.aqrl */, RISCV::AMOMAX_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1000 /* amomax.b.rl */, RISCV::AMOMAX_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1012 /* amomax.d */, RISCV::AMOMAX_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1021 /* amomax.d.aq */, RISCV::AMOMAX_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1033 /* amomax.d.aqrl */, RISCV::AMOMAX_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1047 /* amomax.d.rl */, RISCV::AMOMAX_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1059 /* amomax.h */, RISCV::AMOMAX_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1068 /* amomax.h.aq */, RISCV::AMOMAX_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1080 /* amomax.h.aqrl */, RISCV::AMOMAX_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1094 /* amomax.h.rl */, RISCV::AMOMAX_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1106 /* amomax.w */, RISCV::AMOMAX_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1115 /* amomax.w.aq */, RISCV::AMOMAX_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1127 /* amomax.w.aqrl */, RISCV::AMOMAX_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1141 /* amomax.w.rl */, RISCV::AMOMAX_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1153 /* amomaxu.b */, RISCV::AMOMAXU_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1163 /* amomaxu.b.aq */, RISCV::AMOMAXU_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1176 /* amomaxu.b.aqrl */, RISCV::AMOMAXU_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1191 /* amomaxu.b.rl */, RISCV::AMOMAXU_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1204 /* amomaxu.d */, RISCV::AMOMAXU_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1214 /* amomaxu.d.aq */, RISCV::AMOMAXU_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1227 /* amomaxu.d.aqrl */, RISCV::AMOMAXU_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1242 /* amomaxu.d.rl */, RISCV::AMOMAXU_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1255 /* amomaxu.h */, RISCV::AMOMAXU_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1265 /* amomaxu.h.aq */, RISCV::AMOMAXU_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1278 /* amomaxu.h.aqrl */, RISCV::AMOMAXU_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1293 /* amomaxu.h.rl */, RISCV::AMOMAXU_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1306 /* amomaxu.w */, RISCV::AMOMAXU_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1316 /* amomaxu.w.aq */, RISCV::AMOMAXU_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1329 /* amomaxu.w.aqrl */, RISCV::AMOMAXU_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1344 /* amomaxu.w.rl */, RISCV::AMOMAXU_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1357 /* amomin.b */, RISCV::AMOMIN_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1366 /* amomin.b.aq */, RISCV::AMOMIN_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1378 /* amomin.b.aqrl */, RISCV::AMOMIN_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1392 /* amomin.b.rl */, RISCV::AMOMIN_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1404 /* amomin.d */, RISCV::AMOMIN_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1413 /* amomin.d.aq */, RISCV::AMOMIN_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1425 /* amomin.d.aqrl */, RISCV::AMOMIN_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1439 /* amomin.d.rl */, RISCV::AMOMIN_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1451 /* amomin.h */, RISCV::AMOMIN_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1460 /* amomin.h.aq */, RISCV::AMOMIN_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1472 /* amomin.h.aqrl */, RISCV::AMOMIN_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1486 /* amomin.h.rl */, RISCV::AMOMIN_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1498 /* amomin.w */, RISCV::AMOMIN_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1507 /* amomin.w.aq */, RISCV::AMOMIN_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1519 /* amomin.w.aqrl */, RISCV::AMOMIN_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1533 /* amomin.w.rl */, RISCV::AMOMIN_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1545 /* amominu.b */, RISCV::AMOMINU_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1555 /* amominu.b.aq */, RISCV::AMOMINU_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1568 /* amominu.b.aqrl */, RISCV::AMOMINU_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1583 /* amominu.b.rl */, RISCV::AMOMINU_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1596 /* amominu.d */, RISCV::AMOMINU_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1606 /* amominu.d.aq */, RISCV::AMOMINU_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1619 /* amominu.d.aqrl */, RISCV::AMOMINU_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1634 /* amominu.d.rl */, RISCV::AMOMINU_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1647 /* amominu.h */, RISCV::AMOMINU_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1657 /* amominu.h.aq */, RISCV::AMOMINU_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1670 /* amominu.h.aqrl */, RISCV::AMOMINU_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1685 /* amominu.h.rl */, RISCV::AMOMINU_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1698 /* amominu.w */, RISCV::AMOMINU_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1708 /* amominu.w.aq */, RISCV::AMOMINU_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1721 /* amominu.w.aqrl */, RISCV::AMOMINU_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1736 /* amominu.w.rl */, RISCV::AMOMINU_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1749 /* amoor.b */, RISCV::AMOOR_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1757 /* amoor.b.aq */, RISCV::AMOOR_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1768 /* amoor.b.aqrl */, RISCV::AMOOR_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1781 /* amoor.b.rl */, RISCV::AMOOR_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1792 /* amoor.d */, RISCV::AMOOR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1800 /* amoor.d.aq */, RISCV::AMOOR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1811 /* amoor.d.aqrl */, RISCV::AMOOR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1824 /* amoor.d.rl */, RISCV::AMOOR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1835 /* amoor.h */, RISCV::AMOOR_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1843 /* amoor.h.aq */, RISCV::AMOOR_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1854 /* amoor.h.aqrl */, RISCV::AMOOR_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1867 /* amoor.h.rl */, RISCV::AMOOR_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1878 /* amoor.w */, RISCV::AMOOR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1886 /* amoor.w.aq */, RISCV::AMOOR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1897 /* amoor.w.aqrl */, RISCV::AMOOR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1910 /* amoor.w.rl */, RISCV::AMOOR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1921 /* amoswap.b */, RISCV::AMOSWAP_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1931 /* amoswap.b.aq */, RISCV::AMOSWAP_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1944 /* amoswap.b.aqrl */, RISCV::AMOSWAP_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1959 /* amoswap.b.rl */, RISCV::AMOSWAP_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1972 /* amoswap.d */, RISCV::AMOSWAP_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1982 /* amoswap.d.aq */, RISCV::AMOSWAP_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1995 /* amoswap.d.aqrl */, RISCV::AMOSWAP_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2010 /* amoswap.d.rl */, RISCV::AMOSWAP_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2023 /* amoswap.h */, RISCV::AMOSWAP_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2033 /* amoswap.h.aq */, RISCV::AMOSWAP_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2046 /* amoswap.h.aqrl */, RISCV::AMOSWAP_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2061 /* amoswap.h.rl */, RISCV::AMOSWAP_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2074 /* amoswap.w */, RISCV::AMOSWAP_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2084 /* amoswap.w.aq */, RISCV::AMOSWAP_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2097 /* amoswap.w.aqrl */, RISCV::AMOSWAP_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2112 /* amoswap.w.rl */, RISCV::AMOSWAP_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2125 /* amoxor.b */, RISCV::AMOXOR_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2134 /* amoxor.b.aq */, RISCV::AMOXOR_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2146 /* amoxor.b.aqrl */, RISCV::AMOXOR_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2160 /* amoxor.b.rl */, RISCV::AMOXOR_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2172 /* amoxor.d */, RISCV::AMOXOR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2181 /* amoxor.d.aq */, RISCV::AMOXOR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2193 /* amoxor.d.aqrl */, RISCV::AMOXOR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2207 /* amoxor.d.rl */, RISCV::AMOXOR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2219 /* amoxor.h */, RISCV::AMOXOR_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2228 /* amoxor.h.aq */, RISCV::AMOXOR_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2240 /* amoxor.h.aqrl */, RISCV::AMOXOR_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2254 /* amoxor.h.rl */, RISCV::AMOXOR_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2266 /* amoxor.w */, RISCV::AMOXOR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2275 /* amoxor.w.aq */, RISCV::AMOXOR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2287 /* amoxor.w.aqrl */, RISCV::AMOXOR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2301 /* amoxor.w.rl */, RISCV::AMOXOR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2313 /* and */, RISCV::AND, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2313 /* and */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 2317 /* andi */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 2322 /* andn */, RISCV::ANDN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2327 /* auipc */, RISCV::AUIPC, Convert__Reg1_0__UImm20AUIPC1_1, AMFBS_None, { MCK_GPR, MCK_UImm20AUIPC }, },
  { 2333 /* bclr */, RISCV::BCLR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2333 /* bclr */, RISCV::BCLRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2338 /* bclri */, RISCV::BCLRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2344 /* beq */, RISCV::BEQ, Convert__Reg1_0__Reg1_1__BareSImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2348 /* beqz */, RISCV::BEQ, Convert__Reg1_0__regX0__BareSImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2353 /* bext */, RISCV::BEXT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2353 /* bext */, RISCV::BEXTI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2358 /* bexti */, RISCV::BEXTI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2364 /* bge */, RISCV::BGE, Convert__Reg1_0__Reg1_1__BareSImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2368 /* bgeu */, RISCV::BGEU, Convert__Reg1_0__Reg1_1__BareSImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2373 /* bgez */, RISCV::BGE, Convert__Reg1_0__regX0__BareSImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2378 /* bgt */, RISCV::BLT, Convert__Reg1_1__Reg1_0__BareSImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2382 /* bgtu */, RISCV::BLTU, Convert__Reg1_1__Reg1_0__BareSImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2387 /* bgtz */, RISCV::BLT, Convert__regX0__Reg1_0__BareSImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2392 /* binv */, RISCV::BINV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2392 /* binv */, RISCV::BINVI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2397 /* binvi */, RISCV::BINVI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2403 /* ble */, RISCV::BGE, Convert__Reg1_1__Reg1_0__BareSImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2407 /* bleu */, RISCV::BGEU, Convert__Reg1_1__Reg1_0__BareSImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2412 /* blez */, RISCV::BGE, Convert__regX0__Reg1_0__BareSImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2417 /* blt */, RISCV::BLT, Convert__Reg1_0__Reg1_1__BareSImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2421 /* bltu */, RISCV::BLTU, Convert__Reg1_0__Reg1_1__BareSImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2426 /* bltz */, RISCV::BLT, Convert__Reg1_0__regX0__BareSImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2431 /* bne */, RISCV::BNE, Convert__Reg1_0__Reg1_1__BareSImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2435 /* bnez */, RISCV::BNE, Convert__Reg1_0__regX0__BareSImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_BareSImm13Lsb0 }, },
  { 2440 /* brev8 */, RISCV::BREV8, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb, { MCK_GPR, MCK_GPR }, },
  { 2446 /* bset */, RISCV::BSET, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2446 /* bset */, RISCV::BSETI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2451 /* bseti */, RISCV::BSETI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2457 /* c.add */, RISCV::C_ADD_HINT, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZca, { MCK_GPRX0, MCK_GPRNoX0 }, },
  { 2457 /* c.add */, RISCV::C_ADD, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZca, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 2463 /* c.addi */, RISCV::PseudoC_ADDI_NOP, Convert__Reg1_0__imm_95_0__ImmZero1_1, AMFBS_HasStdExtZca, { MCK_GPRX0, MCK_ImmZero }, },
  { 2463 /* c.addi */, RISCV::C_NOP_HINT, Convert__SImm6NonZero1_1, AMFBS_HasStdExtZca, { MCK_GPRX0, MCK_SImm6NonZero }, },
  { 2463 /* c.addi */, RISCV::C_ADDI_HINT_IMM_ZERO, Convert__Reg1_0__Tie0_1_1__ImmZero1_1, AMFBS_HasStdExtZca, { MCK_GPRNoX0, MCK_ImmZero }, },
  { 2463 /* c.addi */, RISCV::C_ADDI, Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1, AMFBS_HasStdExtZca, { MCK_GPRNoX0, MCK_SImm6NonZero }, },
  { 2470 /* c.addi16sp */, RISCV::C_ADDI16SP, Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1, AMFBS_HasStdExtZca, { MCK_SP, MCK_SImm10Lsb0000NonZero }, },
  { 2481 /* c.addi4spn */, RISCV::C_ADDI4SPN, Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_SP, MCK_UImm10Lsb00NonZero }, },
  { 2492 /* c.addiw */, RISCV::C_ADDIW, Convert__Reg1_0__Tie0_1_1__SImm61_1, AMFBS_HasStdExtZca_IsRV64, { MCK_GPRNoX0, MCK_SImm6 }, },
  { 2500 /* c.addw */, RISCV::C_ADDW, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZca_IsRV64, { MCK_GPRC, MCK_GPRC }, },
  { 2507 /* c.and */, RISCV::C_AND, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_GPRC }, },
  { 2513 /* c.andi */, RISCV::C_ANDI, Convert__Reg1_0__Tie0_1_1__SImm61_1, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_SImm6 }, },
  { 2520 /* c.beqz */, RISCV::C_BEQZ, Convert__Reg1_0__BareSImm9Lsb01_1, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_BareSImm9Lsb0 }, },
  { 2527 /* c.bnez */, RISCV::C_BNEZ, Convert__Reg1_0__BareSImm9Lsb01_1, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_BareSImm9Lsb0 }, },
  { 2534 /* c.ebreak */, RISCV::C_EBREAK, Convert_NoOperands, AMFBS_HasStdExtZca, {  }, },
  { 2543 /* c.fld */, RISCV::C_FLD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2543 /* c.fld */, RISCV::C_FLD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2549 /* c.fldsp */, RISCV::C_FLDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2549 /* c.fldsp */, RISCV::C_FLDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2557 /* c.flw */, RISCV::C_FLW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2557 /* c.flw */, RISCV::C_FLW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2563 /* c.flwsp */, RISCV::C_FLWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2563 /* c.flwsp */, RISCV::C_FLWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2571 /* c.fsd */, RISCV::C_FSD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2571 /* c.fsd */, RISCV::C_FSD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2577 /* c.fsdsp */, RISCV::C_FSDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2577 /* c.fsdsp */, RISCV::C_FSDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2585 /* c.fsw */, RISCV::C_FSW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2585 /* c.fsw */, RISCV::C_FSW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2591 /* c.fswsp */, RISCV::C_FSWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2591 /* c.fswsp */, RISCV::C_FSWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2599 /* c.j */, RISCV::C_J, Convert__BareSImm12Lsb01_0, AMFBS_HasStdExtZca, { MCK_BareSImm12Lsb0 }, },
  { 2603 /* c.jal */, RISCV::C_JAL, Convert__BareSImm12Lsb01_0, AMFBS_HasStdExtZca_IsRV32, { MCK_BareSImm12Lsb0 }, },
  { 2609 /* c.jalr */, RISCV::C_JALR, Convert__Reg1_0, AMFBS_HasStdExtZca, { MCK_GPRNoX0 }, },
  { 2616 /* c.jr */, RISCV::C_JR, Convert__Reg1_0, AMFBS_HasStdExtZca, { MCK_GPRNoX0 }, },
  { 2621 /* c.lbu */, RISCV::C_LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2621 /* c.lbu */, RISCV::C_LBU, Convert__Reg1_0__Reg1_3__UImm21_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2627 /* c.ld */, RISCV::C_LD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2627 /* c.ld */, RISCV::C_LD_RV32, Convert__GPRPairCRV321_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZclsd_IsRV32, { MCK_GPRPairCRV32, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2627 /* c.ld */, RISCV::C_LD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtZca_IsRV64, { MCK_GPRC, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2627 /* c.ld */, RISCV::C_LD_RV32, Convert__GPRPairCRV321_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtZclsd_IsRV32, { MCK_GPRPairCRV32, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2632 /* c.ldsp */, RISCV::C_LDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZca_IsRV64, { MCK_GPRNoX0, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2632 /* c.ldsp */, RISCV::C_LDSP_RV32, Convert__GPRPairNoX0RV321_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZclsd_IsRV32, { MCK_GPRPairNoX0RV32, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2632 /* c.ldsp */, RISCV::C_LDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtZca_IsRV64, { MCK_GPRNoX0, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2632 /* c.ldsp */, RISCV::C_LDSP_RV32, Convert__GPRPairNoX0RV321_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtZclsd_IsRV32, { MCK_GPRPairNoX0RV32, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2639 /* c.lh */, RISCV::C_LH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2639 /* c.lh */, RISCV::C_LH, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2644 /* c.lhu */, RISCV::C_LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2644 /* c.lhu */, RISCV::C_LHU, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2650 /* c.li */, RISCV::C_LI_HINT, Convert__Reg1_0__SImm61_1, AMFBS_HasStdExtZca, { MCK_GPRX0, MCK_SImm6 }, },
  { 2650 /* c.li */, RISCV::C_LI, Convert__Reg1_0__SImm61_1, AMFBS_HasStdExtZca, { MCK_GPRNoX0, MCK_SImm6 }, },
  { 2655 /* c.lui */, RISCV::C_LUI_HINT, Convert__Reg1_0__CLUIImm1_1, AMFBS_HasStdExtZca, { MCK_GPRX0, MCK_CLUIImm }, },
  { 2655 /* c.lui */, RISCV::C_LUI, Convert__Reg1_0__CLUIImm1_1, AMFBS_HasStdExtZca, { MCK_GPRNoX0X2, MCK_CLUIImm }, },
  { 2661 /* c.lw */, RISCV::C_LW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZca, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2661 /* c.lw */, RISCV::C_LW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2666 /* c.lwsp */, RISCV::C_LWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZca, { MCK_GPRNoX0, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2666 /* c.lwsp */, RISCV::C_LWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtZca, { MCK_GPRNoX0, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2673 /* c.mop.1 */, RISCV::C_MOP1, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2681 /* c.mop.11 */, RISCV::C_MOP11, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2690 /* c.mop.13 */, RISCV::C_MOP13, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2699 /* c.mop.15 */, RISCV::C_MOP15, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2708 /* c.mop.3 */, RISCV::C_MOP3, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2716 /* c.mop.5 */, RISCV::C_MOP5, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2724 /* c.mop.7 */, RISCV::C_MOP7, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2732 /* c.mop.9 */, RISCV::C_MOP9, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2740 /* c.mul */, RISCV::C_MUL, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZcb_HasStdExtZmmul, { MCK_GPRC, MCK_GPRC }, },
  { 2746 /* c.mv */, RISCV::C_MV_HINT, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZca, { MCK_GPRX0, MCK_GPRNoX0 }, },
  { 2746 /* c.mv */, RISCV::C_MV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZca, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 2751 /* c.nop */, RISCV::C_NOP, Convert_NoOperands, AMFBS_HasStdExtZca, {  }, },
  { 2751 /* c.nop */, RISCV::C_NOP_HINT, Convert__SImm6NonZero1_0, AMFBS_HasStdExtZca, { MCK_SImm6NonZero }, },
  { 2757 /* c.not */, RISCV::C_NOT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb, { MCK_GPRC }, },
  { 2763 /* c.ntl.all */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX5, AMFBS_HasStdExtC_HasStdExtZihintntl, {  }, },
  { 2773 /* c.ntl.p1 */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX2, AMFBS_HasStdExtC_HasStdExtZihintntl, {  }, },
  { 2782 /* c.ntl.pall */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX3, AMFBS_HasStdExtC_HasStdExtZihintntl, {  }, },
  { 2793 /* c.ntl.s1 */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX4, AMFBS_HasStdExtC_HasStdExtZihintntl, {  }, },
  { 2802 /* c.or */, RISCV::C_OR, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_GPRC }, },
  { 2807 /* c.sb */, RISCV::C_SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2807 /* c.sb */, RISCV::C_SB, Convert__Reg1_0__Reg1_3__UImm21_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2812 /* c.sd */, RISCV::C_SD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2812 /* c.sd */, RISCV::C_SD_RV32, Convert__GPRPairCRV321_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZclsd_IsRV32, { MCK_GPRPairCRV32, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2812 /* c.sd */, RISCV::C_SD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtZca_IsRV64, { MCK_GPRC, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2812 /* c.sd */, RISCV::C_SD_RV32, Convert__GPRPairCRV321_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtZclsd_IsRV32, { MCK_GPRPairCRV32, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2817 /* c.sdsp */, RISCV::C_SDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZca_IsRV64, { MCK_GPR, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2817 /* c.sdsp */, RISCV::C_SDSP_RV32, Convert__GPRPairRV321_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZclsd_IsRV32, { MCK_GPRPairRV32, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2817 /* c.sdsp */, RISCV::C_SDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtZca_IsRV64, { MCK_GPR, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2817 /* c.sdsp */, RISCV::C_SDSP_RV32, Convert__GPRPairRV321_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtZclsd_IsRV32, { MCK_GPRPairRV32, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2824 /* c.sext.b */, RISCV::C_SEXT_B, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 2833 /* c.sext.h */, RISCV::C_SEXT_H, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 2842 /* c.sh */, RISCV::C_SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2842 /* c.sh */, RISCV::C_SH, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2847 /* c.slli */, RISCV::C_SLLI_HINT, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtZca, { MCK_GPRX0, MCK_UImmLog2XLenNonZero }, },
  { 2847 /* c.slli */, RISCV::C_SLLI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtZca, { MCK_GPRNoX0, MCK_UImmLog2XLenNonZero }, },
  { 2854 /* c.slli64 */, RISCV::C_SLLI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZca, { MCK_GPR }, },
  { 2863 /* c.srai */, RISCV::C_SRAI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_UImmLog2XLenNonZero }, },
  { 2870 /* c.srai64 */, RISCV::C_SRAI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZca, { MCK_GPRC }, },
  { 2879 /* c.srli */, RISCV::C_SRLI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_UImmLog2XLenNonZero }, },
  { 2886 /* c.srli64 */, RISCV::C_SRLI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZca, { MCK_GPRC }, },
  { 2895 /* c.sspopchk */, RISCV::C_SSPOPCHK, Convert__Reg1_0, AMFBS_HasStdExtZicfiss_HasStdExtZcmop, { MCK_GPRX5 }, },
  { 2906 /* c.sspush */, RISCV::C_SSPUSH, Convert__Reg1_0, AMFBS_HasStdExtZicfiss_HasStdExtZcmop, { MCK_GPRX1 }, },
  { 2915 /* c.sub */, RISCV::C_SUB, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_GPRC }, },
  { 2921 /* c.subw */, RISCV::C_SUBW, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZca_IsRV64, { MCK_GPRC, MCK_GPRC }, },
  { 2928 /* c.sw */, RISCV::C_SW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZca, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2928 /* c.sw */, RISCV::C_SW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2933 /* c.swsp */, RISCV::C_SWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZca, { MCK_GPR, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2933 /* c.swsp */, RISCV::C_SWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtZca, { MCK_GPR, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2940 /* c.unimp */, RISCV::C_UNIMP, Convert_NoOperands, AMFBS_HasStdExtZca, {  }, },
  { 2948 /* c.xor */, RISCV::C_XOR, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZca, { MCK_GPRC, MCK_GPRC }, },
  { 2954 /* c.zext.b */, RISCV::C_ZEXT_B, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb, { MCK_GPRC }, },
  { 2963 /* c.zext.h */, RISCV::C_ZEXT_H, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 2972 /* c.zext.w */, RISCV::C_ZEXT_W, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZba_IsRV64, { MCK_GPRC }, },
  { 2981 /* call */, RISCV::PseudoCALL, Convert__CallSymbol1_0, AMFBS_None, { MCK_CallSymbol }, },
  { 2981 /* call */, RISCV::PseudoCALLReg, Convert__Reg1_0__CallSymbol1_1, AMFBS_None, { MCK_GPR, MCK_CallSymbol }, },
  { 2986 /* cbo.clean */, RISCV::CBO_CLEAN, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 2996 /* cbo.flush */, RISCV::CBO_FLUSH, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 3006 /* cbo.inval */, RISCV::CBO_INVAL, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 3016 /* cbo.zero */, RISCV::CBO_ZERO, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicboz, { MCK_ZeroOffsetMemOpOperand }, },
  { 3025 /* clmul */, RISCV::CLMUL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbcOrZbkc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3031 /* clmulh */, RISCV::CLMULH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbcOrZbkc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3038 /* clmulr */, RISCV::CLMULR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3045 /* cls */, RISCV::CLS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP, { MCK_GPR, MCK_GPR }, },
  { 3049 /* clsw */, RISCV::CLSW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 3054 /* clz */, RISCV::CLZ, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrP, { MCK_GPR, MCK_GPR }, },
  { 3058 /* clzw */, RISCV::CLZW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrP_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 3063 /* cm.jalt */, RISCV::CM_JALT, Convert__UImm8GE321_0, AMFBS_HasStdExtZcmt, { MCK_UImm8GE32 }, },
  { 3071 /* cm.jt */, RISCV::CM_JT, Convert__UImm51_0, AMFBS_HasStdExtZcmt, { MCK_UImm5 }, },
  { 3077 /* cm.mva01s */, RISCV::CM_MVA01S, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZcmp, { MCK_SR07, MCK_SR07 }, },
  { 3087 /* cm.mvsa01 */, RISCV::CM_MVSA01, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZcmp, { MCK_SR07, MCK_SR07 }, },
  { 3097 /* cm.pop */, RISCV::CM_POP, Convert__RegList1_0__StackAdj1_1, AMFBS_HasStdExtZcmp, { MCK_RegList, MCK_StackAdj }, },
  { 3104 /* cm.popret */, RISCV::CM_POPRET, Convert__RegList1_0__StackAdj1_1, AMFBS_HasStdExtZcmp, { MCK_RegList, MCK_StackAdj }, },
  { 3114 /* cm.popretz */, RISCV::CM_POPRETZ, Convert__RegList1_0__StackAdj1_1, AMFBS_HasStdExtZcmp, { MCK_RegList, MCK_StackAdj }, },
  { 3125 /* cm.push */, RISCV::CM_PUSH, Convert__RegList1_0__NegStackAdj1_1, AMFBS_HasStdExtZcmp, { MCK_RegList, MCK_NegStackAdj }, },
  { 3133 /* cpop */, RISCV::CPOP, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 3138 /* cpopw */, RISCV::CPOPW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 3144 /* csrc */, RISCV::CSRRC, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 3144 /* csrc */, RISCV::CSRRCI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3149 /* csrci */, RISCV::CSRRCI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3155 /* csrr */, RISCV::CSRRS, Convert__Reg1_0__CSRSystemRegister1_1__regX0, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister }, },
  { 3160 /* csrrc */, RISCV::CSRRC, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 3160 /* csrrc */, RISCV::CSRRCI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3166 /* csrrci */, RISCV::CSRRCI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3173 /* csrrs */, RISCV::CSRRS, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 3173 /* csrrs */, RISCV::CSRRSI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3179 /* csrrsi */, RISCV::CSRRSI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3186 /* csrrw */, RISCV::CSRRW, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 3186 /* csrrw */, RISCV::CSRRWI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3192 /* csrrwi */, RISCV::CSRRWI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3199 /* csrs */, RISCV::CSRRS, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 3199 /* csrs */, RISCV::CSRRSI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3204 /* csrsi */, RISCV::CSRRSI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3210 /* csrw */, RISCV::CSRRW, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 3210 /* csrw */, RISCV::CSRRWI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3215 /* csrwi */, RISCV::CSRRWI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3221 /* ctz */, RISCV::CTZ, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 3225 /* ctzw */, RISCV::CTZW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 3230 /* cv.abs */, RISCV::CV_ABS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 3237 /* cv.abs.b */, RISCV::CV_ABS_B, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 3246 /* cv.abs.h */, RISCV::CV_ABS_H, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 3255 /* cv.add.b */, RISCV::CV_ADD_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3264 /* cv.add.div2 */, RISCV::CV_ADD_DIV2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3276 /* cv.add.div4 */, RISCV::CV_ADD_DIV4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3288 /* cv.add.div8 */, RISCV::CV_ADD_DIV8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3300 /* cv.add.h */, RISCV::CV_ADD_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3309 /* cv.add.sc.b */, RISCV::CV_ADD_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3321 /* cv.add.sc.h */, RISCV::CV_ADD_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3333 /* cv.add.sci.b */, RISCV::CV_ADD_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3346 /* cv.add.sci.h */, RISCV::CV_ADD_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3359 /* cv.addn */, RISCV::CV_ADDN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3367 /* cv.addnr */, RISCV::CV_ADDNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3376 /* cv.addrn */, RISCV::CV_ADDRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3385 /* cv.addrnr */, RISCV::CV_ADDRNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3395 /* cv.addun */, RISCV::CV_ADDUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3404 /* cv.addunr */, RISCV::CV_ADDUNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3414 /* cv.addurn */, RISCV::CV_ADDURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3424 /* cv.addurnr */, RISCV::CV_ADDURNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3435 /* cv.and.b */, RISCV::CV_AND_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3444 /* cv.and.h */, RISCV::CV_AND_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3453 /* cv.and.sc.b */, RISCV::CV_AND_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3465 /* cv.and.sc.h */, RISCV::CV_AND_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3477 /* cv.and.sci.b */, RISCV::CV_AND_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3490 /* cv.and.sci.h */, RISCV::CV_AND_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3503 /* cv.avg.b */, RISCV::CV_AVG_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3512 /* cv.avg.h */, RISCV::CV_AVG_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3521 /* cv.avg.sc.b */, RISCV::CV_AVG_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3533 /* cv.avg.sc.h */, RISCV::CV_AVG_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3545 /* cv.avg.sci.b */, RISCV::CV_AVG_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3558 /* cv.avg.sci.h */, RISCV::CV_AVG_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3571 /* cv.avgu.b */, RISCV::CV_AVGU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3581 /* cv.avgu.h */, RISCV::CV_AVGU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3591 /* cv.avgu.sc.b */, RISCV::CV_AVGU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3604 /* cv.avgu.sc.h */, RISCV::CV_AVGU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3617 /* cv.avgu.sci.b */, RISCV::CV_AVGU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3631 /* cv.avgu.sci.h */, RISCV::CV_AVGU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3645 /* cv.bclr */, RISCV::CV_BCLR, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 3653 /* cv.bclrr */, RISCV::CV_BCLRR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3662 /* cv.beqimm */, RISCV::CV_BEQIMM, Convert__Reg1_0__SImm51_1__BareSImm13Lsb01_2, AMFBS_HasVendorXCVbi_IsRV32, { MCK_GPR, MCK_SImm5, MCK_BareSImm13Lsb0 }, },
  { 3672 /* cv.bitrev */, RISCV::CV_BITREV, Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm2, MCK_UImm5 }, },
  { 3682 /* cv.bneimm */, RISCV::CV_BNEIMM, Convert__Reg1_0__SImm51_1__BareSImm13Lsb01_2, AMFBS_HasVendorXCVbi_IsRV32, { MCK_GPR, MCK_SImm5, MCK_BareSImm13Lsb0 }, },
  { 3692 /* cv.bset */, RISCV::CV_BSET, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 3700 /* cv.bsetr */, RISCV::CV_BSETR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3709 /* cv.clb */, RISCV::CV_CLB, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 3716 /* cv.clip */, RISCV::CV_CLIP, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3724 /* cv.clipr */, RISCV::CV_CLIPR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3733 /* cv.clipu */, RISCV::CV_CLIPU, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3742 /* cv.clipur */, RISCV::CV_CLIPUR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3752 /* cv.cmpeq.b */, RISCV::CV_CMPEQ_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3763 /* cv.cmpeq.h */, RISCV::CV_CMPEQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3774 /* cv.cmpeq.sc.b */, RISCV::CV_CMPEQ_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3788 /* cv.cmpeq.sc.h */, RISCV::CV_CMPEQ_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3802 /* cv.cmpeq.sci.b */, RISCV::CV_CMPEQ_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3817 /* cv.cmpeq.sci.h */, RISCV::CV_CMPEQ_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3832 /* cv.cmpge.b */, RISCV::CV_CMPGE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3843 /* cv.cmpge.h */, RISCV::CV_CMPGE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3854 /* cv.cmpge.sc.b */, RISCV::CV_CMPGE_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3868 /* cv.cmpge.sc.h */, RISCV::CV_CMPGE_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3882 /* cv.cmpge.sci.b */, RISCV::CV_CMPGE_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3897 /* cv.cmpge.sci.h */, RISCV::CV_CMPGE_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3912 /* cv.cmpgeu.b */, RISCV::CV_CMPGEU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3924 /* cv.cmpgeu.h */, RISCV::CV_CMPGEU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3936 /* cv.cmpgeu.sc.b */, RISCV::CV_CMPGEU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3951 /* cv.cmpgeu.sc.h */, RISCV::CV_CMPGEU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3966 /* cv.cmpgeu.sci.b */, RISCV::CV_CMPGEU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3982 /* cv.cmpgeu.sci.h */, RISCV::CV_CMPGEU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3998 /* cv.cmpgt.b */, RISCV::CV_CMPGT_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4009 /* cv.cmpgt.h */, RISCV::CV_CMPGT_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4020 /* cv.cmpgt.sc.b */, RISCV::CV_CMPGT_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4034 /* cv.cmpgt.sc.h */, RISCV::CV_CMPGT_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4048 /* cv.cmpgt.sci.b */, RISCV::CV_CMPGT_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4063 /* cv.cmpgt.sci.h */, RISCV::CV_CMPGT_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4078 /* cv.cmpgtu.b */, RISCV::CV_CMPGTU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4090 /* cv.cmpgtu.h */, RISCV::CV_CMPGTU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4102 /* cv.cmpgtu.sc.b */, RISCV::CV_CMPGTU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4117 /* cv.cmpgtu.sc.h */, RISCV::CV_CMPGTU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4132 /* cv.cmpgtu.sci.b */, RISCV::CV_CMPGTU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4148 /* cv.cmpgtu.sci.h */, RISCV::CV_CMPGTU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4164 /* cv.cmple.b */, RISCV::CV_CMPLE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4175 /* cv.cmple.h */, RISCV::CV_CMPLE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4186 /* cv.cmple.sc.b */, RISCV::CV_CMPLE_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4200 /* cv.cmple.sc.h */, RISCV::CV_CMPLE_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4214 /* cv.cmple.sci.b */, RISCV::CV_CMPLE_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4229 /* cv.cmple.sci.h */, RISCV::CV_CMPLE_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4244 /* cv.cmpleu.b */, RISCV::CV_CMPLEU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4256 /* cv.cmpleu.h */, RISCV::CV_CMPLEU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4268 /* cv.cmpleu.sc.b */, RISCV::CV_CMPLEU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4283 /* cv.cmpleu.sc.h */, RISCV::CV_CMPLEU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4298 /* cv.cmpleu.sci.b */, RISCV::CV_CMPLEU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4314 /* cv.cmpleu.sci.h */, RISCV::CV_CMPLEU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4330 /* cv.cmplt.b */, RISCV::CV_CMPLT_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4341 /* cv.cmplt.h */, RISCV::CV_CMPLT_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4352 /* cv.cmplt.sc.b */, RISCV::CV_CMPLT_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4366 /* cv.cmplt.sc.h */, RISCV::CV_CMPLT_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4380 /* cv.cmplt.sci.b */, RISCV::CV_CMPLT_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4395 /* cv.cmplt.sci.h */, RISCV::CV_CMPLT_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4410 /* cv.cmpltu.b */, RISCV::CV_CMPLTU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4422 /* cv.cmpltu.h */, RISCV::CV_CMPLTU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4434 /* cv.cmpltu.sc.b */, RISCV::CV_CMPLTU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4449 /* cv.cmpltu.sc.h */, RISCV::CV_CMPLTU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4464 /* cv.cmpltu.sci.b */, RISCV::CV_CMPLTU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4480 /* cv.cmpltu.sci.h */, RISCV::CV_CMPLTU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4496 /* cv.cmpne.b */, RISCV::CV_CMPNE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4507 /* cv.cmpne.h */, RISCV::CV_CMPNE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4518 /* cv.cmpne.sc.b */, RISCV::CV_CMPNE_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4532 /* cv.cmpne.sc.h */, RISCV::CV_CMPNE_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4546 /* cv.cmpne.sci.b */, RISCV::CV_CMPNE_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4561 /* cv.cmpne.sci.h */, RISCV::CV_CMPNE_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4576 /* cv.cnt */, RISCV::CV_CNT, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4583 /* cv.cplxconj */, RISCV::CV_CPLXCONJ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4595 /* cv.cplxmul.i */, RISCV::CV_CPLXMUL_I, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4608 /* cv.cplxmul.i.div2 */, RISCV::CV_CPLXMUL_I_DIV2, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4626 /* cv.cplxmul.i.div4 */, RISCV::CV_CPLXMUL_I_DIV4, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4644 /* cv.cplxmul.i.div8 */, RISCV::CV_CPLXMUL_I_DIV8, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4662 /* cv.cplxmul.r */, RISCV::CV_CPLXMUL_R, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4675 /* cv.cplxmul.r.div2 */, RISCV::CV_CPLXMUL_R_DIV2, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4693 /* cv.cplxmul.r.div4 */, RISCV::CV_CPLXMUL_R_DIV4, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4711 /* cv.cplxmul.r.div8 */, RISCV::CV_CPLXMUL_R_DIV8, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4729 /* cv.dotsp.b */, RISCV::CV_DOTSP_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4740 /* cv.dotsp.h */, RISCV::CV_DOTSP_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4751 /* cv.dotsp.sc.b */, RISCV::CV_DOTSP_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4765 /* cv.dotsp.sc.h */, RISCV::CV_DOTSP_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4779 /* cv.dotsp.sci.b */, RISCV::CV_DOTSP_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4794 /* cv.dotsp.sci.h */, RISCV::CV_DOTSP_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4809 /* cv.dotup.b */, RISCV::CV_DOTUP_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4820 /* cv.dotup.h */, RISCV::CV_DOTUP_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4831 /* cv.dotup.sc.b */, RISCV::CV_DOTUP_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4845 /* cv.dotup.sc.h */, RISCV::CV_DOTUP_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4859 /* cv.dotup.sci.b */, RISCV::CV_DOTUP_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4874 /* cv.dotup.sci.h */, RISCV::CV_DOTUP_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4889 /* cv.dotusp.b */, RISCV::CV_DOTUSP_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4901 /* cv.dotusp.h */, RISCV::CV_DOTUSP_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4913 /* cv.dotusp.sc.b */, RISCV::CV_DOTUSP_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4928 /* cv.dotusp.sc.h */, RISCV::CV_DOTUSP_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4943 /* cv.dotusp.sci.b */, RISCV::CV_DOTUSP_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4959 /* cv.dotusp.sci.h */, RISCV::CV_DOTUSP_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4975 /* cv.elw */, RISCV::CV_ELW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasVendorXCVelw_IsRV32, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4982 /* cv.extbs */, RISCV::CV_EXTBS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4991 /* cv.extbz */, RISCV::CV_EXTBZ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 5000 /* cv.exths */, RISCV::CV_EXTHS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 5009 /* cv.exthz */, RISCV::CV_EXTHZ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 5018 /* cv.extract */, RISCV::CV_EXTRACT, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 5029 /* cv.extract.b */, RISCV::CV_EXTRACT_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5042 /* cv.extract.h */, RISCV::CV_EXTRACT_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5055 /* cv.extractr */, RISCV::CV_EXTRACTR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5067 /* cv.extractu */, RISCV::CV_EXTRACTU, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 5079 /* cv.extractu.b */, RISCV::CV_EXTRACTU_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5093 /* cv.extractu.h */, RISCV::CV_EXTRACTU_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5107 /* cv.extractur */, RISCV::CV_EXTRACTUR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5120 /* cv.ff1 */, RISCV::CV_FF1, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 5127 /* cv.fl1 */, RISCV::CV_FL1, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 5134 /* cv.insert */, RISCV::CV_INSERT, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 5144 /* cv.insert.b */, RISCV::CV_INSERT_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5156 /* cv.insert.h */, RISCV::CV_INSERT_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5168 /* cv.insertr */, RISCV::CV_INSERTR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5179 /* cv.lb */, RISCV::CV_LB_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5179 /* cv.lb */, RISCV::CV_LB_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5179 /* cv.lb */, RISCV::CV_LB_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5185 /* cv.lbu */, RISCV::CV_LBU_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5185 /* cv.lbu */, RISCV::CV_LBU_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5185 /* cv.lbu */, RISCV::CV_LBU_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5192 /* cv.lh */, RISCV::CV_LH_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5192 /* cv.lh */, RISCV::CV_LH_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5192 /* cv.lh */, RISCV::CV_LH_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5198 /* cv.lhu */, RISCV::CV_LHU_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5198 /* cv.lhu */, RISCV::CV_LHU_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5198 /* cv.lhu */, RISCV::CV_LHU_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5205 /* cv.lw */, RISCV::CV_LW_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5205 /* cv.lw */, RISCV::CV_LW_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5205 /* cv.lw */, RISCV::CV_LW_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5211 /* cv.mac */, RISCV::CV_MAC, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5218 /* cv.machhsn */, RISCV::CV_MACHHSN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5229 /* cv.machhsrn */, RISCV::CV_MACHHSRN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5241 /* cv.machhun */, RISCV::CV_MACHHUN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5252 /* cv.machhurn */, RISCV::CV_MACHHURN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5264 /* cv.macsn */, RISCV::CV_MACSN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5273 /* cv.macsrn */, RISCV::CV_MACSRN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5283 /* cv.macun */, RISCV::CV_MACUN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5292 /* cv.macurn */, RISCV::CV_MACURN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5302 /* cv.max */, RISCV::CV_MAX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5309 /* cv.max.b */, RISCV::CV_MAX_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5318 /* cv.max.h */, RISCV::CV_MAX_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5327 /* cv.max.sc.b */, RISCV::CV_MAX_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5339 /* cv.max.sc.h */, RISCV::CV_MAX_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5351 /* cv.max.sci.b */, RISCV::CV_MAX_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5364 /* cv.max.sci.h */, RISCV::CV_MAX_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5377 /* cv.maxu */, RISCV::CV_MAXU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5385 /* cv.maxu.b */, RISCV::CV_MAXU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5395 /* cv.maxu.h */, RISCV::CV_MAXU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5405 /* cv.maxu.sc.b */, RISCV::CV_MAXU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5418 /* cv.maxu.sc.h */, RISCV::CV_MAXU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5431 /* cv.maxu.sci.b */, RISCV::CV_MAXU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5445 /* cv.maxu.sci.h */, RISCV::CV_MAXU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5459 /* cv.min */, RISCV::CV_MIN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5466 /* cv.min.b */, RISCV::CV_MIN_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5475 /* cv.min.h */, RISCV::CV_MIN_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5484 /* cv.min.sc.b */, RISCV::CV_MIN_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5496 /* cv.min.sc.h */, RISCV::CV_MIN_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5508 /* cv.min.sci.b */, RISCV::CV_MIN_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5521 /* cv.min.sci.h */, RISCV::CV_MIN_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5534 /* cv.minu */, RISCV::CV_MINU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5542 /* cv.minu.b */, RISCV::CV_MINU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5552 /* cv.minu.h */, RISCV::CV_MINU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5562 /* cv.minu.sc.b */, RISCV::CV_MINU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5575 /* cv.minu.sc.h */, RISCV::CV_MINU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5588 /* cv.minu.sci.b */, RISCV::CV_MINU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5602 /* cv.minu.sci.h */, RISCV::CV_MINU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5616 /* cv.msu */, RISCV::CV_MSU, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5623 /* cv.mulhhs */, RISCV::CV_MULHHSN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5633 /* cv.mulhhsn */, RISCV::CV_MULHHSN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5644 /* cv.mulhhsrn */, RISCV::CV_MULHHSRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5656 /* cv.mulhhu */, RISCV::CV_MULHHUN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5666 /* cv.mulhhun */, RISCV::CV_MULHHUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5677 /* cv.mulhhurn */, RISCV::CV_MULHHURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5689 /* cv.muls */, RISCV::CV_MULSN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5697 /* cv.mulsn */, RISCV::CV_MULSN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5706 /* cv.mulsrn */, RISCV::CV_MULSRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5716 /* cv.mulu */, RISCV::CV_MULUN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5724 /* cv.mulun */, RISCV::CV_MULUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5733 /* cv.mulurn */, RISCV::CV_MULURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5743 /* cv.or.b */, RISCV::CV_OR_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5751 /* cv.or.h */, RISCV::CV_OR_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5759 /* cv.or.sc.b */, RISCV::CV_OR_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5770 /* cv.or.sc.h */, RISCV::CV_OR_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5781 /* cv.or.sci.b */, RISCV::CV_OR_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5793 /* cv.or.sci.h */, RISCV::CV_OR_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5805 /* cv.pack */, RISCV::CV_PACK, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5813 /* cv.pack.h */, RISCV::CV_PACK_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5823 /* cv.packhi.b */, RISCV::CV_PACKHI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5835 /* cv.packlo.b */, RISCV::CV_PACKLO_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5847 /* cv.ror */, RISCV::CV_ROR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5854 /* cv.sb */, RISCV::CV_SB_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5854 /* cv.sb */, RISCV::CV_SB_rr_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5854 /* cv.sb */, RISCV::CV_SB_ri_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5860 /* cv.sdotsp.b */, RISCV::CV_SDOTSP_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5872 /* cv.sdotsp.h */, RISCV::CV_SDOTSP_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5884 /* cv.sdotsp.sc.b */, RISCV::CV_SDOTSP_SC_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5899 /* cv.sdotsp.sc.h */, RISCV::CV_SDOTSP_SC_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5914 /* cv.sdotsp.sci.b */, RISCV::CV_SDOTSP_SCI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5930 /* cv.sdotsp.sci.h */, RISCV::CV_SDOTSP_SCI_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5946 /* cv.sdotup.b */, RISCV::CV_SDOTUP_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5958 /* cv.sdotup.h */, RISCV::CV_SDOTUP_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5970 /* cv.sdotup.sc.b */, RISCV::CV_SDOTUP_SC_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5985 /* cv.sdotup.sc.h */, RISCV::CV_SDOTUP_SC_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6000 /* cv.sdotup.sci.b */, RISCV::CV_SDOTUP_SCI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6016 /* cv.sdotup.sci.h */, RISCV::CV_SDOTUP_SCI_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6032 /* cv.sdotusp.b */, RISCV::CV_SDOTUSP_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6045 /* cv.sdotusp.h */, RISCV::CV_SDOTUSP_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6058 /* cv.sdotusp.sc.b */, RISCV::CV_SDOTUSP_SC_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6074 /* cv.sdotusp.sc.h */, RISCV::CV_SDOTUSP_SC_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6090 /* cv.sdotusp.sci.b */, RISCV::CV_SDOTUSP_SCI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6107 /* cv.sdotusp.sci.h */, RISCV::CV_SDOTUSP_SCI_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6124 /* cv.sh */, RISCV::CV_SH_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 6124 /* cv.sh */, RISCV::CV_SH_rr_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 6124 /* cv.sh */, RISCV::CV_SH_ri_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 6130 /* cv.shuffle.b */, RISCV::CV_SHUFFLE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6143 /* cv.shuffle.h */, RISCV::CV_SHUFFLE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6156 /* cv.shuffle.sci.h */, RISCV::CV_SHUFFLE_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6173 /* cv.shuffle2.b */, RISCV::CV_SHUFFLE2_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6187 /* cv.shuffle2.h */, RISCV::CV_SHUFFLE2_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6201 /* cv.shufflei0.sci.b */, RISCV::CV_SHUFFLEI0_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6220 /* cv.shufflei1.sci.b */, RISCV::CV_SHUFFLEI1_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6239 /* cv.shufflei2.sci.b */, RISCV::CV_SHUFFLEI2_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6258 /* cv.shufflei3.sci.b */, RISCV::CV_SHUFFLEI3_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6277 /* cv.sle */, RISCV::CV_SLE, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6284 /* cv.sleu */, RISCV::CV_SLEU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6292 /* cv.sll.b */, RISCV::CV_SLL_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6301 /* cv.sll.h */, RISCV::CV_SLL_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6310 /* cv.sll.sc.b */, RISCV::CV_SLL_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6322 /* cv.sll.sc.h */, RISCV::CV_SLL_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6334 /* cv.sll.sci.b */, RISCV::CV_SLL_SCI_B, Convert__Reg1_0__Reg1_1__UImm31_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm3 }, },
  { 6347 /* cv.sll.sci.h */, RISCV::CV_SLL_SCI_H, Convert__Reg1_0__Reg1_1__UImm41_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm4 }, },
  { 6360 /* cv.sra.b */, RISCV::CV_SRA_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6369 /* cv.sra.h */, RISCV::CV_SRA_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6378 /* cv.sra.sc.b */, RISCV::CV_SRA_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6390 /* cv.sra.sc.h */, RISCV::CV_SRA_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6402 /* cv.sra.sci.b */, RISCV::CV_SRA_SCI_B, Convert__Reg1_0__Reg1_1__UImm31_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm3 }, },
  { 6415 /* cv.sra.sci.h */, RISCV::CV_SRA_SCI_H, Convert__Reg1_0__Reg1_1__UImm41_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm4 }, },
  { 6428 /* cv.srl.b */, RISCV::CV_SRL_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6437 /* cv.srl.h */, RISCV::CV_SRL_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6446 /* cv.srl.sc.b */, RISCV::CV_SRL_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6458 /* cv.srl.sc.h */, RISCV::CV_SRL_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6470 /* cv.srl.sci.b */, RISCV::CV_SRL_SCI_B, Convert__Reg1_0__Reg1_1__UImm31_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm3 }, },
  { 6483 /* cv.srl.sci.h */, RISCV::CV_SRL_SCI_H, Convert__Reg1_0__Reg1_1__UImm41_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm4 }, },
  { 6496 /* cv.sub.b */, RISCV::CV_SUB_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6505 /* cv.sub.div2 */, RISCV::CV_SUB_DIV2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6517 /* cv.sub.div4 */, RISCV::CV_SUB_DIV4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6529 /* cv.sub.div8 */, RISCV::CV_SUB_DIV8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6541 /* cv.sub.h */, RISCV::CV_SUB_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6550 /* cv.sub.sc.b */, RISCV::CV_SUB_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6562 /* cv.sub.sc.h */, RISCV::CV_SUB_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6574 /* cv.sub.sci.b */, RISCV::CV_SUB_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6587 /* cv.sub.sci.h */, RISCV::CV_SUB_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6600 /* cv.subn */, RISCV::CV_SUBN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 6608 /* cv.subnr */, RISCV::CV_SUBNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6617 /* cv.subrn */, RISCV::CV_SUBRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 6626 /* cv.subrnr */, RISCV::CV_SUBRNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6636 /* cv.subrotmj */, RISCV::CV_SUBROTMJ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6648 /* cv.subrotmj.div2 */, RISCV::CV_SUBROTMJ_DIV2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6665 /* cv.subrotmj.div4 */, RISCV::CV_SUBROTMJ_DIV4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6682 /* cv.subrotmj.div8 */, RISCV::CV_SUBROTMJ_DIV8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6699 /* cv.subun */, RISCV::CV_SUBUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 6708 /* cv.subunr */, RISCV::CV_SUBUNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6718 /* cv.suburn */, RISCV::CV_SUBURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 6728 /* cv.suburnr */, RISCV::CV_SUBURNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6739 /* cv.sw */, RISCV::CV_SW_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 6739 /* cv.sw */, RISCV::CV_SW_rr_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 6739 /* cv.sw */, RISCV::CV_SW_ri_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 6745 /* cv.xor.b */, RISCV::CV_XOR_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6754 /* cv.xor.h */, RISCV::CV_XOR_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6763 /* cv.xor.sc.b */, RISCV::CV_XOR_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6775 /* cv.xor.sc.h */, RISCV::CV_XOR_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6787 /* cv.xor.sci.b */, RISCV::CV_XOR_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6800 /* cv.xor.sci.h */, RISCV::CV_XOR_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6813 /* czero.eqz */, RISCV::CZERO_EQZ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZicond, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6823 /* czero.nez */, RISCV::CZERO_NEZ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZicond, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6833 /* div */, RISCV::DIV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6837 /* divu */, RISCV::DIVU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6842 /* divuw */, RISCV::DIVUW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6848 /* divw */, RISCV::DIVW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6853 /* dret */, RISCV::DRET, Convert_NoOperands, AMFBS_None, {  }, },
  { 6858 /* ebreak */, RISCV::EBREAK, Convert_NoOperands, AMFBS_None, {  }, },
  { 6865 /* ecall */, RISCV::ECALL, Convert_NoOperands, AMFBS_None, {  }, },
  { 6871 /* fabs.d */, RISCV::FSGNJX_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 6871 /* fabs.d */, RISCV::FSGNJX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6871 /* fabs.d */, RISCV::FSGNJX_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6878 /* fabs.h */, RISCV::FSGNJX_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 6878 /* fabs.h */, RISCV::FSGNJX_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 6885 /* fabs.q */, RISCV::FSGNJX_Q, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128 }, },
  { 6892 /* fabs.s */, RISCV::FSGNJX_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 6892 /* fabs.s */, RISCV::FSGNJX_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 6899 /* fadd.d */, RISCV::FADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 6899 /* fadd.d */, RISCV::FADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6899 /* fadd.d */, RISCV::FADD_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6906 /* fadd.h */, RISCV::FADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 6906 /* fadd.h */, RISCV::FADD_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 6913 /* fadd.q */, RISCV::FADD_Q, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FRMArg }, },
  { 6920 /* fadd.s */, RISCV::FADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 6920 /* fadd.s */, RISCV::FADD_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 6927 /* fclass.d */, RISCV::FCLASS_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64 }, },
  { 6927 /* fclass.d */, RISCV::FCLASS_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR }, },
  { 6927 /* fclass.d */, RISCV::FCLASS_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR }, },
  { 6936 /* fclass.h */, RISCV::FCLASS_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16 }, },
  { 6936 /* fclass.h */, RISCV::FCLASS_H_INX, Convert__Reg1_0__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16 }, },
  { 6945 /* fclass.q */, RISCV::FCLASS_Q, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtQ, { MCK_GPR, MCK_FPR128 }, },
  { 6954 /* fclass.s */, RISCV::FCLASS_S, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32 }, },
  { 6954 /* fclass.s */, RISCV::FCLASS_S_INX, Convert__Reg1_0__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32 }, },
  { 6963 /* fcvt.bf16.s */, RISCV::FCVT_BF16_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfbfmin, { MCK_FPR16, MCK_FPR32, MCK_FRMArg }, },
  { 6975 /* fcvt.d.h */, RISCV::FCVT_D_H, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZfhmin_HasStdExtD, { MCK_FPR64, MCK_FPR16, MCK_FRMArgLegacy }, },
  { 6975 /* fcvt.d.h */, RISCV::FCVT_D_H_INX, Convert__GPRF64AsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRAsFPR16, MCK_FRMArgLegacy }, },
  { 6975 /* fcvt.d.h */, RISCV::FCVT_D_H_IN32X, Convert__GPRPairAsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRAsFPR16, MCK_FRMArgLegacy }, },
  { 6984 /* fcvt.d.l */, RISCV::FCVT_D_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_FRMArg }, },
  { 6984 /* fcvt.d.l */, RISCV::FCVT_D_L_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArg }, },
  { 6993 /* fcvt.d.lu */, RISCV::FCVT_D_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_FRMArg }, },
  { 6993 /* fcvt.d.lu */, RISCV::FCVT_D_LU_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArg }, },
  { 7003 /* fcvt.d.q */, RISCV::FCVT_D_Q, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtQ, { MCK_FPR64, MCK_FPR128, MCK_FRMArg }, },
  { 7012 /* fcvt.d.s */, RISCV::FCVT_D_S, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR32, MCK_FRMArgLegacy }, },
  { 7012 /* fcvt.d.s */, RISCV::FCVT_D_S_INX, Convert__GPRF64AsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRAsFPR32, MCK_FRMArgLegacy }, },
  { 7012 /* fcvt.d.s */, RISCV::FCVT_D_S_IN32X, Convert__GPRPairAsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRAsFPR32, MCK_FRMArgLegacy }, },
  { 7021 /* fcvt.d.w */, RISCV::FCVT_D_W, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_FRMArgLegacy }, },
  { 7021 /* fcvt.d.w */, RISCV::FCVT_D_W_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 7021 /* fcvt.d.w */, RISCV::FCVT_D_W_IN32X, Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 7030 /* fcvt.d.wu */, RISCV::FCVT_D_WU, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_FRMArgLegacy }, },
  { 7030 /* fcvt.d.wu */, RISCV::FCVT_D_WU_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 7030 /* fcvt.d.wu */, RISCV::FCVT_D_WU_IN32X, Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 7040 /* fcvt.h.d */, RISCV::FCVT_H_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfhmin_HasStdExtD, { MCK_FPR16, MCK_FPR64, MCK_FRMArg }, },
  { 7040 /* fcvt.h.d */, RISCV::FCVT_H_D_INX, Convert__GPRAsFPR161_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64, { MCK_GPRAsFPR16, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7040 /* fcvt.h.d */, RISCV::FCVT_H_D_IN32X, Convert__GPRAsFPR161_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32, { MCK_GPRAsFPR16, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7049 /* fcvt.h.l */, RISCV::FCVT_H_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 7049 /* fcvt.h.l */, RISCV::FCVT_H_L_INX, Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPRAsFPR16, MCK_GPR, MCK_FRMArg }, },
  { 7058 /* fcvt.h.lu */, RISCV::FCVT_H_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 7058 /* fcvt.h.lu */, RISCV::FCVT_H_LU_INX, Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPRAsFPR16, MCK_GPR, MCK_FRMArg }, },
  { 7068 /* fcvt.h.s */, RISCV::FCVT_H_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfhmin, { MCK_FPR16, MCK_FPR32, MCK_FRMArg }, },
  { 7068 /* fcvt.h.s */, RISCV::FCVT_H_S_INX, Convert__GPRAsFPR161_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZhinxmin, { MCK_GPRAsFPR16, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7077 /* fcvt.h.w */, RISCV::FCVT_H_W, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 7077 /* fcvt.h.w */, RISCV::FCVT_H_W_INX, Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPR, MCK_FRMArg }, },
  { 7086 /* fcvt.h.wu */, RISCV::FCVT_H_WU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 7086 /* fcvt.h.wu */, RISCV::FCVT_H_WU_INX, Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPR, MCK_FRMArg }, },
  { 7096 /* fcvt.l.d */, RISCV::FCVT_L_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 7096 /* fcvt.l.d */, RISCV::FCVT_L_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7105 /* fcvt.l.h */, RISCV::FCVT_L_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 7105 /* fcvt.l.h */, RISCV::FCVT_L_H_INX, Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7114 /* fcvt.l.q */, RISCV::FCVT_L_Q, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtQ_IsRV64, { MCK_GPR, MCK_FPR128, MCK_FRMArg }, },
  { 7123 /* fcvt.l.s */, RISCV::FCVT_L_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 7123 /* fcvt.l.s */, RISCV::FCVT_L_S_INX, Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7132 /* fcvt.lu.d */, RISCV::FCVT_LU_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 7132 /* fcvt.lu.d */, RISCV::FCVT_LU_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7142 /* fcvt.lu.h */, RISCV::FCVT_LU_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 7142 /* fcvt.lu.h */, RISCV::FCVT_LU_H_INX, Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7152 /* fcvt.lu.q */, RISCV::FCVT_LU_Q, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtQ_IsRV64, { MCK_GPR, MCK_FPR128, MCK_FRMArg }, },
  { 7162 /* fcvt.lu.s */, RISCV::FCVT_LU_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 7162 /* fcvt.lu.s */, RISCV::FCVT_LU_S_INX, Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7172 /* fcvt.q.d */, RISCV::FCVT_Q_D, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR64, MCK_FRMArgLegacy }, },
  { 7181 /* fcvt.q.l */, RISCV::FCVT_Q_L, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtQ_IsRV64, { MCK_FPR128, MCK_GPR, MCK_FRMArgLegacy }, },
  { 7190 /* fcvt.q.lu */, RISCV::FCVT_Q_LU, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtQ_IsRV64, { MCK_FPR128, MCK_GPR, MCK_FRMArgLegacy }, },
  { 7200 /* fcvt.q.s */, RISCV::FCVT_Q_S, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR32, MCK_FRMArgLegacy }, },
  { 7209 /* fcvt.q.w */, RISCV::FCVT_Q_W, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_GPR, MCK_FRMArgLegacy }, },
  { 7218 /* fcvt.q.wu */, RISCV::FCVT_Q_WU, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_GPR, MCK_FRMArgLegacy }, },
  { 7228 /* fcvt.s.bf16 */, RISCV::FCVT_S_BF16, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZfbfmin, { MCK_FPR32, MCK_FPR16, MCK_FRMArgLegacy }, },
  { 7240 /* fcvt.s.d */, RISCV::FCVT_S_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_FPR32, MCK_FPR64, MCK_FRMArg }, },
  { 7240 /* fcvt.s.d */, RISCV::FCVT_S_D_INX, Convert__GPRAsFPR321_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRAsFPR32, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7240 /* fcvt.s.d */, RISCV::FCVT_S_D_IN32X, Convert__GPRAsFPR321_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRAsFPR32, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7249 /* fcvt.s.h */, RISCV::FCVT_S_H, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZfhmin, { MCK_FPR32, MCK_FPR16, MCK_FRMArgLegacy }, },
  { 7249 /* fcvt.s.h */, RISCV::FCVT_S_H_INX, Convert__GPRAsFPR321_0__GPRAsFPR161_1__FRMArgLegacy1_2, AMFBS_HasStdExtZhinxmin, { MCK_GPRAsFPR32, MCK_GPRAsFPR16, MCK_FRMArgLegacy }, },
  { 7258 /* fcvt.s.l */, RISCV::FCVT_S_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 7258 /* fcvt.s.l */, RISCV::FCVT_S_L_INX, Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPRAsFPR32, MCK_GPR, MCK_FRMArg }, },
  { 7267 /* fcvt.s.lu */, RISCV::FCVT_S_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 7267 /* fcvt.s.lu */, RISCV::FCVT_S_LU_INX, Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPRAsFPR32, MCK_GPR, MCK_FRMArg }, },
  { 7277 /* fcvt.s.q */, RISCV::FCVT_S_Q, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtQ, { MCK_FPR32, MCK_FPR128, MCK_FRMArg }, },
  { 7286 /* fcvt.s.w */, RISCV::FCVT_S_W, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 7286 /* fcvt.s.w */, RISCV::FCVT_S_W_INX, Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPR, MCK_FRMArg }, },
  { 7295 /* fcvt.s.wu */, RISCV::FCVT_S_WU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 7295 /* fcvt.s.wu */, RISCV::FCVT_S_WU_INX, Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPR, MCK_FRMArg }, },
  { 7305 /* fcvt.w.d */, RISCV::FCVT_W_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 7305 /* fcvt.w.d */, RISCV::FCVT_W_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7305 /* fcvt.w.d */, RISCV::FCVT_W_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7314 /* fcvt.w.h */, RISCV::FCVT_W_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 7314 /* fcvt.w.h */, RISCV::FCVT_W_H_INX, Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7323 /* fcvt.w.q */, RISCV::FCVT_W_Q, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtQ, { MCK_GPR, MCK_FPR128, MCK_FRMArg }, },
  { 7332 /* fcvt.w.s */, RISCV::FCVT_W_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 7332 /* fcvt.w.s */, RISCV::FCVT_W_S_INX, Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7341 /* fcvt.wu.d */, RISCV::FCVT_WU_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 7341 /* fcvt.wu.d */, RISCV::FCVT_WU_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7341 /* fcvt.wu.d */, RISCV::FCVT_WU_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7351 /* fcvt.wu.h */, RISCV::FCVT_WU_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 7351 /* fcvt.wu.h */, RISCV::FCVT_WU_H_INX, Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7361 /* fcvt.wu.q */, RISCV::FCVT_WU_Q, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtQ, { MCK_GPR, MCK_FPR128, MCK_FRMArg }, },
  { 7371 /* fcvt.wu.s */, RISCV::FCVT_WU_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 7371 /* fcvt.wu.s */, RISCV::FCVT_WU_S_INX, Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7381 /* fcvtmod.w.d */, RISCV::FCVTMOD_W_D, Convert__Reg1_0__Reg1_1__RTZArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_RTZArg }, },
  { 7393 /* fdiv.d */, RISCV::FDIV_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7393 /* fdiv.d */, RISCV::FDIV_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7393 /* fdiv.d */, RISCV::FDIV_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7400 /* fdiv.h */, RISCV::FDIV_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7400 /* fdiv.h */, RISCV::FDIV_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7407 /* fdiv.q */, RISCV::FDIV_Q, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FRMArg }, },
  { 7414 /* fdiv.s */, RISCV::FDIV_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7414 /* fdiv.s */, RISCV::FDIV_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7421 /* fence */, RISCV::FENCE, Convert__imm_95_15__imm_95_15, AMFBS_None, {  }, },
  { 7421 /* fence */, RISCV::FENCE, Convert__FenceArg1_0__FenceArg1_1, AMFBS_None, { MCK_FenceArg, MCK_FenceArg }, },
  { 7427 /* fence.i */, RISCV::FENCE_I, Convert_NoOperands, AMFBS_None, {  }, },
  { 7435 /* fence.tso */, RISCV::FENCE_TSO, Convert_NoOperands, AMFBS_None, {  }, },
  { 7445 /* feq.d */, RISCV::FEQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7445 /* feq.d */, RISCV::FEQ_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7445 /* feq.d */, RISCV::FEQ_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7451 /* feq.h */, RISCV::FEQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7451 /* feq.h */, RISCV::FEQ_H_INX, Convert__Reg1_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7457 /* feq.q */, RISCV::FEQ_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtQ, { MCK_GPR, MCK_FPR128, MCK_FPR128 }, },
  { 7463 /* feq.s */, RISCV::FEQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7463 /* feq.s */, RISCV::FEQ_S_INX, Convert__Reg1_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7469 /* fge.d */, RISCV::FLE_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7469 /* fge.d */, RISCV::FLE_D_INX, Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7469 /* fge.d */, RISCV::FLE_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7475 /* fge.h */, RISCV::FLE_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7475 /* fge.h */, RISCV::FLE_H_INX, Convert__Reg1_0__GPRAsFPR161_2__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7481 /* fge.q */, RISCV::FLE_Q, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtQ, { MCK_GPR, MCK_FPR128, MCK_FPR128 }, },
  { 7487 /* fge.s */, RISCV::FLE_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7487 /* fge.s */, RISCV::FLE_S_INX, Convert__Reg1_0__GPRAsFPR321_2__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7493 /* fgeq.d */, RISCV::FLEQ_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7500 /* fgeq.h */, RISCV::FLEQ_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7507 /* fgeq.q */, RISCV::FLEQ_Q, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtQ, { MCK_GPR, MCK_FPR128, MCK_FPR128 }, },
  { 7514 /* fgeq.s */, RISCV::FLEQ_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7521 /* fgt.d */, RISCV::FLT_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7521 /* fgt.d */, RISCV::FLT_D_INX, Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7521 /* fgt.d */, RISCV::FLT_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7527 /* fgt.h */, RISCV::FLT_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7527 /* fgt.h */, RISCV::FLT_H_INX, Convert__Reg1_0__GPRAsFPR161_2__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7533 /* fgt.q */, RISCV::FLT_Q, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtQ, { MCK_GPR, MCK_FPR128, MCK_FPR128 }, },
  { 7539 /* fgt.s */, RISCV::FLT_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7539 /* fgt.s */, RISCV::FLT_S_INX, Convert__Reg1_0__GPRAsFPR321_2__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7545 /* fgtq.d */, RISCV::FLTQ_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7552 /* fgtq.h */, RISCV::FLTQ_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7559 /* fgtq.q */, RISCV::FLTQ_Q, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtQ, { MCK_GPR, MCK_FPR128, MCK_FPR128 }, },
  { 7566 /* fgtq.s */, RISCV::FLTQ_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7573 /* fld */, RISCV::PseudoFLD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_BareSymbol, MCK_GPR }, },
  { 7573 /* fld */, RISCV::FLD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7573 /* fld */, RISCV::FLD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7577 /* fle.d */, RISCV::FLE_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7577 /* fle.d */, RISCV::FLE_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7577 /* fle.d */, RISCV::FLE_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7583 /* fle.h */, RISCV::FLE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7583 /* fle.h */, RISCV::FLE_H_INX, Convert__Reg1_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7589 /* fle.q */, RISCV::FLE_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtQ, { MCK_GPR, MCK_FPR128, MCK_FPR128 }, },
  { 7595 /* fle.s */, RISCV::FLE_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7595 /* fle.s */, RISCV::FLE_S_INX, Convert__Reg1_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7601 /* fleq.d */, RISCV::FLEQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7608 /* fleq.h */, RISCV::FLEQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7615 /* fleq.q */, RISCV::FLEQ_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtQ, { MCK_GPR, MCK_FPR128, MCK_FPR128 }, },
  { 7622 /* fleq.s */, RISCV::FLEQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7629 /* flh */, RISCV::PseudoFLH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_BareSymbol, MCK_GPR }, },
  { 7629 /* flh */, RISCV::FLH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7629 /* flh */, RISCV::FLH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7633 /* fli.d */, RISCV::FLI_D, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_LoadFPImm }, },
  { 7639 /* fli.h */, RISCV::FLI_H, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh, { MCK_FPR16, MCK_LoadFPImm }, },
  { 7645 /* fli.q */, RISCV::FLI_Q, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa_HasStdExtQ, { MCK_FPR128, MCK_LoadFPImm }, },
  { 7651 /* fli.s */, RISCV::FLI_S, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_LoadFPImm }, },
  { 7657 /* flq */, RISCV::PseudoFLQ, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_BareSymbol, MCK_GPR }, },
  { 7657 /* flq */, RISCV::FLQ, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtQ, { MCK_FPR128, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7657 /* flq */, RISCV::FLQ, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7661 /* flt.d */, RISCV::FLT_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7661 /* flt.d */, RISCV::FLT_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7661 /* flt.d */, RISCV::FLT_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7667 /* flt.h */, RISCV::FLT_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7667 /* flt.h */, RISCV::FLT_H_INX, Convert__Reg1_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7673 /* flt.q */, RISCV::FLT_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtQ, { MCK_GPR, MCK_FPR128, MCK_FPR128 }, },
  { 7679 /* flt.s */, RISCV::FLT_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7679 /* flt.s */, RISCV::FLT_S_INX, Convert__Reg1_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7685 /* fltq.d */, RISCV::FLTQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7692 /* fltq.h */, RISCV::FLTQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7699 /* fltq.q */, RISCV::FLTQ_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtQ, { MCK_GPR, MCK_FPR128, MCK_FPR128 }, },
  { 7706 /* fltq.s */, RISCV::FLTQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7713 /* flw */, RISCV::PseudoFLW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_BareSymbol, MCK_GPR }, },
  { 7713 /* flw */, RISCV::FLW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtF, { MCK_FPR32, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7713 /* flw */, RISCV::FLW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7717 /* fmadd.d */, RISCV::FMADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7717 /* fmadd.d */, RISCV::FMADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7717 /* fmadd.d */, RISCV::FMADD_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7725 /* fmadd.h */, RISCV::FMADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7725 /* fmadd.h */, RISCV::FMADD_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7733 /* fmadd.q */, RISCV::FMADD_Q, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FRMArg }, },
  { 7741 /* fmadd.s */, RISCV::FMADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7741 /* fmadd.s */, RISCV::FMADD_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7749 /* fmax.d */, RISCV::FMAX_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 7749 /* fmax.d */, RISCV::FMAX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7749 /* fmax.d */, RISCV::FMAX_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7756 /* fmax.h */, RISCV::FMAX_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 7756 /* fmax.h */, RISCV::FMAX_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7763 /* fmax.q */, RISCV::FMAX_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128 }, },
  { 7770 /* fmax.s */, RISCV::FMAX_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 7770 /* fmax.s */, RISCV::FMAX_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7777 /* fmaxm.d */, RISCV::FMAXM_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 7785 /* fmaxm.h */, RISCV::FMAXM_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 7793 /* fmaxm.q */, RISCV::FMAXM_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128 }, },
  { 7801 /* fmaxm.s */, RISCV::FMAXM_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 7809 /* fmin.d */, RISCV::FMIN_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 7809 /* fmin.d */, RISCV::FMIN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7809 /* fmin.d */, RISCV::FMIN_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7816 /* fmin.h */, RISCV::FMIN_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 7816 /* fmin.h */, RISCV::FMIN_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7823 /* fmin.q */, RISCV::FMIN_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128 }, },
  { 7830 /* fmin.s */, RISCV::FMIN_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 7830 /* fmin.s */, RISCV::FMIN_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7837 /* fminm.d */, RISCV::FMINM_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 7845 /* fminm.h */, RISCV::FMINM_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 7853 /* fminm.q */, RISCV::FMINM_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128 }, },
  { 7861 /* fminm.s */, RISCV::FMINM_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 7869 /* fmsub.d */, RISCV::FMSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7869 /* fmsub.d */, RISCV::FMSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7869 /* fmsub.d */, RISCV::FMSUB_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7877 /* fmsub.h */, RISCV::FMSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7877 /* fmsub.h */, RISCV::FMSUB_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7885 /* fmsub.q */, RISCV::FMSUB_Q, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FRMArg }, },
  { 7893 /* fmsub.s */, RISCV::FMSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7893 /* fmsub.s */, RISCV::FMSUB_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7901 /* fmul.d */, RISCV::FMUL_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7901 /* fmul.d */, RISCV::FMUL_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7901 /* fmul.d */, RISCV::FMUL_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7908 /* fmul.h */, RISCV::FMUL_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7908 /* fmul.h */, RISCV::FMUL_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7915 /* fmul.q */, RISCV::FMUL_Q, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FRMArg }, },
  { 7922 /* fmul.s */, RISCV::FMUL_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7922 /* fmul.s */, RISCV::FMUL_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7929 /* fmv.d */, RISCV::FSGNJ_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 7929 /* fmv.d */, RISCV::FSGNJ_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7929 /* fmv.d */, RISCV::FSGNJ_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7935 /* fmv.d.x */, RISCV::FMV_D_X, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR }, },
  { 7943 /* fmv.h */, RISCV::FSGNJ_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 7943 /* fmv.h */, RISCV::FSGNJ_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7949 /* fmv.h.x */, RISCV::FMV_H_X, Convert__Reg1_0__Reg1_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_GPR }, },
  { 7957 /* fmv.q */, RISCV::FSGNJ_Q, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128 }, },
  { 7963 /* fmv.s */, RISCV::FSGNJ_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 7963 /* fmv.s */, RISCV::FSGNJ_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7969 /* fmv.w.x */, RISCV::FMV_W_X, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR }, },
  { 7977 /* fmv.x.d */, RISCV::FMV_X_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64 }, },
  { 7985 /* fmv.x.h */, RISCV::FMV_X_H, Convert__Reg1_0__Reg1_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_GPR, MCK_FPR16 }, },
  { 7993 /* fmv.x.w */, RISCV::FMV_X_W, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32 }, },
  { 8001 /* fmvh.x.d */, RISCV::FMVH_X_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD_IsRV32, { MCK_GPR, MCK_FPR64 }, },
  { 8010 /* fmvh.x.q */, RISCV::FMVH_X_Q, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtQ_IsRV64, { MCK_GPR, MCK_FPR128 }, },
  { 8019 /* fmvp.d.x */, RISCV::FMVP_D_X, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD_IsRV32, { MCK_FPR64, MCK_GPR, MCK_GPR }, },
  { 8028 /* fmvp.q.x */, RISCV::FMVP_Q_X, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtQ_IsRV64, { MCK_FPR128, MCK_GPR, MCK_GPR }, },
  { 8037 /* fneg.d */, RISCV::FSGNJN_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 8037 /* fneg.d */, RISCV::FSGNJN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 8037 /* fneg.d */, RISCV::FSGNJN_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 8044 /* fneg.h */, RISCV::FSGNJN_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 8044 /* fneg.h */, RISCV::FSGNJN_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 8051 /* fneg.q */, RISCV::FSGNJN_Q, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128 }, },
  { 8058 /* fneg.s */, RISCV::FSGNJN_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 8058 /* fneg.s */, RISCV::FSGNJN_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 8065 /* fnmadd.d */, RISCV::FNMADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 8065 /* fnmadd.d */, RISCV::FNMADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 8065 /* fnmadd.d */, RISCV::FNMADD_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 8074 /* fnmadd.h */, RISCV::FNMADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 8074 /* fnmadd.h */, RISCV::FNMADD_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 8083 /* fnmadd.q */, RISCV::FNMADD_Q, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FRMArg }, },
  { 8092 /* fnmadd.s */, RISCV::FNMADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 8092 /* fnmadd.s */, RISCV::FNMADD_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 8101 /* fnmsub.d */, RISCV::FNMSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 8101 /* fnmsub.d */, RISCV::FNMSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 8101 /* fnmsub.d */, RISCV::FNMSUB_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 8110 /* fnmsub.h */, RISCV::FNMSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 8110 /* fnmsub.h */, RISCV::FNMSUB_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 8119 /* fnmsub.q */, RISCV::FNMSUB_Q, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FRMArg }, },
  { 8128 /* fnmsub.s */, RISCV::FNMSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 8128 /* fnmsub.s */, RISCV::FNMSUB_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 8137 /* frcsr */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3__regX0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 8143 /* frflags */, RISCV::CSRRS, Convert__Reg1_0__imm_95_1__regX0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 8151 /* fround.d */, RISCV::FROUND_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 8160 /* fround.h */, RISCV::FROUND_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 8169 /* fround.q */, RISCV::FROUND_Q, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FRMArg }, },
  { 8178 /* fround.s */, RISCV::FROUND_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 8187 /* froundnx.d */, RISCV::FROUNDNX_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 8198 /* froundnx.h */, RISCV::FROUNDNX_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 8209 /* froundnx.q */, RISCV::FROUNDNX_Q, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FRMArg }, },
  { 8220 /* froundnx.s */, RISCV::FROUNDNX_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 8231 /* frrm */, RISCV::CSRRS, Convert__Reg1_0__imm_95_2__regX0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 8236 /* fscsr */, RISCV::CSRRW, Convert__regX0__imm_95_3__Reg1_0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 8236 /* fscsr */, RISCV::CSRRW, Convert__Reg1_0__imm_95_3__Reg1_1, AMFBS_HasStdExtFOrZfinx, { MCK_GPR, MCK_GPR }, },
  { 8242 /* fsd */, RISCV::PseudoFSD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_BareSymbol, MCK_GPR }, },
  { 8242 /* fsd */, RISCV::FSD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8242 /* fsd */, RISCV::FSD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8246 /* fsflags */, RISCV::CSRRW, Convert__regX0__imm_95_1__Reg1_0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 8246 /* fsflags */, RISCV::CSRRW, Convert__Reg1_0__imm_95_1__Reg1_1, AMFBS_HasStdExtFOrZfinx, { MCK_GPR, MCK_GPR }, },
  { 8254 /* fsflagsi */, RISCV::CSRRWI, Convert__regX0__imm_95_1__UImm51_0, AMFBS_HasStdExtFOrZfinx, { MCK_UImm5 }, },
  { 8254 /* fsflagsi */, RISCV::CSRRWI, Convert__Reg1_0__imm_95_1__UImm51_1, AMFBS_HasStdExtFOrZfinx, { MCK_GPR, MCK_UImm5 }, },
  { 8263 /* fsgnj.d */, RISCV::FSGNJ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 8263 /* fsgnj.d */, RISCV::FSGNJ_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 8263 /* fsgnj.d */, RISCV::FSGNJ_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 8271 /* fsgnj.h */, RISCV::FSGNJ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 8271 /* fsgnj.h */, RISCV::FSGNJ_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 8279 /* fsgnj.q */, RISCV::FSGNJ_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128 }, },
  { 8287 /* fsgnj.s */, RISCV::FSGNJ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 8287 /* fsgnj.s */, RISCV::FSGNJ_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 8295 /* fsgnjn.d */, RISCV::FSGNJN_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 8295 /* fsgnjn.d */, RISCV::FSGNJN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 8295 /* fsgnjn.d */, RISCV::FSGNJN_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 8304 /* fsgnjn.h */, RISCV::FSGNJN_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 8304 /* fsgnjn.h */, RISCV::FSGNJN_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 8313 /* fsgnjn.q */, RISCV::FSGNJN_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128 }, },
  { 8322 /* fsgnjn.s */, RISCV::FSGNJN_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 8322 /* fsgnjn.s */, RISCV::FSGNJN_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 8331 /* fsgnjx.d */, RISCV::FSGNJX_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 8331 /* fsgnjx.d */, RISCV::FSGNJX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 8331 /* fsgnjx.d */, RISCV::FSGNJX_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 8340 /* fsgnjx.h */, RISCV::FSGNJX_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 8340 /* fsgnjx.h */, RISCV::FSGNJX_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 8349 /* fsgnjx.q */, RISCV::FSGNJX_Q, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128 }, },
  { 8358 /* fsgnjx.s */, RISCV::FSGNJX_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 8358 /* fsgnjx.s */, RISCV::FSGNJX_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 8367 /* fsh */, RISCV::PseudoFSH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_BareSymbol, MCK_GPR }, },
  { 8367 /* fsh */, RISCV::FSH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8367 /* fsh */, RISCV::FSH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8371 /* fsq */, RISCV::PseudoFSQ, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_BareSymbol, MCK_GPR }, },
  { 8371 /* fsq */, RISCV::FSQ, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtQ, { MCK_FPR128, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8371 /* fsq */, RISCV::FSQ, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8375 /* fsqrt.d */, RISCV::FSQRT_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 8375 /* fsqrt.d */, RISCV::FSQRT_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 8375 /* fsqrt.d */, RISCV::FSQRT_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 8383 /* fsqrt.h */, RISCV::FSQRT_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 8383 /* fsqrt.h */, RISCV::FSQRT_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 8391 /* fsqrt.q */, RISCV::FSQRT_Q, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FRMArg }, },
  { 8399 /* fsqrt.s */, RISCV::FSQRT_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 8399 /* fsqrt.s */, RISCV::FSQRT_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 8407 /* fsrm */, RISCV::CSRRW, Convert__regX0__imm_95_2__Reg1_0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 8407 /* fsrm */, RISCV::CSRRW, Convert__Reg1_0__imm_95_2__Reg1_1, AMFBS_HasStdExtFOrZfinx, { MCK_GPR, MCK_GPR }, },
  { 8412 /* fsrmi */, RISCV::CSRRWI, Convert__regX0__imm_95_2__UImm51_0, AMFBS_HasStdExtFOrZfinx, { MCK_UImm5 }, },
  { 8412 /* fsrmi */, RISCV::CSRRWI, Convert__Reg1_0__imm_95_2__UImm51_1, AMFBS_HasStdExtFOrZfinx, { MCK_GPR, MCK_UImm5 }, },
  { 8418 /* fsub.d */, RISCV::FSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 8418 /* fsub.d */, RISCV::FSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 8418 /* fsub.d */, RISCV::FSUB_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 8425 /* fsub.h */, RISCV::FSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 8425 /* fsub.h */, RISCV::FSUB_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 8432 /* fsub.q */, RISCV::FSUB_Q, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtQ, { MCK_FPR128, MCK_FPR128, MCK_FPR128, MCK_FRMArg }, },
  { 8439 /* fsub.s */, RISCV::FSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 8439 /* fsub.s */, RISCV::FSUB_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 8446 /* fsw */, RISCV::PseudoFSW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_BareSymbol, MCK_GPR }, },
  { 8446 /* fsw */, RISCV::FSW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtF, { MCK_FPR32, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8446 /* fsw */, RISCV::FSW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8450 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 8450 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 8450 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_GPR }, },
  { 8462 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 8462 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 8462 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_GPR }, },
  { 8474 /* hinval.gvma */, RISCV::HINVAL_GVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 8486 /* hinval.vvma */, RISCV::HINVAL_VVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 8498 /* hlv.b */, RISCV::HLV_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8504 /* hlv.bu */, RISCV::HLV_BU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8511 /* hlv.d */, RISCV::HLV_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8517 /* hlv.h */, RISCV::HLV_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8523 /* hlv.hu */, RISCV::HLV_HU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8530 /* hlv.w */, RISCV::HLV_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8536 /* hlv.wu */, RISCV::HLV_WU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8543 /* hlvx.hu */, RISCV::HLVX_HU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8551 /* hlvx.wu */, RISCV::HLVX_WU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8559 /* hsv.b */, RISCV::HSV_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8565 /* hsv.d */, RISCV::HSV_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8571 /* hsv.h */, RISCV::HSV_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8577 /* hsv.w */, RISCV::HSV_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8583 /* j */, RISCV::JAL, Convert__regX0__BareSImm21Lsb01_0, AMFBS_None, { MCK_BareSImm21Lsb0 }, },
  { 8585 /* jal */, RISCV::JAL, Convert__regX1__BareSImm21Lsb01_0, AMFBS_None, { MCK_BareSImm21Lsb0 }, },
  { 8585 /* jal */, RISCV::JAL, Convert__Reg1_0__BareSImm21Lsb01_1, AMFBS_None, { MCK_GPR, MCK_BareSImm21Lsb0 }, },
  { 8589 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_0__imm_95_0, AMFBS_None, { MCK_GPR }, },
  { 8589 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8589 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 8589 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_1__imm_95_0, AMFBS_None, { MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8589 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 8589 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8589 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_2__SImm121_0, AMFBS_None, { MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8589 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8589 /* jalr */, RISCV::PseudoTLSDESCCall, Convert__Reg1_0__Reg1_3__SImm121_1__TLSDESCCallSymbol1_5, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_, MCK_TLSDESCCallSymbol }, },
  { 8594 /* jr */, RISCV::JALR, Convert__regX0__Reg1_0__imm_95_0, AMFBS_None, { MCK_GPR }, },
  { 8594 /* jr */, RISCV::JALR, Convert__regX0__Reg1_0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 8594 /* jr */, RISCV::JALR, Convert__regX0__Reg1_1__imm_95_0, AMFBS_None, { MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8594 /* jr */, RISCV::JALR, Convert__regX0__Reg1_2__SImm121_0, AMFBS_None, { MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8597 /* jump */, RISCV::PseudoJump, Convert__Reg1_1__PseudoJumpSymbol1_0, AMFBS_None, { MCK_PseudoJumpSymbol, MCK_GPR }, },
  { 8602 /* la */, RISCV::PseudoLA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8602 /* la */, RISCV::PseudoLAImm, Convert__Reg1_0__ImmXLenLI_Restricted1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI_Restricted }, },
  { 8605 /* la.tls.gd */, RISCV::PseudoLA_TLS_GD, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8615 /* la.tls.ie */, RISCV::PseudoLA_TLS_IE, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8625 /* la.tlsdesc */, RISCV::PseudoLA_TLSDESC, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8636 /* lb */, RISCV::PseudoLB, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8636 /* lb */, RISCV::LB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8636 /* lb */, RISCV::LB, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8639 /* lb.aq */, RISCV::LB_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8645 /* lb.aqrl */, RISCV::LB_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8653 /* lbu */, RISCV::PseudoLBU, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8653 /* lbu */, RISCV::LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8653 /* lbu */, RISCV::LBU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8657 /* ld */, RISCV::PseudoLD, Convert__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol }, },
  { 8657 /* ld */, RISCV::PseudoLD_RV32, Convert__GPRPairRV321_0__BareSymbol1_1, AMFBS_HasStdExtZilsd_IsRV32, { MCK_GPRPairRV32, MCK_BareSymbol }, },
  { 8657 /* ld */, RISCV::LD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8657 /* ld */, RISCV::LD_RV32, Convert__GPRPairRV321_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZilsd_IsRV32, { MCK_GPRPairRV32, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8657 /* ld */, RISCV::LD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8657 /* ld */, RISCV::LD_RV32, Convert__GPRPairRV321_0__Reg1_3__SImm121_1, AMFBS_HasStdExtZilsd_IsRV32, { MCK_GPRPairRV32, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8660 /* ld.aq */, RISCV::LD_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8666 /* ld.aqrl */, RISCV::LD_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8674 /* lga */, RISCV::PseudoLGA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8678 /* lh */, RISCV::PseudoLH, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8678 /* lh */, RISCV::LH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8678 /* lh */, RISCV::LH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8681 /* lh.aq */, RISCV::LH_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8687 /* lh.aqrl */, RISCV::LH_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8695 /* lhu */, RISCV::PseudoLHU, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8695 /* lhu */, RISCV::LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8695 /* lhu */, RISCV::LHU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8699 /* li */, RISCV::ADDI, Convert__Reg1_0__regX0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 8699 /* li */, RISCV::PseudoLI, Convert__Reg1_0__ImmXLenLI1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI }, },
  { 8702 /* lla */, RISCV::PseudoLLA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8702 /* lla */, RISCV::PseudoLLAImm, Convert__Reg1_0__ImmXLenLI_Restricted1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI_Restricted }, },
  { 8706 /* lpad */, RISCV::AUIPC, Convert__regX0__UImm201_0, AMFBS_HasStdExtZicfilp, { MCK_UImm20 }, },
  { 8711 /* lr.d */, RISCV::LR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8716 /* lr.d.aq */, RISCV::LR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8724 /* lr.d.aqrl */, RISCV::LR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8734 /* lr.d.rl */, RISCV::LR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8742 /* lr.w */, RISCV::LR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8747 /* lr.w.aq */, RISCV::LR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8755 /* lr.w.aqrl */, RISCV::LR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8765 /* lr.w.rl */, RISCV::LR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8773 /* lui */, RISCV::LUI, Convert__Reg1_0__UImm20LUI1_1, AMFBS_None, { MCK_GPR, MCK_UImm20LUI }, },
  { 8777 /* lw */, RISCV::PseudoLW, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8777 /* lw */, RISCV::LW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8777 /* lw */, RISCV::LW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8780 /* lw.aq */, RISCV::LW_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8786 /* lw.aqrl */, RISCV::LW_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8794 /* lwu */, RISCV::PseudoLWU, Convert__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol }, },
  { 8794 /* lwu */, RISCV::LWU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8794 /* lwu */, RISCV::LWU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8798 /* max */, RISCV::MAX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrP, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8802 /* maxu */, RISCV::MAXU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrP, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8807 /* min */, RISCV::MIN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrP, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8811 /* minu */, RISCV::MINU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrP, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8816 /* mips.ccmov */, RISCV::MIPS_CCMOV, Convert__Reg1_0__Reg1_2__Reg1_1__Reg1_3, AMFBS_HasVendorXMIPSCMov, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8827 /* mips.ldp */, RISCV::MIPS_LDP, Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb0001_2, AMFBS_HasVendorXMIPSLSP, { MCK_GPR, MCK_GPR, MCK_UImm7Lsb000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8836 /* mips.lwp */, RISCV::MIPS_LWP, Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb001_2, AMFBS_HasVendorXMIPSLSP, { MCK_GPR, MCK_GPR, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8845 /* mips.pref */, RISCV::MIPS_PREFETCH, Convert__Reg1_3__UImm91_1__UImm51_0, AMFBS_HasVendorXMIPSCBOP, { MCK_UImm5, MCK_UImm9, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8855 /* mips.sdp */, RISCV::MIPS_SDP, Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb0001_2, AMFBS_HasVendorXMIPSLSP, { MCK_GPR, MCK_GPR, MCK_UImm7Lsb000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8864 /* mips.swp */, RISCV::MIPS_SWP, Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb001_2, AMFBS_HasVendorXMIPSLSP, { MCK_GPR, MCK_GPR, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8873 /* mnret */, RISCV::MNRET, Convert_NoOperands, AMFBS_HasStdExtSmrnmi, {  }, },
  { 8879 /* mop.r.0 */, RISCV::MOPR0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8887 /* mop.r.1 */, RISCV::MOPR1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8895 /* mop.r.10 */, RISCV::MOPR10, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8904 /* mop.r.11 */, RISCV::MOPR11, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8913 /* mop.r.12 */, RISCV::MOPR12, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8922 /* mop.r.13 */, RISCV::MOPR13, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8931 /* mop.r.14 */, RISCV::MOPR14, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8940 /* mop.r.15 */, RISCV::MOPR15, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8949 /* mop.r.16 */, RISCV::MOPR16, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8958 /* mop.r.17 */, RISCV::MOPR17, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8967 /* mop.r.18 */, RISCV::MOPR18, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8976 /* mop.r.19 */, RISCV::MOPR19, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8985 /* mop.r.2 */, RISCV::MOPR2, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8993 /* mop.r.20 */, RISCV::MOPR20, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9002 /* mop.r.21 */, RISCV::MOPR21, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9011 /* mop.r.22 */, RISCV::MOPR22, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9020 /* mop.r.23 */, RISCV::MOPR23, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9029 /* mop.r.24 */, RISCV::MOPR24, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9038 /* mop.r.25 */, RISCV::MOPR25, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9047 /* mop.r.26 */, RISCV::MOPR26, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9056 /* mop.r.27 */, RISCV::MOPR27, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9065 /* mop.r.28 */, RISCV::MOPR28, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9074 /* mop.r.29 */, RISCV::MOPR29, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9083 /* mop.r.3 */, RISCV::MOPR3, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9091 /* mop.r.30 */, RISCV::MOPR30, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9100 /* mop.r.31 */, RISCV::MOPR31, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9109 /* mop.r.4 */, RISCV::MOPR4, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9117 /* mop.r.5 */, RISCV::MOPR5, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9125 /* mop.r.6 */, RISCV::MOPR6, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9133 /* mop.r.7 */, RISCV::MOPR7, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9141 /* mop.r.8 */, RISCV::MOPR8, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9149 /* mop.r.9 */, RISCV::MOPR9, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 9157 /* mop.rr.0 */, RISCV::MOPRR0, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9166 /* mop.rr.1 */, RISCV::MOPRR1, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9175 /* mop.rr.2 */, RISCV::MOPRR2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9184 /* mop.rr.3 */, RISCV::MOPRR3, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9193 /* mop.rr.4 */, RISCV::MOPRR4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9202 /* mop.rr.5 */, RISCV::MOPRR5, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9211 /* mop.rr.6 */, RISCV::MOPRR6, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9220 /* mop.rr.7 */, RISCV::MOPRR7, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9229 /* mret */, RISCV::MRET, Convert_NoOperands, AMFBS_None, {  }, },
  { 9234 /* mul */, RISCV::MUL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9238 /* mulh */, RISCV::MULH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9243 /* mulhsu */, RISCV::MULHSU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9250 /* mulhu */, RISCV::MULHU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9256 /* mulw */, RISCV::MULW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZmmul_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9261 /* mv */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 9264 /* nds.addigp */, RISCV::NDS_ADDIGP, Convert__Reg1_0__SImm181_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_SImm18 }, },
  { 9275 /* nds.bbc */, RISCV::NDS_BBC, Convert__Reg1_0__UImmLog2XLen1_1__BareSImm11Lsb01_2, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_UImmLog2XLen, MCK_BareSImm11Lsb0 }, },
  { 9283 /* nds.bbs */, RISCV::NDS_BBS, Convert__Reg1_0__UImmLog2XLen1_1__BareSImm11Lsb01_2, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_UImmLog2XLen, MCK_BareSImm11Lsb0 }, },
  { 9291 /* nds.beqc */, RISCV::NDS_BEQC, Convert__Reg1_0__UImm71_1__BareSImm11Lsb01_2, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_UImm7, MCK_BareSImm11Lsb0 }, },
  { 9300 /* nds.bfos */, RISCV::NDS_BFOS, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen, MCK_UImmLog2XLen }, },
  { 9309 /* nds.bfoz */, RISCV::NDS_BFOZ, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen, MCK_UImmLog2XLen }, },
  { 9318 /* nds.bnec */, RISCV::NDS_BNEC, Convert__Reg1_0__UImm71_1__BareSImm11Lsb01_2, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_UImm7, MCK_BareSImm11Lsb0 }, },
  { 9327 /* nds.fcvt.bf16.s */, RISCV::NDS_FCVT_BF16_S, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXAndesBFHCvt, { MCK_FPR16, MCK_FPR32 }, },
  { 9343 /* nds.fcvt.s.bf16 */, RISCV::NDS_FCVT_S_BF16, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXAndesBFHCvt, { MCK_FPR32, MCK_FPR16 }, },
  { 9359 /* nds.ffb */, RISCV::NDS_FFB, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9367 /* nds.ffmism */, RISCV::NDS_FFMISM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9378 /* nds.ffzmism */, RISCV::NDS_FFZMISM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9390 /* nds.flmism */, RISCV::NDS_FLMISM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9401 /* nds.lbgp */, RISCV::NDS_LBGP, Convert__Reg1_0__SImm181_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_SImm18 }, },
  { 9410 /* nds.lbugp */, RISCV::NDS_LBUGP, Convert__Reg1_0__SImm181_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_SImm18 }, },
  { 9420 /* nds.ldgp */, RISCV::NDS_LDGP, Convert__Reg1_0__SImm20Lsb0001_1, AMFBS_HasVendorXAndesPerf_IsRV64, { MCK_GPR, MCK_SImm20Lsb000 }, },
  { 9429 /* nds.lea.b.ze */, RISCV::NDS_LEA_B_ZE, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasVendorXAndesPerf_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9442 /* nds.lea.d */, RISCV::NDS_LEA_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9452 /* nds.lea.d.ze */, RISCV::NDS_LEA_D_ZE, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasVendorXAndesPerf_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9465 /* nds.lea.h */, RISCV::NDS_LEA_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9475 /* nds.lea.h.ze */, RISCV::NDS_LEA_H_ZE, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasVendorXAndesPerf_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9488 /* nds.lea.w */, RISCV::NDS_LEA_W, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9498 /* nds.lea.w.ze */, RISCV::NDS_LEA_W_ZE, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasVendorXAndesPerf_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9511 /* nds.lhgp */, RISCV::NDS_LHGP, Convert__Reg1_0__SImm18Lsb01_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_SImm18Lsb0 }, },
  { 9520 /* nds.lhugp */, RISCV::NDS_LHUGP, Convert__Reg1_0__SImm18Lsb01_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_SImm18Lsb0 }, },
  { 9530 /* nds.lwgp */, RISCV::NDS_LWGP, Convert__Reg1_0__SImm19Lsb001_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_SImm19Lsb00 }, },
  { 9539 /* nds.lwugp */, RISCV::NDS_LWUGP, Convert__Reg1_0__SImm19Lsb001_1, AMFBS_HasVendorXAndesPerf_IsRV64, { MCK_GPR, MCK_SImm19Lsb00 }, },
  { 9549 /* nds.sbgp */, RISCV::NDS_SBGP, Convert__Reg1_0__SImm181_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_SImm18 }, },
  { 9558 /* nds.sdgp */, RISCV::NDS_SDGP, Convert__Reg1_0__SImm20Lsb0001_1, AMFBS_HasVendorXAndesPerf_IsRV64, { MCK_GPR, MCK_SImm20Lsb000 }, },
  { 9567 /* nds.shgp */, RISCV::NDS_SHGP, Convert__Reg1_0__SImm18Lsb01_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_SImm18Lsb0 }, },
  { 9576 /* nds.swgp */, RISCV::NDS_SWGP, Convert__Reg1_0__SImm19Lsb001_1, AMFBS_HasVendorXAndesPerf, { MCK_GPR, MCK_SImm19Lsb00 }, },
  { 9585 /* nds.vd4dots.vv */, RISCV::NDS_VD4DOTS_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXAndesVDot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9600 /* nds.vd4dotsu.vv */, RISCV::NDS_VD4DOTSU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXAndesVDot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9616 /* nds.vd4dotu.vv */, RISCV::NDS_VD4DOTU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXAndesVDot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9631 /* nds.vfncvt.bf16.s */, RISCV::NDS_VFNCVT_BF16_S, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_HasVendorXAndesVBFHCvt, { MCK_VM, MCK_VM }, },
  { 9649 /* nds.vfpmadb.vf */, RISCV::NDS_VFPMADB_VF, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXAndesVPackFPH, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9664 /* nds.vfpmadt.vf */, RISCV::NDS_VFPMADT_VF, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXAndesVPackFPH, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9679 /* nds.vfwcvt.s.bf16 */, RISCV::NDS_VFWCVT_S_BF16, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_HasVendorXAndesVBFHCvt, { MCK_VM, MCK_VM }, },
  { 9697 /* nds.vln8.v */, RISCV::NDS_VLN8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVendorXAndesVSIntLoad, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9708 /* nds.vlnu8.v */, RISCV::NDS_VLNU8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVendorXAndesVSIntLoad, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9720 /* neg */, RISCV::SUB, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 9724 /* negw */, RISCV::SUBW, Convert__Reg1_0__regX0__Reg1_1, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 9729 /* nop */, RISCV::ADDI, Convert__regX0__regX0__imm_95_0, AMFBS_None, {  }, },
  { 9733 /* not */, RISCV::XORI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 9737 /* ntl.all */, RISCV::ADD, Convert__regX0__regX0__regX5, AMFBS_HasStdExtZihintntl, {  }, },
  { 9745 /* ntl.p1 */, RISCV::ADD, Convert__regX0__regX0__regX2, AMFBS_HasStdExtZihintntl, {  }, },
  { 9752 /* ntl.pall */, RISCV::ADD, Convert__regX0__regX0__regX3, AMFBS_HasStdExtZihintntl, {  }, },
  { 9761 /* ntl.s1 */, RISCV::ADD, Convert__regX0__regX0__regX4, AMFBS_HasStdExtZihintntl, {  }, },
  { 9768 /* or */, RISCV::OR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9768 /* or */, RISCV::ORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 9771 /* orc.b */, RISCV::ORC_B, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 9777 /* ori */, RISCV::ORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 9781 /* orn */, RISCV::ORN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9785 /* pack */, RISCV::PACK, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkbOrP, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9790 /* packh */, RISCV::PACKH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9796 /* packw */, RISCV::PACKW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9802 /* pause */, RISCV::FENCE, Convert__imm_95_1__imm_95_0, AMFBS_HasStdExtZihintpause, {  }, },
  { 9808 /* pli.b */, RISCV::PLI_B, Convert__Reg1_0__UImm81_1, AMFBS_HasStdExtP, { MCK_GPR, MCK_UImm8 }, },
  { 9814 /* pli.h */, RISCV::PLI_H, Convert__Reg1_0__SImm101_1, AMFBS_HasStdExtP, { MCK_GPR, MCK_SImm10 }, },
  { 9820 /* pli.w */, RISCV::PLI_W, Convert__Reg1_0__SImm101_1, AMFBS_HasStdExtP_IsRV64, { MCK_GPR, MCK_SImm10 }, },
  { 9826 /* plui.h */, RISCV::PLUI_H, Convert__Reg1_0__SImm10Unsigned1_1, AMFBS_HasStdExtP, { MCK_GPR, MCK_SImm10Unsigned }, },
  { 9833 /* plui.w */, RISCV::PLUI_W, Convert__Reg1_0__SImm10Unsigned1_1, AMFBS_HasStdExtP_IsRV64, { MCK_GPR, MCK_SImm10Unsigned }, },
  { 9840 /* prefetch.i */, RISCV::PREFETCH_I, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9851 /* prefetch.r */, RISCV::PREFETCH_R, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9862 /* prefetch.w */, RISCV::PREFETCH_W, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9873 /* psabs.b */, RISCV::PSABS_B, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP, { MCK_GPR, MCK_GPR }, },
  { 9881 /* psabs.h */, RISCV::PSABS_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP, { MCK_GPR, MCK_GPR }, },
  { 9889 /* psext.h.b */, RISCV::PSEXT_H_B, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP, { MCK_GPR, MCK_GPR }, },
  { 9899 /* psext.w.b */, RISCV::PSEXT_W_B, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 9909 /* psext.w.h */, RISCV::PSEXT_W_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 9919 /* pslli.b */, RISCV::PSLLI_B, Convert__Reg1_0__Reg1_1__UImm31_2, AMFBS_HasStdExtP, { MCK_GPR, MCK_GPR, MCK_UImm3 }, },
  { 9927 /* pslli.h */, RISCV::PSLLI_H, Convert__Reg1_0__Reg1_1__UImm41_2, AMFBS_HasStdExtP, { MCK_GPR, MCK_GPR, MCK_UImm4 }, },
  { 9935 /* pslli.w */, RISCV::PSLLI_W, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtP_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 9943 /* psslai.h */, RISCV::PSSLAI_H, Convert__Reg1_0__Reg1_1__UImm41_2, AMFBS_HasStdExtP, { MCK_GPR, MCK_GPR, MCK_UImm4 }, },
  { 9952 /* psslai.w */, RISCV::PSSLAI_W, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtP_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 9961 /* qc.addsat */, RISCV::QC_ADDSAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9971 /* qc.addusat */, RISCV::QC_ADDUSAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9982 /* qc.beqi */, RISCV::QC_BEQI, Convert__Reg1_0__SImm5NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_SImm5NonZero, MCK_BareSImm13Lsb0 }, },
  { 9990 /* qc.bgei */, RISCV::QC_BGEI, Convert__Reg1_0__SImm5NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_SImm5NonZero, MCK_BareSImm13Lsb0 }, },
  { 9998 /* qc.bgeui */, RISCV::QC_BGEUI, Convert__Reg1_0__UImm5NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_UImm5NonZero, MCK_BareSImm13Lsb0 }, },
  { 10007 /* qc.blti */, RISCV::QC_BLTI, Convert__Reg1_0__SImm5NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_SImm5NonZero, MCK_BareSImm13Lsb0 }, },
  { 10015 /* qc.bltui */, RISCV::QC_BLTUI, Convert__Reg1_0__UImm5NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_UImm5NonZero, MCK_BareSImm13Lsb0 }, },
  { 10024 /* qc.bnei */, RISCV::QC_BNEI, Convert__Reg1_0__SImm5NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_SImm5NonZero, MCK_BareSImm13Lsb0 }, },
  { 10032 /* qc.brev32 */, RISCV::QC_BREV32, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 10042 /* qc.c.bexti */, RISCV::QC_C_BEXTI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRC, MCK_UImmLog2XLenNonZero }, },
  { 10053 /* qc.c.bseti */, RISCV::QC_C_BSETI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRC, MCK_UImmLog2XLenNonZero }, },
  { 10064 /* qc.c.clrint */, RISCV::QC_C_CLRINT, Convert__Reg1_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_GPRNoX0 }, },
  { 10076 /* qc.c.delay */, RISCV::QC_C_DELAY, Convert__UImm5NonZero1_0, AMFBS_HasVendorXqcisync_IsRV32, { MCK_UImm5NonZero }, },
  { 10087 /* qc.c.di */, RISCV::QC_C_DI, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 10095 /* qc.c.dir */, RISCV::QC_C_DIR, Convert__Reg1_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_GPRNoX0 }, },
  { 10104 /* qc.c.ei */, RISCV::QC_C_EI, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 10112 /* qc.c.eir */, RISCV::QC_C_EIR, Convert__Reg1_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_GPRNoX0 }, },
  { 10121 /* qc.c.extu */, RISCV::QC_C_EXTU, Convert__Reg1_0__Tie0_1_1__UImm5GE6Plus11_1, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_UImm5GE6Plus1 }, },
  { 10131 /* qc.c.mienter */, RISCV::QC_C_MIENTER, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 10144 /* qc.c.mienter.nest */, RISCV::QC_C_MIENTER_NEST, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 10162 /* qc.c.mileaveret */, RISCV::QC_C_MILEAVERET, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 10178 /* qc.c.mnret */, RISCV::QC_C_MNRET, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 10189 /* qc.c.mret */, RISCV::QC_C_MRET, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 10199 /* qc.c.muliadd */, RISCV::QC_C_MULIADD, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2, AMFBS_HasVendorXqciac_IsRV32, { MCK_GPRC, MCK_GPRC, MCK_UImm5 }, },
  { 10212 /* qc.c.mveqz */, RISCV::QC_C_MVEQZ, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRC, MCK_GPRC }, },
  { 10223 /* qc.c.ptrace */, RISCV::QC_C_PTRACE, Convert_NoOperands, AMFBS_HasVendorXqcisim_IsRV32, {  }, },
  { 10235 /* qc.c.setint */, RISCV::QC_C_SETINT, Convert__Reg1_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_GPRNoX0 }, },
  { 10247 /* qc.c.sync */, RISCV::QC_C_SYNC, Convert__UImm5Slist1_0, AMFBS_HasVendorXqcisync_IsRV32, { MCK_UImm5Slist }, },
  { 10257 /* qc.c.syncr */, RISCV::QC_C_SYNCR, Convert__UImm5Slist1_0, AMFBS_HasVendorXqcisync_IsRV32, { MCK_UImm5Slist }, },
  { 10268 /* qc.c.syncwf */, RISCV::QC_C_SYNCWF, Convert__UImm5Slist1_0, AMFBS_HasVendorXqcisync_IsRV32, { MCK_UImm5Slist }, },
  { 10280 /* qc.c.syncwl */, RISCV::QC_C_SYNCWL, Convert__UImm5Slist1_0, AMFBS_HasVendorXqcisync_IsRV32, { MCK_UImm5Slist }, },
  { 10292 /* qc.clo */, RISCV::QC_CLO, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 10299 /* qc.clrinti */, RISCV::QC_CLRINTI, Convert__UImm101_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_UImm10 }, },
  { 10310 /* qc.cm.mva01s */, RISCV::QC_CM_MVA01S, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqccmp, { MCK_SR07, MCK_SR07 }, },
  { 10323 /* qc.cm.mvsa01 */, RISCV::QC_CM_MVSA01, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqccmp, { MCK_SR07, MCK_SR07 }, },
  { 10336 /* qc.cm.pop */, RISCV::QC_CM_POP, Convert__RegList1_0__StackAdj1_1, AMFBS_HasVendorXqccmp, { MCK_RegList, MCK_StackAdj }, },
  { 10346 /* qc.cm.popret */, RISCV::QC_CM_POPRET, Convert__RegList1_0__StackAdj1_1, AMFBS_HasVendorXqccmp, { MCK_RegList, MCK_StackAdj }, },
  { 10359 /* qc.cm.popretz */, RISCV::QC_CM_POPRETZ, Convert__RegList1_0__StackAdj1_1, AMFBS_HasVendorXqccmp, { MCK_RegList, MCK_StackAdj }, },
  { 10373 /* qc.cm.push */, RISCV::QC_CM_PUSH, Convert__RegList1_0__NegStackAdj1_1, AMFBS_HasVendorXqccmp, { MCK_RegList, MCK_NegStackAdj }, },
  { 10384 /* qc.cm.pushfp */, RISCV::QC_CM_PUSHFP, Convert__RegListS01_0__NegStackAdj1_1, AMFBS_HasVendorXqccmp, { MCK_RegListS0, MCK_NegStackAdj }, },
  { 10397 /* qc.compress2 */, RISCV::QC_COMPRESS2, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 10410 /* qc.compress3 */, RISCV::QC_COMPRESS3, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 10423 /* qc.csrrwr */, RISCV::QC_CSRRWR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcicsr_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0 }, },
  { 10433 /* qc.csrrwri */, RISCV::QC_CSRRWRI, Convert__Reg1_0__UImm51_1__Reg1_2, AMFBS_HasVendorXqcicsr_IsRV32, { MCK_GPR, MCK_UImm5, MCK_GPRNoX0 }, },
  { 10444 /* qc.cto */, RISCV::QC_CTO, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 10451 /* qc.e.addai */, RISCV::QC_E_ADDAI, Convert__Reg1_0__Tie0_1_1__BareSImm321_1, AMFBS_HasVendorXqcilia_IsRV32, { MCK_GPRNoX0, MCK_BareSImm32 }, },
  { 10462 /* qc.e.addi */, RISCV::QC_E_ADDI, Convert__Reg1_0__Reg1_1__SImm261_2, AMFBS_HasVendorXqcilia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm26 }, },
  { 10472 /* qc.e.andai */, RISCV::QC_E_ANDAI, Convert__Reg1_0__Tie0_1_1__BareSImm321_1, AMFBS_HasVendorXqcilia_IsRV32, { MCK_GPRNoX0, MCK_BareSImm32 }, },
  { 10483 /* qc.e.andi */, RISCV::QC_E_ANDI, Convert__Reg1_0__Reg1_1__SImm261_2, AMFBS_HasVendorXqcilia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm26 }, },
  { 10493 /* qc.e.beqi */, RISCV::QC_E_BEQI, Convert__Reg1_0__SImm16NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_SImm16NonZero, MCK_BareSImm13Lsb0 }, },
  { 10503 /* qc.e.bgei */, RISCV::QC_E_BGEI, Convert__Reg1_0__SImm16NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_SImm16NonZero, MCK_BareSImm13Lsb0 }, },
  { 10513 /* qc.e.bgeui */, RISCV::QC_E_BGEUI, Convert__Reg1_0__UImm16NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_UImm16NonZero, MCK_BareSImm13Lsb0 }, },
  { 10524 /* qc.e.blti */, RISCV::QC_E_BLTI, Convert__Reg1_0__SImm16NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_SImm16NonZero, MCK_BareSImm13Lsb0 }, },
  { 10534 /* qc.e.bltui */, RISCV::QC_E_BLTUI, Convert__Reg1_0__UImm16NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_UImm16NonZero, MCK_BareSImm13Lsb0 }, },
  { 10545 /* qc.e.bnei */, RISCV::QC_E_BNEI, Convert__Reg1_0__SImm16NonZero1_1__BareSImm13Lsb01_2, AMFBS_HasVendorXqcibi_IsRV32, { MCK_GPRNoX0, MCK_SImm16NonZero, MCK_BareSImm13Lsb0 }, },
  { 10555 /* qc.e.j */, RISCV::QC_E_J, Convert__BareSImm32Lsb01_0, AMFBS_HasVendorXqcilb_IsRV32, { MCK_BareSImm32Lsb0 }, },
  { 10562 /* qc.e.jal */, RISCV::QC_E_JAL, Convert__BareSImm32Lsb01_0, AMFBS_HasVendorXqcilb_IsRV32, { MCK_BareSImm32Lsb0 }, },
  { 10571 /* qc.e.lb */, RISCV::PseudoQC_E_LB, Convert__Reg1_0__BareSymbol1_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_BareSymbol }, },
  { 10571 /* qc.e.lb */, RISCV::QC_E_LB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10571 /* qc.e.lb */, RISCV::QC_E_LB, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10579 /* qc.e.lbu */, RISCV::PseudoQC_E_LBU, Convert__Reg1_0__BareSymbol1_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_BareSymbol }, },
  { 10579 /* qc.e.lbu */, RISCV::QC_E_LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10579 /* qc.e.lbu */, RISCV::QC_E_LBU, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10588 /* qc.e.lh */, RISCV::PseudoQC_E_LH, Convert__Reg1_0__BareSymbol1_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_BareSymbol }, },
  { 10588 /* qc.e.lh */, RISCV::QC_E_LH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10588 /* qc.e.lh */, RISCV::QC_E_LH, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10596 /* qc.e.lhu */, RISCV::PseudoQC_E_LHU, Convert__Reg1_0__BareSymbol1_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_BareSymbol }, },
  { 10596 /* qc.e.lhu */, RISCV::QC_E_LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10596 /* qc.e.lhu */, RISCV::QC_E_LHU, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10605 /* qc.e.li */, RISCV::QC_E_LI, Convert__Reg1_0__BareSImm321_1, AMFBS_HasVendorXqcili_IsRV32, { MCK_GPRNoX0, MCK_BareSImm32 }, },
  { 10605 /* qc.e.li */, RISCV::ADDI, Convert__Reg1_0__regX0__BareSymbolQC_E_LI1_1, AMFBS_HasVendorXqcili_IsRV32, { MCK_GPR, MCK_BareSymbolQC_E_LI }, },
  { 10613 /* qc.e.lw */, RISCV::PseudoQC_E_LW, Convert__Reg1_0__BareSymbol1_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_BareSymbol }, },
  { 10613 /* qc.e.lw */, RISCV::QC_E_LW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10613 /* qc.e.lw */, RISCV::QC_E_LW, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10621 /* qc.e.orai */, RISCV::QC_E_ORAI, Convert__Reg1_0__Tie0_1_1__BareSImm321_1, AMFBS_HasVendorXqcilia_IsRV32, { MCK_GPRNoX0, MCK_BareSImm32 }, },
  { 10631 /* qc.e.ori */, RISCV::QC_E_ORI, Convert__Reg1_0__Reg1_1__SImm261_2, AMFBS_HasVendorXqcilia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm26 }, },
  { 10640 /* qc.e.sb */, RISCV::PseudoQC_E_SB, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 10640 /* qc.e.sb */, RISCV::QC_E_SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10640 /* qc.e.sb */, RISCV::QC_E_SB, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10648 /* qc.e.sh */, RISCV::PseudoQC_E_SH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 10648 /* qc.e.sh */, RISCV::QC_E_SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10648 /* qc.e.sh */, RISCV::QC_E_SH, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10656 /* qc.e.sw */, RISCV::PseudoQC_E_SW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 10656 /* qc.e.sw */, RISCV::QC_E_SW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10656 /* qc.e.sw */, RISCV::QC_E_SW, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10664 /* qc.e.xorai */, RISCV::QC_E_XORAI, Convert__Reg1_0__Tie0_1_1__BareSImm321_1, AMFBS_HasVendorXqcilia_IsRV32, { MCK_GPRNoX0, MCK_BareSImm32 }, },
  { 10675 /* qc.e.xori */, RISCV::QC_E_XORI, Convert__Reg1_0__Reg1_1__SImm261_2, AMFBS_HasVendorXqcilia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm26 }, },
  { 10685 /* qc.expand2 */, RISCV::QC_EXPAND2, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 10696 /* qc.expand3 */, RISCV::QC_EXPAND3, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 10707 /* qc.ext */, RISCV::QC_EXT, Convert__Reg1_0__Reg1_1__UImm5Plus11_2__UImm51_3, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5Plus1, MCK_UImm5 }, },
  { 10714 /* qc.extd */, RISCV::QC_EXTD, Convert__Reg1_0__Reg1_1__UImm5Plus11_2__UImm51_3, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX31, MCK_UImm5Plus1, MCK_UImm5 }, },
  { 10722 /* qc.extdpr */, RISCV::QC_EXTDPR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX31, MCK_GPRNoX0 }, },
  { 10732 /* qc.extdprh */, RISCV::QC_EXTDPRH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX31, MCK_GPRNoX0 }, },
  { 10743 /* qc.extdr */, RISCV::QC_EXTDR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX31, MCK_GPRNoX0 }, },
  { 10752 /* qc.extdu */, RISCV::QC_EXTDU, Convert__Reg1_0__Reg1_1__UImm5Plus11_2__UImm51_3, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX31, MCK_UImm5Plus1, MCK_UImm5 }, },
  { 10761 /* qc.extdupr */, RISCV::QC_EXTDUPR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX31, MCK_GPRNoX0 }, },
  { 10772 /* qc.extduprh */, RISCV::QC_EXTDUPRH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX31, MCK_GPRNoX0 }, },
  { 10784 /* qc.extdur */, RISCV::QC_EXTDUR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX31, MCK_GPRNoX0 }, },
  { 10794 /* qc.extu */, RISCV::QC_EXTU, Convert__Reg1_0__Reg1_1__UImm5Plus11_2__UImm51_3, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5Plus1, MCK_UImm5 }, },
  { 10802 /* qc.insb */, RISCV::QC_INSB, Convert__Reg1_0__Reg1_1__UImm5Plus11_2__UImm51_3, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPR, MCK_UImm5Plus1, MCK_UImm5 }, },
  { 10810 /* qc.insbh */, RISCV::QC_INSBH, Convert__Reg1_0__Reg1_1__UImm5Plus11_2__UImm51_3, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPR, MCK_UImm5Plus1, MCK_UImm5 }, },
  { 10819 /* qc.insbhr */, RISCV::QC_INSBHR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPR, MCK_GPRNoX0 }, },
  { 10829 /* qc.insbi */, RISCV::QC_INSBI, Convert__Reg1_0__Tie0_1_1__SImm51_1__UImm5Plus11_2__UImm51_3, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_SImm5, MCK_UImm5Plus1, MCK_UImm5 }, },
  { 10838 /* qc.insbpr */, RISCV::QC_INSBPR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPR, MCK_GPRNoX0 }, },
  { 10848 /* qc.insbprh */, RISCV::QC_INSBPRH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPR, MCK_GPRNoX0 }, },
  { 10859 /* qc.insbr */, RISCV::QC_INSBR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPR, MCK_GPRNoX0 }, },
  { 10868 /* qc.insbri */, RISCV::QC_INSBRI, Convert__Reg1_0__Reg1_1__SImm111_2, AMFBS_HasVendorXqcibm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm11 }, },
  { 10878 /* qc.inw */, RISCV::QC_INW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqciio_IsRV32, { MCK_GPRNoX0, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10878 /* qc.inw */, RISCV::QC_INW, Convert__Reg1_0__Reg1_3__UImm14Lsb001_1, AMFBS_HasVendorXqciio_IsRV32, { MCK_GPRNoX0, MCK_UImm14Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10885 /* qc.li */, RISCV::QC_LI, Convert__Reg1_0__SImm20LI1_1, AMFBS_HasVendorXqcili_IsRV32, { MCK_GPRNoX0, MCK_SImm20LI }, },
  { 10891 /* qc.lieq */, RISCV::QC_LIEQ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 10899 /* qc.lieqi */, RISCV::QC_LIEQI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 10908 /* qc.lige */, RISCV::QC_LIGE, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 10916 /* qc.ligei */, RISCV::QC_LIGEI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 10925 /* qc.ligeu */, RISCV::QC_LIGEU, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 10934 /* qc.ligeui */, RISCV::QC_LIGEUI, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5, MCK_SImm5 }, },
  { 10944 /* qc.lilt */, RISCV::QC_LILT, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 10952 /* qc.lilti */, RISCV::QC_LILTI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 10961 /* qc.liltu */, RISCV::QC_LILTU, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 10970 /* qc.liltui */, RISCV::QC_LILTUI, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5, MCK_SImm5 }, },
  { 10980 /* qc.line */, RISCV::QC_LINE, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 10988 /* qc.linei */, RISCV::QC_LINEI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 10997 /* qc.lrb */, RISCV::QC_LRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 11004 /* qc.lrbu */, RISCV::QC_LRBU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 11012 /* qc.lrh */, RISCV::QC_LRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 11019 /* qc.lrhu */, RISCV::QC_LRHU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 11027 /* qc.lrw */, RISCV::QC_LRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 11034 /* qc.lwm */, RISCV::QC_LWM, Convert__Reg1_0__Reg1_3__Reg1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11034 /* qc.lwm */, RISCV::QC_LWM, Convert__Reg1_0__Reg1_4__Reg1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11041 /* qc.lwmi */, RISCV::QC_LWMI, Convert__Reg1_0__Reg1_3__UImm5NonZero1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_UImm5NonZero, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11041 /* qc.lwmi */, RISCV::QC_LWMI, Convert__Reg1_0__Reg1_4__UImm5NonZero1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_UImm5NonZero, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11049 /* qc.muliadd */, RISCV::QC_MULIADD, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm121_2, AMFBS_HasVendorXqciac_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm12 }, },
  { 11060 /* qc.mveq */, RISCV::QC_MVEQ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11068 /* qc.mveqi */, RISCV::QC_MVEQI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0 }, },
  { 11077 /* qc.mvge */, RISCV::QC_MVGE, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11085 /* qc.mvgei */, RISCV::QC_MVGEI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0 }, },
  { 11094 /* qc.mvgeu */, RISCV::QC_MVGEU, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11103 /* qc.mvgeui */, RISCV::QC_MVGEUI, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5, MCK_GPRNoX0 }, },
  { 11113 /* qc.mvlt */, RISCV::QC_MVLT, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11121 /* qc.mvlti */, RISCV::QC_MVLTI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0 }, },
  { 11130 /* qc.mvltu */, RISCV::QC_MVLTU, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11139 /* qc.mvltui */, RISCV::QC_MVLTUI, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5, MCK_GPRNoX0 }, },
  { 11149 /* qc.mvne */, RISCV::QC_MVNE, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11157 /* qc.mvnei */, RISCV::QC_MVNEI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0 }, },
  { 11166 /* qc.norm */, RISCV::QC_NORM, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11174 /* qc.normeu */, RISCV::QC_NORMEU, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11184 /* qc.normu */, RISCV::QC_NORMU, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11193 /* qc.outw */, RISCV::QC_OUTW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqciio_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11193 /* qc.outw */, RISCV::QC_OUTW, Convert__Reg1_0__Reg1_3__UImm14Lsb001_1, AMFBS_HasVendorXqciio_IsRV32, { MCK_GPR, MCK_UImm14Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11201 /* qc.pcoredump */, RISCV::QC_PCOREDUMP, Convert_NoOperands, AMFBS_HasVendorXqcisim_IsRV32, {  }, },
  { 11214 /* qc.pexit */, RISCV::QC_PEXIT, Convert__Reg1_0, AMFBS_HasVendorXqcisim_IsRV32, { MCK_GPR }, },
  { 11223 /* qc.ppreg */, RISCV::QC_PPREG, Convert__Reg1_0, AMFBS_HasVendorXqcisim_IsRV32, { MCK_GPR }, },
  { 11232 /* qc.ppregs */, RISCV::QC_PPREGS, Convert_NoOperands, AMFBS_HasVendorXqcisim_IsRV32, {  }, },
  { 11242 /* qc.pputc */, RISCV::QC_PPUTC, Convert__Reg1_0, AMFBS_HasVendorXqcisim_IsRV32, { MCK_GPR }, },
  { 11251 /* qc.pputci */, RISCV::QC_PPUTCI, Convert__UImm81_0, AMFBS_HasVendorXqcisim_IsRV32, { MCK_UImm8 }, },
  { 11261 /* qc.pputs */, RISCV::QC_PPUTS, Convert__Reg1_0, AMFBS_HasVendorXqcisim_IsRV32, { MCK_GPR }, },
  { 11270 /* qc.psyscall */, RISCV::QC_PSYSCALL, Convert__Reg1_0, AMFBS_HasVendorXqcisim_IsRV32, { MCK_GPR }, },
  { 11282 /* qc.psyscalli */, RISCV::QC_PSYSCALLI, Convert__UImm101_0, AMFBS_HasVendorXqcisim_IsRV32, { MCK_UImm10 }, },
  { 11295 /* qc.selecteqi */, RISCV::QC_SELECTEQI, Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11308 /* qc.selectieq */, RISCV::QC_SELECTIEQ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 11321 /* qc.selectieqi */, RISCV::QC_SELECTIEQI, Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0, MCK_SImm5 }, },
  { 11335 /* qc.selectiieq */, RISCV::QC_SELECTIIEQ, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 11349 /* qc.selectiine */, RISCV::QC_SELECTIINE, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 11363 /* qc.selectine */, RISCV::QC_SELECTINE, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 11376 /* qc.selectinei */, RISCV::QC_SELECTINEI, Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0, MCK_SImm5 }, },
  { 11390 /* qc.selectnei */, RISCV::QC_SELECTNEI, Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11403 /* qc.setinti */, RISCV::QC_SETINTI, Convert__UImm101_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_UImm10 }, },
  { 11414 /* qc.setwm */, RISCV::QC_SETWM, Convert__Reg1_0__Reg1_3__Reg1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_GPRNoX0, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11414 /* qc.setwm */, RISCV::QC_SETWM, Convert__Reg1_0__Reg1_4__Reg1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_GPRNoX0, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11423 /* qc.setwmi */, RISCV::QC_SETWMI, Convert__Reg1_0__Reg1_3__UImm5NonZero1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_UImm5NonZero, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11423 /* qc.setwmi */, RISCV::QC_SETWMI, Convert__Reg1_0__Reg1_4__UImm5NonZero1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_UImm5NonZero, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11433 /* qc.shladd */, RISCV::QC_SHLADD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm5GT31_3, AMFBS_HasVendorXqciac_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5GT3 }, },
  { 11443 /* qc.shlsat */, RISCV::QC_SHLSAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11453 /* qc.shlusat */, RISCV::QC_SHLUSAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11464 /* qc.srb */, RISCV::QC_SRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 11471 /* qc.srh */, RISCV::QC_SRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 11478 /* qc.srw */, RISCV::QC_SRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 11485 /* qc.subsat */, RISCV::QC_SUBSAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11495 /* qc.subusat */, RISCV::QC_SUBUSAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 11506 /* qc.swm */, RISCV::QC_SWM, Convert__Reg1_0__Reg1_3__Reg1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11506 /* qc.swm */, RISCV::QC_SWM, Convert__Reg1_0__Reg1_4__Reg1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11513 /* qc.swmi */, RISCV::QC_SWMI, Convert__Reg1_0__Reg1_3__UImm5NonZero1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_UImm5NonZero, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11513 /* qc.swmi */, RISCV::QC_SWMI, Convert__Reg1_0__Reg1_4__UImm5NonZero1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_UImm5NonZero, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11521 /* qc.sync */, RISCV::QC_SYNC, Convert__UImm51_0, AMFBS_HasVendorXqcisync_IsRV32, { MCK_UImm5 }, },
  { 11529 /* qc.syncr */, RISCV::QC_SYNCR, Convert__UImm51_0, AMFBS_HasVendorXqcisync_IsRV32, { MCK_UImm5 }, },
  { 11538 /* qc.syncwf */, RISCV::QC_SYNCWF, Convert__UImm51_0, AMFBS_HasVendorXqcisync_IsRV32, { MCK_UImm5 }, },
  { 11548 /* qc.syncwl */, RISCV::QC_SYNCWL, Convert__UImm51_0, AMFBS_HasVendorXqcisync_IsRV32, { MCK_UImm5 }, },
  { 11558 /* qc.wrap */, RISCV::QC_WRAP, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPR, MCK_GPRNoX0 }, },
  { 11566 /* qc.wrapi */, RISCV::QC_WRAPI, Convert__Reg1_0__Reg1_1__UImm111_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm11 }, },
  { 11575 /* qk.c.lbu */, RISCV::QK_C_LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 11575 /* qk.c.lbu */, RISCV::QK_C_LBU, Convert__Reg1_0__Reg1_3__UImm51_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm5, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 11584 /* qk.c.lbusp */, RISCV::QK_C_LBUSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 11584 /* qk.c.lbusp */, RISCV::QK_C_LBUSP, Convert__Reg1_0__Reg1_3__UImm41_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm4, MCK__40_, MCK_SP, MCK__41_ }, },
  { 11595 /* qk.c.lhu */, RISCV::QK_C_LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 11595 /* qk.c.lhu */, RISCV::QK_C_LHU, Convert__Reg1_0__Reg1_3__UImm6Lsb01_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm6Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 11604 /* qk.c.lhusp */, RISCV::QK_C_LHUSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 11604 /* qk.c.lhusp */, RISCV::QK_C_LHUSP, Convert__Reg1_0__Reg1_3__UImm5Lsb01_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm5Lsb0, MCK__40_, MCK_SP, MCK__41_ }, },
  { 11615 /* qk.c.sb */, RISCV::QK_C_SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 11615 /* qk.c.sb */, RISCV::QK_C_SB, Convert__Reg1_0__Reg1_3__UImm51_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm5, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 11623 /* qk.c.sbsp */, RISCV::QK_C_SBSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 11623 /* qk.c.sbsp */, RISCV::QK_C_SBSP, Convert__Reg1_0__Reg1_3__UImm41_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm4, MCK__40_, MCK_SP, MCK__41_ }, },
  { 11633 /* qk.c.sh */, RISCV::QK_C_SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 11633 /* qk.c.sh */, RISCV::QK_C_SH, Convert__Reg1_0__Reg1_3__UImm6Lsb01_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm6Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 11641 /* qk.c.shsp */, RISCV::QK_C_SHSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 11641 /* qk.c.shsp */, RISCV::QK_C_SHSP, Convert__Reg1_0__Reg1_3__UImm5Lsb01_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm5Lsb0, MCK__40_, MCK_SP, MCK__41_ }, },
  { 11651 /* rdcycle */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3072__regX0, AMFBS_None, { MCK_GPR }, },
  { 11659 /* rdcycleh */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3200__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 11668 /* rdinstret */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3074__regX0, AMFBS_None, { MCK_GPR }, },
  { 11678 /* rdinstreth */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3202__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 11689 /* rdtime */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3073__regX0, AMFBS_None, { MCK_GPR }, },
  { 11696 /* rdtimeh */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3201__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 11704 /* rem */, RISCV::REM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11708 /* remu */, RISCV::REMU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11713 /* remuw */, RISCV::REMUW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11719 /* remw */, RISCV::REMW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11724 /* ret */, RISCV::JALR, Convert__regX0__regX1__imm_95_0, AMFBS_None, {  }, },
  { 11728 /* rev */, RISCV::REV_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 11728 /* rev */, RISCV::REV_RV64, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 11732 /* rev16 */, RISCV::REV16, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtP_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 11738 /* rev8 */, RISCV::REV8_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrZbkbOrP_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 11738 /* rev8 */, RISCV::REV8_RV64, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrZbkbOrP_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 11743 /* ri.vextract.x.v */, RISCV::RI_VEXTRACT, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasVendorXRivosVisni, { MCK_GPR, MCK_VM, MCK_UImm5 }, },
  { 11759 /* ri.vinsert.v.x */, RISCV::RI_VINSERT, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2, AMFBS_HasVendorXRivosVisni, { MCK_VM, MCK_GPR, MCK_UImm5 }, },
  { 11774 /* ri.vunzip2a.vv */, RISCV::RI_VUNZIP2A_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXRivosVizip, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11789 /* ri.vunzip2b.vv */, RISCV::RI_VUNZIP2B_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXRivosVizip, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11804 /* ri.vzero.v */, RISCV::RI_VZERO, Convert__Reg1_0, AMFBS_HasVendorXRivosVisni, { MCK_VM }, },
  { 11815 /* ri.vzip2a.vv */, RISCV::RI_VZIP2A_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXRivosVizip, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11828 /* ri.vzip2b.vv */, RISCV::RI_VZIP2B_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXRivosVizip, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11841 /* ri.vzipeven.vv */, RISCV::RI_VZIPEVEN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXRivosVizip, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11856 /* ri.vzipodd.vv */, RISCV::RI_VZIPODD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXRivosVizip, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11870 /* rol */, RISCV::ROL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11874 /* rolw */, RISCV::ROLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11879 /* ror */, RISCV::ROR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11879 /* ror */, RISCV::RORI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 11883 /* rori */, RISCV::RORI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 11888 /* roriw */, RISCV::RORIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 11894 /* rorw */, RISCV::RORW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11894 /* rorw */, RISCV::RORIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 11899 /* sb */, RISCV::PseudoSB, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 11899 /* sb */, RISCV::SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11899 /* sb */, RISCV::SB, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11902 /* sb.aqrl */, RISCV::SB_AQ_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11910 /* sb.rl */, RISCV::SB_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11916 /* sc.d */, RISCV::SC_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11921 /* sc.d.aq */, RISCV::SC_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11929 /* sc.d.aqrl */, RISCV::SC_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11939 /* sc.d.rl */, RISCV::SC_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11947 /* sc.w */, RISCV::SC_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11952 /* sc.w.aq */, RISCV::SC_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11960 /* sc.w.aqrl */, RISCV::SC_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11970 /* sc.w.rl */, RISCV::SC_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11978 /* sctrclr */, RISCV::SCTRCLR, Convert_NoOperands, AMFBS_HasStdExtSmctrOrSsctr, {  }, },
  { 11986 /* sd */, RISCV::PseudoSD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 11986 /* sd */, RISCV::PseudoSD_RV32, Convert__Reg1_2__GPRPairRV321_0__BareSymbol1_1, AMFBS_HasStdExtZilsd_IsRV32, { MCK_GPRPairRV32, MCK_BareSymbol, MCK_GPR }, },
  { 11986 /* sd */, RISCV::SD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11986 /* sd */, RISCV::SD_RV32, Convert__GPRPairRV321_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZilsd_IsRV32, { MCK_GPRPairRV32, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11986 /* sd */, RISCV::SD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11986 /* sd */, RISCV::SD_RV32, Convert__GPRPairRV321_0__Reg1_3__SImm121_1, AMFBS_HasStdExtZilsd_IsRV32, { MCK_GPRPairRV32, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11989 /* sd.aqrl */, RISCV::SD_AQ_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11997 /* sd.rl */, RISCV::SD_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 12003 /* seqz */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__imm_95_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 12008 /* sext.b */, RISCV::SEXT_B, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrP, { MCK_GPR, MCK_GPR }, },
  { 12008 /* sext.b */, RISCV::PseudoSEXT_B, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 12015 /* sext.h */, RISCV::SEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrP, { MCK_GPR, MCK_GPR }, },
  { 12015 /* sext.h */, RISCV::PseudoSEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 12022 /* sext.w */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 12029 /* sf.cdiscard.d.l1 */, RISCV::SF_CDISCARD_D_L1, Convert__regX0, AMFBS_HasVendorXSiFivecdiscarddlone, {  }, },
  { 12029 /* sf.cdiscard.d.l1 */, RISCV::SF_CDISCARD_D_L1, Convert__Reg1_0, AMFBS_HasVendorXSiFivecdiscarddlone, { MCK_GPR }, },
  { 12046 /* sf.cease */, RISCV::SF_CEASE, Convert_NoOperands, AMFBS_HasVendorXSfcease, {  }, },
  { 12055 /* sf.cflush.d.l1 */, RISCV::SF_CFLUSH_D_L1, Convert__regX0, AMFBS_HasVendorXSiFivecflushdlone, {  }, },
  { 12055 /* sf.cflush.d.l1 */, RISCV::SF_CFLUSH_D_L1, Convert__Reg1_0, AMFBS_HasVendorXSiFivecflushdlone, { MCK_GPR }, },
  { 12070 /* sf.mm.e4m3.e4m3 */, RISCV::SF_MM_E4M3_E4M3, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfmm32a8f, { MCK_TRM4, MCK_VM, MCK_VM }, },
  { 12086 /* sf.mm.e4m3.e5m2 */, RISCV::SF_MM_E4M3_E5M2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfmm32a8f, { MCK_TRM4, MCK_VM, MCK_VM }, },
  { 12102 /* sf.mm.e5m2.e4m3 */, RISCV::SF_MM_E5M2_E4M3, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfmm32a8f, { MCK_TRM4, MCK_VM, MCK_VM }, },
  { 12118 /* sf.mm.e5m2.e5m2 */, RISCV::SF_MM_E5M2_E5M2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfmm32a8f, { MCK_TRM4, MCK_VM, MCK_VM }, },
  { 12134 /* sf.mm.f.f */, RISCV::SF_MM_F_F, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfmm32a16fOrXSfmm32a32fOrXSfmm64a64f, { MCK_TRM2, MCK_VM, MCK_VM }, },
  { 12144 /* sf.mm.s.s */, RISCV::SF_MM_S_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfmm32a8i, { MCK_TRM4, MCK_VM, MCK_VM }, },
  { 12154 /* sf.mm.s.u */, RISCV::SF_MM_S_U, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfmm32a8i, { MCK_TRM4, MCK_VM, MCK_VM }, },
  { 12164 /* sf.mm.u.s */, RISCV::SF_MM_U_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfmm32a8i, { MCK_TRM4, MCK_VM, MCK_VM }, },
  { 12174 /* sf.mm.u.u */, RISCV::SF_MM_U_U, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfmm32a8i, { MCK_TRM4, MCK_VM, MCK_VM }, },
  { 12184 /* sf.vc.fv */, RISCV::SF_VC_FV, Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_UImm5, MCK_VM, MCK_FPR32 }, },
  { 12193 /* sf.vc.fvv */, RISCV::SF_VC_FVV, Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 12203 /* sf.vc.fvw */, RISCV::SF_VC_FVW, Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 12213 /* sf.vc.i */, RISCV::SF_VC_I, Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_UImm5, MCK_SImm5 }, },
  { 12221 /* sf.vc.iv */, RISCV::SF_VC_IV, Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_SImm5 }, },
  { 12230 /* sf.vc.ivv */, RISCV::SF_VC_IVV, Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 12240 /* sf.vc.ivw */, RISCV::SF_VC_IVW, Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 12250 /* sf.vc.v.fv */, RISCV::SF_VC_V_FV, Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 12261 /* sf.vc.v.fvv */, RISCV::SF_VC_V_FVV, Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 12273 /* sf.vc.v.fvw */, RISCV::SF_VC_V_FVW, Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 12285 /* sf.vc.v.i */, RISCV::SF_VC_V_I, Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_SImm5 }, },
  { 12295 /* sf.vc.v.iv */, RISCV::SF_VC_V_IV, Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 12306 /* sf.vc.v.ivv */, RISCV::SF_VC_V_IVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 12318 /* sf.vc.v.ivw */, RISCV::SF_VC_V_IVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 12330 /* sf.vc.v.vv */, RISCV::SF_VC_V_VV, Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 12341 /* sf.vc.v.vvv */, RISCV::SF_VC_V_VVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 12353 /* sf.vc.v.vvw */, RISCV::SF_VC_V_VVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 12365 /* sf.vc.v.x */, RISCV::SF_VC_V_X, Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_GPR }, },
  { 12375 /* sf.vc.v.xv */, RISCV::SF_VC_V_XV, Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 12386 /* sf.vc.v.xvv */, RISCV::SF_VC_V_XVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 12398 /* sf.vc.v.xvw */, RISCV::SF_VC_V_XVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 12410 /* sf.vc.vv */, RISCV::SF_VC_VV, Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_VM }, },
  { 12419 /* sf.vc.vvv */, RISCV::SF_VC_VVV, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 12429 /* sf.vc.vvw */, RISCV::SF_VC_VVW, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 12439 /* sf.vc.x */, RISCV::SF_VC_X, Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_UImm5, MCK_GPR }, },
  { 12447 /* sf.vc.xv */, RISCV::SF_VC_XV, Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_GPR }, },
  { 12456 /* sf.vc.xvv */, RISCV::SF_VC_XVV, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 12466 /* sf.vc.xvw */, RISCV::SF_VC_XVW, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 12476 /* sf.vfnrclip.x.f.qf */, RISCV::SF_VFNRCLIP_X_F_QF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXSfvfnrclipxfqf, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 12495 /* sf.vfnrclip.xu.f.qf */, RISCV::SF_VFNRCLIP_XU_F_QF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXSfvfnrclipxfqf, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 12515 /* sf.vfwmacc.4x4x4 */, RISCV::SF_VFWMACC_4x4x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvfwmaccqqq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 12532 /* sf.vlte16 */, RISCV::SF_VLTE16, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 12542 /* sf.vlte32 */, RISCV::SF_VLTE32, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 12552 /* sf.vlte64 */, RISCV::SF_VLTE64, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 12562 /* sf.vlte8 */, RISCV::SF_VLTE8, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 12571 /* sf.vqmacc.2x8x2 */, RISCV::SF_VQMACC_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 12587 /* sf.vqmacc.4x8x4 */, RISCV::SF_VQMACC_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 12603 /* sf.vqmaccsu.2x8x2 */, RISCV::SF_VQMACCSU_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 12621 /* sf.vqmaccsu.4x8x4 */, RISCV::SF_VQMACCSU_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 12639 /* sf.vqmaccu.2x8x2 */, RISCV::SF_VQMACCU_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 12656 /* sf.vqmaccu.4x8x4 */, RISCV::SF_VQMACCU_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 12673 /* sf.vqmaccus.2x8x2 */, RISCV::SF_VQMACCUS_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 12691 /* sf.vqmaccus.4x8x4 */, RISCV::SF_VQMACCUS_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 12709 /* sf.vsettk */, RISCV::SF_VSETTK, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_GPR }, },
  { 12719 /* sf.vsettm */, RISCV::SF_VSETTM, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_GPR }, },
  { 12729 /* sf.vsettn */, RISCV::SF_VSETTN, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_GPR }, },
  { 12739 /* sf.vsettnt */, RISCV::VSETVLI, Convert__Reg1_0__Reg1_1__XSfmmVType1_2, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_GPR, MCK_XSfmmVType }, },
  { 12750 /* sf.vste16 */, RISCV::SF_VSTE16, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 12760 /* sf.vste32 */, RISCV::SF_VSTE32, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 12770 /* sf.vste64 */, RISCV::SF_VSTE64, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 12780 /* sf.vste8 */, RISCV::SF_VSTE8, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 12789 /* sf.vtdiscard */, RISCV::SF_VTDISCARD, Convert_NoOperands, AMFBS_HasVendorXSfmmbase, {  }, },
  { 12802 /* sf.vtmv.t.v */, RISCV::SF_VTMV_T_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXSfmmbase, { MCK_GPR, MCK_VM }, },
  { 12814 /* sf.vtmv.v.t */, RISCV::SF_VTMV_V_T, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXSfmmbase, { MCK_VM, MCK_GPR }, },
  { 12826 /* sf.vtzero.t */, RISCV::SF_VTZERO_T, Convert__Reg1_0, AMFBS_HasVendorXSfmmbase, { MCK_TR }, },
  { 12838 /* sfence.inval.ir */, RISCV::SFENCE_INVAL_IR, Convert_NoOperands, AMFBS_HasStdExtSvinval, {  }, },
  { 12854 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 12854 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 12854 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 12865 /* sfence.w.inval */, RISCV::SFENCE_W_INVAL, Convert_NoOperands, AMFBS_HasStdExtSvinval, {  }, },
  { 12880 /* sgt */, RISCV::SLT, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 12884 /* sgtu */, RISCV::SLTU, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 12889 /* sgtz */, RISCV::SLT, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 12894 /* sh */, RISCV::PseudoSH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 12894 /* sh */, RISCV::SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 12894 /* sh */, RISCV::SH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 12897 /* sh.aqrl */, RISCV::SH_AQ_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 12905 /* sh.rl */, RISCV::SH_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 12911 /* sh1add */, RISCV::SH1ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbaOrP, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 12918 /* sh1add.uw */, RISCV::SH1ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 12928 /* sh2add */, RISCV::SH2ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 12935 /* sh2add.uw */, RISCV::SH2ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 12945 /* sh3add */, RISCV::SH3ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 12952 /* sh3add.uw */, RISCV::SH3ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 12962 /* sha256sig0 */, RISCV::SHA256SIG0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 12973 /* sha256sig1 */, RISCV::SHA256SIG1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 12984 /* sha256sum0 */, RISCV::SHA256SUM0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 12995 /* sha256sum1 */, RISCV::SHA256SUM1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 13006 /* sha512sig0 */, RISCV::SHA512SIG0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 13017 /* sha512sig0h */, RISCV::SHA512SIG0H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13029 /* sha512sig0l */, RISCV::SHA512SIG0L, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13041 /* sha512sig1 */, RISCV::SHA512SIG1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 13052 /* sha512sig1h */, RISCV::SHA512SIG1H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13064 /* sha512sig1l */, RISCV::SHA512SIG1L, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13076 /* sha512sum0 */, RISCV::SHA512SUM0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 13087 /* sha512sum0r */, RISCV::SHA512SUM0R, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13099 /* sha512sum1 */, RISCV::SHA512SUM1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 13110 /* sha512sum1r */, RISCV::SHA512SUM1R, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13122 /* sinval.vma */, RISCV::SINVAL_VMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 13133 /* sll */, RISCV::SLL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13133 /* sll */, RISCV::SLLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 13137 /* slli */, RISCV::SLLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 13142 /* slli.uw */, RISCV::SLLI_UW, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 13150 /* slliw */, RISCV::SLLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 13156 /* sllw */, RISCV::SLLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13156 /* sllw */, RISCV::SLLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 13161 /* slt */, RISCV::SLT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13161 /* slt */, RISCV::SLTI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 13165 /* slti */, RISCV::SLTI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 13170 /* sltiu */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 13176 /* sltu */, RISCV::SLTU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13176 /* sltu */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 13181 /* sltz */, RISCV::SLT, Convert__Reg1_0__Reg1_1__regX0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 13186 /* sm3p0 */, RISCV::SM3P0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZksh, { MCK_GPR, MCK_GPR }, },
  { 13192 /* sm3p1 */, RISCV::SM3P1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZksh, { MCK_GPR, MCK_GPR }, },
  { 13198 /* sm4ed */, RISCV::SM4ED, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZksed, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13204 /* sm4ks */, RISCV::SM4KS, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZksed, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13210 /* snez */, RISCV::SLTU, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 13215 /* sra */, RISCV::SRA, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13215 /* sra */, RISCV::SRAI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 13219 /* srai */, RISCV::SRAI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 13224 /* sraiw */, RISCV::SRAIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 13230 /* sraw */, RISCV::SRAW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13230 /* sraw */, RISCV::SRAIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 13235 /* sret */, RISCV::SRET, Convert_NoOperands, AMFBS_None, {  }, },
  { 13240 /* srl */, RISCV::SRL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13240 /* srl */, RISCV::SRLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 13244 /* srli */, RISCV::SRLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 13249 /* srliw */, RISCV::SRLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 13255 /* srlw */, RISCV::SRLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13255 /* srlw */, RISCV::SRLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 13260 /* ssamoswap.d */, RISCV::SSAMOSWAP_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 13272 /* ssamoswap.d.aq */, RISCV::SSAMOSWAP_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 13287 /* ssamoswap.d.aqrl */, RISCV::SSAMOSWAP_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 13304 /* ssamoswap.d.rl */, RISCV::SSAMOSWAP_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 13319 /* ssamoswap.w */, RISCV::SSAMOSWAP_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 13331 /* ssamoswap.w.aq */, RISCV::SSAMOSWAP_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 13346 /* ssamoswap.w.aqrl */, RISCV::SSAMOSWAP_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 13363 /* ssamoswap.w.rl */, RISCV::SSAMOSWAP_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 13378 /* sslai */, RISCV::SSLAI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtP_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 13384 /* sspopchk */, RISCV::SSPOPCHK, Convert__Reg1_0, AMFBS_HasStdExtZicfiss, { MCK_GPRX1X5 }, },
  { 13393 /* sspush */, RISCV::SSPUSH, Convert__Reg1_0, AMFBS_HasStdExtZicfiss, { MCK_GPRX1X5 }, },
  { 13400 /* ssrdp */, RISCV::SSRDP, Convert__Reg1_0, AMFBS_HasStdExtZicfiss, { MCK_GPRNoX0 }, },
  { 13406 /* sub */, RISCV::SUB, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13410 /* subw */, RISCV::SUBW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13415 /* sw */, RISCV::PseudoSW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 13415 /* sw */, RISCV::SW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 13415 /* sw */, RISCV::SW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 13418 /* sw.aqrl */, RISCV::SW_AQ_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 13426 /* sw.rl */, RISCV::SW_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 13432 /* tail */, RISCV::PseudoTAIL, Convert__CallSymbol1_0, AMFBS_None, { MCK_CallSymbol }, },
  { 13437 /* th.addsl */, RISCV::TH_ADDSL, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadBa, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13446 /* th.dcache.call */, RISCV::TH_DCACHE_CALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 13461 /* th.dcache.ciall */, RISCV::TH_DCACHE_CIALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 13477 /* th.dcache.cipa */, RISCV::TH_DCACHE_CIPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13492 /* th.dcache.cisw */, RISCV::TH_DCACHE_CISW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13507 /* th.dcache.civa */, RISCV::TH_DCACHE_CIVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13522 /* th.dcache.cpa */, RISCV::TH_DCACHE_CPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13536 /* th.dcache.cpal1 */, RISCV::TH_DCACHE_CPAL1, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13552 /* th.dcache.csw */, RISCV::TH_DCACHE_CSW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13566 /* th.dcache.cva */, RISCV::TH_DCACHE_CVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13580 /* th.dcache.cval1 */, RISCV::TH_DCACHE_CVAL1, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13596 /* th.dcache.iall */, RISCV::TH_DCACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 13611 /* th.dcache.ipa */, RISCV::TH_DCACHE_IPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13625 /* th.dcache.isw */, RISCV::TH_DCACHE_ISW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13639 /* th.dcache.iva */, RISCV::TH_DCACHE_IVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13653 /* th.ext */, RISCV::TH_EXT, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen, MCK_UImmLog2XLen }, },
  { 13660 /* th.extu */, RISCV::TH_EXTU, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen, MCK_UImmLog2XLen }, },
  { 13668 /* th.ff0 */, RISCV::TH_FF0, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 13675 /* th.ff1 */, RISCV::TH_FF1, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 13682 /* th.flrd */, RISCV::TH_FLRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13690 /* th.flrw */, RISCV::TH_FLRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13698 /* th.flurd */, RISCV::TH_FLURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13707 /* th.flurw */, RISCV::TH_FLURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13716 /* th.fsrd */, RISCV::TH_FSRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13724 /* th.fsrw */, RISCV::TH_FSRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13732 /* th.fsurd */, RISCV::TH_FSURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13741 /* th.fsurw */, RISCV::TH_FSURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13750 /* th.icache.iall */, RISCV::TH_ICACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 13765 /* th.icache.ialls */, RISCV::TH_ICACHE_IALLS, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 13781 /* th.icache.ipa */, RISCV::TH_ICACHE_IPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13795 /* th.icache.iva */, RISCV::TH_ICACHE_IVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 13809 /* th.l2cache.call */, RISCV::TH_L2CACHE_CALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 13825 /* th.l2cache.ciall */, RISCV::TH_L2CACHE_CIALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 13842 /* th.l2cache.iall */, RISCV::TH_L2CACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 13858 /* th.lbia */, RISCV::TH_LBIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 13866 /* th.lbib */, RISCV::TH_LBIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 13874 /* th.lbuia */, RISCV::TH_LBUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 13883 /* th.lbuib */, RISCV::TH_LBUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 13892 /* th.ldd */, RISCV::TH_LDD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__ImmFour1_6, AMFBS_HasVendorXTHeadMemPair_IsRV64, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_ImmFour }, },
  { 13899 /* th.ldia */, RISCV::TH_LDIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 13907 /* th.ldib */, RISCV::TH_LDIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 13915 /* th.lhia */, RISCV::TH_LHIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 13923 /* th.lhib */, RISCV::TH_LHIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 13931 /* th.lhuia */, RISCV::TH_LHUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 13940 /* th.lhuib */, RISCV::TH_LHUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 13949 /* th.lrb */, RISCV::TH_LRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13956 /* th.lrbu */, RISCV::TH_LRBU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13964 /* th.lrd */, RISCV::TH_LRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13971 /* th.lrh */, RISCV::TH_LRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13978 /* th.lrhu */, RISCV::TH_LRHU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13986 /* th.lrw */, RISCV::TH_LRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 13993 /* th.lrwu */, RISCV::TH_LRWU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14001 /* th.lurb */, RISCV::TH_LURB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14009 /* th.lurbu */, RISCV::TH_LURBU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14018 /* th.lurd */, RISCV::TH_LURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14026 /* th.lurh */, RISCV::TH_LURH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14034 /* th.lurhu */, RISCV::TH_LURHU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14043 /* th.lurw */, RISCV::TH_LURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14051 /* th.lurwu */, RISCV::TH_LURWU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14060 /* th.lwd */, RISCV::TH_LWD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__ImmThree1_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_ImmThree }, },
  { 14067 /* th.lwia */, RISCV::TH_LWIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14075 /* th.lwib */, RISCV::TH_LWIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14083 /* th.lwud */, RISCV::TH_LWUD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__ImmThree1_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_ImmThree }, },
  { 14091 /* th.lwuia */, RISCV::TH_LWUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14100 /* th.lwuib */, RISCV::TH_LWUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14109 /* th.mula */, RISCV::TH_MULA, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14117 /* th.mulah */, RISCV::TH_MULAH, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14126 /* th.mulaw */, RISCV::TH_MULAW, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14135 /* th.muls */, RISCV::TH_MULS, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14143 /* th.mulsh */, RISCV::TH_MULSH, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14152 /* th.mulsw */, RISCV::TH_MULSW, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14161 /* th.mveqz */, RISCV::TH_MVEQZ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadCondMov, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14170 /* th.mvnez */, RISCV::TH_MVNEZ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadCondMov, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14179 /* th.rev */, RISCV::TH_REV, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 14186 /* th.revw */, RISCV::TH_REVW, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 14194 /* th.sbia */, RISCV::TH_SBIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14202 /* th.sbib */, RISCV::TH_SBIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14210 /* th.sdd */, RISCV::TH_SDD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__ImmFour1_6, AMFBS_HasVendorXTHeadMemPair_IsRV64, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_ImmFour }, },
  { 14217 /* th.sdia */, RISCV::TH_SDIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14225 /* th.sdib */, RISCV::TH_SDIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14233 /* th.sfence.vmas */, RISCV::TH_SFENCE_VMAS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadSync, { MCK_GPR, MCK_GPR }, },
  { 14248 /* th.shia */, RISCV::TH_SHIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14256 /* th.shib */, RISCV::TH_SHIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14264 /* th.srb */, RISCV::TH_SRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14271 /* th.srd */, RISCV::TH_SRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14278 /* th.srh */, RISCV::TH_SRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14285 /* th.srri */, RISCV::TH_SRRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 14293 /* th.srriw */, RISCV::TH_SRRIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasVendorXTHeadBb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 14302 /* th.srw */, RISCV::TH_SRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14309 /* th.surb */, RISCV::TH_SURB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14317 /* th.surd */, RISCV::TH_SURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14325 /* th.surh */, RISCV::TH_SURH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14333 /* th.surw */, RISCV::TH_SURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 14341 /* th.swd */, RISCV::TH_SWD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__ImmThree1_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_ImmThree }, },
  { 14348 /* th.swia */, RISCV::TH_SWIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14356 /* th.swib */, RISCV::TH_SWIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 14364 /* th.sync */, RISCV::TH_SYNC, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 14372 /* th.sync.i */, RISCV::TH_SYNC_I, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 14382 /* th.sync.is */, RISCV::TH_SYNC_IS, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 14393 /* th.sync.s */, RISCV::TH_SYNC_S, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 14403 /* th.tst */, RISCV::TH_TST, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasVendorXTHeadBs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 14410 /* th.tstnbz */, RISCV::TH_TSTNBZ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 14420 /* th.vmaqa.vv */, RISCV::TH_VMAQA_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14432 /* th.vmaqa.vx */, RISCV::TH_VMAQA_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14444 /* th.vmaqasu.vv */, RISCV::TH_VMAQASU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14458 /* th.vmaqasu.vx */, RISCV::TH_VMAQASU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14472 /* th.vmaqau.vv */, RISCV::TH_VMAQAU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14485 /* th.vmaqau.vx */, RISCV::TH_VMAQAU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14498 /* th.vmaqaus.vx */, RISCV::TH_VMAQAUS_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14512 /* unimp */, RISCV::UNIMP, Convert_NoOperands, AMFBS_None, {  }, },
  { 14518 /* unzip */, RISCV::UNZIP_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 14524 /* vaadd.vv */, RISCV::VAADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14533 /* vaadd.vx */, RISCV::VAADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14542 /* vaaddu.vv */, RISCV::VAADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14552 /* vaaddu.vx */, RISCV::VAADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14562 /* vadc.vim */, RISCV::VADC_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskCarryInRegOpOperand }, },
  { 14571 /* vadc.vvm */, RISCV::VADC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskCarryInRegOpOperand }, },
  { 14580 /* vadc.vxm */, RISCV::VADC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskCarryInRegOpOperand }, },
  { 14589 /* vadd.vi */, RISCV::VADD_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 14597 /* vadd.vv */, RISCV::VADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14605 /* vadd.vx */, RISCV::VADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14613 /* vaesdf.vs */, RISCV::VAESDF_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 14623 /* vaesdf.vv */, RISCV::VAESDF_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 14633 /* vaesdm.vs */, RISCV::VAESDM_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 14643 /* vaesdm.vv */, RISCV::VAESDM_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 14653 /* vaesef.vs */, RISCV::VAESEF_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 14663 /* vaesef.vv */, RISCV::VAESEF_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 14673 /* vaesem.vs */, RISCV::VAESEM_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 14683 /* vaesem.vv */, RISCV::VAESEM_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 14693 /* vaeskf1.vi */, RISCV::VAESKF1_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 14704 /* vaeskf2.vi */, RISCV::VAESKF2_VI, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 14715 /* vaesz.vs */, RISCV::VAESZ_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 14724 /* vand.vi */, RISCV::VAND_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 14732 /* vand.vv */, RISCV::VAND_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14740 /* vand.vx */, RISCV::VAND_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14748 /* vandn.vv */, RISCV::VANDN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14757 /* vandn.vx */, RISCV::VANDN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14766 /* vasub.vv */, RISCV::VASUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14775 /* vasub.vx */, RISCV::VASUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14784 /* vasubu.vv */, RISCV::VASUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14794 /* vasubu.vx */, RISCV::VASUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14804 /* vbrev.v */, RISCV::VBREV_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14812 /* vbrev8.v */, RISCV::VBREV8_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14821 /* vclmul.vv */, RISCV::VCLMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbcOrZvbc32e, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14831 /* vclmul.vx */, RISCV::VCLMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbcOrZvbc32e, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14841 /* vclmulh.vv */, RISCV::VCLMULH_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbcOrZvbc32e, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14852 /* vclmulh.vx */, RISCV::VCLMULH_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbcOrZvbc32e, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14863 /* vclz.v */, RISCV::VCLZ_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14870 /* vcompress.vm */, RISCV::VCOMPRESS_VM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 14883 /* vcpop.m */, RISCV::VCPOP_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14891 /* vcpop.v */, RISCV::VCPOP_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14899 /* vctz.v */, RISCV::VCTZ_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14906 /* vdiv.vv */, RISCV::VDIV_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14914 /* vdiv.vx */, RISCV::VDIV_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14922 /* vdivu.vv */, RISCV::VDIVU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14931 /* vdivu.vx */, RISCV::VDIVU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14940 /* vfabs.v */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_1__reg0, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM }, },
  { 14940 /* vfabs.v */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14948 /* vfadd.vf */, RISCV::VFADD_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 14957 /* vfadd.vv */, RISCV::VFADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14966 /* vfclass.v */, RISCV::VFCLASS_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14976 /* vfcvt.f.x.v */, RISCV::VFCVT_F_X_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14988 /* vfcvt.f.xu.v */, RISCV::VFCVT_F_XU_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15001 /* vfcvt.rtz.x.f.v */, RISCV::VFCVT_RTZ_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15017 /* vfcvt.rtz.xu.f.v */, RISCV::VFCVT_RTZ_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15034 /* vfcvt.x.f.v */, RISCV::VFCVT_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15046 /* vfcvt.xu.f.v */, RISCV::VFCVT_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15059 /* vfdiv.vf */, RISCV::VFDIV_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15068 /* vfdiv.vv */, RISCV::VFDIV_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15077 /* vfirst.m */, RISCV::VFIRST_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15086 /* vfmacc.vf */, RISCV::VFMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15096 /* vfmacc.vv */, RISCV::VFMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15106 /* vfmadd.vf */, RISCV::VFMADD_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15116 /* vfmadd.vv */, RISCV::VFMADD_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15126 /* vfmax.vf */, RISCV::VFMAX_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15135 /* vfmax.vv */, RISCV::VFMAX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15144 /* vfmerge.vfm */, RISCV::VFMERGE_VFM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskCarryInRegOpOperand }, },
  { 15156 /* vfmin.vf */, RISCV::VFMIN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15165 /* vfmin.vv */, RISCV::VFMIN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15174 /* vfmsac.vf */, RISCV::VFMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15184 /* vfmsac.vv */, RISCV::VFMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15194 /* vfmsub.vf */, RISCV::VFMSUB_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15204 /* vfmsub.vv */, RISCV::VFMSUB_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15214 /* vfmul.vf */, RISCV::VFMUL_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15223 /* vfmul.vv */, RISCV::VFMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15232 /* vfmv.f.s */, RISCV::VFMV_F_S, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_FPR32, MCK_VM }, },
  { 15241 /* vfmv.s.f */, RISCV::VFMV_S_F, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32 }, },
  { 15250 /* vfmv.v.f */, RISCV::VFMV_V_F, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32 }, },
  { 15259 /* vfncvt.f.f.w */, RISCV::VFNCVT_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15272 /* vfncvt.f.x.w */, RISCV::VFNCVT_F_X_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15285 /* vfncvt.f.xu.w */, RISCV::VFNCVT_F_XU_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15299 /* vfncvt.rod.f.f.w */, RISCV::VFNCVT_ROD_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15316 /* vfncvt.rtz.x.f.w */, RISCV::VFNCVT_RTZ_X_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15333 /* vfncvt.rtz.xu.f.w */, RISCV::VFNCVT_RTZ_XU_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15351 /* vfncvt.x.f.w */, RISCV::VFNCVT_X_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15364 /* vfncvt.xu.f.w */, RISCV::VFNCVT_XU_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15378 /* vfncvtbf16.f.f.w */, RISCV::VFNCVTBF16_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvfbfmin, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15395 /* vfneg.v */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_1__reg0, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM }, },
  { 15395 /* vfneg.v */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15403 /* vfnmacc.vf */, RISCV::VFNMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15414 /* vfnmacc.vv */, RISCV::VFNMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15425 /* vfnmadd.vf */, RISCV::VFNMADD_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15436 /* vfnmadd.vv */, RISCV::VFNMADD_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15447 /* vfnmsac.vf */, RISCV::VFNMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15458 /* vfnmsac.vv */, RISCV::VFNMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15469 /* vfnmsub.vf */, RISCV::VFNMSUB_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15480 /* vfnmsub.vv */, RISCV::VFNMSUB_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15491 /* vfrdiv.vf */, RISCV::VFRDIV_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15501 /* vfrec7.v */, RISCV::VFREC7_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15510 /* vfredmax.vs */, RISCV::VFREDMAX_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15522 /* vfredmin.vs */, RISCV::VFREDMIN_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15534 /* vfredosum.vs */, RISCV::VFREDOSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15547 /* vfredusum.vs */, RISCV::VFREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15560 /* vfrsqrt7.v */, RISCV::VFRSQRT7_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15571 /* vfrsub.vf */, RISCV::VFRSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15581 /* vfsgnj.vf */, RISCV::VFSGNJ_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15591 /* vfsgnj.vv */, RISCV::VFSGNJ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15601 /* vfsgnjn.vf */, RISCV::VFSGNJN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15612 /* vfsgnjn.vv */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15623 /* vfsgnjx.vf */, RISCV::VFSGNJX_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15634 /* vfsgnjx.vv */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15645 /* vfslide1down.vf */, RISCV::VFSLIDE1DOWN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15661 /* vfslide1up.vf */, RISCV::VFSLIDE1UP_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15675 /* vfsqrt.v */, RISCV::VFSQRT_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15684 /* vfsub.vf */, RISCV::VFSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15693 /* vfsub.vv */, RISCV::VFSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15702 /* vfwadd.vf */, RISCV::VFWADD_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15712 /* vfwadd.vv */, RISCV::VFWADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15722 /* vfwadd.wf */, RISCV::VFWADD_WF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15732 /* vfwadd.wv */, RISCV::VFWADD_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15742 /* vfwcvt.f.f.v */, RISCV::VFWCVT_F_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15755 /* vfwcvt.f.x.v */, RISCV::VFWCVT_F_X_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15768 /* vfwcvt.f.xu.v */, RISCV::VFWCVT_F_XU_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15782 /* vfwcvt.rtz.x.f.v */, RISCV::VFWCVT_RTZ_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15799 /* vfwcvt.rtz.xu.f.v */, RISCV::VFWCVT_RTZ_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15817 /* vfwcvt.x.f.v */, RISCV::VFWCVT_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15830 /* vfwcvt.xu.f.v */, RISCV::VFWCVT_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15844 /* vfwcvtbf16.f.f.v */, RISCV::VFWCVTBF16_F_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvfbfmin, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15861 /* vfwmacc.vf */, RISCV::VFWMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15872 /* vfwmacc.vv */, RISCV::VFWMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15883 /* vfwmaccbf16.vf */, RISCV::VFWMACCBF16_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvfbfwma, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15898 /* vfwmaccbf16.vv */, RISCV::VFWMACCBF16_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvfbfwma, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15913 /* vfwmsac.vf */, RISCV::VFWMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15924 /* vfwmsac.vv */, RISCV::VFWMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15935 /* vfwmul.vf */, RISCV::VFWMUL_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 15945 /* vfwmul.vv */, RISCV::VFWMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15955 /* vfwnmacc.vf */, RISCV::VFWNMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15967 /* vfwnmacc.vv */, RISCV::VFWNMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15979 /* vfwnmsac.vf */, RISCV::VFWNMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15991 /* vfwnmsac.vv */, RISCV::VFWNMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16003 /* vfwredosum.vs */, RISCV::VFWREDOSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16017 /* vfwredusum.vs */, RISCV::VFWREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16031 /* vfwsub.vf */, RISCV::VFWSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 16041 /* vfwsub.vv */, RISCV::VFWSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16051 /* vfwsub.wf */, RISCV::VFWSUB_WF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 16061 /* vfwsub.wv */, RISCV::VFWSUB_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16071 /* vghsh.vs */, RISCV::VGHSH_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasStdExtZvkgs, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16080 /* vghsh.vv */, RISCV::VGHSH_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasStdExtZvkg, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16089 /* vgmul.vs */, RISCV::VGMUL_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkgs, { MCK_VM, MCK_VM }, },
  { 16098 /* vgmul.vv */, RISCV::VGMUL_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkg, { MCK_VM, MCK_VM }, },
  { 16107 /* vid.v */, RISCV::VID_V, Convert__Reg1_0__RVVMaskRegOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16113 /* viota.m */, RISCV::VIOTA_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16121 /* vl1r.v */, RISCV::VL1RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 16128 /* vl1re16.v */, RISCV::VL1RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 16138 /* vl1re32.v */, RISCV::VL1RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 16148 /* vl1re64.v */, RISCV::VL1RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 16158 /* vl1re8.v */, RISCV::VL1RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 16167 /* vl2r.v */, RISCV::VL2RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 16174 /* vl2re16.v */, RISCV::VL2RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 16184 /* vl2re32.v */, RISCV::VL2RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 16194 /* vl2re64.v */, RISCV::VL2RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 16204 /* vl2re8.v */, RISCV::VL2RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 16213 /* vl4r.v */, RISCV::VL4RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 16220 /* vl4re16.v */, RISCV::VL4RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 16230 /* vl4re32.v */, RISCV::VL4RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 16240 /* vl4re64.v */, RISCV::VL4RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 16250 /* vl4re8.v */, RISCV::VL4RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 16259 /* vl8r.v */, RISCV::VL8RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 16266 /* vl8re16.v */, RISCV::VL8RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 16276 /* vl8re32.v */, RISCV::VL8RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 16286 /* vl8re64.v */, RISCV::VL8RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 16296 /* vl8re8.v */, RISCV::VL8RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 16305 /* vle16.v */, RISCV::VLE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16313 /* vle16ff.v */, RISCV::VLE16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16323 /* vle32.v */, RISCV::VLE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16331 /* vle32ff.v */, RISCV::VLE32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16341 /* vle64.v */, RISCV::VLE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16349 /* vle64ff.v */, RISCV::VLE64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16359 /* vle8.v */, RISCV::VLE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16366 /* vle8ff.v */, RISCV::VLE8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16375 /* vlm.v */, RISCV::VLM_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 16381 /* vloxei16.v */, RISCV::VLOXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16392 /* vloxei32.v */, RISCV::VLOXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16403 /* vloxei64.v */, RISCV::VLOXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16414 /* vloxei8.v */, RISCV::VLOXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16424 /* vloxseg2ei16.v */, RISCV::VLOXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16439 /* vloxseg2ei32.v */, RISCV::VLOXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16454 /* vloxseg2ei64.v */, RISCV::VLOXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16469 /* vloxseg2ei8.v */, RISCV::VLOXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16483 /* vloxseg3ei16.v */, RISCV::VLOXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16498 /* vloxseg3ei32.v */, RISCV::VLOXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16513 /* vloxseg3ei64.v */, RISCV::VLOXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16528 /* vloxseg3ei8.v */, RISCV::VLOXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16542 /* vloxseg4ei16.v */, RISCV::VLOXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16557 /* vloxseg4ei32.v */, RISCV::VLOXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16572 /* vloxseg4ei64.v */, RISCV::VLOXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16587 /* vloxseg4ei8.v */, RISCV::VLOXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16601 /* vloxseg5ei16.v */, RISCV::VLOXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16616 /* vloxseg5ei32.v */, RISCV::VLOXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16631 /* vloxseg5ei64.v */, RISCV::VLOXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16646 /* vloxseg5ei8.v */, RISCV::VLOXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16660 /* vloxseg6ei16.v */, RISCV::VLOXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16675 /* vloxseg6ei32.v */, RISCV::VLOXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16690 /* vloxseg6ei64.v */, RISCV::VLOXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16705 /* vloxseg6ei8.v */, RISCV::VLOXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16719 /* vloxseg7ei16.v */, RISCV::VLOXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16734 /* vloxseg7ei32.v */, RISCV::VLOXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16749 /* vloxseg7ei64.v */, RISCV::VLOXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16764 /* vloxseg7ei8.v */, RISCV::VLOXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16778 /* vloxseg8ei16.v */, RISCV::VLOXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16793 /* vloxseg8ei32.v */, RISCV::VLOXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16808 /* vloxseg8ei64.v */, RISCV::VLOXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16823 /* vloxseg8ei8.v */, RISCV::VLOXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16837 /* vlse16.v */, RISCV::VLSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16846 /* vlse32.v */, RISCV::VLSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16855 /* vlse64.v */, RISCV::VLSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16864 /* vlse8.v */, RISCV::VLSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16872 /* vlseg2e16.v */, RISCV::VLSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16884 /* vlseg2e16ff.v */, RISCV::VLSEG2E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16898 /* vlseg2e32.v */, RISCV::VLSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16910 /* vlseg2e32ff.v */, RISCV::VLSEG2E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16924 /* vlseg2e64.v */, RISCV::VLSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16936 /* vlseg2e64ff.v */, RISCV::VLSEG2E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16950 /* vlseg2e8.v */, RISCV::VLSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16961 /* vlseg2e8ff.v */, RISCV::VLSEG2E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16974 /* vlseg3e16.v */, RISCV::VLSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16986 /* vlseg3e16ff.v */, RISCV::VLSEG3E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17000 /* vlseg3e32.v */, RISCV::VLSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17012 /* vlseg3e32ff.v */, RISCV::VLSEG3E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17026 /* vlseg3e64.v */, RISCV::VLSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17038 /* vlseg3e64ff.v */, RISCV::VLSEG3E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17052 /* vlseg3e8.v */, RISCV::VLSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17063 /* vlseg3e8ff.v */, RISCV::VLSEG3E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17076 /* vlseg4e16.v */, RISCV::VLSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17088 /* vlseg4e16ff.v */, RISCV::VLSEG4E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17102 /* vlseg4e32.v */, RISCV::VLSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17114 /* vlseg4e32ff.v */, RISCV::VLSEG4E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17128 /* vlseg4e64.v */, RISCV::VLSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17140 /* vlseg4e64ff.v */, RISCV::VLSEG4E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17154 /* vlseg4e8.v */, RISCV::VLSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17165 /* vlseg4e8ff.v */, RISCV::VLSEG4E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17178 /* vlseg5e16.v */, RISCV::VLSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17190 /* vlseg5e16ff.v */, RISCV::VLSEG5E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17204 /* vlseg5e32.v */, RISCV::VLSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17216 /* vlseg5e32ff.v */, RISCV::VLSEG5E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17230 /* vlseg5e64.v */, RISCV::VLSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17242 /* vlseg5e64ff.v */, RISCV::VLSEG5E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17256 /* vlseg5e8.v */, RISCV::VLSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17267 /* vlseg5e8ff.v */, RISCV::VLSEG5E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17280 /* vlseg6e16.v */, RISCV::VLSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17292 /* vlseg6e16ff.v */, RISCV::VLSEG6E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17306 /* vlseg6e32.v */, RISCV::VLSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17318 /* vlseg6e32ff.v */, RISCV::VLSEG6E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17332 /* vlseg6e64.v */, RISCV::VLSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17344 /* vlseg6e64ff.v */, RISCV::VLSEG6E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17358 /* vlseg6e8.v */, RISCV::VLSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17369 /* vlseg6e8ff.v */, RISCV::VLSEG6E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17382 /* vlseg7e16.v */, RISCV::VLSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17394 /* vlseg7e16ff.v */, RISCV::VLSEG7E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17408 /* vlseg7e32.v */, RISCV::VLSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17420 /* vlseg7e32ff.v */, RISCV::VLSEG7E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17434 /* vlseg7e64.v */, RISCV::VLSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17446 /* vlseg7e64ff.v */, RISCV::VLSEG7E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17460 /* vlseg7e8.v */, RISCV::VLSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17471 /* vlseg7e8ff.v */, RISCV::VLSEG7E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17484 /* vlseg8e16.v */, RISCV::VLSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17496 /* vlseg8e16ff.v */, RISCV::VLSEG8E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17510 /* vlseg8e32.v */, RISCV::VLSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17522 /* vlseg8e32ff.v */, RISCV::VLSEG8E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17536 /* vlseg8e64.v */, RISCV::VLSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17548 /* vlseg8e64ff.v */, RISCV::VLSEG8E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17562 /* vlseg8e8.v */, RISCV::VLSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17573 /* vlseg8e8ff.v */, RISCV::VLSEG8E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17586 /* vlsseg2e16.v */, RISCV::VLSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17599 /* vlsseg2e32.v */, RISCV::VLSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17612 /* vlsseg2e64.v */, RISCV::VLSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17625 /* vlsseg2e8.v */, RISCV::VLSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17637 /* vlsseg3e16.v */, RISCV::VLSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17650 /* vlsseg3e32.v */, RISCV::VLSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17663 /* vlsseg3e64.v */, RISCV::VLSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17676 /* vlsseg3e8.v */, RISCV::VLSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17688 /* vlsseg4e16.v */, RISCV::VLSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17701 /* vlsseg4e32.v */, RISCV::VLSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17714 /* vlsseg4e64.v */, RISCV::VLSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17727 /* vlsseg4e8.v */, RISCV::VLSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17739 /* vlsseg5e16.v */, RISCV::VLSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17752 /* vlsseg5e32.v */, RISCV::VLSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17765 /* vlsseg5e64.v */, RISCV::VLSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17778 /* vlsseg5e8.v */, RISCV::VLSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17790 /* vlsseg6e16.v */, RISCV::VLSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17803 /* vlsseg6e32.v */, RISCV::VLSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17816 /* vlsseg6e64.v */, RISCV::VLSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17829 /* vlsseg6e8.v */, RISCV::VLSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17841 /* vlsseg7e16.v */, RISCV::VLSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17854 /* vlsseg7e32.v */, RISCV::VLSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17867 /* vlsseg7e64.v */, RISCV::VLSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17880 /* vlsseg7e8.v */, RISCV::VLSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17892 /* vlsseg8e16.v */, RISCV::VLSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17905 /* vlsseg8e32.v */, RISCV::VLSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17918 /* vlsseg8e64.v */, RISCV::VLSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17931 /* vlsseg8e8.v */, RISCV::VLSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17943 /* vluxei16.v */, RISCV::VLUXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17954 /* vluxei32.v */, RISCV::VLUXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17965 /* vluxei64.v */, RISCV::VLUXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17976 /* vluxei8.v */, RISCV::VLUXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17986 /* vluxseg2ei16.v */, RISCV::VLUXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18001 /* vluxseg2ei32.v */, RISCV::VLUXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18016 /* vluxseg2ei64.v */, RISCV::VLUXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18031 /* vluxseg2ei8.v */, RISCV::VLUXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18045 /* vluxseg3ei16.v */, RISCV::VLUXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18060 /* vluxseg3ei32.v */, RISCV::VLUXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18075 /* vluxseg3ei64.v */, RISCV::VLUXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18090 /* vluxseg3ei8.v */, RISCV::VLUXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18104 /* vluxseg4ei16.v */, RISCV::VLUXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18119 /* vluxseg4ei32.v */, RISCV::VLUXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18134 /* vluxseg4ei64.v */, RISCV::VLUXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18149 /* vluxseg4ei8.v */, RISCV::VLUXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18163 /* vluxseg5ei16.v */, RISCV::VLUXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18178 /* vluxseg5ei32.v */, RISCV::VLUXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18193 /* vluxseg5ei64.v */, RISCV::VLUXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18208 /* vluxseg5ei8.v */, RISCV::VLUXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18222 /* vluxseg6ei16.v */, RISCV::VLUXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18237 /* vluxseg6ei32.v */, RISCV::VLUXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18252 /* vluxseg6ei64.v */, RISCV::VLUXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18267 /* vluxseg6ei8.v */, RISCV::VLUXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18281 /* vluxseg7ei16.v */, RISCV::VLUXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18296 /* vluxseg7ei32.v */, RISCV::VLUXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18311 /* vluxseg7ei64.v */, RISCV::VLUXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18326 /* vluxseg7ei8.v */, RISCV::VLUXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18340 /* vluxseg8ei16.v */, RISCV::VLUXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18355 /* vluxseg8ei32.v */, RISCV::VLUXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18370 /* vluxseg8ei64.v */, RISCV::VLUXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18385 /* vluxseg8ei8.v */, RISCV::VLUXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18399 /* vmacc.vv */, RISCV::VMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18408 /* vmacc.vx */, RISCV::VMACC_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18417 /* vmadc.vi */, RISCV::VMADC_VI, Convert__Reg1_0__Reg1_1__SImm51_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 18426 /* vmadc.vim */, RISCV::VMADC_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskCarryInRegOpOperand }, },
  { 18436 /* vmadc.vv */, RISCV::VMADC_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 18445 /* vmadc.vvm */, RISCV::VMADC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskCarryInRegOpOperand }, },
  { 18455 /* vmadc.vx */, RISCV::VMADC_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 18464 /* vmadc.vxm */, RISCV::VMADC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskCarryInRegOpOperand }, },
  { 18474 /* vmadd.vv */, RISCV::VMADD_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18483 /* vmadd.vx */, RISCV::VMADD_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18492 /* vmand.mm */, RISCV::VMAND_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 18501 /* vmandn.mm */, RISCV::VMANDN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 18511 /* vmax.vv */, RISCV::VMAX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18519 /* vmax.vx */, RISCV::VMAX_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18527 /* vmaxu.vv */, RISCV::VMAXU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18536 /* vmaxu.vx */, RISCV::VMAXU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18545 /* vmclr.m */, RISCV::VMXOR_MM, Convert__Reg1_0__Reg1_0__Reg1_0, AMFBS_HasVInstructions, { MCK_VM }, },
  { 18553 /* vmerge.vim */, RISCV::VMERGE_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskCarryInRegOpOperand }, },
  { 18564 /* vmerge.vvm */, RISCV::VMERGE_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskCarryInRegOpOperand }, },
  { 18575 /* vmerge.vxm */, RISCV::VMERGE_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskCarryInRegOpOperand }, },
  { 18586 /* vmfeq.vf */, RISCV::VMFEQ_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 18595 /* vmfeq.vv */, RISCV::VMFEQ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18604 /* vmfge.vf */, RISCV::VMFGE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 18613 /* vmfge.vv */, RISCV::VMFLE_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18622 /* vmfgt.vf */, RISCV::VMFGT_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 18631 /* vmfgt.vv */, RISCV::VMFLT_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18640 /* vmfle.vf */, RISCV::VMFLE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 18649 /* vmfle.vv */, RISCV::VMFLE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18658 /* vmflt.vf */, RISCV::VMFLT_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 18667 /* vmflt.vv */, RISCV::VMFLT_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18676 /* vmfne.vf */, RISCV::VMFNE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 18685 /* vmfne.vv */, RISCV::VMFNE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18694 /* vmin.vv */, RISCV::VMIN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18702 /* vmin.vx */, RISCV::VMIN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18710 /* vminu.vv */, RISCV::VMINU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18719 /* vminu.vx */, RISCV::VMINU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18728 /* vmmv.m */, RISCV::VMAND_MM, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 18735 /* vmnand.mm */, RISCV::VMNAND_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 18745 /* vmnor.mm */, RISCV::VMNOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 18754 /* vmnot.m */, RISCV::VMNAND_MM, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 18762 /* vmor.mm */, RISCV::VMOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 18770 /* vmorn.mm */, RISCV::VMORN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 18779 /* vmsbc.vv */, RISCV::VMSBC_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 18788 /* vmsbc.vvm */, RISCV::VMSBC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskCarryInRegOpOperand }, },
  { 18798 /* vmsbc.vx */, RISCV::VMSBC_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 18807 /* vmsbc.vxm */, RISCV::VMSBC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskCarryInRegOpOperand }, },
  { 18817 /* vmsbf.m */, RISCV::VMSBF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18825 /* vmseq.vi */, RISCV::VMSEQ_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 18834 /* vmseq.vv */, RISCV::VMSEQ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18843 /* vmseq.vx */, RISCV::VMSEQ_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18852 /* vmset.m */, RISCV::VMXNOR_MM, Convert__Reg1_0__Reg1_0__Reg1_0, AMFBS_HasVInstructions, { MCK_VM }, },
  { 18860 /* vmsge.vi */, RISCV::PseudoVMSGE_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 18869 /* vmsge.vv */, RISCV::VMSLE_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18878 /* vmsge.vx */, RISCV::PseudoVMSGE_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 18878 /* vmsge.vx */, RISCV::PseudoVMSGE_VX_M, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VRNoV0, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18878 /* vmsge.vx */, RISCV::PseudoVMSGE_VX_M_T, Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand, MCK_VRNoV0 }, },
  { 18887 /* vmsgeu.vi */, RISCV::PseudoVMSGEU_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 18897 /* vmsgeu.vv */, RISCV::VMSLEU_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18907 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 18907 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX_M, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VRNoV0, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18907 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX_M_T, Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand, MCK_VRNoV0 }, },
  { 18917 /* vmsgt.vi */, RISCV::VMSGT_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 18926 /* vmsgt.vv */, RISCV::VMSLT_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18935 /* vmsgt.vx */, RISCV::VMSGT_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18944 /* vmsgtu.vi */, RISCV::VMSGTU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 18954 /* vmsgtu.vv */, RISCV::VMSLTU_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18964 /* vmsgtu.vx */, RISCV::VMSGTU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18974 /* vmsif.m */, RISCV::VMSIF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18982 /* vmsle.vi */, RISCV::VMSLE_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 18991 /* vmsle.vv */, RISCV::VMSLE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19000 /* vmsle.vx */, RISCV::VMSLE_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19009 /* vmsleu.vi */, RISCV::VMSLEU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 19019 /* vmsleu.vv */, RISCV::VMSLEU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19029 /* vmsleu.vx */, RISCV::VMSLEU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19039 /* vmslt.vi */, RISCV::PseudoVMSLT_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 19048 /* vmslt.vv */, RISCV::VMSLT_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19057 /* vmslt.vx */, RISCV::VMSLT_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19066 /* vmsltu.vi */, RISCV::PseudoVMSLTU_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 19076 /* vmsltu.vv */, RISCV::VMSLTU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19086 /* vmsltu.vx */, RISCV::VMSLTU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19096 /* vmsne.vi */, RISCV::VMSNE_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 19105 /* vmsne.vv */, RISCV::VMSNE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19114 /* vmsne.vx */, RISCV::VMSNE_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19123 /* vmsof.m */, RISCV::VMSOF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19131 /* vmul.vv */, RISCV::VMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19139 /* vmul.vx */, RISCV::VMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19147 /* vmulh.vv */, RISCV::VMULH_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19156 /* vmulh.vx */, RISCV::VMULH_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19165 /* vmulhsu.vv */, RISCV::VMULHSU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19176 /* vmulhsu.vx */, RISCV::VMULHSU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19187 /* vmulhu.vv */, RISCV::VMULHU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19197 /* vmulhu.vx */, RISCV::VMULHU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19207 /* vmv.s.x */, RISCV::VMV_S_X, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR }, },
  { 19215 /* vmv.v.i */, RISCV::VMV_V_I, Convert__Reg1_0__SImm51_1, AMFBS_HasVInstructions, { MCK_VM, MCK_SImm5 }, },
  { 19223 /* vmv.v.v */, RISCV::VMV_V_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 19231 /* vmv.v.x */, RISCV::VMV_V_X, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR }, },
  { 19239 /* vmv.x.s */, RISCV::VMV_X_S, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM }, },
  { 19247 /* vmv1r.v */, RISCV::VMV1R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 19255 /* vmv2r.v */, RISCV::VMV2R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_VRM2 }, },
  { 19263 /* vmv4r.v */, RISCV::VMV4R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_VRM4 }, },
  { 19271 /* vmv8r.v */, RISCV::VMV8R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_VRM8 }, },
  { 19279 /* vmxnor.mm */, RISCV::VMXNOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 19289 /* vmxor.mm */, RISCV::VMXOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 19298 /* vnclip.wi */, RISCV::VNCLIP_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 19308 /* vnclip.wv */, RISCV::VNCLIP_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19318 /* vnclip.wx */, RISCV::VNCLIP_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19328 /* vnclipu.wi */, RISCV::VNCLIPU_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 19339 /* vnclipu.wv */, RISCV::VNCLIPU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19350 /* vnclipu.wx */, RISCV::VNCLIPU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19361 /* vncvt.x.x.w */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 19361 /* vncvt.x.x.w */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19373 /* vneg.v */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 19373 /* vneg.v */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19380 /* vnmsac.vv */, RISCV::VNMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19390 /* vnmsac.vx */, RISCV::VNMSAC_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19400 /* vnmsub.vv */, RISCV::VNMSUB_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19410 /* vnmsub.vx */, RISCV::VNMSUB_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19420 /* vnot.v */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 19420 /* vnot.v */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19427 /* vnsra.wi */, RISCV::VNSRA_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 19436 /* vnsra.wv */, RISCV::VNSRA_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19445 /* vnsra.wx */, RISCV::VNSRA_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19454 /* vnsrl.wi */, RISCV::VNSRL_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 19463 /* vnsrl.wv */, RISCV::VNSRL_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19472 /* vnsrl.wx */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19481 /* vor.vi */, RISCV::VOR_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 19488 /* vor.vv */, RISCV::VOR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19495 /* vor.vx */, RISCV::VOR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19502 /* vqdot.vv */, RISCV::VQDOT_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvqdotq, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19511 /* vqdot.vx */, RISCV::VQDOT_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvqdotq, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19520 /* vqdotsu.vv */, RISCV::VQDOTSU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvqdotq, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19531 /* vqdotsu.vx */, RISCV::VQDOTSU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvqdotq, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19542 /* vqdotu.vv */, RISCV::VQDOTU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvqdotq, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19552 /* vqdotu.vx */, RISCV::VQDOTU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvqdotq, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19562 /* vqdotus.vx */, RISCV::VQDOTUS_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvqdotq, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19573 /* vredand.vs */, RISCV::VREDAND_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19584 /* vredmax.vs */, RISCV::VREDMAX_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19595 /* vredmaxu.vs */, RISCV::VREDMAXU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19607 /* vredmin.vs */, RISCV::VREDMIN_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19618 /* vredminu.vs */, RISCV::VREDMINU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19630 /* vredor.vs */, RISCV::VREDOR_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19640 /* vredsum.vs */, RISCV::VREDSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19651 /* vredxor.vs */, RISCV::VREDXOR_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19662 /* vrem.vv */, RISCV::VREM_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19670 /* vrem.vx */, RISCV::VREM_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19678 /* vremu.vv */, RISCV::VREMU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19687 /* vremu.vx */, RISCV::VREMU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19696 /* vrev8.v */, RISCV::VREV8_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19704 /* vrgather.vi */, RISCV::VRGATHER_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 19716 /* vrgather.vv */, RISCV::VRGATHER_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19728 /* vrgather.vx */, RISCV::VRGATHER_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19740 /* vrgatherei16.vv */, RISCV::VRGATHEREI16_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19756 /* vrol.vv */, RISCV::VROL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19764 /* vrol.vx */, RISCV::VROL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19772 /* vror.vi */, RISCV::VROR_VI, Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_UImm6, MCK_RVVMaskRegOpOperand }, },
  { 19780 /* vror.vv */, RISCV::VROR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19788 /* vror.vx */, RISCV::VROR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19796 /* vrsub.vi */, RISCV::VRSUB_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 19805 /* vrsub.vx */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19814 /* vs1r.v */, RISCV::VS1R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 19821 /* vs2r.v */, RISCV::VS2R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 19828 /* vs4r.v */, RISCV::VS4R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 19835 /* vs8r.v */, RISCV::VS8R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 19842 /* vsadd.vi */, RISCV::VSADD_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 19851 /* vsadd.vv */, RISCV::VSADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19860 /* vsadd.vx */, RISCV::VSADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19869 /* vsaddu.vi */, RISCV::VSADDU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 19879 /* vsaddu.vv */, RISCV::VSADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19889 /* vsaddu.vx */, RISCV::VSADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19899 /* vsbc.vvm */, RISCV::VSBC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskCarryInRegOpOperand }, },
  { 19908 /* vsbc.vxm */, RISCV::VSBC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskCarryInRegOpOperand }, },
  { 19917 /* vse16.v */, RISCV::VSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 19925 /* vse32.v */, RISCV::VSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 19933 /* vse64.v */, RISCV::VSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 19941 /* vse8.v */, RISCV::VSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 19948 /* vsetivli */, RISCV::VSETIVLI, Convert__Reg1_0__UImm51_1__VTypeI101_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_UImm5, MCK_VTypeI10 }, },
  { 19957 /* vsetvl */, RISCV::VSETVL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 19964 /* vsetvli */, RISCV::VSETVLI, Convert__Reg1_0__Reg1_1__VTypeI111_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_GPR, MCK_VTypeI11 }, },
  { 19972 /* vsext.vf2 */, RISCV::VSEXT_VF2, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19982 /* vsext.vf4 */, RISCV::VSEXT_VF4, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19992 /* vsext.vf8 */, RISCV::VSEXT_VF8, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20002 /* vsha2ch.vv */, RISCV::VSHA2CH_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknhaOrZvknhb, { MCK_VM, MCK_VM, MCK_VM }, },
  { 20013 /* vsha2cl.vv */, RISCV::VSHA2CL_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknhaOrZvknhb, { MCK_VM, MCK_VM, MCK_VM }, },
  { 20024 /* vsha2ms.vv */, RISCV::VSHA2MS_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknhaOrZvknhb, { MCK_VM, MCK_VM, MCK_VM }, },
  { 20035 /* vslide1down.vx */, RISCV::VSLIDE1DOWN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20050 /* vslide1up.vx */, RISCV::VSLIDE1UP_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20063 /* vslidedown.vi */, RISCV::VSLIDEDOWN_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 20077 /* vslidedown.vx */, RISCV::VSLIDEDOWN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20091 /* vslideup.vi */, RISCV::VSLIDEUP_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 20103 /* vslideup.vx */, RISCV::VSLIDEUP_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20115 /* vsll.vi */, RISCV::VSLL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 20123 /* vsll.vv */, RISCV::VSLL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20131 /* vsll.vx */, RISCV::VSLL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20139 /* vsm.v */, RISCV::VSM_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 20145 /* vsm3c.vi */, RISCV::VSM3C_VI, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2, AMFBS_HasStdExtZvksh, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 20154 /* vsm3me.vv */, RISCV::VSM3ME_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvksh, { MCK_VM, MCK_VM, MCK_VM }, },
  { 20164 /* vsm4k.vi */, RISCV::VSM4K_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 20173 /* vsm4r.vs */, RISCV::VSM4R_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM }, },
  { 20182 /* vsm4r.vv */, RISCV::VSM4R_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM }, },
  { 20191 /* vsmul.vv */, RISCV::VSMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20200 /* vsmul.vx */, RISCV::VSMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20209 /* vsoxei16.v */, RISCV::VSOXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20220 /* vsoxei32.v */, RISCV::VSOXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20231 /* vsoxei64.v */, RISCV::VSOXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20242 /* vsoxei8.v */, RISCV::VSOXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20252 /* vsoxseg2ei16.v */, RISCV::VSOXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20267 /* vsoxseg2ei32.v */, RISCV::VSOXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20282 /* vsoxseg2ei64.v */, RISCV::VSOXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20297 /* vsoxseg2ei8.v */, RISCV::VSOXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20311 /* vsoxseg3ei16.v */, RISCV::VSOXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20326 /* vsoxseg3ei32.v */, RISCV::VSOXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20341 /* vsoxseg3ei64.v */, RISCV::VSOXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20356 /* vsoxseg3ei8.v */, RISCV::VSOXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20370 /* vsoxseg4ei16.v */, RISCV::VSOXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20385 /* vsoxseg4ei32.v */, RISCV::VSOXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20400 /* vsoxseg4ei64.v */, RISCV::VSOXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20415 /* vsoxseg4ei8.v */, RISCV::VSOXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20429 /* vsoxseg5ei16.v */, RISCV::VSOXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20444 /* vsoxseg5ei32.v */, RISCV::VSOXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20459 /* vsoxseg5ei64.v */, RISCV::VSOXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20474 /* vsoxseg5ei8.v */, RISCV::VSOXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20488 /* vsoxseg6ei16.v */, RISCV::VSOXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20503 /* vsoxseg6ei32.v */, RISCV::VSOXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20518 /* vsoxseg6ei64.v */, RISCV::VSOXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20533 /* vsoxseg6ei8.v */, RISCV::VSOXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20547 /* vsoxseg7ei16.v */, RISCV::VSOXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20562 /* vsoxseg7ei32.v */, RISCV::VSOXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20577 /* vsoxseg7ei64.v */, RISCV::VSOXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20592 /* vsoxseg7ei8.v */, RISCV::VSOXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20606 /* vsoxseg8ei16.v */, RISCV::VSOXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20621 /* vsoxseg8ei32.v */, RISCV::VSOXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20636 /* vsoxseg8ei64.v */, RISCV::VSOXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20651 /* vsoxseg8ei8.v */, RISCV::VSOXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20665 /* vsra.vi */, RISCV::VSRA_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 20673 /* vsra.vv */, RISCV::VSRA_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20681 /* vsra.vx */, RISCV::VSRA_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20689 /* vsrl.vi */, RISCV::VSRL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 20697 /* vsrl.vv */, RISCV::VSRL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20705 /* vsrl.vx */, RISCV::VSRL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20713 /* vsse16.v */, RISCV::VSSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20722 /* vsse32.v */, RISCV::VSSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20731 /* vsse64.v */, RISCV::VSSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20740 /* vsse8.v */, RISCV::VSSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20748 /* vsseg2e16.v */, RISCV::VSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20760 /* vsseg2e32.v */, RISCV::VSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20772 /* vsseg2e64.v */, RISCV::VSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20784 /* vsseg2e8.v */, RISCV::VSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20795 /* vsseg3e16.v */, RISCV::VSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20807 /* vsseg3e32.v */, RISCV::VSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20819 /* vsseg3e64.v */, RISCV::VSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20831 /* vsseg3e8.v */, RISCV::VSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20842 /* vsseg4e16.v */, RISCV::VSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20854 /* vsseg4e32.v */, RISCV::VSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20866 /* vsseg4e64.v */, RISCV::VSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20878 /* vsseg4e8.v */, RISCV::VSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20889 /* vsseg5e16.v */, RISCV::VSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20901 /* vsseg5e32.v */, RISCV::VSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20913 /* vsseg5e64.v */, RISCV::VSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20925 /* vsseg5e8.v */, RISCV::VSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20936 /* vsseg6e16.v */, RISCV::VSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20948 /* vsseg6e32.v */, RISCV::VSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20960 /* vsseg6e64.v */, RISCV::VSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20972 /* vsseg6e8.v */, RISCV::VSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20983 /* vsseg7e16.v */, RISCV::VSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 20995 /* vsseg7e32.v */, RISCV::VSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 21007 /* vsseg7e64.v */, RISCV::VSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 21019 /* vsseg7e8.v */, RISCV::VSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 21030 /* vsseg8e16.v */, RISCV::VSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 21042 /* vsseg8e32.v */, RISCV::VSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 21054 /* vsseg8e64.v */, RISCV::VSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 21066 /* vsseg8e8.v */, RISCV::VSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 21077 /* vssra.vi */, RISCV::VSSRA_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 21086 /* vssra.vv */, RISCV::VSSRA_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21095 /* vssra.vx */, RISCV::VSSRA_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21104 /* vssrl.vi */, RISCV::VSSRL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 21113 /* vssrl.vv */, RISCV::VSSRL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21122 /* vssrl.vx */, RISCV::VSSRL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21131 /* vssseg2e16.v */, RISCV::VSSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21144 /* vssseg2e32.v */, RISCV::VSSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21157 /* vssseg2e64.v */, RISCV::VSSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21170 /* vssseg2e8.v */, RISCV::VSSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21182 /* vssseg3e16.v */, RISCV::VSSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21195 /* vssseg3e32.v */, RISCV::VSSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21208 /* vssseg3e64.v */, RISCV::VSSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21221 /* vssseg3e8.v */, RISCV::VSSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21233 /* vssseg4e16.v */, RISCV::VSSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21246 /* vssseg4e32.v */, RISCV::VSSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21259 /* vssseg4e64.v */, RISCV::VSSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21272 /* vssseg4e8.v */, RISCV::VSSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21284 /* vssseg5e16.v */, RISCV::VSSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21297 /* vssseg5e32.v */, RISCV::VSSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21310 /* vssseg5e64.v */, RISCV::VSSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21323 /* vssseg5e8.v */, RISCV::VSSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21335 /* vssseg6e16.v */, RISCV::VSSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21348 /* vssseg6e32.v */, RISCV::VSSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21361 /* vssseg6e64.v */, RISCV::VSSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21374 /* vssseg6e8.v */, RISCV::VSSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21386 /* vssseg7e16.v */, RISCV::VSSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21399 /* vssseg7e32.v */, RISCV::VSSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21412 /* vssseg7e64.v */, RISCV::VSSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21425 /* vssseg7e8.v */, RISCV::VSSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21437 /* vssseg8e16.v */, RISCV::VSSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21450 /* vssseg8e32.v */, RISCV::VSSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21463 /* vssseg8e64.v */, RISCV::VSSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21476 /* vssseg8e8.v */, RISCV::VSSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21488 /* vssub.vv */, RISCV::VSSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21497 /* vssub.vx */, RISCV::VSSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21506 /* vssubu.vv */, RISCV::VSSUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21516 /* vssubu.vx */, RISCV::VSSUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21526 /* vsub.vv */, RISCV::VSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21534 /* vsub.vx */, RISCV::VSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 21542 /* vsuxei16.v */, RISCV::VSUXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21553 /* vsuxei32.v */, RISCV::VSUXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21564 /* vsuxei64.v */, RISCV::VSUXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21575 /* vsuxei8.v */, RISCV::VSUXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21585 /* vsuxseg2ei16.v */, RISCV::VSUXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21600 /* vsuxseg2ei32.v */, RISCV::VSUXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21615 /* vsuxseg2ei64.v */, RISCV::VSUXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21630 /* vsuxseg2ei8.v */, RISCV::VSUXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21644 /* vsuxseg3ei16.v */, RISCV::VSUXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21659 /* vsuxseg3ei32.v */, RISCV::VSUXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21674 /* vsuxseg3ei64.v */, RISCV::VSUXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21689 /* vsuxseg3ei8.v */, RISCV::VSUXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21703 /* vsuxseg4ei16.v */, RISCV::VSUXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21718 /* vsuxseg4ei32.v */, RISCV::VSUXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21733 /* vsuxseg4ei64.v */, RISCV::VSUXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21748 /* vsuxseg4ei8.v */, RISCV::VSUXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21762 /* vsuxseg5ei16.v */, RISCV::VSUXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21777 /* vsuxseg5ei32.v */, RISCV::VSUXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21792 /* vsuxseg5ei64.v */, RISCV::VSUXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21807 /* vsuxseg5ei8.v */, RISCV::VSUXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21821 /* vsuxseg6ei16.v */, RISCV::VSUXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21836 /* vsuxseg6ei32.v */, RISCV::VSUXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21851 /* vsuxseg6ei64.v */, RISCV::VSUXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21866 /* vsuxseg6ei8.v */, RISCV::VSUXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21880 /* vsuxseg7ei16.v */, RISCV::VSUXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21895 /* vsuxseg7ei32.v */, RISCV::VSUXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21910 /* vsuxseg7ei64.v */, RISCV::VSUXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21925 /* vsuxseg7ei8.v */, RISCV::VSUXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21939 /* vsuxseg8ei16.v */, RISCV::VSUXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21954 /* vsuxseg8ei32.v */, RISCV::VSUXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21969 /* vsuxseg8ei64.v */, RISCV::VSUXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21984 /* vsuxseg8ei8.v */, RISCV::VSUXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 21998 /* vt.maskc */, RISCV::VT_MASKC, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXVentanaCondOps, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 22007 /* vt.maskcn */, RISCV::VT_MASKCN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXVentanaCondOps, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 22017 /* vwadd.vv */, RISCV::VWADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22026 /* vwadd.vx */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22035 /* vwadd.wv */, RISCV::VWADD_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22044 /* vwadd.wx */, RISCV::VWADD_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22053 /* vwaddu.vv */, RISCV::VWADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22063 /* vwaddu.vx */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22073 /* vwaddu.wv */, RISCV::VWADDU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22083 /* vwaddu.wx */, RISCV::VWADDU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22093 /* vwcvt.x.x.v */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 22093 /* vwcvt.x.x.v */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22105 /* vwcvtu.x.x.v */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 22105 /* vwcvtu.x.x.v */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22118 /* vwmacc.vv */, RISCV::VWMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22128 /* vwmacc.vx */, RISCV::VWMACC_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22138 /* vwmaccsu.vv */, RISCV::VWMACCSU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22150 /* vwmaccsu.vx */, RISCV::VWMACCSU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22162 /* vwmaccu.vv */, RISCV::VWMACCU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22173 /* vwmaccu.vx */, RISCV::VWMACCU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22184 /* vwmaccus.vx */, RISCV::VWMACCUS_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22196 /* vwmul.vv */, RISCV::VWMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22205 /* vwmul.vx */, RISCV::VWMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22214 /* vwmulsu.vv */, RISCV::VWMULSU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22225 /* vwmulsu.vx */, RISCV::VWMULSU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22236 /* vwmulu.vv */, RISCV::VWMULU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22246 /* vwmulu.vx */, RISCV::VWMULU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22256 /* vwredsum.vs */, RISCV::VWREDSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22268 /* vwredsumu.vs */, RISCV::VWREDSUMU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22281 /* vwsll.vi */, RISCV::VWSLL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 22290 /* vwsll.vv */, RISCV::VWSLL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22299 /* vwsll.vx */, RISCV::VWSLL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22308 /* vwsub.vv */, RISCV::VWSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22317 /* vwsub.vx */, RISCV::VWSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22326 /* vwsub.wv */, RISCV::VWSUB_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22335 /* vwsub.wx */, RISCV::VWSUB_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22344 /* vwsubu.vv */, RISCV::VWSUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22354 /* vwsubu.vx */, RISCV::VWSUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22364 /* vwsubu.wv */, RISCV::VWSUBU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22374 /* vwsubu.wx */, RISCV::VWSUBU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22384 /* vxor.vi */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 22392 /* vxor.vv */, RISCV::VXOR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22400 /* vxor.vx */, RISCV::VXOR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 22408 /* vzext.vf2 */, RISCV::VZEXT_VF2, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22418 /* vzext.vf4 */, RISCV::VZEXT_VF4, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22428 /* vzext.vf8 */, RISCV::VZEXT_VF8, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 22438 /* wfi */, RISCV::WFI, Convert_NoOperands, AMFBS_None, {  }, },
  { 22442 /* wrs.nto */, RISCV::WRS_NTO, Convert_NoOperands, AMFBS_HasStdExtZawrs, {  }, },
  { 22450 /* wrs.sto */, RISCV::WRS_STO, Convert_NoOperands, AMFBS_HasStdExtZawrs, {  }, },
  { 22458 /* xnor */, RISCV::XNOR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 22463 /* xor */, RISCV::XOR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 22463 /* xor */, RISCV::XORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 22467 /* xori */, RISCV::XORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 22472 /* xperm4 */, RISCV::XPERM4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkx, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 22479 /* xperm8 */, RISCV::XPERM8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkx, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 22486 /* zext.b */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__imm_95_255, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 22493 /* zext.h */, RISCV::PACK, Convert__Reg1_0__Reg1_1__regX0, AMFBS_HasStdExtZbkb_NoStdExtZbb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 22493 /* zext.h */, RISCV::PACKW, Convert__Reg1_0__Reg1_1__regX0, AMFBS_HasStdExtZbkb_NoStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 22493 /* zext.h */, RISCV::ZEXT_H_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 22493 /* zext.h */, RISCV::ZEXT_H_RV64, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 22493 /* zext.h */, RISCV::PseudoZEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 22500 /* zext.w */, RISCV::ADD_UW, Convert__Reg1_0__Reg1_1__regX0, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 22500 /* zext.w */, RISCV::PseudoZEXT_W, Convert__Reg1_0__Reg1_1, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 22507 /* zip */, RISCV::ZIP_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb_IsRV32, { MCK_GPR, MCK_GPR }, },
};

#include "llvm/Support/Debug.h"
#include "llvm/Support/Format.h"

unsigned RISCVAsmParser::
MatchInstructionImpl(const OperandVector &Operands,
                     MCInst &Inst,
                     uint64_t &ErrorInfo,
                     FeatureBitset &MissingFeatures,
                     bool matchingInlineAsm, unsigned VariantID) {
  // Eliminate obvious mismatches.
  if (Operands.size() > 9) {
    ErrorInfo = 9;
    return Match_InvalidOperand;
  }

  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the instruction mnemonic, which is the first token.
  StringRef Mnemonic = ((RISCVOperand &)*Operands[0]).getToken();

  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Some state to try to produce better error messages.
  bool HadMatchOtherThanFeatures = false;
  bool HadMatchOtherThanPredicate = false;
  unsigned RetCode = Match_InvalidOperand;
  MissingFeatures.set();
  // Set ErrorInfo to the operand that mismatches if it is
  // wrong for all instances of the instruction.
  ErrorInfo = ~0ULL;
  SmallBitVector OptionalOperandsMask(8);
  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }
  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  DEBUG_WITH_TYPE("asm-matcher", dbgs() << "AsmMatcher: found " <<
  std::distance(MnemonicRange.first, MnemonicRange.second) <<
  " encodings with mnemonic '" << Mnemonic << "'\n");

  // Return a more specific error code if no mnemonics match.
  if (MnemonicRange.first == MnemonicRange.second)
    return Match_MnemonicFail;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    bool HasRequiredFeatures =
      (AvailableFeatures & RequiredFeatures) == RequiredFeatures;
    DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Trying to match opcode "
                                          << MII.getName(it->Opcode) << "\n");
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());
    bool OperandsValid = true;
    OptionalOperandsMask.reset(0, 8);
    for (unsigned FormalIdx = 0, ActualIdx = 1; FormalIdx != 8; ++FormalIdx) {
      auto Formal = static_cast<MatchClassKind>(it->Classes[FormalIdx]);
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "  Matching formal operand class " << getMatchClassName(Formal)
                             << " against actual operand at index " << ActualIdx);
      if (ActualIdx < Operands.size())
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << " (";
                        Operands[ActualIdx]->print(dbgs(), *getContext().getAsmInfo()); dbgs() << "): ");
      else
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << ": ");
      if (ActualIdx >= Operands.size()) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "actual operand index out of range\n");
        if (Formal == InvalidMatchClass) {
          OptionalOperandsMask.set(FormalIdx, 8);
          break;
        }
        if (isSubclass(Formal, OptionalMatchClass)) {
          OptionalOperandsMask.set(FormalIdx);
          continue;
        }
        OperandsValid = false;
        ErrorInfo = ActualIdx;
        break;
      }
      MCParsedAsmOperand &Actual = *Operands[ActualIdx];
      unsigned Diag = validateOperandClass(Actual, Formal);
      if (Diag == Match_Success) {
        DEBUG_WITH_TYPE("asm-matcher",
                        dbgs() << "match success using generic matcher\n");
        ++ActualIdx;
        continue;
      }
      // If the generic handler indicates an invalid operand
      // failure, check for a special case.
      if (Diag != Match_Success) {
        unsigned TargetDiag = validateTargetOperandClass(Actual, Formal);
        if (TargetDiag == Match_Success) {
          DEBUG_WITH_TYPE("asm-matcher",
                          dbgs() << "match success using target matcher\n");
          ++ActualIdx;
          continue;
        }
        // If the target matcher returned a specific error code use
        // that, else use the one from the generic matcher.
        if (TargetDiag != Match_InvalidOperand && HasRequiredFeatures)
          Diag = TargetDiag;
      }
      // If current formal operand wasn't matched and it is optional
      // then try to match next formal operand
      if (Diag == Match_InvalidOperand && isSubclass(Formal, OptionalMatchClass)) {
        OptionalOperandsMask.set(FormalIdx);
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "ignoring optional operand\n");
        continue;
      }
      // If this operand is broken for all of the instances of this
      // mnemonic, keep track of it so we can report loc info.
      // If we already had a match that only failed due to a
      // target predicate, that diagnostic is preferred.
      if (!HadMatchOtherThanPredicate &&
          (it == MnemonicRange.first || ErrorInfo <= ActualIdx)) {
        if (HasRequiredFeatures && (ErrorInfo != ActualIdx || Diag != Match_InvalidOperand))
          RetCode = Diag;
        ErrorInfo = ActualIdx;
      }
      // Otherwise, just reject this instance of the mnemonic.
      OperandsValid = false;
      break;
    }

    if (!OperandsValid) {
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Opcode result: multiple "
                                               "operand mismatches, ignoring "
                                               "this opcode\n");
      continue;
    }
    if (!HasRequiredFeatures) {
      HadMatchOtherThanFeatures = true;
      FeatureBitset NewMissingFeatures = RequiredFeatures & ~AvailableFeatures;
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Missing target features:";
                      for (unsigned I = 0, E = NewMissingFeatures.size(); I != E; ++I)
                        if (NewMissingFeatures[I])
                          dbgs() << ' ' << I;
                      dbgs() << "\n");
      if (NewMissingFeatures.count() <=
          MissingFeatures.count())
        MissingFeatures = NewMissingFeatures;
      continue;
    }

    Inst.clear();

    Inst.setOpcode(it->Opcode);
    // We have a potential match but have not rendered the operands.
    // Check the target predicate to handle any context sensitive
    // constraints.
    // For example, Ties that are referenced multiple times must be
    // checked here to ensure the input is the same for each match
    // constraints. If we leave it any later the ties will have been
    // canonicalized
    unsigned MatchResult;
    if ((MatchResult = checkEarlyTargetMatchPredicate(Inst, Operands)) != Match_Success) {
      Inst.clear();
      DEBUG_WITH_TYPE(
          "asm-matcher",
          dbgs() << "Early target match predicate failed with diag code "
                 << MatchResult << "\n");
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    unsigned DefaultsOffset[9] = { 0 };
    assert(OptionalOperandsMask.size() == 8);
    for (unsigned i = 0, NumDefaults = 0; i < 8; ++i) {
      DefaultsOffset[i + 1] = NumDefaults;
      NumDefaults += (OptionalOperandsMask[i] ? 1 : 0);
    }

    if (matchingInlineAsm) {
      convertToMapAndConstraints(it->ConvertFn, Operands);
      if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                          DefaultsOffset, ErrorInfo))
        return Match_InvalidTiedOperand;

      return Match_Success;
    }

    // We have selected a definite instruction, convert the parsed
    // operands into the appropriate MCInst.
    convertToMCInst(it->ConvertFn, Inst, it->Opcode, Operands,
                    OptionalOperandsMask, DefaultsOffset);

    // We have a potential match. Check the target predicate to
    // handle any context sensitive constraints.
    if ((MatchResult = checkTargetMatchPredicate(Inst)) != Match_Success) {
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "Target match predicate failed with diag code "
                             << MatchResult << "\n");
      Inst.clear();
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                         DefaultsOffset, ErrorInfo))
      return Match_InvalidTiedOperand;

    DEBUG_WITH_TYPE(
        "asm-matcher",
        dbgs() << "Opcode result: complete match, selecting this opcode\n");
    return Match_Success;
  }

  // Okay, we had no match.  Try to return a useful error code.
  if (HadMatchOtherThanPredicate || !HadMatchOtherThanFeatures)
    return RetCode;

  ErrorInfo = 0;
  return Match_MissingFeature;
}

namespace {
  struct OperandMatchEntry {
    uint16_t Mnemonic;
    uint8_t OperandMask;
    uint8_t Class;
    uint8_t RequiredFeaturesIdx;

    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcodeOperand {
    bool operator()(const OperandMatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic()  < RHS;
    }
    bool operator()(StringRef LHS, const OperandMatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const OperandMatchEntry &LHS, const OperandMatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const OperandMatchEntry OperandMatchTable[1642] = {
  /* Operand List Mnemonic, Mask, Operand Class, Features */
  { 0 /* .insn_b */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 8 /* .insn_ca */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtZca },
  { 17 /* .insn_cb */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtZca },
  { 26 /* .insn_ci */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtZca },
  { 35 /* .insn_ciw */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtZca },
  { 45 /* .insn_cj */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtZca },
  { 54 /* .insn_cl */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtZca },
  { 54 /* .insn_cl */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtZca },
  { 63 /* .insn_cr */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtZca },
  { 72 /* .insn_cs */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtZca },
  { 72 /* .insn_cs */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtZca },
  { 81 /* .insn_css */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtZca },
  { 91 /* .insn_i */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 91 /* .insn_i */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 91 /* .insn_i */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 99 /* .insn_j */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 99 /* .insn_j */, 4 /* 2 */, MCK_BareSImm21Lsb0, AMFBS_None },
  { 107 /* .insn_qc.eai */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_IsRV32 },
  { 120 /* .insn_qc.eb */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_IsRV32 },
  { 132 /* .insn_qc.ei */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_IsRV32 },
  { 132 /* .insn_qc.ei */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_IsRV32 },
  { 132 /* .insn_qc.ei */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_IsRV32 },
  { 144 /* .insn_qc.ej */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_IsRV32 },
  { 156 /* .insn_qc.es */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_IsRV32 },
  { 156 /* .insn_qc.es */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_IsRV32 },
  { 168 /* .insn_r */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 168 /* .insn_r */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 176 /* .insn_r4 */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 185 /* .insn_s */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 185 /* .insn_s */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 193 /* .insn_sb */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 202 /* .insn_u */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 210 /* .insn_uj */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 210 /* .insn_uj */, 4 /* 2 */, MCK_BareSImm21Lsb0, AMFBS_None },
  { 228 /* add */, 8 /* 3 */, MCK_TPRelAddSymbol, AMFBS_None },
  { 354 /* amoadd.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 363 /* amoadd.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 375 /* amoadd.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 389 /* amoadd.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 401 /* amoadd.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 410 /* amoadd.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 422 /* amoadd.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 436 /* amoadd.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 448 /* amoadd.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 457 /* amoadd.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 469 /* amoadd.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 483 /* amoadd.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 495 /* amoadd.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 504 /* amoadd.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 516 /* amoadd.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 530 /* amoadd.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 542 /* amoand.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 551 /* amoand.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 563 /* amoand.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 577 /* amoand.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 589 /* amoand.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 598 /* amoand.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 610 /* amoand.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 624 /* amoand.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 636 /* amoand.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 645 /* amoand.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 657 /* amoand.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 671 /* amoand.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 683 /* amoand.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 692 /* amoand.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 704 /* amoand.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 718 /* amoand.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 730 /* amocas.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 739 /* amocas.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 751 /* amocas.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 765 /* amocas.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 777 /* amocas.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 777 /* amocas.d */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 777 /* amocas.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 786 /* amocas.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 786 /* amocas.d.aq */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 786 /* amocas.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 798 /* amocas.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 798 /* amocas.d.aqrl */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 798 /* amocas.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 812 /* amocas.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 812 /* amocas.d.rl */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 812 /* amocas.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 824 /* amocas.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 833 /* amocas.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 845 /* amocas.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 859 /* amocas.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 871 /* amocas.q */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 871 /* amocas.q */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 880 /* amocas.q.aq */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 880 /* amocas.q.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 892 /* amocas.q.aqrl */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 892 /* amocas.q.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 906 /* amocas.q.rl */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 906 /* amocas.q.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 918 /* amocas.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 927 /* amocas.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 939 /* amocas.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 953 /* amocas.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 965 /* amomax.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 974 /* amomax.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 986 /* amomax.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1000 /* amomax.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1012 /* amomax.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1021 /* amomax.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1033 /* amomax.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1047 /* amomax.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1059 /* amomax.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1068 /* amomax.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1080 /* amomax.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1094 /* amomax.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1106 /* amomax.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1115 /* amomax.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1127 /* amomax.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1141 /* amomax.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1153 /* amomaxu.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1163 /* amomaxu.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1176 /* amomaxu.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1191 /* amomaxu.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1204 /* amomaxu.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1214 /* amomaxu.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1227 /* amomaxu.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1242 /* amomaxu.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1255 /* amomaxu.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1265 /* amomaxu.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1278 /* amomaxu.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1293 /* amomaxu.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1306 /* amomaxu.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1316 /* amomaxu.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1329 /* amomaxu.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1344 /* amomaxu.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1357 /* amomin.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1366 /* amomin.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1378 /* amomin.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1392 /* amomin.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1404 /* amomin.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1413 /* amomin.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1425 /* amomin.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1439 /* amomin.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1451 /* amomin.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1460 /* amomin.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1472 /* amomin.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1486 /* amomin.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1498 /* amomin.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1507 /* amomin.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1519 /* amomin.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1533 /* amomin.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1545 /* amominu.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1555 /* amominu.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1568 /* amominu.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1583 /* amominu.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1596 /* amominu.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1606 /* amominu.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1619 /* amominu.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1634 /* amominu.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1647 /* amominu.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1657 /* amominu.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1670 /* amominu.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1685 /* amominu.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1698 /* amominu.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1708 /* amominu.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1721 /* amominu.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1736 /* amominu.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1749 /* amoor.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1757 /* amoor.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1768 /* amoor.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1781 /* amoor.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1792 /* amoor.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1800 /* amoor.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1811 /* amoor.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1824 /* amoor.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1835 /* amoor.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1843 /* amoor.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1854 /* amoor.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1867 /* amoor.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1878 /* amoor.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1886 /* amoor.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1897 /* amoor.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1910 /* amoor.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1921 /* amoswap.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1931 /* amoswap.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1944 /* amoswap.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1959 /* amoswap.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1972 /* amoswap.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1982 /* amoswap.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1995 /* amoswap.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 2010 /* amoswap.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 2023 /* amoswap.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2033 /* amoswap.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2046 /* amoswap.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2061 /* amoswap.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2074 /* amoswap.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2084 /* amoswap.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2097 /* amoswap.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2112 /* amoswap.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2125 /* amoxor.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2134 /* amoxor.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2146 /* amoxor.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2160 /* amoxor.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2172 /* amoxor.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 2181 /* amoxor.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 2193 /* amoxor.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 2207 /* amoxor.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 2219 /* amoxor.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2228 /* amoxor.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2240 /* amoxor.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2254 /* amoxor.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2266 /* amoxor.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2275 /* amoxor.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2287 /* amoxor.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2301 /* amoxor.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2627 /* c.ld */, 1 /* 0 */, MCK_GPRPairCRV32, AMFBS_HasStdExtZclsd_IsRV32 },
  { 2627 /* c.ld */, 1 /* 0 */, MCK_GPRPairCRV32, AMFBS_HasStdExtZclsd_IsRV32 },
  { 2632 /* c.ldsp */, 1 /* 0 */, MCK_GPRPairNoX0RV32, AMFBS_HasStdExtZclsd_IsRV32 },
  { 2632 /* c.ldsp */, 1 /* 0 */, MCK_GPRPairNoX0RV32, AMFBS_HasStdExtZclsd_IsRV32 },
  { 2812 /* c.sd */, 1 /* 0 */, MCK_GPRPairCRV32, AMFBS_HasStdExtZclsd_IsRV32 },
  { 2812 /* c.sd */, 1 /* 0 */, MCK_GPRPairCRV32, AMFBS_HasStdExtZclsd_IsRV32 },
  { 2817 /* c.sdsp */, 1 /* 0 */, MCK_GPRPairRV32, AMFBS_HasStdExtZclsd_IsRV32 },
  { 2817 /* c.sdsp */, 1 /* 0 */, MCK_GPRPairRV32, AMFBS_HasStdExtZclsd_IsRV32 },
  { 2981 /* call */, 1 /* 0 */, MCK_CallSymbol, AMFBS_None },
  { 2981 /* call */, 2 /* 1 */, MCK_CallSymbol, AMFBS_None },
  { 2986 /* cbo.clean */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 2996 /* cbo.flush */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 3006 /* cbo.inval */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 3016 /* cbo.zero */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicboz },
  { 3097 /* cm.pop */, 1 /* 0 */, MCK_RegList, AMFBS_HasStdExtZcmp },
  { 3097 /* cm.pop */, 2 /* 1 */, MCK_StackAdj, AMFBS_HasStdExtZcmp },
  { 3104 /* cm.popret */, 1 /* 0 */, MCK_RegList, AMFBS_HasStdExtZcmp },
  { 3104 /* cm.popret */, 2 /* 1 */, MCK_StackAdj, AMFBS_HasStdExtZcmp },
  { 3114 /* cm.popretz */, 1 /* 0 */, MCK_RegList, AMFBS_HasStdExtZcmp },
  { 3114 /* cm.popretz */, 2 /* 1 */, MCK_StackAdj, AMFBS_HasStdExtZcmp },
  { 3125 /* cm.push */, 2 /* 1 */, MCK_NegStackAdj, AMFBS_HasStdExtZcmp },
  { 3125 /* cm.push */, 1 /* 0 */, MCK_RegList, AMFBS_HasStdExtZcmp },
  { 3144 /* csrc */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3144 /* csrc */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3149 /* csrci */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3155 /* csrr */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3160 /* csrrc */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3160 /* csrrc */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3166 /* csrrci */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3173 /* csrrs */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3173 /* csrrs */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3179 /* csrrsi */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3186 /* csrrw */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3186 /* csrrw */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3192 /* csrrwi */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3199 /* csrs */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3199 /* csrs */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3204 /* csrsi */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3210 /* csrw */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3210 /* csrw */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3215 /* csrwi */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 5179 /* cv.lb */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5185 /* cv.lbu */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5192 /* cv.lh */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5198 /* cv.lhu */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5205 /* cv.lw */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5854 /* cv.sb */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 6124 /* cv.sh */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 6739 /* cv.sw */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 6871 /* fabs.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6871 /* fabs.d */, 3 /* 0, 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6878 /* fabs.h */, 3 /* 0, 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 6892 /* fabs.s */, 3 /* 0, 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 6899 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6899 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6899 /* fadd.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6899 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6899 /* fadd.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6906 /* fadd.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6906 /* fadd.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6906 /* fadd.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 6913 /* fadd.q */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 6920 /* fadd.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6920 /* fadd.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6920 /* fadd.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 6927 /* fclass.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6927 /* fclass.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6936 /* fclass.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 6954 /* fclass.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 6963 /* fcvt.bf16.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfbfmin },
  { 6975 /* fcvt.d.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZfhmin_HasStdExtD },
  { 6975 /* fcvt.d.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 6975 /* fcvt.d.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 6975 /* fcvt.d.h */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 6975 /* fcvt.d.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 6975 /* fcvt.d.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 6975 /* fcvt.d.h */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 6984 /* fcvt.d.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 6984 /* fcvt.d.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6984 /* fcvt.d.l */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6993 /* fcvt.d.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 6993 /* fcvt.d.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6993 /* fcvt.d.lu */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 7003 /* fcvt.d.q */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 7012 /* fcvt.d.s */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtD },
  { 7012 /* fcvt.d.s */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7012 /* fcvt.d.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7012 /* fcvt.d.s */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7012 /* fcvt.d.s */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7012 /* fcvt.d.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7012 /* fcvt.d.s */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7021 /* fcvt.d.w */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtD },
  { 7021 /* fcvt.d.w */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7021 /* fcvt.d.w */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7021 /* fcvt.d.w */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7021 /* fcvt.d.w */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7030 /* fcvt.d.wu */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtD },
  { 7030 /* fcvt.d.wu */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7030 /* fcvt.d.wu */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7030 /* fcvt.d.wu */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7030 /* fcvt.d.wu */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7040 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfhmin_HasStdExtD },
  { 7040 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 7040 /* fcvt.h.d */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 7040 /* fcvt.h.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 7040 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 7040 /* fcvt.h.d */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 7040 /* fcvt.h.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 7049 /* fcvt.h.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 7049 /* fcvt.h.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 7049 /* fcvt.h.l */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx_IsRV64 },
  { 7058 /* fcvt.h.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 7058 /* fcvt.h.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 7058 /* fcvt.h.lu */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx_IsRV64 },
  { 7068 /* fcvt.h.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfhmin },
  { 7068 /* fcvt.h.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxmin },
  { 7068 /* fcvt.h.s */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin },
  { 7068 /* fcvt.h.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZhinxmin },
  { 7077 /* fcvt.h.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7077 /* fcvt.h.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7077 /* fcvt.h.w */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7086 /* fcvt.h.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7086 /* fcvt.h.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7086 /* fcvt.h.wu */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7096 /* fcvt.l.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 7096 /* fcvt.l.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 7096 /* fcvt.l.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 7105 /* fcvt.l.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 7105 /* fcvt.l.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 7105 /* fcvt.l.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx_IsRV64 },
  { 7114 /* fcvt.l.q */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtQ_IsRV64 },
  { 7123 /* fcvt.l.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 7123 /* fcvt.l.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7123 /* fcvt.l.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7132 /* fcvt.lu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 7132 /* fcvt.lu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 7132 /* fcvt.lu.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 7142 /* fcvt.lu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 7142 /* fcvt.lu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 7142 /* fcvt.lu.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx_IsRV64 },
  { 7152 /* fcvt.lu.q */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtQ_IsRV64 },
  { 7162 /* fcvt.lu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 7162 /* fcvt.lu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7162 /* fcvt.lu.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7172 /* fcvt.q.d */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtQ },
  { 7181 /* fcvt.q.l */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtQ_IsRV64 },
  { 7190 /* fcvt.q.lu */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtQ_IsRV64 },
  { 7200 /* fcvt.q.s */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtQ },
  { 7209 /* fcvt.q.w */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtQ },
  { 7218 /* fcvt.q.wu */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtQ },
  { 7228 /* fcvt.s.bf16 */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZfbfmin },
  { 7240 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7240 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7240 /* fcvt.s.d */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7240 /* fcvt.s.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7240 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7240 /* fcvt.s.d */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7240 /* fcvt.s.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7249 /* fcvt.s.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZfhmin },
  { 7249 /* fcvt.s.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZhinxmin },
  { 7249 /* fcvt.s.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin },
  { 7249 /* fcvt.s.h */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZhinxmin },
  { 7258 /* fcvt.s.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 7258 /* fcvt.s.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7258 /* fcvt.s.l */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7267 /* fcvt.s.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 7267 /* fcvt.s.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7267 /* fcvt.s.lu */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7277 /* fcvt.s.q */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 7286 /* fcvt.s.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7286 /* fcvt.s.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7286 /* fcvt.s.w */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7295 /* fcvt.s.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7295 /* fcvt.s.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7295 /* fcvt.s.wu */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7305 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7305 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7305 /* fcvt.w.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7305 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7305 /* fcvt.w.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7314 /* fcvt.w.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7314 /* fcvt.w.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7314 /* fcvt.w.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7323 /* fcvt.w.q */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 7332 /* fcvt.w.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7332 /* fcvt.w.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7332 /* fcvt.w.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7341 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7341 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7341 /* fcvt.wu.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7341 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7341 /* fcvt.wu.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7351 /* fcvt.wu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7351 /* fcvt.wu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7351 /* fcvt.wu.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7361 /* fcvt.wu.q */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 7371 /* fcvt.wu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7371 /* fcvt.wu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7371 /* fcvt.wu.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7381 /* fcvtmod.w.d */, 4 /* 2 */, MCK_RTZArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 7393 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7393 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7393 /* fdiv.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7393 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7393 /* fdiv.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7400 /* fdiv.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7400 /* fdiv.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7400 /* fdiv.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7407 /* fdiv.q */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 7414 /* fdiv.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7414 /* fdiv.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7414 /* fdiv.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7421 /* fence */, 3 /* 0, 1 */, MCK_FenceArg, AMFBS_None },
  { 7445 /* feq.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7445 /* feq.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7451 /* feq.h */, 6 /* 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7463 /* feq.s */, 6 /* 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7469 /* fge.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7469 /* fge.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7475 /* fge.h */, 6 /* 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7487 /* fge.s */, 6 /* 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7521 /* fgt.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7521 /* fgt.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7527 /* fgt.h */, 6 /* 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7539 /* fgt.s */, 6 /* 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7573 /* fld */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtD },
  { 7577 /* fle.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7577 /* fle.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7583 /* fle.h */, 6 /* 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7595 /* fle.s */, 6 /* 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7629 /* flh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasHalfFPLoadStoreMove },
  { 7633 /* fli.d */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa_HasStdExtD },
  { 7639 /* fli.h */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh },
  { 7645 /* fli.q */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa_HasStdExtQ },
  { 7651 /* fli.s */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa },
  { 7657 /* flq */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtQ },
  { 7661 /* flt.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7661 /* flt.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7667 /* flt.h */, 6 /* 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7679 /* flt.s */, 6 /* 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7713 /* flw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtF },
  { 7717 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7717 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7717 /* fmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7717 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7717 /* fmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7725 /* fmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7725 /* fmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7725 /* fmadd.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7733 /* fmadd.q */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 7741 /* fmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7741 /* fmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7741 /* fmadd.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7749 /* fmax.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7749 /* fmax.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7756 /* fmax.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7770 /* fmax.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7809 /* fmin.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7809 /* fmin.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7816 /* fmin.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7830 /* fmin.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7869 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7869 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7869 /* fmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7869 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7869 /* fmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7877 /* fmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7877 /* fmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7877 /* fmsub.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7885 /* fmsub.q */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 7893 /* fmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7893 /* fmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7893 /* fmsub.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7901 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7901 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7901 /* fmul.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7901 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7901 /* fmul.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7908 /* fmul.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7908 /* fmul.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7908 /* fmul.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7915 /* fmul.q */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 7922 /* fmul.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7922 /* fmul.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7922 /* fmul.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7929 /* fmv.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7929 /* fmv.d */, 3 /* 0, 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7943 /* fmv.h */, 3 /* 0, 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7963 /* fmv.s */, 3 /* 0, 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 8037 /* fneg.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8037 /* fneg.d */, 3 /* 0, 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8044 /* fneg.h */, 3 /* 0, 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 8058 /* fneg.s */, 3 /* 0, 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 8065 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 8065 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8065 /* fnmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8065 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8065 /* fnmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8074 /* fnmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 8074 /* fnmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 8074 /* fnmadd.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 8083 /* fnmadd.q */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 8092 /* fnmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 8092 /* fnmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 8092 /* fnmadd.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 8101 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 8101 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8101 /* fnmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8101 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8101 /* fnmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8110 /* fnmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 8110 /* fnmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 8110 /* fnmsub.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 8119 /* fnmsub.q */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 8128 /* fnmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 8128 /* fnmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 8128 /* fnmsub.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 8151 /* fround.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 8160 /* fround.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtZfh },
  { 8169 /* fround.q */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtQ },
  { 8178 /* fround.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa },
  { 8187 /* froundnx.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 8198 /* froundnx.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtZfh },
  { 8209 /* froundnx.q */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtQ },
  { 8220 /* froundnx.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa },
  { 8242 /* fsd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtD },
  { 8263 /* fsgnj.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8263 /* fsgnj.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8271 /* fsgnj.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 8287 /* fsgnj.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 8295 /* fsgnjn.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8295 /* fsgnjn.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8304 /* fsgnjn.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 8322 /* fsgnjn.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 8331 /* fsgnjx.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8331 /* fsgnjx.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8340 /* fsgnjx.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 8358 /* fsgnjx.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 8367 /* fsh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasHalfFPLoadStoreMove },
  { 8371 /* fsq */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtQ },
  { 8375 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 8375 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8375 /* fsqrt.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8375 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8375 /* fsqrt.d */, 3 /* 0, 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8383 /* fsqrt.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 8383 /* fsqrt.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 8383 /* fsqrt.h */, 3 /* 0, 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 8391 /* fsqrt.q */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 8399 /* fsqrt.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 8399 /* fsqrt.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 8399 /* fsqrt.s */, 3 /* 0, 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 8418 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 8418 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8418 /* fsub.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 8418 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8418 /* fsub.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 8425 /* fsub.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 8425 /* fsub.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 8425 /* fsub.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 8432 /* fsub.q */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtQ },
  { 8439 /* fsub.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 8439 /* fsub.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 8439 /* fsub.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 8446 /* fsw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtF },
  { 8498 /* hlv.b */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8504 /* hlv.bu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8511 /* hlv.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 8517 /* hlv.h */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8523 /* hlv.hu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8530 /* hlv.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8536 /* hlv.wu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 8543 /* hlvx.hu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8551 /* hlvx.wu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8559 /* hsv.b */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8565 /* hsv.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 8571 /* hsv.h */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8577 /* hsv.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8583 /* j */, 1 /* 0 */, MCK_BareSImm21Lsb0, AMFBS_None },
  { 8585 /* jal */, 1 /* 0 */, MCK_BareSImm21Lsb0, AMFBS_None },
  { 8585 /* jal */, 2 /* 1 */, MCK_BareSImm21Lsb0, AMFBS_None },
  { 8589 /* jalr */, 32 /* 5 */, MCK_TLSDESCCallSymbol, AMFBS_None },
  { 8597 /* jump */, 1 /* 0 */, MCK_PseudoJumpSymbol, AMFBS_None },
  { 8602 /* la */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8605 /* la.tls.gd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8615 /* la.tls.ie */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8625 /* la.tlsdesc */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8636 /* lb */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8639 /* lb.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8645 /* lb.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8653 /* lbu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8657 /* ld */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 8657 /* ld */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtZilsd_IsRV32 },
  { 8657 /* ld */, 1 /* 0 */, MCK_GPRPairRV32, AMFBS_HasStdExtZilsd_IsRV32 },
  { 8657 /* ld */, 1 /* 0 */, MCK_GPRPairRV32, AMFBS_HasStdExtZilsd_IsRV32 },
  { 8657 /* ld */, 1 /* 0 */, MCK_GPRPairRV32, AMFBS_HasStdExtZilsd_IsRV32 },
  { 8660 /* ld.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr_IsRV64 },
  { 8666 /* ld.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr_IsRV64 },
  { 8674 /* lga */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8678 /* lh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8681 /* lh.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8687 /* lh.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8695 /* lhu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8702 /* lla */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8711 /* lr.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 8716 /* lr.d.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 8724 /* lr.d.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 8734 /* lr.d.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 8742 /* lr.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 8747 /* lr.w.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 8755 /* lr.w.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 8765 /* lr.w.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 8777 /* lw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8780 /* lw.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8786 /* lw.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8794 /* lwu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 9585 /* nds.vd4dots.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXAndesVDot },
  { 9600 /* nds.vd4dotsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXAndesVDot },
  { 9616 /* nds.vd4dotu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXAndesVDot },
  { 9649 /* nds.vfpmadb.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXAndesVPackFPH },
  { 9664 /* nds.vfpmadt.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXAndesVPackFPH },
  { 9697 /* nds.vln8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXAndesVSIntLoad },
  { 9697 /* nds.vln8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVendorXAndesVSIntLoad },
  { 9708 /* nds.vlnu8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXAndesVSIntLoad },
  { 9708 /* nds.vlnu8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVendorXAndesVSIntLoad },
  { 10336 /* qc.cm.pop */, 1 /* 0 */, MCK_RegList, AMFBS_HasVendorXqccmp },
  { 10336 /* qc.cm.pop */, 2 /* 1 */, MCK_StackAdj, AMFBS_HasVendorXqccmp },
  { 10346 /* qc.cm.popret */, 1 /* 0 */, MCK_RegList, AMFBS_HasVendorXqccmp },
  { 10346 /* qc.cm.popret */, 2 /* 1 */, MCK_StackAdj, AMFBS_HasVendorXqccmp },
  { 10359 /* qc.cm.popretz */, 1 /* 0 */, MCK_RegList, AMFBS_HasVendorXqccmp },
  { 10359 /* qc.cm.popretz */, 2 /* 1 */, MCK_StackAdj, AMFBS_HasVendorXqccmp },
  { 10373 /* qc.cm.push */, 2 /* 1 */, MCK_NegStackAdj, AMFBS_HasVendorXqccmp },
  { 10373 /* qc.cm.push */, 1 /* 0 */, MCK_RegList, AMFBS_HasVendorXqccmp },
  { 10384 /* qc.cm.pushfp */, 2 /* 1 */, MCK_NegStackAdj, AMFBS_HasVendorXqccmp },
  { 10384 /* qc.cm.pushfp */, 1 /* 0 */, MCK_RegListS0, AMFBS_HasVendorXqccmp },
  { 10571 /* qc.e.lb */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasVendorXqcilo_IsRV32 },
  { 10579 /* qc.e.lbu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasVendorXqcilo_IsRV32 },
  { 10588 /* qc.e.lh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasVendorXqcilo_IsRV32 },
  { 10596 /* qc.e.lhu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasVendorXqcilo_IsRV32 },
  { 10605 /* qc.e.li */, 2 /* 1 */, MCK_BareSymbolQC_E_LI, AMFBS_HasVendorXqcili_IsRV32 },
  { 10613 /* qc.e.lw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasVendorXqcilo_IsRV32 },
  { 10640 /* qc.e.sb */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasVendorXqcilo_IsRV32 },
  { 10648 /* qc.e.sh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasVendorXqcilo_IsRV32 },
  { 10656 /* qc.e.sw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasVendorXqcilo_IsRV32 },
  { 11774 /* ri.vunzip2a.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXRivosVizip },
  { 11789 /* ri.vunzip2b.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXRivosVizip },
  { 11815 /* ri.vzip2a.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXRivosVizip },
  { 11828 /* ri.vzip2b.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXRivosVizip },
  { 11841 /* ri.vzipeven.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXRivosVizip },
  { 11856 /* ri.vzipodd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXRivosVizip },
  { 11899 /* sb */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 11902 /* sb.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 11910 /* sb.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 11916 /* sc.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 11921 /* sc.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 11929 /* sc.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 11939 /* sc.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 11947 /* sc.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 11952 /* sc.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 11960 /* sc.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 11970 /* sc.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 11986 /* sd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 11986 /* sd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtZilsd_IsRV32 },
  { 11986 /* sd */, 1 /* 0 */, MCK_GPRPairRV32, AMFBS_HasStdExtZilsd_IsRV32 },
  { 11986 /* sd */, 1 /* 0 */, MCK_GPRPairRV32, AMFBS_HasStdExtZilsd_IsRV32 },
  { 11986 /* sd */, 1 /* 0 */, MCK_GPRPairRV32, AMFBS_HasStdExtZilsd_IsRV32 },
  { 11989 /* sd.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr_IsRV64 },
  { 11997 /* sd.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr_IsRV64 },
  { 12476 /* sf.vfnrclip.x.f.qf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXSfvfnrclipxfqf },
  { 12495 /* sf.vfnrclip.xu.f.qf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXSfvfnrclipxfqf },
  { 12532 /* sf.vlte16 */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVendorXSfmmbase },
  { 12542 /* sf.vlte32 */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVendorXSfmmbase },
  { 12552 /* sf.vlte64 */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVendorXSfmmbase },
  { 12562 /* sf.vlte8 */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVendorXSfmmbase },
  { 12739 /* sf.vsettnt */, 4 /* 2 */, MCK_XSfmmVType, AMFBS_HasVendorXSfmmbase },
  { 12750 /* sf.vste16 */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVendorXSfmmbase },
  { 12760 /* sf.vste32 */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVendorXSfmmbase },
  { 12770 /* sf.vste64 */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVendorXSfmmbase },
  { 12780 /* sf.vste8 */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVendorXSfmmbase },
  { 12894 /* sh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 12897 /* sh.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 12905 /* sh.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 13260 /* ssamoswap.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 13272 /* ssamoswap.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 13287 /* ssamoswap.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 13304 /* ssamoswap.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 13319 /* ssamoswap.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 13331 /* ssamoswap.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 13346 /* ssamoswap.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 13363 /* ssamoswap.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 13415 /* sw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 13418 /* sw.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 13426 /* sw.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 13432 /* tail */, 1 /* 0 */, MCK_CallSymbol, AMFBS_None },
  { 14420 /* th.vmaqa.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 14432 /* th.vmaqa.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 14444 /* th.vmaqasu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 14458 /* th.vmaqasu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 14472 /* th.vmaqau.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 14485 /* th.vmaqau.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 14498 /* th.vmaqaus.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 14524 /* vaadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14533 /* vaadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14542 /* vaaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14552 /* vaaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14589 /* vadd.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14597 /* vadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14605 /* vadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14724 /* vand.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14732 /* vand.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14740 /* vand.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14748 /* vandn.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 14757 /* vandn.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 14766 /* vasub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14775 /* vasub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14784 /* vasubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14794 /* vasubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14804 /* vbrev.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 14812 /* vbrev8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 14821 /* vclmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbcOrZvbc32e },
  { 14831 /* vclmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbcOrZvbc32e },
  { 14841 /* vclmulh.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbcOrZvbc32e },
  { 14852 /* vclmulh.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbcOrZvbc32e },
  { 14863 /* vclz.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 14883 /* vcpop.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14891 /* vcpop.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 14899 /* vctz.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 14906 /* vdiv.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14914 /* vdiv.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14922 /* vdivu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14931 /* vdivu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14940 /* vfabs.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14948 /* vfadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14957 /* vfadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14966 /* vfclass.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14976 /* vfcvt.f.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14988 /* vfcvt.f.xu.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15001 /* vfcvt.rtz.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15017 /* vfcvt.rtz.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15034 /* vfcvt.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15046 /* vfcvt.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15059 /* vfdiv.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15068 /* vfdiv.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15077 /* vfirst.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15086 /* vfmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15096 /* vfmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15106 /* vfmadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15116 /* vfmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15126 /* vfmax.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15135 /* vfmax.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15156 /* vfmin.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15165 /* vfmin.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15174 /* vfmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15184 /* vfmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15194 /* vfmsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15204 /* vfmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15214 /* vfmul.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15223 /* vfmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15259 /* vfncvt.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15272 /* vfncvt.f.x.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15285 /* vfncvt.f.xu.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15299 /* vfncvt.rod.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15316 /* vfncvt.rtz.x.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15333 /* vfncvt.rtz.xu.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15351 /* vfncvt.x.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15364 /* vfncvt.xu.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15378 /* vfncvtbf16.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfmin },
  { 15395 /* vfneg.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15403 /* vfnmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15414 /* vfnmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15425 /* vfnmadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15436 /* vfnmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15447 /* vfnmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15458 /* vfnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15469 /* vfnmsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15480 /* vfnmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15491 /* vfrdiv.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15501 /* vfrec7.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15510 /* vfredmax.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15522 /* vfredmin.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15534 /* vfredosum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15547 /* vfredusum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15560 /* vfrsqrt7.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15571 /* vfrsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15581 /* vfsgnj.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15591 /* vfsgnj.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15601 /* vfsgnjn.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15612 /* vfsgnjn.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15623 /* vfsgnjx.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15634 /* vfsgnjx.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15645 /* vfslide1down.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15661 /* vfslide1up.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15675 /* vfsqrt.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15684 /* vfsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15693 /* vfsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15702 /* vfwadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15712 /* vfwadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15722 /* vfwadd.wf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15732 /* vfwadd.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15742 /* vfwcvt.f.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15755 /* vfwcvt.f.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15768 /* vfwcvt.f.xu.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15782 /* vfwcvt.rtz.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15799 /* vfwcvt.rtz.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15817 /* vfwcvt.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15830 /* vfwcvt.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15844 /* vfwcvtbf16.f.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfmin },
  { 15861 /* vfwmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15872 /* vfwmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15883 /* vfwmaccbf16.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfwma },
  { 15898 /* vfwmaccbf16.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfwma },
  { 15913 /* vfwmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15924 /* vfwmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15935 /* vfwmul.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15945 /* vfwmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15955 /* vfwnmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15967 /* vfwnmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15979 /* vfwnmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 15991 /* vfwnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16003 /* vfwredosum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16017 /* vfwredusum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16031 /* vfwsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16041 /* vfwsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16051 /* vfwsub.wf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16061 /* vfwsub.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16107 /* vid.v */, 2 /* 1 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16113 /* viota.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16121 /* vl1r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16128 /* vl1re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16138 /* vl1re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16148 /* vl1re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16158 /* vl1re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16167 /* vl2r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16174 /* vl2re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16184 /* vl2re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16194 /* vl2re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16204 /* vl2re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16213 /* vl4r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16220 /* vl4re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16230 /* vl4re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16240 /* vl4re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16250 /* vl4re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16259 /* vl8r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16266 /* vl8re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16276 /* vl8re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16286 /* vl8re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16296 /* vl8re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16305 /* vle16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16305 /* vle16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16313 /* vle16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16313 /* vle16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16323 /* vle32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16323 /* vle32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16331 /* vle32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16331 /* vle32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16341 /* vle64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16341 /* vle64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16349 /* vle64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16349 /* vle64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16359 /* vle8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16359 /* vle8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16366 /* vle8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16366 /* vle8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16375 /* vlm.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16381 /* vloxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16381 /* vloxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16392 /* vloxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16392 /* vloxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16403 /* vloxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 16403 /* vloxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 16414 /* vloxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16414 /* vloxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16424 /* vloxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16424 /* vloxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16439 /* vloxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16439 /* vloxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16454 /* vloxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16454 /* vloxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16469 /* vloxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16469 /* vloxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16483 /* vloxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16483 /* vloxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16498 /* vloxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16498 /* vloxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16513 /* vloxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16513 /* vloxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16528 /* vloxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16528 /* vloxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16542 /* vloxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16542 /* vloxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16557 /* vloxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16557 /* vloxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16572 /* vloxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16572 /* vloxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16587 /* vloxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16587 /* vloxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16601 /* vloxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16601 /* vloxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16616 /* vloxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16616 /* vloxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16631 /* vloxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16631 /* vloxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16646 /* vloxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16646 /* vloxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16660 /* vloxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16660 /* vloxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16675 /* vloxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16675 /* vloxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16690 /* vloxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16690 /* vloxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16705 /* vloxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16705 /* vloxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16719 /* vloxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16719 /* vloxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16734 /* vloxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16734 /* vloxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16749 /* vloxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16749 /* vloxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16764 /* vloxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16764 /* vloxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16778 /* vloxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16778 /* vloxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16793 /* vloxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16793 /* vloxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16808 /* vloxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16808 /* vloxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16823 /* vloxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16823 /* vloxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16837 /* vlse16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16837 /* vlse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16846 /* vlse32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16846 /* vlse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16855 /* vlse64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16855 /* vlse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16864 /* vlse8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16864 /* vlse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16872 /* vlseg2e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16872 /* vlseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16884 /* vlseg2e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16884 /* vlseg2e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16898 /* vlseg2e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16898 /* vlseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16910 /* vlseg2e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16910 /* vlseg2e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16924 /* vlseg2e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16924 /* vlseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16936 /* vlseg2e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16936 /* vlseg2e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16950 /* vlseg2e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16950 /* vlseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16961 /* vlseg2e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16961 /* vlseg2e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16974 /* vlseg3e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16974 /* vlseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16986 /* vlseg3e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16986 /* vlseg3e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17000 /* vlseg3e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17000 /* vlseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17012 /* vlseg3e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17012 /* vlseg3e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17026 /* vlseg3e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17026 /* vlseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17038 /* vlseg3e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17038 /* vlseg3e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17052 /* vlseg3e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17052 /* vlseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17063 /* vlseg3e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17063 /* vlseg3e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17076 /* vlseg4e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17076 /* vlseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17088 /* vlseg4e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17088 /* vlseg4e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17102 /* vlseg4e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17102 /* vlseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17114 /* vlseg4e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17114 /* vlseg4e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17128 /* vlseg4e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17128 /* vlseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17140 /* vlseg4e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17140 /* vlseg4e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17154 /* vlseg4e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17154 /* vlseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17165 /* vlseg4e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17165 /* vlseg4e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17178 /* vlseg5e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17178 /* vlseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17190 /* vlseg5e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17190 /* vlseg5e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17204 /* vlseg5e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17204 /* vlseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17216 /* vlseg5e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17216 /* vlseg5e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17230 /* vlseg5e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17230 /* vlseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17242 /* vlseg5e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17242 /* vlseg5e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17256 /* vlseg5e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17256 /* vlseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17267 /* vlseg5e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17267 /* vlseg5e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17280 /* vlseg6e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17280 /* vlseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17292 /* vlseg6e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17292 /* vlseg6e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17306 /* vlseg6e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17306 /* vlseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17318 /* vlseg6e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17318 /* vlseg6e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17332 /* vlseg6e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17332 /* vlseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17344 /* vlseg6e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17344 /* vlseg6e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17358 /* vlseg6e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17358 /* vlseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17369 /* vlseg6e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17369 /* vlseg6e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17382 /* vlseg7e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17382 /* vlseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17394 /* vlseg7e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17394 /* vlseg7e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17408 /* vlseg7e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17408 /* vlseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17420 /* vlseg7e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17420 /* vlseg7e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17434 /* vlseg7e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17434 /* vlseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17446 /* vlseg7e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17446 /* vlseg7e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17460 /* vlseg7e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17460 /* vlseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17471 /* vlseg7e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17471 /* vlseg7e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17484 /* vlseg8e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17484 /* vlseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17496 /* vlseg8e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17496 /* vlseg8e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17510 /* vlseg8e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17510 /* vlseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17522 /* vlseg8e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17522 /* vlseg8e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17536 /* vlseg8e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17536 /* vlseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17548 /* vlseg8e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17548 /* vlseg8e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17562 /* vlseg8e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17562 /* vlseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17573 /* vlseg8e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17573 /* vlseg8e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17586 /* vlsseg2e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17586 /* vlsseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17599 /* vlsseg2e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17599 /* vlsseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17612 /* vlsseg2e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17612 /* vlsseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17625 /* vlsseg2e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17625 /* vlsseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17637 /* vlsseg3e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17637 /* vlsseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17650 /* vlsseg3e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17650 /* vlsseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17663 /* vlsseg3e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17663 /* vlsseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17676 /* vlsseg3e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17676 /* vlsseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17688 /* vlsseg4e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17688 /* vlsseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17701 /* vlsseg4e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17701 /* vlsseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17714 /* vlsseg4e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17714 /* vlsseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17727 /* vlsseg4e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17727 /* vlsseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17739 /* vlsseg5e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17739 /* vlsseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17752 /* vlsseg5e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17752 /* vlsseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17765 /* vlsseg5e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17765 /* vlsseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17778 /* vlsseg5e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17778 /* vlsseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17790 /* vlsseg6e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17790 /* vlsseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17803 /* vlsseg6e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17803 /* vlsseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17816 /* vlsseg6e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17816 /* vlsseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17829 /* vlsseg6e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17829 /* vlsseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17841 /* vlsseg7e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17841 /* vlsseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17854 /* vlsseg7e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17854 /* vlsseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17867 /* vlsseg7e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17867 /* vlsseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17880 /* vlsseg7e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17880 /* vlsseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17892 /* vlsseg8e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17892 /* vlsseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17905 /* vlsseg8e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17905 /* vlsseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17918 /* vlsseg8e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17918 /* vlsseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17931 /* vlsseg8e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17931 /* vlsseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17943 /* vluxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17943 /* vluxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17954 /* vluxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17954 /* vluxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17965 /* vluxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 17965 /* vluxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 17976 /* vluxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17976 /* vluxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17986 /* vluxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17986 /* vluxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18001 /* vluxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18001 /* vluxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18016 /* vluxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18016 /* vluxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18031 /* vluxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18031 /* vluxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18045 /* vluxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18045 /* vluxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18060 /* vluxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18060 /* vluxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18075 /* vluxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18075 /* vluxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18090 /* vluxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18090 /* vluxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18104 /* vluxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18104 /* vluxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18119 /* vluxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18119 /* vluxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18134 /* vluxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18134 /* vluxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18149 /* vluxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18149 /* vluxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18163 /* vluxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18163 /* vluxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18178 /* vluxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18178 /* vluxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18193 /* vluxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18193 /* vluxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18208 /* vluxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18208 /* vluxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18222 /* vluxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18222 /* vluxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18237 /* vluxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18237 /* vluxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18252 /* vluxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18252 /* vluxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18267 /* vluxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18267 /* vluxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18281 /* vluxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18281 /* vluxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18296 /* vluxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18296 /* vluxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18311 /* vluxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18311 /* vluxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18326 /* vluxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18326 /* vluxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18340 /* vluxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18340 /* vluxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18355 /* vluxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18355 /* vluxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18370 /* vluxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18370 /* vluxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18385 /* vluxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18385 /* vluxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18399 /* vmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18408 /* vmacc.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18474 /* vmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18483 /* vmadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18511 /* vmax.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18519 /* vmax.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18527 /* vmaxu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18536 /* vmaxu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18586 /* vmfeq.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18595 /* vmfeq.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18604 /* vmfge.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18613 /* vmfge.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18622 /* vmfgt.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18631 /* vmfgt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18640 /* vmfle.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18649 /* vmfle.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18658 /* vmflt.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18667 /* vmflt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18676 /* vmfne.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18685 /* vmfne.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 18694 /* vmin.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18702 /* vmin.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18710 /* vminu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18719 /* vminu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18817 /* vmsbf.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18825 /* vmseq.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18834 /* vmseq.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18843 /* vmseq.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18860 /* vmsge.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18869 /* vmsge.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18878 /* vmsge.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18878 /* vmsge.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18887 /* vmsgeu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18897 /* vmsgeu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18907 /* vmsgeu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18907 /* vmsgeu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18917 /* vmsgt.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18926 /* vmsgt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18935 /* vmsgt.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18944 /* vmsgtu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18954 /* vmsgtu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18964 /* vmsgtu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18974 /* vmsif.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18982 /* vmsle.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18991 /* vmsle.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19000 /* vmsle.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19009 /* vmsleu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19019 /* vmsleu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19029 /* vmsleu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19039 /* vmslt.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19048 /* vmslt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19057 /* vmslt.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19066 /* vmsltu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19076 /* vmsltu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19086 /* vmsltu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19096 /* vmsne.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19105 /* vmsne.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19114 /* vmsne.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19123 /* vmsof.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19131 /* vmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19139 /* vmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19147 /* vmulh.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19156 /* vmulh.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19165 /* vmulhsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19176 /* vmulhsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19187 /* vmulhu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19197 /* vmulhu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19298 /* vnclip.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19308 /* vnclip.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19318 /* vnclip.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19328 /* vnclipu.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19339 /* vnclipu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19350 /* vnclipu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19361 /* vncvt.x.x.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19373 /* vneg.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19380 /* vnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19390 /* vnmsac.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19400 /* vnmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19410 /* vnmsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19420 /* vnot.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19427 /* vnsra.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19436 /* vnsra.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19445 /* vnsra.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19454 /* vnsrl.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19463 /* vnsrl.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19472 /* vnsrl.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19481 /* vor.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19488 /* vor.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19495 /* vor.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19502 /* vqdot.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvqdotq },
  { 19511 /* vqdot.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvqdotq },
  { 19520 /* vqdotsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvqdotq },
  { 19531 /* vqdotsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvqdotq },
  { 19542 /* vqdotu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvqdotq },
  { 19552 /* vqdotu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvqdotq },
  { 19562 /* vqdotus.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvqdotq },
  { 19573 /* vredand.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19584 /* vredmax.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19595 /* vredmaxu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19607 /* vredmin.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19618 /* vredminu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19630 /* vredor.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19640 /* vredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19651 /* vredxor.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19662 /* vrem.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19670 /* vrem.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19678 /* vremu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19687 /* vremu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19696 /* vrev8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 19704 /* vrgather.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19716 /* vrgather.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19728 /* vrgather.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19740 /* vrgatherei16.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19756 /* vrol.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 19764 /* vrol.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 19772 /* vror.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 19780 /* vror.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 19788 /* vror.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 19796 /* vrsub.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19805 /* vrsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19814 /* vs1r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19821 /* vs2r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19828 /* vs4r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19835 /* vs8r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19842 /* vsadd.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19851 /* vsadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19860 /* vsadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19869 /* vsaddu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19879 /* vsaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19889 /* vsaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19917 /* vse16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19917 /* vse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19925 /* vse32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19925 /* vse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19933 /* vse64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 19933 /* vse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 19941 /* vse8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19941 /* vse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19948 /* vsetivli */, 4 /* 2 */, MCK_VTypeI10, AMFBS_HasVInstructions },
  { 19964 /* vsetvli */, 4 /* 2 */, MCK_VTypeI11, AMFBS_HasVInstructions },
  { 19972 /* vsext.vf2 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19982 /* vsext.vf4 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19992 /* vsext.vf8 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20035 /* vslide1down.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20050 /* vslide1up.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20063 /* vslidedown.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20077 /* vslidedown.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20091 /* vslideup.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20103 /* vslideup.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20115 /* vsll.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20123 /* vsll.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20131 /* vsll.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20139 /* vsm.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20191 /* vsmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20200 /* vsmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20209 /* vsoxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20209 /* vsoxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20220 /* vsoxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20220 /* vsoxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20231 /* vsoxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 20231 /* vsoxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 20242 /* vsoxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20242 /* vsoxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20252 /* vsoxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20252 /* vsoxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20267 /* vsoxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20267 /* vsoxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20282 /* vsoxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20282 /* vsoxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20297 /* vsoxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20297 /* vsoxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20311 /* vsoxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20311 /* vsoxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20326 /* vsoxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20326 /* vsoxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20341 /* vsoxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20341 /* vsoxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20356 /* vsoxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20356 /* vsoxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20370 /* vsoxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20370 /* vsoxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20385 /* vsoxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20385 /* vsoxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20400 /* vsoxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20400 /* vsoxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20415 /* vsoxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20415 /* vsoxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20429 /* vsoxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20429 /* vsoxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20444 /* vsoxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20444 /* vsoxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20459 /* vsoxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20459 /* vsoxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20474 /* vsoxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20474 /* vsoxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20488 /* vsoxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20488 /* vsoxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20503 /* vsoxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20503 /* vsoxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20518 /* vsoxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20518 /* vsoxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20533 /* vsoxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20533 /* vsoxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20547 /* vsoxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20547 /* vsoxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20562 /* vsoxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20562 /* vsoxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20577 /* vsoxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20577 /* vsoxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20592 /* vsoxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20592 /* vsoxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20606 /* vsoxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20606 /* vsoxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20621 /* vsoxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20621 /* vsoxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20636 /* vsoxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20636 /* vsoxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 20651 /* vsoxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20651 /* vsoxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20665 /* vsra.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20673 /* vsra.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20681 /* vsra.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20689 /* vsrl.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20697 /* vsrl.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20705 /* vsrl.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20713 /* vsse16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20713 /* vsse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20722 /* vsse32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20722 /* vsse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20731 /* vsse64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 20731 /* vsse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 20740 /* vsse8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20740 /* vsse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20748 /* vsseg2e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20748 /* vsseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20760 /* vsseg2e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20760 /* vsseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20772 /* vsseg2e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 20772 /* vsseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 20784 /* vsseg2e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20784 /* vsseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20795 /* vsseg3e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20795 /* vsseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20807 /* vsseg3e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20807 /* vsseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20819 /* vsseg3e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 20819 /* vsseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 20831 /* vsseg3e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20831 /* vsseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20842 /* vsseg4e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20842 /* vsseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20854 /* vsseg4e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20854 /* vsseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20866 /* vsseg4e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 20866 /* vsseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 20878 /* vsseg4e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20878 /* vsseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20889 /* vsseg5e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20889 /* vsseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20901 /* vsseg5e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20901 /* vsseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20913 /* vsseg5e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 20913 /* vsseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 20925 /* vsseg5e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20925 /* vsseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20936 /* vsseg6e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20936 /* vsseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20948 /* vsseg6e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20948 /* vsseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20960 /* vsseg6e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 20960 /* vsseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 20972 /* vsseg6e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20972 /* vsseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20983 /* vsseg7e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20983 /* vsseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 20995 /* vsseg7e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20995 /* vsseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21007 /* vsseg7e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 21007 /* vsseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 21019 /* vsseg7e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21019 /* vsseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21030 /* vsseg8e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21030 /* vsseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21042 /* vsseg8e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21042 /* vsseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21054 /* vsseg8e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 21054 /* vsseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 21066 /* vsseg8e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21066 /* vsseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21077 /* vssra.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21086 /* vssra.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21095 /* vssra.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21104 /* vssrl.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21113 /* vssrl.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21122 /* vssrl.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21131 /* vssseg2e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21131 /* vssseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21144 /* vssseg2e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21144 /* vssseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21157 /* vssseg2e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 21157 /* vssseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 21170 /* vssseg2e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21170 /* vssseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21182 /* vssseg3e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21182 /* vssseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21195 /* vssseg3e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21195 /* vssseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21208 /* vssseg3e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 21208 /* vssseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 21221 /* vssseg3e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21221 /* vssseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21233 /* vssseg4e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21233 /* vssseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21246 /* vssseg4e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21246 /* vssseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21259 /* vssseg4e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 21259 /* vssseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 21272 /* vssseg4e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21272 /* vssseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21284 /* vssseg5e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21284 /* vssseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21297 /* vssseg5e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21297 /* vssseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21310 /* vssseg5e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 21310 /* vssseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 21323 /* vssseg5e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21323 /* vssseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21335 /* vssseg6e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21335 /* vssseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21348 /* vssseg6e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21348 /* vssseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21361 /* vssseg6e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 21361 /* vssseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 21374 /* vssseg6e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21374 /* vssseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21386 /* vssseg7e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21386 /* vssseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21399 /* vssseg7e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21399 /* vssseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21412 /* vssseg7e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 21412 /* vssseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 21425 /* vssseg7e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21425 /* vssseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21437 /* vssseg8e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21437 /* vssseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21450 /* vssseg8e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21450 /* vssseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21463 /* vssseg8e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 21463 /* vssseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 21476 /* vssseg8e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21476 /* vssseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21488 /* vssub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21497 /* vssub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21506 /* vssubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21516 /* vssubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21526 /* vsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21534 /* vsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21542 /* vsuxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21542 /* vsuxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21553 /* vsuxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21553 /* vsuxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21564 /* vsuxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 21564 /* vsuxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 21575 /* vsuxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21575 /* vsuxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21585 /* vsuxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21585 /* vsuxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21600 /* vsuxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21600 /* vsuxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21615 /* vsuxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21615 /* vsuxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21630 /* vsuxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21630 /* vsuxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21644 /* vsuxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21644 /* vsuxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21659 /* vsuxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21659 /* vsuxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21674 /* vsuxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21674 /* vsuxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21689 /* vsuxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21689 /* vsuxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21703 /* vsuxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21703 /* vsuxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21718 /* vsuxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21718 /* vsuxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21733 /* vsuxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21733 /* vsuxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21748 /* vsuxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21748 /* vsuxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21762 /* vsuxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21762 /* vsuxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21777 /* vsuxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21777 /* vsuxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21792 /* vsuxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21792 /* vsuxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21807 /* vsuxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21807 /* vsuxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21821 /* vsuxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21821 /* vsuxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21836 /* vsuxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21836 /* vsuxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21851 /* vsuxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21851 /* vsuxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21866 /* vsuxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21866 /* vsuxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21880 /* vsuxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21880 /* vsuxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21895 /* vsuxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21895 /* vsuxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21910 /* vsuxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21910 /* vsuxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21925 /* vsuxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21925 /* vsuxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21939 /* vsuxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21939 /* vsuxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21954 /* vsuxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21954 /* vsuxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 21969 /* vsuxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21969 /* vsuxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 21984 /* vsuxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 21984 /* vsuxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 22017 /* vwadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22026 /* vwadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22035 /* vwadd.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22044 /* vwadd.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22053 /* vwaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22063 /* vwaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22073 /* vwaddu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22083 /* vwaddu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22093 /* vwcvt.x.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22105 /* vwcvtu.x.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22118 /* vwmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22128 /* vwmacc.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22138 /* vwmaccsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22150 /* vwmaccsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22162 /* vwmaccu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22173 /* vwmaccu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22184 /* vwmaccus.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22196 /* vwmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22205 /* vwmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22214 /* vwmulsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22225 /* vwmulsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22236 /* vwmulu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22246 /* vwmulu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22256 /* vwredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22268 /* vwredsumu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22281 /* vwsll.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 22290 /* vwsll.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 22299 /* vwsll.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 22308 /* vwsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22317 /* vwsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22326 /* vwsub.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22335 /* vwsub.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22344 /* vwsubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22354 /* vwsubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22364 /* vwsubu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22374 /* vwsubu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22384 /* vxor.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22392 /* vxor.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22400 /* vxor.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22408 /* vzext.vf2 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22418 /* vzext.vf4 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 22428 /* vzext.vf8 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
};

ParseStatus RISCVAsmParser::
tryCustomParseOperand(OperandVector &Operands,
                      unsigned MCK) {

  switch(MCK) {
  case MCK_BareSymbol:
    return parseBareSymbol(Operands);
  case MCK_BareSymbolQC_E_LI:
    return parseBareSymbol(Operands);
  case MCK_CSRSystemRegister:
    return parseCSRSystemRegister(Operands);
  case MCK_RegReg:
    return parseRegReg(Operands);
  case MCK_CallSymbol:
    return parseCallSymbol(Operands);
  case MCK_FRMArg:
    return parseFRMArg(Operands);
  case MCK_FRMArgLegacy:
    return parseFRMArg(Operands);
  case MCK_FenceArg:
    return parseFenceArg(Operands);
  case MCK_GPRAsFPR16:
    return parseGPRAsFPR(Operands);
  case MCK_GPRAsFPR32:
    return parseGPRAsFPR(Operands);
  case MCK_GPRF64AsFPR:
    return parseGPRAsFPR64(Operands);
  case MCK_GPRPairAsFPR:
    return parseGPRPairAsFPR64(Operands);
  case MCK_GPRPairCRV32:
    return parseGPRPair<false>(Operands);
  case MCK_GPRPairNoX0RV32:
    return parseGPRPair<false>(Operands);
  case MCK_GPRPairRV32:
    return parseGPRPair<false>(Operands);
  case MCK_GPRPairRV64:
    return parseGPRPair<true>(Operands);
  case MCK_InsnCDirectiveOpcode:
    return parseInsnCDirectiveOpcode(Operands);
  case MCK_InsnDirectiveOpcode:
    return parseInsnDirectiveOpcode(Operands);
  case MCK_LoadFPImm:
    return parseFPImm(Operands);
  case MCK_NegStackAdj:
    return parseZcmpNegStackAdj(Operands);
  case MCK_PseudoJumpSymbol:
    return parsePseudoJumpSymbol(Operands);
  case MCK_RTZArg:
    return parseFRMArg(Operands);
  case MCK_RegList:
    return parseRegList(Operands);
  case MCK_RegListS0:
    return parseRegListS0(Operands);
  case MCK_BareSImm21Lsb0:
    return parseJALOffset(Operands);
  case MCK_StackAdj:
    return parseZcmpStackAdj(Operands);
  case MCK_TLSDESCCallSymbol:
    return parseOperandWithSpecifier(Operands);
  case MCK_TPRelAddSymbol:
    return parseOperandWithSpecifier(Operands);
  case MCK_RVVMaskRegOpOperand:
    return parseMaskReg(Operands);
  case MCK_XSfmmVType:
    return parseXSfmmVType(Operands);
  case MCK_ZeroOffsetMemOpOperand:
    return parseZeroOffsetMemOp(Operands);
  case MCK_VTypeI10:
    return parseVTypeI(Operands);
  case MCK_VTypeI11:
    return parseVTypeI(Operands);
  default:
    return ParseStatus::NoMatch;
  }
  return ParseStatus::NoMatch;
}

ParseStatus RISCVAsmParser::
MatchOperandParserImpl(OperandVector &Operands,
                       StringRef Mnemonic,
                       bool ParseForAllFeatures) {
  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the next operand index.
  unsigned NextOpNum = Operands.size() - 1;
  // Search the table.
  auto MnemonicRange =
    std::equal_range(std::begin(OperandMatchTable), std::end(OperandMatchTable),
                     Mnemonic, LessOpcodeOperand());

  if (MnemonicRange.first == MnemonicRange.second)
    return ParseStatus::NoMatch;

  for (const OperandMatchEntry *it = MnemonicRange.first,
       *ie = MnemonicRange.second; it != ie; ++it) {
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());

    // check if the available features match
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    if (!ParseForAllFeatures && (AvailableFeatures & RequiredFeatures) != RequiredFeatures)
      continue;

    // check if the operand in question has a custom parser.
    if (!(it->OperandMask & (1 << NextOpNum)))
      continue;

    // call custom parse method to handle the operand
    ParseStatus Result = tryCustomParseOperand(Operands, it->Class);
    if (!Result.isNoMatch())
      return Result;
  }

  // Okay, we had no match.
  return ParseStatus::NoMatch;
}

#endif // GET_MATCHER_IMPLEMENTATION


#ifdef GET_MNEMONIC_SPELL_CHECKER
#undef GET_MNEMONIC_SPELL_CHECKER

static std::string RISCVMnemonicSpellCheck(StringRef S, const FeatureBitset &FBS, unsigned VariantID) {
  const unsigned MaxEditDist = 2;
  std::vector<StringRef> Candidates;
  StringRef Prev = "";

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  for (auto I = Start; I < End; I++) {
    // Ignore unsupported instructions.
    const FeatureBitset &RequiredFeatures = FeatureBitsets[I->RequiredFeaturesIdx];
    if ((FBS & RequiredFeatures) != RequiredFeatures)
      continue;

    StringRef T = I->getMnemonic();
    // Avoid recomputing the edit distance for the same string.
    if (T == Prev)
      continue;

    Prev = T;
    unsigned Dist = S.edit_distance(T, false, MaxEditDist);
    if (Dist <= MaxEditDist)
      Candidates.push_back(T);
  }

  if (Candidates.empty())
    return "";

  std::string Res = ", did you mean: ";
  unsigned i = 0;
  for (; i < Candidates.size() - 1; i++)
    Res += Candidates[i].str() + ", ";
  return Res + Candidates[i].str() + "?";
}

#endif // GET_MNEMONIC_SPELL_CHECKER


#ifdef GET_MNEMONIC_CHECKER
#undef GET_MNEMONIC_CHECKER

static bool RISCVCheckMnemonic(StringRef Mnemonic,
                                const FeatureBitset &AvailableFeatures,
                                unsigned VariantID) {
  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  if (MnemonicRange.first == MnemonicRange.second)
    return false;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures =
      FeatureBitsets[it->RequiredFeaturesIdx];
    if ((AvailableFeatures & RequiredFeatures) == RequiredFeatures)
      return true;
  }
  return false;
}

#endif // GET_MNEMONIC_CHECKER

