/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.Session;
import org.apache.wicket.core.util.string.interpolator.PropertyVariableInterpolator;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class StringResourceModel
extends LoadableDetachableModel<String>
implements IComponentAssignedModel<String> {
    private static final long serialVersionUID = 1L;
    private final String resourceKey;
    private final Component component;
    private IModel<?> model;
    private Object[] parameters;
    private IModel<String> defaultValue;

    @Override
    public IWrapModel<String> wrapOnAssignment(Component component) {
        return new AssignmentWrapper(component);
    }

    public StringResourceModel(String resourceKey, Component component, IModel<?> model) {
        Args.notNull(resourceKey, "resource key");
        this.resourceKey = resourceKey;
        this.component = component;
        this.model = model;
    }

    public StringResourceModel(String resourceKey, Component component) {
        this(resourceKey, component, null);
    }

    public StringResourceModel(String resourceKey, IModel<?> model) {
        this(resourceKey, null, model);
    }

    public StringResourceModel(String resourceKey) {
        this(resourceKey, null, null);
    }

    public StringResourceModel setDefaultValue(IModel<String> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public StringResourceModel setDefaultValue(String defaultValue) {
        return this.setDefaultValue(Model.of(defaultValue));
    }

    public StringResourceModel setModel(IModel<?> model) {
        this.model = model;
        return this;
    }

    public StringResourceModel setParameters(Object ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public Localizer getLocalizer() {
        return Application.get().getResourceSettings().getLocalizer();
    }

    public final String getString() {
        return this.getString(this.component);
    }

    protected String getString(Component component) {
        String value;
        Localizer localizer = this.getLocalizer();
        Object[] parameters = this.getParameters();
        if (parameters == null || parameters.length == 0) {
            value = localizer.getString(this.getResourceKey(), component, this.model, null, null, this.defaultValue);
        } else {
            value = localizer.getString(this.getResourceKey(), component, null, null, null, this.defaultValue);
            if (value != null) {
                Object[] realParams = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    realParams[i] = parameters[i] instanceof IModel ? ((IModel)parameters[i]).getObject() : (this.model != null && parameters[i] instanceof String ? localizer.substitutePropertyExpressions(component, (String)parameters[i], this.model) : parameters[i]);
                }
                if (value.indexOf(39) != -1) {
                    value = this.escapeQuotes(value);
                }
                if (this.model != null) {
                    value = Strings.replaceAll(value, "${", "$'{'").toString();
                }
                MessageFormat format = new MessageFormat(value, this.getLocale());
                value = format.format(realParams);
                if (this.model != null) {
                    value = Strings.replaceAll(value, "$'{'", "${").toString();
                    value = localizer.substitutePropertyExpressions(component, value, this.model);
                }
            }
        }
        return value;
    }

    protected Locale getLocale() {
        Locale locale = this.component != null ? this.component.getLocale() : (Session.exists() ? Session.get().getLocale() : Locale.getDefault());
        return locale;
    }

    private String escapeQuotes(String value) {
        StringBuilder newValue = new StringBuilder(value.length() + 10);
        int count = 0;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '{') {
                ++count;
            } else if (ch == '}') {
                --count;
            }
            newValue.append(ch);
            if (ch != '\'' || count != 0) continue;
            newValue.append(ch);
        }
        return newValue.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StringResourceModel[");
        sb.append("key:");
        sb.append(this.resourceKey);
        sb.append(",default:");
        sb.append(this.defaultValue);
        sb.append(",params:");
        if (this.parameters != null) {
            sb.append(Arrays.asList(this.parameters));
        }
        sb.append(']');
        return sb.toString();
    }

    protected Object[] getParameters() {
        return this.parameters;
    }

    protected final String getResourceKey() {
        if (this.model != null) {
            return new PropertyVariableInterpolator(this.resourceKey, this.model.getObject()){

                @Override
                protected String getValue(String variableName) {
                    String result = super.getValue(variableName);
                    return result == null ? "null" : result;
                }
            }.toString();
        }
        return this.resourceKey;
    }

    @Override
    protected final String load() {
        return this.getString();
    }

    @Override
    public final void detach() {
        super.detach();
        if (this.model != null) {
            this.model.detach();
        }
        if (this.parameters != null) {
            for (Object parameter : this.parameters) {
                if (!(parameter instanceof IDetachable)) continue;
                ((IDetachable)parameter).detach();
            }
        }
        if (this.defaultValue != null) {
            this.defaultValue.detach();
        }
    }

    @Override
    public void setObject(String object) {
        throw new UnsupportedOperationException();
    }

    private class AssignmentWrapper
    extends LoadableDetachableModel<String>
    implements IWrapModel<String> {
        private static final long serialVersionUID = 1L;
        private final Component component;

        public AssignmentWrapper(Component component) {
            this.component = component;
        }

        @Override
        public void detach() {
            super.detach();
            StringResourceModel.this.detach();
        }

        @Override
        protected void onDetach() {
            if (StringResourceModel.this.component == null) {
                StringResourceModel.this.onDetach();
            }
        }

        @Override
        protected String load() {
            if (StringResourceModel.this.component != null) {
                return (String)StringResourceModel.this.getObject();
            }
            return StringResourceModel.this.getString(this.component);
        }

        @Override
        public void setObject(String object) {
            StringResourceModel.this.setObject(object);
        }

        @Override
        public IModel<String> getWrappedModel() {
            return StringResourceModel.this;
        }
    }
}

