/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.request.mapper.BasicResourceReferenceMapper;
import org.apache.wicket.request.mapper.ParentPathReferenceRewriter;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.util.lang.Args;

public class HashBasedResourceReferenceMapper
extends ParentPathReferenceRewriter {
    public HashBasedResourceReferenceMapper(IPageParametersEncoder pageParametersEncoder, Supplier<String> parentPathPartEscapeSequence, Supplier<IResourceCachingStrategy> cachingStrategy, boolean checkHashCollision, IHasher hasher) {
        super(new HashBasedBasicResourceReferenceMapper(pageParametersEncoder, cachingStrategy, checkHashCollision, hasher), parentPathPartEscapeSequence);
    }

    public static HashBasedResourceReferenceMapper withJavaHash(IPageParametersEncoder pageParametersEncoder, Supplier<String> parentPathPartEscapeSequence, Supplier<IResourceCachingStrategy> cachingStrategy, boolean checkHashCollision) {
        return HashBasedResourceReferenceMapper.withOtherHash(pageParametersEncoder, parentPathPartEscapeSequence, cachingStrategy, checkHashCollision, new IHasher(){

            @Override
            public long computeHash(String name) {
                return name != null ? (long)name.hashCode() : 0L;
            }
        });
    }

    public static HashBasedResourceReferenceMapper withOtherHash(IPageParametersEncoder pageParametersEncoder, Supplier<String> parentPathPartEscapeSequence, Supplier<IResourceCachingStrategy> cachingStrategy, boolean checkHashCollision, IHasher hasher) {
        return new HashBasedResourceReferenceMapper(pageParametersEncoder, parentPathPartEscapeSequence, cachingStrategy, checkHashCollision, hasher);
    }

    public static class HashBasedBasicResourceReferenceMapper
    extends BasicResourceReferenceMapper {
        private final Map<Long, String> hashMap = new ConcurrentHashMap<Long, String>();
        private final boolean checkHashCollision;
        private final IHasher hasher;

        public HashBasedBasicResourceReferenceMapper(IPageParametersEncoder pageParametersEncoder, Supplier<? extends IResourceCachingStrategy> cachingStrategy, boolean checkHashCollision, IHasher hasher) {
            super(pageParametersEncoder, cachingStrategy);
            this.checkHashCollision = checkHashCollision;
            Args.notNull(hasher, "hasher");
            this.hasher = hasher;
        }

        @Override
        protected Class<?> resolveClass(String name) {
            try {
                long hash = Long.parseLong(name);
                String className = this.hashMap.get(hash);
                if (className == null) {
                    return super.getPageClass(name);
                }
                return super.resolveClass(className);
            }
            catch (NumberFormatException e) {
                return super.getPageClass(name);
            }
        }

        @Override
        protected String getClassName(Class<?> scope) {
            String existing;
            String name = super.getClassName(scope);
            long hash = this.hasher.computeHash(name);
            if (this.checkHashCollision && (existing = this.hashMap.get(hash)) != null && !existing.equals(name)) {
                throw new WicketRuntimeException("Class " + name + " has collision with " + existing);
            }
            this.hashMap.putIfAbsent(hash, name);
            return Long.toString(hash);
        }
    }

    public static interface IHasher {
        public long computeHash(String var1);
    }
}

