/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Objects;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.JavaScriptUrlReferenceHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class JavaScriptHeaderItem
extends HeaderItem {
    private final String condition;
    private String markupId;

    protected JavaScriptHeaderItem(String condition) {
        this.condition = condition;
    }

    public String getId() {
        return this.markupId;
    }

    public JavaScriptHeaderItem setId(String markupId) {
        this.markupId = markupId;
        return this;
    }

    public String getCondition() {
        return this.condition;
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference) {
        return JavaScriptHeaderItem.forReference(reference, null);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, String id) {
        return JavaScriptHeaderItem.forReference(reference, null, id);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String id) {
        return JavaScriptHeaderItem.forReference(reference, pageParameters, id, false);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String id, boolean defer) {
        return JavaScriptHeaderItem.forReference(reference, pageParameters, id, defer, null);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, String id, boolean defer) {
        return JavaScriptHeaderItem.forReference(reference, null, id, defer, null);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, boolean defer) {
        return JavaScriptHeaderItem.forReference(reference, null, null, defer, null);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String id, boolean defer, String charset) {
        return new JavaScriptReferenceHeaderItem(reference, pageParameters, id, defer, charset, null);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String id, boolean defer, String charset, String condition) {
        return new JavaScriptReferenceHeaderItem(reference, pageParameters, id, defer, charset, condition);
    }

    public static JavaScriptContentHeaderItem forScript(CharSequence javascript, String id) {
        return JavaScriptHeaderItem.forScript(javascript, id, null);
    }

    public static JavaScriptContentHeaderItem forScript(CharSequence javascript, String id, String condition) {
        return new JavaScriptContentHeaderItem(javascript, id, condition);
    }

    public static JavaScriptUrlReferenceHeaderItem forUrl(String url) {
        return JavaScriptHeaderItem.forUrl(url, null);
    }

    public static JavaScriptUrlReferenceHeaderItem forUrl(String url, String id) {
        return JavaScriptHeaderItem.forUrl(url, id, false);
    }

    public static JavaScriptUrlReferenceHeaderItem forUrl(String url, String id, boolean defer) {
        return JavaScriptHeaderItem.forUrl(url, id, defer, null);
    }

    public static JavaScriptUrlReferenceHeaderItem forUrl(String url, String id, boolean defer, String charset) {
        return JavaScriptHeaderItem.forUrl(url, id, defer, charset, null);
    }

    public static JavaScriptUrlReferenceHeaderItem forUrl(String url, String id, boolean defer, String charset, String condition) {
        return new JavaScriptUrlReferenceHeaderItem(url, id, defer, charset, condition);
    }

    protected final void internalRenderJavaScriptReference(Response response, String url, String id, boolean defer, String charset, String condition, boolean async) {
        boolean isAjax;
        boolean hasCondition;
        Args.notEmpty((CharSequence)url, (String)"url");
        boolean bl = hasCondition = !Strings.isEmpty((CharSequence)condition);
        if (hasCondition) {
            response.write((CharSequence)"<!--[if ");
            response.write((CharSequence)condition);
            response.write((CharSequence)"]>");
        }
        CharSequence escapedUrl = (isAjax = RequestCycle.get().find(IPartialPageRequestHandler.class).isPresent()) ? Strings.escapeMarkup((CharSequence)url) : url;
        JavaScriptUtils.writeJavaScriptUrl(response, escapedUrl, id, defer, charset, async);
        if (hasCondition) {
            response.write((CharSequence)"<![endif]-->\n");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptHeaderItem that = (JavaScriptHeaderItem)o;
        return Objects.equals(this.condition, that.condition) && Objects.equals(this.markupId, that.markupId);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.markupId);
    }
}

