/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import org.apache.wicket.DefaultMarkupIdGenerator;
import org.apache.wicket.IMarkupIdGenerator;
import org.apache.wicket.markup.MarkupFactory;
import org.apache.wicket.util.lang.Args;

public class MarkupSettings {
    private boolean automaticLinking = false;
    private boolean compressWhitespace = false;
    private String defaultMarkupEncoding;
    private MarkupFactory markupFactory;
    private boolean throwExceptionOnMissingXmlDeclaration = false;
    private boolean stripComments = false;
    private boolean stripWicketTags = false;
    private IMarkupIdGenerator markupIdGenerator = new DefaultMarkupIdGenerator();

    public boolean getAutomaticLinking() {
        return this.automaticLinking;
    }

    public boolean getCompressWhitespace() {
        return this.compressWhitespace;
    }

    public String getDefaultMarkupEncoding() {
        return this.defaultMarkupEncoding;
    }

    public MarkupFactory getMarkupFactory() {
        if (this.markupFactory == null) {
            this.markupFactory = new MarkupFactory();
        }
        return this.markupFactory;
    }

    public boolean getStripComments() {
        return this.stripComments;
    }

    public boolean getStripWicketTags() {
        return this.stripWicketTags;
    }

    public boolean getThrowExceptionOnMissingXmlDeclaration() {
        return this.throwExceptionOnMissingXmlDeclaration;
    }

    public MarkupSettings setAutomaticLinking(boolean automaticLinking) {
        this.automaticLinking = automaticLinking;
        return this;
    }

    public MarkupSettings setCompressWhitespace(boolean compressWhitespace) {
        this.compressWhitespace = compressWhitespace;
        return this;
    }

    public MarkupSettings setDefaultMarkupEncoding(String encoding) {
        this.defaultMarkupEncoding = encoding;
        return this;
    }

    public MarkupSettings setMarkupFactory(MarkupFactory factory) {
        Args.notNull((Object)factory, (String)"markup factory");
        this.markupFactory = factory;
        return this;
    }

    public MarkupSettings setStripComments(boolean stripComments) {
        this.stripComments = stripComments;
        return this;
    }

    public MarkupSettings setStripWicketTags(boolean stripWicketTags) {
        this.stripWicketTags = stripWicketTags;
        return this;
    }

    public MarkupSettings setThrowExceptionOnMissingXmlDeclaration(boolean throwException) {
        this.throwExceptionOnMissingXmlDeclaration = throwException;
        return this;
    }

    public IMarkupIdGenerator getMarkupIdGenerator() {
        return this.markupIdGenerator;
    }

    public MarkupSettings setMarkupIdGenerator(IMarkupIdGenerator markupIdGenerator) {
        this.markupIdGenerator = (IMarkupIdGenerator)Args.notNull((Object)markupIdGenerator, (String)"markupIdGenerator");
        return this;
    }
}

