/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wicket.util.watch;

import org.apache.wicket.util.time.Time;

/**
 * Interface to get the last time something was modified.
 * 
 * @author Jonathan Locke
 * @since 1.2.6
 */
public interface IModifiable
{
	/**
	 * Gets the last time this modifiable thing changed.
	 * 
	 * @return the last modification <code>Time</code> or 
	 * <code>null</code> if that information is not available
	 */
	Time lastModifiedTime();
}
