/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings.def;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Duration;

public class RequestCycleSettings
implements IRequestCycleSettings {
    private boolean bufferResponse = true;
    private boolean gatherExtendedBrowserInfo = false;
    private IRequestCycleSettings.RenderStrategy renderStrategy = IRequestCycleSettings.RenderStrategy.REDIRECT_TO_BUFFER;
    private List<IResponseFilter> responseFilters;
    private String responseRequestEncoding = "UTF-8";
    private Duration timeout = Duration.ONE_MINUTE;

    @Override
    public void addResponseFilter(IResponseFilter responseFilter) {
        if (this.responseFilters == null) {
            this.responseFilters = new ArrayList<IResponseFilter>(3);
        }
        this.responseFilters.add(responseFilter);
    }

    @Override
    public boolean getBufferResponse() {
        return this.bufferResponse;
    }

    @Override
    public boolean getGatherExtendedBrowserInfo() {
        return this.gatherExtendedBrowserInfo;
    }

    @Override
    public IRequestCycleSettings.RenderStrategy getRenderStrategy() {
        return this.renderStrategy;
    }

    @Override
    public List<IResponseFilter> getResponseFilters() {
        if (this.responseFilters == null) {
            return null;
        }
        return Collections.unmodifiableList(this.responseFilters);
    }

    @Override
    public String getResponseRequestEncoding() {
        return this.responseRequestEncoding;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public void setBufferResponse(boolean bufferResponse) {
        this.bufferResponse = bufferResponse;
    }

    @Override
    public void setGatherExtendedBrowserInfo(boolean gatherExtendedBrowserInfo) {
        this.gatherExtendedBrowserInfo = gatherExtendedBrowserInfo;
    }

    @Override
    public void setRenderStrategy(IRequestCycleSettings.RenderStrategy renderStrategy) {
        this.renderStrategy = renderStrategy;
    }

    @Override
    public void setResponseRequestEncoding(String encoding) {
        Args.notNull((Object)encoding, (String)"encoding");
        this.responseRequestEncoding = encoding;
    }

    @Override
    public void setTimeout(Duration timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException("timeout cannot be null");
        }
        this.timeout = timeout;
    }
}

