/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.pages;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.core.request.ClientInfo;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.pages.BrowserInfoForm;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;

public class BrowserInfoPage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private BrowserInfoForm browserInfoForm;

    public BrowserInfoPage() {
        this.initComps();
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render(OnLoadHeaderItem.forScript(String.format("Wicket.BrowserInfo.submitForm('%s')", this.browserInfoForm.getFormMarkupId())));
    }

    @Override
    public boolean isVersioned() {
        return false;
    }

    private void initComps() {
        LoadableDetachableModel<WebClientInfo> info = new LoadableDetachableModel<WebClientInfo>(){

            @Override
            protected WebClientInfo load() {
                return new WebClientInfo(BrowserInfoPage.this.getRequestCycle());
            }
        };
        final ContinueLink link = new ContinueLink("link", (IModel<WebClientInfo>)info);
        this.add(link);
        WebComponent meta = new WebComponent("meta");
        meta.add(AttributeModifier.replace("content", new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getObject() {
                return "0; url=" + link.getURL();
            }
        }));
        this.add(meta);
        this.browserInfoForm = new BrowserInfoForm("postback"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void afterSubmit() {
                this.continueToOriginalDestination();
                this.setResponsePage(this.getApplication().getHomePage());
            }
        };
        this.add(this.browserInfoForm);
    }

    private static class ContinueLink
    extends Link<WebClientInfo> {
        public ContinueLink(String id, IModel<WebClientInfo> info) {
            super(id, info);
        }

        @Override
        public CharSequence getURL() {
            return super.getURL();
        }

        @Override
        public void onClick() {
            ((WebClientInfo)this.getModelObject()).getProperties().setJavaEnabled(false);
            WebSession.get().setClientInfo((ClientInfo)this.getModelObject());
            this.continueToOriginalDestination();
            this.setResponsePage(this.getApplication().getHomePage());
        }
    }
}

