/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.navigation.paging;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.IPagingLabelProvider;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigationLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.collections.MicroMap;

public class PagingNavigation
extends Loop {
    private static final long serialVersionUID = 1L;
    protected IPageable pageable;
    protected IPagingLabelProvider labelProvider;
    private long startIndex;
    private long margin = -1L;
    private String separator = null;
    private int viewSize = 10;

    public PagingNavigation(String id, IPageable pageable) {
        this(id, pageable, null);
    }

    public PagingNavigation(String id, IPageable pageable, IPagingLabelProvider labelProvider) {
        super(id, (IModel<Integer>)null);
        this.pageable = pageable;
        this.labelProvider = labelProvider;
        this.startIndex = 0L;
    }

    public long getMargin() {
        if (this.margin == -1L && this.viewSize != 0) {
            return this.viewSize / 2;
        }
        return this.margin;
    }

    public String getSeparator() {
        return this.separator;
    }

    public int getViewSize() {
        return this.viewSize;
    }

    public void setViewSize(int size) {
        this.viewSize = size;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    protected void onConfigure() {
        super.onConfigure();
        this.setDefaultModel(new Model<Integer>((int)Math.max(Integer.MAX_VALUE, this.pageable.getPageCount())));
        this.setStartIndex();
    }

    protected final long getStartIndex() {
        return this.startIndex;
    }

    @Override
    protected void populateItem(LoopItem loopItem) {
        long pageIndex = this.getStartIndex() + (long)loopItem.getIndex();
        AbstractLink link = this.newPagingNavigationLink("pageLink", this.pageable, pageIndex);
        link.add(new TitleAppender(pageIndex));
        loopItem.add(link);
        String label = "";
        label = this.labelProvider != null ? this.labelProvider.getPageLabel(pageIndex) : String.valueOf(pageIndex + 1L);
        link.add(new Label("pageNumber", label));
    }

    protected AbstractLink newPagingNavigationLink(String id, IPageable pageable, long pageIndex) {
        return new PagingNavigationLink(id, pageable, pageIndex);
    }

    @Override
    protected void renderItem(LoopItem loopItem) {
        super.renderItem(loopItem);
        if (this.separator != null && loopItem.getIndex() != this.getIterations() - 1) {
            this.getResponse().write((CharSequence)this.separator);
        }
    }

    private void setStartIndex() {
        long firstListItem = this.startIndex;
        int viewSize = (int)Math.min((long)this.getViewSize(), this.pageable.getPageCount());
        long margin = this.getMargin();
        long currentPage = this.pageable.getCurrentPage();
        if (currentPage < firstListItem + margin) {
            firstListItem = currentPage - margin;
        } else if (currentPage >= firstListItem + (long)viewSize - margin) {
            firstListItem = currentPage + margin + 1L - (long)viewSize;
        }
        if (firstListItem + (long)viewSize >= this.pageable.getPageCount()) {
            firstListItem = this.pageable.getPageCount() - (long)viewSize;
        }
        if (firstListItem < 0L) {
            firstListItem = 0L;
        }
        if (viewSize != this.getIterations() || this.startIndex != firstListItem) {
            this.modelChanging();
            this.addStateChange();
            this.startIndex = firstListItem;
            this.setIterations((int)Math.min((long)viewSize, this.pageable.getPageCount()));
            this.modelChanged();
            this.removeAll();
        }
    }

    private void setIterations(int i) {
        this.setDefaultModelObject(i);
    }

    private final class TitleAppender
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private static final String RES = "PagingNavigation.page";
        private final long page;

        public TitleAppender(long page) {
            this.page = page;
        }

        @Override
        public void onComponentTag(Component component, ComponentTag tag) {
            MicroMap vars = new MicroMap((Object)"page", (Object)String.valueOf(this.page + 1L));
            tag.put("title", PagingNavigation.this.getString(RES, Model.ofMap(vars)));
        }
    }
}

