/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.util.tester;

import java.io.IOException;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;

abstract class TestWebSocketConnection
implements IWebSocketConnection {
    private boolean isOpen = true;

    TestWebSocketConnection() {
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close(int code, String reason) {
        this.isOpen = false;
    }

    @Override
    public IWebSocketConnection sendMessage(String message) throws IOException {
        this.checkOpenness();
        this.onOutMessage(message);
        return this;
    }

    @Override
    public IWebSocketConnection sendMessage(byte[] message, int offset, int length) throws IOException {
        this.checkOpenness();
        this.onOutMessage(message, offset, length);
        return this;
    }

    protected abstract void onOutMessage(String var1);

    protected abstract void onOutMessage(byte[] var1, int var2, int var3);

    private void checkOpenness() {
        if (!this.isOpen()) {
            throw new IllegalStateException("The connection is closed!");
        }
    }
}

