/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import aQute.bnd.help.instructions.ProjectInstructions;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.generate.BuildContext;
import aQute.bnd.service.generate.Generator;
import aQute.bnd.service.result.Result;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.fileset.FileSet;
import aQute.lib.io.IO;
import aQute.lib.redirect.Redirect;
import aQute.lib.specinterface.SpecInterface;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.osgi.framework.VersionRange;

public class ProjectGenerate
implements AutoCloseable {
    final Project project;

    ProjectGenerate(Project project) {
        this.project = project;
    }

    public Result<Set<File>, String> generate(boolean force) {
        if (force) {
            this.clean();
        }
        TreeSet files = new TreeSet();
        for (Map.Entry<String, ProjectInstructions.GeneratorSpec> e : this.project.instructions.generate().entrySet()) {
            Result<Set<File>, String> step = this.step(e.getKey(), e.getValue());
            if (step.isErr()) {
                String qsrc = e.getKey();
                Reporter.SetLocation error = this.project.error("%s : %s;%s", step.error().get(), e.getKey(), e.getValue()._attrs());
                error.context(qsrc);
                error.header("-generate");
                return step.asError();
            }
            files.addAll(step.unwrap());
        }
        return Result.ok(files);
    }

    private Result<Set<File>, String> step(String sourceWithDuplicate, ProjectInstructions.GeneratorSpec st) {
        try {
            Set<File> affected;
            Set<File> sourceFiles;
            String source = Strings.trim(Processor.removeDuplicateMarker(sourceWithDuplicate));
            if (source.isEmpty() || source.equals("<<EMPTY>>")) {
                return Result.ok(Collections.emptySet());
            }
            String output = st.output();
            if (output == null) {
                return Result.err("No mandatory 'output' files/directories specified");
            }
            if (!output.endsWith("/")) {
                output = output + "/";
            }
            if ((sourceFiles = new FileSet(this.project.getBase(), source).getFiles()).isEmpty()) {
                return Result.err("No source files/directories specified");
            }
            File out = this.project.getFile(output);
            if (out.isDirectory()) {
                for (File f : out.listFiles()) {
                    IO.delete(f);
                }
            } else {
                out.mkdirs();
            }
            if (st.system().isPresent()) {
                this.project.system(st.system().get(), null);
            }
            if (st.generate().isPresent()) {
                String result;
                boolean ignoreErrors = false;
                String plugin = st.generate().get();
                if (plugin.startsWith("-")) {
                    ignoreErrors = true;
                    plugin = plugin.substring(1);
                }
                if ((result = this.doGenerate(plugin, st)) != null) {
                    return Result.err(ignoreErrors ? "-" + result : result);
                }
            }
            if ((affected = new FileSet(this.project.getBase(), st.output()).getFiles()).isEmpty()) {
                return Result.err("ran command or generate but no files were changed; Is `output` correct wrt to the command?");
            }
            return Result.ok(affected);
        }
        catch (Exception e) {
            return Result.err(Exceptions.causes(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doGenerate(String commandline, ProjectInstructions.GeneratorSpec st) {
        try {
            String result = null;
            List<String> blocks = Strings.splitQuoted(commandline, ";");
            Iterator<String> iterator = blocks.iterator();
            while (true) {
                OutputStream stderr;
                OutputStream stdout;
                InputStream stdin;
                block19: {
                    String string;
                    if (!iterator.hasNext()) {
                        return result;
                    }
                    String block = iterator.next();
                    if (block.isEmpty()) continue;
                    List<String> arguments = Strings.splitQuoted(block, " \t");
                    if (arguments.isEmpty()) {
                        return block + " : no command name";
                    }
                    File fstdin = null;
                    File fstdout = null;
                    File fstderr = null;
                    String pluginName = arguments.remove(0);
                    Iterator<String> it = arguments.iterator();
                    while (it.hasNext()) {
                        String arg = it.next();
                        if (arg.startsWith("<")) {
                            if (fstdin != null) {
                                return "only 1 redirection of stdin supported";
                            }
                            fstdin = this.getFile(arg.substring(1), false);
                            if (fstdin == null || !fstdin.isFile()) {
                                return "cannot find redirected input file " + fstdin;
                            }
                            it.remove();
                            continue;
                        }
                        if (arg.startsWith(">")) {
                            if (fstdout != null) {
                                return "only 1 redirection of stdout supported";
                            }
                            fstdout = this.getFile(arg.substring(1), true);
                            it.remove();
                            continue;
                        }
                        if (arg.startsWith("1>")) {
                            if (fstdout != null) {
                                return "only 1 redirection of stdout supported";
                            }
                            fstdout = this.getFile(arg.substring(2), true);
                            it.remove();
                            continue;
                        }
                        if (!arg.startsWith("2>")) continue;
                        if (fstderr != null) {
                            return "only 1 redirection of stderr supported";
                        }
                        fstderr = this.getFile(arg.substring(2), true);
                        it.remove();
                    }
                    stdin = fstdin == null ? null : IO.stream(fstdin);
                    stdout = fstdout == null ? null : IO.outputStream(fstdout);
                    stderr = fstderr == null ? null : IO.outputStream(fstderr);
                    try {
                        if (pluginName.indexOf(46) >= 0) {
                            if (pluginName.startsWith(".")) {
                                pluginName = pluginName.substring(1);
                            }
                            VersionRange range = st.version().map(VersionRange::valueOf).orElse(null);
                            result = this.doGenerateMain(pluginName, range, st._attrs(), arguments, stdin, stdout, stderr);
                        } else {
                            result = this.doGeneratePlugin(pluginName, st._attrs(), arguments, stdin, stdout, stderr);
                        }
                        if (result == null) break block19;
                        string = block + " : " + result;
                    }
                    catch (Throwable throwable) {
                        IO.closeAll(stdout, stderr, stdin);
                        throw throwable;
                    }
                    IO.closeAll(stdout, stderr, stdin);
                    return string;
                }
                IO.closeAll(stdout, stderr, stdin);
            }
        }
        catch (Exception e) {
            return Exceptions.causes(e);
        }
    }

    private File getFile(String path, boolean mkdirs) {
        File f = this.project.getFile(path);
        if (mkdirs) {
            f.getParentFile().mkdirs();
        }
        return f;
    }

    private String doGeneratePlugin(String pluginName, Map<String, String> attrs, List<String> arguments, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        BuildContext bc = new BuildContext(this.project, attrs, arguments, stdin, stdout, stderr);
        Result call = this.project.getWorkspace().getExternalPlugins().call(pluginName, Generator.class, p -> {
            Class<Generator> type = SpecInterface.getParameterizedInterfaceType(p.getClass(), Generator.class);
            if (type == null) {
                return Result.err("Cannot find the options type in %s", p.getClass());
            }
            SpecInterface<Generator> spec = SpecInterface.getOptions(type, arguments, bc.getBase());
            if (spec.isFailure()) {
                return Result.err(spec.failure());
            }
            Redirect redirect = new Redirect(stdin, stdout, stderr).captureStdout().captureStderr();
            Optional error = redirect.apply(() -> p.generate(bc, spec.instance()));
            if (error.isPresent()) {
                return Result.err((String)error.get() + " : " + redirect.getContent());
            }
            return Result.ok(true);
        });
        return call.error().orElse(null);
    }

    private String doGenerateMain(String mainClass, VersionRange range, Map<String, String> attrs, List<String> arguments, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        Result<Integer, String> call = this.project.getWorkspace().getExternalPlugins().call(mainClass, range, this.project, attrs, arguments, stdin, stdout, stderr);
        if (call.isErr()) {
            return call.error().get();
        }
        if (call.unwrap() != 0) {
            return "process returned with non-zero exit code: " + call.unwrap();
        }
        return null;
    }

    public Result<Set<File>, String> getInputs() {
        Set<String> inputs = this.project.instructions.generate().keySet();
        if (inputs.isEmpty()) {
            return Result.ok(Collections.emptySet());
        }
        HashSet<File> files = new HashSet<File>();
        String errors = "";
        for (String input : inputs) {
            Set<File> inputFiles = new FileSet(this.project.getBase(), input).getFiles();
            if (inputFiles.isEmpty()) {
                this.project.error("-generate: no content for %s", input);
                errors = errors.concat(input).concat(" has no matching files\n");
                continue;
            }
            files.addAll(inputFiles);
        }
        if (errors.isEmpty()) {
            return Result.ok(files);
        }
        return Result.err(errors);
    }

    public Set<File> getOutputDirs() {
        return this.project.instructions.generate().values().stream().map(ProjectInstructions.GeneratorSpec::output).filter(Objects::nonNull).map(this.project::getFile).collect(Collectors.toSet());
    }

    public boolean needsBuild() {
        for (Map.Entry<String, ProjectInstructions.GeneratorSpec> e : this.project.instructions.generate().entrySet()) {
            Set<File> sourceFiles;
            ProjectInstructions.GeneratorSpec spec = e.getValue();
            String source = Strings.trim(Processor.removeDuplicateMarker(e.getKey()));
            if (source.isEmpty() || source.equals("<<EMPTY>>")) continue;
            String output = spec.output();
            if (output == null) {
                return true;
            }
            if (!output.endsWith("/")) {
                output = output + "/";
            }
            if ((sourceFiles = new FileSet(this.project.getBase(), source).getFiles()).isEmpty()) {
                return true;
            }
            sourceFiles.addAll(this.project.getSelfAndAncestors());
            long latestModifiedSource = sourceFiles.stream().mapToLong(File::lastModified).max().getAsLong();
            Set<File> outputFiles = new FileSet(this.project.getBase(), output).getFiles();
            if (outputFiles.isEmpty()) {
                return true;
            }
            long latestModifiedTarget = outputFiles.stream().filter(File::isFile).mapToLong(File::lastModified).min().orElse(0L);
            boolean staleFiles = latestModifiedSource > latestModifiedTarget;
            if (!staleFiles) continue;
            return true;
        }
        return false;
    }

    public void clean() {
        this.getOutputDirs().stream().forEach(IO::delete);
    }

    @Override
    public void close() {
    }
}

