/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.api;

import java.util.Map;

public class GeoPoint {
    private Double lat;
    private Double lon;

    public GeoPoint(Double lat, Double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public String asString() {
        return this.lat + ", " + this.lon;
    }

    public double distanceTo(GeoPoint other) {
        if (other == null) {
            return 0.0;
        }
        int R = 6371;
        double lat2 = other.lat;
        double lon2 = other.lon;
        double latDistance = Math.toRadians(lat2 - this.lat);
        double lonDistance = Math.toRadians(lon2 - this.lon);
        double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(Math.toRadians(this.lat)) * Math.cos(Math.toRadians(lat2)) * Math.sin(lonDistance / 2.0) * Math.sin(lonDistance / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6371.0 * c * 1000.0;
    }

    public static GeoPoint fromMap(Map<String, Double> map) {
        if (map == null || map.isEmpty() || !map.containsKey("lat") || !map.containsKey("lon")) {
            throw new IllegalArgumentException("Map should be not null and contain \"lat\" and \"lon\" fields");
        }
        return new GeoPoint(map.get("lat"), map.get("lon"));
    }

    public static GeoPoint fromString(String input) {
        if (input == null || input.trim().length() == 0) {
            return null;
        }
        String[] parts = input.split(",");
        if (parts.length == 2) {
            try {
                return new GeoPoint(Double.valueOf(parts[0].trim()), Double.valueOf(parts[1].trim()));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("Could not parse \"lat\" or \"lon\" from: %s", input), ex);
            }
        }
        throw new IllegalArgumentException(String.format("Incorrect geo point format. Expected: \"lat, lon\", was: %s", input));
    }
}

