/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.wagon.shared.http;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import shaded.org.apache.http.Header;
import shaded.org.apache.http.HttpEntity;
import shaded.org.apache.http.HttpException;
import shaded.org.apache.http.HttpHost;
import shaded.org.apache.http.HttpResponse;
import shaded.org.apache.http.auth.AuthScope;
import shaded.org.apache.http.auth.ChallengeState;
import shaded.org.apache.http.auth.Credentials;
import shaded.org.apache.http.auth.NTCredentials;
import shaded.org.apache.http.auth.UsernamePasswordCredentials;
import shaded.org.apache.http.client.AuthCache;
import shaded.org.apache.http.client.CredentialsProvider;
import shaded.org.apache.http.client.HttpRequestRetryHandler;
import shaded.org.apache.http.client.config.RequestConfig;
import shaded.org.apache.http.client.methods.CloseableHttpResponse;
import shaded.org.apache.http.client.methods.HttpGet;
import shaded.org.apache.http.client.methods.HttpHead;
import shaded.org.apache.http.client.methods.HttpPut;
import shaded.org.apache.http.client.methods.HttpUriRequest;
import shaded.org.apache.http.client.protocol.HttpClientContext;
import shaded.org.apache.http.client.utils.DateUtils;
import shaded.org.apache.http.config.Registry;
import shaded.org.apache.http.config.RegistryBuilder;
import shaded.org.apache.http.conn.HttpClientConnectionManager;
import shaded.org.apache.http.conn.socket.ConnectionSocketFactory;
import shaded.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import shaded.org.apache.http.conn.ssl.SSLContextBuilder;
import shaded.org.apache.http.conn.ssl.SSLInitializationException;
import shaded.org.apache.http.entity.AbstractHttpEntity;
import shaded.org.apache.http.impl.auth.BasicScheme;
import shaded.org.apache.http.impl.client.BasicAuthCache;
import shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import shaded.org.apache.http.impl.client.CloseableHttpClient;
import shaded.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import shaded.org.apache.http.impl.client.HttpClientBuilder;
import shaded.org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import shaded.org.apache.http.message.BasicHeader;
import shaded.org.apache.http.util.EntityUtils;
import shaded.org.apache.maven.wagon.InputData;
import shaded.org.apache.maven.wagon.OutputData;
import shaded.org.apache.maven.wagon.PathUtils;
import shaded.org.apache.maven.wagon.ResourceDoesNotExistException;
import shaded.org.apache.maven.wagon.StreamWagon;
import shaded.org.apache.maven.wagon.TransferFailedException;
import shaded.org.apache.maven.wagon.Wagon;
import shaded.org.apache.maven.wagon.authorization.AuthorizationException;
import shaded.org.apache.maven.wagon.events.TransferEvent;
import shaded.org.apache.maven.wagon.proxy.ProxyInfo;
import shaded.org.apache.maven.wagon.repository.Repository;
import shaded.org.apache.maven.wagon.resource.Resource;
import shaded.org.apache.maven.wagon.shared.http.BasicAuthScope;
import shaded.org.apache.maven.wagon.shared.http.ConfigurationUtils;
import shaded.org.apache.maven.wagon.shared.http.EncodingUtil;
import shaded.org.apache.maven.wagon.shared.http.HttpConfiguration;
import shaded.org.apache.maven.wagon.shared.http.HttpMethodConfiguration;
import shaded.org.apache.maven.wagon.shared.http.RelaxedTrustStrategy;
import shaded.org.codehaus.plexus.util.StringUtils;

public abstract class AbstractHttpClientWagon
extends StreamWagon {
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static boolean persistentPool = Boolean.valueOf(System.getProperty("maven.wagon.http.pool", "true"));
    private static final boolean SSL_INSECURE = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.insecure", "false"));
    private static final boolean IGNORE_SSL_VALIDITY_DATES = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.ignore.validity.dates", "false"));
    private static final boolean SSL_ALLOW_ALL = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.allowall", "false"));
    private static final int MAX_CONN_PER_ROUTE = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.maxPerRoute", "20"));
    private static final int MAX_CONN_TOTAL = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.maxTotal", "40"));
    private static HttpClientConnectionManager httpClientConnectionManager = AbstractHttpClientWagon.createConnManager();
    protected static final int SC_TOO_MANY_REQUESTS = 429;
    private int initialBackoffSeconds = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.backoffSeconds", "5"));
    private static final int MAX_BACKOFF_WAIT_SECONDS = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.maxBackoffSeconds", "180"));
    private static final long CONN_TTL = Long.getLong("maven.wagon.httpconnectionManager.ttlSeconds", 300L);
    private static final String RETRY_HANDLER_CLASS = System.getProperty("maven.wagon.http.retryHandler.class", "standard");
    private static final boolean RETRY_HANDLER_REQUEST_SENT_ENABLED = Boolean.getBoolean("maven.wagon.http.retryHandler.requestSentEnabled");
    private static final int RETRY_HANDLER_COUNT = Integer.getInteger("maven.wagon.http.retryHandler.count", 3);
    private static final String RETRY_HANDLER_EXCEPTIONS = System.getProperty("maven.wagon.http.retryHandler.nonRetryableClasses");
    private static CloseableHttpClient httpClient = AbstractHttpClientWagon.createClient();
    private CredentialsProvider credentialsProvider;
    private AuthCache authCache;
    private Closeable closeable;
    private Properties httpHeaders;
    private HttpConfiguration httpConfiguration;
    private BasicAuthScope basicAuth;
    private BasicAuthScope proxyAuth;

    protected int backoff(int wait, String url) throws InterruptedException, TransferFailedException {
        TimeUnit.SECONDS.sleep(wait);
        int nextWait = wait * 2;
        if (nextWait >= AbstractHttpClientWagon.getMaxBackoffWaitSeconds()) {
            throw new TransferFailedException("Waited too long to access: " + url + ". Return code is: " + 429);
        }
        return nextWait;
    }

    private static PoolingHttpClientConnectionManager createConnManager() {
        SSLConnectionSocketFactory sslConnectionSocketFactory;
        String[] cipherSuites;
        String sslProtocolsStr = System.getProperty("https.protocols");
        String cipherSuitesStr = System.getProperty("https.cipherSuites");
        String[] sslProtocols = sslProtocolsStr != null ? sslProtocolsStr.split(" *, *") : null;
        String[] stringArray = cipherSuites = cipherSuitesStr != null ? cipherSuitesStr.split(" *, *") : null;
        if (SSL_INSECURE) {
            try {
                SSLContext sslContext = new SSLContextBuilder().useSSL().loadTrustMaterial(null, new RelaxedTrustStrategy(IGNORE_SSL_VALIDITY_DATES)).build();
                sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, sslProtocols, cipherSuites, SSL_ALLOW_ALL ? SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            }
            catch (Exception ex) {
                throw new SSLInitializationException(ex.getMessage(), ex);
            }
        } else {
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(HttpsURLConnection.getDefaultSSLSocketFactory(), sslProtocols, cipherSuites, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        }
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.INSTANCE).register("https", (PlainConnectionSocketFactory)((Object)sslConnectionSocketFactory)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry, null, null, null, CONN_TTL, TimeUnit.SECONDS);
        if (persistentPool) {
            connManager.setDefaultMaxPerRoute(MAX_CONN_PER_ROUTE);
            connManager.setMaxTotal(MAX_CONN_TOTAL);
        } else {
            connManager.setMaxTotal(1);
        }
        return connManager;
    }

    private static HttpRequestRetryHandler createRetryHandler() {
        switch (RETRY_HANDLER_CLASS) {
            case "default": {
                if (StringUtils.isEmpty(RETRY_HANDLER_EXCEPTIONS)) {
                    return new DefaultHttpRequestRetryHandler(RETRY_HANDLER_COUNT, RETRY_HANDLER_REQUEST_SENT_ENABLED);
                }
                return new DefaultHttpRequestRetryHandler(RETRY_HANDLER_COUNT, RETRY_HANDLER_REQUEST_SENT_ENABLED, (Collection)AbstractHttpClientWagon.getNonRetryableExceptions()){};
            }
            case "standard": {
                return new StandardHttpRequestRetryHandler(RETRY_HANDLER_COUNT, RETRY_HANDLER_REQUEST_SENT_ENABLED);
            }
        }
        try {
            ClassLoader classLoader = AbstractHttpClientWagon.class.getClassLoader();
            return (HttpRequestRetryHandler)HttpRequestRetryHandler.class.cast(classLoader.loadClass(RETRY_HANDLER_CLASS).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Collection<Class<? extends IOException>> getNonRetryableExceptions() {
        ArrayList<Class<? extends IOException>> exceptions = new ArrayList<Class<? extends IOException>>();
        ClassLoader loader = AbstractHttpClientWagon.class.getClassLoader();
        for (String ex : RETRY_HANDLER_EXCEPTIONS.split(",")) {
            try {
                exceptions.add(loader.loadClass(ex));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return exceptions;
    }

    private static CloseableHttpClient createClient() {
        return HttpClientBuilder.create().useSystemProperties().disableConnectionState().setConnectionManager(httpClientConnectionManager).setRetryHandler(AbstractHttpClientWagon.createRetryHandler()).build();
    }

    @Override
    public void openConnectionInternal() {
        ProxyInfo proxyInfo;
        this.repository.setUrl(this.getURL(this.repository));
        this.credentialsProvider = new BasicCredentialsProvider();
        this.authCache = new BasicAuthCache();
        if (this.authenticationInfo != null) {
            String username = this.authenticationInfo.getUserName();
            String password = this.authenticationInfo.getPassword();
            if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
                String host = this.getRepository().getHost();
                int port = this.getRepository().getPort();
                this.credentialsProvider.setCredentials(this.getBasicAuthScope().getScope(host, port), creds);
            }
        }
        if ((proxyInfo = this.getProxyInfo(this.getRepository().getProtocol(), this.getRepository().getHost())) != null) {
            String proxyUsername = proxyInfo.getUserName();
            String proxyPassword = proxyInfo.getPassword();
            String proxyHost = proxyInfo.getHost();
            String proxyNtlmHost = proxyInfo.getNtlmHost();
            String proxyNtlmDomain = proxyInfo.getNtlmDomain();
            if (proxyHost != null && proxyUsername != null && proxyPassword != null) {
                Credentials creds = proxyNtlmHost != null || proxyNtlmDomain != null ? new NTCredentials(proxyUsername, proxyPassword, proxyNtlmHost, proxyNtlmDomain) : new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                int proxyPort = proxyInfo.getPort();
                AuthScope authScope = this.getProxyBasicAuthScope().getScope(proxyHost, proxyPort);
                this.credentialsProvider.setCredentials(authScope, creds);
            }
        }
    }

    @Override
    public void closeConnection() {
        if (!persistentPool) {
            httpClientConnectionManager.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        }
        if (this.authCache != null) {
            this.authCache.clear();
            this.authCache = null;
        }
        if (this.credentialsProvider != null) {
            this.credentialsProvider.clear();
            this.credentialsProvider = null;
        }
    }

    public static CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    public static void setPersistentPool(boolean persistentPool) {
    }

    public static void setPoolingHttpClientConnectionManager(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager) {
        httpClientConnectionManager = poolingHttpClientConnectionManager;
        httpClient = AbstractHttpClientWagon.createClient();
    }

    @Override
    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.put(null, resource, source);
    }

    @Override
    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, null);
        resource.setContentLength(contentLength);
        resource.setLastModified(lastModified);
        this.put(stream, resource, null);
    }

    private void put(InputStream stream, Resource resource, File source) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.put(resource, source, new RequestEntityImplementation(stream, resource, this, source));
    }

    private void put(Resource resource, File source, HttpEntity httpEntity) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.put(resource, source, httpEntity, this.buildUrl(resource));
    }

    private String buildUrl(Resource resource) {
        return EncodingUtil.encodeURLToString(this.getRepository().getUrl(), resource.getName());
    }

    private void put(Resource resource, File source, HttpEntity httpEntity, String url) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.put(this.getInitialBackoffSeconds(), resource, source, httpEntity, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(int wait, Resource resource, File source, HttpEntity httpEntity, String url) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        try {
            this.mkdirs(PathUtils.dirname(resource.getName()));
        }
        catch (HttpException he) {
            this.fireTransferError(resource, he, 6);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 6);
        }
        Repository repo = this.getRepository();
        HttpHost targetHost = new HttpHost(repo.getHost(), repo.getPort(), repo.getProtocol());
        AuthScope targetScope = this.getBasicAuthScope().getScope(targetHost);
        if (this.credentialsProvider.getCredentials(targetScope) != null) {
            BasicScheme targetAuth = new BasicScheme();
            this.authCache.put(targetHost, targetAuth);
        }
        HttpPut putMethod = new HttpPut(url);
        this.firePutStarted(resource, source);
        try {
            putMethod.setEntity(httpEntity);
            try (CloseableHttpResponse response = this.execute(putMethod);){
                int statusCode = response.getStatusLine().getStatusCode();
                String reasonPhrase = response.getStatusLine().getReasonPhrase();
                StringBuilder debugMessage = new StringBuilder();
                debugMessage.append(url);
                debugMessage.append(" -- ");
                debugMessage.append("status code: ").append(statusCode);
                if (StringUtils.isNotEmpty(reasonPhrase)) {
                    debugMessage.append(", reason phrase: ").append(reasonPhrase);
                }
                this.fireTransferDebug(debugMessage.toString());
                switch (statusCode) {
                    case 200: 
                    case 201: 
                    case 202: 
                    case 204: {
                        break;
                    }
                    case 301: 
                    case 302: 
                    case 303: {
                        this.put(resource, source, httpEntity, this.calculateRelocatedUrl(response));
                        return;
                    }
                    case 403: {
                        this.fireSessionConnectionRefused();
                        throw new AuthorizationException("Access denied to: " + url);
                    }
                    case 404: {
                        throw new ResourceDoesNotExistException("File " + url + " does not exist");
                    }
                    case 429: {
                        this.put(this.backoff(wait, url), resource, source, httpEntity, url);
                        break;
                    }
                    default: {
                        TransferFailedException e = new TransferFailedException("Failed to transfer file " + url + " with status code " + statusCode);
                        this.fireTransferError(resource, e, 6);
                        throw e;
                    }
                }
                this.firePutCompleted(resource, source);
                EntityUtils.consume(response.getEntity());
            }
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 6);
            throw new TransferFailedException(e.getMessage(), e);
        }
        catch (HttpException e) {
            this.fireTransferError(resource, e, 6);
            throw new TransferFailedException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            this.fireTransferError(resource, e, 6);
            throw new TransferFailedException(e.getMessage(), e);
        }
    }

    protected String calculateRelocatedUrl(HttpResponse response) {
        Header locationHeader = response.getFirstHeader("Location");
        String locationField = locationHeader.getValue();
        return locationField.startsWith("http") ? locationField : this.getURL(this.getRepository()) + '/' + locationField;
    }

    protected void mkdirs(String dirname) throws HttpException, IOException {
    }

    @Override
    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        return this.resourceExists(this.getInitialBackoffSeconds(), resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean resourceExists(int wait, String resourceName) throws TransferFailedException, AuthorizationException {
        String repositoryUrl = this.getRepository().getUrl();
        String url = repositoryUrl + (repositoryUrl.endsWith("/") ? "" : "/") + resourceName;
        HttpHead headMethod = new HttpHead(url);
        try (CloseableHttpResponse response = this.execute(headMethod);){
            boolean result;
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    result = true;
                    break;
                }
                case 304: {
                    result = true;
                    break;
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 401: {
                    throw new AuthorizationException("Not authorized");
                }
                case 407: {
                    throw new AuthorizationException("Not authorized by proxy");
                }
                case 404: {
                    result = false;
                    break;
                }
                case 429: {
                    boolean bl = this.resourceExists(this.backoff(wait, resourceName), resourceName);
                    return bl;
                }
                default: {
                    throw new TransferFailedException("Failed to transfer file " + url + " with status code " + statusCode);
                }
            }
            EntityUtils.consume(response.getEntity());
            boolean bl = result;
            return bl;
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), e);
        }
        catch (HttpException e) {
            throw new TransferFailedException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new TransferFailedException(e.getMessage(), e);
        }
    }

    protected CloseableHttpResponse execute(HttpUriRequest httpMethod) throws HttpException, IOException {
        HttpMethodConfiguration config;
        this.setHeaders(httpMethod);
        String userAgent = this.getUserAgent(httpMethod);
        if (userAgent != null) {
            httpMethod.setHeader("User-Agent", userAgent);
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setCookieSpec("compatibility");
        Repository repo = this.getRepository();
        ProxyInfo proxyInfo = this.getProxyInfo(repo.getProtocol(), repo.getHost());
        if (proxyInfo != null) {
            HttpHost proxy = new HttpHost(proxyInfo.getHost(), proxyInfo.getPort());
            requestConfigBuilder.setProxy(proxy);
        }
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(httpMethod);
        if (config != null) {
            ConfigurationUtils.copyConfig(config, requestConfigBuilder);
        } else {
            requestConfigBuilder.setSocketTimeout(this.getReadTimeout());
            if (httpMethod instanceof HttpPut) {
                requestConfigBuilder.setExpectContinueEnabled(true);
            }
        }
        if (httpMethod instanceof HttpPut) {
            requestConfigBuilder.setRedirectsEnabled(false);
        }
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setCredentialsProvider(this.credentialsProvider);
        localContext.setAuthCache(this.authCache);
        localContext.setRequestConfig(requestConfigBuilder.build());
        if (config != null && config.isUsePreemptive()) {
            HttpHost targetHost = new HttpHost(repo.getHost(), repo.getPort(), repo.getProtocol());
            AuthScope targetScope = this.getBasicAuthScope().getScope(targetHost);
            if (this.credentialsProvider.getCredentials(targetScope) != null) {
                BasicScheme targetAuth = new BasicScheme();
                this.authCache.put(targetHost, targetAuth);
            }
        }
        if (proxyInfo != null && proxyInfo.getHost() != null) {
            HttpHost proxyHost = new HttpHost(proxyInfo.getHost(), proxyInfo.getPort());
            AuthScope proxyScope = this.getProxyBasicAuthScope().getScope(proxyHost);
            if (this.credentialsProvider.getCredentials(proxyScope) != null) {
                BasicScheme proxyAuth = new BasicScheme(ChallengeState.PROXY);
                this.authCache.put(proxyHost, proxyAuth);
            }
        }
        return httpClient.execute(httpMethod, localContext);
    }

    public void setHeaders(HttpUriRequest method) {
        String userAgent;
        Header userAgentHeader;
        Header[] headers;
        HttpMethodConfiguration config;
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config == null || config.isUseDefaultHeaders()) {
            method.addHeader("Cache-control", "no-cache");
            method.addHeader("Cache-store", "no-store");
            method.addHeader("Pragma", "no-cache");
        }
        if (this.httpHeaders != null) {
            for (Map.Entry<Object, Object> entry : this.httpHeaders.entrySet()) {
                method.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Header[] headerArray = headers = config == null ? null : config.asRequestHeaders();
        if (headers != null) {
            for (Header header : headers) {
                method.setHeader(header);
            }
        }
        if ((userAgentHeader = method.getFirstHeader("User-Agent")) == null && (userAgent = this.getUserAgent(method)) != null) {
            method.setHeader("User-Agent", userAgent);
        }
    }

    protected String getUserAgent(HttpUriRequest method) {
        HttpMethodConfiguration config;
        String value;
        if (this.httpHeaders != null && (value = (String)this.httpHeaders.get("User-Agent")) != null) {
            return value;
        }
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config != null) {
            return (String)config.getHeaders().get("User-Agent");
        }
        return null;
    }

    protected String getURL(Repository repository) {
        return repository.getUrl();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    public BasicAuthScope getBasicAuthScope() {
        if (this.basicAuth == null) {
            this.basicAuth = new BasicAuthScope();
        }
        return this.basicAuth;
    }

    public void setBasicAuthScope(BasicAuthScope basicAuth) {
        this.basicAuth = basicAuth;
    }

    public BasicAuthScope getProxyBasicAuthScope() {
        if (this.proxyAuth == null) {
            this.proxyAuth = new BasicAuthScope();
        }
        return this.proxyAuth;
    }

    public void setProxyBasicAuthScope(BasicAuthScope proxyAuth) {
        this.proxyAuth = proxyAuth;
    }

    @Override
    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.fillInputData(this.getInitialBackoffSeconds(), inputData);
    }

    private void fillInputData(int wait, InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        String repositoryUrl = this.getRepository().getUrl();
        String url = repositoryUrl + (repositoryUrl.endsWith("/") ? "" : "/") + resource.getName();
        HttpGet getMethod = new HttpGet(url);
        long timestamp = resource.getLastModified();
        if (timestamp > 0L) {
            SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            fmt.setTimeZone(GMT_TIME_ZONE);
            BasicHeader hdr = new BasicHeader("If-Modified-Since", fmt.format(new Date(timestamp)));
            this.fireTransferDebug("sending ==> " + hdr + "(" + timestamp + ")");
            getMethod.addHeader(hdr);
        }
        try {
            HttpEntity entity;
            Date lastModified;
            Header lastModifiedHeader;
            CloseableHttpResponse response = this.execute(getMethod);
            this.closeable = response;
            int statusCode = response.getStatusLine().getStatusCode();
            String reasonPhrase = response.getStatusLine().getReasonPhrase();
            StringBuilder debugMessage = new StringBuilder();
            debugMessage.append(url);
            debugMessage.append(" -- ");
            debugMessage.append("status code: ").append(statusCode);
            if (StringUtils.isNotEmpty(reasonPhrase)) {
                debugMessage.append(", reason phrase: ").append(reasonPhrase);
            }
            this.fireTransferDebug(debugMessage.toString());
            switch (statusCode) {
                case 200: {
                    break;
                }
                case 304: {
                    return;
                }
                case 403: {
                    this.fireSessionConnectionRefused();
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 401: {
                    this.fireSessionConnectionRefused();
                    throw new AuthorizationException("Not authorized");
                }
                case 407: {
                    this.fireSessionConnectionRefused();
                    throw new AuthorizationException("Not authorized by proxy");
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File " + url + " does not exist");
                }
                case 429: {
                    this.fillInputData(this.backoff(wait, url), inputData);
                    break;
                }
                default: {
                    this.cleanupGetTransfer(resource);
                    TransferFailedException e = new TransferFailedException("Failed to transfer file " + url + " with status code " + statusCode);
                    this.fireTransferError(resource, e, 5);
                    throw e;
                }
            }
            Header contentLengthHeader = response.getFirstHeader("Content-Length");
            if (contentLengthHeader != null) {
                try {
                    long contentLength = Long.parseLong(contentLengthHeader.getValue());
                    resource.setContentLength(contentLength);
                }
                catch (NumberFormatException e) {
                    this.fireTransferDebug("error parsing content length header '" + contentLengthHeader.getValue() + "' " + e);
                }
            }
            if ((lastModifiedHeader = response.getFirstHeader("Last-Modified")) != null && (lastModified = DateUtils.parseDate(lastModifiedHeader.getValue())) != null) {
                resource.setLastModified(lastModified.getTime());
                this.fireTransferDebug("last-modified = " + lastModifiedHeader.getValue() + " (" + lastModified.getTime() + ")");
            }
            if ((entity = response.getEntity()) != null) {
                inputData.setInputStream(entity.getContent());
            }
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException(e.getMessage(), e);
        }
        catch (HttpException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException(e.getMessage(), e);
        }
    }

    @Override
    protected void cleanupGetTransfer(Resource resource) {
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void putFromStream(InputStream stream, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.putFromStream(stream, destination, -1L, -1L);
    }

    @Override
    protected void putFromStream(InputStream stream, Resource resource) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.putFromStream(stream, resource.getName(), -1L, -1L);
    }

    public Properties getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Properties httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    @Override
    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new IllegalStateException("this wagon http client must not use fillOutputData");
    }

    protected CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    protected AuthCache getAuthCache() {
        return this.authCache;
    }

    public int getInitialBackoffSeconds() {
        return this.initialBackoffSeconds;
    }

    public void setInitialBackoffSeconds(int initialBackoffSeconds) {
        this.initialBackoffSeconds = initialBackoffSeconds;
    }

    public static int getMaxBackoffWaitSeconds() {
        return MAX_BACKOFF_WAIT_SECONDS;
    }

    private final class RequestEntityImplementation
    extends AbstractHttpEntity {
        private static final int BUFFER_SIZE = 2048;
        private final Resource resource;
        private final Wagon wagon;
        private InputStream stream;
        private File source;
        private long length = -1L;
        private boolean repeatable;

        private RequestEntityImplementation(InputStream stream, Resource resource, Wagon wagon, File source) throws TransferFailedException {
            if (source != null) {
                this.source = source;
                this.repeatable = true;
            } else {
                this.stream = stream;
                this.repeatable = false;
            }
            this.resource = resource;
            this.length = resource == null ? -1L : resource.getContentLength();
            this.wagon = wagon;
        }

        @Override
        public long getContentLength() {
            return this.length;
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            if (this.source != null) {
                return new FileInputStream(this.source);
            }
            return this.stream;
        }

        @Override
        public boolean isRepeatable() {
            return this.repeatable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            block8: {
                if (outputStream == null) {
                    throw new NullPointerException("outputStream cannot be null");
                }
                TransferEvent transferEvent = new TransferEvent(this.wagon, this.resource, 3, 6);
                transferEvent.setTimestamp(System.currentTimeMillis());
                try (InputStream instream = this.source != null ? new FileInputStream(this.source) : this.stream;){
                    int l;
                    byte[] buffer = new byte[2048];
                    if (this.length < 0L) {
                        int l2;
                        while ((l2 = instream.read(buffer)) != -1) {
                            AbstractHttpClientWagon.this.fireTransferProgress(transferEvent, buffer, -1);
                            outputStream.write(buffer, 0, l2);
                        }
                        break block8;
                    }
                    for (long remaining = this.length; remaining > 0L; remaining -= (long)l) {
                        l = instream.read(buffer, 0, (int)Math.min(2048L, remaining));
                        if (l == -1) {
                            break;
                        }
                        AbstractHttpClientWagon.this.fireTransferProgress(transferEvent, buffer, (int)Math.min(2048L, remaining));
                        outputStream.write(buffer, 0, l);
                    }
                }
            }
        }

        @Override
        public boolean isStreaming() {
            return true;
        }
    }
}

