/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class NodeAttributes
implements ToXContentObject {
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final ParseField NAME = new ParseField("name", new String[0]);
    public static final ParseField EPHEMERAL_ID = new ParseField("ephemeral_id", new String[0]);
    public static final ParseField TRANSPORT_ADDRESS = new ParseField("transport_address", new String[0]);
    public static final ParseField ATTRIBUTES = new ParseField("attributes", new String[0]);
    public static final ConstructingObjectParser<NodeAttributes, Void> PARSER = new ConstructingObjectParser("node", true, a -> {
        int i = 0;
        String id = (String)a[i++];
        String name = (String)a[i++];
        String ephemeralId = (String)a[i++];
        String transportAddress = (String)a[i++];
        Map attributes = (Map)a[i];
        return new NodeAttributes(id, name, ephemeralId, transportAddress, attributes);
    });
    private final String id;
    private final String name;
    private final String ephemeralId;
    private final String transportAddress;
    private final Map<String, String> attributes;

    public NodeAttributes(String id, String name, String ephemeralId, String transportAddress, Map<String, String> attributes) {
        this.id = id;
        this.name = name;
        this.ephemeralId = ephemeralId;
        this.transportAddress = transportAddress;
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEphemeralId() {
        return this.ephemeralId;
    }

    public String getTransportAddress() {
        return this.transportAddress;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(EPHEMERAL_ID.getPreferredName(), this.ephemeralId);
        builder.field(TRANSPORT_ADDRESS.getPreferredName(), this.transportAddress);
        builder.field(ATTRIBUTES.getPreferredName(), this.attributes);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.ephemeralId, this.transportAddress, this.attributes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NodeAttributes that = (NodeAttributes)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.ephemeralId, that.ephemeralId) && Objects.equals(this.transportAddress, that.transportAddress) && Objects.equals(this.attributes, that.attributes);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), EPHEMERAL_ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TRANSPORT_ADDRESS);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.mapStrings(), ATTRIBUTES, ObjectParser.ValueType.OBJECT);
    }
}

