/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.tasks.TaskSubmissionResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;

public class CustomRestHighLevelClient
extends RestHighLevelClient {
    public CustomRestHighLevelClient(RestClientBuilder restClientBuilder) {
        super(restClientBuilder);
    }

    public final TaskSubmissionResponse submitDeleteByQuery(DeleteByQueryRequest deleteByQueryRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(deleteByQueryRequest, innerDeleteByQueryRequest -> {
            Request request = RequestConverters.deleteByQuery(innerDeleteByQueryRequest);
            request.addParameter("wait_for_completion", "false");
            return request;
        }, options, TaskSubmissionResponse::fromXContent, Collections.emptySet());
    }

    public final TaskSubmissionResponse submitUpdateByQuery(UpdateByQueryRequest updateByQueryRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(updateByQueryRequest, innerUpdateByQueryRequest -> {
            Request request = RequestConverters.updateByQuery(updateByQueryRequest);
            request.addParameter("wait_for_completion", "false");
            return request;
        }, options, TaskSubmissionResponse::fromXContent, Collections.emptySet());
    }
}

