/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.indices.IndexTemplateMetaData;
import org.elasticsearch.common.xcontent.XContentParser;

public class GetIndexTemplatesResponse {
    private final List<IndexTemplateMetaData> indexTemplates;

    public String toString() {
        ArrayList<IndexTemplateMetaData> thisList = new ArrayList<IndexTemplateMetaData>(this.indexTemplates);
        thisList.sort(Comparator.comparing(IndexTemplateMetaData::name));
        return "GetIndexTemplatesResponse [indexTemplates=" + thisList + "]";
    }

    GetIndexTemplatesResponse() {
        this.indexTemplates = new ArrayList<IndexTemplateMetaData>();
    }

    GetIndexTemplatesResponse(List<IndexTemplateMetaData> indexTemplates) {
        this.indexTemplates = indexTemplates;
    }

    public List<IndexTemplateMetaData> getIndexTemplates() {
        return this.indexTemplates;
    }

    public static GetIndexTemplatesResponse fromXContent(XContentParser parser) throws IOException {
        ArrayList<IndexTemplateMetaData> templates = new ArrayList<IndexTemplateMetaData>();
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                IndexTemplateMetaData templateMetaData = IndexTemplateMetaData.Builder.fromXContent(parser, parser.currentName());
                templates.add(templateMetaData);
            }
            token = parser.nextToken();
        }
        return new GetIndexTemplatesResponse(templates);
    }

    public int hashCode() {
        ArrayList<IndexTemplateMetaData> sortedList = new ArrayList<IndexTemplateMetaData>(this.indexTemplates);
        sortedList.sort(Comparator.comparing(IndexTemplateMetaData::name));
        return Objects.hash(sortedList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetIndexTemplatesResponse other = (GetIndexTemplatesResponse)obj;
        ArrayList<IndexTemplateMetaData> thisList = new ArrayList<IndexTemplateMetaData>(this.indexTemplates);
        ArrayList<IndexTemplateMetaData> otherList = new ArrayList<IndexTemplateMetaData>(other.indexTemplates);
        thisList.sort(Comparator.comparing(IndexTemplateMetaData::name));
        otherList.sort(Comparator.comparing(IndexTemplateMetaData::name));
        return Objects.equals(thisList, otherList);
    }
}

