/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import java.util.Date;
import java.util.UUID;
import javax.jws.WebService;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.EventsCollectorRequest;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.rest.models.EventCollectorResponse;
import org.apache.unomi.rest.service.RestServiceUtils;
import org.apache.unomi.utils.Changes;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json;charset=UTF-8"})
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/")
@Component(service={EventsCollectorEndpoint.class}, property={"osgi.jaxrs.resource=true"})
public class EventsCollectorEndpoint {
    private static final Logger logger = LoggerFactory.getLogger((String)EventsCollectorEndpoint.class.getName());
    @Reference
    private EventService eventService;
    @Reference
    private ProfileService profileService;
    @Reference
    private PrivacyService privacyService;
    @Reference
    private ConfigSharingService configSharingService;
    @Reference
    private RestServiceUtils restServiceUtils;
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;

    @OPTIONS
    @Path(value="/eventcollector")
    public Response options() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="/eventcollector")
    public EventCollectorResponse collectAsGet(@QueryParam(value="payload") @NotNull @Valid EventsCollectorRequest eventsCollectorRequest, @QueryParam(value="timestamp") Long timestampAsString) {
        return this.doEvent(eventsCollectorRequest, timestampAsString);
    }

    @POST
    @Path(value="/eventcollector")
    public EventCollectorResponse collectAsPost(@NotNull @Valid EventsCollectorRequest eventsCollectorRequest, @QueryParam(value="timestamp") Long timestampAsLong) {
        return this.doEvent(eventsCollectorRequest, timestampAsLong);
    }

    private EventCollectorResponse doEvent(EventsCollectorRequest eventsCollectorRequest, Long timestampAsLong) {
        String sessionId;
        Date timestamp = new Date();
        if (timestampAsLong != null) {
            timestamp = new Date(timestampAsLong);
        }
        if ((sessionId = eventsCollectorRequest.getSessionId()) == null) {
            sessionId = this.request.getParameter("sessionId");
        }
        Session session = null;
        if (sessionId != null) {
            session = this.profileService.loadSession(sessionId, timestamp);
        }
        Profile profile = null;
        if (session == null) {
            String scope = "systemscope";
            for (Event event : eventsCollectorRequest.getEvents()) {
                if (!StringUtils.isNotBlank((CharSequence)event.getEventType())) continue;
                if (StringUtils.isNotBlank((CharSequence)event.getScope()) && !event.getScope().equals("systemscope")) {
                    scope = event.getScope();
                    break;
                }
                if (event.getSource() == null || !StringUtils.isNotBlank((CharSequence)event.getSource().getScope()) || event.getSource().getScope().equals("systemscope")) continue;
                scope = event.getSource().getScope();
                break;
            }
            logger.debug("scope is now {}", (Object)scope);
            String cookieProfileId = this.restServiceUtils.getProfileIdCookieValue(this.request);
            if (StringUtils.isNotBlank((CharSequence)cookieProfileId)) {
                profile = this.profileService.load(cookieProfileId);
            }
            if (profile == null) {
                profile = new Profile("temp_" + UUID.randomUUID().toString());
                profile.setProperty("firstVisit", (Object)timestamp);
            }
        } else {
            Profile sessionProfile = session.getProfile();
            String errorMessage = String.format("No valid profile found or persona found for profileId=%s, aborting request !", session.getProfileId());
            if (sessionProfile.getItemId() != null) {
                profile = this.profileService.load(sessionProfile.getItemId());
                if (profile == null || profile instanceof Persona) {
                    logger.error(errorMessage);
                    throw new BadRequestException(errorMessage);
                }
            } else {
                String cookieProfileId = this.restServiceUtils.getProfileIdCookieValue(this.request);
                if (StringUtils.isNotBlank((CharSequence)cookieProfileId)) {
                    profile = this.profileService.load(cookieProfileId);
                }
                if (profile == null) {
                    logger.error(errorMessage);
                    throw new BadRequestException(errorMessage);
                }
            }
        }
        Changes changesObject = this.restServiceUtils.handleEvents(eventsCollectorRequest.getEvents(), session, profile, (ServletRequest)this.request, (ServletResponse)this.response, timestamp);
        int changes = changesObject.getChangeType();
        profile = changesObject.getProfile();
        if ((changes & 4) == 4) {
            this.profileService.save(profile);
        }
        if ((changes & 2) == 2 && session != null) {
            this.profileService.saveSession(session);
        }
        if ((changes & 1) == 1) {
            String errorMessage = "Error processing events. Total number of processed events: " + changesObject.getProcessedItems() + "/" + eventsCollectorRequest.getEvents().size();
            throw new BadRequestException(errorMessage);
        }
        return new EventCollectorResponse(changes);
    }
}

