/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jaas.spi;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.jaas.PropertyUserStoreManager;
import org.eclipse.jetty.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public class PropertyFileLoginModule
extends AbstractLoginModule {
    public static final String DEFAULT_FILENAME = "realm.properties";
    private static final Logger LOG = Log.getLogger(PropertyFileLoginModule.class);
    private PropertyUserStore _store;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.setupPropertyUserStore(options);
    }

    private void setupPropertyUserStore(Map<String, ?> options) {
        String filename = (String)options.get("file");
        filename = filename == null ? DEFAULT_FILENAME : filename;
        PropertyUserStoreManager mgr = (PropertyUserStoreManager)((Object)JAASLoginService.INSTANCE.get().getBean(PropertyUserStoreManager.class));
        if (mgr == null) {
            throw new IllegalStateException("No PropertyUserStoreManager");
        }
        this._store = mgr.getPropertyUserStore(filename);
        if (this._store == null) {
            boolean hotReload = false;
            String tmp = (String)options.get("hotReload");
            if (tmp != null) {
                hotReload = Boolean.parseBoolean(tmp);
            } else {
                tmp = (String)options.get("refreshInterval");
                if (tmp != null) {
                    LOG.warn("Use 'hotReload' boolean property instead of 'refreshInterval'", new Object[0]);
                    try {
                        hotReload = Integer.parseInt(tmp) > 0;
                    }
                    catch (NumberFormatException e) {
                        LOG.warn("'refreshInterval' is not an integer", new Object[0]);
                    }
                }
            }
            PropertyUserStore newStore = new PropertyUserStore();
            newStore.setConfig(filename);
            newStore.setHotReload(hotReload);
            this._store = mgr.addPropertyUserStore(filename, newStore);
            try {
                this._store.start();
            }
            catch (Exception e) {
                LOG.warn("Exception starting propertyUserStore {} ", new Object[]{filename, e});
            }
        }
    }

    @Override
    public UserInfo getUserInfo(String userName) throws Exception {
        LOG.debug("Checking PropertyUserStore {} for {}", new Object[]{this._store.getConfig(), userName});
        UserIdentity userIdentity = this._store.getUserIdentity(userName);
        if (userIdentity == null) {
            return null;
        }
        Set<AbstractLoginService.RolePrincipal> principals = userIdentity.getSubject().getPrincipals(AbstractLoginService.RolePrincipal.class);
        List<String> roles = principals.stream().map(AbstractLoginService.RolePrincipal::getName).collect(Collectors.toList());
        Credential credential = (Credential)userIdentity.getSubject().getPrivateCredentials().iterator().next();
        return new UserInfo(userName, credential, roles);
    }
}

