/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.Session;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.GoalsService;
import org.apache.unomi.api.services.PatchService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.api.services.RulesService;
import org.apache.unomi.api.services.SegmentService;
import org.jline.reader.LineReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class DeploymentCommandSupport
implements Action {
    public static final String ALL_OPTION_LABEL = "* (All)";
    @Reference
    DefinitionsService definitionsService;
    @Reference
    GoalsService goalsService;
    @Reference
    ProfileService profileService;
    @Reference
    RulesService rulesService;
    @Reference
    SegmentService segmentService;
    @Reference
    PatchService patchService;
    @Reference
    BundleContext bundleContext;
    @Reference
    Session session;
    public static final String CONDITION_DEFINITION_TYPE = "conditions";
    public static final String ACTION_DEFINITION_TYPE = "actions";
    public static final String GOAL_DEFINITION_TYPE = "goals";
    public static final String CAMPAIGN_DEFINITION_TYPE = "campaigns";
    public static final String PERSONA_DEFINITION_TYPE = "personas";
    public static final String PROPERTY_DEFINITION_TYPE = "properties";
    public static final String RULE_DEFINITION_TYPE = "rules";
    public static final String SEGMENT_DEFINITION_TYPE = "segments";
    public static final String SCORING_DEFINITION_TYPE = "scoring";
    public static final String PATCH_DEFINITION_TYPE = "patches";
    public static final String VALUE_DEFINITION_TYPE = "values";
    public static final String MERGER_DEFINITION_TYPE = "mergers";
    public static final String MAPPING_DEFINITION_TYPE = "mappings";
    protected static final List<String> definitionTypes = Arrays.asList("conditions", "actions", "goals", "campaigns", "personas", "properties", "rules", "segments", "scoring", "patches", "values", "mergers", "mappings");
    @Argument(index=0, name="bundleId", description="The bundle identifier where to find the definition", multiValued=false)
    Long bundleIdentifier;
    @Argument(index=1, name="type", description="The kind of definitions you want to load (e.g.: *, conditions, actions, ..)", required=false, multiValued=false)
    String definitionType;
    @Argument(index=2, name="fileName", description="The name of the file which contains the definition, without its extension (e.g: firstName)", required=false, multiValued=false)
    String fileName;

    public abstract void processDefinition(String var1, URL var2);

    public Object execute() throws Exception {
        List<Object> bundlesToUpdate;
        if ("*".equals(this.definitionType)) {
            this.definitionType = ALL_OPTION_LABEL;
        }
        if ("*".equals(this.fileName)) {
            this.fileName = ALL_OPTION_LABEL;
        }
        if (this.bundleIdentifier == null) {
            List<Object> bundles = new ArrayList();
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (bundle.findEntries("META-INF/cxs/", "*.json", true) == null) continue;
                bundles.add(bundle);
            }
            bundles = bundles.stream().filter(b -> definitionTypes.stream().anyMatch(t -> b.findEntries(this.getDefinitionTypePath((String)t), "*.json", true) != null)).collect(Collectors.toList());
            List<String> bundleSymbolicNames = bundles.stream().map(Bundle::getSymbolicName).collect(Collectors.toList());
            bundleSymbolicNames.add(ALL_OPTION_LABEL);
            String bundleAnswer = this.askUserWithAuthorizedAnswer(this.session, "Which bundle ?" + this.getValuesWithNumber(bundleSymbolicNames) + "\n", IntStream.range(1, bundleSymbolicNames.size() + 1).mapToObj(Integer::toString).collect(Collectors.toList()));
            String selectedBundle = bundleSymbolicNames.get(new Integer(bundleAnswer) - 1);
            bundlesToUpdate = selectedBundle.equals(ALL_OPTION_LABEL) ? bundles : Collections.singletonList((Bundle)bundles.get(new Integer(bundleAnswer) - 1));
        } else {
            Bundle bundle = this.bundleContext.getBundle(this.bundleIdentifier.longValue());
            if (bundle == null) {
                System.out.println("Couldn't find a bundle with id: " + this.bundleIdentifier);
                return null;
            }
            bundlesToUpdate = Collections.singletonList(bundle);
        }
        if (this.definitionType == null) {
            List<String> possibleDefinitionNames = definitionTypes.stream().filter(t -> bundlesToUpdate.stream().anyMatch(b -> b.findEntries(this.getDefinitionTypePath((String)t), "*.json", true) != null)).collect(Collectors.toList());
            possibleDefinitionNames.add(ALL_OPTION_LABEL);
            if (possibleDefinitionNames.isEmpty()) {
                System.out.println("Couldn't find definitions in bundle : " + bundlesToUpdate);
                return null;
            }
            String definitionTypeAnswer = this.askUserWithAuthorizedAnswer(this.session, "Which kind of definition do you want to load?" + this.getValuesWithNumber(possibleDefinitionNames) + "\n", IntStream.range(1, possibleDefinitionNames.size() + 1).mapToObj(Integer::toString).collect(Collectors.toList()));
            this.definitionType = possibleDefinitionNames.get(new Integer(definitionTypeAnswer) - 1);
        }
        if (!definitionTypes.contains(this.definitionType) && !ALL_OPTION_LABEL.equals(this.definitionType)) {
            System.out.println("Invalid type '" + this.definitionType + "' , allowed values : " + definitionTypes);
            return null;
        }
        String definitionTypePath = this.getDefinitionTypePath(this.definitionType);
        List definitionTypeURLs = bundlesToUpdate.stream().flatMap(b -> b.findEntries(definitionTypePath, "*.json", true) != null ? Collections.list(b.findEntries(definitionTypePath, "*.json", true)).stream() : Stream.empty()).collect(Collectors.toList());
        if (definitionTypeURLs.isEmpty()) {
            System.out.println("Couldn't find definitions in bundle with id: " + this.bundleIdentifier + " and definition path: " + definitionTypePath);
            return null;
        }
        if (this.fileName == null) {
            List definitionTypeFileNames = definitionTypeURLs.stream().map(u -> StringUtils.substringAfterLast((String)u.getFile(), (String)"/")).sorted().collect(Collectors.toList());
            definitionTypeFileNames.add(ALL_OPTION_LABEL);
            String fileNameAnswer = this.askUserWithAuthorizedAnswer(this.session, "Which file do you want to load ?" + this.getValuesWithNumber(definitionTypeFileNames) + "\n", IntStream.range(1, definitionTypeFileNames.size() + 1).mapToObj(Integer::toString).collect(Collectors.toList()));
            this.fileName = (String)definitionTypeFileNames.get(new Integer(fileNameAnswer) - 1);
        }
        if (ALL_OPTION_LABEL.equals(this.fileName)) {
            for (URL url : definitionTypeURLs) {
                this.processDefinition(this.definitionType, url);
            }
        } else {
            Optional<URL> optionalURL;
            if (!this.fileName.contains("/")) {
                this.fileName = "/" + this.fileName;
            }
            if (!this.fileName.endsWith(".json")) {
                this.fileName = this.fileName + ".json";
            }
            if ((optionalURL = definitionTypeURLs.stream().filter(u -> u.getFile().endsWith(this.fileName)).findFirst()).isPresent()) {
                URL url;
                url = optionalURL.get();
                this.processDefinition(this.definitionType, url);
            } else {
                System.out.println("Couldn't find file " + this.fileName);
                return null;
            }
        }
        return null;
    }

    protected String askUserWithAuthorizedAnswer(Session session, String msg, List<String> authorizedAnswer) throws IOException {
        String answer;
        while (!authorizedAnswer.contains((answer = this.promptMessageToUser(session, msg)).toLowerCase())) {
        }
        return answer;
    }

    protected String promptMessageToUser(Session session, String msg) throws IOException {
        LineReader reader = (LineReader)session.get(".jline.reader");
        return reader.readLine(msg, null);
    }

    protected String getValuesWithNumber(List<String> values) {
        StringBuilder definitionTypesWithNumber = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            definitionTypesWithNumber.append("\n").append(i + 1).append(". ").append(values.get(i));
        }
        return definitionTypesWithNumber.toString();
    }

    protected String getDefinitionTypePath(String definitionType) {
        StringBuilder path = new StringBuilder("META-INF/cxs/");
        if (!ALL_OPTION_LABEL.equals(definitionType)) {
            path.append(definitionType);
        }
        return path.toString();
    }
}

