/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Filter;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtendedHttpServiceRuntime;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ErrorPageWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.FilterMappingWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.FilterWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.HttpContextElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.JspWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ListenerMappingWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ListenerWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ResourceMappingWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ResourceWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ServletMappingWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebSocketElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WelcomeFileWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ErrorPageMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.FilterMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.FilterTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.HttpContextMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.HttpContextTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.JspMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ListenerMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ListenerTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ResourceMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ResourceTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ServletContextHelperTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ServletMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ServletTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.WebSocketTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.WelcomeFileMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.whiteboard.ErrorPageMapping;
import org.ops4j.pax.web.service.whiteboard.FilterMapping;
import org.ops4j.pax.web.service.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.service.whiteboard.JspMapping;
import org.ops4j.pax.web.service.whiteboard.ListenerMapping;
import org.ops4j.pax.web.service.whiteboard.ResourceMapping;
import org.ops4j.pax.web.service.whiteboard.ServletMapping;
import org.ops4j.pax.web.service.whiteboard.WelcomeFileMapping;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private ExtenderContext extenderContext;
    private List<ServiceTracker<?, ?>> trackers;
    private ExtendedHttpServiceRuntime httpServiceRuntime;

    public void start(BundleContext bundleContext) throws Exception {
        this.httpServiceRuntime = new ExtendedHttpServiceRuntime(bundleContext);
        this.httpServiceRuntime.start();
        this.extenderContext = new ExtenderContext(this.httpServiceRuntime);
        this.trackers = new ArrayList();
        this.trackHttpContexts(bundleContext, this.httpServiceRuntime);
        this.trackServlets(bundleContext);
        this.trackResources(bundleContext);
        if (WebContainerUtils.WEB_CONATAINER_AVAILABLE) {
            this.trackFilters(bundleContext);
            this.trackListeners(bundleContext);
            this.trackJspMappings(bundleContext);
            this.trackErrorPages(bundleContext);
            this.trackWelcomeFiles(bundleContext);
            this.trackServletContextHelper(bundleContext, this.httpServiceRuntime);
            if (WebContainerUtils.WEBSOCKETS_AVAILABLE) {
                this.trackWebSockets(bundleContext);
            } else {
                LOG.info("No javax.websocket.Endpoint class found, WebSocketTracker is disabled");
            }
        } else {
            LOG.warn("Filters tracking has been disabled as the WebContainer (Pax Web) is not available");
            LOG.warn("Event Listeners tracking has been disabled as the WebContainer (Pax Web) is not available");
            LOG.warn("JSP mappings tracking has been disabled as the WebContainer (Pax Web) is not available");
        }
        LOG.debug("Pax Web Whiteboard Extender started");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        ArrayList serviceTrackers = new ArrayList(this.trackers);
        Collections.reverse(serviceTrackers);
        for (ServiceTracker serviceTracker : serviceTrackers) {
            serviceTracker.close();
        }
        this.trackers = null;
        this.httpServiceRuntime.stop();
        LOG.debug("Pax Web Extender stopped");
    }

    private void trackHttpContexts(BundleContext bundleContext, ExtendedHttpServiceRuntime httpServiceRuntime) {
        ServiceTracker<HttpContext, HttpContextElement> httpContextTracker = HttpContextTracker.createTracker(this.extenderContext, bundleContext, httpServiceRuntime);
        httpContextTracker.open();
        this.trackers.add(0, httpContextTracker);
        ServiceTracker<HttpContextMapping, HttpContextElement> httpContextMappingTracker = HttpContextMappingTracker.createTracker(this.extenderContext, bundleContext, httpServiceRuntime);
        httpContextMappingTracker.open();
        this.trackers.add(0, httpContextMappingTracker);
    }

    private void trackServletContextHelper(BundleContext bundleContext, ExtendedHttpServiceRuntime httpServiceRuntime) {
        ServiceTracker servletContextHelperTracker = ServletContextHelperTracker.createTracker(this.extenderContext, bundleContext, httpServiceRuntime);
        servletContextHelperTracker.open();
        this.trackers.add(0, servletContextHelperTracker);
    }

    private void trackServlets(BundleContext bundleContext) {
        ServiceTracker servletTracker = ServletTracker.createTracker(this.extenderContext, bundleContext);
        servletTracker.open();
        this.trackers.add(0, servletTracker);
        ServiceTracker<ServletMapping, ServletMappingWebElement> servletMappingTracker = ServletMappingTracker.createTracker(this.extenderContext, bundleContext);
        servletMappingTracker.open();
        this.trackers.add(0, servletMappingTracker);
    }

    private void trackResources(BundleContext bundleContext) {
        ServiceTracker<Object, ResourceWebElement> resourceTracker = ResourceTracker.createTracker(this.extenderContext, bundleContext);
        resourceTracker.open();
        this.trackers.add(0, resourceTracker);
        ServiceTracker<ResourceMapping, ResourceMappingWebElement> resourceMappingTracker = ResourceMappingTracker.createTracker(this.extenderContext, bundleContext);
        resourceMappingTracker.open();
        this.trackers.add(0, resourceMappingTracker);
    }

    private void trackFilters(BundleContext bundleContext) {
        ServiceTracker<Filter, FilterWebElement> filterTracker = FilterTracker.createTracker(this.extenderContext, bundleContext);
        filterTracker.open();
        this.trackers.add(0, filterTracker);
        ServiceTracker<FilterMapping, FilterMappingWebElement> filterMappingTracker = FilterMappingTracker.createTracker(this.extenderContext, bundleContext);
        filterMappingTracker.open();
        this.trackers.add(0, filterMappingTracker);
    }

    private void trackListeners(BundleContext bundleContext) {
        ServiceTracker<EventListener, ListenerWebElement> listenerTracker = ListenerTracker.createTracker(this.extenderContext, bundleContext);
        listenerTracker.open();
        this.trackers.add(0, listenerTracker);
        ServiceTracker<ListenerMapping, ListenerMappingWebElement> listenerMappingTracker = ListenerMappingTracker.createTracker(this.extenderContext, bundleContext);
        listenerMappingTracker.open();
        this.trackers.add(0, listenerMappingTracker);
    }

    private void trackJspMappings(BundleContext bundleContext) {
        ServiceTracker<JspMapping, JspWebElement> jspMappingTracker = JspMappingTracker.createTracker(this.extenderContext, bundleContext);
        jspMappingTracker.open();
        this.trackers.add(0, jspMappingTracker);
    }

    private void trackWelcomeFiles(BundleContext bundleContext) {
        ServiceTracker<WelcomeFileMapping, WelcomeFileWebElement> welcomeFileTracker = WelcomeFileMappingTracker.createTracker(this.extenderContext, bundleContext);
        welcomeFileTracker.open();
        this.trackers.add(0, welcomeFileTracker);
    }

    private void trackErrorPages(BundleContext bundleContext) {
        ServiceTracker<ErrorPageMapping, ErrorPageWebElement> errorPagesTracker = ErrorPageMappingTracker.createTracker(this.extenderContext, bundleContext);
        errorPagesTracker.open();
        this.trackers.add(0, errorPagesTracker);
    }

    private void trackWebSockets(BundleContext bundleContext) {
        ServiceTracker<Object, WebSocketElement> webSocketTracker = WebSocketTracker.createTracker(this.extenderContext, bundleContext);
        webSocketTracker.open();
        this.trackers.add(0, webSocketTracker);
    }
}

