/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.types;

public enum BinaryOperatorType {
    EQ,
    EQ_IGNORE,
    GT,
    GTE,
    LT,
    LTE,
    NOT_EQ,
    CONTAINS,
    NOT_CONTAINS,
    CONTAINS_IGNORECASE,
    REGEX,
    NOT_REGEX,
    IN,
    NOT_IN,
    IS,
    NOT_IS,
    RANGE,
    NOT_RANGE,
    STARTS_WITH,
    ENDS_WITH;


    public static BinaryOperatorType asOperator(String text) {
        if ("==".equals(text)) {
            return EQ;
        }
        if ("=~".equals(text)) {
            return EQ_IGNORE;
        }
        if (">".equals(text)) {
            return GT;
        }
        if (">=".equals(text)) {
            return GTE;
        }
        if ("<".equals(text)) {
            return LT;
        }
        if ("<=".equals(text)) {
            return LTE;
        }
        if ("!=".equals(text)) {
            return NOT_EQ;
        }
        if ("contains".equals(text)) {
            return CONTAINS;
        }
        if ("not contains".equals(text)) {
            return NOT_CONTAINS;
        }
        if ("~~".equals(text)) {
            return CONTAINS_IGNORECASE;
        }
        if ("regex".equals(text)) {
            return REGEX;
        }
        if ("not regex".equals(text)) {
            return NOT_REGEX;
        }
        if ("in".equals(text)) {
            return IN;
        }
        if ("not in".equals(text)) {
            return NOT_IN;
        }
        if ("is".equals(text)) {
            return IS;
        }
        if ("not is".equals(text)) {
            return NOT_IS;
        }
        if ("range".equals(text)) {
            return RANGE;
        }
        if ("not range".equals(text)) {
            return NOT_RANGE;
        }
        if ("starts with".equals(text)) {
            return STARTS_WITH;
        }
        if ("ends with".equals(text)) {
            return ENDS_WITH;
        }
        throw new IllegalArgumentException("Operator not supported: " + text);
    }

    public static String getOperatorText(BinaryOperatorType operator) {
        if (operator == EQ) {
            return "==";
        }
        if (operator == EQ_IGNORE) {
            return "=~";
        }
        if (operator == GT) {
            return ">";
        }
        if (operator == GTE) {
            return ">=";
        }
        if (operator == LT) {
            return "<";
        }
        if (operator == LTE) {
            return "<=";
        }
        if (operator == NOT_EQ) {
            return "!=";
        }
        if (operator == CONTAINS) {
            return "contains";
        }
        if (operator == NOT_CONTAINS) {
            return "not contains";
        }
        if (operator == CONTAINS_IGNORECASE) {
            return "~~";
        }
        if (operator == REGEX) {
            return "regex";
        }
        if (operator == NOT_REGEX) {
            return "not regex";
        }
        if (operator == IN) {
            return "in";
        }
        if (operator == NOT_IN) {
            return "not in";
        }
        if (operator == IS) {
            return "is";
        }
        if (operator == NOT_IS) {
            return "not is";
        }
        if (operator == RANGE) {
            return "range";
        }
        if (operator == NOT_RANGE) {
            return "not range";
        }
        if (operator == STARTS_WITH) {
            return "starts with";
        }
        if (operator == ENDS_WITH) {
            return "ends with";
        }
        return "";
    }

    public static ParameterType[] supportedParameterTypes(BinaryOperatorType operator) {
        if (operator == EQ) {
            return null;
        }
        if (operator == EQ_IGNORE) {
            return null;
        }
        if (operator == GT) {
            return null;
        }
        if (operator == GTE) {
            return null;
        }
        if (operator == LT) {
            return null;
        }
        if (operator == LTE) {
            return null;
        }
        if (operator == NOT_EQ) {
            return null;
        }
        if (operator == CONTAINS) {
            return null;
        }
        if (operator == NOT_CONTAINS) {
            return null;
        }
        if (operator == CONTAINS_IGNORECASE) {
            return null;
        }
        if (operator == REGEX) {
            return new ParameterType[]{ParameterType.Literal, ParameterType.Function};
        }
        if (operator == NOT_REGEX) {
            return new ParameterType[]{ParameterType.Literal, ParameterType.Function};
        }
        if (operator == IN) {
            return null;
        }
        if (operator == NOT_IN) {
            return null;
        }
        if (operator == IS) {
            return new ParameterType[]{ParameterType.LiteralWithFunction, ParameterType.Function};
        }
        if (operator == NOT_IS) {
            return new ParameterType[]{ParameterType.LiteralWithFunction, ParameterType.Function};
        }
        if (operator == RANGE) {
            return new ParameterType[]{ParameterType.LiteralWithFunction, ParameterType.Function};
        }
        if (operator == NOT_RANGE) {
            return new ParameterType[]{ParameterType.LiteralWithFunction, ParameterType.Function};
        }
        if (operator == STARTS_WITH) {
            return null;
        }
        if (operator == ENDS_WITH) {
            return null;
        }
        return null;
    }

    public String toString() {
        return BinaryOperatorType.getOperatorText(this);
    }

    public static enum ParameterType {
        Literal,
        LiteralWithFunction,
        Function,
        NumericValue,
        BooleanValue,
        NullValue,
        MinusValue;


        public boolean isLiteralSupported() {
            return this == Literal;
        }

        public boolean isLiteralWithFunctionSupport() {
            return this == LiteralWithFunction;
        }

        public boolean isFunctionSupport() {
            return this == Function;
        }

        public boolean isNumericValueSupported() {
            return this == NumericValue;
        }

        public boolean isBooleanValueSupported() {
            return this == BooleanValue;
        }

        public boolean isNullValueSupported() {
            return this == NullValue;
        }

        public boolean isMinusValueSupported() {
            return this == MinusValue;
        }
    }
}

