/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Principal;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.utils.Utils;

public class KafkaChannel {
    private final String id;
    private final TransportLayer transportLayer;
    private final Authenticator authenticator;
    private final int maxReceiveSize;
    private NetworkReceive receive;
    private Send send;

    public KafkaChannel(String id, TransportLayer transportLayer, Authenticator authenticator, int maxReceiveSize) throws IOException {
        this.id = id;
        this.transportLayer = transportLayer;
        this.authenticator = authenticator;
        this.maxReceiveSize = maxReceiveSize;
    }

    public void close() throws IOException {
        Utils.closeAll(this.transportLayer, this.authenticator);
    }

    public Principal principal() throws IOException {
        return this.authenticator.principal();
    }

    public void prepare() throws IOException {
        if (!this.transportLayer.ready()) {
            this.transportLayer.handshake();
        }
        if (this.transportLayer.ready() && !this.authenticator.complete()) {
            this.authenticator.authenticate();
        }
    }

    public void disconnect() {
        this.transportLayer.disconnect();
    }

    public boolean finishConnect() throws IOException {
        return this.transportLayer.finishConnect();
    }

    public boolean isConnected() {
        return this.transportLayer.isConnected();
    }

    public String id() {
        return this.id;
    }

    public void mute() {
        this.transportLayer.removeInterestOps(1);
    }

    public void unmute() {
        this.transportLayer.addInterestOps(1);
    }

    public boolean isMute() {
        return this.transportLayer.isMute();
    }

    public boolean ready() {
        return this.transportLayer.ready() && this.authenticator.complete();
    }

    public boolean hasSend() {
        return this.send != null;
    }

    public InetAddress socketAddress() {
        return this.transportLayer.socketChannel().socket().getInetAddress();
    }

    public String socketDescription() {
        Socket socket = this.transportLayer.socketChannel().socket();
        if (socket.getInetAddress() == null) {
            return socket.getLocalAddress().toString();
        }
        return socket.getInetAddress().toString();
    }

    public void setSend(Send send) {
        if (this.send != null) {
            throw new IllegalStateException("Attempt to begin a send operation with prior send operation still in progress.");
        }
        this.send = send;
        this.transportLayer.addInterestOps(4);
    }

    public NetworkReceive read() throws IOException {
        NetworkReceive result = null;
        if (this.receive == null) {
            this.receive = new NetworkReceive(this.maxReceiveSize, this.id);
        }
        this.receive(this.receive);
        if (this.receive.complete()) {
            this.receive.payload().rewind();
            result = this.receive;
            this.receive = null;
        }
        return result;
    }

    public Send write() throws IOException {
        Send result = null;
        if (this.send != null && this.send(this.send)) {
            result = this.send;
            this.send = null;
        }
        return result;
    }

    private long receive(NetworkReceive receive) throws IOException {
        return receive.readFrom(this.transportLayer);
    }

    private boolean send(Send send) throws IOException {
        send.writeTo(this.transportLayer);
        if (send.completed()) {
            this.transportLayer.removeInterestOps(4);
        }
        return send.completed();
    }
}

