/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import java.util.EventListener;
import javax.servlet.AsyncListener;
import javax.servlet.ReadListener;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.ServicePropertiesUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.whiteboard.ListenerMapping;
import org.ops4j.pax.web.service.whiteboard.WhiteboardListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerWebElement<T extends EventListener>
extends WebElement<T>
implements WhiteboardListener {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerWebElement.class);
    private final ListenerMapping listenerMapping;

    public ListenerWebElement(ServiceReference<T> ref, ListenerMapping listenerMapping) {
        super(ref);
        Boolean listenerEnabled;
        NullArgumentException.validateNotNull(listenerMapping, "Listener mapping");
        this.listenerMapping = listenerMapping;
        EventListener listener = listenerMapping.getListener();
        if (!(listener instanceof ServletContextListener || listener instanceof ServletContextAttributeListener || listener instanceof ServletRequestListener || listener instanceof ServletRequestAttributeListener || listener instanceof HttpSessionListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionActivationListener || listener instanceof AsyncListener || listener instanceof ReadListener || listener instanceof WriteListener || listener instanceof HttpSessionIdListener)) {
            this.valid = false;
        }
        if (listenerMapping.getHttpContextId() != null && listenerMapping.getHttpContextId().trim().length() == 0) {
            LOG.warn("Registered listener [{}] did not contain a valid http context id.", (Object)this.getServiceID());
            this.valid = false;
        }
        if (!Boolean.TRUE.equals(listenerEnabled = ServicePropertiesUtils.getBooleanProperty(this.serviceReference, "osgi.http.whiteboard.listener"))) {
            LOG.warn("Registered listener [{}] is not enabled via 'osgi.http.whiteboard.listener' property.", (Object)this.getServiceID());
            this.valid = false;
        }
    }

    @Override
    public void register(WebContainer webContainer, HttpContext httpContext) throws Exception {
        webContainer.registerEventListener(this.listenerMapping.getListener(), httpContext);
    }

    @Override
    public void unregister(WebContainer webContainer, HttpContext httpContext) {
        webContainer.unregisterEventListener(this.listenerMapping.getListener());
    }

    @Override
    public String getHttpContextId() {
        return this.listenerMapping.getHttpContextId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mapping=" + this.listenerMapping + "}";
    }

    public ListenerMapping getListenerMapping() {
        return this.listenerMapping;
    }
}

