/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.control;

import java.util.Dictionary;
import org.apache.karaf.cellar.core.Producer;
import org.apache.karaf.cellar.core.command.CommandHandler;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.ProducerSwitchCommand;
import org.apache.karaf.cellar.core.control.ProducerSwitchResult;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.osgi.service.cm.Configuration;

public class ProducerSwitchCommandHandler
extends CommandHandler<ProducerSwitchCommand, ProducerSwitchResult> {
    public static final String SWITCH_ID = "org.apache.karaf.cellar.command.producer.switch";
    private final Switch commandSwitch = new BasicSwitch("org.apache.karaf.cellar.command.producer.switch");

    @Override
    public ProducerSwitchResult execute(ProducerSwitchCommand command) {
        if (command.getStatus() == null) {
            return new ProducerSwitchResult(command.getId(), Boolean.TRUE, this.producer.getSwitch().getStatus().getValue());
        }
        if (command.getStatus().equals((Object)SwitchStatus.ON)) {
            this.producer.getSwitch().turnOn();
            this.persist(command.getStatus());
            return new ProducerSwitchResult(command.getId(), Boolean.TRUE, Boolean.TRUE);
        }
        if (command.getStatus().equals((Object)SwitchStatus.OFF)) {
            this.producer.getSwitch().turnOff();
            this.persist(command.getStatus());
            return new ProducerSwitchResult(command.getId(), Boolean.TRUE, Boolean.FALSE);
        }
        return new ProducerSwitchResult(command.getId(), Boolean.FALSE, this.producer.getSwitch().getStatus().getValue());
    }

    private void persist(SwitchStatus switchStatus) {
        try {
            Dictionary properties;
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (configuration != null && (properties = configuration.getProperties()) != null) {
                properties.put("producer", switchStatus.getValue().toString());
                configuration.update(properties);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't persist the producer status", (Throwable)e);
        }
    }

    @Override
    public Class<ProducerSwitchCommand> getType() {
        return ProducerSwitchCommand.class;
    }

    @Override
    public Switch getSwitch() {
        return this.commandSwitch;
    }

    @Override
    public Producer getProducer() {
        return this.producer;
    }

    @Override
    public void setProducer(Producer producer) {
        this.producer = producer;
    }
}

