/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.command;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.karaf.diagnostic.core.Dump;
import org.apache.karaf.diagnostic.core.DumpDestination;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.framework.BundleContext;

@Command(scope="dev", name="dump-create", description="Creates zip archive with diagnostic info.")
@Service
public class DumpCommand
implements Action {
    private SimpleDateFormat dumpFormat = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
    @Option(name="-d", aliases={"--directory"}, description="Creates dump in a directory in place of a ZIP archive")
    boolean directory;
    @Option(name="--no-thread-dump", description="Include or not the thread dump in ZIP archive")
    boolean noThreadDump = false;
    @Option(name="--no-heap-dump", description="Include or not the heap dump in ZIP archive")
    boolean noHeapDump = false;
    @Argument(name="name", description="Name of created zip or directory", required=false)
    String fileName;
    @Reference
    BundleContext bundleContext;

    public Object execute() throws Exception {
        if (this.fileName == null || this.fileName.trim().length() == 0) {
            this.fileName = this.dumpFormat.format(new Date());
            if (!this.directory) {
                this.fileName = this.fileName + ".zip";
            }
        }
        File target = new File(this.fileName);
        DumpDestination destination = this.directory ? Dump.directory((File)target) : Dump.zip((File)target);
        Dump.dump((BundleContext)this.bundleContext, (DumpDestination)destination, (boolean)this.noThreadDump, (boolean)this.noHeapDump);
        System.out.println("Created dump " + destination.toString());
        return null;
    }
}

