/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.softclassification;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class BinarySoftClassification
implements Evaluation {
    public static final String NAME = "binary_soft_classification";
    private static final ParseField ACTUAL_FIELD = new ParseField("actual_field", new String[0]);
    private static final ParseField PREDICTED_PROBABILITY_FIELD = new ParseField("predicted_probability_field", new String[0]);
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    public static final ConstructingObjectParser<BinarySoftClassification, Void> PARSER = new ConstructingObjectParser("binary_soft_classification", true, args -> new BinarySoftClassification((String)args[0], (String)args[1], (List)args[2]));
    private final String actualField;
    private final String predictedProbabilityField;
    private final List<EvaluationMetric> metrics;

    public static BinarySoftClassification fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public BinarySoftClassification(String actualField, String predictedField) {
        this(actualField, predictedField, (List<EvaluationMetric>)null);
    }

    public BinarySoftClassification(String actualField, String predictedProbabilityField, EvaluationMetric ... metric) {
        this(actualField, predictedProbabilityField, Arrays.asList(metric));
    }

    public BinarySoftClassification(String actualField, String predictedProbabilityField, @Nullable List<EvaluationMetric> metrics) {
        this.actualField = Objects.requireNonNull(actualField);
        this.predictedProbabilityField = Objects.requireNonNull(predictedProbabilityField);
        if (metrics != null) {
            metrics.sort(Comparator.comparing(EvaluationMetric::getName));
        }
        this.metrics = metrics;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTUAL_FIELD.getPreferredName(), this.actualField);
        builder.field(PREDICTED_PROBABILITY_FIELD.getPreferredName(), this.predictedProbabilityField);
        if (this.metrics != null) {
            builder.startObject(METRICS.getPreferredName());
            for (EvaluationMetric metric : this.metrics) {
                builder.field(metric.getName(), metric);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinarySoftClassification that = (BinarySoftClassification)o;
        return Objects.equals(this.actualField, that.actualField) && Objects.equals(this.predictedProbabilityField, that.predictedProbabilityField) && Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.actualField, this.predictedProbabilityField, this.metrics);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ACTUAL_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PREDICTED_PROBABILITY_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> p.namedObject(EvaluationMetric.class, n, null), METRICS);
    }
}

