/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.ClusterNode;
import org.apache.unomi.api.services.ClusterService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/cluster")
@Component(service={ClusterServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class ClusterServiceEndPoint {
    private static final Logger logger = LoggerFactory.getLogger((String)ClusterServiceEndPoint.class.getName());
    @Context
    private MessageContext messageContext;
    @Reference
    private ClusterService clusterService;

    public ClusterServiceEndPoint() {
        logger.info("Initializing cluster service endpoint...");
    }

    @WebMethod(exclude=true)
    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @WebMethod(exclude=true)
    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    @GET
    @Path(value="/")
    public List<ClusterNode> getClusterNodes() {
        return this.clusterService.getClusterNodes();
    }

    @GET
    @Path(value="/purge/{date}")
    public void purge(@PathParam(value="date") String date) {
        block2: {
            try {
                this.clusterService.purge(new SimpleDateFormat("yyyy-MM-dd").parse(date));
            }
            catch (ParseException e) {
                logger.error("Cannot parse date, expected format is: yyyy-MM-dd. See debug log level for more information");
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Cannot parse date: {}", (Object)date, (Object)e);
            }
        }
    }

    @DELETE
    @Path(value="{scope}")
    public void deleteScopedData(@PathParam(value="scope") String scope) {
        this.clusterService.purge(scope);
    }
}

