/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.DynamicRouter;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Pattern;
import org.apache.camel.Processor;
import org.apache.camel.RecipientList;
import org.apache.camel.RoutingSlip;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.StreamCache;
import org.apache.camel.component.bean.BeanHelper;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterBindingException;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.StringQuoteHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MethodInfo.class);
    private CamelContext camelContext;
    private Class<?> type;
    private Method method;
    private final List<ParameterInfo> parameters;
    private final List<ParameterInfo> bodyParameters;
    private final boolean hasCustomAnnotation;
    private final boolean hasHandlerAnnotation;
    private Expression parametersExpression;
    private ExchangePattern pattern = ExchangePattern.InOut;
    private org.apache.camel.processor.RecipientList recipientList;
    private org.apache.camel.processor.RoutingSlip routingSlip;
    private org.apache.camel.processor.DynamicRouter dynamicRouter;

    public MethodInfo(CamelContext camelContext, Class<?> type, Method method, List<ParameterInfo> parameters, List<ParameterInfo> bodyParameters, boolean hasCustomAnnotation, boolean hasHandlerAnnotation) {
        RecipientList recipientListAnnotation;
        DynamicRouter dynamicRouterAnnotation;
        RoutingSlip routingSlipAnnotation;
        this.camelContext = camelContext;
        this.type = type;
        this.method = method;
        this.parameters = parameters;
        this.bodyParameters = bodyParameters;
        this.hasCustomAnnotation = hasCustomAnnotation;
        this.hasHandlerAnnotation = hasHandlerAnnotation;
        this.parametersExpression = this.createParametersExpression();
        Map<Class<?>, Annotation> collectedMethodAnnotation = this.collectMethodAnnotations(type, method);
        Pattern oneway = this.findOneWayAnnotation(method);
        if (oneway != null) {
            this.pattern = oneway.value();
        }
        if ((routingSlipAnnotation = (RoutingSlip)collectedMethodAnnotation.get(RoutingSlip.class)) != null && this.matchContext(routingSlipAnnotation.context())) {
            this.routingSlip = new org.apache.camel.processor.RoutingSlip(camelContext);
            this.routingSlip.setDelimiter(routingSlipAnnotation.delimiter());
            this.routingSlip.setIgnoreInvalidEndpoints(routingSlipAnnotation.ignoreInvalidEndpoints());
            try {
                camelContext.addService(this.routingSlip);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if ((dynamicRouterAnnotation = (DynamicRouter)collectedMethodAnnotation.get(DynamicRouter.class)) != null && this.matchContext(dynamicRouterAnnotation.context())) {
            this.dynamicRouter = new org.apache.camel.processor.DynamicRouter(camelContext);
            this.dynamicRouter.setDelimiter(dynamicRouterAnnotation.delimiter());
            this.dynamicRouter.setIgnoreInvalidEndpoints(dynamicRouterAnnotation.ignoreInvalidEndpoints());
            try {
                camelContext.addService(this.dynamicRouter);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if ((recipientListAnnotation = (RecipientList)collectedMethodAnnotation.get(RecipientList.class)) != null && this.matchContext(recipientListAnnotation.context())) {
            ExecutorService executor;
            this.recipientList = new org.apache.camel.processor.RecipientList(camelContext, recipientListAnnotation.delimiter());
            this.recipientList.setStopOnException(recipientListAnnotation.stopOnException());
            this.recipientList.setStopOnAggregateException(recipientListAnnotation.stopOnAggregateException());
            this.recipientList.setIgnoreInvalidEndpoints(recipientListAnnotation.ignoreInvalidEndpoints());
            this.recipientList.setParallelProcessing(recipientListAnnotation.parallelProcessing());
            this.recipientList.setParallelAggregate(recipientListAnnotation.parallelAggregate());
            this.recipientList.setStreaming(recipientListAnnotation.streaming());
            this.recipientList.setTimeout(recipientListAnnotation.timeout());
            this.recipientList.setShareUnitOfWork(recipientListAnnotation.shareUnitOfWork());
            if (ObjectHelper.isNotEmpty(recipientListAnnotation.executorServiceRef())) {
                executor = camelContext.getExecutorServiceManager().newDefaultThreadPool(this, recipientListAnnotation.executorServiceRef());
                this.recipientList.setExecutorService(executor);
            }
            if (recipientListAnnotation.parallelProcessing() && this.recipientList.getExecutorService() == null) {
                executor = camelContext.getExecutorServiceManager().newDefaultThreadPool(this, "@RecipientList");
                this.recipientList.setExecutorService(executor);
            }
            if (ObjectHelper.isNotEmpty(recipientListAnnotation.strategyRef())) {
                AggregationStrategy strategy = CamelContextHelper.mandatoryLookup(camelContext, recipientListAnnotation.strategyRef(), AggregationStrategy.class);
                this.recipientList.setAggregationStrategy(strategy);
            }
            if (ObjectHelper.isNotEmpty(recipientListAnnotation.onPrepareRef())) {
                Processor onPrepare = CamelContextHelper.mandatoryLookup(camelContext, recipientListAnnotation.onPrepareRef(), Processor.class);
                this.recipientList.setOnPrepare(onPrepare);
            }
            try {
                camelContext.addService(this.recipientList);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
    }

    private Map<Class<?>, Annotation> collectMethodAnnotations(Class<?> c, Method method) {
        HashMap annotations = new HashMap();
        this.collectMethodAnnotations(c, method, annotations);
        return annotations;
    }

    private void collectMethodAnnotations(Class<?> c, Method method, Map<Class<?>, Annotation> annotations) {
        for (Class<?> i : c.getInterfaces()) {
            this.collectMethodAnnotations(i, method, annotations);
        }
        if (!c.isInterface() && c.getSuperclass() != null) {
            this.collectMethodAnnotations(c.getSuperclass(), method, annotations);
        }
        try {
            Annotation[] ma;
            for (Annotation a : ma = c.getDeclaredMethod(method.getName(), method.getParameterTypes()).getAnnotations()) {
                annotations.put(a.annotationType(), a);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private boolean matchContext(String context) {
        return !ObjectHelper.isNotEmpty(context) || this.camelContext.getName().equals(context);
    }

    public String toString() {
        return this.method.toString();
    }

    public MethodInvocation createMethodInvocation(final Object pojo, boolean hasParameters, final Exchange exchange) {
        final Object[] arguments = hasParameters ? this.parametersExpression.evaluate(exchange, Object[].class) : null;
        return new MethodInvocation(){

            @Override
            public Method getMethod() {
                return MethodInfo.this.method;
            }

            @Override
            public Object[] getArguments() {
                return arguments;
            }

            @Override
            public boolean proceed(AsyncCallback callback) {
                Object body = exchange.getIn().getBody();
                if (body != null && body instanceof StreamCache) {
                    ((StreamCache)body).reset();
                }
                try {
                    return this.doProceed(callback);
                }
                catch (InvocationTargetException e) {
                    exchange.setException(e.getTargetException());
                    callback.done(true);
                    return true;
                }
                catch (Throwable e) {
                    exchange.setException(e);
                    callback.done(true);
                    return true;
                }
            }

            private boolean doProceed(AsyncCallback callback) throws Exception {
                Class<Void> result;
                if (MethodInfo.this.dynamicRouter != null) {
                    if (!MethodInfo.this.dynamicRouter.isStarted()) {
                        ServiceHelper.startService(MethodInfo.this.dynamicRouter);
                    }
                    DynamicRouterExpression expression = new DynamicRouterExpression(pojo);
                    return MethodInfo.this.dynamicRouter.doRoutingSlip(exchange, expression, callback);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(">>>> invoking: {} on bean: {} with arguments: {} for exchange: {}", new Object[]{MethodInfo.this.method, pojo, ObjectHelper.asString(arguments), exchange});
                }
                if ((result = MethodInfo.this.invoke(MethodInfo.this.method, pojo, arguments, exchange)) instanceof Callable) {
                    LOG.trace("Method returned Callback which will be called: {}", (Object)result);
                    Object callableResult = ((Callable)((Object)result)).call();
                    result = callableResult != null ? callableResult : Void.TYPE;
                }
                if (MethodInfo.this.recipientList != null) {
                    if (!MethodInfo.this.recipientList.isStarted()) {
                        ServiceHelper.startService(MethodInfo.this.recipientList);
                    }
                    return MethodInfo.this.recipientList.sendToRecipientList(exchange, result, callback);
                }
                if (MethodInfo.this.routingSlip != null) {
                    if (!MethodInfo.this.routingSlip.isStarted()) {
                        ServiceHelper.startService(MethodInfo.this.routingSlip);
                    }
                    return MethodInfo.this.routingSlip.doRoutingSlip(exchange, result, callback);
                }
                if (CompletionStage.class.isAssignableFrom(this.getMethod().getReturnType())) {
                    CompletionStage completionStage = (CompletionStage)((Object)result);
                    completionStage.whenComplete((resultObject, e) -> {
                        if (e != null) {
                            exchange.setException((Throwable)e);
                        } else if (resultObject != null) {
                            MethodInfo.this.fillResult(exchange, resultObject);
                        }
                        callback.done(false);
                    });
                    return false;
                }
                if (!this.getMethod().getReturnType().equals(Void.TYPE) && result != Void.TYPE) {
                    MethodInfo.this.fillResult(exchange, result);
                }
                callback.done(true);
                return true;
            }

            @Override
            public Object getThis() {
                return pojo;
            }

            @Override
            public AccessibleObject getStaticPart() {
                return MethodInfo.this.method;
            }
        };
    }

    private void fillResult(Exchange exchange, Object result) {
        boolean copyNeeded;
        Message old;
        boolean out;
        LOG.trace("Setting bean invocation result : {}", result);
        boolean bl = out = ExchangeHelper.isOutCapable(exchange) || exchange.hasOut();
        if (out) {
            old = exchange.getOut();
            exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
            if (exchange.getIn().hasAttachments()) {
                exchange.getOut().getAttachments().putAll(exchange.getIn().getAttachments());
            }
        } else {
            old = exchange.getIn();
        }
        boolean bl2 = copyNeeded = !old.getClass().equals(DefaultMessage.class);
        if (copyNeeded) {
            DefaultMessage msg = new DefaultMessage(exchange.getContext());
            msg.copyFromWithNewBody(old, result);
            ExchangeHelper.replaceMessage(exchange, msg, false);
        } else {
            old.setBody(result);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public Expression getParametersExpression() {
        return this.parametersExpression;
    }

    public List<ParameterInfo> getBodyParameters() {
        return this.bodyParameters;
    }

    public Class<?> getBodyParameterType() {
        if (this.bodyParameters.isEmpty()) {
            return null;
        }
        ParameterInfo parameterInfo = this.bodyParameters.get(0);
        return parameterInfo.getType();
    }

    public boolean bodyParameterMatches(Class<?> bodyType) {
        Class<?> actualType = this.getBodyParameterType();
        return actualType != null && ObjectHelper.isAssignableFrom(bodyType, actualType);
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public boolean hasBodyParameter() {
        return !this.bodyParameters.isEmpty();
    }

    public boolean hasCustomAnnotation() {
        return this.hasCustomAnnotation;
    }

    public boolean hasHandlerAnnotation() {
        return this.hasHandlerAnnotation;
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean isReturnTypeVoid() {
        return this.method.getReturnType().getName().equals("void");
    }

    public boolean isStaticMethod() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public boolean isCovariantWith(MethodInfo method) {
        return method.getMethod().getName().equals(this.getMethod().getName()) && (method.getMethod().getReturnType().isAssignableFrom(this.getMethod().getReturnType()) || this.getMethod().getReturnType().isAssignableFrom(method.getMethod().getReturnType())) && Arrays.deepEquals(method.getMethod().getParameterTypes(), this.getMethod().getParameterTypes());
    }

    protected Object invoke(Method mth, Object pojo, Object[] arguments, Exchange exchange) throws InvocationTargetException {
        try {
            return mth.invoke(pojo, arguments);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeExchangeException("IllegalAccessException occurred invoking method: " + mth + " using arguments: " + Arrays.asList(arguments), exchange, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeExchangeException("IllegalArgumentException occurred invoking method: " + mth + " using arguments: " + Arrays.asList(arguments), exchange, e);
        }
    }

    protected Expression[] createParameterExpressions() {
        int size = this.parameters.size();
        LOG.trace("Creating parameters expression for {} parameters", (Object)size);
        Expression[] expressions = new Expression[size];
        for (int i = 0; i < size; ++i) {
            Expression parameterExpression;
            expressions[i] = parameterExpression = this.parameters.get(i).getExpression();
            LOG.trace("Parameter #{} has expression: {}", (Object)i, (Object)parameterExpression);
        }
        return expressions;
    }

    protected Expression createParametersExpression() {
        return new ParameterExpression(this.createParameterExpressions());
    }

    protected Pattern findOneWayAnnotation(Method method) {
        Pattern answer = this.getPatternAnnotation(method);
        if (answer == null) {
            Class<?>[] interfaces;
            Class<?> type = method.getDeclaringClass();
            ArrayList typesToSearch = new ArrayList();
            this.addTypeAndSuperTypes(type, typesToSearch);
            for (Class<?> anInterface : interfaces = type.getInterfaces()) {
                this.addTypeAndSuperTypes(anInterface, typesToSearch);
            }
            answer = this.findOneWayAnnotationOnMethod(typesToSearch, method);
            if (answer == null) {
                answer = this.findOneWayAnnotation(typesToSearch);
            }
        }
        return answer;
    }

    protected Pattern getPatternAnnotation(AnnotatedElement annotatedElement) {
        return this.getPatternAnnotation(annotatedElement, 2);
    }

    protected Pattern getPatternAnnotation(AnnotatedElement annotatedElement, int depth) {
        Pattern answer = annotatedElement.getAnnotation(Pattern.class);
        int nextDepth = depth - 1;
        if (nextDepth > 0) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotatedElement.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotation instanceof Pattern || annotationType.equals(annotatedElement)) continue;
                Pattern another = this.getPatternAnnotation(annotationType, nextDepth);
                if (this.pattern == null) continue;
                if (answer == null) {
                    answer = another;
                    continue;
                }
                LOG.warn("Duplicate pattern annotation: " + another + " found on annotation: " + annotation + " which will be ignored");
            }
        }
        return answer;
    }

    protected void addTypeAndSuperTypes(Class<?> type, List<Class<?>> result) {
        for (Class<?> t = type; t != null && t != Object.class; t = t.getSuperclass()) {
            result.add(t);
        }
    }

    protected Pattern findOneWayAnnotationOnMethod(List<Class<?>> classes, Method method) {
        for (Class<?> type : classes) {
            try {
                Method definedMethod = type.getMethod(method.getName(), method.getParameterTypes());
                Pattern answer = this.getPatternAnnotation(definedMethod);
                if (answer == null) continue;
                return answer;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    protected Pattern findOneWayAnnotation(List<Class<?>> classes) {
        for (Class<?> type : classes) {
            Pattern answer = this.getPatternAnnotation(type);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }

    protected boolean hasExceptionParameter() {
        for (ParameterInfo parameter : this.parameters) {
            if (!Exception.class.isAssignableFrom(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    private final class ParameterExpression
    implements Expression {
        private final Expression[] expressions;

        ParameterExpression(Expression[] expressions) {
            this.expressions = expressions;
        }

        @Override
        public <T> T evaluate(Exchange exchange, Class<T> type) {
            Object[] body = exchange.getIn().getBody();
            boolean multiParameterArray = exchange.getIn().getHeader("CamelBeanMultiParameterArray", false, Boolean.TYPE);
            if (multiParameterArray && !(body instanceof Object[])) {
                body = exchange.getIn().getBody(Object[].class);
            }
            String methodName = exchange.getIn().getHeader("CamelBeanMethodName", String.class);
            String methodParameters = StringHelper.betweenOuterPair(methodName, '(', ')');
            Iterator<Object> it = null;
            if (methodParameters != null) {
                String[] parameters = StringQuoteHelper.splitSafeQuote(methodParameters, ',', true);
                it = ObjectHelper.createIterator(parameters, ",", true);
            }
            if (multiParameterArray) {
                exchange.getIn().removeHeader("CamelBeanMultiParameterArray");
            }
            if (methodName != null) {
                exchange.getIn().removeHeader("CamelBeanMethodName");
            }
            Object[] answer = this.evaluateParameterExpressions(exchange, body, multiParameterArray, it);
            return (T)answer;
        }

        private Object[] evaluateParameterExpressions(Exchange exchange, Object body, boolean multiParameterArray, Iterator<?> it) {
            Object[] answer = new Object[this.expressions.length];
            for (int i = 0; i < this.expressions.length; ++i) {
                if (body != null && body instanceof StreamCache) {
                    ((StreamCache)body).reset();
                }
                Object parameterValue = it != null && it.hasNext() ? (Object)it.next() : null;
                Class<?> parameterType = ((ParameterInfo)MethodInfo.this.parameters.get(i)).getType();
                Object value = null;
                if (multiParameterArray && body instanceof Object[]) {
                    Object[] array = (Object[])body;
                    if (array.length >= i) {
                        value = array[i];
                    }
                } else {
                    if (parameterValue != null && !parameterValue.equals("*")) {
                        value = this.evaluateParameterValue(exchange, i, parameterValue, parameterType);
                    }
                    Expression expression = this.expressions[i];
                    if (value == null && expression != null) {
                        value = this.evaluateParameterBinding(exchange, expression, i, parameterType);
                    }
                }
                if (value == Void.TYPE) continue;
                answer[i] = value;
            }
            return answer;
        }

        private Object evaluateParameterValue(Exchange exchange, int index, Object parameterValue, Class<?> parameterType) {
            Object answer = null;
            String exp = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, parameterValue);
            if (exp != null) {
                Boolean isClass;
                boolean valid = BeanHelper.isValidParameterValue(exp);
                if (!valid && (isClass = BeanHelper.isAssignableToExpectedType(exchange.getContext().getClassResolver(), exp, parameterType)) != null) {
                    return null;
                }
                Expression expression = null;
                try {
                    expression = exchange.getContext().resolveLanguage("simple").createExpression(exp);
                    parameterValue = expression.evaluate(exchange, Object.class);
                    if (parameterValue == null) {
                        parameterValue = "null";
                    }
                }
                catch (Exception e) {
                    throw new ExpressionEvaluationException(expression, "Cannot create/evaluate simple expression: " + exp + " to be bound to parameter at index: " + index + " on method: " + MethodInfo.this.getMethod(), exchange, e);
                }
                if ("null".equals(parameterValue)) {
                    return Void.TYPE;
                }
                if (parameterType.isAssignableFrom(parameterValue.getClass())) {
                    valid = true;
                } else {
                    exp = exchange.getContext().getTypeConverter().tryConvertTo(String.class, parameterValue);
                    if (!valid) {
                        boolean bl = valid = parameterValue instanceof String || BeanHelper.isValidParameterValue(exp);
                    }
                }
                if (valid) {
                    if (parameterValue instanceof String) {
                        parameterValue = StringHelper.removeLeadingAndEndingQuotes((String)parameterValue);
                    }
                    if (parameterValue != null) {
                        try {
                            answer = exchange.getContext().getTypeConverter().mandatoryConvertTo(parameterType, exchange, parameterValue);
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Parameter #{} evaluated as: {} type: ", new Object[]{index, answer, ObjectHelper.type(answer)});
                            }
                        }
                        catch (Exception e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Cannot convert from type: {} to type: {} for parameter #{}", new Object[]{ObjectHelper.type(parameterValue), parameterType, index});
                            }
                            throw new ParameterBindingException(e, MethodInfo.this.method, index, parameterType, parameterValue);
                        }
                    }
                }
            }
            return answer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Object evaluateParameterBinding(Exchange exchange, Expression expression, int index, Class<?> parameterType) {
            Object answer = null;
            Object result = expression.evaluate(exchange, Object.class);
            if (result != null) {
                try {
                    answer = parameterType.isInstance(result) ? result : exchange.getContext().getTypeConverter().mandatoryConvertTo(parameterType, result);
                    if (!LOG.isTraceEnabled()) return answer;
                    LOG.trace("Parameter #{} evaluated as: {} type: ", new Object[]{index, answer, ObjectHelper.type(answer)});
                    return answer;
                }
                catch (NoTypeConversionAvailableException e) {
                    if (!LOG.isDebugEnabled()) throw new ParameterBindingException(e, MethodInfo.this.method, index, parameterType, result);
                    LOG.debug("Cannot convert from type: {} to type: {} for parameter #{}", new Object[]{ObjectHelper.type(result), parameterType, index});
                    throw new ParameterBindingException(e, MethodInfo.this.method, index, parameterType, result);
                }
            } else {
                LOG.trace("Parameter #{} evaluated as null", (Object)index);
            }
            return answer;
        }

        public String toString() {
            return "ParametersExpression: " + Arrays.asList(this.expressions);
        }
    }

    private final class DynamicRouterExpression
    extends ExpressionAdapter {
        private final Object pojo;

        private DynamicRouterExpression(Object pojo) {
            this.pojo = pojo;
        }

        @Override
        public Object evaluate(Exchange exchange) {
            Object[] arguments = MethodInfo.this.parametersExpression.evaluate(exchange, Object[].class);
            try {
                return MethodInfo.this.invoke(MethodInfo.this.method, this.pojo, arguments, exchange);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }

        public String toString() {
            return "DynamicRouter[invoking: " + MethodInfo.this.method + " on bean: " + this.pojo + "]";
        }
    }
}

