/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.ack.CreateIndexClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexTemplateService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.threadpool.ThreadPool;

public class MetaDataCreateIndexService {
    private static final Logger logger = LogManager.getLogger(MetaDataCreateIndexService.class);
    public static final int MAX_INDEX_NAME_BYTES = 255;
    private final Settings settings;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final AliasValidator aliasValidator;
    private final Environment env;
    private final IndexScopedSettings indexScopedSettings;
    private final ActiveShardsObserver activeShardsObserver;
    private final NamedXContentRegistry xContentRegistry;
    private final boolean forbidPrivateIndexSettings;

    public MetaDataCreateIndexService(Settings settings, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, AliasValidator aliasValidator, Environment env, IndexScopedSettings indexScopedSettings, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, boolean forbidPrivateIndexSettings) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.aliasValidator = aliasValidator;
        this.env = env;
        this.indexScopedSettings = indexScopedSettings;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.xContentRegistry = xContentRegistry;
        this.forbidPrivateIndexSettings = forbidPrivateIndexSettings;
    }

    public static void validateIndexName(String index, ClusterState state) {
        MetaDataCreateIndexService.validateIndexOrAliasName(index, InvalidIndexNameException::new);
        if (!index.toLowerCase(Locale.ROOT).equals(index)) {
            throw new InvalidIndexNameException(index, "must be lowercase");
        }
        if (state.routingTable().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.routingTable().index(index).getIndex());
        }
        if (state.metaData().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.metaData().index(index).getIndex());
        }
        if (state.metaData().hasAlias(index)) {
            throw new InvalidIndexNameException(index, "already exists as alias");
        }
    }

    public static void validateIndexOrAliasName(String index, BiFunction<String, String, ? extends RuntimeException> exceptionCtor) {
        if (!Strings.validFileName(index)) {
            throw exceptionCtor.apply(index, "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (index.contains("#")) {
            throw exceptionCtor.apply(index, "must not contain '#'");
        }
        if (index.contains(":")) {
            throw exceptionCtor.apply(index, "must not contain ':'");
        }
        if (index.charAt(0) == '_' || index.charAt(0) == '-' || index.charAt(0) == '+') {
            throw exceptionCtor.apply(index, "must not start with '_', '-', or '+'");
        }
        int byteCount = 0;
        try {
            byteCount = index.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new ElasticsearchException("Unable to determine length of index name", (Throwable)e, new Object[0]);
        }
        if (byteCount > 255) {
            throw exceptionCtor.apply(index, "index name is too long, (" + byteCount + " > " + 255 + ")");
        }
        if (index.equals(".") || index.equals("..")) {
            throw exceptionCtor.apply(index, "must not be '.' or '..'");
        }
    }

    public void createIndex(CreateIndexClusterStateUpdateRequest request, ActionListener<CreateIndexClusterStateUpdateResponse> listener) {
        this.onlyCreateIndex(request, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.activeShardsObserver.waitForActiveShards(new String[]{request.index()}, request.waitForActiveShards(), request.ackTimeout(), shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        logger.debug("[{}] index created, but the operation timed out while waiting for enough shards to be started.", (Object)request.index());
                    }
                    listener.onResponse(new CreateIndexClusterStateUpdateResponse(response.isAcknowledged(), (boolean)shardsAcknowledged));
                }, listener::onFailure);
            } else {
                listener.onResponse(new CreateIndexClusterStateUpdateResponse(false, false));
            }
        }, listener::onFailure));
    }

    private void onlyCreateIndex(CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings.Builder updatedSettingsBuilder = Settings.builder();
        Settings build = updatedSettingsBuilder.put(request.settings()).normalizePrefix("index.").build();
        this.indexScopedSettings.validate(build, true);
        request.settings(build);
        this.clusterService.submitStateUpdateTask("create-index [" + request.index() + "], cause [" + request.cause() + "]", new IndexCreationTask(logger, this.allocationService, request, listener, this.indicesService, this.aliasValidator, this.xContentRegistry, this.settings, this::validate, this.indexScopedSettings));
    }

    private void validate(CreateIndexClusterStateUpdateRequest request, ClusterState state) {
        MetaDataCreateIndexService.validateIndexName(request.index(), state);
        this.validateIndexSettings(request.index(), request.settings(), this.forbidPrivateIndexSettings);
    }

    public void validateIndexSettings(String indexName, Settings settings, boolean forbidPrivateIndexSettings) throws IndexCreationException {
        List<String> validationErrors = this.getIndexSettingsValidationErrors(settings, forbidPrivateIndexSettings);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new IndexCreationException(indexName, validationException);
        }
    }

    public static void checkShardLimit(Settings settings, ClusterState clusterState) {
        int numberOfReplicas;
        int numberOfShards = IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(settings);
        int shardsToCreate = numberOfShards * (1 + (numberOfReplicas = IndexMetaData.INDEX_NUMBER_OF_REPLICAS_SETTING.get(settings).intValue()));
        Optional<String> shardLimit = IndicesService.checkShardLimit(shardsToCreate, clusterState);
        if (shardLimit.isPresent()) {
            ValidationException e = new ValidationException();
            e.addValidationError(shardLimit.get());
            throw e;
        }
    }

    List<String> getIndexSettingsValidationErrors(Settings settings, boolean forbidPrivateIndexSettings) {
        Path resolvedPath;
        String customPath = IndexMetaData.INDEX_DATA_PATH_SETTING.get(settings);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!Strings.isEmpty(customPath) && this.env.sharedDataFile() == null) {
            validationErrors.add("path.shared_data must be set in order to use custom data paths");
        } else if (!Strings.isEmpty(customPath) && (resolvedPath = PathUtils.get(new Path[]{this.env.sharedDataFile()}, customPath)) == null) {
            validationErrors.add("custom path [" + customPath + "] is not a sub-path of path.shared_data [" + this.env.sharedDataFile() + "]");
        }
        if (forbidPrivateIndexSettings) {
            for (String key : settings.keySet()) {
                Setting<?> setting = this.indexScopedSettings.get(key);
                if (setting == null) {
                    assert (this.indexScopedSettings.isPrivateSetting(key));
                    continue;
                }
                if (!setting.isPrivateIndex()) continue;
                validationErrors.add("private index setting [" + key + "] can not be set explicitly");
            }
        }
        return validationErrors;
    }

    static List<String> validateShrinkIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetaData sourceMetaData = MetaDataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        assert (IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings));
        IndexMetaData.selectShrinkShards(0, sourceMetaData, IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        if (sourceMetaData.getNumberOfShards() == 1) {
            throw new IllegalArgumentException("can't shrink an index with only one shard");
        }
        IndexRoutingTable table = state.routingTable().index(sourceIndex);
        HashMap<String, AtomicInteger> nodesToNumRouting = new HashMap<String, AtomicInteger>();
        int numShards = sourceMetaData.getNumberOfShards();
        for (ShardRouting routing : table.shardsWithState(ShardRoutingState.STARTED)) {
            nodesToNumRouting.computeIfAbsent(routing.currentNodeId(), s -> new AtomicInteger(0)).incrementAndGet();
        }
        ArrayList<String> nodesToAllocateOn = new ArrayList<String>();
        for (Map.Entry entries : nodesToNumRouting.entrySet()) {
            int numAllocations = ((AtomicInteger)entries.getValue()).get();
            assert (numAllocations <= numShards) : "wait what? " + numAllocations + " is > than num shards " + numShards;
            if (numAllocations != numShards) continue;
            nodesToAllocateOn.add((String)entries.getKey());
        }
        if (nodesToAllocateOn.isEmpty()) {
            throw new IllegalStateException("index " + sourceIndex + " must have all shards allocated on the same node to shrink index");
        }
        return nodesToAllocateOn;
    }

    static void validateSplitIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetaData sourceMetaData = MetaDataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        IndexMetaData.selectSplitShard(0, sourceMetaData, IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        if (sourceMetaData.getCreationVersion().before(Version.V_6_0_0_alpha1)) {
            throw new IllegalStateException("source index created version is too old to apply a split operation");
        }
    }

    static void validateCloneIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetaData sourceMetaData = MetaDataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        IndexMetaData.selectCloneShard(0, sourceMetaData, IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
    }

    static IndexMetaData validateResize(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        if (state.metaData().hasIndex(targetIndexName)) {
            throw new ResourceAlreadyExistsException(state.metaData().index(targetIndexName).getIndex());
        }
        IndexMetaData sourceMetaData = state.metaData().index(sourceIndex);
        if (sourceMetaData == null) {
            throw new IndexNotFoundException(sourceIndex);
        }
        if (!state.blocks().indexBlocked(ClusterBlockLevel.WRITE, sourceIndex)) {
            throw new IllegalStateException("index " + sourceIndex + " must be read-only to resize index. use \"index.blocks.write=true\"");
        }
        if (targetIndexMappingsTypes.size() > 1 || !(targetIndexMappingsTypes.isEmpty() || targetIndexMappingsTypes.contains("_default_"))) {
            throw new IllegalArgumentException("mappings are not allowed when resizing indices, all mappings are copied from the source index");
        }
        if (IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            IndexMetaData.getRoutingFactor(sourceMetaData.getNumberOfShards(), IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        }
        return sourceMetaData;
    }

    static void prepareResizeIndexSettings(ClusterState currentState, Set<String> mappingKeys, Settings.Builder indexSettingsBuilder, Index resizeSourceIndex, String resizeIntoName, ResizeType type, boolean copySettings, IndexScopedSettings indexScopedSettings) {
        String initialRecoveryIdFilter = IndexMetaData.INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getKey() + "_id";
        IndexMetaData sourceMetaData = currentState.metaData().index(resizeSourceIndex.getName());
        if (type == ResizeType.SHRINK) {
            List<String> nodesToAllocateOn = MetaDataCreateIndexService.validateShrinkIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.put(initialRecoveryIdFilter, Strings.arrayToCommaDelimitedString(nodesToAllocateOn.toArray())).put("index.allocation.max_retries", 1);
        } else if (type == ResizeType.SPLIT) {
            MetaDataCreateIndexService.validateSplitIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.putNull(initialRecoveryIdFilter);
        } else if (type == ResizeType.CLONE) {
            MetaDataCreateIndexService.validateCloneIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.putNull(initialRecoveryIdFilter);
        } else {
            throw new IllegalStateException("unknown resize type is " + (Object)((Object)type));
        }
        Settings.Builder builder = Settings.builder();
        if (copySettings) {
            for (String key : sourceMetaData.getSettings().keySet()) {
                Setting<?> setting = indexScopedSettings.get(key);
                if (setting == null) {
                    assert (indexScopedSettings.isPrivateSetting(key)) : key;
                } else if (setting.getProperties().contains((Object)Setting.Property.NotCopyableOnResize)) continue;
                if (indexSettingsBuilder.keys().contains(key)) continue;
                builder.copy(key, sourceMetaData.getSettings());
            }
        } else {
            Predicate<String> sourceSettingsPredicate = s -> (s.startsWith("index.similarity.") || s.startsWith("index.analysis.") || s.startsWith("index.sort.") || s.equals("index.soft_deletes.enabled")) && !indexSettingsBuilder.keys().contains(s);
            builder.put(sourceMetaData.getSettings().filter(sourceSettingsPredicate));
        }
        indexSettingsBuilder.put(IndexMetaData.SETTING_INDEX_VERSION_CREATED.getKey(), sourceMetaData.getCreationVersion()).put("index.version.upgraded", sourceMetaData.getUpgradedVersion()).put(builder.build()).put("index.routing_partition_size", sourceMetaData.getRoutingPartitionSize()).put(IndexMetaData.INDEX_RESIZE_SOURCE_NAME.getKey(), resizeSourceIndex.getName()).put(IndexMetaData.INDEX_RESIZE_SOURCE_UUID.getKey(), resizeSourceIndex.getUUID());
    }

    public static int calculateNumRoutingShards(int numShards, Version indexVersionCreated) {
        if (indexVersionCreated.onOrAfter(Version.V_7_0_0)) {
            int log2MaxNumShards = 10;
            int log2NumShards = 32 - Integer.numberOfLeadingZeros(numShards - 1);
            int numSplits = log2MaxNumShards - log2NumShards;
            numSplits = Math.max(1, numSplits);
            return numShards * 1 << numSplits;
        }
        return numShards;
    }

    static class IndexCreationTask
    extends AckedClusterStateUpdateTask<ClusterStateUpdateResponse> {
        private final IndicesService indicesService;
        private final AliasValidator aliasValidator;
        private final NamedXContentRegistry xContentRegistry;
        private final CreateIndexClusterStateUpdateRequest request;
        private final Logger logger;
        private final AllocationService allocationService;
        private final Settings settings;
        private final IndexValidator validator;
        private final IndexScopedSettings indexScopedSettings;

        IndexCreationTask(Logger logger, AllocationService allocationService, CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener, IndicesService indicesService, AliasValidator aliasValidator, NamedXContentRegistry xContentRegistry, Settings settings, IndexValidator validator, IndexScopedSettings indexScopedSettings) {
            super(Priority.URGENT, request, listener);
            this.request = request;
            this.logger = logger;
            this.allocationService = allocationService;
            this.indicesService = indicesService;
            this.aliasValidator = aliasValidator;
            this.xContentRegistry = xContentRegistry;
            this.settings = settings;
            this.validator = validator;
            this.indexScopedSettings = indexScopedSettings;
        }

        @Override
        protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
            return new ClusterStateUpdateResponse(acknowledged);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            Index createdIndex = null;
            String removalExtraInfo = null;
            IndicesClusterStateService.AllocatedIndices.IndexRemovalReason removalReason = IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.FAILURE;
            try {
                IndexMetaData indexMetaData;
                int routingNumShards;
                IndexMetaData sourceMetaData;
                this.validator.validate(this.request, currentState);
                for (Alias alias : this.request.aliases()) {
                    this.aliasValidator.validateAlias(alias, this.request.index(), currentState.metaData());
                }
                List<IndexTemplateMetaData> templates = MetaDataIndexTemplateService.findTemplates(currentState.metaData(), this.request.index());
                HashMap<String, Map<String, Object>> mappings = new HashMap<String, Map<String, Object>>();
                HashMap<String, AliasMetaData> templatesAliases = new HashMap<String, AliasMetaData>();
                ArrayList<String> templateNames = new ArrayList<String>();
                for (Map.Entry<String, String> entry : this.request.mappings().entrySet()) {
                    Map<String, Object> mapping = MapperService.parseMapping(this.xContentRegistry, entry.getValue());
                    assert (mapping.size() == 1) : mapping;
                    assert (entry.getKey().equals(mapping.keySet().iterator().next())) : entry.getKey() + " != " + mapping;
                    mappings.put(entry.getKey(), mapping);
                }
                Index recoverFromIndex = this.request.recoverFrom();
                if (recoverFromIndex == null) {
                    for (IndexTemplateMetaData template : templates) {
                        templateNames.add(template.getName());
                        for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : template.mappings()) {
                            Map<String, Object> templateMapping;
                            String mappingString = ((CompressedXContent)objectObjectCursor.value).string();
                            if (mappings.containsKey(objectObjectCursor.key)) {
                                XContentHelper.mergeDefaults((Map)mappings.get(objectObjectCursor.key), MapperService.parseMapping(this.xContentRegistry, mappingString));
                                continue;
                            }
                            if (mappings.size() == 1 && ((String)objectObjectCursor.key).equals("_doc")) {
                                templateMapping = MapperService.parseMapping(this.xContentRegistry, mappingString);
                                assert (templateMapping.size() == 1) : templateMapping;
                                assert (((String)objectObjectCursor.key).equals(templateMapping.keySet().iterator().next())) : (String)objectObjectCursor.key + " != " + templateMapping;
                                Map.Entry mappingEntry = mappings.entrySet().iterator().next();
                                templateMapping = Collections.singletonMap((String)mappingEntry.getKey(), templateMapping.values().iterator().next());
                                XContentHelper.mergeDefaults((Map)mappingEntry.getValue(), templateMapping);
                                continue;
                            }
                            if (template.mappings().size() == 1 && mappings.containsKey("_doc")) {
                                templateMapping = MapperService.parseMapping(this.xContentRegistry, mappingString);
                                assert (templateMapping.size() == 1) : templateMapping;
                                assert (((String)objectObjectCursor.key).equals(templateMapping.keySet().iterator().next())) : (String)objectObjectCursor.key + " != " + templateMapping;
                                Map mapping = (Map)mappings.get("_doc");
                                templateMapping = Collections.singletonMap("_doc", templateMapping.values().iterator().next());
                                XContentHelper.mergeDefaults(mapping, templateMapping);
                                continue;
                            }
                            mappings.put((String)objectObjectCursor.key, MapperService.parseMapping(this.xContentRegistry, mappingString));
                        }
                        for (ObjectObjectCursor objectObjectCursor : template.aliases()) {
                            AliasMetaData aliasMetaData = (AliasMetaData)objectObjectCursor.value;
                            if (this.request.aliases().contains(new Alias(aliasMetaData.alias())) || templatesAliases.containsKey(objectObjectCursor.key)) continue;
                            if (aliasMetaData.alias().contains("{index}")) {
                                String templatedAlias = aliasMetaData.alias().replace("{index}", this.request.index());
                                aliasMetaData = AliasMetaData.newAliasMetaData(aliasMetaData, templatedAlias);
                            }
                            this.aliasValidator.validateAliasMetaData(aliasMetaData, this.request.index(), currentState.metaData());
                            templatesAliases.put(aliasMetaData.alias(), aliasMetaData);
                        }
                    }
                }
                Settings.Builder builder = Settings.builder();
                if (recoverFromIndex == null) {
                    for (int i = templates.size() - 1; i >= 0; --i) {
                        builder.put(templates.get(i).settings());
                    }
                }
                builder.put(this.request.settings());
                if (builder.get(IndexMetaData.SETTING_INDEX_VERSION_CREATED.getKey()) == null) {
                    DiscoveryNodes nodes = currentState.nodes();
                    Version createdVersion = Version.min(Version.CURRENT, nodes.getSmallestNonClientNodeVersion());
                    builder.put(IndexMetaData.SETTING_INDEX_VERSION_CREATED.getKey(), createdVersion);
                }
                if (builder.get("index.number_of_shards") == null) {
                    int numberOfShards = IndexCreationTask.getNumberOfShards(builder);
                    builder.put("index.number_of_shards", this.settings.getAsInt("index.number_of_shards", numberOfShards));
                }
                if (builder.get("index.number_of_replicas") == null) {
                    builder.put("index.number_of_replicas", this.settings.getAsInt("index.number_of_replicas", 1));
                }
                if (this.settings.get("index.auto_expand_replicas") != null && builder.get("index.auto_expand_replicas") == null) {
                    builder.put("index.auto_expand_replicas", this.settings.get("index.auto_expand_replicas"));
                }
                if (builder.get("index.creation_date") == null) {
                    builder.put("index.creation_date", Instant.now().toEpochMilli());
                }
                builder.put("index.provided_name", this.request.getProvidedName());
                builder.put("index.uuid", UUIDs.randomBase64UUID());
                IndexMetaData.Builder tmpImdBuilder = IndexMetaData.builder(this.request.index());
                Settings idxSettings = builder.build();
                int n = IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(idxSettings);
                Version indexVersionCreated = IndexMetaData.SETTING_INDEX_VERSION_CREATED.get(idxSettings);
                IndexMetaData indexMetaData2 = sourceMetaData = recoverFromIndex == null ? null : currentState.metaData().getIndexSafe(recoverFromIndex);
                if (sourceMetaData == null || sourceMetaData.getNumberOfShards() == 1) {
                    routingNumShards = IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(idxSettings) ? IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.get(idxSettings) : MetaDataCreateIndexService.calculateNumRoutingShards(n, indexVersionCreated);
                } else {
                    assert (!IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(builder.build())) : "index.number_of_routing_shards should not be present on the target index on resize";
                    routingNumShards = sourceMetaData.getRoutingNumShards();
                }
                builder.remove(IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.getKey());
                tmpImdBuilder.setRoutingNumShards(routingNumShards);
                if (recoverFromIndex != null) {
                    assert (this.request.resizeType() != null);
                    MetaDataCreateIndexService.prepareResizeIndexSettings(currentState, mappings.keySet(), builder, recoverFromIndex, this.request.index(), this.request.resizeType(), this.request.copySettings(), this.indexScopedSettings);
                }
                Settings actualIndexSettings = builder.build();
                this.checkShardLimit(actualIndexSettings, currentState);
                tmpImdBuilder.settings(actualIndexSettings);
                if (recoverFromIndex != null) {
                    long primaryTerm = IntStream.range(0, sourceMetaData.getNumberOfShards()).mapToLong(sourceMetaData::primaryTerm).max().getAsLong();
                    for (int shardId = 0; shardId < tmpImdBuilder.numberOfShards(); ++shardId) {
                        tmpImdBuilder.primaryTerm(shardId, primaryTerm);
                    }
                }
                IndexMetaData tmpImd = tmpImdBuilder.build();
                ActiveShardCount waitForActiveShards = this.request.waitForActiveShards();
                if (waitForActiveShards == ActiveShardCount.DEFAULT) {
                    waitForActiveShards = tmpImd.getWaitForActiveShards();
                }
                if (!waitForActiveShards.validate(tmpImd.getNumberOfReplicas())) {
                    throw new IllegalArgumentException("invalid wait_for_active_shards[" + this.request.waitForActiveShards() + "]: cannot be greater than number of shard copies [" + (tmpImd.getNumberOfReplicas() + 1) + "]");
                }
                IndicesClusterStateService.AllocatedIndex indexService = this.indicesService.createIndex(tmpImd, Collections.emptyList());
                createdIndex = ((AbstractIndexComponent)((Object)indexService)).index();
                MapperService mapperService = ((IndexService)indexService).mapperService();
                try {
                    mapperService.merge(mappings, MapperService.MergeReason.MAPPING_UPDATE);
                }
                catch (Exception e) {
                    removalExtraInfo = "failed on parsing default mapping/mappings on index creation";
                    throw e;
                }
                if (this.request.recoverFrom() == null) {
                    ((IndexService)indexService).getIndexSortSupplier().get();
                }
                QueryShardContext queryShardContext = ((IndexService)indexService).newQueryShardContext(0, null, () -> 0L, null);
                for (Alias alias : this.request.aliases()) {
                    if (!Strings.hasLength(alias.filter())) continue;
                    this.aliasValidator.validateAliasFilter(alias.name(), alias.filter(), queryShardContext, this.xContentRegistry);
                }
                for (Object aliasMetaData : templatesAliases.values()) {
                    if (((AliasMetaData)aliasMetaData).filter() == null) continue;
                    this.aliasValidator.validateAliasFilter(((AliasMetaData)aliasMetaData).alias(), ((AliasMetaData)aliasMetaData).filter().uncompressed(), queryShardContext, this.xContentRegistry);
                }
                HashMap<String, MappingMetaData> mappingsMetaData = new HashMap<String, MappingMetaData>();
                for (DocumentMapper mapper : Arrays.asList(mapperService.documentMapper(), mapperService.documentMapper("_default_"))) {
                    if (mapper == null) continue;
                    MappingMetaData mappingMd = new MappingMetaData(mapper);
                    mappingsMetaData.put(mapper.type(), mappingMd);
                }
                IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder(this.request.index()).settings(actualIndexSettings).setRoutingNumShards(routingNumShards);
                for (int shardId = 0; shardId < tmpImd.getNumberOfShards(); ++shardId) {
                    indexMetaDataBuilder.primaryTerm(shardId, tmpImd.primaryTerm(shardId));
                }
                for (MappingMetaData mappingMd : mappingsMetaData.values()) {
                    indexMetaDataBuilder.putMapping(mappingMd);
                }
                for (AliasMetaData aliasMetaData : templatesAliases.values()) {
                    indexMetaDataBuilder.putAlias(aliasMetaData);
                }
                for (Alias alias : this.request.aliases()) {
                    AliasMetaData aliasMetaData = AliasMetaData.builder(alias.name()).filter(alias.filter()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).writeIndex(alias.writeIndex()).build();
                    indexMetaDataBuilder.putAlias(aliasMetaData);
                }
                indexMetaDataBuilder.state(IndexMetaData.State.OPEN);
                try {
                    indexMetaData = indexMetaDataBuilder.build();
                }
                catch (Exception e) {
                    removalExtraInfo = "failed to build index metadata";
                    throw e;
                }
                ((IndexService)indexService).getIndexEventListener().beforeIndexAddedToCluster(indexMetaData.getIndex(), indexMetaData.getSettings());
                MetaData newMetaData = MetaData.builder(currentState.metaData()).put(indexMetaData, false).build();
                this.logger.info("[{}] creating index, cause [{}], templates {}, shards [{}]/[{}], mappings {}", (Object)this.request.index(), (Object)this.request.cause(), templateNames, (Object)indexMetaData.getNumberOfShards(), (Object)indexMetaData.getNumberOfReplicas(), mappings.keySet());
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                if (!this.request.blocks().isEmpty()) {
                    for (ClusterBlock block : this.request.blocks()) {
                        blocks.addIndexBlock(this.request.index(), block);
                    }
                }
                blocks.updateBlocks(indexMetaData);
                ClusterState updatedState = ClusterState.builder(currentState).blocks(blocks).metaData(newMetaData).build();
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable()).addAsNew(updatedState.metaData().index(this.request.index()));
                updatedState = this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build(), "index [" + this.request.index() + "] created");
                removalExtraInfo = "cleaning up after validating index on master";
                removalReason = IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED;
                ClusterState clusterState = updatedState;
                if (createdIndex != null) {
                    this.indicesService.removeIndex(createdIndex, removalReason, removalExtraInfo);
                }
                return clusterState;
            }
            catch (Throwable throwable) {
                if (createdIndex != null) {
                    this.indicesService.removeIndex(createdIndex, removalReason, removalExtraInfo);
                }
                throw throwable;
            }
        }

        static int getNumberOfShards(Settings.Builder indexSettingsBuilder) {
            assert (Version.CURRENT.major == 7);
            Version indexVersionCreated = Version.fromId(Integer.parseInt(indexSettingsBuilder.get(IndexMetaData.SETTING_INDEX_VERSION_CREATED.getKey())));
            int numberOfShards = indexVersionCreated.before(Version.V_7_0_0) ? 5 : 1;
            return numberOfShards;
        }

        protected void checkShardLimit(Settings settings, ClusterState clusterState) {
            MetaDataCreateIndexService.checkShardLimit(settings, clusterState);
        }

        @Override
        public void onFailure(String source, Exception e) {
            if (e instanceof ResourceAlreadyExistsException) {
                this.logger.trace(() -> new ParameterizedMessage("[{}] failed to create", (Object)this.request.index()), (Throwable)e);
            } else {
                this.logger.debug(() -> new ParameterizedMessage("[{}] failed to create", (Object)this.request.index()), (Throwable)e);
            }
            super.onFailure(source, e);
        }
    }

    static interface IndexValidator {
        public void validate(CreateIndexClusterStateUpdateRequest var1, ClusterState var2);
    }
}

