/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class InputStreamOrByteBufferAdapter
implements AutoCloseable {
    private static final int INITIAL_BUFFER_CHUNK_SIZE = 16384;
    private static final int SUBSEQUENT_BUFFER_CHUNK_SIZE = 4096;
    private InputStream inputStream;
    private ByteBuffer byteBuffer;
    public byte[] buf;
    public int curr = 0;
    public int used = 0;

    public InputStreamOrByteBufferAdapter(InputStream inputStream) {
        this.inputStream = inputStream;
        this.buf = new byte[16384];
    }

    public InputStreamOrByteBufferAdapter(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.buf = byteBuffer.array();
        } else {
            this.byteBuffer = byteBuffer;
            this.buf = new byte[16384];
        }
    }

    private int read(int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.inputStream != null) {
            return this.inputStream.read(this.buf, off, len);
        }
        int bytesRemainingInBuf = this.byteBuffer != null ? this.byteBuffer.remaining() : this.buf.length - off;
        int bytesRead = Math.max(0, Math.min(len, bytesRemainingInBuf));
        if (bytesRead == 0) {
            return -1;
        }
        if (this.byteBuffer != null) {
            int byteBufPositionBefore = this.byteBuffer.position();
            try {
                this.byteBuffer.get(this.buf, off, bytesRead);
            }
            catch (BufferUnderflowException e) {
                throw new IOException("Buffer underflow", e);
            }
            return this.byteBuffer.position() - byteBufPositionBefore;
        }
        return bytesRead;
    }

    public void readInitialChunk() throws IOException {
        int bytesRead;
        while (this.used < 16384 && (bytesRead = this.read(this.used, 16384 - this.used)) != -1) {
            this.used += bytesRead;
        }
    }

    private void readMore(int bytesRequired) throws IOException {
        int bytesRead;
        int extraBytesNeeded = bytesRequired - (this.used - this.curr);
        int bytesToRequest = Math.max(extraBytesNeeded, 4096);
        int maxNewUsed = this.used + bytesToRequest;
        if (maxNewUsed > this.buf.length) {
            int newBufLen = this.buf.length;
            while (newBufLen < maxNewUsed) {
                if ((newBufLen <<= 1) > 0) continue;
                throw new IOException("Classfile is bigger than 2GB, cannot read it");
            }
            this.buf = Arrays.copyOf(this.buf, newBufLen);
        }
        for (int extraBytesStillNotRead = extraBytesNeeded; extraBytesStillNotRead > 0; extraBytesStillNotRead -= bytesRead) {
            bytesRead = this.read(this.used, bytesToRequest);
            if (bytesRead > 0) {
                this.used += bytesRead;
                bytesToRequest -= bytesRead;
                continue;
            }
            throw new IOException("Premature EOF while reading classfile");
        }
    }

    public int readUnsignedByte() throws IOException {
        if (this.curr > this.used - 1) {
            this.readMore(1);
        }
        return this.buf[this.curr++] & 0xFF;
    }

    public int readUnsignedByte(int offset) {
        int bytesToRead = Math.max(0, offset + 1 - this.used);
        if (bytesToRead > 0) {
            throw new IllegalArgumentException("Can only read from absolute offsets before the current location in the file");
        }
        return this.buf[offset] & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        if (this.curr > this.used - 2) {
            this.readMore(2);
        }
        int val = (this.buf[this.curr] & 0xFF) << 8 | this.buf[this.curr + 1] & 0xFF;
        this.curr += 2;
        return val;
    }

    public int readUnsignedShort(int offset) {
        int bytesToRead = Math.max(0, offset + 1 - this.used);
        if (bytesToRead > 0) {
            throw new IllegalArgumentException("Can only read from absolute offsets before the current location in the file");
        }
        return (this.buf[offset] & 0xFF) << 8 | this.buf[offset + 1] & 0xFF;
    }

    public int readInt() throws IOException {
        if (this.curr > this.used - 4) {
            this.readMore(4);
        }
        int val = (this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF;
        this.curr += 4;
        return val;
    }

    public int readInt(int offset) {
        int bytesToRead = Math.max(0, offset + 4 - this.used);
        if (bytesToRead > 0) {
            throw new IllegalArgumentException("Can only read from absolute offsets before the current location in the file");
        }
        return (this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF;
    }

    public long readLong() throws IOException {
        if (this.curr > this.used - 8) {
            this.readMore(8);
        }
        long val = (long)((this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF) << 32 | (long)((this.buf[this.curr + 4] & 0xFF) << 24) | (long)((this.buf[this.curr + 5] & 0xFF) << 16) | (long)((this.buf[this.curr + 6] & 0xFF) << 8) | (long)(this.buf[this.curr + 7] & 0xFF);
        this.curr += 8;
        return val;
    }

    public long readLong(int offset) {
        int bytesToRead = Math.max(0, offset + 8 - this.used);
        if (bytesToRead > 0) {
            throw new IllegalArgumentException("Can only read from absolute offsets before the current location in the file");
        }
        return (long)((this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF) << 32 | (long)((this.buf[offset + 4] & 0xFF) << 24) | (long)((this.buf[offset + 5] & 0xFF) << 16) | (long)((this.buf[offset + 6] & 0xFF) << 8) | (long)(this.buf[offset + 7] & 0xFF);
    }

    public void skip(int bytesToSkip) throws IOException {
        if (this.curr > this.used - bytesToSkip) {
            this.readMore(bytesToSkip);
        }
        this.curr += bytesToSkip;
    }

    public String readString(int strStart, boolean replaceSlashWithDot, boolean stripLSemicolon) throws IOException {
        int c;
        int byteIdx;
        int utfStart = strStart + 2;
        int utfLen = this.readUnsignedShort(strStart);
        int bufferUnderrunBytes = Math.max(0, utfStart + utfLen - this.used);
        if (bufferUnderrunBytes > 0) {
            this.readMore(bufferUnderrunBytes);
        }
        char[] chars = new char[utfLen];
        int charIdx = 0;
        for (byteIdx = 0; byteIdx < utfLen && (c = this.buf[utfStart + byteIdx] & 0xFF) <= 127; ++byteIdx) {
            chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
        }
        block6: while (byteIdx < utfLen) {
            c = this.buf[utfStart + byteIdx] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++byteIdx;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((byteIdx += 2) > utfLen) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[utfStart + byteIdx - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    int c4 = (c & 0x1F) << 6 | c2 & 0x3F;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
                case 14: {
                    if ((byteIdx += 3) > utfLen) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[utfStart + byteIdx - 2];
                    byte c3 = this.buf[utfStart + byteIdx - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    int c4 = (c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
            }
            throw new RuntimeException("Bad modified UTF8");
        }
        if (charIdx == utfLen && !stripLSemicolon) {
            return new String(chars);
        }
        if (stripLSemicolon) {
            if (charIdx < 2 || chars[0] != 'L' || chars[charIdx - 1] != ';') {
                throw new RuntimeException("Expected string to start with 'L' and end with ';', got \"" + new String(chars) + "\"");
            }
            return new String(chars, 1, charIdx - 2);
        }
        return new String(chars, 0, charIdx);
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = null;
        }
        this.byteBuffer = null;
        this.buf = null;
    }
}

