/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;

public enum ContentTypes implements Iterable<String>
{
    ANY("*/*"),
    TEXT("text/plain"),
    JSON("application/json", "application/javascript", "text/javascript"),
    XML("application/xml", "text/xml", "application/xhtml+xml", "application/atom+xml"),
    HTML("text/html"),
    URLENC("application/x-www-form-urlencoded"),
    BINARY("application/octet-stream"),
    MULTIPART_FORMDATA("multipart/form-data"),
    MULTIPART_MIXED("multipart/mixed");

    private final List<String> values;

    private ContentTypes(String ... values) {
        this.values = Collections.unmodifiableList(Arrays.asList(values));
    }

    public static ContentTypes fromValue(String value) {
        for (ContentTypes type : ContentTypes.values()) {
            if (!type.values.contains(value)) continue;
            return type;
        }
        return null;
    }

    public String getAt(int index) {
        return this.values.get(index);
    }

    @Override
    public Iterator<String> iterator() {
        return this.values.iterator();
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        this.values.forEach(action);
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.values.spliterator();
    }
}

