/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.geonames.services;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.SchedulerService;
import org.apache.unomi.geonames.services.GeonameEntry;
import org.apache.unomi.geonames.services.GeonamesService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeonamesServiceImpl
implements GeonamesService {
    public static final String GEOCODING_MAX_DISTANCE = "100km";
    private static final Logger logger = LoggerFactory.getLogger((String)GeonamesServiceImpl.class.getName());
    private DefinitionsService definitionsService;
    private PersistenceService persistenceService;
    private SchedulerService schedulerService;
    private String pathToGeonamesDatabase;
    private Boolean forceDbImport;
    private Integer refreshDbInterval = 5000;

    public void setForceDbImport(Boolean forceDbImport) {
        this.forceDbImport = forceDbImport;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setPathToGeonamesDatabase(String pathToGeonamesDatabase) {
        this.pathToGeonamesDatabase = pathToGeonamesDatabase;
    }

    public void setRefreshDbInterval(Integer refreshDbInterval) {
        this.refreshDbInterval = refreshDbInterval;
    }

    public void start() {
        this.importDatabase();
    }

    public void stop() {
    }

    @Override
    public void importDatabase() {
        if (!this.persistenceService.createIndex("geonameEntry")) {
            if (this.forceDbImport.booleanValue()) {
                this.persistenceService.removeIndex("geonameEntry");
                this.persistenceService.createIndex("geonameEntry");
                logger.info("Geonames index removed and recreated");
            } else if (this.persistenceService.getAllItemsCount("geonameEntry") > 0L) {
                return;
            }
        } else {
            logger.info("Geonames index created");
        }
        if (this.pathToGeonamesDatabase == null) {
            logger.info("No geonames DB provided");
            return;
        }
        final File f = new File(this.pathToGeonamesDatabase);
        if (f.exists()) {
            this.schedulerService.getScheduleExecutorService().schedule(new TimerTask(){

                @Override
                public void run() {
                    GeonamesServiceImpl.this.importGeoNameDatabase(f);
                }
            }, (long)this.refreshDbInterval.intValue(), TimeUnit.MILLISECONDS);
        }
    }

    private void importGeoNameDatabase(final File f) {
        Map typeMappings = this.persistenceService.getPropertiesMapping("geonameEntry");
        if (typeMappings == null || typeMappings.size() == 0) {
            logger.warn("Type mappings for type {} are not yet installed, delaying import until they are ready!", (Object)"geonameEntry");
            this.schedulerService.getScheduleExecutorService().schedule(new TimerTask(){

                @Override
                public void run() {
                    GeonamesServiceImpl.this.importGeoNameDatabase(f);
                }
            }, (long)this.refreshDbInterval.intValue(), TimeUnit.MILLISECONDS);
            return;
        }
        try {
            String line;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(f));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            long fileSize = zipEntry.getSize();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)zipInputStream, "UTF-8"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            logger.info("Starting to import geonames database from file {}...", (Object)f);
            long charCount = 0L;
            double lastCompletionPourcentage = 0.0;
            long lastCharCount = 0L;
            long importStartTime = System.currentTimeMillis();
            while ((line = reader.readLine()) != null) {
                String[] values = line.split("\t");
                if (FEATURES_CLASSES.contains(values[6])) {
                    GeonameEntry geonameEntry = new GeonameEntry(values[0], values[1], values[2], StringUtils.isEmpty((CharSequence)values[4]) ? null : Double.valueOf(Double.parseDouble(values[4])), StringUtils.isEmpty((CharSequence)values[5]) ? null : Double.valueOf(Double.parseDouble(values[5])), values[6], values[7], values[8], Arrays.asList(values[9].split(",")), values[10], values[11], values[12], values[13], StringUtils.isEmpty((CharSequence)values[14]) ? null : Long.valueOf(Long.parseLong(values[14])), StringUtils.isEmpty((CharSequence)values[15]) ? null : Integer.valueOf(Integer.parseInt(values[15])), values[16], values[17], sdf.parse(values[18]));
                    this.persistenceService.save((Item)geonameEntry, true);
                }
                charCount += (long)line.length();
                if (fileSize > 0L) {
                    double completionPourcentage = 100.0 * (double)charCount / (double)fileSize;
                    if (!(completionPourcentage - lastCompletionPourcentage > 1.0)) continue;
                    int roundedPourcentage = (int)completionPourcentage;
                    logger.info("{}% imported from file {}", (Object)roundedPourcentage, (Object)f);
                    lastCompletionPourcentage = completionPourcentage;
                    continue;
                }
                if (charCount - lastCharCount <= 0x6400000L) continue;
                logger.info("{}MB imported from file {}", (Object)(charCount / 0x100000L), (Object)f);
                lastCharCount = charCount;
            }
            long totalTimeMillis = System.currentTimeMillis() - importStartTime;
            logger.info("{} characters from Geonames database file {} imported in {}ms. Speed={}MB/s", new Object[]{charCount, f, totalTimeMillis, charCount / 0x100000L / (totalTimeMillis / 1000L)});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<GeonameEntry> getHierarchy(String itemId) {
        return this.getHierarchy((GeonameEntry)this.persistenceService.load(itemId, GeonameEntry.class));
    }

    public List<GeonameEntry> getHierarchy(GeonameEntry entry) {
        ArrayList<GeonameEntry> entries = new ArrayList<GeonameEntry>();
        entries.add(entry);
        ArrayList<Condition> l = new ArrayList<Condition>();
        Condition andCondition = new Condition();
        andCondition.setConditionType(this.definitionsService.getConditionType("booleanCondition"));
        andCondition.setParameter("operator", (Object)"and");
        andCondition.setParameter("subConditions", l);
        Condition featureCodeCondition = new Condition();
        featureCodeCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
        featureCodeCondition.setParameter("propertyName", (Object)"featureCode");
        featureCodeCondition.setParameter("comparisonOperator", (Object)"in");
        l.add(featureCodeCondition);
        PartialList<GeonameEntry> country = this.buildHierarchy(andCondition, featureCodeCondition, "countryCode", entry.getCountryCode(), COUNTRY_FEATURE_CODES, 0, 1);
        if (!StringUtils.isEmpty((CharSequence)entry.getAdmin1Code())) {
            PartialList<GeonameEntry> adm2;
            PartialList<GeonameEntry> adm1 = this.buildHierarchy(andCondition, featureCodeCondition, "admin1Code", entry.getAdmin1Code(), ADM1_FEATURE_CODES, 0, 1);
            if (!StringUtils.isEmpty((CharSequence)entry.getAdmin2Code()) && !(adm2 = this.buildHierarchy(andCondition, featureCodeCondition, "admin2Code", entry.getAdmin2Code(), ADM2_FEATURE_CODES, 0, 1)).getList().isEmpty()) {
                entries.add((GeonameEntry)((Object)adm2.get(0)));
            }
            if (!adm1.getList().isEmpty()) {
                entries.add((GeonameEntry)((Object)adm1.get(0)));
            }
        }
        if (!country.getList().isEmpty()) {
            entries.add((GeonameEntry)((Object)country.get(0)));
        }
        return entries;
    }

    private PartialList<GeonameEntry> buildHierarchy(Condition andCondition, Condition featureCodeCondition, String featurePropertyName, String featureValue, List<String> featuresCode, int offset, int size) {
        featureCodeCondition.setParameter("propertyValues", featuresCode);
        List l = (List)andCondition.getParameter("subConditions");
        Condition condition = this.getPropertyCondition(featurePropertyName, "propertyValue", featureValue, "equals");
        l.add(condition);
        return this.persistenceService.query(andCondition, null, GeonameEntry.class, offset, size);
    }

    @Override
    public List<GeonameEntry> reverseGeoCode(String lat, String lon) {
        ArrayList<Condition> l = new ArrayList<Condition>();
        Condition andCondition = new Condition();
        andCondition.setConditionType(this.definitionsService.getConditionType("booleanCondition"));
        andCondition.setParameter("operator", (Object)"and");
        andCondition.setParameter("subConditions", l);
        Condition geoLocation = new Condition();
        geoLocation.setConditionType(this.definitionsService.getConditionType("geoLocationByPointSessionCondition"));
        geoLocation.setParameter("type", (Object)"circle");
        geoLocation.setParameter("circleLatitude", (Object)Double.parseDouble(lat));
        geoLocation.setParameter("circleLongitude", (Object)Double.parseDouble(lon));
        geoLocation.setParameter("distance", (Object)GEOCODING_MAX_DISTANCE);
        l.add(geoLocation);
        l.add(this.getPropertyCondition("featureCode", "propertyValues", CITIES_FEATURE_CODES, "in"));
        PartialList list = this.persistenceService.query(andCondition, "geo:location:" + lat + ":" + lon, GeonameEntry.class, 0, 1);
        if (!list.getList().isEmpty()) {
            return this.getHierarchy((GeonameEntry)((Object)list.getList().get(0)));
        }
        return Collections.emptyList();
    }

    @Override
    public PartialList<GeonameEntry> getChildrenEntries(List<String> items, int offset, int size) {
        Condition andCondition = this.getItemsInChildrenQuery(items, CITIES_FEATURE_CODES);
        Condition featureCodeCondition = (Condition)((List)andCondition.getParameter("subConditions")).get(0);
        int level = items.size();
        featureCodeCondition.setParameter("propertyValues", ORDERED_FEATURES.get(level));
        PartialList r = this.persistenceService.query(andCondition, null, GeonameEntry.class, offset, size);
        while (r.size() == 0 && level < ORDERED_FEATURES.size() - 1) {
            featureCodeCondition.setParameter("propertyValues", ORDERED_FEATURES.get(++level));
            r = this.persistenceService.query(andCondition, null, GeonameEntry.class, offset, size);
        }
        return r;
    }

    @Override
    public PartialList<GeonameEntry> getChildrenCities(List<String> items, int offset, int size) {
        return this.persistenceService.query(this.getItemsInChildrenQuery(items, CITIES_FEATURE_CODES), null, GeonameEntry.class, offset, size);
    }

    private Condition getItemsInChildrenQuery(List<String> items, List<String> featureCodes) {
        ArrayList<Condition> l = new ArrayList<Condition>();
        Condition andCondition = new Condition();
        andCondition.setConditionType(this.definitionsService.getConditionType("booleanCondition"));
        andCondition.setParameter("operator", (Object)"and");
        andCondition.setParameter("subConditions", l);
        Condition featureCodeCondition = this.getPropertyCondition("featureCode", "propertyValues", featureCodes, "in");
        l.add(featureCodeCondition);
        if (items.size() > 0) {
            l.add(this.getPropertyCondition("countryCode", "propertyValue", items.get(0), "equals"));
        }
        if (items.size() > 1) {
            l.add(this.getPropertyCondition("admin1Code", "propertyValue", items.get(1), "equals"));
        }
        if (items.size() > 2) {
            l.add(this.getPropertyCondition("admin2Code", "propertyValue", items.get(2), "equals"));
        }
        return andCondition;
    }

    @Override
    public List<GeonameEntry> getCapitalEntries(String itemId) {
        List<String> featureCodes;
        GeonameEntry entry = (GeonameEntry)this.persistenceService.load(itemId, GeonameEntry.class);
        ArrayList<Condition> l = new ArrayList<Condition>();
        Condition andCondition = new Condition();
        andCondition.setConditionType(this.definitionsService.getConditionType("booleanCondition"));
        andCondition.setParameter("operator", (Object)"and");
        andCondition.setParameter("subConditions", l);
        l.add(this.getPropertyCondition("countryCode", "propertyValue", entry.getCountryCode(), "equals"));
        if (COUNTRY_FEATURE_CODES.contains(entry.getFeatureCode())) {
            featureCodes = Arrays.asList("PPLC");
        } else if (ADM1_FEATURE_CODES.contains(entry.getFeatureCode())) {
            featureCodes = Arrays.asList("PPLA", "PPLC");
            l.add(this.getPropertyCondition("admin1Code", "propertyValue", entry.getAdmin1Code(), "equals"));
        } else if (ADM2_FEATURE_CODES.contains(entry.getFeatureCode())) {
            featureCodes = Arrays.asList("PPLA2", "PPLA", "PPLC");
            l.add(this.getPropertyCondition("admin1Code", "propertyValue", entry.getAdmin1Code(), "equals"));
            l.add(this.getPropertyCondition("admin2Code", "propertyValue", entry.getAdmin2Code(), "equals"));
        } else {
            return Collections.emptyList();
        }
        Condition featureCodeCondition = new Condition();
        featureCodeCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
        featureCodeCondition.setParameter("propertyName", (Object)"featureCode");
        featureCodeCondition.setParameter("propertyValues", featureCodes);
        featureCodeCondition.setParameter("comparisonOperator", (Object)"in");
        l.add(featureCodeCondition);
        List entries = this.persistenceService.query(andCondition, null, GeonameEntry.class);
        if (entries.size() == 0) {
            featureCodeCondition.setParameter("propertyValues", (Object)CITIES_FEATURE_CODES);
            entries = this.persistenceService.query(andCondition, "population:desc", GeonameEntry.class, 0, 1).getList();
        }
        if (entries.size() > 0) {
            return this.getHierarchy((GeonameEntry)((Object)entries.get(0)));
        }
        return Collections.emptyList();
    }

    private Condition getPropertyCondition(String name, String propertyValueField, Object value, String operator) {
        Condition condition = new Condition();
        condition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
        condition.setParameter("propertyName", (Object)name);
        condition.setParameter(propertyValueField, value);
        condition.setParameter("comparisonOperator", (Object)operator);
        return condition;
    }
}

