/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.route;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.router.api.ImportConfiguration;
import org.apache.unomi.router.api.exceptions.BadProfileDataFormatException;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.apache.unomi.router.core.processor.LineSplitFailureHandler;
import org.apache.unomi.router.core.processor.LineSplitProcessor;
import org.apache.unomi.router.core.route.RouterAbstractRouteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileImportFromSourceRouteBuilder
extends RouterAbstractRouteBuilder {
    private static final Logger logger = LoggerFactory.getLogger((String)ProfileImportFromSourceRouteBuilder.class.getName());
    private List<ImportConfiguration> importConfigurationList;
    private ImportExportConfigurationService<ImportConfiguration> importConfigurationService;

    public ProfileImportFromSourceRouteBuilder(Map<String, String> kafkaProps, String configType) {
        super(kafkaProps, configType);
    }

    public void configure() throws Exception {
        logger.info("Configure Recurrent Route 'From Source'");
        if (this.importConfigurationList == null) {
            this.importConfigurationList = this.importConfigurationService.getAll();
        }
        OnExceptionDefinition prDefErr = ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(BadProfileDataFormatException.class).log(LoggingLevel.ERROR, "Error processing record ${exchangeProperty.CamelSplitIndex}++ !")).handled(true).process((Processor)new LineSplitFailureHandler())).onException(Exception.class).log(LoggingLevel.ERROR, "Failed to process file.")).handled(true);
        if ("kafka".equals(this.configType)) {
            prDefErr.to((Endpoint)((KafkaEndpoint)this.getEndpointURI("from", "direct:depositImportBuffer")));
        } else {
            prDefErr.to((String)this.getEndpointURI("from", "direct:depositImportBuffer"));
        }
        for (final ImportConfiguration importConfiguration : this.importConfigurationList) {
            if (!"recurrent".equals(importConfiguration.getConfigType()) || importConfiguration.getProperties() == null || importConfiguration.getProperties().size() <= 0) continue;
            LineSplitProcessor lineSplitProcessor = new LineSplitProcessor();
            lineSplitProcessor.setFieldsMapping((Map)importConfiguration.getProperties().get("mapping"));
            lineSplitProcessor.setOverwriteExistingProfiles(importConfiguration.isOverwriteExistingProfiles());
            lineSplitProcessor.setPropertiesToOverwrite(importConfiguration.getPropertiesToOverwrite());
            lineSplitProcessor.setMergingProperty(importConfiguration.getMergingProperty());
            lineSplitProcessor.setColumnSeparator(importConfiguration.getColumnSeparator());
            lineSplitProcessor.setHasHeader(importConfiguration.isHasHeader());
            lineSplitProcessor.setHasDeleteColumn(importConfiguration.isHasDeleteColumn());
            lineSplitProcessor.setMultiValueDelimiter(importConfiguration.getMultiValueDelimiter());
            lineSplitProcessor.setMultiValueSeparator(importConfiguration.getMultiValueSeparator());
            lineSplitProcessor.setProfilePropertyTypes(this.profileService.getTargetPropertyTypes("profiles"));
            String endpoint = (String)importConfiguration.getProperties().get("source");
            endpoint = endpoint + "&moveFailed=.error";
            if (StringUtils.isNotBlank((CharSequence)endpoint) && this.allowedEndpoints.contains(endpoint.substring(0, endpoint.indexOf(58)))) {
                ProcessorDefinition prDef = ((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((OnCompletionDefinition)this.from(endpoint).routeId(importConfiguration.getItemId()).autoStartup(importConfiguration.isActive()).shutdownRunningTask(ShutdownRunningTask.CompleteAllTasks).onCompletion().log(LoggingLevel.DEBUG, "ROUTE [" + importConfiguration.getItemId() + "] is now complete [" + new Date().toString() + "]")).end().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        importConfiguration.setStatus("RUNNING");
                        ProfileImportFromSourceRouteBuilder.this.importConfigurationService.save((Object)importConfiguration, false);
                    }
                }).split((Expression)this.bodyAs(String.class).tokenize(importConfiguration.getLineSeparator())).log(LoggingLevel.DEBUG, "Splitted into ${exchangeProperty.CamelSplitSize} records")).setHeader("configType", (Expression)this.constant(this.configType))).process((Processor)lineSplitProcessor)).log(LoggingLevel.DEBUG, "Split IDX ${exchangeProperty.CamelSplitIndex} record")).marshal((DataFormat)this.jacksonDataFormat)).convertBodyTo(String.class);
                if ("kafka".equals(this.configType)) {
                    prDef.to((Endpoint)((KafkaEndpoint)this.getEndpointURI("from", "direct:depositImportBuffer")));
                    continue;
                }
                prDef.to((String)this.getEndpointURI("from", "direct:depositImportBuffer"));
                continue;
            }
            logger.error("Endpoint scheme {} is not allowed, route {} will be skipped.", (Object)endpoint.substring(0, endpoint.indexOf(58)), (Object)importConfiguration.getItemId());
        }
    }

    public void setImportConfigurationList(List<ImportConfiguration> importConfigurationList) {
        this.importConfigurationList = importConfigurationList;
    }

    public void setImportConfigurationService(ImportExportConfigurationService<ImportConfiguration> importConfigurationService) {
        this.importConfigurationService = importConfigurationService;
    }
}

