/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.geonames.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.PathSegment;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.geonames.services.GeonameEntry;
import org.apache.unomi.geonames.services.GeonamesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json;charset=UTF-8"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
public class GeonamesEndPoint {
    private static final Logger logger = LoggerFactory.getLogger((String)GeonamesEndPoint.class.getName());
    private GeonamesService geonamesService;

    public GeonamesEndPoint() {
        logger.info("Initializing geonames service endpoint...");
    }

    @WebMethod(exclude=true)
    public void setGeonamesService(GeonamesService geonamesService) {
        this.geonamesService = geonamesService;
    }

    @GET
    @Path(value="/reverseGeoCode/{latlon}")
    public List<GeonameEntry> reverseGeoCode(@PathParam(value="latlon") String latlon, @HeaderParam(value="Accept-Language") String language) {
        String[] s = latlon.split(",");
        List entries = this.geonamesService.reverseGeoCode(s[0], s[1]);
        this.translate(entries, new Locale(language));
        return entries;
    }

    @GET
    @Path(value="/entries/{items:.*}")
    public PartialList<GeonameEntry> getChildrenEntries(@PathParam(value="items") List<PathSegment> items, @HeaderParam(value="Accept-Language") String language) {
        ArrayList<String> l = new ArrayList<String>();
        for (PathSegment item : items) {
            l.add(item.getPath());
        }
        PartialList list = this.geonamesService.getChildrenEntries(l, 0, 999);
        this.translate(list.getList(), new Locale(language));
        return list;
    }

    @GET
    @Path(value="/cities/{items:.*}")
    public PartialList<GeonameEntry> getChildrenCities(@PathParam(value="items") List<PathSegment> items, @HeaderParam(value="Accept-Language") String language) {
        ArrayList<String> l = new ArrayList<String>();
        for (PathSegment item : items) {
            l.add(item.getPath());
        }
        PartialList list = this.geonamesService.getChildrenCities(l, 0, 999);
        this.translate(list.getList(), new Locale(language));
        return list;
    }

    @GET
    @Path(value="/hierarchy/{id}")
    public List<GeonameEntry> getHierarchy(@PathParam(value="id") String id, @HeaderParam(value="Accept-Language") String language) {
        List list = this.geonamesService.getHierarchy(id);
        this.translate(list, new Locale(language));
        return list;
    }

    @GET
    @Path(value="/capitals/{id}")
    public List<GeonameEntry> getCapitalEntries(@PathParam(value="id") String id, @HeaderParam(value="Accept-Language") String language) {
        List list = this.geonamesService.getCapitalEntries(id);
        this.translate(list, new Locale(language));
        return list;
    }

    private void translate(List<GeonameEntry> l, Locale locale) {
        for (GeonameEntry entry : l) {
            String name;
            if (!GeonamesService.COUNTRY_FEATURE_CODES.contains(entry.getFeatureCode()) || StringUtils.isEmpty((String)(name = new Locale("", entry.getCountryCode()).getDisplayCountry(locale))) || name.equals(entry.getCountryCode())) continue;
            entry.setName(name);
        }
    }
}

