/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.sorts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.unomi.api.PersonalizationStrategy;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.PersonalizationService;
import org.apache.unomi.api.services.ProfileService;

public class ScorePersonalizationStrategy
implements PersonalizationStrategy {
    private ProfileService profileService;

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public List<String> personalizeList(Profile profile, Session session, PersonalizationService.PersonalizationRequest personalizationRequest) {
        ArrayList<String> sortedContent = new ArrayList<String>();
        final HashMap<String, Integer> t = new HashMap<String, Integer>();
        Integer threshold = (Integer)personalizationRequest.getStrategyOptions().get("threshold");
        if (threshold == null) {
            threshold = 1;
        }
        for (PersonalizationService.PersonalizedContent personalizedContent : personalizationRequest.getContents()) {
            String scoringPlanList;
            int score = 0;
            String interestList = personalizedContent.getProperties() != null ? personalizedContent.getProperties().get("interests") : null;
            if (interestList != null) {
                Map interestValues = (Map)profile.getProperties().get("interests");
                for (String interest : interestList.split(" ")) {
                    if (interestValues.get(interest) == null) continue;
                    score += ((Integer)interestValues.get(interest)).intValue();
                }
            }
            if ((scoringPlanList = (String)(personalizedContent.getProperties() != null ? personalizedContent.getProperties().get("scoringPlans") : null)) != null) {
                Map scoreValues = profile.getScores();
                for (String scoringPlan : scoringPlanList.split(" ")) {
                    if (scoreValues.get(scoringPlan) != null) {
                        score += ((Integer)scoreValues.get(scoringPlan)).intValue();
                        continue;
                    }
                    ++score;
                }
            }
            if (personalizedContent.getFilters() != null) {
                for (PersonalizationService.Filter filter : personalizedContent.getFilters()) {
                    Condition condition = filter.getCondition();
                    if (condition == null || condition.getConditionTypeId() == null || !this.profileService.matchCondition(condition, profile, session)) continue;
                    if (filter.getProperties().get("score") != null) {
                        score += ((Integer)filter.getProperties().get("score")).intValue();
                        continue;
                    }
                    ++score;
                }
            }
            if (score < threshold) continue;
            t.put(personalizedContent.getId(), score);
            sortedContent.add(personalizedContent.getId());
        }
        Collections.sort(sortedContent, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return (Integer)t.get(o2) - (Integer)t.get(o1);
            }
        });
        String fallback = (String)personalizationRequest.getStrategyOptions().get("fallback");
        if (fallback != null && !sortedContent.contains(fallback)) {
            sortedContent.add(fallback);
        }
        return sortedContent;
    }
}

