/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.ast.AnonymousObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.ClassOfExpression;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.ConvertTypeOptions;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.InstanceInitializer;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LocalClassHelper {
    private static final ConvertTypeOptions OUTER_TYPE_CONVERT_OPTIONS = new ConvertTypeOptions(false, false);

    public static void replaceClosureMembers(DecompilerContext context, AnonymousObjectCreationExpression node) {
        LocalClassHelper.replaceClosureMembers(context, node.getTypeDeclaration(), Collections.singletonList(node));
    }

    public static void replaceClosureMembers(DecompilerContext context, TypeDeclaration declaration, List<? extends ObjectCreationExpression> instantiations) {
        VerifyArgument.notNull((Object)((Object)context), (String)"context");
        VerifyArgument.notNull((Object)declaration, (String)"declaration");
        VerifyArgument.notNull(instantiations, (String)"instantiations");
        HashMap<String, Expression> initializers = new HashMap<String, Expression>();
        HashMap<String, Expression> replacements = new HashMap<String, Expression>();
        ArrayList<AstNode> nodesToRemove = new ArrayList<AstNode>();
        ArrayList<ParameterDefinition> parametersToRemove = new ArrayList<ParameterDefinition>();
        List<Expression> originalArguments = instantiations.isEmpty() ? Collections.emptyList() : new ArrayList<Expression>(instantiations.get(0).getArguments());
        new ClosureRewriterPhaseOneVisitor(context, originalArguments, replacements, initializers, parametersToRemove, nodesToRemove).run(declaration);
        LocalClassHelper.rewriteThisReferences(context, declaration, initializers);
        new ClosureRewriterPhaseTwoVisitor(context, replacements, initializers).run(declaration);
        for (ObjectCreationExpression objectCreationExpression : instantiations) {
            for (ParameterDefinition p : parametersToRemove) {
                Expression expression = (Expression)CollectionUtilities.getOrDefault(objectCreationExpression.getArguments(), (int)p.getPosition());
                if (expression == null) continue;
                objectCreationExpression.getArguments().remove(expression);
            }
        }
        for (AstNode astNode : nodesToRemove) {
            int argumentIndex;
            if (astNode instanceof Expression && (argumentIndex = originalArguments.indexOf(astNode)) >= 0) {
                for (ObjectCreationExpression objectCreationExpression : instantiations) {
                    Expression argumentToRemove = (Expression)CollectionUtilities.getOrDefault(objectCreationExpression.getArguments(), (int)argumentIndex);
                    if (argumentToRemove == null) continue;
                    argumentToRemove.remove();
                }
            }
            astNode.remove();
        }
    }

    public static void introduceInitializerBlocks(DecompilerContext context, AstNode node) {
        VerifyArgument.notNull((Object)((Object)context), (String)"context");
        VerifyArgument.notNull((Object)node, (String)"node");
        new IntroduceInitializersVisitor(context).run(node);
    }

    private static void rewriteThisReferences(DecompilerContext context, TypeDeclaration declaration, Map<String, Expression> initializers) {
        TypeDefinition innerClass = declaration.getUserData(Keys.TYPE_DEFINITION);
        if (innerClass != null) {
            ThisReferenceReplacingVisitor thisRewriter = new ThisReferenceReplacingVisitor(context, innerClass);
            for (Expression e : initializers.values()) {
                thisRewriter.run(e);
            }
        }
    }

    private static boolean isLocalOrAnonymous(TypeDefinition type) {
        return type != null && (type.isLocalClass() || type.isAnonymous());
    }

    private static boolean hasSideEffects(Expression e) {
        return !(e instanceof IdentifierExpression) && !(e instanceof PrimitiveExpression) && !(e instanceof ThisReferenceExpression) && !(e instanceof SuperReferenceExpression) && !(e instanceof NullReferenceExpression) && !(e instanceof ClassOfExpression);
    }

    static {
        OUTER_TYPE_CONVERT_OPTIONS.setIncludeTypeArguments(false);
    }

    private static final class IntroduceInitializersVisitor
    extends ContextTrackingVisitor<Void> {
        public IntroduceInitializersVisitor(DecompilerContext context) {
            super(context);
        }

        @Override
        public Void visitSuperReferenceExpression(SuperReferenceExpression node, Void p) {
            super.visitSuperReferenceExpression(node, p);
            if (this.context.getCurrentMethod() != null && this.context.getCurrentMethod().isConstructor() && this.context.getCurrentMethod().getDeclaringType().isAnonymous() && node.getParent() instanceof InvocationExpression && node.getRole() == Roles.TARGET_EXPRESSION) {
                Statement parentStatement = (Statement)CollectionUtilities.firstOrDefault(node.getAncestors(Statement.class));
                ConstructorDeclaration constructor = (ConstructorDeclaration)CollectionUtilities.firstOrDefault(node.getAncestors(ConstructorDeclaration.class));
                if (parentStatement == null || constructor == null || constructor.getParent() == null || parentStatement.getNextStatement() == null) {
                    return null;
                }
                InstanceInitializer initializer = new InstanceInitializer();
                BlockStatement initializerBody = new BlockStatement();
                Statement current = parentStatement.getNextStatement();
                while (current != null) {
                    Statement next = current.getNextStatement();
                    current.remove();
                    initializerBody.addChild(current, current.getRole());
                    current = next;
                }
                initializer.setBody(initializerBody);
                constructor.getParent().insertChildAfter(constructor, initializer, Roles.TYPE_MEMBER);
            }
            return null;
        }
    }

    private static class ThisReferenceReplacingVisitor
    extends ContextTrackingVisitor<Void> {
        private final TypeDefinition _innerClass;

        public ThisReferenceReplacingVisitor(DecompilerContext context, TypeDefinition innerClass) {
            super(context);
            this._innerClass = innerClass;
        }

        @Override
        public Void visitMemberReferenceExpression(MemberReferenceExpression node, Void data) {
            ThisReferenceExpression thisReference;
            Expression target;
            super.visitMemberReferenceExpression(node, data);
            if (node.getTarget() instanceof ThisReferenceExpression && ((target = (thisReference = (ThisReferenceExpression)node.getTarget()).getTarget()) == null || target.isNull())) {
                AstBuilder astBuilder;
                MemberReference member = node.getUserData(Keys.MEMBER_REFERENCE);
                if (member == null && node.getParent() instanceof InvocationExpression) {
                    member = node.getParent().getUserData(Keys.MEMBER_REFERENCE);
                }
                if (member != null && MetadataHelper.isEnclosedBy(this._innerClass, member.getDeclaringType()) && (astBuilder = (AstBuilder)this.context.getUserData(Keys.AST_BUILDER)) != null) {
                    thisReference.setTarget(new TypeReferenceExpression(thisReference.getOffset(), astBuilder.convertType(member.getDeclaringType(), OUTER_TYPE_CONVERT_OPTIONS)));
                }
            }
            return null;
        }
    }

    private static final class ClosureRewriterPhaseTwoVisitor
    extends ContextTrackingVisitor<Void> {
        private final Map<String, Expression> _replacements;
        private final Map<String, Expression> _initializers;

        protected ClosureRewriterPhaseTwoVisitor(DecompilerContext context, Map<String, Expression> replacements, Map<String, Expression> initializers) {
            super(context);
            this._replacements = (Map)VerifyArgument.notNull(replacements, (String)"replacements");
            this._initializers = (Map)VerifyArgument.notNull(initializers, (String)"initializers");
        }

        @Override
        public Void visitFieldDeclaration(FieldDeclaration node, Void data) {
            Expression initializer;
            super.visitFieldDeclaration(node, data);
            FieldDefinition field = node.getUserData(Keys.FIELD_DEFINITION);
            if (field != null && !this._initializers.isEmpty() && node.getVariables().size() == 1 && node.getVariables().firstOrNullObject().getInitializer().isNull() && (initializer = this._initializers.get(field.getFullName())) != null) {
                node.getVariables().firstOrNullObject().setInitializer(initializer.clone());
            }
            return null;
        }

        @Override
        public Void visitMemberReferenceExpression(MemberReferenceExpression node, Void p) {
            Expression replacement;
            super.visitMemberReferenceExpression(node, p);
            if (node.getParent() instanceof AssignmentExpression && node.getRole() == AssignmentExpression.LEFT_ROLE) {
                return null;
            }
            MemberReference member = node.getUserData(Keys.MEMBER_REFERENCE);
            if (member instanceof FieldReference && (replacement = this._replacements.get(member.getFullName())) != null) {
                node.replaceWith(replacement.clone());
            }
            return null;
        }
    }

    private static final class ClosureRewriterPhaseOneVisitor
    extends ContextTrackingVisitor<Void> {
        private final Map<String, Expression> _replacements;
        private final List<Expression> _originalArguments;
        private final List<ParameterDefinition> _parametersToRemove;
        private final Map<String, Expression> _initializers;
        private final List<AstNode> _nodesToRemove;
        private boolean _baseConstructorCalled;

        public ClosureRewriterPhaseOneVisitor(DecompilerContext context, List<Expression> originalArguments, Map<String, Expression> replacements, Map<String, Expression> initializers, List<ParameterDefinition> parametersToRemove, List<AstNode> nodesToRemove) {
            super(context);
            this._originalArguments = (List)VerifyArgument.notNull(originalArguments, (String)"originalArguments");
            this._replacements = (Map)VerifyArgument.notNull(replacements, (String)"replacements");
            this._initializers = (Map)VerifyArgument.notNull(initializers, (String)"initializers");
            this._parametersToRemove = (List)VerifyArgument.notNull(parametersToRemove, (String)"parametersToRemove");
            this._nodesToRemove = (List)VerifyArgument.notNull(nodesToRemove, (String)"nodesToRemove");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
            boolean wasDone = this._baseConstructorCalled;
            this._baseConstructorCalled = false;
            try {
                Void void_ = (Void)super.visitConstructorDeclaration(node, p);
                return void_;
            }
            finally {
                this._baseConstructorCalled = wasDone;
            }
        }

        @Override
        protected Void visitChildren(AstNode node, Void p) {
            MethodDefinition currentMethod = this.context.getCurrentMethod();
            if (currentMethod != null && !currentMethod.isConstructor()) {
                return null;
            }
            return (Void)super.visitChildren(node, p);
        }

        @Override
        public Void visitSuperReferenceExpression(SuperReferenceExpression node, Void p) {
            super.visitSuperReferenceExpression(node, p);
            if (this.context.getCurrentMethod() != null && this.context.getCurrentMethod().isConstructor() && node.getParent() instanceof InvocationExpression) {
                this._baseConstructorCalled = true;
            }
            return null;
        }

        @Override
        public Void visitAssignmentExpression(AssignmentExpression node, Void p) {
            super.visitAssignmentExpression(node, p);
            if (this.context.getCurrentMethod() == null || !this.context.getCurrentMethod().isConstructor()) {
                return null;
            }
            Expression left = node.getLeft();
            Expression right = node.getRight();
            if (left instanceof MemberReferenceExpression) {
                if (right instanceof IdentifierExpression) {
                    Variable variable = right.getUserData(Keys.VARIABLE);
                    if (variable == null || !variable.isParameter()) {
                        return null;
                    }
                    MemberReferenceExpression memberReference = (MemberReferenceExpression)left;
                    MemberReference member = memberReference.getUserData(Keys.MEMBER_REFERENCE);
                    if (member instanceof FieldReference && memberReference.getTarget() instanceof ThisReferenceExpression) {
                        FieldDefinition resolvedField = ((FieldReference)member).resolve();
                        if (resolvedField != null && resolvedField.isSynthetic()) {
                            ParameterDefinition parameter = variable.getOriginalParameter();
                            if (parameter == null) {
                                return null;
                            }
                            int parameterIndex = parameter.getPosition();
                            if (parameter.getMethod().getParameters().size() > this._originalArguments.size()) {
                                parameterIndex -= parameter.getMethod().getParameters().size() - this._originalArguments.size();
                            }
                            if (parameterIndex >= 0 && parameterIndex < this._originalArguments.size()) {
                                Expression argument = this._originalArguments.get(parameterIndex);
                                if (argument == null) {
                                    return null;
                                }
                                this._nodesToRemove.add(argument);
                                if (argument instanceof ThisReferenceExpression) {
                                    this.markConstructorParameterForRemoval(node, parameter);
                                    return null;
                                }
                                this._parametersToRemove.add(parameter);
                                String fullName = member.getFullName();
                                if (!LocalClassHelper.hasSideEffects(argument)) {
                                    this._replacements.put(fullName, argument);
                                } else {
                                    this.context.getForcedVisibleMembers().add(resolvedField);
                                    this._initializers.put(fullName, argument);
                                }
                                if (node.getParent() instanceof ExpressionStatement) {
                                    this._nodesToRemove.add(node.getParent());
                                }
                                this.markConstructorParameterForRemoval(node, parameter);
                            }
                        } else if (this._baseConstructorCalled && resolvedField != null && this.context.getCurrentMethod().isConstructor() && (!this.context.getCurrentMethod().isSynthetic() || this.context.getSettings().getShowSyntheticMembers())) {
                            MemberReferenceExpression leftMemberReference = (MemberReferenceExpression)left;
                            MemberReference leftMember = leftMemberReference.getUserData(Keys.MEMBER_REFERENCE);
                            Variable rightVariable = right.getUserData(Keys.VARIABLE);
                            if (rightVariable.isParameter()) {
                                ParameterDefinition parameter = variable.getOriginalParameter();
                                if (parameter == null) {
                                    return null;
                                }
                                int parameterIndex = parameter.getPosition();
                                if (parameterIndex >= 0 && parameterIndex < this._originalArguments.size()) {
                                    Expression argument = this._originalArguments.get(parameterIndex);
                                    if (parameterIndex == 0 && argument instanceof ThisReferenceExpression && LocalClassHelper.isLocalOrAnonymous(this.context.getCurrentType())) {
                                        return null;
                                    }
                                    FieldDefinition resolvedTargetField = ((FieldReference)leftMember).resolve();
                                    if (resolvedTargetField != null && !resolvedTargetField.isSynthetic()) {
                                        this._parametersToRemove.add(parameter);
                                        this._initializers.put(resolvedTargetField.getFullName(), argument);
                                        if (node.getParent() instanceof ExpressionStatement) {
                                            this._nodesToRemove.add(node.getParent());
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (this._baseConstructorCalled && right instanceof MemberReferenceExpression) {
                    MemberReferenceExpression leftMemberReference = (MemberReferenceExpression)left;
                    MemberReference leftMember = leftMemberReference.getUserData(Keys.MEMBER_REFERENCE);
                    MemberReferenceExpression rightMemberReference = (MemberReferenceExpression)right;
                    MemberReference rightMember = right.getUserData(Keys.MEMBER_REFERENCE);
                    if (rightMember instanceof FieldReference && rightMemberReference.getTarget() instanceof ThisReferenceExpression) {
                        Expression initializer;
                        FieldDefinition resolvedTargetField = ((FieldReference)leftMember).resolve();
                        FieldDefinition resolvedSourceField = ((FieldReference)rightMember).resolve();
                        if (resolvedSourceField != null && resolvedTargetField != null && resolvedSourceField.isSynthetic() && !resolvedTargetField.isSynthetic() && (initializer = this._replacements.get(rightMember.getFullName())) != null) {
                            this._initializers.put(resolvedTargetField.getFullName(), initializer);
                            if (node.getParent() instanceof ExpressionStatement) {
                                this._nodesToRemove.add(node.getParent());
                            }
                        }
                    }
                }
            }
            return null;
        }

        private void markConstructorParameterForRemoval(AssignmentExpression node, ParameterDefinition parameter) {
            ConstructorDeclaration constructorDeclaration = node.getParent(ConstructorDeclaration.class);
            if (constructorDeclaration != null) {
                AstNodeCollection<ParameterDeclaration> parameters = constructorDeclaration.getParameters();
                for (ParameterDeclaration p : parameters) {
                    if (p.getUserData(Keys.PARAMETER_DEFINITION) != parameter) continue;
                    this._nodesToRemove.add(p);
                    break;
                }
            }
        }
    }
}

